@echo off
rem
rem Copyright by  The HDF Group (THG) and
rem               The Board of Trustees of the University of Illinois.
rem All rights reserved.
rem
rem This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,
rem including terms governing use, modification, and redistribution, is
rem contained in the files COPYING and Copyright.html.  COPYING can be found
rem at the root of the source code distribution tree; Copyright.html can be
rem found at the root level of an installed copy of the electronic H4H5TOOLS
rem document set and is linked from the top-level documents page.  It can
rem also be found at http://www.hdfgroup.org/H4H5TOOLS/doc/Copyright.html.
rem If you do not have access to either file, you may request a copy from
rem help@hdfgroup.org.
rem
rem
rem This batch file is used to install H4H5 libraries and tools

setlocal enabledelayedexpansion
pushd %~dp0
set instdebug=debug
set instrelease=release

set install_dir=h4h5lib

if not exist %install_dir% mkdir %install_dir%

if /i "%1" equ "nodebug" (
    set instdebug=
)
goto :main

rem This function actally copies the file over, and prints a status message
rem Expected parameters:
rem     %1 - name of file to copy
rem     %2 - path to copy to, relative to %install_dir%
:install
    
    if exist %1 (
        echo.Installing %~nx1
        if not exist %CD%\%install_dir%\%2 mkdir %CD%\%install_dir%\%2
        copy /y %1 %CD%\%install_dir%\%2\%~nx1 > nul
    )
    
    exit /b

    
rem Add the files to be copied here.
:main
    
    rem Release
    for %%a in (%instdebug% %instrelease%) do (
        if "%%a"=="release" (
            call :install lib\src\%%a\libh4toh5.lib %%a\lib
        ) else (
            call :install lib\src\%%a\libh4toh5d.lib %%a\lib
        )
        
        call :install utils\h4toh5\%%a\h4toh5.exe release\bin
        call :install utils\h5toh4\%%a\h5toh4.exe release\bin
    
        rem copy over all .h files without "private" in their name
        for %%b in (lib\src\*.h) do (
            echo.%%~nb | findstr /i "private" > nul
            if !errorlevel! neq 0 (
                call :install %%b %%a\include
            )
        )
    )
    
    popd
    endlocal & exit /b
