#!/bin/bash
#
#  Copyright by The HDF Group (THG).
#  All rights reserved.
# 
#  This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,
#  including terms governing use, modification, and redistribution, is
#  contained in the files COPYING and Copyright.html. COPYING can be
#  found at the root of the source code distribution tree; Copyright.html
#  can be found at the root level of an installed copy of the electronic
#  H4H5TOOLS document set and is linked from the top-level documents page.
#  It can also be found at
#  http://www.hdfgroup.org/H4H5TOOLS/doc/Copyright.html. If you do not have
#  access to either file, you may request a copy from help@hdfgroup.org.
#


VERIFY=/mnt/scr1/clee83/sysdep/jam/h4h5tools/misc/verify_eos2nc4/src/verify

H4TOH5DIR=/mnt/scr1/clee83/sysdep/jam/h4h5tools

SRCDIR="$H4TOH5DIR/utils/testfiles"
OUTDIR="$SRCDIR/Expected"

nerrors=0

CONVERT() {
  INFILES=""
  OUTFILES=""
  VERIFY_OPT="-p -v"
#  VERIFY_OPT="-v"

  case "$1" in
  -e)  # HDF-EOS2 file conversion
    OUTPATH=`dirname $2`

    INFILES="$2"
    OUTFILES="$3"
    ;;

  -f)  # HDF-EOS2 file conversion that should fail
    ;;

  -g)  # HDF-EOS2 file conversion can be different
    ;;
  esac

  # run the conversion and remove input files that have been copied over
  if [ "$INFILES" != "" ] ; then
    if $VERIFY $VERIFY_OPT $SRCDIR/$INFILES $OUTDIR/$OUTFILES ; then
      echo PASSED
    else
      echo FAILED
      nerrors="`expr $nerrors + 1`"
    fi
  fi
}

VERIFY_ONE() {
  CONVERT -e swath/swath_tll.hdf swath/swath_tll.h5
}

VERIFY_GRID() {
  CONVERT -e grid/generic_type_grid.hdf grid/generic_type_grid.h5
  CONVERT -e grid/grid_badname.hdf grid/grid_badname.h5
  CONVERT -e grid/grid_geo_xy.hdf grid/grid_geo_xy.h5
  CONVERT -e grid/grid_geo_yx.hdf grid/grid_geo_yx.h5
  CONVERT -e grid/grid_geo_timexy.hdf grid/grid_geo_timexy.h5
  CONVERT -e grid/grid_geo_timeyx.hdf grid/grid_geo_timeyx.h5
  CONVERT -e grid/grid_utm_xy.hdf grid/grid_utm_xy.h5
  CONVERT -e grid/grid_utm_yx.hdf grid/grid_utm_yx.h5
  CONVERT -e grid/grid_utm_timexy.hdf grid/grid_utm_timexy.h5
  CONVERT -e grid/grid_utm_timeyx.hdf grid/grid_utm_timeyx.h5
  CONVERT -e grid/grid_geo_xyxy.hdf grid/grid_geo_xyxy.h5
  CONVERT -e grid/grid_geo_yxyx.hdf grid/grid_geo_yxyx.h5
  CONVERT -f grid/grid_geo_xyyx.hdf grid/grid_geo_xyyx.h5
  CONVERT -g grid/grid_geo_nil.hdf grid/grid_geo_nil.h5
  CONVERT -e grid/grid_utm_xyxy.hdf grid/grid_utm_xyxy.h5
  CONVERT -e grid/grid_utm_yxyx.hdf grid/grid_utm_yxyx.h5
  CONVERT -f grid/grid_utm_xyyx.hdf grid/grid_utm_xyyx.h5
  CONVERT -g grid/grid_utm_nil.hdf grid/grid_utm_nil.h5
}

VERIFY_SWATH() {
  CONVERT -e swath/generic_type_swath.hdf swath/generic_type_swath.h5
  CONVERT -e swath/swath_badname.hdf swath/swath_badname.h5
  CONVERT -e swath/swath_basic.hdf swath/swath_basic.h5
  CONVERT -e swath/swath_0101.hdf swath/swath_0101.h5
  CONVERT -e swath/swath_1111.hdf swath/swath_1111.h5
  CONVERT -e swath/swath_2121.hdf swath/swath_2121.h5
  CONVERT -e swath/swath_n11n11.hdf swath/swath_n11n11.h5
  CONVERT -e swath/swath_n11n11_tight.hdf swath/swath_n11n11_tight.h5
  CONVERT -e swath/swath_n21n21.hdf swath/swath_n21n21.h5
  CONVERT -e swath/swath_0202.hdf swath/swath_0202.h5
  CONVERT -e swath/swath_1212.hdf swath/swath_1212.h5
  CONVERT -e swath/swath_2222.hdf swath/swath_2222.h5
  CONVERT -e swath/swath_n12n12.hdf swath/swath_n12n12.h5
  CONVERT -e swath/swath_n22n22.hdf swath/swath_n22n22.h5
  CONVERT -e swath/swath_0n20n2.hdf swath/swath_0n20n2.h5
  CONVERT -e swath/swath_1n21n2.hdf swath/swath_1n21n2.h5
  CONVERT -e swath/swath_2n22n2.hdf swath/swath_2n22n2.h5
  CONVERT -e swath/swath_n1n2n1n2.hdf swath/swath_n1n2n1n2.h5
  CONVERT -e swath/swath_n2n2n2n2.hdf swath/swath_n2n2n2n2.h5
  CONVERT -e swath/swath_qdd.hdf swath/swath_qdd.h5
  CONVERT -e swath/swath_dqd.hdf swath/swath_dqd.h5
  CONVERT -e swath/swath_ddq.hdf swath/swath_ddq.h5
  CONVERT -e swath/swath_qgg.hdf swath/swath_qgg.h5
  CONVERT -e swath/swath_gqg.hdf swath/swath_gqg.h5
  CONVERT -e swath/swath_ggq.hdf swath/swath_ggq.h5
  CONVERT -e swath/swath_tll.hdf swath/swath_tll.h5
  CONVERT -e swath/swath_tll02.hdf swath/swath_tll02.h5
}

#VERIFY_ONE
VERIFY_GRID
VERIFY_SWATH

if test $nerrors -eq 0 ; then
  echo "All h4toh5 tests passed."
else
  echo "FAILED: # failures " $nerrors
fi
exit $nerrors

# vim:ts=8:sts=2:sw=2:et
