#!/bin/bash
#
#  Copyright by The HDF Group (THG).
#  All rights reserved.
# 
#  This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,
#  including terms governing use, modification, and redistribution, is
#  contained in the files COPYING and Copyright.html. COPYING can be
#  found at the root of the source code distribution tree; Copyright.html
#  can be found at the root level of an installed copy of the electronic
#  H4H5TOOLS document set and is linked from the top-level documents page.
#  It can also be found at
#  http://www.hdfgroup.org/H4H5TOOLS/doc/Copyright.html. If you do not have
#  access to either file, you may request a copy from help@hdfgroup.org.
#


H4TOH5=h4toh5
H4TOH5_BIN=/mnt/scr1/clee83/sysdep/kagiso/h4h5tools/utils/h4toh5/$H4TOH5

# The build (current) directory might be different than the source directory.
if test -z "$srcdir"; then
  srcdir=.
fi

ROOTDIR="/mnt/scr1/clee83/real_testfiles"
SRCDIR=$ROOTDIR
OUTDIR=$ROOTDIR/Candidates

#test -d "$OUTDIR" || mkdir $OUTDIR
nerrors=0

CONVERT() {
  partialpath=`dirname $1`

  inputfilename=`basename $1`
  inputdir=$SRCDIR/$partialpath
  inpath=$inputdir/$inputfilename

  outputfilename=${inputfilename%.hdf}.h5
  outputdir=$OUTDIR/$partialpath
  outpath=$outputdir/$outputfilename

  test -d "$outputdir" || mkdir -p $outputdir

  h4toh5option="-eos -nc4strict"
  if 'time' $H4TOH5_BIN $h4toh5option $inpath $outpath ; then
    echo PASSED
  else
    echo FAILED
    nerrors="`expr $nerrors + 1`"
  fi
}

convert_additional_grid_projection() {
  CONVERT additional_grid_projection/AMSR_E_L3_5DaySnow_B07_20060705.hdf
  CONVERT additional_grid_projection/AMSR_E_L3_DailyLand_B03_20050913.hdf
}

convert_n4ftl01u() {
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/AMSA/AE_5DSno.001/2004.07.05/AMSR_E_L3_5DaySnow_B02_20040705.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/AMSA/AE_DyOcn.001/2007.07.06/AMSR_E_L3_DailyOcean_B02_20070706.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/AMSA/AE_DySno.001/2002.06.19/AMSR_E_L3_DailySnow_B02_20020619.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/AMSA/AE_L2A.002/2002.06.19/AMSR_E_L2A_BrightnessTemperatures_V09_200206190029_D.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/AMSA/AE_Land.001/2002.06.18/AMSR_E_L2_Land_B04_200206182340_A.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/AMSA/AE_Land.002/2002.06.19/AMSR_E_L2_Land_T07_200206190029_D.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/AMSA/AE_Land3.001/2002.06.18/AMSR_E_L3_DailyLand_B03_20020618.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/AMSA/AE_MoOcn.001/2007.07.01/AMSR_E_L3_MonthlyOcean_B02_200707.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/AMSA/AE_MoSno.001/2006.03.01/AMSR_E_L3_MonthlySnow_B07_200603.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/AMSA/AE_Ocean.001/2002.06.18/AMSR_E_L2_Ocean_B01_200206182340_A.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/AMSA/AE_Ocean.002/2002.06.19/AMSR_E_L2_Ocean_V06_200206190029_D.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/AMSA/AE_Rain.001/2002.06.18/AMSR_E_L2_Rain_B02_200206182340_A.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/AMSA/AE_Rain.002/2002.06.20/AMSR_E_L2_Rain_V10_200206200023_A.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/AMSA/AE_RnGd.001/2007.07.01/AMSR_E_L3_RainGrid_B05_200707.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/AMSA/AE_SI12.001/2002.06.19/AMSR_E_L3_SeaIce12km_B02_20020619.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/AMSA/AE_SI6.001/2007.04.29/AMSR_E_L3_SeaIce6km_B06_20070429.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/AMSA/AE_WkOcn.001/2007.07.01/AMSR_E_L3_WeeklyOcean_B02_20070701.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOSA/MYD10A1.004/2006.07.19/MYD10A1.A2006200.h10v08.004.2006210171342.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOSA/MYD10A1.005/2002.07.04/MYD10A1.A2002185.h00v08.005.2007162002108.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOSA/MYD10A2.005/2002.07.04/MYD10A2.A2002185.h00v08.005.2007175021721.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOSA/MYD10C1.005/2002.07.04/MYD10C1.A2002185.005.2007162170238.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOSA/MYD10C2.005/2002.07.04/MYD10C2.A2002185.005.2007175180716.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOSA/MYD10CM.005/2002.07.04/MYD10CM.A2002185.005.2007123456789.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOSA/MYD10_L2.005/2002.07.04/MYD10_L2.A2002185.0045.005.2007160151703.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOSA/MYD29.004/2006.07.16/MYD29.A2006197.0300.004.2006206001839.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOSA/MYD29.005/2002.07.04/MYD29.A2002185.0000.005.2007160150627.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOSA/MYD29E1D.005/2002.07.04/MYD29E1D.A2002185.005.2007161103323.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOSA/MYD29P1D.004/2006.07.21/MYD29P1D.A2006202.h08v08.004.2006210172007.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOSA/MYD29P1D.005/2002.07.04/MYD29P1D.A2002185.h03v08.005.2007161002144.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOSA/MYD29P1N.005/2002.07.04/MYD29P1N.A2002185.h03v08.005.2007160163501.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOST/MOD10A1.004/2000.02.24/MOD10A1.A2000055.h00v08.004.2002355191010.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOST/MOD10A1.005/2000.03.05/MOD10A1.A2000065.h17v05.005.2006268042659.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOST/MOD10A2.004/2000.02.26/MOD10A2.A2000057.h00v09.004.2002357102217.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOST/MOD10A2.005/2000.02.26/MOD10A2.A2000057.h00v08.005.2006270075711.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOST/MOD10C1.004/2000.02.24/MOD10C1.A2000055.004.2003002184950.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOST/MOD10C1.005/2000.03.19/MOD10C1.A2000079.005.2007169084153.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOST/MOD10C2.004/2000.02.26/MOD10C2.A2000057.004.2002365173245.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOST/MOD10C2.005/2000.03.05/MOD10C2.A2000065.005.2007176204224.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOST/MOD10CM.005/2000.09.01/MOD10CM.A2000245.005.2006334060242.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOST/MOD10_L2.004/2000.05.15/MOD10_L2.A2000136.0235.004.2003009030119.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOST/MOD10_L2.005/2000.04.03/MOD10_L2.A2000094.0010.005.2008012224617.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOST/MOD29.004/2000.05.15/MOD29.A2000136.0040.004.2003009030013.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOST/MOD29.005/2000.02.24/MOD29.A2000055.0005.005.2006267200024.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOST/MOD29P1D.005/2000.02.24/MOD29P1D.A2000055.h03v08.005.2006268004214.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOST/MOD29P1N.004/2000.05.10/MOD29P1N.A2000131.h08v07.004.2003008205546.hdf
  CONVERT n4ftl01u.ecs.nasa.gov/SAN/MOST/MOD29P1N.005/2000.02.24/MOD29P1N.A2000055.h03v08.005.2006268011806.hdf
}

convert_acdisc_gsfc() {
  CONVERT acdisc.gsfc.nasa.gov/Aqua_AIRS_Level3/AIRH3QP5.005/2003/AIRS.2003.01.01.L3.RetQuant_H005.v5.0.14.0.G07291155122.hdf
  CONVERT acdisc.gsfc.nasa.gov/Aqua_AIRS_Level3/AIRH3QPM.005/2003/AIRS.2003.01.01.L3.RetQuant_H031.v5.0.14.0.G08105155238.hdf
  CONVERT acdisc.gsfc.nasa.gov/Aqua_AIRS_Level3/AIRS3QP5.005/2008/AIRS.2008.01.01.L3.RetQuant_IR005.v5.0.14.0.G08022210143.hdf
  CONVERT acdisc.gsfc.nasa.gov/Aqua_AIRS_Level3/AIRS3ST8.005/2008/AIRS.2008.01.05.L3.RetStd_IR008.v5.0.14.0.G08038124224.hdf
  CONVERT acdisc.gsfc.nasa.gov/Aqua_AIRS_Level3/AIRX3QP5.005/2008/AIRS.2008.01.01.L3.RetQuant005.v5.2.2.0.G08066162952.hdf
  CONVERT acdisc.gsfc.nasa.gov/Aqua_AIRS_Level3/AIRX3ST8.003/2006/AIRS.2006.01.07.L3.RetStd008.v4.0.9.0.G06017010852.hdf
  CONVERT acdisc.gsfc.nasa.gov/Aqua_AIRS_Level3/AIRX3ST8.005/2008/AIRS.2008.01.05.L3.RetStd008.v5.2.2.0.G08071171232.hdf
  CONVERT acdisc.gsfc.nasa.gov/Aqua_AIRS_Level3/AIRX3STD.003/2007/AIRS.2007.01.01.L3.RetStd001.v4.0.9.0.G07003151021.hdf
  CONVERT acdisc.gsfc.nasa.gov/Aqua_AIRS_Level3/AIRX3STD.005/2008/AIRS.2008.01.01.L3.RetStd001.v5.2.2.0.G08066120251.hdf
  CONVERT acdisc.gsfc.nasa.gov/Aqua_AIRS_Level3/AIRX3STM.003/2007/AIRS.2007.01.01.L3.RetStd031.v4.0.9.0.G07033164311.hdf
}

convert_e4ft10lu_ecs() {
  CONVERT e4ftl01u.ecs.nasa.gov/MOLT/MOD13A2.005/2000.02.18/MOD13A2.A2000049.h35v10.005.2006270113527.hdf
  CONVERT e4ftl01u.ecs.nasa.gov/MOLT/MOD13A2.005/2001.01.01/MOD13A2.A2001001.h35v10.005.2008270112438.hdf
  CONVERT e4ftl01u.ecs.nasa.gov/MOLT/MOD13A2.005/2002.05.25/MOD13A2.A2002145.h35v10.005.2007158162110.hdf
  CONVERT e4ftl01u.ecs.nasa.gov/MOLT/MOD13A2.005/2003.12.19/MOD13A2.A2003353.h35v10.005.2008041095145.hdf
  CONVERT e4ftl01u.ecs.nasa.gov/MOLT/MOD13A2.005/2004.12.18/MOD13A2.A2004353.h35v10.005.2008261061742.hdf
  CONVERT e4ftl01u.ecs.nasa.gov/MOLT/MOD13A2.005/2005.08.13/MOD13A2.A2005225.h35v10.005.2008213230723.hdf
  CONVERT e4ftl01u.ecs.nasa.gov/MOLT/MOD13A2.005/2006.08.29/MOD13A2.A2006241.h35v10.005.2008105105824.hdf
  CONVERT e4ftl01u.ecs.nasa.gov/MOLT/MOD13A2.005/2007.12.19/MOD13A2.A2007353.h35v10.005.2008006020610.hdf
  CONVERT e4ftl01u.ecs.nasa.gov/MOLT/MOD13A2.005/2008.09.29/MOD13A2.A2008273.h35v10.005.2008291205702.hdf
}

convert_ladsweb_nascom() {
#  CONVERT ladsweb.nascom.nasa.gov/datapool/Alberta/MYD03.A2002185.0000.005.2007205201114.pscs_000500328620.hdf
  CONVERT ladsweb.nascom.nasa.gov/datapool/NCAR/MOD04_L2.A2008063.1320.005.2008074083014.hdf
#  CONVERT ladsweb.nascom.nasa.gov/datapool/Portugal/MOD021KM.A2008285.1135.005.2008286115556.hdf
#  CONVERT ladsweb.nascom.nasa.gov/datapool/RVito/MOD02HKM.A2005187.0315.005.2008038190147.hdf
#  CONVERT ladsweb.nascom.nasa.gov/datapool/Richardson/MYD01SS.A2008294.0425.005.2008294145837.hdf
  CONVERT ladsweb.nascom.nasa.gov/datapool/Vito/MOD35_L2.A2008268.1405.005.2008268230402.hdf
  CONVERT ladsweb.nascom.nasa.gov/datapool/Vito/china/MOD35_L2.A2008291.1100.005.2008291215048.hdf
  CONVERT ladsweb.nascom.nasa.gov/datapool/Vito/kenya/MOD35_L2.A2008292.0830.005.2008293050618.hdf
}

convert_basic() {
  CONVERT basic/AR_Ocean.hdf
  CONVERT basic/AR_RnGd.hdf
  CONVERT basic/MOD10_L2.hdf
  CONVERT basic/MOD10A1.hdf
}

#convert_basic
convert_n4ftl01u
#convert_acdisc_gsfc
#convert_e4ft10lu_ecs
#convert_ladsweb_nascom

if test $nerrors -eq 0 ; then
  echo "All h4toh5 tests passed."
else
  echo "FAILED: # failures " $nerrors
fi
exit $nerrors

# vim:ts=8:sts=2:sw=2:et
