//////////////////////////////////////////////////////////////////////////////
//    Copyright 2004-2019, SenseGraphics AB
//
//    This file is part of H3D API.
//
//    H3D API is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    H3D API is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with H3D API; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//    A commercial license is also available. Please contact us at 
//    www.sensegraphics.com for more information.
//
//
/// \file H3DShadowObjectNode.cpp
/// \brief CPP file for H3DShadowObjectNode
///
//
//
//////////////////////////////////////////////////////////////////////////////

#include <H3D/H3DShadowObjectNode.h>
#include <H3D/DirectionalLight.h>
#include <H3D/PointLight.h>

using namespace H3D;

H3DNodeDatabase H3DShadowObjectNode::database( 
        "H3DShadowObjectNode", 
        NULL,
        typeid( H3DShadowObjectNode ),
        &X3DChildNode::database 
        );

namespace H3DShadowObjectNodeInternals {
  FIELDDB_ELEMENT( H3DShadowObjectNode, transform, INPUT_OUTPUT )
  FIELDDB_ELEMENT( H3DShadowObjectNode, enabled, INPUT_OUTPUT )
}

H3DShadowObjectNode::H3DShadowObjectNode(  Inst< SFNode>  _metadata,
					   Inst< SFTransformNode > _transform,
                       Inst< SFBool > _enabled ) :
  X3DNode( _metadata ),
  transform( _transform ),
  enabled( _enabled ) {
  type_name = "H3DShadowObjectNode";
  database.initFields( this );

  enabled->setValue( true );
}

H3DShadowObjectNode::LightDataStruct::LightDataStruct( X3DLightNode* light ) :
  light_pos(),
  light_dir(),
  is_direction_light( false ),
  is_point_light( false ) {

  DirectionalLight* dir_light = dynamic_cast<DirectionalLight*>(light);
  if( dir_light ) {
    is_direction_light = true;
    light_dir = dir_light->direction->getValue();
  } else {
    PointLight* point_light = dynamic_cast<PointLight*> (light);
    if( point_light ) {
      is_point_light = true;
      light_pos = point_light->location->getValue();
    }
  }
}


