/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.collections.Maps;
import org.testng.internal.Utils;
import org.testng.xml.XmlClass;

public class ClassInfoMap {
    private Map<Class<?>, XmlClass> m_map = Maps.newLinkedHashMap();
    private boolean includeNestedClasses;

    public ClassInfoMap() {
    }

    public ClassInfoMap(List<XmlClass> classes) {
        this(classes, true);
    }

    public ClassInfoMap(List<XmlClass> classes, boolean includeNested) {
        this.includeNestedClasses = includeNested;
        for (XmlClass xmlClass : classes) {
            try {
                Class c = xmlClass.getSupportClass();
                this.registerClass(c, xmlClass);
            }
            catch (NoClassDefFoundError e) {
                Utils.log("[ClassInfoMap]", 1, "Unable to open class " + xmlClass.getName() + " - unable to resolve class reference " + e.getMessage());
                if (!xmlClass.loadClasses()) continue;
                throw e;
            }
        }
    }

    private void registerClass(Class cl, XmlClass xmlClass) {
        this.m_map.put(cl, xmlClass);
        if (this.includeNestedClasses) {
            for (Class<?> c : cl.getClasses()) {
                if (this.m_map.containsKey(c)) continue;
                this.registerClass(c, xmlClass);
            }
        }
    }

    public void addClass(Class<?> cls) {
        this.m_map.put(cls, null);
    }

    public XmlClass getXmlClass(Class<?> cls) {
        return this.m_map.get(cls);
    }

    public void put(Class<?> cls, XmlClass xmlClass) {
        this.m_map.put(cls, xmlClass);
    }

    public Set<Class<?>> getClasses() {
        return this.m_map.keySet();
    }

    public int getSize() {
        return this.m_map.size();
    }
}

