/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.codehaus.groovy.runtime.ConvertedClosure;
import org.gradle.internal.properties.bean.ImplementationResolver;
import org.gradle.internal.scripts.ScriptOriginUtil;
import org.gradle.internal.snapshot.impl.ImplementationValue;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.util.internal.ConfigureUtil;

public class ScriptSourceAwareImplementationResolver
implements ImplementationResolver {
    public ImplementationValue resolveImplementation(Object bean) {
        Object unwrapped = ScriptSourceAwareImplementationResolver.unwrapBean(bean);
        String classIdentifier = ScriptOriginUtil.getOriginClassIdentifier(unwrapped);
        return new ImplementationValue(classIdentifier, unwrapped);
    }

    @VisibleForTesting
    static Object unwrapBean(Object bean) {
        if (Proxy.isProxyClass(bean.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(bean);
            if (invocationHandler instanceof ConvertedClosure) {
                return ((ConvertedClosure)invocationHandler).getDelegate();
            }
            return invocationHandler;
        }
        if (bean instanceof ConfigureUtil.WrappedConfigureAction) {
            return ((ConfigureUtil.WrappedConfigureAction)bean).getConfigureClosure();
        }
        if (bean instanceof ClosureBackedAction) {
            return ((ClosureBackedAction)bean).getClosure();
        }
        return bean;
    }
}

