/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.CommandLineJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.CompileJavaBuildOperationReportingCompiler;
import org.gradle.api.internal.tasks.compile.CompilerForkUtils;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpecFactory;
import org.gradle.api.internal.tasks.compile.HasCompileOptions;
import org.gradle.api.internal.tasks.compile.JavaCompileExecutableUtils;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilerFactory;
import org.gradle.api.internal.tasks.compile.incremental.recomp.JavaRecompilationSpecProvider;
import org.gradle.api.jvm.ModularitySpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.internal.jvm.DefaultModularitySpec;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.jvm.toolchain.JavaCompiler;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.internal.DefaultToolchainJavaCompiler;
import org.gradle.jvm.toolchain.internal.JavaExecutableUtils;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.gradle.work.NormalizeLineEndings;

@CacheableTask
public abstract class JavaCompile
extends AbstractCompile
implements HasCompileOptions {
    private final CompileOptions compileOptions;
    private final FileCollection stableSources = this.getProject().files(new Object[]{this::getSource});
    private final ModularitySpec modularity;
    private File previousCompilationDataFile;
    private final Property<JavaCompiler> javaCompiler;

    public JavaCompile() {
        ObjectFactory objectFactory = this.getObjectFactory();
        this.compileOptions = (CompileOptions)objectFactory.newInstance(CompileOptions.class, new Object[0]);
        this.modularity = (ModularitySpec)objectFactory.newInstance(DefaultModularitySpec.class, new Object[0]);
        JavaToolchainService javaToolchainService = this.getJavaToolchainService();
        Provider javaCompilerConvention = this.getProviderFactory().provider(() -> JavaCompileExecutableUtils.getExecutableOverrideToolchainSpec(this, objectFactory)).flatMap(arg_0 -> ((JavaToolchainService)javaToolchainService).compilerFor(arg_0)).orElse(javaToolchainService.compilerFor(it -> {}));
        this.javaCompiler = objectFactory.property(JavaCompiler.class).convention(javaCompilerConvention);
        this.javaCompiler.finalizeValueOnRead();
        this.compileOptions.getIncrementalAfterFailure().convention((Object)true);
        CompilerForkUtils.doNotCacheIfForkingViaExecutable(this.compileOptions, (TaskOutputs)this.getOutputs());
    }

    @Internal(value="tracked via stableSources")
    @ToBeReplacedByLazyProperty
    public FileTree getSource() {
        return super.getSource();
    }

    @Nested
    public Property<JavaCompiler> getJavaCompiler() {
        return this.javaCompiler;
    }

    @TaskAction
    protected void compile(InputChanges inputs) {
        DefaultJavaCompileSpec spec = this.createSpec();
        if (!this.compileOptions.isIncremental()) {
            this.performFullCompilation(spec);
        } else {
            this.performIncrementalCompilation(inputs, spec);
        }
    }

    private void performIncrementalCompilation(InputChanges inputs, DefaultJavaCompileSpec spec) {
        boolean isUsingCliCompiler = this.isUsingCliCompiler(spec);
        if (isUsingCliCompiler) {
            spec.getCompileOptions().setSupportsIncrementalCompilationAfterFailure(false);
        }
        spec.getCompileOptions().setSupportsCompilerApi(!isUsingCliCompiler);
        spec.getCompileOptions().setSupportsConstantAnalysis(!isUsingCliCompiler);
        spec.getCompileOptions().setPreviousCompilationDataFile(this.getPreviousCompilationData());
        CleaningJavaCompiler<JavaCompileSpec> compiler = this.createCompiler();
        compiler = this.makeIncremental(inputs, compiler, this.getStableSources());
        this.performCompilation(spec, compiler);
    }

    private Compiler<JavaCompileSpec> makeIncremental(InputChanges inputs, CleaningJavaCompiler<JavaCompileSpec> compiler, FileCollection stableSources) {
        FileTree sources = stableSources.getAsFileTree();
        return this.getIncrementalCompilerFactory().makeIncremental(compiler, sources, this.createRecompilationSpec(inputs, sources));
    }

    private JavaRecompilationSpecProvider createRecompilationSpec(InputChanges inputs, FileTree sources) {
        return new JavaRecompilationSpecProvider(this.getDeleter(), (FileOperations)this.getServices().get(FileOperations.class), sources, inputs.isIncremental(), () -> inputs.getFileChanges(this.getStableSources()).iterator());
    }

    private boolean isUsingCliCompiler(DefaultJavaCompileSpec spec) {
        return CommandLineJavaCompileSpec.class.isAssignableFrom(spec.getClass());
    }

    private void performFullCompilation(DefaultJavaCompileSpec spec) {
        spec.setSourceFiles((Iterable)this.getStableSources());
        CleaningJavaCompiler<JavaCompileSpec> compiler = this.createCompiler();
        this.performCompilation(spec, compiler);
    }

    CleaningJavaCompiler<JavaCompileSpec> createCompiler() {
        Compiler javaCompiler = this.createToolchainCompiler();
        return new CleaningJavaCompiler<JavaCompileSpec>(javaCompiler, this.getOutputs(), this.getDeleter());
    }

    private <T extends CompileSpec> Compiler<T> createToolchainCompiler() {
        return spec -> {
            DefaultToolchainJavaCompiler compiler = (DefaultToolchainJavaCompiler)this.getJavaCompiler().get();
            return compiler.execute(spec);
        };
    }

    @OutputFile
    protected File getPreviousCompilationData() {
        if (this.previousCompilationDataFile == null) {
            this.previousCompilationDataFile = new File(this.getTemporaryDirWithoutCreating(), "previous-compilation-data.bin");
        }
        return this.previousCompilationDataFile;
    }

    private void performCompilation(JavaCompileSpec spec, Compiler<JavaCompileSpec> compiler) {
        WorkResult result = new CompileJavaBuildOperationReportingCompiler((TaskInternal)this, compiler, (BuildOperationRunner)this.getServices().get(BuildOperationRunner.class)).execute(spec);
        this.setDidWork(result.getDidWork());
    }

    @VisibleForTesting
    DefaultJavaCompileSpec createSpec() {
        this.validateForkOptionsMatchToolchain();
        List<File> sourcesRoots = CompilationSourceDirs.inferSourceRoots((FileTreeInternal)this.getStableSources().getAsFileTree());
        JavaModuleDetector javaModuleDetector = this.getJavaModuleDetector();
        boolean isModule = JavaModuleDetector.isModuleSource((boolean)((Boolean)this.modularity.getInferModulePath().get()), sourcesRoots);
        boolean isSourcepathUserDefined = this.compileOptions.getSourcepath() != null && !this.compileOptions.getSourcepath().isEmpty();
        DefaultJavaCompileSpec spec = (DefaultJavaCompileSpec)new DefaultJavaCompileSpecFactory(this.compileOptions, this.getToolchain()).create();
        spec.setDestinationDir((File)this.getDestinationDirectory().getAsFile().get());
        spec.setWorkingDir(this.getProjectLayout().getProjectDirectory().getAsFile());
        spec.setTempDir(this.getTemporaryDir());
        spec.setCompileClasspath((List)ImmutableList.copyOf((Iterable)javaModuleDetector.inferClasspath(isModule, this.getClasspath())));
        spec.setModulePath((List<File>)ImmutableList.copyOf((Iterable)javaModuleDetector.inferModulePath(isModule, this.getClasspath())));
        if (isModule && !isSourcepathUserDefined) {
            this.compileOptions.setSourcepath(this.getProjectLayout().files(new Object[]{sourcesRoots}));
        }
        spec.setAnnotationProcessorPath((List<File>)(this.compileOptions.getAnnotationProcessorPath() == null ? ImmutableList.of() : ImmutableList.copyOf((Iterable)this.compileOptions.getAnnotationProcessorPath())));
        this.configureCompileOptions(spec);
        spec.setSourcesRoots(sourcesRoots);
        if (!this.isToolchainCompatibleWithJava8()) {
            spec.getCompileOptions().setHeaderOutputDirectory(null);
        }
        return spec;
    }

    private void validateForkOptionsMatchToolchain() {
        String customExecutablePath;
        if (!this.getOptions().isFork()) {
            return;
        }
        JavaCompiler javaCompilerTool = (JavaCompiler)this.getJavaCompiler().get();
        File toolchainJavaHome = javaCompilerTool.getMetadata().getInstallationPath().getAsFile();
        ForkOptions forkOptions = this.getOptions().getForkOptions();
        File customJavaHome = forkOptions.getJavaHome();
        if (customJavaHome != null) {
            JavaExecutableUtils.validateMatchingFiles((File)customJavaHome, (String)"Toolchain from `javaHome` property on `ForkOptions`", (File)toolchainJavaHome, (String)"toolchain from `javaCompiler` property");
        }
        if ((customExecutablePath = forkOptions.getExecutable()) != null) {
            File customExecutableJavaHome = JavaExecutableUtils.resolveJavaHomeOfExecutable((String)customExecutablePath);
            JavaExecutableUtils.validateMatchingFiles((File)customExecutableJavaHome, (String)"Toolchain from `executable` property on `ForkOptions`", (File)toolchainJavaHome, (String)"toolchain from `javaCompiler` property");
        }
    }

    private boolean isToolchainCompatibleWithJava8() {
        return this.getToolchain().getLanguageVersion().canCompileOrRun(8);
    }

    @Input
    JavaVersion getJavaVersion() {
        return JavaVersion.toVersion((Object)this.getToolchain().getLanguageVersion().asInt());
    }

    private void configureCompileOptions(DefaultJavaCompileSpec spec) {
        if (this.compileOptions.getRelease().isPresent()) {
            spec.setRelease((Integer)this.compileOptions.getRelease().get());
        } else {
            String targetCompatibility;
            String toolchainVersion = JavaVersion.toVersion((Object)this.getToolchain().getLanguageVersion().asInt()).toString();
            String sourceCompatibility = this.getSourceCompatibility();
            if (sourceCompatibility == null) {
                sourceCompatibility = toolchainVersion;
            }
            if ((targetCompatibility = this.getTargetCompatibility()) == null) {
                targetCompatibility = sourceCompatibility;
            }
            spec.setSourceCompatibility(sourceCompatibility);
            spec.setTargetCompatibility(targetCompatibility);
        }
        spec.setCompileOptions(this.compileOptions);
    }

    private JavaInstallationMetadata getToolchain() {
        return ((JavaCompiler)this.getJavaCompiler().get()).getMetadata();
    }

    private File getTemporaryDirWithoutCreating() {
        return ((TemporaryFileProvider)this.getServices().get(TemporaryFileProvider.class)).newTemporaryFile(new String[]{this.getName()});
    }

    @Nested
    public ModularitySpec getModularity() {
        return this.modularity;
    }

    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    @CompileClasspath
    @Incremental
    @ToBeReplacedByLazyProperty
    public FileCollection getClasspath() {
        return super.getClasspath();
    }

    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @NormalizeLineEndings
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    protected FileCollection getStableSources() {
        return this.stableSources;
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JavaToolchainService getJavaToolchainService() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ProviderFactory getProviderFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected IncrementalCompilerFactory getIncrementalCompilerFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JavaModuleDetector getJavaModuleDetector() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected Deleter getDeleter() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ProjectLayout getProjectLayout() {
        throw new UnsupportedOperationException();
    }
}

