/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.problems;

import com.google.common.collect.Ordering;
import io.usethesource.capsule.Set;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.configurationcache.extensions.CharSequenceExtensionsKt;
import org.gradle.configurationcache.problems.ConfigurationCacheProblemsSummaryKt;
import org.gradle.configurationcache.problems.ProblemSeverity;
import org.gradle.configurationcache.problems.PropertyProblem;
import org.gradle.configurationcache.problems.UniquePropertyProblem;
import org.gradle.internal.logging.ConsoleRenderer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B;\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\n \u001a*\u0004\u0018\u00010\u00160\u00162\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0018J(\u0010$\u001a\u00020%*\u00060&j\u0002`'2\u0006\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003H\u0002R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/gradle/configurationcache/problems/Summary;", "", "problemCount", "", "failureCount", "uniqueProblems", "Lio/usethesource/capsule/Set$Immutable;", "Lorg/gradle/configurationcache/problems/UniquePropertyProblem;", "causes", "", "", "overflowed", "", "(IILio/usethesource/capsule/Set$Immutable;Ljava/util/List;Z)V", "getCauses", "()Ljava/util/List;", "getFailureCount", "()I", "getOverflowed", "()Z", "getProblemCount", "buildSummaryReportLink", "", "reportFile", "Ljava/io/File;", "clickableUrlFor", "kotlin.jvm.PlatformType", "file", "insert", "problem", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "severity", "Lorg/gradle/configurationcache/problems/ProblemSeverity;", "textForConsole", "cacheActionText", "htmlReportFile", "appendSummaryHeader", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "cacheAction", "totalProblemCount", "uniqueProblemCount", "Companion", "configuration-cache"})
public final class Summary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int problemCount;
    private final int failureCount;
    @NotNull
    private final Set.Immutable<UniquePropertyProblem> uniqueProblems;
    @NotNull
    private final List<Throwable> causes;
    private final boolean overflowed;
    @NotNull
    private static final Summary empty;

    private Summary(int problemCount, int failureCount, Set.Immutable<UniquePropertyProblem> uniqueProblems, List<? extends Throwable> causes, boolean overflowed) {
        this.problemCount = problemCount;
        this.failureCount = failureCount;
        this.uniqueProblems = uniqueProblems;
        this.causes = causes;
        this.overflowed = overflowed;
    }

    public final int getProblemCount() {
        return this.problemCount;
    }

    public final int getFailureCount() {
        return this.failureCount;
    }

    @NotNull
    public final List<Throwable> getCauses() {
        return this.causes;
    }

    public final boolean getOverflowed() {
        return this.overflowed;
    }

    @NotNull
    public final Summary insert(@NotNull PropertyProblem problem, @NotNull ProblemSeverity severity) {
        List list;
        PropertyProblem propertyProblem;
        int newFailureCount;
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        int newProblemCount = this.problemCount + 1;
        int n = newFailureCount = severity == ProblemSeverity.Failure ? this.failureCount + 1 : this.failureCount;
        if (this.overflowed || newProblemCount > 4096) {
            return new Summary(newProblemCount, newFailureCount, this.uniqueProblems, this.causes, true);
        }
        UniquePropertyProblem uniqueProblem = UniquePropertyProblem.Companion.of(problem);
        Set.Immutable newUniqueProblems = this.uniqueProblems.__insert((Object)uniqueProblem);
        Object object = problem;
        boolean bl = false;
        boolean bl2 = false;
        PropertyProblem it = object;
        boolean bl3 = false;
        PropertyProblem propertyProblem2 = propertyProblem = newUniqueProblems != this.uniqueProblems && this.getCauses().size() < 5 ? object : null;
        if (propertyProblem == null) {
            list = null;
        } else {
            object = propertyProblem.getException();
            if (object == null) {
                list = null;
            } else {
                Object object2 = object;
                bl2 = false;
                boolean bl4 = false;
                Object it2 = object2;
                boolean bl5 = false;
                list = CollectionsKt.plus((Collection)this.getCauses(), (Object)it2);
            }
        }
        List list2 = list;
        List newCauses = list2 == null ? this.causes : list2;
        Intrinsics.checkNotNullExpressionValue((Object)newUniqueProblems, (String)"newUniqueProblems");
        return new Summary(newProblemCount, newFailureCount, (Set.Immutable<UniquePropertyProblem>)newUniqueProblems, newCauses, false);
    }

    @NotNull
    public final String textForConsole(@NotNull String cacheActionText, @NotNull File htmlReportFile) {
        Intrinsics.checkNotNullParameter((Object)cacheActionText, (String)"cacheActionText");
        Intrinsics.checkNotNullParameter((Object)htmlReportFile, (String)"htmlReportFile");
        DocumentationRegistry documentationRegistry = new DocumentationRegistry();
        int uniqueProblemCount = this.uniqueProblems.size();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$textForConsole_u24lambda_u2d4 = stringBuilder;
        boolean bl3 = false;
        Object object = $this$textForConsole_u24lambda_u2d4;
        boolean bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object).append('\n'), (String)"append('\\n')");
        this.appendSummaryHeader($this$textForConsole_u24lambda_u2d4, cacheActionText, this.getProblemCount(), uniqueProblemCount);
        object = $this$textForConsole_u24lambda_u2d4;
        bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object).append('\n'), (String)"append('\\n')");
        object = Ordering.from((Comparator)ConfigurationCacheProblemsSummaryKt.access$consoleComparator()).leastOf((Iterable)this.uniqueProblems, 15);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"from(consoleComparator()\u2026lems, maxConsoleProblems)");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StringBuilder stringBuilder2;
            StringBuilder stringBuilder3;
            UniquePropertyProblem problem = (UniquePropertyProblem)element$iv;
            boolean bl5 = false;
            $this$textForConsole_u24lambda_u2d4.append("- ");
            $this$textForConsole_u24lambda_u2d4.append(CharSequenceExtensionsKt.capitalized(problem.getUserCodeLocation()));
            $this$textForConsole_u24lambda_u2d4.append(": ");
            CharSequence charSequence = $this$textForConsole_u24lambda_u2d4;
            CharSequence charSequence2 = problem.getMessage();
            boolean bl6 = false;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence.append((String)charSequence2), (String)"append(value)");
            boolean bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            charSequence = problem.getDocumentationSection();
            if (charSequence == null) continue;
            charSequence2 = charSequence;
            bl6 = false;
            boolean bl8 = false;
            CharSequence it = charSequence2;
            boolean bl9 = false;
            StringBuilder stringBuilder4 = $this$textForConsole_u24lambda_u2d4;
            String string2 = Intrinsics.stringPlus((String)"  See ", (Object)documentationRegistry.getDocumentationFor("configuration_cache", it));
            boolean bl10 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append(string2), (String)"append(value)");
            boolean bl11 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        }
        if (uniqueProblemCount > 15) {
            object = $this$textForConsole_u24lambda_u2d4;
            String string3 = "plus " + (uniqueProblemCount - 15) + " more problems. Please see the report for details.";
            boolean bl12 = false;
            StringBuilder stringBuilder5 = ((StringBuilder)object).append(string3);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            StringBuilder stringBuilder6 = stringBuilder5;
            boolean bl13 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append('\\n')");
        }
        object = $this$textForConsole_u24lambda_u2d4;
        boolean bl14 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object).append('\n'), (String)"append('\\n')");
        $this$textForConsole_u24lambda_u2d4.append(this.buildSummaryReportLink(htmlReportFile));
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply {\n\u2026le))\n        }.toString()");
        return string4;
    }

    private final void appendSummaryHeader(StringBuilder $this$appendSummaryHeader, String cacheAction, int totalProblemCount, int uniqueProblemCount) {
        $this$appendSummaryHeader.append(totalProblemCount);
        $this$appendSummaryHeader.append(totalProblemCount == 1 ? " problem was found " : " problems were found ");
        $this$appendSummaryHeader.append(cacheAction);
        $this$appendSummaryHeader.append(" the configuration cache");
        if (this.overflowed) {
            $this$appendSummaryHeader.append(", only the first ");
            $this$appendSummaryHeader.append(4096);
            $this$appendSummaryHeader.append(" were considered");
        }
        if (totalProblemCount != uniqueProblemCount) {
            $this$appendSummaryHeader.append(", ");
            $this$appendSummaryHeader.append(uniqueProblemCount);
            $this$appendSummaryHeader.append(" of which ");
            $this$appendSummaryHeader.append(uniqueProblemCount == 1 ? "seems unique" : "seem unique");
        }
        $this$appendSummaryHeader.append(".");
    }

    private final String buildSummaryReportLink(File reportFile) {
        return Intrinsics.stringPlus((String)"See the complete report at ", (Object)this.clickableUrlFor(reportFile));
    }

    private final String clickableUrlFor(File file) {
        return new ConsoleRenderer().asClickableFileUrl(file);
    }

    static {
        Set.Immutable immutable = Set.Immutable.of();
        Intrinsics.checkNotNullExpressionValue((Object)immutable, (String)"of()");
        empty = new Summary(0, 0, (Set.Immutable<UniquePropertyProblem>)immutable, CollectionsKt.emptyList(), false);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/gradle/configurationcache/problems/Summary$Companion;", "", "()V", "empty", "Lorg/gradle/configurationcache/problems/Summary;", "getEmpty", "()Lorg/gradle/configurationcache/problems/Summary;", "configuration-cache"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Summary getEmpty() {
            return empty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

