/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog.problems;

import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.catalog.problems.VersionCatalogProblemId;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.problems.BaseProblem;
import org.gradle.problems.Solution;
import org.gradle.problems.StandardSeverity;

public class VersionCatalogProblem
extends BaseProblem<VersionCatalogProblemId, StandardSeverity, String> {
    VersionCatalogProblem(VersionCatalogProblemId versionCatalogProblemId, StandardSeverity severity, String context, Supplier<String> shortDescription, Supplier<String> longDescription, Supplier<String> reason, Supplier<String> docUrl, List<Supplier<Solution>> solutions) {
        super((Enum)versionCatalogProblemId, (Enum)severity, (Object)context, shortDescription, longDescription, reason, docUrl, solutions);
    }

    public void reportInto(TreeFormatter output) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Problem: In " + StringUtils.uncapitalize((String)((String)this.getWhere())) + ", " + VersionCatalogProblem.maybeAppendDot(StringUtils.uncapitalize((String)this.getShortDescription())));
        this.getWhy().ifPresent(reason -> {
            formatter.blankLine();
            formatter.node("Reason: " + StringUtils.capitalize((String)VersionCatalogProblem.maybeAppendDot(reason)));
        });
        List possibleSolutions = this.getPossibleSolutions();
        int solutionCount = possibleSolutions.size();
        if (solutionCount > 0) {
            formatter.blankLine();
            if (solutionCount == 1) {
                formatter.node("Possible solution: " + StringUtils.capitalize((String)VersionCatalogProblem.maybeAppendDot(((Solution)possibleSolutions.get(0)).getShortDescription())));
            } else {
                formatter.node("Possible solutions");
                formatter.startNumberedChildren();
                possibleSolutions.forEach(solution -> formatter.node(StringUtils.capitalize((String)VersionCatalogProblem.maybeAppendDot(solution.getShortDescription()))));
                formatter.endChildren();
            }
        }
        this.getDocumentationLink().ifPresent(docLink -> {
            formatter.blankLine();
            formatter.node("Please refer to ").append((CharSequence)docLink).append((CharSequence)" for more details about this problem.");
        });
        output.node(formatter.toString());
    }

    private static String maybeAppendDot(String txt) {
        if (txt.endsWith(".") || txt.endsWith("\n")) {
            return txt;
        }
        return txt + ".";
    }
}

