/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategies;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategy;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategyKt;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\\\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002hiB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0011\u0010!\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0011\u0010#\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006R\u0011\u0010%\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u0011\u0010'\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0006R\u0011\u0010)\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0006R\u0011\u0010+\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0006R\u0011\u0010-\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0006R\u0011\u0010/\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0006R\u0011\u00101\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0006R\u0011\u00103\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0006R\u0011\u00105\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0006R\u0011\u00107\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0006R\u0011\u00109\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u0006R\u0011\u0010;\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u0006R\u0011\u0010=\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u0006R\u0011\u0010?\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u0006R\u0011\u0010A\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\u0006R\u0011\u0010C\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010\u0006R\u0011\u0010E\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\u0006R\u0011\u0010G\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010\u0006R\u0011\u0010I\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010\u0006R\u0011\u0010K\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010\u0006R\u0011\u0010M\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010\u0006R\u000e\u0010O\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010P\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010\u0006R\u0011\u0010R\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010\u0006R\u0011\u0010T\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010\u0006R\u0011\u0010V\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010\u0006R\u0011\u0010X\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010\u0006R\u0011\u0010Z\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\u0006R\u0011\u0010\\\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010\u0006R\u0011\u0010^\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010\u0006R\u001c\u0010`\u001a\u0010\u0012\f\u0012\n c*\u0004\u0018\u00010b0b0aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010d\u001a\u00020e*\u00020f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bd\u0010g\u00a8\u0006j"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategies;", "", "()V", "ABSTRACT_MODIFIER", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;", "getABSTRACT_MODIFIER", "()Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;", "ARRAY_ACCESS", "getARRAY_ACCESS", "COMPANION_OBJECT", "getCOMPANION_OBJECT", "CONST_MODIFIER", "getCONST_MODIFIER", "DECLARATION_NAME", "getDECLARATION_NAME", "DECLARATION_RETURN_TYPE", "getDECLARATION_RETURN_TYPE", "DECLARATION_SIGNATURE", "getDECLARATION_SIGNATURE", "DECLARATION_SIGNATURE_OR_DEFAULT", "getDECLARATION_SIGNATURE_OR_DEFAULT", "DEFAULT", "getDEFAULT", "DOT_BY_QUALIFIED", "getDOT_BY_QUALIFIED", "ELSE_ENTRY", "getELSE_ENTRY", "FUN_INTERFACE", "getFUN_INTERFACE", "FUN_MODIFIER", "getFUN_MODIFIER", "IF_EXPRESSION", "getIF_EXPRESSION", "INLINE_OR_VALUE_MODIFIER", "getINLINE_OR_VALUE_MODIFIER", "INNER_MODIFIER", "getINNER_MODIFIER", "LAST_CHILD", "getLAST_CHILD", "LATEINIT_MODIFIER", "getLATEINIT_MODIFIER", "LONG_LITERAL_SUFFIX", "getLONG_LITERAL_SUFFIX", "MODALITY_MODIFIER", "getMODALITY_MODIFIER", "NAME_OF_NAMED_ARGUMENT", "getNAME_OF_NAMED_ARGUMENT", "OPEN_MODIFIER", "getOPEN_MODIFIER", "OPERATOR", "getOPERATOR", "OVERRIDE_MODIFIER", "getOVERRIDE_MODIFIER", "PARAMETER_DEFAULT_VALUE", "getPARAMETER_DEFAULT_VALUE", "PARAMETER_VARARG_MODIFIER", "getPARAMETER_VARARG_MODIFIER", "PRIVATE_MODIFIER", "getPRIVATE_MODIFIER", "REFERENCED_NAME_BY_QUALIFIED", "getREFERENCED_NAME_BY_QUALIFIED", "REFERENCE_BY_QUALIFIED", "getREFERENCE_BY_QUALIFIED", "REIFIED_MODIFIER", "getREIFIED_MODIFIER", "RESERVED_UNDERSCORE", "getRESERVED_UNDERSCORE", "RETURN_WITH_LABEL", "getRETURN_WITH_LABEL", "SAFE_ACCESS", "getSAFE_ACCESS", "SECONDARY_CONSTRUCTOR_DELEGATION_CALL", "getSECONDARY_CONSTRUCTOR_DELEGATION_CALL", "SELECTOR_BY_QUALIFIED", "getSELECTOR_BY_QUALIFIED", "SUPERTYPES_LIST", "getSUPERTYPES_LIST", "SUSPEND_MODIFIER", "getSUSPEND_MODIFIER", "SUSPEND_OR_FUN_MODIFIER", "TYPE_PARAMETERS_LIST", "getTYPE_PARAMETERS_LIST", "USELESS_ELVIS", "getUSELESS_ELVIS", "VALUE_ARGUMENTS", "getVALUE_ARGUMENTS", "VAL_OR_VAR_NODE", "getVAL_OR_VAR_NODE", "VARIANCE_MODIFIER", "getVARIANCE_MODIFIER", "VISIBILITY_MODIFIER", "getVISIBILITY_MODIFIER", "WHEN_EXPRESSION", "getWHEN_EXPRESSION", "WHOLE_ELEMENT", "getWHOLE_ELEMENT", "nodeTypesWithOperation", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "isDeclaration", "", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "(Lcom/intellij/lang/LighterASTNode;)Z", "FindReferencePositioningStrategy", "ModifierSetBasedLightTreePositioningStrategy", "checkers"})
public final class LightTreePositioningStrategies {
    @NotNull
    public static final LightTreePositioningStrategies INSTANCE = new LightTreePositioningStrategies();
    @NotNull
    private static final LightTreePositioningStrategy DEFAULT = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            IElementType iElementType = node.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.OBJECT_LITERAL)) {
                KtKeywordToken ktKeywordToken = KtTokens.OBJECT_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)ktKeywordToken, (String)"OBJECT_KEYWORD");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.findDescendantByType(tree, node, ktKeywordToken);
                Intrinsics.checkNotNull((Object)lighterASTNode2);
                LighterASTNode objectKeyword = lighterASTNode2;
                return LightTreePositioningStrategyKt.markElement(objectKeyword, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.OBJECT_DECLARATION)) {
                LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.access$objectKeyword(tree, node);
                Intrinsics.checkNotNull((Object)lighterASTNode3);
                LighterASTNode objectKeyword = lighterASTNode3;
                lighterASTNode3 = LightTreePositioningStrategiesKt.nameIdentifier(tree, node);
                return LightTreePositioningStrategyKt.markRange(objectKeyword, lighterASTNode3 == null ? objectKeyword : lighterASTNode3, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL)) {
                return LightTreePositioningStrategies.INSTANCE.getSECONDARY_CONSTRUCTOR_DELEGATION_CALL().mark(node, startOffset, endOffset, tree);
            }
            return super.mark(node, startOffset, endOffset, tree);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy SUPERTYPES_LIST = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$supertypesList(tree, node);
            LighterASTNode target = lighterASTNode2 == null ? node : lighterASTNode2;
            return LightTreePositioningStrategyKt.markElement(target, startOffset, endOffset, tree, node);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy VAL_OR_VAR_NODE = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$valOrVarKeyword(tree, node);
            LighterASTNode target = lighterASTNode2 == null ? node : lighterASTNode2;
            return LightTreePositioningStrategyKt.markElement(target, startOffset, endOffset, tree, node);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy COMPANION_OBJECT = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$companionKeyword(tree, node);
            LighterASTNode target = lighterASTNode2 == null ? node : lighterASTNode2;
            return LightTreePositioningStrategyKt.markElement(target, startOffset, endOffset, tree, node);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy SECONDARY_CONSTRUCTOR_DELEGATION_CALL = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            IElementType iElementType = node.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.SECONDARY_CONSTRUCTOR)) {
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node);
                if (lighterASTNode2 == null) {
                    return LightTreePositioningStrategyKt.markElement$default(node, startOffset, endOffset, tree, null, 16, null);
                }
                LighterASTNode valueParameterList = lighterASTNode2;
                lighterASTNode2 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, node);
                Intrinsics.checkNotNull((Object)lighterASTNode2);
                LighterASTNode lighterASTNode3 = lighterASTNode2;
                lighterASTNode2 = LightTreePositioningStrategiesKt.access$lastChild(tree, valueParameterList);
                return LightTreePositioningStrategyKt.markRange(lighterASTNode3, lighterASTNode2 == null ? valueParameterList : lighterASTNode2, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL)) {
                Object object = KtNodeTypes.CONSTRUCTOR_DELEGATION_REFERENCE;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CONSTRUCTOR_DELEGATION_REFERENCE");
                LighterASTNode delegationReference = LightTreePositioningStrategiesKt.findChildByType(tree, node, (IElementType)object);
                if (delegationReference != null && LightTreePositioningStrategiesKt.access$firstChild(tree, delegationReference) == null) {
                    Object object2 = KtNodeTypes.SECONDARY_CONSTRUCTOR;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"SECONDARY_CONSTRUCTOR");
                    LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.findParentOfType$default(tree, node, (IElementType)object2, false, 4, null);
                    Intrinsics.checkNotNull((Object)lighterASTNode4);
                    LighterASTNode constructor2 = lighterASTNode4;
                    object2 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, constructor2);
                    if (object2 == null) {
                        return LightTreePositioningStrategyKt.markElement(constructor2, startOffset, endOffset, tree, node);
                    }
                    Object valueParameterList = object2;
                    object2 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, constructor2);
                    Intrinsics.checkNotNull((Object)object2);
                    Object object3 = object2;
                    object2 = LightTreePositioningStrategiesKt.access$lastChild(tree, (LighterASTNode)valueParameterList);
                    return LightTreePositioningStrategyKt.markRange((LighterASTNode)object3, (LighterASTNode)(object2 == null ? valueParameterList : object2), startOffset, endOffset, tree, node);
                }
                object = delegationReference;
                return LightTreePositioningStrategyKt.markElement((LighterASTNode)(object == null ? node : object), startOffset, endOffset, tree, node);
            }
            String string2 = Intrinsics.stringPlus((String)"unexpected element ", (Object)node);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy DECLARATION_RETURN_TYPE = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            return LightTreePositioningStrategyKt.markElement(this.getElementToMark(node, tree), startOffset, endOffset, tree, node);
        }

        public boolean isValid(@NotNull LighterASTNode node, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            return super.isValid(this.getElementToMark(node, tree), tree);
        }

        private final LighterASTNode getElementToMark(LighterASTNode node, FlyweightCapableTreeStructure<LighterASTNode> tree) {
            LighterASTNode lighterASTNode2;
            Pair pair = Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.PROPERTY_ACCESSOR) ? TuplesKt.to((Object)LightTreePositioningStrategiesKt.access$typeReference(tree, node), (Object)LightTreePositioningStrategiesKt.access$accessorNamePlaceholder(tree, node)) : (LightTreePositioningStrategies.access$isDeclaration(LightTreePositioningStrategies.INSTANCE, node) ? TuplesKt.to((Object)LightTreePositioningStrategiesKt.access$typeReference(tree, node), (Object)LightTreePositioningStrategiesKt.nameIdentifier(tree, node)) : TuplesKt.to(null, null));
            LighterASTNode returnTypeRef = (LighterASTNode)pair.component1();
            LighterASTNode nameIdentifierOrPlaceHolder = (LighterASTNode)pair.component2();
            LighterASTNode lighterASTNode3 = returnTypeRef;
            return lighterASTNode3 == null ? ((lighterASTNode2 = nameIdentifierOrPlaceHolder) == null ? node : lighterASTNode2) : lighterASTNode3;
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy DECLARATION_NAME = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            LighterASTNode nameIdentifier = LightTreePositioningStrategiesKt.nameIdentifier(tree, node);
            if (nameIdentifier != null) {
                if (Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.CLASS) || Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.OBJECT_DECLARATION)) {
                    LighterASTNode lighterASTNode2;
                    Object object;
                    LighterASTNode lighterASTNode3;
                    LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.access$modifierList(tree, node);
                    if (lighterASTNode4 == null) {
                        lighterASTNode3 = null;
                    } else {
                        object = lighterASTNode4;
                        boolean bl = false;
                        boolean bl2 = false;
                        LighterASTNode modifierList2 = object;
                        boolean bl3 = false;
                        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ENUM_KEYWORD;
                        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"ENUM_KEYWORD");
                        lighterASTNode3 = LightTreePositioningStrategiesKt.findChildByType(tree, modifierList2, ktModifierKeywordToken);
                    }
                    LighterASTNode lighterASTNode5 = lighterASTNode3;
                    if (lighterASTNode5 == null) {
                        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD};
                        object = TokenSet.create(iElementTypeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD)");
                        lighterASTNode4 = LightTreePositioningStrategiesKt.access$findChildByType(tree, node, (TokenSet)object);
                        lighterASTNode2 = lighterASTNode4 == null ? node : lighterASTNode4;
                    } else {
                        lighterASTNode2 = lighterASTNode5;
                    }
                    LighterASTNode startElement = lighterASTNode2;
                    return LightTreePositioningStrategyKt.markRange(startElement, nameIdentifier, startOffset, endOffset, tree, node);
                }
                return LightTreePositioningStrategyKt.markElement(nameIdentifier, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.FUN)) {
                return LightTreePositioningStrategies.INSTANCE.getDECLARATION_SIGNATURE().mark(node, startOffset, endOffset, tree);
            }
            return LightTreePositioningStrategies.INSTANCE.getDEFAULT().mark(node, startOffset, endOffset, tree);
        }

        public boolean isValid(@NotNull LighterASTNode node, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            if (!(Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.OBJECT_DECLARATION) || Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.FUN) || Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.SECONDARY_CONSTRUCTOR) || Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.OBJECT_LITERAL) || LightTreePositioningStrategiesKt.nameIdentifier(tree, node) != null)) {
                return false;
            }
            return super.isValid(node, tree);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy DECLARATION_SIGNATURE = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            IElementType iElementType = node.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PRIMARY_CONSTRUCTOR) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.SECONDARY_CONSTRUCTOR)) {
                LighterASTNode lighterASTNode2;
                LighterASTNode lighterASTNode3;
                LighterASTNode lighterASTNode4;
                LighterASTNode lighterASTNode5 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, node);
                if (lighterASTNode5 == null) {
                    lighterASTNode4 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node);
                    if (lighterASTNode4 == null) {
                        return LightTreePositioningStrategyKt.markElement$default(node, startOffset, endOffset, tree, null, 16, null);
                    }
                    lighterASTNode3 = lighterASTNode4;
                } else {
                    lighterASTNode3 = lighterASTNode5;
                }
                LighterASTNode begin = lighterASTNode3;
                lighterASTNode4 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node);
                if (lighterASTNode4 == null) {
                    LighterASTNode lighterASTNode6 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, node);
                    if (lighterASTNode6 == null) {
                        return LightTreePositioningStrategyKt.markElement$default(node, startOffset, endOffset, tree, null, 16, null);
                    }
                    lighterASTNode2 = lighterASTNode6;
                } else {
                    lighterASTNode2 = lighterASTNode4;
                }
                LighterASTNode end = lighterASTNode2;
                return LightTreePositioningStrategyKt.markRange(begin, end, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FUN) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FUNCTION_LITERAL)) {
                LighterASTNode lighterASTNode7;
                LighterASTNode endOfSignatureElement;
                LighterASTNode end;
                LighterASTNode lighterASTNode8 = LightTreePositioningStrategiesKt.access$typeReference(tree, node);
                LighterASTNode lighterASTNode9 = end = lighterASTNode8 == null ? LightTreePositioningStrategiesKt.access$valueParameterList(tree, node) : lighterASTNode8;
                LighterASTNode lighterASTNode10 = end == null ? ((lighterASTNode8 = LightTreePositioningStrategiesKt.nameIdentifier(tree, node)) == null ? node : lighterASTNode8) : (endOfSignatureElement = end);
                LighterASTNode lighterASTNode11 = Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.FUNCTION_LITERAL) ? ((lighterASTNode8 = LightTreePositioningStrategiesKt.access$receiverTypeReference(tree, node)) == null ? ((lighterASTNode7 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node)) == null ? node : lighterASTNode7) : lighterASTNode8) : node;
                LighterASTNode startElement = lighterASTNode11;
                return LightTreePositioningStrategyKt.markRange(startElement, endOfSignatureElement, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PROPERTY)) {
                LighterASTNode lighterASTNode12;
                LighterASTNode startElement = LightTreePositioningStrategiesKt.access$typeReference(tree, node);
                LighterASTNode endOfSignatureElement = startElement == null ? ((lighterASTNode12 = LightTreePositioningStrategiesKt.nameIdentifier(tree, node)) == null ? node : lighterASTNode12) : startElement;
                return LightTreePositioningStrategyKt.markRange(node, endOfSignatureElement, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PROPERTY_ACCESSOR)) {
                LighterASTNode lighterASTNode13;
                LighterASTNode startElement = LightTreePositioningStrategiesKt.access$typeReference(tree, node);
                LighterASTNode endOfSignatureElement = startElement == null ? ((lighterASTNode13 = LightTreePositioningStrategiesKt.access$rightParenthesis(tree, node)) == null ? LightTreePositioningStrategiesKt.access$accessorNamePlaceholder(tree, node) : lighterASTNode13) : startElement;
                return LightTreePositioningStrategyKt.markRange(node, endOfSignatureElement, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CLASS)) {
                LighterASTNode lighterASTNode14;
                LighterASTNode startElement = LightTreePositioningStrategiesKt.nameIdentifier(tree, node);
                if (startElement == null) {
                    return LightTreePositioningStrategyKt.markElement$default(node, startOffset, endOffset, tree, null, 16, null);
                }
                LighterASTNode nameAsDeclaration = startElement;
                LighterASTNode lighterASTNode15 = LightTreePositioningStrategiesKt.access$primaryConstructor(tree, node);
                if (lighterASTNode15 == null) {
                    lighterASTNode14 = null;
                } else {
                    LighterASTNode lighterASTNode16 = lighterASTNode15;
                    boolean bl = false;
                    boolean bl2 = false;
                    LighterASTNode constructor2 = lighterASTNode16;
                    boolean bl3 = false;
                    lighterASTNode14 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, constructor2);
                }
                LighterASTNode lighterASTNode17 = lighterASTNode14;
                if (lighterASTNode17 == null) {
                    return LightTreePositioningStrategyKt.markElement(nameAsDeclaration, startOffset, endOffset, tree, node);
                }
                LighterASTNode primaryConstructorParameterList = lighterASTNode17;
                return LightTreePositioningStrategyKt.markRange(nameAsDeclaration, primaryConstructorParameterList, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.OBJECT_DECLARATION)) {
                return LightTreePositioningStrategies.INSTANCE.getDECLARATION_NAME().mark(node, startOffset, endOffset, tree);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CLASS_INITIALIZER)) {
                LighterASTNode lighterASTNode18 = LightTreePositioningStrategiesKt.access$initKeyword(tree, node);
                Intrinsics.checkNotNull((Object)lighterASTNode18);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode18, startOffset, endOffset, tree, node);
            }
            return super.mark(node, startOffset, endOffset, tree);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy DECLARATION_SIGNATURE_OR_DEFAULT = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            return LightTreePositioningStrategies.access$isDeclaration(LightTreePositioningStrategies.INSTANCE, node) ? LightTreePositioningStrategies.INSTANCE.getDECLARATION_SIGNATURE().mark(node, startOffset, endOffset, tree) : LightTreePositioningStrategies.INSTANCE.getDEFAULT().mark(node, startOffset, endOffset, tree);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy LAST_CHILD = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            LighterASTNode value2 = LightTreePositioningStrategyKt.nonFillerLastChildOrSelf(node, tree);
            return LightTreePositioningStrategyKt.markElement(value2, startOffset, endOffset, tree, node);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy VISIBILITY_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy MODALITY_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy ABSTRACT_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy OPEN_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy OVERRIDE_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy PRIVATE_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy LATEINIT_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy VARIANCE_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy CONST_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy FUN_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy SUSPEND_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy SUSPEND_OR_FUN_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy INLINE_OR_VALUE_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy INNER_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy OPERATOR;
    @NotNull
    private static final LightTreePositioningStrategy PARAMETER_DEFAULT_VALUE;
    @NotNull
    private static final LightTreePositioningStrategy PARAMETER_VARARG_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy NAME_OF_NAMED_ARGUMENT;
    @NotNull
    private static final LightTreePositioningStrategy VALUE_ARGUMENTS;
    @NotNull
    private static final LightTreePositioningStrategy DOT_BY_QUALIFIED;
    @NotNull
    private static final LightTreePositioningStrategy SELECTOR_BY_QUALIFIED;
    @NotNull
    private static final LightTreePositioningStrategy FUN_INTERFACE;
    @NotNull
    private static final LightTreePositioningStrategy REFERENCE_BY_QUALIFIED;
    @NotNull
    private static final LightTreePositioningStrategy REFERENCED_NAME_BY_QUALIFIED;
    @NotNull
    private static final Set<IElementType> nodeTypesWithOperation;
    @NotNull
    private static final LightTreePositioningStrategy WHEN_EXPRESSION;
    @NotNull
    private static final LightTreePositioningStrategy IF_EXPRESSION;
    @NotNull
    private static final LightTreePositioningStrategy ELSE_ENTRY;
    @NotNull
    private static final LightTreePositioningStrategy ARRAY_ACCESS;
    @NotNull
    private static final LightTreePositioningStrategy SAFE_ACCESS;
    @NotNull
    private static final LightTreePositioningStrategy USELESS_ELVIS;
    @NotNull
    private static final LightTreePositioningStrategy RETURN_WITH_LABEL;
    @NotNull
    private static final LightTreePositioningStrategy WHOLE_ELEMENT;
    @NotNull
    private static final LightTreePositioningStrategy LONG_LITERAL_SUFFIX;
    @NotNull
    private static final LightTreePositioningStrategy REIFIED_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy TYPE_PARAMETERS_LIST;
    @NotNull
    private static final LightTreePositioningStrategy RESERVED_UNDERSCORE;

    private LightTreePositioningStrategies() {
    }

    @NotNull
    public final LightTreePositioningStrategy getDEFAULT() {
        return DEFAULT;
    }

    @NotNull
    public final LightTreePositioningStrategy getSUPERTYPES_LIST() {
        return SUPERTYPES_LIST;
    }

    @NotNull
    public final LightTreePositioningStrategy getVAL_OR_VAR_NODE() {
        return VAL_OR_VAR_NODE;
    }

    @NotNull
    public final LightTreePositioningStrategy getCOMPANION_OBJECT() {
        return COMPANION_OBJECT;
    }

    @NotNull
    public final LightTreePositioningStrategy getSECONDARY_CONSTRUCTOR_DELEGATION_CALL() {
        return SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    }

    @NotNull
    public final LightTreePositioningStrategy getDECLARATION_RETURN_TYPE() {
        return DECLARATION_RETURN_TYPE;
    }

    @NotNull
    public final LightTreePositioningStrategy getDECLARATION_NAME() {
        return DECLARATION_NAME;
    }

    @NotNull
    public final LightTreePositioningStrategy getDECLARATION_SIGNATURE() {
        return DECLARATION_SIGNATURE;
    }

    @NotNull
    public final LightTreePositioningStrategy getDECLARATION_SIGNATURE_OR_DEFAULT() {
        return DECLARATION_SIGNATURE_OR_DEFAULT;
    }

    @NotNull
    public final LightTreePositioningStrategy getLAST_CHILD() {
        return LAST_CHILD;
    }

    private final boolean isDeclaration(LighterASTNode $this$isDeclaration) {
        IElementType iElementType = $this$isDeclaration.getTokenType();
        return (((((((Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PRIMARY_CONSTRUCTOR) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.SECONDARY_CONSTRUCTOR)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FUN)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FUNCTION_LITERAL)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PROPERTY)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PROPERTY_ACCESSOR)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CLASS)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.OBJECT_DECLARATION)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CLASS_INITIALIZER);
    }

    @NotNull
    public final LightTreePositioningStrategy getVISIBILITY_MODIFIER() {
        return VISIBILITY_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getMODALITY_MODIFIER() {
        return MODALITY_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getABSTRACT_MODIFIER() {
        return ABSTRACT_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getOPEN_MODIFIER() {
        return OPEN_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getOVERRIDE_MODIFIER() {
        return OVERRIDE_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getPRIVATE_MODIFIER() {
        return PRIVATE_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getLATEINIT_MODIFIER() {
        return LATEINIT_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getVARIANCE_MODIFIER() {
        return VARIANCE_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getCONST_MODIFIER() {
        return CONST_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getFUN_MODIFIER() {
        return FUN_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getSUSPEND_MODIFIER() {
        return SUSPEND_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getINLINE_OR_VALUE_MODIFIER() {
        return INLINE_OR_VALUE_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getINNER_MODIFIER() {
        return INNER_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getOPERATOR() {
        return OPERATOR;
    }

    @NotNull
    public final LightTreePositioningStrategy getPARAMETER_DEFAULT_VALUE() {
        return PARAMETER_DEFAULT_VALUE;
    }

    @NotNull
    public final LightTreePositioningStrategy getPARAMETER_VARARG_MODIFIER() {
        return PARAMETER_VARARG_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getNAME_OF_NAMED_ARGUMENT() {
        return NAME_OF_NAMED_ARGUMENT;
    }

    @NotNull
    public final LightTreePositioningStrategy getVALUE_ARGUMENTS() {
        return VALUE_ARGUMENTS;
    }

    @NotNull
    public final LightTreePositioningStrategy getDOT_BY_QUALIFIED() {
        return DOT_BY_QUALIFIED;
    }

    @NotNull
    public final LightTreePositioningStrategy getSELECTOR_BY_QUALIFIED() {
        return SELECTOR_BY_QUALIFIED;
    }

    @NotNull
    public final LightTreePositioningStrategy getFUN_INTERFACE() {
        return FUN_INTERFACE;
    }

    @NotNull
    public final LightTreePositioningStrategy getREFERENCE_BY_QUALIFIED() {
        return REFERENCE_BY_QUALIFIED;
    }

    @NotNull
    public final LightTreePositioningStrategy getREFERENCED_NAME_BY_QUALIFIED() {
        return REFERENCED_NAME_BY_QUALIFIED;
    }

    @NotNull
    public final LightTreePositioningStrategy getWHEN_EXPRESSION() {
        return WHEN_EXPRESSION;
    }

    @NotNull
    public final LightTreePositioningStrategy getIF_EXPRESSION() {
        return IF_EXPRESSION;
    }

    @NotNull
    public final LightTreePositioningStrategy getELSE_ENTRY() {
        return ELSE_ENTRY;
    }

    @NotNull
    public final LightTreePositioningStrategy getARRAY_ACCESS() {
        return ARRAY_ACCESS;
    }

    @NotNull
    public final LightTreePositioningStrategy getSAFE_ACCESS() {
        return SAFE_ACCESS;
    }

    @NotNull
    public final LightTreePositioningStrategy getUSELESS_ELVIS() {
        return USELESS_ELVIS;
    }

    @NotNull
    public final LightTreePositioningStrategy getRETURN_WITH_LABEL() {
        return RETURN_WITH_LABEL;
    }

    @NotNull
    public final LightTreePositioningStrategy getWHOLE_ELEMENT() {
        return WHOLE_ELEMENT;
    }

    @NotNull
    public final LightTreePositioningStrategy getLONG_LITERAL_SUFFIX() {
        return LONG_LITERAL_SUFFIX;
    }

    @NotNull
    public final LightTreePositioningStrategy getREIFIED_MODIFIER() {
        return REIFIED_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getTYPE_PARAMETERS_LIST() {
        return TYPE_PARAMETERS_LIST;
    }

    @NotNull
    public final LightTreePositioningStrategy getRESERVED_UNDERSCORE() {
        return RESERVED_UNDERSCORE;
    }

    public static final /* synthetic */ boolean access$isDeclaration(LightTreePositioningStrategies $this, LighterASTNode $receiver) {
        return $this.isDeclaration($receiver);
    }

    public static final /* synthetic */ LightTreePositioningStrategy access$getSUSPEND_OR_FUN_MODIFIER$p() {
        return SUSPEND_OR_FUN_MODIFIER;
    }

    static {
        Object object = KtTokens.VISIBILITY_MODIFIERS;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"VISIBILITY_MODIFIERS");
        VISIBILITY_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        object = KtTokens.MODALITY_MODIFIERS;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"MODALITY_MODIFIERS");
        MODALITY_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.ABSTRACT_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(KtTokens.ABSTRACT_KEYWORD)");
        ABSTRACT_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.OPEN_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(KtTokens.OPEN_KEYWORD)");
        OPEN_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.OVERRIDE_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(KtTokens.OVERRIDE_KEYWORD)");
        OVERRIDE_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.PRIVATE_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(KtTokens.PRIVATE_KEYWORD)");
        PRIVATE_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.LATEINIT_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(KtTokens.LATEINIT_KEYWORD)");
        LATEINIT_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.OUT_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(KtTokens.IN_KEYWORD, KtTokens.OUT_KEYWORD)");
        VARIANCE_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.CONST_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(KtTokens.CONST_KEYWORD)");
        CONST_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.FUN_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(KtTokens.FUN_KEYWORD)");
        FUN_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.SUSPEND_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(KtTokens.SUSPEND_KEYWORD)");
        SUSPEND_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.SUSPEND_KEYWORD, KtTokens.FUN_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(KtTokens.SUSPEND_KEYWORD, KtTokens.FUN_KEYWORD)");
        SUSPEND_OR_FUN_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.INLINE_KEYWORD, KtTokens.VALUE_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(KtTokens.INLINE_KEYWORD, KtTokens.VALUE_KEYWORD)");
        INLINE_OR_VALUE_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.INNER_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(KtTokens.INNER_KEYWORD)");
        INNER_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        OPERATOR = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$operationReference(tree, node);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode2 == null ? node : lighterASTNode2, startOffset, endOffset, tree, node);
            }
        };
        PARAMETER_DEFAULT_VALUE = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$defaultValue(tree, node);
                LighterASTNode defaultValueElement = lighterASTNode2 == null ? node : lighterASTNode2;
                return LightTreePositioningStrategyKt.markElement(defaultValueElement, startOffset, endOffset, tree, node);
            }
        };
        PARAMETER_VARARG_MODIFIER = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                LighterASTNode modifier;
                LighterASTNode lighterASTNode2;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.access$modifierList(tree, node);
                if (lighterASTNode3 == null) {
                    lighterASTNode2 = null;
                } else {
                    LighterASTNode lighterASTNode4 = lighterASTNode3;
                    boolean bl = false;
                    boolean bl2 = false;
                    LighterASTNode modifierList2 = lighterASTNode4;
                    boolean bl3 = false;
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.VARARG_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"VARARG_KEYWORD");
                    lighterASTNode2 = LightTreePositioningStrategiesKt.findChildByType(tree, modifierList2, ktModifierKeywordToken);
                }
                lighterASTNode3 = modifier = lighterASTNode2;
                return LightTreePositioningStrategyKt.markElement(lighterASTNode3 == null ? node : lighterASTNode3, startOffset, endOffset, tree, node);
            }
        };
        NAME_OF_NAMED_ARGUMENT = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                Object object = KtNodeTypes.VALUE_ARGUMENT_NAME;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"VALUE_ARGUMENT_NAME");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.findChildByType(tree, node, (IElementType)object);
                if (lighterASTNode2 == null) {
                    list2 = null;
                } else {
                    object = lighterASTNode2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object valueArgumentName = object;
                    boolean bl3 = false;
                    list2 = LightTreePositioningStrategyKt.markElement((LighterASTNode)valueArgumentName, startOffset, endOffset, tree, node);
                }
                List<TextRange> list3 = list2;
                return list3 == null ? LightTreePositioningStrategyKt.markElement(node, startOffset, endOffset, tree, node) : list3;
            }
        };
        VALUE_ARGUMENTS = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                Object object = KtNodeTypes.VALUE_ARGUMENT_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"VALUE_ARGUMENT_LIST");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.findDescendantByType(tree, node, (IElementType)object);
                if (lighterASTNode2 == null) {
                    list2 = null;
                } else {
                    object = lighterASTNode2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object valueArgumentList = object;
                    boolean bl3 = false;
                    Object object2 = KtTokens.RPAR;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"RPAR");
                    LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.findLastChildByType(tree, (LighterASTNode)valueArgumentList, (IElementType)object2);
                    if (lighterASTNode3 == null) {
                        list2 = null;
                    } else {
                        object2 = lighterASTNode3;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Object rpar = object2;
                        boolean bl6 = false;
                        list2 = LightTreePositioningStrategyKt.markElement((LighterASTNode)rpar, startOffset, endOffset, tree, node);
                    }
                }
                List<TextRange> list3 = list2;
                return list3 == null ? LightTreePositioningStrategyKt.markElement(node, startOffset, endOffset, tree, node) : list3;
            }
        };
        DOT_BY_QUALIFIED = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                if (Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.DOT_QUALIFIED_EXPRESSION)) {
                    LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$dotOperator(tree, node);
                    return LightTreePositioningStrategyKt.markElement(lighterASTNode2 == null ? node : lighterASTNode2, startOffset, endOffset, tree, node);
                }
                return LightTreePositioningStrategies.INSTANCE.getREFERENCE_BY_QUALIFIED().mark(node, startOffset, endOffset, tree);
            }
        };
        SELECTOR_BY_QUALIFIED = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                if (!Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.DOT_QUALIFIED_EXPRESSION) && !Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.SAFE_ACCESS_EXPRESSION)) {
                    return super.mark(node, startOffset, endOffset, tree);
                }
                LighterASTNode selector = LightTreePositioningStrategiesKt.selector(tree, node);
                if (selector != null) {
                    return LightTreePositioningStrategyKt.markElement(selector, startOffset, endOffset, tree, node);
                }
                return super.mark(node, startOffset, endOffset, tree);
            }
        };
        FUN_INTERFACE = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                IElementType iElementType = node.getTokenType();
                return Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CLASS) ? LightTreePositioningStrategies.INSTANCE.getFUN_MODIFIER().mark(node, startOffset, endOffset, tree) : (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PROPERTY) ? LightTreePositioningStrategies.INSTANCE.getVAL_OR_VAR_NODE().mark(node, startOffset, endOffset, tree) : (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FUN) ? (LightTreePositioningStrategiesKt.typeParametersList(tree, node) != null ? LightTreePositioningStrategies.INSTANCE.getTYPE_PARAMETERS_LIST().mark(node, startOffset, endOffset, tree) : LightTreePositioningStrategies.access$getSUSPEND_OR_FUN_MODIFIER$p().mark(node, startOffset, endOffset, tree)) : LightTreePositioningStrategies.INSTANCE.getDEFAULT().mark(node, startOffset, endOffset, tree)));
            }
        };
        REFERENCE_BY_QUALIFIED = new FindReferencePositioningStrategy(false);
        REFERENCED_NAME_BY_QUALIFIED = new FindReferencePositioningStrategy(true);
        object = new IElementType[]{KtNodeTypes.IS_EXPRESSION, KtNodeTypes.BINARY_WITH_TYPE, KtNodeTypes.BINARY_EXPRESSION, KtNodeTypes.POSTFIX_EXPRESSION, KtNodeTypes.PREFIX_EXPRESSION, KtNodeTypes.BINARY_EXPRESSION, KtNodeTypes.WHEN_CONDITION_IN_RANGE};
        nodeTypesWithOperation = SetsKt.setOf((Object[])object);
        WHEN_EXPRESSION = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$whenKeyword(tree, node);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode2 == null ? node : lighterASTNode2, startOffset, endOffset, tree, node);
            }
        };
        IF_EXPRESSION = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$ifKeyword(tree, node);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode2 == null ? node : lighterASTNode2, startOffset, endOffset, tree, node);
            }
        };
        ELSE_ENTRY = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$elseKeyword(tree, node);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode2 == null ? node : lighterASTNode2, startOffset, endOffset, tree, node);
            }
        };
        ARRAY_ACCESS = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                IElementType iElementType = KtNodeTypes.INDICES;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"INDICES");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.findChildByType(tree, node, iElementType);
                Intrinsics.checkNotNull((Object)lighterASTNode2);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode2, startOffset, endOffset, tree, node);
            }
        };
        SAFE_ACCESS = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$safeAccess(tree, node);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode2 == null ? node : lighterASTNode2, startOffset, endOffset, tree, node);
            }
        };
        USELESS_ELVIS = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$operationReference(tree, node);
                LighterASTNode lighterASTNode3 = lighterASTNode2 == null ? node : lighterASTNode2;
                lighterASTNode2 = LightTreePositioningStrategiesKt.access$lastChild(tree, node);
                return LightTreePositioningStrategyKt.markRange(lighterASTNode3, lighterASTNode2 == null ? node : lighterASTNode2, startOffset, endOffset, tree, node);
            }
        };
        RETURN_WITH_LABEL = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                Object object = KtNodeTypes.LABEL_QUALIFIER;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"LABEL_QUALIFIER");
                LighterASTNode labeledExpression = LightTreePositioningStrategiesKt.findChildByType(tree, node, (IElementType)object);
                if (labeledExpression != null) {
                    return LightTreePositioningStrategyKt.markRange(node, labeledExpression, startOffset, endOffset, tree, node);
                }
                object = LightTreePositioningStrategiesKt.access$returnKeyword(tree, node);
                return LightTreePositioningStrategyKt.markElement((LighterASTNode)(object == null ? node : object), startOffset, endOffset, tree, node);
            }
        };
        WHOLE_ELEMENT = new LightTreePositioningStrategy(){};
        LONG_LITERAL_SUFFIX = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                if (Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.INTEGER_CONSTANT)) {
                    TextRange textRange = TextRange.create(endOffset - 1, endOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(endOffset - 1, endOffset)");
                    return CollectionsKt.listOf((Object)textRange);
                }
                return super.mark(node, startOffset, endOffset, tree);
            }
        };
        iElementTypeArray = new IElementType[]{KtTokens.REIFIED_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(KtTokens.REIFIED_KEYWORD)");
        REIFIED_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        TYPE_PARAMETERS_LIST = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.typeParametersList(tree, node);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode2 == null ? node : lighterASTNode2, startOffset, endOffset, tree, node);
            }
        };
        RESERVED_UNDERSCORE = new LightTreePositioningStrategy(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Object label;
                LighterASTNode parent2;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(tree, (String)"tree");
                if (Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.RETURN) && (parent2 = tree.getParent(node)) != null) {
                    IElementType iElementType = KtNodeTypes.LABEL;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"LABEL");
                    label = LightTreePositioningStrategiesKt.findDescendantByType(tree, parent2, iElementType);
                    if (label != null) {
                        return LightTreePositioningStrategyKt.markElement((LighterASTNode)label, startOffset, endOffset - 1, tree, node);
                    }
                }
                label = KtTokens.IDENTIFIER;
                Intrinsics.checkNotNullExpressionValue((Object)label, (String)"IDENTIFIER");
                List<LighterASTNode> descendants2 = LightTreePositioningStrategiesKt.collectDescendantsOfType(tree, node, (IElementType)label, (Function1<? super LighterASTNode, Boolean>)((Function1)RESERVED_UNDERSCORE.mark.descendants.1.INSTANCE));
                label = descendants2;
                boolean bl = false;
                if (!label.isEmpty()) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = descendants2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        LighterASTNode lighterASTNode2 = (LighterASTNode)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        TextRange textRange = LightTreePositioningStrategyKt.markSingleElement((LighterASTNode)it, (LighterASTNode)it, startOffset, endOffset, tree, node);
                        collection.add(textRange);
                    }
                    return (List)destination$iv$iv;
                }
                return super.mark(node, startOffset, endOffset, tree);
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategies$ModifierSetBasedLightTreePositioningStrategy;", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;", "modifierSet", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "(Lcom/intellij/psi/tree/TokenSet;)V", "mark", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "startOffset", "", "endOffset", "tree", "Lorg/jetbrains/kotlin/com/intellij/util/diff/FlyweightCapableTreeStructure;", "checkers"})
    private static final class ModifierSetBasedLightTreePositioningStrategy
    extends LightTreePositioningStrategy {
        @NotNull
        private final TokenSet modifierSet;

        public ModifierSetBasedLightTreePositioningStrategy(@NotNull TokenSet modifierSet) {
            Intrinsics.checkNotNullParameter((Object)modifierSet, (String)"modifierSet");
            this.modifierSet = modifierSet;
        }

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            List<TextRange> list2;
            Object object;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            LighterASTNode modifierList2 = LightTreePositioningStrategiesKt.access$modifierList(tree, node);
            if (modifierList2 != null && (object = LightTreePositioningStrategiesKt.access$findChildByType(tree, modifierList2, this.modifierSet)) != null) {
                LighterASTNode lighterASTNode2 = object;
                boolean bl = false;
                boolean bl2 = false;
                LighterASTNode it = lighterASTNode2;
                boolean bl3 = false;
                return LightTreePositioningStrategyKt.markElement(it, startOffset, endOffset, tree, node);
            }
            object = LightTreePositioningStrategiesKt.nameIdentifier(tree, node);
            if (object != null) {
                LighterASTNode lighterASTNode3 = object;
                boolean bl = false;
                boolean bl4 = false;
                LighterASTNode it = lighterASTNode3;
                boolean bl5 = false;
                return LightTreePositioningStrategyKt.markElement(it, startOffset, endOffset, tree, node);
            }
            object = node.getTokenType();
            if (Intrinsics.areEqual((Object)object, (Object)KtNodeTypes.OBJECT_DECLARATION)) {
                LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.access$objectKeyword(tree, node);
                Intrinsics.checkNotNull((Object)lighterASTNode4);
                list2 = LightTreePositioningStrategyKt.markElement(lighterASTNode4, startOffset, endOffset, tree, node);
            } else {
                list2 = Intrinsics.areEqual((Object)object, (Object)KtNodeTypes.PROPERTY_ACCESSOR) ? LightTreePositioningStrategyKt.markElement(LightTreePositioningStrategiesKt.access$accessorNamePlaceholder(tree, node), startOffset, endOffset, tree, node) : LightTreePositioningStrategyKt.markElement$default(node, startOffset, endOffset, tree, null, 16, null);
            }
            return list2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategies$FindReferencePositioningStrategy;", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;", "locateReferencedName", "", "(Z)V", "getLocateReferencedName", "()Z", "mark", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "startOffset", "", "endOffset", "tree", "Lorg/jetbrains/kotlin/com/intellij/util/diff/FlyweightCapableTreeStructure;", "checkers"})
    public static final class FindReferencePositioningStrategy
    extends LightTreePositioningStrategy {
        private final boolean locateReferencedName;

        public FindReferencePositioningStrategy(boolean locateReferencedName) {
            this.locateReferencedName = locateReferencedName;
        }

        public final boolean getLocateReferencedName() {
            return this.locateReferencedName;
        }

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            if (Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.CALL_EXPRESSION) || Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL)) {
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$referenceExpression(tree, node, this.locateReferencedName);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode2 == null ? node : lighterASTNode2, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.PROPERTY_DELEGATE)) {
                LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.access$findReferenceExpressionDeep(tree, node);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode3 == null ? node : lighterASTNode3, startOffset, endOffset, tree, node);
            }
            if (nodeTypesWithOperation.contains(node.getTokenType())) {
                LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.access$operationReference(tree, node);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode4 == null ? node : lighterASTNode4, startOffset, endOffset, tree, node);
            }
            if (!(Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.DOT_QUALIFIED_EXPRESSION) || Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.SAFE_ACCESS_EXPRESSION) || Intrinsics.areEqual((Object)node.getTokenType(), (Object)KtNodeTypes.CALLABLE_REFERENCE_EXPRESSION))) {
                return super.mark(node, startOffset, endOffset, tree);
            }
            LighterASTNode selector = LightTreePositioningStrategiesKt.selector(tree, node);
            if (selector != null) {
                IElementType iElementType = selector.getTokenType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.REFERENCE_EXPRESSION)) {
                    return LightTreePositioningStrategyKt.markElement(selector, startOffset, endOffset, tree, node);
                }
                if ((Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CALL_EXPRESSION) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.SUPER_TYPE_CALL_ENTRY)) {
                    LighterASTNode lighterASTNode5 = LightTreePositioningStrategiesKt.access$referenceExpression(tree, selector, this.locateReferencedName);
                    return LightTreePositioningStrategyKt.markElement(lighterASTNode5 == null ? selector : lighterASTNode5, startOffset, endOffset, tree, node);
                }
            }
            return super.mark(node, startOffset, endOffset, tree);
        }
    }
}

