/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.catalog.internal;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.catalog.DefaultVersionCatalog;
import org.gradle.api.internal.catalog.DependencyModel;
import org.gradle.api.internal.catalog.PluginModel;

class TomlWriter {
    private static final Pattern SEPARATOR = Pattern.compile("[_.-]");
    private final Writer writer;

    private static String normalizeForToml(String alias) {
        return SEPARATOR.matcher(alias).replaceAll("-");
    }

    TomlWriter(Writer writer) {
        this.writer = writer;
    }

    private TomlWriter writeLn(String line) {
        return this.write(line + "\n");
    }

    private TomlWriter writeLn() {
        return this.writeLn("");
    }

    private TomlWriter write(String text) {
        try {
            this.writer.write(text);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return this;
    }

    public void generate(DefaultVersionCatalog model) {
        this.writeHeader();
        this.writeMetadata();
        this.writeVersions(model);
        this.writeLibraries(model);
        this.writeBundles(model);
        this.writePlugins(model);
    }

    private void writeVersions(DefaultVersionCatalog model) {
        List versions = model.getVersionAliases();
        if (versions.isEmpty()) {
            return;
        }
        this.writeTableHeader("versions");
        for (String alias : versions) {
            this.write(TomlWriter.normalizeForToml(alias) + " = ");
            this.writeLn(TomlWriter.versionString(model.getVersion(alias).getVersion()));
        }
        this.writeLn();
    }

    private void writeLibraries(DefaultVersionCatalog model) {
        List aliases = model.getDependencyAliases();
        if (aliases.isEmpty()) {
            return;
        }
        this.writeTableHeader("libraries");
        for (String alias : aliases) {
            DependencyModel data = model.getDependencyData(alias);
            String group = data.getGroup();
            String name = data.getName();
            String versionRef = data.getVersionRef();
            ImmutableVersionConstraint version = data.getVersion();
            StringBuilder sb = new StringBuilder();
            sb.append(TomlWriter.normalizeForToml(alias)).append(" = {").append(TomlWriter.keyValuePair("group", group)).append(", ").append(TomlWriter.keyValuePair("name", name)).append(", ");
            if (versionRef != null) {
                sb.append(TomlWriter.keyValuePair("version.ref", TomlWriter.normalizeForToml(versionRef)));
            } else {
                sb.append("version = ").append(TomlWriter.versionString(version));
            }
            sb.append(" }");
            this.writeLn(sb.toString());
        }
        this.writeLn();
    }

    private void writeBundles(DefaultVersionCatalog model) {
        List aliases = model.getBundleAliases();
        if (aliases.isEmpty()) {
            return;
        }
        this.writeTableHeader("bundles");
        for (String alias : aliases) {
            List bundle = model.getBundle(alias).getComponents();
            this.writeLn(TomlWriter.normalizeForToml(alias) + " = [" + bundle.stream().map(TomlWriter::normalizeForToml).map(TomlWriter::quoted).collect(Collectors.joining(", ")) + "]");
        }
        this.writeLn();
    }

    private void writePlugins(DefaultVersionCatalog model) {
        List aliases = model.getPluginAliases();
        if (aliases.isEmpty()) {
            return;
        }
        this.writeTableHeader("plugins");
        for (String alias : aliases) {
            PluginModel data = model.getPlugin(alias);
            String id = data.getId();
            String versionRef = data.getVersionRef();
            ImmutableVersionConstraint version = data.getVersion();
            StringBuilder sb = new StringBuilder();
            sb.append(TomlWriter.normalizeForToml(alias)).append(" = {").append(TomlWriter.keyValuePair("id", id)).append(", ");
            if (versionRef != null) {
                sb.append(TomlWriter.keyValuePair("version.ref", TomlWriter.normalizeForToml(versionRef)));
            } else {
                sb.append("version = ").append(TomlWriter.versionString(version));
            }
            sb.append(" }");
            this.writeLn(sb.toString());
        }
        this.writeLn();
    }

    private static String versionString(ImmutableVersionConstraint version) {
        String requiredVersion = version.getRequiredVersion();
        String strictVersion = version.getStrictVersion();
        String preferredVersion = version.getPreferredVersion();
        List rejectedVersions = version.getRejectedVersions();
        StringBuilder sb = new StringBuilder();
        if (rejectedVersions.isEmpty() && strictVersion.isEmpty() && preferredVersion.isEmpty()) {
            sb.append(TomlWriter.quoted(requiredVersion));
            return sb.toString();
        }
        sb.append("{ ");
        ArrayList parts = Lists.newArrayList();
        if (!strictVersion.isEmpty()) {
            parts.add(TomlWriter.keyValuePair("strictly", strictVersion));
        }
        if (!preferredVersion.isEmpty()) {
            parts.add(TomlWriter.keyValuePair("prefer", preferredVersion));
        }
        if (!requiredVersion.isEmpty() && strictVersion.isEmpty()) {
            parts.add(TomlWriter.keyValuePair("require", requiredVersion));
        }
        if (!rejectedVersions.isEmpty()) {
            if (rejectedVersions.contains("+")) {
                parts.add("rejectAll = true");
            } else {
                parts.add("reject = [" + rejectedVersions.stream().map(TomlWriter::quoted).collect(Collectors.joining(", ")) + "]");
            }
        }
        sb.append(String.join((CharSequence)", ", parts)).append(" }");
        return sb.toString();
    }

    private void writeHeader() {
        this.writeLn("#");
        this.writeLn("# This file has been generated by Gradle and is intended to be consumed by Gradle");
        this.writeLn("#");
    }

    private void writeMetadata() {
        this.writeLn("[metadata]");
        this.writeLn("format.version = \"1.1\"");
        this.writeLn();
    }

    private void writeTableHeader(String title) {
        this.writeLn("[" + title + "]");
    }

    private static String keyValuePair(String key, String value) {
        return key + " = " + TomlWriter.quoted(value);
    }

    private static String quoted(String string) {
        return "\"" + string + "\"";
    }
}

