/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000f2\n\u0010\u0012\u001a\u00060\u0013R\u00020\u0000H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\f\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u001aJ\"\u0010\u001b\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u000f0\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/VarargTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "externalVarargs", "", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "getExternalVarargs", "()Ljava/util/Set;", "setExternalVarargs", "(Ljava/util/Set;)V", "getArgumentFromSingleSegment", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "segment", "arrayInfo", "Lorg/jetbrains/kotlin/ir/backend/js/lower/VarargTransformer$InlineClassArrayInfo;", "transformFunctionAccessExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitFunctionAccess", "visitVararg", "getInlinedClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "toArrayLiteral", "", "type", "varargElementType", "InlineClassArrayInfo", "backend.js"})
final class VarargTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private Set<IrVararg> externalVarargs;

    public VarargTransformer(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        boolean bl = false;
        this.externalVarargs = new LinkedHashSet();
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @Nullable
    public final IrClass getInlinedClass(@NotNull IrType $this$getInlinedClass) {
        Intrinsics.checkNotNullParameter((Object)$this$getInlinedClass, (String)"<this>");
        return this.context.getInlineClassesUtils().getInlinedClass($this$getInlinedClass);
    }

    @NotNull
    public final Set<IrVararg> getExternalVarargs() {
        return this.externalVarargs;
    }

    public final void setExternalVarargs(@NotNull Set<IrVararg> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.externalVarargs = set;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression toArrayLiteral(List<? extends IrExpression> $this$toArrayLiteral, IrType type2, IrType varargElementType) {
        int n;
        void $this$mapKeysTo$iv$iv322;
        Map $this$mapKeys$iv;
        Map<IrClassSymbol, PrimitiveType> map = this.context.getIntrinsics().getPrimitiveArrays();
        boolean $i$f$mapKeys22 = false;
        void var7_8 = $this$mapKeys$iv;
        Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv322.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            IrClassSymbol irClassSymbol = (IrClassSymbol)it.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            IrClassSymbol irClassSymbol2 = irClassSymbol;
            Map map3 = map2;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map3.put(irClassSymbol2, entry);
        }
        $this$mapKeys$iv = destination$iv$iv;
        IrClassifierSymbol $i$f$mapKeys22 = IrTypesKt.getClassifierOrNull(type2);
        boolean $this$mapKeysTo$iv$iv322 = false;
        PrimitiveType primitiveType = (PrimitiveType)((Object)$this$mapKeys$iv.get($i$f$mapKeys22));
        IrSimpleFunctionSymbol intrinsic = primitiveType != null ? (IrSimpleFunctionSymbol)MapsKt.getValue(this.context.getIntrinsics().getPrimitiveToLiteralConstructor(), (Object)((Object)primitiveType)) : this.context.getIntrinsics().getArrayLiteral();
        IrExpression $this$mapKeysTo$iv$iv322 = (IrExpression)CollectionsKt.firstOrNull($this$toArrayLiteral);
        int startOffset = $this$mapKeysTo$iv$iv322 == null ? -1 : (destination$iv$iv = $this$mapKeysTo$iv$iv322.getStartOffset());
        destination$iv$iv = (IrExpression)CollectionsKt.lastOrNull($this$toArrayLiteral);
        int endOffset = destination$iv$iv == null ? -1 : (n = destination$iv$iv.getEndOffset());
        IrVarargImpl irVararg = new IrVarargImpl(startOffset, endOffset, type2, varargElementType, $this$toArrayLiteral);
        Object object = ((IrSimpleFunction)intrinsic.getOwner()).getTypeParameters();
        boolean bl = false;
        object = new IrCallImpl(startOffset, endOffset, type2, intrinsic, !object.isEmpty() ? 1 : 0, 1, null, null, 192, null);
        bl = false;
        boolean bl3 = false;
        Object $this$toArrayLiteral_u24lambda_u2d1 = object;
        boolean bl4 = false;
        if (((IrMemberAccessExpression)$this$toArrayLiteral_u24lambda_u2d1).getTypeArgumentsCount() == 1) {
            ((IrMemberAccessExpression)$this$toArrayLiteral_u24lambda_u2d1).putTypeArgument(0, varargElementType);
        }
        ((IrFunctionAccessExpression)$this$toArrayLiteral_u24lambda_u2d1).putValueArgument(0, irVararg);
        return (IrExpression)object;
    }

    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2) {
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        boolean bl2 = false;
        List currentList = new ArrayList();
        boolean bl3 = false;
        List segments = new ArrayList();
        InlineClassArrayInfo arrayInfo = new InlineClassArrayInfo(expression2.getVarargElementType(), expression2.getType());
        for (IrVarargElement e : expression2.getElements()) {
            IrVarargElement irVarargElement = e;
            if (irVarargElement instanceof IrSpreadElement) {
                object = currentList;
                bl = false;
                if (!object.isEmpty()) {
                    segments.add(arrayInfo.toPrimitiveArrayLiteral(currentList));
                    currentList.clear();
                }
                segments.add(arrayInfo.unboxElementIfNeeded(((IrSpreadElement)e).getExpression()));
                continue;
            }
            if (!(irVarargElement instanceof IrExpression)) continue;
            currentList.add(arrayInfo.unboxElementIfNeeded((IrExpression)e));
        }
        Collection collection = currentList;
        boolean e = false;
        if (!collection.isEmpty()) {
            segments.add(arrayInfo.toPrimitiveArrayLiteral(currentList));
            currentList.clear();
        }
        if (segments.isEmpty()) {
            boolean bl4 = false;
            e = false;
            InlineClassArrayInfo $this$visitVararg_u24lambda_u2d2 = arrayInfo;
            boolean bl5 = false;
            return $this$visitVararg_u24lambda_u2d2.boxArrayIfNeeded($this$visitVararg_u24lambda_u2d2.toPrimitiveArrayLiteral(CollectionsKt.emptyList()));
        }
        if (segments.size() == 1) {
            IrExpression segment = (IrExpression)CollectionsKt.first((List)segments);
            IrExpression argument2 = this.getArgumentFromSingleSegment(expression2, segment, arrayInfo);
            return arrayInfo.boxArrayIfNeeded(argument2);
        }
        IrExpression arrayLiteral = this.toArrayLiteral(segments, new IrSimpleTypeImpl(this.context.getIntrinsics().getArray(), false, CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, 16, null), this.context.getIrBuiltIns().getAnyType());
        IrSimpleFunctionSymbol concatFun = CollectionsKt.contains((Iterable)this.context.getIntrinsics().getPrimitiveArrays().keySet(), (Object)IrTypesKt.getClassifierOrNull(arrayInfo.getPrimitiveArrayType())) ? this.context.getIntrinsics().getPrimitiveArrayConcat() : this.context.getIntrinsics().getArrayConcat();
        object = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), arrayInfo.getPrimitiveArrayType(), concatFun, 0, 1, null, null, 192, null);
        bl = false;
        boolean bl6 = false;
        Object $this$visitVararg_u24lambda_u2d3 = object;
        boolean bl7 = false;
        ((IrFunctionAccessExpression)$this$visitVararg_u24lambda_u2d3).putValueArgument(0, arrayLiteral);
        Object res2 = object;
        return arrayInfo.boxArrayIfNeeded((IrExpression)res2);
    }

    private final IrExpression getArgumentFromSingleSegment(IrVararg expression2, IrExpression segment, InlineClassArrayInfo arrayInfo) {
        IrExpression irExpression;
        boolean bl;
        block6: {
            if (this.externalVarargs.contains(expression2)) {
                this.externalVarargs.remove(expression2);
                return segment;
            }
            Iterable $this$any$iv = expression2.getElements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrVarargElement it = (IrVarargElement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof IrSpreadElement)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            IrType elementType = arrayInfo.getPrimitiveElementType();
            IrSimpleFunctionSymbol copyFunction = IrTypePredicatesKt.isChar(elementType) || IrTypePredicatesKt.isBoolean(elementType) || IrTypePredicatesKt.isLong(elementType) ? this.context.getIntrinsics().getTaggedArrayCopy() : this.context.getIntrinsics().getJsArraySlice();
            IrCallImpl irCallImpl = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), arrayInfo.getPrimitiveArrayType(), copyFunction, 1, 1, null, null, 192, null);
            boolean bl3 = false;
            boolean bl4 = false;
            IrCallImpl $this$getArgumentFromSingleSegment_u24lambda_u2d5 = irCallImpl;
            boolean bl5 = false;
            $this$getArgumentFromSingleSegment_u24lambda_u2d5.putTypeArgument(0, arrayInfo.getPrimitiveArrayType());
            $this$getArgumentFromSingleSegment_u24lambda_u2d5.putValueArgument(0, segment);
            irExpression = irCallImpl;
        } else {
            irExpression = segment;
        }
        return irExpression;
    }

    private final IrExpression transformFunctionAccessExpression(IrFunctionAccessExpression expression2) {
        boolean bl;
        int i;
        int n;
        int n2;
        if (((IrFunctionSymbol)expression2.getSymbol()).getOwner().isExternal() && (n2 = 0) < (n = expression2.getValueArgumentsCount())) {
            do {
                IrVararg irVararg;
                i = n2++;
                IrValueParameter parameter = ((IrFunctionSymbol)expression2.getSymbol()).getOwner().getValueParameters().get(i);
                IrType varargElementType = parameter.getVarargElementType();
                if (varargElementType == null || (irVararg = (IrVararg)expression2.getValueArgument(i)) == null) continue;
                IrVararg irVararg2 = irVararg;
                boolean bl2 = false;
                bl = false;
                IrVararg it = irVararg2;
                boolean bl3 = false;
                this.getExternalVarargs().add(it);
            } while (n2 < n);
        }
        this.transformChildrenVoid(expression2);
        int size = expression2.getValueArgumentsCount();
        n = 0;
        if (n < size) {
            do {
                i = n++;
                IrExpression argument2 = expression2.getValueArgument(i);
                IrValueParameter parameter = ((IrFunctionSymbol)expression2.getSymbol()).getOwner().getValueParameters().get(i);
                IrType varargElementType = parameter.getVarargElementType();
                if (argument2 != null || varargElementType == null) continue;
                InlineClassArrayInfo arrayInfo = new InlineClassArrayInfo(varargElementType, parameter.getType());
                bl = false;
                boolean bl4 = false;
                InlineClassArrayInfo $this$transformFunctionAccessExpression_u24lambda_u2d7 = arrayInfo;
                boolean bl5 = false;
                IrExpression emptyArray = $this$transformFunctionAccessExpression_u24lambda_u2d7.boxArrayIfNeeded($this$transformFunctionAccessExpression_u24lambda_u2d7.toPrimitiveArrayLiteral(CollectionsKt.emptyList()));
                expression2.putValueArgument(i, emptyArray);
            } while (n < size);
        }
        return expression2;
    }

    @Override
    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return this.transformFunctionAccessExpression(expression2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\u0014\u0010\u0018\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aJ\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/VarargTransformer$InlineClassArrayInfo;", "", "elementType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "arrayType", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/VarargTransformer;Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "arrayInlineClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getArrayInlineClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getArrayType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "getElementType", "inlined", "", "getInlined", "()Z", "primitiveArrayType", "getPrimitiveArrayType", "primitiveElementType", "getPrimitiveElementType", "boxArrayIfNeeded", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "array", "toPrimitiveArrayLiteral", "elements", "", "unboxElementIfNeeded", "element", "backend.js"})
    public final class InlineClassArrayInfo {
        @NotNull
        private final IrType elementType;
        @NotNull
        private final IrType arrayType;
        @Nullable
        private final IrClass arrayInlineClass;
        private final boolean inlined;
        @NotNull
        private final IrType primitiveElementType;
        @NotNull
        private final IrType primitiveArrayType;

        public InlineClassArrayInfo(@NotNull IrType elementType, IrType arrayType) {
            IrType irType;
            IrType irType2;
            IrClass irClass2;
            Intrinsics.checkNotNullParameter((Object)VarargTransformer.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)arrayType, (String)"arrayType");
            this.elementType = elementType;
            this.arrayType = arrayType;
            this.arrayInlineClass = VarargTransformer.this.getInlinedClass(this.arrayType);
            boolean bl = this.inlined = this.arrayInlineClass != null;
            if (this.inlined) {
                irClass2 = VarargTransformer.this.getInlinedClass(this.elementType);
                Intrinsics.checkNotNull((Object)irClass2);
                irType2 = InlineClassesKt.getInlineClassUnderlyingType(irClass2);
            } else {
                irType2 = this.primitiveElementType = this.elementType;
            }
            if (this.inlined) {
                irClass2 = this.arrayInlineClass;
                Intrinsics.checkNotNull((Object)irClass2);
                irType = InlineClassesKt.getInlineClassUnderlyingType(irClass2);
            } else {
                irType = this.arrayType;
            }
            this.primitiveArrayType = irType;
        }

        @NotNull
        public final IrType getElementType() {
            return this.elementType;
        }

        @NotNull
        public final IrType getArrayType() {
            return this.arrayType;
        }

        @Nullable
        public final IrClass getArrayInlineClass() {
            return this.arrayInlineClass;
        }

        public final boolean getInlined() {
            return this.inlined;
        }

        @NotNull
        public final IrType getPrimitiveElementType() {
            return this.primitiveElementType;
        }

        @NotNull
        public final IrType getPrimitiveArrayType() {
            return this.primitiveArrayType;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IrExpression boxArrayIfNeeded(@NotNull IrExpression array) {
            IrExpression irExpression;
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            if (this.arrayInlineClass == null) {
                irExpression = array;
            } else {
                void $this$single$iv;
                boolean bl = false;
                boolean bl2 = false;
                IrExpression $this$boxArrayIfNeeded_u24lambda_u2d2 = array;
                boolean bl3 = false;
                Object object = IrUtilsKt.getConstructors(this.getArrayInlineClass());
                IrType irType = IrUtilsKt.getDefaultType(this.getArrayInlineClass());
                int n = $this$boxArrayIfNeeded_u24lambda_u2d2.getEndOffset();
                int n2 = $this$boxArrayIfNeeded_u24lambda_u2d2.getStartOffset();
                IrConstructorCallImpl.Companion companion = IrConstructorCallImpl.Companion;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    IrConstructor it = (IrConstructor)element$iv;
                    boolean bl4 = false;
                    if (!it.isPrimary()) continue;
                    if (found$iv) {
                        throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                Object var18_21 = single$iv;
                object = IrConstructorCallImpl.Companion.fromSymbolOwner$default(companion, n2, n, irType, ((IrConstructor)var18_21).getSymbol(), this.getArrayInlineClass().getTypeParameters().size(), null, 32, null);
                boolean bl5 = false;
                boolean bl6 = false;
                Object it = object;
                boolean bl7 = false;
                ((IrFunctionAccessExpression)it).putValueArgument(0, array);
                irExpression = (IrExpression)object;
            }
            return irExpression;
        }

        @NotNull
        public final IrExpression unboxElementIfNeeded(@NotNull IrExpression element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (this.arrayInlineClass == null) {
                return element;
            }
            VarargTransformer varargTransformer = VarargTransformer.this;
            boolean bl = false;
            boolean bl2 = false;
            IrExpression $this$unboxElementIfNeeded_u24lambda_u2d3 = element;
            boolean bl3 = false;
            IrClass irClass2 = varargTransformer.getInlinedClass($this$unboxElementIfNeeded_u24lambda_u2d3.getType());
            if (irClass2 == null) {
                return element;
            }
            IrClass inlinedClass = irClass2;
            IrField field = InlineClassesKt.getInlineClassBackingField(inlinedClass);
            return new IrGetFieldImpl($this$unboxElementIfNeeded_u24lambda_u2d3.getStartOffset(), $this$unboxElementIfNeeded_u24lambda_u2d3.getEndOffset(), field.getSymbol(), field.getType(), $this$unboxElementIfNeeded_u24lambda_u2d3, null, null, 96, null);
        }

        @NotNull
        public final IrExpression toPrimitiveArrayLiteral(@NotNull List<? extends IrExpression> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return VarargTransformer.this.toArrayLiteral(elements, this.primitiveArrayType, this.primitiveElementType);
        }
    }
}

