/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.layout;

import java.io.File;
import java.io.IOException;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.cache.internal.DefaultCleanupProgressMonitor;
import org.gradle.cache.internal.VersionSpecificCacheCleanupAction;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectCacheDir
implements Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectCacheDir.class);
    private static final long MAX_UNUSED_DAYS_FOR_RELEASES_AND_SNAPSHOTS = 7L;
    private final File dir;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final Deleter deleter;
    private boolean deleteOnStop = false;

    public ProjectCacheDir(File dir, ProgressLoggerFactory progressLoggerFactory, Deleter deleter) {
        this.dir = dir;
        this.progressLoggerFactory = progressLoggerFactory;
        this.deleter = deleter;
    }

    public File getDir() {
        return this.dir;
    }

    public void delete() {
        this.deleteOnStop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.deleteOnStop) {
            try {
                this.deleter.deleteRecursively(this.dir);
            }
            catch (IOException e) {
                LOGGER.debug("Failed to delete unused project cache dir " + this.dir.getAbsolutePath(), (Throwable)e);
            }
            return;
        }
        VersionSpecificCacheCleanupAction cleanupAction = new VersionSpecificCacheCleanupAction(this.dir, 7L, this.deleter);
        String description = cleanupAction.getDisplayName();
        ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(ProjectCacheDir.class).start(description, description);
        try {
            cleanupAction.execute((CleanupProgressMonitor)new DefaultCleanupProgressMonitor(progressLogger));
        }
        finally {
            progressLogger.completed();
        }
    }
}

