/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.initialization.DefaultGradleProperties;
import org.gradle.initialization.IGradlePropertiesLoader;
import org.gradle.internal.Cast;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGradlePropertiesLoader
implements IGradlePropertiesLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGradlePropertiesLoader.class);
    private final StartParameterInternal startParameter;

    public DefaultGradlePropertiesLoader(StartParameterInternal startParameter) {
        this.startParameter = startParameter;
    }

    @Override
    public GradleProperties loadGradleProperties(File rootDir) {
        return this.loadProperties(rootDir, this.startParameter, this.getAllSystemProperties(), this.getAllEnvProperties());
    }

    GradleProperties loadProperties(File rootDir, StartParameterInternal startParameter, Map<String, String> systemProperties, Map<String, String> envProperties) {
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        HashMap<String, String> overrideProperties = new HashMap<String, String>();
        this.addGradleProperties(defaultProperties, new File(startParameter.getGradleHomeDir(), "gradle.properties"));
        this.addGradleProperties(defaultProperties, new File(rootDir, "gradle.properties"));
        this.addGradleProperties(overrideProperties, new File(startParameter.getGradleUserHomeDir(), "gradle.properties"));
        this.addSystemPropertiesFromGradleProperties(defaultProperties);
        this.addSystemPropertiesFromGradleProperties(overrideProperties);
        System.getProperties().putAll((Map<?, ?>)startParameter.getSystemPropertiesArgs());
        overrideProperties.putAll(this.getEnvProjectProperties(envProperties));
        overrideProperties.putAll(this.getSystemProjectProperties(systemProperties));
        overrideProperties.putAll(startParameter.getProjectProperties());
        return new DefaultGradleProperties(defaultProperties, overrideProperties);
    }

    Map<String, String> getAllSystemProperties() {
        return (Map)Cast.uncheckedNonnullCast((Object)System.getProperties());
    }

    Map<String, String> getAllEnvProperties() {
        return System.getenv();
    }

    private void addGradleProperties(Map<String, String> target, File ... files) {
        for (File propertyFile : files) {
            if (propertyFile == null || !propertyFile.isFile()) continue;
            Properties properties = GUtil.loadProperties((File)propertyFile);
            target.putAll((Map)Cast.uncheckedNonnullCast((Object)properties));
        }
    }

    private Map<String, String> getSystemProjectProperties(Map<String, String> systemProperties) {
        HashMap<String, String> systemProjectProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : systemProperties.entrySet()) {
            if (!entry.getKey().startsWith("org.gradle.project.") || entry.getKey().length() <= "org.gradle.project.".length()) continue;
            systemProjectProperties.put(entry.getKey().substring("org.gradle.project.".length()), entry.getValue());
        }
        LOGGER.debug("Found system project properties: {}", systemProjectProperties.keySet());
        return systemProjectProperties;
    }

    private Map<String, String> getEnvProjectProperties(Map<String, String> envProperties) {
        HashMap<String, String> envProjectProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : envProperties.entrySet()) {
            if (!entry.getKey().startsWith("ORG_GRADLE_PROJECT_") || entry.getKey().length() <= "ORG_GRADLE_PROJECT_".length()) continue;
            envProjectProperties.put(entry.getKey().substring("ORG_GRADLE_PROJECT_".length()), entry.getValue());
        }
        LOGGER.debug("Found env project properties: {}", envProjectProperties.keySet());
        return envProjectProperties;
    }

    private void addSystemPropertiesFromGradleProperties(Map<String, String> properties) {
        for (String key : properties.keySet()) {
            if (!key.startsWith("systemProp.")) continue;
            System.setProperty(key.substring("systemProp.".length()), properties.get(key));
        }
    }
}

