/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.nio.channels.SocketChannel;
import org.simpleframework.http.core.Channel;
import org.simpleframework.http.core.Collector;
import org.simpleframework.http.core.Selector;
import org.simpleframework.transport.reactor.Operation;

class Reader
implements Operation {
    private final Selector source;
    private final Collector task;
    private final Channel channel;

    public Reader(Selector source, Collector task) {
        this.channel = task.getChannel();
        this.source = source;
        this.task = task;
    }

    public SocketChannel getChannel() {
        return this.task.getSocket();
    }

    public void run() {
        try {
            this.task.collect(this.source);
        }
        catch (Throwable e) {
            this.cancel();
        }
    }

    public void cancel() {
        try {
            this.channel.close();
        }
        finally {
            return;
        }
    }
}

