/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.distribution.Distribution;
import org.gradle.api.distribution.DistributionContainer;
import org.gradle.api.distribution.plugins.DistributionPlugin;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.api.plugins.JavaApplication;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.DefaultApplicationPluginConvention;
import org.gradle.api.plugins.internal.DefaultJavaApplication;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.application.CreateStartScripts;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;

public class ApplicationPlugin
implements Plugin<Project> {
    public static final String APPLICATION_PLUGIN_NAME = "application";
    public static final String APPLICATION_GROUP = "application";
    public static final String TASK_RUN_NAME = "run";
    public static final String TASK_START_SCRIPTS_NAME = "startScripts";
    public static final String TASK_DIST_ZIP_NAME = "distZip";
    public static final String TASK_DIST_TAR_NAME = "distTar";

    public void apply(Project project) {
        TaskContainer tasks = project.getTasks();
        project.getPluginManager().apply(JavaPlugin.class);
        project.getPluginManager().apply(DistributionPlugin.class);
        ApplicationPluginConvention pluginConvention = this.addConvention(project);
        JavaApplication pluginExtension = this.addExtensions(project, pluginConvention);
        this.addRunTask(project, pluginExtension, pluginConvention);
        this.addCreateScriptsTask(project, pluginExtension, pluginConvention);
        this.configureJavaCompileTask((TaskProvider<JavaCompile>)tasks.named("compileJava", JavaCompile.class), pluginExtension);
        this.configureInstallTask(project.getProviders(), (TaskProvider<Sync>)tasks.named("installDist", Sync.class), pluginConvention);
        DistributionContainer distributions = (DistributionContainer)project.getExtensions().getByName("distributions");
        Distribution mainDistribution = (Distribution)distributions.getByName("main");
        this.configureDistribution(project, mainDistribution, pluginConvention);
    }

    private void configureJavaCompileTask(TaskProvider<JavaCompile> javaCompile, JavaApplication pluginExtension) {
        javaCompile.configure(j -> j.getOptions().getJavaModuleMainClass().convention(pluginExtension.getMainClass()));
    }

    private void configureJarTask(TaskProvider<Jar> jar, JavaApplication pluginExtension) {
        jar.configure(j -> j.getManifest().attributes(Collections.singletonMap("Main-Class", pluginExtension.getMainClass())));
    }

    private void configureInstallTask(ProviderFactory providers, TaskProvider<Sync> installTask, ApplicationPluginConvention pluginConvention) {
        installTask.configure(task -> task.doFirst("don't overwrite existing directories", (Action)new PreventDestinationOverwrite(providers.provider(pluginConvention::getApplicationName), providers.provider(pluginConvention::getExecutableDir))));
    }

    private ApplicationPluginConvention addConvention(Project project) {
        DefaultApplicationPluginConvention pluginConvention = new DefaultApplicationPluginConvention(project);
        ((ApplicationPluginConvention)pluginConvention).setApplicationName(project.getName());
        project.getConvention().getPlugins().put("application", pluginConvention);
        return pluginConvention;
    }

    private JavaApplication addExtensions(Project project, ApplicationPluginConvention pluginConvention) {
        return (JavaApplication)project.getExtensions().create(JavaApplication.class, "application", DefaultJavaApplication.class, new Object[]{pluginConvention});
    }

    private void addRunTask(Project project, JavaApplication pluginExtension, ApplicationPluginConvention pluginConvention) {
        project.getTasks().register(TASK_RUN_NAME, JavaExec.class, run -> {
            run.setDescription("Runs this project as a JVM application");
            run.setGroup("application");
            ConfigurableFileCollection runtimeClasspath = project.files(new Object[0]).from(new Object[]{() -> {
                if (run.getMainModule().isPresent()) {
                    return this.jarsOnlyRuntimeClasspath(project);
                }
                return this.runtimeClasspath(project);
            }});
            run.setClasspath((FileCollection)runtimeClasspath);
            run.getMainModule().set(pluginExtension.getMainModule());
            run.getMainClass().set(pluginExtension.getMainClass());
            run.getConventionMapping().map("jvmArgs", pluginConvention::getApplicationDefaultJvmArgs);
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            run.getModularity().getInferModulePath().convention((Provider)javaPluginExtension.getModularity().getInferModulePath());
        });
    }

    private void addCreateScriptsTask(Project project, JavaApplication pluginExtension, ApplicationPluginConvention pluginConvention) {
        project.getTasks().register(TASK_START_SCRIPTS_NAME, CreateStartScripts.class, startScripts -> {
            startScripts.setDescription("Creates OS specific scripts to run the project as a JVM application.");
            startScripts.setClasspath(this.jarsOnlyRuntimeClasspath(project));
            startScripts.getMainModule().set(pluginExtension.getMainModule());
            startScripts.getMainClass().set(pluginExtension.getMainClass());
            startScripts.getConventionMapping().map("applicationName", pluginConvention::getApplicationName);
            startScripts.getConventionMapping().map("outputDir", () -> new File(project.getBuildDir(), "scripts"));
            startScripts.getConventionMapping().map("executableDir", pluginConvention::getExecutableDir);
            startScripts.getConventionMapping().map("defaultJvmOpts", pluginConvention::getApplicationDefaultJvmArgs);
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            startScripts.getModularity().getInferModulePath().convention((Provider)javaPluginExtension.getModularity().getInferModulePath());
        });
    }

    private FileCollection runtimeClasspath(Project project) {
        return ((SourceSet)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main")).getRuntimeClasspath();
    }

    private FileCollection jarsOnlyRuntimeClasspath(Project project) {
        return project.getTasks().getAt("jar").getOutputs().getFiles().plus((FileCollection)project.getConfigurations().getByName("runtimeClasspath"));
    }

    private CopySpec configureDistribution(Project project, Distribution mainDistribution, ApplicationPluginConvention pluginConvention) {
        mainDistribution.getDistributionBaseName().convention(project.provider(pluginConvention::getApplicationName));
        CopySpec distSpec = mainDistribution.getContents();
        TaskProvider jar = project.getTasks().named("jar");
        TaskProvider startScripts = project.getTasks().named(TASK_START_SCRIPTS_NAME);
        CopySpec libChildSpec = project.copySpec();
        libChildSpec.into((Object)"lib");
        libChildSpec.from(new Object[]{jar});
        libChildSpec.from(new Object[]{project.getConfigurations().named("runtimeClasspath")});
        CopySpec binChildSpec = project.copySpec();
        binChildSpec.into(pluginConvention::getExecutableDir);
        binChildSpec.from(new Object[]{startScripts});
        binChildSpec.setFileMode(Integer.valueOf(493));
        CopySpec childSpec = project.copySpec();
        childSpec.from(new Object[]{project.file((Object)"src/dist")});
        childSpec.with(new CopySpec[]{libChildSpec});
        childSpec.with(new CopySpec[]{binChildSpec});
        distSpec.with(new CopySpec[]{childSpec});
        distSpec.with(new CopySpec[]{pluginConvention.getApplicationDistribution()});
        return distSpec;
    }

    private static class PreventDestinationOverwrite
    implements Action<Task> {
        private final Provider<String> applicationName;
        private final Provider<String> executableDir;

        private PreventDestinationOverwrite(Provider<String> applicationName, Provider<String> executableDir) {
            this.applicationName = applicationName;
            this.executableDir = executableDir;
        }

        public void execute(Task task) {
            Sync sync = (Sync)task;
            File destinationDir = sync.getDestinationDir();
            if (destinationDir.isDirectory()) {
                String[] children = destinationDir.list();
                if (children == null) {
                    throw new UncheckedIOException("Could not list directory " + destinationDir);
                }
                if (!(children.length <= 0 || new File(destinationDir, "lib").isDirectory() && new File(destinationDir, (String)this.executableDir.get()).isDirectory())) {
                    throw new GradleException("The specified installation directory '" + destinationDir + "' is neither empty nor does it contain an installation for '" + (String)this.applicationName.get() + "'.\nIf you really want to install to this directory, delete it and run the install task again.\nAlternatively, choose a different installation directory.");
                }
            }
        }
    }
}

