/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.rhino;

import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.plugins.javascript.base.JavaScriptBasePlugin;
import org.gradle.plugins.javascript.base.JavaScriptExtension;
import org.gradle.plugins.javascript.rhino.RhinoExtension;
import org.gradle.plugins.javascript.rhino.RhinoShellExec;

public class RhinoPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        DeprecationLogger.deprecatePlugin((String)"org.gradle.rhino").withUpgradeGuideSection(5, "deprecated_plugins").nagUser();
        project.getPluginManager().apply(JavaScriptBasePlugin.class);
        JavaScriptExtension jsExtension = (JavaScriptExtension)project.getExtensions().findByType(JavaScriptExtension.class);
        final RhinoExtension rhinoExtension = (RhinoExtension)((ExtensionAware)jsExtension).getExtensions().create("rhino", RhinoExtension.class, new Object[0]);
        final Configuration configuration = this.addClasspathConfiguration(project.getConfigurations());
        this.configureDefaultRhinoDependency(configuration, project.getDependencies(), rhinoExtension);
        ConventionMapping conventionMapping = ((IConventionAware)rhinoExtension).getConventionMapping();
        conventionMapping.map("classpath", (Callable)new Callable<Configuration>(){

            @Override
            public Configuration call() {
                return configuration;
            }
        });
        conventionMapping.map("version", (Callable)new Callable<String>(){

            @Override
            public String call() {
                return "1.7R3";
            }
        });
        project.getTasks().withType(RhinoShellExec.class, (Action)new Action<RhinoShellExec>(){

            public void execute(RhinoShellExec task) {
                task.getConventionMapping().map("classpath", (Callable)new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() {
                        return rhinoExtension.getClasspath();
                    }
                });
                task.getConventionMapping().map("main", (Callable)new Callable<String>(){

                    @Override
                    public String call() {
                        return "org.mozilla.javascript.tools.shell.Main";
                    }
                });
                task.setClasspath(rhinoExtension.getClasspath());
            }
        });
    }

    private Configuration addClasspathConfiguration(ConfigurationContainer configurations) {
        Configuration configuration = (Configuration)configurations.create("rhinoPluginRhinoClasspath");
        configuration.setVisible(false);
        configuration.setDescription("The default Rhino classpath");
        return configuration;
    }

    public void configureDefaultRhinoDependency(Configuration configuration, final DependencyHandler dependencyHandler, final RhinoExtension extension) {
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencies) {
                Dependency dependency = dependencyHandler.create((Object)("org.mozilla:rhino:" + extension.getVersion()));
                dependencies.add((Object)dependency);
            }
        });
    }
}

