/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.locking;

import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyLockingHandler;
import org.gradle.api.artifacts.dsl.LockMode;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;

public class DefaultDependencyLockingHandler
implements DependencyLockingHandler {
    private static final Action<Configuration> ACTIVATE_LOCKING = configuration -> configuration.getResolutionStrategy().activateDependencyLocking();
    private static final Action<Configuration> DEACTIVATE_LOCKING = configuration -> configuration.getResolutionStrategy().deactivateDependencyLocking();
    private final ConfigurationContainer configurationContainer;
    private final DependencyLockingProvider dependencyLockingProvider;

    public DefaultDependencyLockingHandler(ConfigurationContainer configurationContainer, DependencyLockingProvider dependencyLockingProvider) {
        this.configurationContainer = configurationContainer;
        this.dependencyLockingProvider = dependencyLockingProvider;
    }

    public void lockAllConfigurations() {
        this.configurationContainer.all(ACTIVATE_LOCKING);
    }

    public void unlockAllConfigurations() {
        this.configurationContainer.all(DEACTIVATE_LOCKING);
    }

    public LockMode getLockMode() {
        return this.dependencyLockingProvider.getLockMode();
    }

    public void setLockMode(LockMode mode) {
        this.dependencyLockingProvider.setLockMode(mode);
    }
}

