/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetadata;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCachesProvider;
import org.gradle.api.internal.artifacts.ivyservice.DefaultArtifactCacheMetadata;
import org.gradle.api.internal.artifacts.ivyservice.ReadOnlyArtifactCacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.WritableArtifactCacheLockingManager;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.CacheScopeMapping;
import org.gradle.cache.internal.UsedGradleVersions;
import org.gradle.internal.Factory;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.serialize.Serializer;
import org.gradle.util.IncubationLogger;

public class DefaultArtifactCaches
implements ArtifactCachesProvider {
    private final DefaultArtifactCacheMetadata writableCacheMetadata;
    private final DefaultArtifactCacheMetadata readOnlyCacheMetadata;
    private final LateInitWritableArtifactCacheLockingManager writableArtifactCacheLockingManager;
    private final ReadOnlyArtifactCacheLockingManager readOnlyArtifactCacheLockingManager;

    public DefaultArtifactCaches(CacheScopeMapping cacheScopeMapping, CacheRepository cacheRepository, Factory<WritableArtifactCacheLockingParameters> writableArtifactCacheLockingParametersFactory) {
        this.writableCacheMetadata = new DefaultArtifactCacheMetadata(cacheScopeMapping);
        this.writableArtifactCacheLockingManager = new LateInitWritableArtifactCacheLockingManager(() -> {
            WritableArtifactCacheLockingParameters params = (WritableArtifactCacheLockingParameters)writableArtifactCacheLockingParametersFactory.create();
            return new WritableArtifactCacheLockingManager(cacheRepository, this.writableCacheMetadata, params.getFileAccessTimeJournal(), params.getUsedGradleVersions());
        });
        String roCache = System.getenv("GRADLE_RO_DEP_CACHE");
        if (StringUtils.isNotEmpty((String)roCache)) {
            IncubationLogger.incubatingFeatureUsed((String)"Shared read-only dependency cache");
            this.readOnlyCacheMetadata = new DefaultArtifactCacheMetadata(cacheScopeMapping, new File(roCache));
            this.readOnlyArtifactCacheLockingManager = new ReadOnlyArtifactCacheLockingManager(cacheRepository, this.readOnlyCacheMetadata);
        } else {
            this.readOnlyCacheMetadata = null;
            this.readOnlyArtifactCacheLockingManager = null;
        }
    }

    @Override
    public ArtifactCacheMetadata getWritableCacheMetadata() {
        return this.writableCacheMetadata;
    }

    @Override
    public Optional<ArtifactCacheMetadata> getReadOnlyCacheMetadata() {
        return Optional.ofNullable(this.readOnlyCacheMetadata);
    }

    @Override
    public ArtifactCacheLockingManager getWritableCacheLockingManager() {
        return this.writableArtifactCacheLockingManager;
    }

    @Override
    public Optional<ArtifactCacheLockingManager> getReadOnlyCacheLockingManager() {
        return Optional.ofNullable(this.readOnlyArtifactCacheLockingManager);
    }

    public List<File> getAdditiveCacheRoots() {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)4);
        builder.add((Object)this.writableCacheMetadata.getFileStoreDirectory());
        builder.add((Object)this.writableCacheMetadata.getTransformsStoreDirectory());
        if (this.readOnlyCacheMetadata != null) {
            builder.add((Object)this.readOnlyCacheMetadata.getFileStoreDirectory());
            builder.add((Object)this.readOnlyCacheMetadata.getTransformsStoreDirectory());
        }
        return builder.build();
    }

    @Override
    public void close() {
        this.writableArtifactCacheLockingManager.close();
        if (this.readOnlyArtifactCacheLockingManager != null) {
            this.readOnlyArtifactCacheLockingManager.close();
        }
    }

    private static class LateInitWritableArtifactCacheLockingManager
    implements ArtifactCacheLockingManager,
    Closeable {
        private final Factory<WritableArtifactCacheLockingManager> factory;
        private volatile WritableArtifactCacheLockingManager delegate;

        private LateInitWritableArtifactCacheLockingManager(Factory<WritableArtifactCacheLockingManager> factory) {
            this.factory = factory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WritableArtifactCacheLockingManager getDelegate() {
            if (this.delegate == null) {
                Factory<WritableArtifactCacheLockingManager> factory = this.factory;
                synchronized (factory) {
                    if (this.delegate == null) {
                        this.delegate = (WritableArtifactCacheLockingManager)this.factory.create();
                    }
                }
            }
            return this.delegate;
        }

        @Override
        public void close() {
            this.getDelegate().close();
        }

        public <T> T withFileLock(Factory<? extends T> action) {
            return this.getDelegate().withFileLock(action);
        }

        public void withFileLock(Runnable action) {
            this.getDelegate().withFileLock(action);
        }

        public <T> T useCache(Factory<? extends T> action) {
            return this.getDelegate().useCache(action);
        }

        public void useCache(Runnable action) {
            this.getDelegate().useCache(action);
        }

        @Override
        public <K, V> PersistentIndexedCache<K, V> createCache(String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
            return this.getDelegate().createCache(cacheName, keySerializer, valueSerializer);
        }
    }

    public static interface WritableArtifactCacheLockingParameters {
        public FileAccessTimeJournal getFileAccessTimeJournal();

        public UsedGradleVersions getUsedGradleVersions();
    }
}

