/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.InputArtifactDependencies;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ArtifactTransformRegistration;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformActionScheme;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformParameterScheme;
import org.gradle.api.internal.artifacts.transform.DefaultTransformer;
import org.gradle.api.internal.artifacts.transform.LegacyTransformer;
import org.gradle.api.internal.artifacts.transform.TransformationRegistrationFactory;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.api.internal.artifacts.transform.TransformerInvocationFactory;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.properties.FileParameterUtils;
import org.gradle.api.internal.tasks.properties.InputFilePropertyType;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.internal.tasks.properties.TypeMetadataStore;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.reflect.DefaultTypeValidationContext;
import org.gradle.internal.reflect.PropertyMetadata;
import org.gradle.internal.reflect.TypeValidationContext;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.model.internal.type.ModelType;

public class DefaultTransformationRegistrationFactory
implements TransformationRegistrationFactory {
    private final BuildOperationExecutor buildOperationExecutor;
    private final IsolatableFactory isolatableFactory;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final TransformerInvocationFactory transformerInvocationFactory;
    private final ValueSnapshotter valueSnapshotter;
    private final PropertyWalker parametersPropertyWalker;
    private final ServiceLookup internalServices;
    private final TypeMetadataStore actionMetadataStore;
    private final FileCollectionFactory fileCollectionFactory;
    private final FileLookup fileLookup;
    private final FileCollectionFingerprinterRegistry fileCollectionFingerprinterRegistry;
    private final DomainObjectContext owner;
    private final ProjectStateRegistry projectRegistry;
    private final InstantiationScheme actionInstantiationScheme;
    private final InstantiationScheme legacyActionInstantiationScheme;

    public DefaultTransformationRegistrationFactory(BuildOperationExecutor buildOperationExecutor, IsolatableFactory isolatableFactory, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, TransformerInvocationFactory transformerInvocationFactory, ValueSnapshotter valueSnapshotter, FileCollectionFactory fileCollectionFactory, FileLookup fileLookup, FileCollectionFingerprinterRegistry fileCollectionFingerprinterRegistry, DomainObjectContext owner, ProjectStateRegistry projectRegistry, ArtifactTransformParameterScheme parameterScheme, ArtifactTransformActionScheme actionScheme, ServiceLookup internalServices) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.isolatableFactory = isolatableFactory;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.transformerInvocationFactory = transformerInvocationFactory;
        this.valueSnapshotter = valueSnapshotter;
        this.fileCollectionFactory = fileCollectionFactory;
        this.fileLookup = fileLookup;
        this.fileCollectionFingerprinterRegistry = fileCollectionFingerprinterRegistry;
        this.owner = owner;
        this.projectRegistry = projectRegistry;
        this.actionInstantiationScheme = actionScheme.getInstantiationScheme();
        this.actionMetadataStore = actionScheme.getInspectionScheme().getMetadataStore();
        this.legacyActionInstantiationScheme = actionScheme.getLegacyInstantiationScheme();
        this.parametersPropertyWalker = parameterScheme.getInspectionScheme().getPropertyWalker();
        this.internalServices = internalServices;
    }

    @Override
    public ArtifactTransformRegistration create(ImmutableAttributes from, ImmutableAttributes to, Class<? extends TransformAction<?>> implementation, @Nullable TransformParameters parameterObject) {
        TypeMetadata actionMetadata = this.actionMetadataStore.getTypeMetadata(implementation);
        boolean cacheable = implementation.isAnnotationPresent(CacheableTransform.class);
        DefaultTypeValidationContext validationContext = DefaultTypeValidationContext.withoutRootType((boolean)cacheable);
        actionMetadata.visitValidationFailures(null, (TypeValidationContext)validationContext);
        Class inputArtifactNormalizer = null;
        Class dependenciesNormalizer = null;
        for (PropertyMetadata propertyMetadata : actionMetadata.getPropertiesMetadata()) {
            NormalizerCollectingVisitor visitor;
            Class propertyType = propertyMetadata.getPropertyType();
            if (propertyType.equals(InputArtifact.class)) {
                visitor = new NormalizerCollectingVisitor();
                actionMetadata.getAnnotationHandlerFor(propertyMetadata).visitPropertyValue(propertyMetadata.getPropertyName(), null, propertyMetadata, (PropertyVisitor)visitor, null);
                inputArtifactNormalizer = visitor.normalizer;
                DefaultTransformer.validateInputFileNormalizer(propertyMetadata.getPropertyName(), inputArtifactNormalizer, cacheable, (TypeValidationContext)validationContext);
                continue;
            }
            if (!propertyType.equals(InputArtifactDependencies.class)) continue;
            visitor = new NormalizerCollectingVisitor();
            actionMetadata.getAnnotationHandlerFor(propertyMetadata).visitPropertyValue(propertyMetadata.getPropertyName(), null, propertyMetadata, (PropertyVisitor)visitor, null);
            dependenciesNormalizer = visitor.normalizer;
            DefaultTransformer.validateInputFileNormalizer(propertyMetadata.getPropertyName(), dependenciesNormalizer, cacheable, (TypeValidationContext)validationContext);
        }
        ImmutableMap validationMessages = validationContext.getProblems();
        if (!validationMessages.isEmpty()) {
            String formatString = validationMessages.size() == 1 ? "A problem was found with the configuration of %s." : "Some problems were found with the configuration of %s.";
            throw new DefaultMultiCauseException(String.format(formatString, ModelType.of(implementation).getDisplayName()), (Iterable)validationMessages.keySet().stream().sorted().map(InvalidUserDataException::new).collect(Collectors.toList()));
        }
        DefaultTransformer transformer = new DefaultTransformer(implementation, parameterObject, null, from, FileParameterUtils.normalizerOrDefault(inputArtifactNormalizer), FileParameterUtils.normalizerOrDefault(dependenciesNormalizer), cacheable, this.buildOperationExecutor, this.classLoaderHierarchyHasher, this.isolatableFactory, this.valueSnapshotter, this.fileCollectionFactory, this.fileLookup, this.parametersPropertyWalker, this.actionInstantiationScheme, this.internalServices);
        return new DefaultArtifactTransformRegistration(from, to, new TransformationStep(transformer, this.transformerInvocationFactory, this.owner, this.projectRegistry, this.fileCollectionFingerprinterRegistry));
    }

    @Override
    public ArtifactTransformRegistration create(ImmutableAttributes from, ImmutableAttributes to, Class<? extends ArtifactTransform> implementation, Object[] params) {
        LegacyTransformer transformer = new LegacyTransformer(implementation, params, this.legacyActionInstantiationScheme, from, this.classLoaderHierarchyHasher, this.isolatableFactory);
        return new DefaultArtifactTransformRegistration(from, to, new TransformationStep(transformer, this.transformerInvocationFactory, this.owner, this.projectRegistry, this.fileCollectionFingerprinterRegistry));
    }

    private static class NormalizerCollectingVisitor
    extends PropertyVisitor.Adapter {
        private Class<? extends FileNormalizer> normalizer;

        private NormalizerCollectingVisitor() {
        }

        public void visitInputFileProperty(String propertyName, boolean optional, boolean skipWhenEmpty, boolean incremental, @Nullable Class<? extends FileNormalizer> fileNormalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
            this.normalizer = fileNormalizer;
        }
    }

    private static class DefaultArtifactTransformRegistration
    implements ArtifactTransformRegistration {
        private final ImmutableAttributes from;
        private final ImmutableAttributes to;
        private final TransformationStep transformationStep;

        public DefaultArtifactTransformRegistration(ImmutableAttributes from, ImmutableAttributes to, TransformationStep transformationStep) {
            this.from = from;
            this.to = to;
            this.transformationStep = transformationStep;
        }

        @Override
        public AttributeContainerInternal getFrom() {
            return this.from;
        }

        @Override
        public AttributeContainerInternal getTo() {
            return this.to;
        }

        @Override
        public TransformationStep getTransformationStep() {
            return this.transformationStep;
        }
    }
}

