/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

class TokenSequence {
    private static final Logger LOG = Logger.getInstance("#com.intellij.lang.impl.TokenSequence");
    final int[] lexStarts;
    final IElementType[] lexTypes;
    final int lexemeCount;

    TokenSequence(int[] lexStarts, IElementType[] lexTypes, int lexemeCount) {
        this.lexStarts = lexStarts;
        this.lexTypes = lexTypes;
        this.lexemeCount = lexemeCount;
        assert (lexemeCount < lexStarts.length);
        assert (lexemeCount < lexTypes.length);
    }

    void assertMatches(@NotNull CharSequence text2, @NotNull Lexer lexer) {
        if (text2 == null) {
            TokenSequence.$$$reportNull$$$0(0);
        }
        if (lexer == null) {
            TokenSequence.$$$reportNull$$$0(1);
        }
        TokenSequence sequence2 = new Builder(text2, lexer).performLexing();
        assert (this.lexemeCount == sequence2.lexemeCount);
        for (int j = 0; j <= this.lexemeCount; ++j) {
            if (sequence2.lexStarts[j] != this.lexStarts[j] || sequence2.lexTypes[j] != this.lexTypes[j]) assert (false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "lexer";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/com/intellij/lang/impl/TokenSequence";
        objectArray[2] = "assertMatches";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class Builder {
        private final CharSequence myText;
        private final Lexer myLexer;
        private int[] myLexStarts;
        private IElementType[] myLexTypes;

        Builder(@NotNull CharSequence text2, @NotNull Lexer lexer) {
            if (text2 == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (lexer == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myText = text2;
            this.myLexer = lexer;
            int approxLexCount = Math.max(10, this.myText.length() / 5);
            this.myLexStarts = new int[approxLexCount];
            this.myLexTypes = new IElementType[approxLexCount];
        }

        @NotNull
        TokenSequence performLexing() {
            IElementType type2;
            this.myLexer.start(this.myText);
            int i = 0;
            int offset2 = 0;
            while ((type2 = this.myLexer.getTokenType()) != null) {
                int tokenStart;
                if (i % 20 == 0) {
                    ProgressIndicatorProvider.checkCanceled();
                }
                if (i >= this.myLexTypes.length - 1) {
                    this.resizeLexemes(i * 3 / 2);
                }
                if ((tokenStart = this.myLexer.getTokenStart()) < offset2) {
                    this.reportDescendingOffsets(i, offset2, tokenStart);
                }
                this.myLexStarts[i] = offset2 = tokenStart;
                this.myLexTypes[i] = type2;
                ++i;
                this.myLexer.advance();
            }
            this.myLexStarts[i] = this.myText.length();
            TokenSequence tokenSequence = new TokenSequence(this.myLexStarts, this.myLexTypes, i);
            if (tokenSequence == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return tokenSequence;
        }

        private void reportDescendingOffsets(int tokenIndex, int offset2, int tokenStart) {
            StringBuilder sb = new StringBuilder();
            IElementType tokenType = this.myLexer.getTokenType();
            sb.append("Token sequence broken").append("\n  this: '").append(this.myLexer.getTokenText()).append("' (").append(tokenType).append(':').append(tokenType != null ? tokenType.getLanguage() : null).append(") ").append(tokenStart).append(":").append(this.myLexer.getTokenEnd());
            if (tokenIndex > 0) {
                int prevStart = this.myLexStarts[tokenIndex - 1];
                sb.append("\n  prev: '").append(this.myText.subSequence(prevStart, offset2)).append("' (").append(this.myLexTypes[tokenIndex - 1]).append(':').append(this.myLexTypes[tokenIndex - 1].getLanguage()).append(") ").append(prevStart).append(":").append(offset2);
            }
            int quoteStart = Math.max(tokenStart - 256, 0);
            int quoteEnd = Math.min(tokenStart + 256, this.myText.length());
            sb.append("\n  quote: [").append(quoteStart).append(':').append(quoteEnd).append("] '").append(this.myText.subSequence(quoteStart, quoteEnd)).append('\'');
            LOG.error(sb);
        }

        private void resizeLexemes(int newSize) {
            this.myLexStarts = ArrayUtil.realloc(this.myLexStarts, newSize);
            this.myLexTypes = ArrayUtil.realloc(this.myLexTypes, newSize, IElementType.ARRAY_FACTORY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lexer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/impl/TokenSequence$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/impl/TokenSequence$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "performLexing";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

