/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class PathFilter
extends TreeFilter {
    final String pathStr;
    final byte[] pathRaw;

    public static PathFilter create(String path) {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().emptyPathNotPermitted);
        }
        return new PathFilter(path);
    }

    private PathFilter(String s) {
        this.pathStr = s;
        this.pathRaw = Constants.encode(this.pathStr);
    }

    public String getPath() {
        return this.pathStr;
    }

    @Override
    public boolean include(TreeWalk walker) {
        return this.matchFilter(walker) <= 0;
    }

    @Override
    public int matchFilter(TreeWalk walker) {
        return walker.isPathMatch(this.pathRaw, this.pathRaw.length);
    }

    @Override
    public boolean shouldBeRecursive() {
        byte[] byArray = this.pathRaw;
        int n = this.pathRaw.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b == 47) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public PathFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return "PATH(\"" + this.pathStr + "\")";
    }

    public boolean isDone(TreeWalk walker) {
        return this.pathRaw.length == walker.getPathLength();
    }
}

