/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.BuilderCommon;
import org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.apache.maven.lifecycle.internal.ProjectSegment;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=BuildListCalculator.class)
public class BuildListCalculator {
    public ProjectBuildList calculateProjectBuilds(MavenSession session, List<TaskSegment> taskSegments) {
        ArrayList<ProjectSegment> projectBuilds = new ArrayList<ProjectSegment>();
        MavenProject rootProject = session.getTopLevelProject();
        for (TaskSegment taskSegment : taskSegments) {
            List<MavenProject> projects = taskSegment.isAggregating() ? Collections.singletonList(rootProject) : session.getProjects();
            for (MavenProject project : projects) {
                BuilderCommon.attachToThread(project);
                MavenSession copiedSession = session.clone();
                copiedSession.setCurrentProject(project);
                projectBuilds.add(new ProjectSegment(project, taskSegment, copiedSession));
            }
        }
        return new ProjectBuildList(projectBuilds);
    }
}

