/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.impl.IrErrorDeclarationImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrTypeAliasImpl;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.TypeTranslator;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.AnonymousInitializerGenerator;
import org.jetbrains.kotlin.psi2ir.generators.ClassGenerator;
import org.jetbrains.kotlin.psi2ir.generators.DeclarationGeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.FunctionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.Generator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.PropertyGenerator;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)J\u0016\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u00102\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)J\u000e\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u00020\u0012J\u0010\u00105\u001a\u00020\n2\u0006\u0010\u000b\u001a\u000206H\u0002J>\u00107\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u001e\u00108\u001a\u001a\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020;09H\u0002J\n\u0010<\u001a\u00020=*\u00020>R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/DeclarationGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/Generator;", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "(Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;)V", "getContext", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "typeTranslator", "Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "generateClassMemberDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ktDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "generateClassOrObjectDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "ktClassOrObject", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "generateEnumEntryDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "ktEnumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "generateFakeOverrideDeclaration", "memberDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "ktElement", "Lorg/jetbrains/kotlin/psi/KtPureElement;", "generateFakeOverrideFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateFakeOverrideProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "generateGlobalTypeParametersDeclarations", "", "irTypeParametersOwner", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "from", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "generateInitializerBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "scopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "ktBody", "Lorg/jetbrains/kotlin/psi/KtExpression;", "generateMemberDeclaration", "generateScopedTypeParameterDeclarations", "generateSyntheticClassOrObject", "syntheticDeclaration", "generateTypeAliasDeclaration", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "generateTypeParameterDeclarations", "declareTypeParameter", "Lkotlin/Function3;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "toIrType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/types/KotlinType;", "ir.psi2ir"})
public final class DeclarationGenerator
implements Generator {
    private final TypeTranslator typeTranslator;
    @NotNull
    private final GeneratorContext context;

    @NotNull
    public final IrType toIrType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return this.typeTranslator.translateType($receiver);
    }

    @NotNull
    public final IrDeclaration generateMemberDeclaration(@NotNull KtDeclaration ktDeclaration) {
        IrDeclaration irDeclaration;
        Intrinsics.checkParameterIsNotNull((Object)ktDeclaration, (String)"ktDeclaration");
        KtDeclaration ktDeclaration2 = ktDeclaration;
        if (ktDeclaration2 instanceof KtNamedFunction) {
            irDeclaration = new FunctionGenerator(this).generateFunctionDeclaration((KtNamedFunction)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtProperty) {
            irDeclaration = new PropertyGenerator(this).generatePropertyDeclaration((KtProperty)ktDeclaration);
        } else if (ktDeclaration2 instanceof KtClassOrObject) {
            irDeclaration = this.generateClassOrObjectDeclaration((KtPureClassOrObject)((Object)ktDeclaration));
        } else if (ktDeclaration2 instanceof KtTypeAlias) {
            irDeclaration = this.generateTypeAliasDeclaration((KtTypeAlias)ktDeclaration);
        } else {
            int n = PsiUtilsKt.getStartOffsetSkippingComments(ktDeclaration);
            int n2 = PsiUtilsKt.getEndOffset(ktDeclaration);
            ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
            Intrinsics.checkExpressionValueIsNotNull(readOnlySlice, (String)"BindingContext.DECLARATION_TO_DESCRIPTOR");
            DeclarationDescriptor declarationDescriptor = GeneratorKt.getOrFail(this, readOnlySlice, ktDeclaration);
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"getOrFail(BindingContext\u2026ESCRIPTOR, ktDeclaration)");
            irDeclaration = new IrErrorDeclarationImpl(n, n2, declarationDescriptor);
        }
        return irDeclaration;
    }

    @NotNull
    public final IrClass generateSyntheticClassOrObject(@NotNull KtPureClassOrObject syntheticDeclaration) {
        Intrinsics.checkParameterIsNotNull((Object)syntheticDeclaration, (String)"syntheticDeclaration");
        return this.generateClassOrObjectDeclaration(syntheticDeclaration);
    }

    @NotNull
    public final IrDeclaration generateClassMemberDeclaration(@NotNull KtDeclaration ktDeclaration, @NotNull ClassDescriptor classDescriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)ktDeclaration, (String)"ktDeclaration");
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor2, (String)"classDescriptor");
        KtDeclaration ktDeclaration2 = ktDeclaration;
        return ktDeclaration2 instanceof KtAnonymousInitializer ? new AnonymousInitializerGenerator(this).generateAnonymousInitializerDeclaration((KtAnonymousInitializer)ktDeclaration, classDescriptor2) : (ktDeclaration2 instanceof KtSecondaryConstructor ? (IrDeclaration)new FunctionGenerator(this).generateSecondaryConstructor((KtSecondaryConstructor)ktDeclaration) : (ktDeclaration2 instanceof KtEnumEntry ? (IrDeclaration)this.generateEnumEntryDeclaration((KtEnumEntry)ktDeclaration) : this.generateMemberDeclaration(ktDeclaration)));
    }

    private final IrEnumEntry generateEnumEntryDeclaration(KtEnumEntry ktEnumEntry) {
        return new ClassGenerator(this).generateEnumEntry(ktEnumEntry);
    }

    @NotNull
    public final IrClass generateClassOrObjectDeclaration(@NotNull KtPureClassOrObject ktClassOrObject) {
        Intrinsics.checkParameterIsNotNull((Object)ktClassOrObject, (String)"ktClassOrObject");
        return new ClassGenerator(this).generateClass(ktClassOrObject);
    }

    private final IrDeclaration generateTypeAliasDeclaration(KtTypeAlias ktDeclaration) {
        int n = PsiUtilsKt.getStartOffsetSkippingComments(ktDeclaration);
        int n2 = PsiUtilsKt.getEndOffset(ktDeclaration);
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
        WritableSlice<PsiElement, TypeAliasDescriptor> writableSlice = BindingContext.TYPE_ALIAS;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.TYPE_ALIAS");
        Object v2 = GeneratorKt.getOrFail(this, writableSlice, ktDeclaration);
        Intrinsics.checkExpressionValueIsNotNull(v2, (String)"getOrFail(BindingContext\u2026YPE_ALIAS, ktDeclaration)");
        return new IrTypeAliasImpl(n, n2, irDeclarationOrigin, (TypeAliasDescriptor)v2);
    }

    public final void generateGlobalTypeParametersDeclarations(@NotNull IrTypeParametersContainer irTypeParametersOwner, @NotNull List<? extends TypeParameterDescriptor> from) {
        Intrinsics.checkParameterIsNotNull((Object)irTypeParametersOwner, (String)"irTypeParametersOwner");
        Intrinsics.checkParameterIsNotNull(from, (String)"from");
        this.generateTypeParameterDeclarations(irTypeParametersOwner, from, (Function3<? super Integer, ? super Integer, ? super TypeParameterDescriptor, ? extends IrTypeParameter>)((Function3)new Function3<Integer, Integer, TypeParameterDescriptor, IrTypeParameter>(this){
            final /* synthetic */ DeclarationGenerator this$0;

            @NotNull
            public final IrTypeParameter invoke(int startOffset, int endOffset, @NotNull TypeParameterDescriptor typeParameterDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)typeParameterDescriptor, (String)"typeParameterDescriptor");
                return SymbolTable.declareGlobalTypeParameter$default(this.this$0.getContext().getSymbolTable(), startOffset, endOffset, IrDeclarationOrigin.DEFINED.INSTANCE, typeParameterDescriptor, null, 16, null);
            }
            {
                this.this$0 = declarationGenerator;
                super(3);
            }
        }));
    }

    public final void generateScopedTypeParameterDeclarations(@NotNull IrTypeParametersContainer irTypeParametersOwner, @NotNull List<? extends TypeParameterDescriptor> from) {
        Intrinsics.checkParameterIsNotNull((Object)irTypeParametersOwner, (String)"irTypeParametersOwner");
        Intrinsics.checkParameterIsNotNull(from, (String)"from");
        this.generateTypeParameterDeclarations(irTypeParametersOwner, from, (Function3<? super Integer, ? super Integer, ? super TypeParameterDescriptor, ? extends IrTypeParameter>)((Function3)new Function3<Integer, Integer, TypeParameterDescriptor, IrTypeParameter>(this){
            final /* synthetic */ DeclarationGenerator this$0;

            @NotNull
            public final IrTypeParameter invoke(int startOffset, int endOffset, @NotNull TypeParameterDescriptor typeParameterDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)typeParameterDescriptor, (String)"typeParameterDescriptor");
                return SymbolTable.declareScopedTypeParameter$default(this.this$0.getContext().getSymbolTable(), startOffset, endOffset, IrDeclarationOrigin.DEFINED.INSTANCE, typeParameterDescriptor, null, 16, null);
            }
            {
                this.this$0 = declarationGenerator;
                super(3);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void generateTypeParameterDeclarations(IrTypeParametersContainer irTypeParametersOwner, List<? extends TypeParameterDescriptor> from, Function3<? super Integer, ? super Integer, ? super TypeParameterDescriptor, ? extends IrTypeParameter> declareTypeParameter) {
        Object object;
        Collection collection;
        void $receiver$iv;
        Iterable iterable = from;
        Collection destination$iv = irTypeParametersOwner.getTypeParameters();
        for (Object item$iv : $receiver$iv) {
            void typeParameterDescriptor;
            TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)item$iv;
            collection = destination$iv;
            PsiElement ktTypeParameterDeclaration = DescriptorToSourceUtils.getSourceFromDescriptor((DeclarationDescriptor)typeParameterDescriptor);
            int startOffset = KotlinUtilsKt.getStartOffsetOrUndefined(ktTypeParameterDeclaration);
            int endOffset = KotlinUtilsKt.getEndOffsetOrUndefined(ktTypeParameterDeclaration);
            object = (IrTypeParameter)declareTypeParameter.invoke((Object)startOffset, (Object)endOffset, (Object)typeParameterDescriptor);
            collection.add(object);
        }
        for (IrTypeParameter irTypeParameter : irTypeParametersOwner.getTypeParameters()) {
            void $receiver$iv2;
            List<KotlinType> list2 = irTypeParameter.getDescriptor().getUpperBounds();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"irTypeParameter.descriptor.upperBounds");
            Iterable iterable2 = list2;
            Collection destination$iv2 = irTypeParameter.getSuperTypes();
            for (Object item$iv : $receiver$iv2) {
                void it;
                KotlinType startOffset = (KotlinType)item$iv;
                collection = destination$iv2;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                object = this.toIrType((KotlinType)v1);
                collection.add(object);
            }
        }
    }

    @NotNull
    public final IrExpressionBody generateInitializerBody(@NotNull IrSymbol scopeOwnerSymbol, @NotNull KtExpression ktBody) {
        Intrinsics.checkParameterIsNotNull((Object)scopeOwnerSymbol, (String)"scopeOwnerSymbol");
        Intrinsics.checkParameterIsNotNull((Object)ktBody, (String)"ktBody");
        return DeclarationGeneratorKt.createBodyGenerator(this, scopeOwnerSymbol).generateExpressionBody(ktBody);
    }

    @NotNull
    public final IrDeclaration generateFakeOverrideDeclaration(@NotNull CallableMemberDescriptor memberDescriptor, @NotNull KtPureElement ktElement) {
        IrDeclarationWithVisibility irDeclarationWithVisibility;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)memberDescriptor, (String)"memberDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)ktElement, (String)"ktElement");
        boolean bl2 = bl = memberDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Fake override expected: " + memberDescriptor;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        CallableMemberDescriptor callableMemberDescriptor = memberDescriptor;
        if (callableMemberDescriptor instanceof FunctionDescriptor) {
            irDeclarationWithVisibility = this.generateFakeOverrideFunction((FunctionDescriptor)memberDescriptor, ktElement);
        } else if (callableMemberDescriptor instanceof PropertyDescriptor) {
            irDeclarationWithVisibility = this.generateFakeOverrideProperty((PropertyDescriptor)memberDescriptor, ktElement);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected member descriptor: " + memberDescriptor)));
        }
        return irDeclarationWithVisibility;
    }

    private final IrProperty generateFakeOverrideProperty(PropertyDescriptor propertyDescriptor2, KtPureElement ktElement) {
        return new PropertyGenerator(this).generateFakeOverrideProperty(propertyDescriptor2, ktElement);
    }

    private final IrSimpleFunction generateFakeOverrideFunction(FunctionDescriptor functionDescriptor, KtPureElement ktElement) {
        return new FunctionGenerator(this).generateFakeOverrideFunction(functionDescriptor, ktElement);
    }

    @Override
    @NotNull
    public GeneratorContext getContext() {
        return this.context;
    }

    public DeclarationGenerator(@NotNull GeneratorContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.typeTranslator = this.getContext().getTypeTranslator();
    }
}

