/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.TaskFingerprinter;
import org.gradle.api.internal.tasks.properties.CacheableOutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.FilePropertySpec;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.StopActionException;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.internal.execution.CacheHandler;
import org.gradle.internal.execution.ExecutionException;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkExecutor;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.OutputFilesRepository;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.OutputFileChanges;
import org.gradle.internal.execution.impl.OutputFilterUtil;
import org.gradle.internal.execution.impl.steps.UpToDateResult;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.work.AsyncWorkTracker;

public class ExecuteActionsTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = Logging.getLogger(ExecuteActionsTaskExecuter.class);
    private final boolean buildCacheEnabled;
    private final TaskFingerprinter taskFingerprinter;
    private final ExecutionHistoryStore executionHistoryStore;
    private final OutputFilesRepository outputFilesRepository;
    private final BuildOperationExecutor buildOperationExecutor;
    private final AsyncWorkTracker asyncWorkTracker;
    private final TaskActionListener actionListener;
    private final WorkExecutor<UpToDateResult> workExecutor;

    public ExecuteActionsTaskExecuter(boolean buildCacheEnabled, TaskFingerprinter taskFingerprinter, ExecutionHistoryStore executionHistoryStore, OutputFilesRepository outputFilesRepository, BuildOperationExecutor buildOperationExecutor, AsyncWorkTracker asyncWorkTracker, TaskActionListener actionListener, WorkExecutor<UpToDateResult> workExecutor) {
        this.buildCacheEnabled = buildCacheEnabled;
        this.taskFingerprinter = taskFingerprinter;
        this.executionHistoryStore = executionHistoryStore;
        this.outputFilesRepository = outputFilesRepository;
        this.buildOperationExecutor = buildOperationExecutor;
        this.asyncWorkTracker = asyncWorkTracker;
        this.actionListener = actionListener;
        this.workExecutor = workExecutor;
    }

    @Override
    public TaskExecuterResult execute(final TaskInternal task, final TaskStateInternal state, TaskExecutionContext context) {
        final UpToDateResult result = (UpToDateResult)this.workExecutor.execute((UnitOfWork)new TaskExecution(task, context));
        result.getOutcome().ifSuccessfulOrElse((Consumer)new Consumer<ExecutionOutcome>(){

            @Override
            public void accept(ExecutionOutcome outcome) {
                state.setOutcome(TaskExecutionOutcome.valueOf(outcome));
            }
        }, (Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable failure) {
                state.setOutcome((RuntimeException)((Object)(failure instanceof ExecutionException ? new TaskExecutionException(task, failure.getCause()) : new TaskExecutionException(task, failure))));
            }
        });
        context.setUpToDateMessages((List<String>)result.getOutOfDateReasons());
        return new TaskExecuterResult(){

            @Override
            public Optional<OriginMetadata> getReusedOutputOriginMetadata() {
                return result.isReused() ? Optional.of(result.getOriginMetadata()) : Optional.empty();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeActions(TaskInternal task, TaskExecutionContext context) {
        for (ContextAwareTaskAction action : new ArrayList<ContextAwareTaskAction>(task.getTaskActions())) {
            task.getState().setDidWork(true);
            task.getStandardOutputCapture().start();
            try {
                this.executeAction(action.getDisplayName(), task, action, context);
            }
            catch (StopActionException e) {
                LOGGER.debug("Action stopped by some action with message: {}", (Object)e.getMessage());
            }
            catch (StopExecutionException e) {
                LOGGER.info("Execution stopped by some action with message: {}", (Object)e.getMessage());
                break;
            }
            finally {
                task.getStandardOutputCapture().stop();
            }
        }
    }

    private void executeAction(final String actionDisplayName, final TaskInternal task, final ContextAwareTaskAction action, TaskExecutionContext context) {
        action.contextualise(context);
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)(actionDisplayName + " for " + task.getIdentityPath().getPath())).name(actionDisplayName);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(BuildOperationContext context) {
                BuildOperationRef currentOperation = ExecuteActionsTaskExecuter.this.buildOperationExecutor.getCurrentOperation();
                Throwable actionFailure = null;
                try {
                    action.execute(task);
                }
                catch (Throwable t) {
                    actionFailure = t;
                }
                finally {
                    action.releaseContext();
                }
                try {
                    ExecuteActionsTaskExecuter.this.asyncWorkTracker.waitForCompletion(currentOperation, true);
                }
                catch (Throwable t) {
                    ArrayList failures = Lists.newArrayList();
                    if (actionFailure != null) {
                        failures.add(actionFailure);
                    }
                    if (t instanceof MultiCauseException) {
                        failures.addAll(((MultiCauseException)t).getCauses());
                    } else {
                        failures.add(t);
                    }
                    if (failures.size() > 1) {
                        throw new MultipleTaskActionFailures("Multiple task action failures occurred:", failures);
                    }
                    throw UncheckedException.throwAsUncheckedException((Throwable)((Throwable)failures.get(0)));
                }
                if (actionFailure != null) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)actionFailure);
                }
            }
        });
    }

    @Contextual
    private static class MultipleTaskActionFailures
    extends DefaultMultiCauseException {
        public MultipleTaskActionFailures(String message, Iterable<? extends Throwable> causes) {
            super(message, causes);
        }
    }

    private class TaskExecution
    implements UnitOfWork {
        private final TaskInternal task;
        private final TaskExecutionContext context;

        public TaskExecution(TaskInternal task, TaskExecutionContext context) {
            this.task = task;
            this.context = context;
        }

        public String getIdentity() {
            return this.task.getPath();
        }

        public ExecutionOutcome execute() {
            this.task.getState().setExecuting(true);
            try {
                LOGGER.debug("Executing actions for {}.", (Object)this.task);
                ExecuteActionsTaskExecuter.this.actionListener.beforeActions((Task)this.task);
                ExecuteActionsTaskExecuter.this.executeActions(this.task, this.context);
                ExecutionOutcome executionOutcome = this.task.getState().getDidWork() ? ExecutionOutcome.EXECUTED : ExecutionOutcome.UP_TO_DATE;
                return executionOutcome;
            }
            finally {
                this.task.getState().setExecuting(false);
                ExecuteActionsTaskExecuter.this.actionListener.afterActions((Task)this.task);
            }
        }

        public void visitOutputProperties(UnitOfWork.OutputPropertyVisitor visitor) {
            for (OutputFilePropertySpec property : this.context.getTaskProperties().getOutputFileProperties()) {
                visitor.visitOutputProperty(property.getPropertyName(), property.getOutputType(), property.getPropertyFiles());
            }
        }

        public void visitOutputTrees(CacheableEntity.CacheableTreeVisitor visitor) {
            for (OutputFilePropertySpec property : this.context.getTaskProperties().getOutputFileProperties()) {
                if (!(property instanceof CacheableOutputFilePropertySpec)) {
                    throw new IllegalStateException("Non-cacheable property: " + property);
                }
                File cacheRoot = ((CacheableOutputFilePropertySpec)property).getOutputFile();
                if (cacheRoot == null) continue;
                visitor.visitOutputTree(property.getPropertyName(), property.getOutputType(), cacheRoot);
            }
        }

        public void visitLocalState(CacheableEntity.LocalStateVisitor visitor) {
            for (File localStateFile : this.context.getTaskProperties().getLocalStateFiles()) {
                visitor.visitLocalStateRoot(localStateFile);
            }
        }

        public Optional<ExecutionStateChanges> getChangesSincePreviousExecution() {
            return this.context.getExecutionStateChanges();
        }

        public Optional<? extends Iterable<String>> getChangingOutputs() {
            return Optional.empty();
        }

        public CacheHandler createCacheHandler() {
            return new CacheHandler(){

                public <T> Optional<T> load(Function<BuildCacheKey, T> loader) {
                    if (TaskExecution.this.task.isHasCustomActions()) {
                        LOGGER.info("Custom actions are attached to {}.", (Object)TaskExecution.this.task);
                    }
                    if (TaskExecution.this.context.isTaskCachingEnabled() && TaskExecution.this.context.getTaskExecutionMode().isAllowedToUseCachedResults() && TaskExecution.this.context.getBuildCacheKey().isValid()) {
                        return Optional.ofNullable(loader.apply(TaskExecution.this.context.getBuildCacheKey()));
                    }
                    return Optional.empty();
                }

                public void store(Consumer<BuildCacheKey> storer) {
                    if (ExecuteActionsTaskExecuter.this.buildCacheEnabled && TaskExecution.this.context.isTaskCachingEnabled() && TaskExecution.this.context.getBuildCacheKey().isValid()) {
                        storer.accept(TaskExecution.this.context.getBuildCacheKey());
                    }
                }
            };
        }

        public void outputsRemovedAfterFailureToLoadFromCache() {
            this.context.setOutputRemovedBeforeExecution(true);
        }

        public Optional<Duration> getTimeout() {
            return Optional.ofNullable(this.task.getTimeout().getOrNull());
        }

        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshotAfterOutputsGenerated() {
            final AfterPreviousExecutionState afterPreviousExecutionState = this.context.getAfterPreviousExecution();
            final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputsAfterExecution = ExecuteActionsTaskExecuter.this.taskFingerprinter.fingerprintTaskFiles(this.task, (SortedSet<? extends FilePropertySpec>)this.context.getTaskProperties().getOutputFileProperties());
            return this.context.getOverlappingOutputs().map(new Function<OverlappingOutputs, ImmutableSortedMap<String, CurrentFileCollectionFingerprint>>(){

                @Override
                public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> apply(OverlappingOutputs overlappingOutputs) {
                    return OutputFilterUtil.filterOutputFingerprints((ImmutableSortedMap)(afterPreviousExecutionState == null ? null : afterPreviousExecutionState.getOutputFileProperties()), TaskExecution.this.context.getOutputFilesBeforeExecution(), (ImmutableSortedMap)outputsAfterExecution);
                }
            }).orElse(outputsAfterExecution);
        }

        public void persistResult(final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> finalOutputs, final boolean successful, final OriginMetadata originMetadata) {
            AfterPreviousExecutionState afterPreviousExecutionState = this.context.getAfterPreviousExecution();
            if (successful || afterPreviousExecutionState == null || this.hasAnyOutputFileChanges((ImmutableSortedMap<String, FileCollectionFingerprint>)afterPreviousExecutionState.getOutputFileProperties(), finalOutputs)) {
                this.context.getBeforeExecutionState().ifPresent(new Consumer<BeforeExecutionState>(){

                    @Override
                    public void accept(BeforeExecutionState execution) {
                        ExecuteActionsTaskExecuter.this.executionHistoryStore.store(TaskExecution.this.task.getPath(), originMetadata, execution.getImplementation(), execution.getAdditionalImplementations(), execution.getInputProperties(), execution.getInputFileProperties(), finalOutputs, successful);
                        ExecuteActionsTaskExecuter.this.outputFilesRepository.recordOutputs((Iterable)finalOutputs.values());
                    }
                });
            }
        }

        private boolean hasAnyOutputFileChanges(ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current) {
            return !previous.keySet().equals((Object)current.keySet()) || new OutputFileChanges(previous, current).hasAnyChanges();
        }

        public long markExecutionTime() {
            return this.context.markExecutionTime();
        }

        public String getDisplayName() {
            return this.task.toString();
        }
    }
}

