/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.rubygrapefruit.platform.ProcessLauncher;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.process.internal.DefaultExecHandle;
import org.gradle.process.internal.ProcessBuilderFactory;
import org.gradle.process.internal.StreamsHandler;

public class ExecHandleRunner
implements Runnable {
    private static final Logger LOGGER = Logging.getLogger(ExecHandleRunner.class);
    private final ProcessBuilderFactory processBuilderFactory;
    private final DefaultExecHandle execHandle;
    private final Lock lock = new ReentrantLock();
    private final ProcessLauncher processLauncher;
    private final Executor executor;
    private Process process;
    private boolean aborted;
    private final StreamsHandler streamsHandler;

    public ExecHandleRunner(DefaultExecHandle execHandle, StreamsHandler streamsHandler, ProcessLauncher processLauncher, Executor executor) {
        this.processLauncher = processLauncher;
        this.executor = executor;
        if (execHandle == null) {
            throw new IllegalArgumentException("execHandle == null!");
        }
        this.streamsHandler = streamsHandler;
        this.processBuilderFactory = new ProcessBuilderFactory();
        this.execHandle = execHandle;
    }

    public void abortProcess() {
        this.lock.lock();
        try {
            if (this.aborted) {
                return;
            }
            this.aborted = true;
            if (this.process != null) {
                this.streamsHandler.disconnect();
                LOGGER.debug("Abort requested. Destroying process: {}.", (Object)this.execHandle.getDisplayName());
                this.process.destroy();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void run() {
        try {
            this.startProcess();
            this.execHandle.started();
            LOGGER.debug("waiting until streams are handled...");
            this.streamsHandler.start();
            if (this.execHandle.isDaemon()) {
                this.streamsHandler.stop();
                this.detached();
            } else {
                int exitValue = this.process.waitFor();
                this.streamsHandler.stop();
                this.completed(exitValue);
            }
        }
        catch (Throwable t) {
            this.execHandle.failed(t);
        }
    }

    private void startProcess() {
        this.lock.lock();
        try {
            if (this.aborted) {
                throw new IllegalStateException("Process has already been aborted");
            }
            ProcessBuilder processBuilder = this.processBuilderFactory.createProcessBuilder(this.execHandle);
            Process process = this.processLauncher.start(processBuilder);
            this.streamsHandler.connectStreams(process, this.execHandle.getDisplayName(), this.executor);
            this.process = process;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void completed(int exitValue) {
        if (this.aborted) {
            this.execHandle.aborted(exitValue);
        } else {
            this.execHandle.finished(exitValue);
        }
    }

    private void detached() {
        this.execHandle.detached();
    }
}

