/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.types.KotlinType;

public class TemporaryVariable {
    @Nullable
    private final JsExpression assignmentExpression;
    @NotNull
    private final JsName variableName;
    @Nullable
    private final KotlinType type;

    static TemporaryVariable create(@NotNull JsName temporaryName, @Nullable JsExpression initExpression) {
        JsBinaryOperation rhs = null;
        KotlinType type2 = null;
        if (initExpression != null) {
            rhs = JsAstUtils.assignment(temporaryName.makeRef(), initExpression);
            rhs.source(initExpression.getSource());
            MetadataProperties.setSynthetic(rhs, true);
            type2 = MetadataProperties.getType(initExpression);
        }
        return new TemporaryVariable(temporaryName, rhs, type2);
    }

    protected TemporaryVariable(@NotNull JsName temporaryName, @Nullable JsExpression assignmentExpression, @Nullable KotlinType type2) {
        this.variableName = temporaryName;
        this.assignmentExpression = assignmentExpression;
        this.type = type2;
    }

    @NotNull
    public JsNameRef reference() {
        JsNameRef result2 = this.variableName.makeRef();
        MetadataProperties.setSynthetic(result2, true);
        MetadataProperties.setType(result2, this.type);
        return result2;
    }

    @NotNull
    public JsName name() {
        return this.variableName;
    }

    @NotNull
    public JsExpression assignmentExpression() {
        assert (this.assignmentExpression != null);
        return this.assignmentExpression;
    }

    @NotNull
    public JsStatement assignmentStatement() {
        return JsAstUtils.asSyntheticStatement(this.assignmentExpression());
    }
}

