/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import com.google.common.util.concurrent.Callables;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.SourceSet;
import org.gradle.util.DeprecationLogger;

public class CheckstylePlugin
extends AbstractCodeQualityPlugin<Checkstyle> {
    public static final String DEFAULT_CHECKSTYLE_VERSION = "6.19";
    private static final String CONFIG_DIR_NAME = "config/checkstyle";
    private CheckstyleExtension extension;

    @Override
    protected String getToolName() {
        return "Checkstyle";
    }

    @Override
    protected Class<Checkstyle> getTaskType() {
        return Checkstyle.class;
    }

    @Override
    protected CodeQualityExtension createExtension() {
        this.extension = (CheckstyleExtension)this.project.getExtensions().create("checkstyle", CheckstyleExtension.class, new Object[]{this.project});
        this.extension.setToolVersion(DEFAULT_CHECKSTYLE_VERSION);
        this.extension.getConfigDirectory().set(this.determineConfigurationDirectory());
        this.extension.setConfig(this.project.getResources().getText().fromFile((Object)new Callable<File>(){

            @Override
            public File call() {
                return new File(CheckstylePlugin.this.extension.getConfigDir(), "checkstyle.xml");
            }
        }));
        return this.extension;
    }

    private Provider<Directory> determineConfigurationDirectory() {
        return this.project.provider((Callable)new Callable<Directory>(){

            @Override
            public Directory call() {
                if (CheckstylePlugin.this.usesSubprojectCheckstyleConfiguration()) {
                    DeprecationLogger.nagUserOfDeprecated((String)"Setting the Checkstyle configuration file under 'config/checkstyle' of a sub project", (String)"Use the root project's 'config/checkstyle' directory instead");
                    return CheckstylePlugin.this.project.getLayout().getProjectDirectory().dir(CheckstylePlugin.CONFIG_DIR_NAME);
                }
                return CheckstylePlugin.this.project.getRootProject().getLayout().getProjectDirectory().dir(CheckstylePlugin.CONFIG_DIR_NAME);
            }
        });
    }

    private boolean usesSubprojectCheckstyleConfiguration() {
        return !this.isRootProject() && this.project.file((Object)CONFIG_DIR_NAME).isDirectory();
    }

    private boolean isRootProject() {
        return this.project.equals(this.project.getRootProject());
    }

    @Override
    protected void configureConfiguration(Configuration configuration) {
        this.configureDefaultDependencies(configuration);
    }

    @Override
    protected void configureTaskDefaults(Checkstyle task, String baseName) {
        Configuration configuration = this.project.getConfigurations().getAt(this.getConfigurationName());
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencies) {
                dependencies.add((Object)CheckstylePlugin.this.project.getDependencies().create((Object)("com.puppycrawl.tools:checkstyle:" + CheckstylePlugin.this.extension.getToolVersion())));
            }
        });
    }

    private void configureTaskConventionMapping(Configuration configuration, Checkstyle task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("checkstyleClasspath", Callables.returning((Object)configuration));
        taskMapping.map("config", (Callable)new Callable<TextResource>(){

            @Override
            public TextResource call() {
                return CheckstylePlugin.this.extension.getConfig();
            }
        });
        taskMapping.map("configProperties", (Callable)new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() {
                return CheckstylePlugin.this.extension.getConfigProperties();
            }
        });
        taskMapping.map("ignoreFailures", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return CheckstylePlugin.this.extension.isIgnoreFailures();
            }
        });
        taskMapping.map("showViolations", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return CheckstylePlugin.this.extension.isShowViolations();
            }
        });
        taskMapping.map("maxErrors", (Callable)new Callable<Integer>(){

            @Override
            public Integer call() {
                return CheckstylePlugin.this.extension.getMaxErrors();
            }
        });
        taskMapping.map("maxWarnings", (Callable)new Callable<Integer>(){

            @Override
            public Integer call() {
                return CheckstylePlugin.this.extension.getMaxWarnings();
            }
        });
        task.setConfigDir((Provider<File>)this.project.provider((Callable)new Callable<File>(){

            @Override
            public File call() {
                return CheckstylePlugin.this.extension.getConfigDir();
            }
        }));
    }

    private void configureReportsConventionMapping(Checkstyle task, final String baseName) {
        task.getReports().all((Action)new Action<SingleFileReport>(){

            public void execute(final SingleFileReport report) {
                ConventionMapping reportMapping = CheckstylePlugin.conventionMappingOf(report);
                reportMapping.map("enabled", Callables.returning((Object)true));
                reportMapping.map("destination", (Callable)new Callable<File>(){

                    @Override
                    public File call() {
                        return new File(CheckstylePlugin.this.extension.getReportsDir(), baseName + "." + report.getName());
                    }
                });
            }
        });
    }

    @Override
    protected void configureForSourceSet(SourceSet sourceSet, Checkstyle task) {
        task.setDescription("Run Checkstyle analysis for " + sourceSet.getName() + " classes");
        task.setClasspath(sourceSet.getOutput().plus(sourceSet.getCompileClasspath()));
        task.setSource((FileTree)sourceSet.getAllJava());
    }
}

