/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.CachingTaskDependencyResolveContext;
import org.gradle.execution.taskgraph.WorkInfo;
import org.gradle.execution.taskgraph.WorkInfoDependencyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class TaskDependencyResolver {
    private final List<WorkInfoDependencyResolver> workResolvers;
    private CachingTaskDependencyResolveContext<WorkInfo> context;

    public TaskDependencyResolver(List<WorkInfoDependencyResolver> workResolvers) {
        this.workResolvers = workResolvers;
        this.context = TaskDependencyResolver.createTaskDependencyResolverContext(workResolvers);
    }

    public void clear() {
        this.context = TaskDependencyResolver.createTaskDependencyResolverContext(this.workResolvers);
    }

    private static CachingTaskDependencyResolveContext<WorkInfo> createTaskDependencyResolverContext(List<WorkInfoDependencyResolver> workResolvers) {
        return new CachingTaskDependencyResolveContext<WorkInfo>(workResolvers);
    }

    public Set<WorkInfo> resolveDependenciesFor(@Nullable TaskInternal task, Object dependencies) {
        return this.context.getDependencies(task, dependencies);
    }
}

