/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.Transformer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.execution.taskgraph.TaskExecutionPlan;
import org.gradle.execution.taskgraph.TaskPlanExecutor;
import org.gradle.execution.taskgraph.WorkInfo;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.resources.DefaultResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockState;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.TimeFormatting;
import org.gradle.internal.time.Timer;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class DefaultTaskPlanExecutor
implements TaskPlanExecutor {
    private static final Logger LOGGER = Logging.getLogger(DefaultTaskPlanExecutor.class);
    private final int executorCount;
    private final ExecutorFactory executorFactory;
    private final WorkerLeaseService workerLeaseService;
    private final BuildCancellationToken cancellationToken;
    private final ResourceLockCoordinationService coordinationService;

    public DefaultTaskPlanExecutor(ParallelismConfiguration parallelismConfiguration, ExecutorFactory executorFactory, WorkerLeaseService workerLeaseService, BuildCancellationToken cancellationToken, ResourceLockCoordinationService coordinationService) {
        this.executorFactory = executorFactory;
        this.cancellationToken = cancellationToken;
        this.coordinationService = coordinationService;
        int numberOfParallelExecutors = parallelismConfiguration.getMaxWorkerCount();
        if (numberOfParallelExecutors < 1) {
            throw new IllegalArgumentException("Not a valid number of parallel executors: " + numberOfParallelExecutors);
        }
        this.executorCount = numberOfParallelExecutors;
        this.workerLeaseService = workerLeaseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(TaskExecutionPlan taskExecutionPlan, Collection<? super Throwable> failures, Action<WorkInfo> workExecutor) {
        ManagedExecutor executor = this.executorFactory.create("Task worker for '" + taskExecutionPlan.getDisplayName() + "'");
        try {
            WorkerLeaseRegistry.WorkerLease parentWorkerLease = this.workerLeaseService.getCurrentWorkerLease();
            this.startAdditionalWorkers(taskExecutionPlan, workExecutor, (Executor)executor, parentWorkerLease);
            new ExecutorWorker(taskExecutionPlan, workExecutor, parentWorkerLease, this.cancellationToken, this.coordinationService).run();
            this.awaitCompletion(taskExecutionPlan, failures);
        }
        finally {
            executor.stop();
        }
    }

    private void awaitCompletion(final TaskExecutionPlan taskExecutionPlan, final Collection<? super Throwable> taskFailures) {
        this.coordinationService.withStateLock((Transformer)new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

            public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                if (taskExecutionPlan.allTasksComplete()) {
                    taskExecutionPlan.collectFailures(taskFailures);
                    return ResourceLockState.Disposition.FINISHED;
                }
                return ResourceLockState.Disposition.RETRY;
            }
        });
    }

    private void startAdditionalWorkers(TaskExecutionPlan taskExecutionPlan, Action<? super WorkInfo> workExecutor, Executor executor, WorkerLeaseRegistry.WorkerLease parentWorkerLease) {
        LOGGER.debug("Using {} parallel executor threads", (Object)this.executorCount);
        for (int i = 1; i < this.executorCount; ++i) {
            executor.execute(new ExecutorWorker(taskExecutionPlan, workExecutor, parentWorkerLease, this.cancellationToken, this.coordinationService));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecutorWorker
    implements Runnable {
        private final TaskExecutionPlan taskExecutionPlan;
        private final Action<? super WorkInfo> workExecutor;
        private final WorkerLeaseRegistry.WorkerLease parentWorkerLease;
        private final BuildCancellationToken cancellationToken;
        private final ResourceLockCoordinationService coordinationService;

        private ExecutorWorker(TaskExecutionPlan taskExecutionPlan, Action<? super WorkInfo> workExecutor, WorkerLeaseRegistry.WorkerLease parentWorkerLease, BuildCancellationToken cancellationToken, ResourceLockCoordinationService coordinationService) {
            this.taskExecutionPlan = taskExecutionPlan;
            this.workExecutor = workExecutor;
            this.parentWorkerLease = parentWorkerLease;
            this.cancellationToken = cancellationToken;
            this.coordinationService = coordinationService;
        }

        @Override
        public void run() {
            final AtomicLong busy = new AtomicLong(0L);
            Timer totalTimer = Time.startTimer();
            final Timer taskTimer = Time.startTimer();
            WorkerLeaseRegistry.WorkerLease childLease = this.parentWorkerLease.createChild();
            boolean moreTasksToExecute = true;
            while (moreTasksToExecute) {
                moreTasksToExecute = this.executeWithWork(childLease, new Action<WorkInfo>(){

                    public void execute(WorkInfo work) {
                        LOGGER.info("{} ({}) started.", (Object)work, (Object)Thread.currentThread());
                        taskTimer.reset();
                        ExecutorWorker.this.workExecutor.execute((Object)work);
                        long taskDuration = taskTimer.getElapsedMillis();
                        busy.addAndGet(taskDuration);
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("{} ({}) completed. Took {}.", new Object[]{work, Thread.currentThread(), TimeFormatting.formatDurationVerbose((long)taskDuration)});
                        }
                    }
                });
            }
            long total = totalTimer.getElapsedMillis();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Task worker [{}] finished, busy: {}, idle: {}", new Object[]{Thread.currentThread(), TimeFormatting.formatDurationVerbose((long)busy.get()), TimeFormatting.formatDurationVerbose((long)(total - busy.get()))});
            }
        }

        private boolean executeWithWork(final WorkerLeaseRegistry.WorkerLease workerLease, Action<WorkInfo> workExecutor) {
            final AtomicReference selected = new AtomicReference();
            final AtomicBoolean workRemaining = new AtomicBoolean();
            this.coordinationService.withStateLock((Transformer)new Transformer<ResourceLockState.Disposition, ResourceLockState>(){

                public ResourceLockState.Disposition transform(ResourceLockState resourceLockState) {
                    if (ExecutorWorker.this.cancellationToken.isCancellationRequested()) {
                        ExecutorWorker.this.taskExecutionPlan.cancelExecution();
                    }
                    workRemaining.set(ExecutorWorker.this.taskExecutionPlan.hasWorkRemaining());
                    if (!workRemaining.get()) {
                        return ResourceLockState.Disposition.FINISHED;
                    }
                    try {
                        selected.set(ExecutorWorker.this.taskExecutionPlan.selectNext(workerLease, resourceLockState));
                    }
                    catch (Throwable t) {
                        resourceLockState.releaseLocks();
                        ExecutorWorker.this.taskExecutionPlan.abortAllAndFail(t);
                        workRemaining.set(false);
                    }
                    if (selected.get() == null && workRemaining.get()) {
                        return ResourceLockState.Disposition.RETRY;
                    }
                    return ResourceLockState.Disposition.FINISHED;
                }
            });
            WorkInfo selectedWorkInfo = (WorkInfo)selected.get();
            if (selectedWorkInfo != null) {
                this.execute(selectedWorkInfo, workerLease, workExecutor);
            }
            return workRemaining.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute(WorkInfo selected, WorkerLeaseRegistry.WorkerLease workerLease, Action<WorkInfo> workExecutor) {
            block4: {
                try {
                    if (selected.isComplete()) break block4;
                    try {
                        workExecutor.execute((Object)selected);
                    }
                    catch (Throwable e) {
                        selected.setExecutionFailure(e);
                    }
                }
                catch (Throwable throwable) {
                    this.coordinationService.withStateLock((Transformer)new Transformer<ResourceLockState.Disposition, ResourceLockState>(selected, workerLease){
                        final /* synthetic */ WorkInfo val$selected;
                        final /* synthetic */ WorkerLeaseRegistry.WorkerLease val$workerLease;
                        {
                            this.val$selected = workInfo;
                            this.val$workerLease = workerLease;
                        }

                        public ResourceLockState.Disposition transform(ResourceLockState state) {
                            ExecutorWorker.this.taskExecutionPlan.workComplete(this.val$selected);
                            return (ResourceLockState.Disposition)DefaultResourceLockCoordinationService.unlock((ResourceLock[])new ResourceLock[]{this.val$workerLease}).transform((Object)state);
                        }
                    });
                    throw throwable;
                }
            }
            this.coordinationService.withStateLock((Transformer)new /* invalid duplicate definition of identical inner class */);
        }
    }
}

