/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.health.memory;

import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.internal.health.memory.MBeanAvailableMemory;
import org.gradle.process.internal.health.memory.MeminfoAvailableMemory;
import org.gradle.process.internal.health.memory.NativeOsxAvailableMemory;
import org.gradle.process.internal.health.memory.OsMemoryInfo;
import org.gradle.process.internal.health.memory.OsMemoryStatus;
import org.gradle.process.internal.health.memory.OsMemoryStatusSnapshot;
import org.gradle.process.internal.health.memory.TotalPhysicalMemoryProvider;

public class DefaultOsMemoryInfo
implements OsMemoryInfo {
    long getTotalPhysicalMemory() {
        return TotalPhysicalMemoryProvider.getTotalPhysicalMemory();
    }

    long getFreePhysicalMemory() {
        OperatingSystem operatingSystem = OperatingSystem.current();
        if (operatingSystem.isMacOsX()) {
            return new NativeOsxAvailableMemory().get();
        }
        if (operatingSystem.isLinux()) {
            return new MeminfoAvailableMemory().get();
        }
        return new MBeanAvailableMemory().get();
    }

    public OsMemoryStatus getOsSnapshot() {
        return new OsMemoryStatusSnapshot(this.getTotalPhysicalMemory(), this.getFreePhysicalMemory());
    }
}

