# Deterministic gridworld example of a reachability game.
# Go from the left column to the right.
#
#   0 1 2 3
#  ---------
# 0|I| | |G|
#  ---------
# 1|I| | |G|
#  ---------
# 2|I| | |G|
#  ---------
# 3|I| | |G|
#  ---------

ENV: ;
SYS: Y_0_0 Y_0_1 Y_0_2 Y_0_3 Y_1_0 Y_1_1 Y_1_2 Y_1_3 Y_2_0 Y_2_1 Y_2_2 Y_2_3 Y_3_0 Y_3_1 Y_3_2 Y_3_3;

ENVINIT: ;
ENVTRANS:;
ENVGOAL:;

SYSINIT: ((Y_0_0 & !Y_0_1 & !Y_0_2 & !Y_0_3 & !Y_1_0 & !Y_1_1 & !Y_1_2 & !Y_1_3 & !Y_2_0 & !Y_2_1 & !Y_2_2 & !Y_2_3 & !Y_3_0 & !Y_3_1 & !Y_3_2 & !Y_3_3) | (Y_1_0 & !Y_0_0 & !Y_0_1 & !Y_0_2 & !Y_0_3 & !Y_1_1 & !Y_1_2 & !Y_1_3 & !Y_2_0 & !Y_2_1 & !Y_2_2 & !Y_2_3 & !Y_3_0 & !Y_3_1 & !Y_3_2 & !Y_3_3) | (Y_2_0 & !Y_0_0 & !Y_0_1 & !Y_0_2 & !Y_0_3 & !Y_1_0 & !Y_1_1 & !Y_1_2 & !Y_1_3 & !Y_2_1 & !Y_2_2 & !Y_2_3 & !Y_3_0 & !Y_3_1 & !Y_3_2 & !Y_3_3) | (Y_3_0 & !Y_0_0 & !Y_0_1 & !Y_0_2 & !Y_0_3 & !Y_1_0 & !Y_1_1 & !Y_1_2 & !Y_1_3 & !Y_2_0 & !Y_2_1 & !Y_2_2 & !Y_2_3 & !Y_3_1 & !Y_3_2 & !Y_3_3));
SYSTRANS: [](Y_0_0 -> (Y_0_0' | Y_1_0' | Y_0_1'))
& [](Y_0_1 -> (Y_0_1' | Y_0_0' | Y_1_1' | Y_0_2'))
& [](Y_0_2 -> (Y_0_2' | Y_0_1' | Y_1_2' | Y_0_3'))
& [](Y_0_3 -> (Y_0_3' | Y_0_2' | Y_1_3'))
& [](Y_1_0 -> (Y_1_0' | Y_0_0' | Y_2_0' | Y_1_1'))
& [](Y_1_1 -> (Y_1_1' | Y_0_1' | Y_1_0' | Y_2_1' | Y_1_2'))
& [](Y_1_2 -> (Y_1_2' | Y_0_2' | Y_1_1' | Y_2_2' | Y_1_3'))
& [](Y_1_3 -> (Y_1_3' | Y_0_3' | Y_1_2' | Y_2_3'))
& [](Y_2_0 -> (Y_2_0' | Y_1_0' | Y_3_0' | Y_2_1'))
& [](Y_2_1 -> (Y_2_1' | Y_1_1' | Y_2_0' | Y_3_1' | Y_2_2'))
& [](Y_2_2 -> (Y_2_2' | Y_1_2' | Y_2_1' | Y_3_2' | Y_2_3'))
& [](Y_2_3 -> (Y_2_3' | Y_1_3' | Y_2_2' | Y_3_3'))
& [](Y_3_0 -> (Y_3_0' | Y_2_0' | Y_3_1'))
& [](Y_3_1 -> (Y_3_1' | Y_2_1' | Y_3_0' | Y_3_2'))
& [](Y_3_2 -> (Y_3_2' | Y_2_2' | Y_3_1' | Y_3_3'))
& [](Y_3_3 -> (Y_3_3' | Y_2_3' | Y_3_2'))
& []((Y_0_0' & (!Y_0_1') & (!Y_0_2') & (!Y_0_3') & (!Y_1_0') & (!Y_1_1') & (!Y_1_2') & (!Y_1_3') & (!Y_2_0') & (!Y_2_1') & (!Y_2_2') & (!Y_2_3') & (!Y_3_0') & (!Y_3_1') & (!Y_3_2') & (!Y_3_3'))
| (Y_0_1' & (!Y_0_0') & (!Y_0_2') & (!Y_0_3') & (!Y_1_0') & (!Y_1_1') & (!Y_1_2') & (!Y_1_3') & (!Y_2_0') & (!Y_2_1') & (!Y_2_2') & (!Y_2_3') & (!Y_3_0') & (!Y_3_1') & (!Y_3_2') & (!Y_3_3'))
| (Y_0_2' & (!Y_0_0') & (!Y_0_1') & (!Y_0_3') & (!Y_1_0') & (!Y_1_1') & (!Y_1_2') & (!Y_1_3') & (!Y_2_0') & (!Y_2_1') & (!Y_2_2') & (!Y_2_3') & (!Y_3_0') & (!Y_3_1') & (!Y_3_2') & (!Y_3_3'))
| (Y_0_3' & (!Y_0_0') & (!Y_0_1') & (!Y_0_2') & (!Y_1_0') & (!Y_1_1') & (!Y_1_2') & (!Y_1_3') & (!Y_2_0') & (!Y_2_1') & (!Y_2_2') & (!Y_2_3') & (!Y_3_0') & (!Y_3_1') & (!Y_3_2') & (!Y_3_3'))
| (Y_1_0' & (!Y_0_0') & (!Y_0_1') & (!Y_0_2') & (!Y_0_3') & (!Y_1_1') & (!Y_1_2') & (!Y_1_3') & (!Y_2_0') & (!Y_2_1') & (!Y_2_2') & (!Y_2_3') & (!Y_3_0') & (!Y_3_1') & (!Y_3_2') & (!Y_3_3'))
| (Y_1_1' & (!Y_0_0') & (!Y_0_1') & (!Y_0_2') & (!Y_0_3') & (!Y_1_0') & (!Y_1_2') & (!Y_1_3') & (!Y_2_0') & (!Y_2_1') & (!Y_2_2') & (!Y_2_3') & (!Y_3_0') & (!Y_3_1') & (!Y_3_2') & (!Y_3_3'))
| (Y_1_2' & (!Y_0_0') & (!Y_0_1') & (!Y_0_2') & (!Y_0_3') & (!Y_1_0') & (!Y_1_1') & (!Y_1_3') & (!Y_2_0') & (!Y_2_1') & (!Y_2_2') & (!Y_2_3') & (!Y_3_0') & (!Y_3_1') & (!Y_3_2') & (!Y_3_3'))
| (Y_1_3' & (!Y_0_0') & (!Y_0_1') & (!Y_0_2') & (!Y_0_3') & (!Y_1_0') & (!Y_1_1') & (!Y_1_2') & (!Y_2_0') & (!Y_2_1') & (!Y_2_2') & (!Y_2_3') & (!Y_3_0') & (!Y_3_1') & (!Y_3_2') & (!Y_3_3'))
| (Y_2_0' & (!Y_0_0') & (!Y_0_1') & (!Y_0_2') & (!Y_0_3') & (!Y_1_0') & (!Y_1_1') & (!Y_1_2') & (!Y_1_3') & (!Y_2_1') & (!Y_2_2') & (!Y_2_3') & (!Y_3_0') & (!Y_3_1') & (!Y_3_2') & (!Y_3_3'))
| (Y_2_1' & (!Y_0_0') & (!Y_0_1') & (!Y_0_2') & (!Y_0_3') & (!Y_1_0') & (!Y_1_1') & (!Y_1_2') & (!Y_1_3') & (!Y_2_0') & (!Y_2_2') & (!Y_2_3') & (!Y_3_0') & (!Y_3_1') & (!Y_3_2') & (!Y_3_3'))
| (Y_2_2' & (!Y_0_0') & (!Y_0_1') & (!Y_0_2') & (!Y_0_3') & (!Y_1_0') & (!Y_1_1') & (!Y_1_2') & (!Y_1_3') & (!Y_2_0') & (!Y_2_1') & (!Y_2_3') & (!Y_3_0') & (!Y_3_1') & (!Y_3_2') & (!Y_3_3'))
| (Y_2_3' & (!Y_0_0') & (!Y_0_1') & (!Y_0_2') & (!Y_0_3') & (!Y_1_0') & (!Y_1_1') & (!Y_1_2') & (!Y_1_3') & (!Y_2_0') & (!Y_2_1') & (!Y_2_2') & (!Y_3_0') & (!Y_3_1') & (!Y_3_2') & (!Y_3_3'))
| (Y_3_0' & (!Y_0_0') & (!Y_0_1') & (!Y_0_2') & (!Y_0_3') & (!Y_1_0') & (!Y_1_1') & (!Y_1_2') & (!Y_1_3') & (!Y_2_0') & (!Y_2_1') & (!Y_2_2') & (!Y_2_3') & (!Y_3_1') & (!Y_3_2') & (!Y_3_3'))
| (Y_3_1' & (!Y_0_0') & (!Y_0_1') & (!Y_0_2') & (!Y_0_3') & (!Y_1_0') & (!Y_1_1') & (!Y_1_2') & (!Y_1_3') & (!Y_2_0') & (!Y_2_1') & (!Y_2_2') & (!Y_2_3') & (!Y_3_0') & (!Y_3_2') & (!Y_3_3'))
| (Y_3_2' & (!Y_0_0') & (!Y_0_1') & (!Y_0_2') & (!Y_0_3') & (!Y_1_0') & (!Y_1_1') & (!Y_1_2') & (!Y_1_3') & (!Y_2_0') & (!Y_2_1') & (!Y_2_2') & (!Y_2_3') & (!Y_3_0') & (!Y_3_1') & (!Y_3_3'))
| (Y_3_3' & (!Y_0_0') & (!Y_0_1') & (!Y_0_2') & (!Y_0_3') & (!Y_1_0') & (!Y_1_1') & (!Y_1_2') & (!Y_1_3') & (!Y_2_0') & (!Y_2_1') & (!Y_2_2') & (!Y_2_3') & (!Y_3_0') & (!Y_3_1') & (!Y_3_2')));
SYSGOAL: <>(Y_0_3 | Y_1_3 | Y_2_3 | Y_3_3);
