/* -*- c++ -*- */
/*
 * Gqrx SDR: Software defined radio receiver powered by GNU Radio and Qt
 *           http://gqrx.dk/
 *
 * Copyright 2016 Alexandru Csete OZ9AEC.
 *
 * Gqrx is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * Gqrx is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Gqrx; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */
#pragma once

/* Filter taps generated by matlab.
 * All filters are designed for 0.5 dB passband ripple and 90-100 dB stop-band
 * attenuation.
 * Optimal FIR sequence generated using FIRCalc 1.0 by Youssef Touil
 */

//  0.4500000000     0.5500000000    2
#define FIR_2_1_LEN     65
const float FIR_2_1_TAPS[FIR_2_1_LEN] = {
    -0.0003278252261,
    -0.002040079795,
    -0.005349315703,
    -0.007344492245,
    -0.004085056018,
     0.002583198482,
     0.004540402908,
    -0.001126032323,
    -0.005173824262,
     0.0001933958993,
     0.006274622399,
     0.0009823472938,
    -0.007659214549,
    -0.002643365879,
     0.009217977524,
     0.004966503475,
    -0.01085040253,
    -0.008121663705,
     0.01248027012,
     0.01234706212,
    -0.01405533589,
    -0.01806676947,
     0.01550395414,
     0.02604486234,
    -0.01677149534,
    -0.03794026747,
     0.0178176146,
     0.05812988058,
    -0.01859222725,
    -0.1027237624,
     0.01906614564,
     0.3171727061,
     0.4807731807,
     0.3171727061,
     0.01906614564,
    -0.1027237624,
    -0.01859222725,
     0.05812988058,
     0.0178176146,
    -0.03794026747,
    -0.01677149534,
     0.02604486234,
     0.01550395414,
    -0.01806676947,
    -0.01405533589,
     0.01234706212,
     0.01248027012,
    -0.008121663705,
    -0.01085040253,
     0.004966503475,
     0.009217977524,
    -0.002643365879,
    -0.007659214549,
     0.0009823472938,
     0.006274622399,
     0.0001933958993,
    -0.005173824262,
    -0.001126032323,
     0.004540402908,
     0.002583198482,
    -0.004085056018,
    -0.007344492245,
    -0.005349315703,
    -0.002040079795,
    -0.0003278252261
};

//  0.2250000000    0.7750000000    2
#define FIR_4_1_LEN     11
const float FIR_4_1_TAPS[FIR_4_1_LEN] = {
    -0.005957326386,
    -0.02477577329,
    -0.01910482161,
     0.09140145779,
     0.2892911136,
     0.3952179253,
     0.2892911136,
     0.09140145779,
    -0.01910482161,
    -0.02477577329,
    -0.005957326386
};

//  0.4500000000    0.5500000000    2
#define FIR_4_2_LEN     FIR_2_1_LEN
const float *FIR_4_2_TAPS = FIR_2_1_TAPS;

//  0.1125000000    0.3875000000    4
#define FIR_8_1_LEN     24
const float FIR_8_1_TAPS[FIR_8_1_LEN] = {
    -0.0003039507719,
    -0.00151092303,
    -0.004308381584,
    -0.008604046889,
    -0.0124123916,
    -0.01131789293,
     0.0005229047383,
     0.02762223035,
     0.06973481923,
     0.1198379695,
     0.1653192043,
     0.1925006062,
     0.1925006062,
     0.1653192043,
     0.1198379695,
     0.06973481923,
     0.02762223035,
     0.0005229047383,
    -0.01131789293,
    -0.0124123916,
    -0.008604046889,
    -0.004308381584,
    -0.00151092303,
    -0.0003039507719
};

//  0.4500000000    0.5500000000    2
#define FIR_8_2_LEN     FIR_2_1_LEN
const float *FIR_8_2_TAPS = FIR_2_1_TAPS;

//    0.0562500000    0.4437500000    4
#define FIR_16_1_LEN    16
const float FIR_16_1_TAPS[FIR_16_1_LEN] = {
    0.0005477772793,
    0.003594921902,
    0.01279040519,
    0.03234443441,
    0.06392806023,
    0.103605859,
    0.141295597,
    0.1644843221,
    0.1644843221,
    0.141295597,
    0.103605859,
    0.06392806023,
    0.03234443441,
    0.01279040519,
    0.003594921902,
    0.0005477772793
};

//    0.2250000000    0.7750000000    2
#define FIR_16_2_LEN    FIR_4_1_LEN
const float *FIR_16_2_TAPS = FIR_4_1_TAPS;

//    0.4500000000    0.5500000000    2
#define FIR_16_3_LEN     FIR_2_1_LEN
const float *FIR_16_3_TAPS = FIR_2_1_TAPS;

//    0.0281250000    0.2218750000    8
#define FIR_32_1_LEN    42
const float FIR_32_1_TAPS[FIR_32_1_LEN] = {
    -4.750685548e-5,
    -0.0001519439538,
    -0.0003587162937,
    -0.0006931721,
    -0.001151426113,
    -0.001673014951,
    -0.002116090851,
    -0.002241667826,
    -0.001715262071,
    -0.0001324449986,
     0.002929489361,
     0.007837772369,
     0.01481874287,
     0.02387691103,
     0.03473669663,
     0.0468236953,
     0.05929613858,
     0.07112794369,
     0.08123386651,
     0.08861737698,
     0.09251579642,
     0.09251579642,
     0.08861737698,
     0.08123386651,
     0.07112794369,
     0.05929613858,
     0.0468236953,
     0.03473669663,
     0.02387691103,
     0.01481874287,
     0.007837772369,
     0.002929489361,
    -0.0001324449986,
    -0.001715262071,
    -0.002241667826,
    -0.002116090851,
    -0.001673014951,
    -0.001151426113,
    -0.0006931721,
    -0.0003587162937,
    -0.0001519439538,
    -4.750685548e-5
};

//    0.2250000000    0.7750000000    2
#define FIR_32_2_LEN    FIR_4_1_LEN
const float *FIR_32_2_TAPS = FIR_4_1_TAPS;

//    0.4500000000    0.5500000000    2
#define FIR_32_3_LEN     FIR_2_1_LEN
const float *FIR_32_3_TAPS = FIR_2_1_TAPS;

//    0.0140625000    0.2359375000    8
#define FIR_64_1_LEN    30
const float FIR_64_1_TAPS[FIR_64_1_LEN] = {
    0.0001188354872,
    0.0004522371455,
    0.001223598025,
    0.002714014845,
    0.005253443029,
    0.009166177362,
    0.0146980416,
    0.02193524688,
    0.03073395602,
    0.04068056494,
    0.05109928548,
    0.06111412868,
    0.06976035982,
    0.07612732053,
    0.07950519025,
    0.07950519025,
    0.07612732053,
    0.06976035982,
    0.06111412868,
    0.05109928548,
    0.04068056494,
    0.03073395602,
    0.02193524688,
    0.0146980416,
    0.009166177362,
    0.005253443029,
    0.002714014845,
    0.001223598025,
    0.0004522371455,
    0.0001188354872
};

//    0.1125000000    0.3875000000    4
#define FIR_64_2_LEN    FIR_8_1_LEN
const float *FIR_64_2_TAPS = FIR_8_1_TAPS;

//    0.4500000000    0.5500000000    2
#define FIR_64_3_LEN    FIR_2_1_LEN
const float *FIR_64_3_TAPS = FIR_2_1_TAPS;

//    0.0070312500    0.1179688000    16
#define FIR_128_1_LEN   61
const float FIR_128_1_TAPS[FIR_128_1_LEN] = {
    3.695723717e-5,
    7.529251889e-5,
    0.0001481503132,
    0.000263013033,
    0.0004344411718,
    0.0006792644854,
    0.001016279799,
    0.001465716981,
    0.002048497088,
    0.002785283606,
    0.003695455613,
    0.004795861896,
    0.006099532824,
    0.007614453789,
    0.00934238825,
    0.01127781812,
    0.01340724807,
    0.01570868306,
    0.01815159246,
    0.02069726959,
    0.02329952456,
    0.02590598352,
    0.02845956571,
    0.03090048954,
    0.03316837549,
    0.03520460054,
    0.03695458919,
    0.03837010637,
    0.03941125423,
    0.04004824534,
    0.0402626507,
    0.04004824534,
    0.03941125423,
    0.03837010637,
    0.03695458919,
    0.03520460054,
    0.03316837549,
    0.03090048954,
    0.02845956571,
    0.02590598352,
    0.02329952456,
    0.02069726959,
    0.01815159246,
    0.01570868306,
    0.01340724807,
    0.01127781812,
    0.00934238825,
    0.007614453789,
    0.006099532824,
    0.004795861896,
    0.003695455613,
    0.002785283606,
    0.002048497088,
    0.001465716981,
    0.001016279799,
    0.0006792644854,
    0.0004344411718,
    0.000263013033,
    0.0001481503132,
    7.529251889e-5,
    3.695723717e-5
};

//    0.1125000000    0.3875000000    4
#define FIR_128_2_LEN   FIR_8_1_LEN
const float *FIR_128_2_TAPS = FIR_8_1_TAPS;

//    0.4500000000    0.5500000000    2
#define FIR_128_3_LEN   FIR_2_1_LEN
const float *FIR_128_3_TAPS = FIR_2_1_TAPS;
