"""Generated message classes for memorystore version v1alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'memorystore'


class AOFConfig(_messages.Message):
  r"""Configuration for AOF based persistence.

  Enums:
    AppendFsyncValueValuesEnum: Optional. The fsync mode.

  Fields:
    appendFsync: Optional. The fsync mode.
  """

  class AppendFsyncValueValuesEnum(_messages.Enum):
    r"""Optional. The fsync mode.

    Values:
      APPEND_FSYNC_UNSPECIFIED: Not set. Default: EVERY_SEC
      NEVER: Never fsync. Normally Linux will flush data every 30 seconds with
        this configuration, but it's up to the kernel's exact tuning.
      EVERY_SEC: Fsync every second. You may lose 1 second of data if there is
        a disaster.
      ALWAYS: Fsync every time new commands are appended to the AOF. The best
        data loss protection at the cost of performance.
    """
    APPEND_FSYNC_UNSPECIFIED = 0
    NEVER = 1
    EVERY_SEC = 2
    ALWAYS = 3

  appendFsync = _messages.EnumField('AppendFsyncValueValuesEnum', 1)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CertChain(_messages.Message):
  r"""A certificate chain.

  Fields:
    certificates: The certificates that form the CA chain in order of leaf to
      root.
  """

  certificates = _messages.StringField(1, repeated=True)


class CertificateAuthority(_messages.Message):
  r"""A certificate authority for an instance.

  Fields:
    managedServerCa: A managed server certificate authority.
    name: Identifier. Unique name of the certificate authority. Format:
      projects/{project}/locations/{location}/instances/{instance}
  """

  managedServerCa = _messages.MessageField('ManagedCertificateAuthority', 1)
  name = _messages.StringField(2)


class DiscoveryEndpoint(_messages.Message):
  r"""Represents an endpoint for clients to connect to the instance.

  Fields:
    address: Output only. IP address of the exposed endpoint clients connect
      to.
    network: Output only. The network where the IP address of the discovery
      endpoint will be reserved, in the form of
      projects/{network_project}/global/networks/{network_id}.
    port: Output only. The port number of the exposed endpoint.
  """

  address = _messages.StringField(1)
  network = _messages.StringField(2)
  port = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Instance(_messages.Message):
  r"""A Memorystore instance.

  Enums:
    AuthorizationModeValueValuesEnum: Optional. Authorization mode of the
      instance.
    NodeTypeValueValuesEnum: Optional. Machine type for individual nodes of
      the instance.
    StateValueValuesEnum: Output only. Current state of the instance.
    TransitEncryptionModeValueValuesEnum: Optional. In-transit encryption mode
      of the instance.

  Messages:
    EngineConfigsValue: Optional. User-provided engine configurations for the
      instance.
    LabelsValue: Optional. Labels to represent user-provided metadata.

  Fields:
    authorizationMode: Optional. Authorization mode of the instance.
    createTime: Output only. Creation timestamp of the instance.
    deletionProtectionEnabled: Optional. If set to true deletion of the
      instance will fail.
    discoveryEndpoints: Output only. Endpoints clients can connect to the
      instance through. Currently only one discovery endpoint is supported.
    engineConfigs: Optional. User-provided engine configurations for the
      instance.
    engineVersion: Optional. Engine version of the instance.
    labels: Optional. Labels to represent user-provided metadata.
    name: Identifier. Unique name of the instance. Format:
      projects/{project}/locations/{location}/instances/{instance}
    nodeConfig: Output only. Configuration of individual nodes of the
      instance.
    nodeType: Optional. Machine type for individual nodes of the instance.
    persistenceConfig: Optional. Persistence configuration of the instance.
    pscAutoConnections: Optional. User inputs and resource details of the
      auto-created PSC connections.
    replicaCount: Optional. Number of replica nodes per shard. If omitted the
      default is 0 replicas.
    shardCount: Required. Number of shards for the instance.
    state: Output only. Current state of the instance.
    stateInfo: Output only. Additional information about the state of the
      instance.
    transitEncryptionMode: Optional. In-transit encryption mode of the
      instance.
    uid: Output only. System assigned, unique identifier for the instance.
    updateTime: Output only. Latest update timestamp of the instance.
    zoneDistributionConfig: Optional. Zone distribution configuration of the
      instance for node allocation.
  """

  class AuthorizationModeValueValuesEnum(_messages.Enum):
    r"""Optional. Authorization mode of the instance.

    Values:
      AUTHORIZATION_MODE_UNSPECIFIED: Not set.
      AUTH_DISABLED: Authorization disabled.
      IAM_AUTH: IAM basic authorization.
    """
    AUTHORIZATION_MODE_UNSPECIFIED = 0
    AUTH_DISABLED = 1
    IAM_AUTH = 2

  class NodeTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Machine type for individual nodes of the instance.

    Values:
      NODE_TYPE_UNSPECIFIED: Not set.
      SHARED_CORE_NANO: Shared core nano.
      HIGHMEM_MEDIUM: High memory medium.
      HIGHMEM_XLARGE: High memory extra large.
      STANDARD_SMALL: Standard small.
    """
    NODE_TYPE_UNSPECIFIED = 0
    SHARED_CORE_NANO = 1
    HIGHMEM_MEDIUM = 2
    HIGHMEM_XLARGE = 3
    STANDARD_SMALL = 4

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current state of the instance.

    Values:
      STATE_UNSPECIFIED: Not set.
      CREATING: Instance is being created.
      ACTIVE: Instance has been created and is usable.
      UPDATING: Instance is being updated.
      DELETING: Instance is being deleted.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    UPDATING = 3
    DELETING = 4

  class TransitEncryptionModeValueValuesEnum(_messages.Enum):
    r"""Optional. In-transit encryption mode of the instance.

    Values:
      TRANSIT_ENCRYPTION_MODE_UNSPECIFIED: Not set.
      TRANSIT_ENCRYPTION_DISABLED: In-transit encryption is disabled.
      SERVER_AUTHENTICATION: Server-managed encryption is used for in-transit
        encryption.
    """
    TRANSIT_ENCRYPTION_MODE_UNSPECIFIED = 0
    TRANSIT_ENCRYPTION_DISABLED = 1
    SERVER_AUTHENTICATION = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class EngineConfigsValue(_messages.Message):
    r"""Optional. User-provided engine configurations for the instance.

    Messages:
      AdditionalProperty: An additional property for a EngineConfigsValue
        object.

    Fields:
      additionalProperties: Additional properties of type EngineConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a EngineConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels to represent user-provided metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  authorizationMode = _messages.EnumField('AuthorizationModeValueValuesEnum', 1)
  createTime = _messages.StringField(2)
  deletionProtectionEnabled = _messages.BooleanField(3)
  discoveryEndpoints = _messages.MessageField('DiscoveryEndpoint', 4, repeated=True)
  engineConfigs = _messages.MessageField('EngineConfigsValue', 5)
  engineVersion = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  nodeConfig = _messages.MessageField('NodeConfig', 9)
  nodeType = _messages.EnumField('NodeTypeValueValuesEnum', 10)
  persistenceConfig = _messages.MessageField('PersistenceConfig', 11)
  pscAutoConnections = _messages.MessageField('PscAutoConnection', 12, repeated=True)
  replicaCount = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  shardCount = _messages.IntegerField(14, variant=_messages.Variant.INT32)
  state = _messages.EnumField('StateValueValuesEnum', 15)
  stateInfo = _messages.MessageField('StateInfo', 16)
  transitEncryptionMode = _messages.EnumField('TransitEncryptionModeValueValuesEnum', 17)
  uid = _messages.StringField(18)
  updateTime = _messages.StringField(19)
  zoneDistributionConfig = _messages.MessageField('ZoneDistributionConfig', 20)


class ListInstancesResponse(_messages.Message):
  r"""Response message for ListInstances.

  Fields:
    instances: If the {location} requested was "-" the response contains a
      list of instances from all locations. Instances in unreachable locations
      will be omitted.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachable: Locations that could not be reached.
  """

  instances = _messages.MessageField('Instance', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class ManagedCertificateAuthority(_messages.Message):
  r"""A managed certificate authority.

  Fields:
    caCerts: PEM encoded CA certificate chains for managed server
      authentication.
  """

  caCerts = _messages.MessageField('CertChain', 1, repeated=True)


class MemorystoreProjectsLocationsGetRequest(_messages.Message):
  r"""A MemorystoreProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class MemorystoreProjectsLocationsInstancesCreateRequest(_messages.Message):
  r"""A MemorystoreProjectsLocationsInstancesCreateRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    instanceId: Required. The ID to use for the instance, which will become
      the final component of the instance's resource name. This value is
      subject to the following restrictions: * Must be 4-63 characters in
      length * Must begin with a letter or digit * Must contain only lowercase
      letters, digits, and hyphens * Must not end with a hyphen * Must be
      unique within a location
    parent: Required. The parent resource where this instance will be created.
      Format: projects/{project}/locations/{location}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  instance = _messages.MessageField('Instance', 1)
  instanceId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class MemorystoreProjectsLocationsInstancesDeleteRequest(_messages.Message):
  r"""A MemorystoreProjectsLocationsInstancesDeleteRequest object.

  Fields:
    name: Required. The name of the instance to delete. Format:
      projects/{project}/locations/{location}/instances/{instance}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class MemorystoreProjectsLocationsInstancesGetCertificateAuthorityRequest(_messages.Message):
  r"""A MemorystoreProjectsLocationsInstancesGetCertificateAuthorityRequest
  object.

  Fields:
    name: Required. The name of the certificate authority. Format: projects/{p
      roject}/locations/{location}/instances/{instance}/certificateAuthority
  """

  name = _messages.StringField(1, required=True)


class MemorystoreProjectsLocationsInstancesGetRequest(_messages.Message):
  r"""A MemorystoreProjectsLocationsInstancesGetRequest object.

  Fields:
    name: Required. The name of the instance to retrieve. Format:
      projects/{project}/locations/{location}/instances/{instance}
  """

  name = _messages.StringField(1, required=True)


class MemorystoreProjectsLocationsInstancesListRequest(_messages.Message):
  r"""A MemorystoreProjectsLocationsInstancesListRequest object.

  Fields:
    filter: Optional. Expression for filtering results.
    orderBy: Optional. Sort results by a defined order. Supported values:
      "name", "create_time".
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The parent to list instances from. Format:
      projects/{project}/locations/{location}
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class MemorystoreProjectsLocationsInstancesPatchRequest(_messages.Message):
  r"""A MemorystoreProjectsLocationsInstancesPatchRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    name: Identifier. Unique name of the instance. Format:
      projects/{project}/locations/{location}/instances/{instance}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. The list of fields to be updated on the instance. At
      least one field must be specified.
  """

  instance = _messages.MessageField('Instance', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class MemorystoreProjectsLocationsListRequest(_messages.Message):
  r"""A MemorystoreProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class MemorystoreProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A MemorystoreProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class MemorystoreProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A MemorystoreProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class MemorystoreProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A MemorystoreProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class MemorystoreProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A MemorystoreProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class NodeConfig(_messages.Message):
  r"""Represents configuration for nodes of the instance.

  Fields:
    sizeGb: Output only. Memory size in GB of the node.
  """

  sizeGb = _messages.FloatField(1)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of a long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class PersistenceConfig(_messages.Message):
  r"""Represents persistence configuration for a instance.

  Enums:
    ModeValueValuesEnum: Optional. Current persistence mode.

  Fields:
    aofConfig: Optional. AOF configuration. This field will be ignored if mode
      is not AOF.
    mode: Optional. Current persistence mode.
    rdbConfig: Optional. RDB configuration. This field will be ignored if mode
      is not RDB.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""Optional. Current persistence mode.

    Values:
      PERSISTENCE_MODE_UNSPECIFIED: Not set.
      DISABLED: Persistence is disabled, and any snapshot data is deleted.
      RDB: RDB based persistence is enabled.
      AOF: AOF based persistence is enabled.
    """
    PERSISTENCE_MODE_UNSPECIFIED = 0
    DISABLED = 1
    RDB = 2
    AOF = 3

  aofConfig = _messages.MessageField('AOFConfig', 1)
  mode = _messages.EnumField('ModeValueValuesEnum', 2)
  rdbConfig = _messages.MessageField('RDBConfig', 3)


class PscAutoConnection(_messages.Message):
  r"""Details of consumer resources in a PSC connection.

  Fields:
    forwardingRule: Output only. The URI of the consumer side forwarding rule.
      Format:
      projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
    ipAddress: Output only. The IP allocated on the consumer network for the
      PSC forwarding rule.
    network: Required. The consumer network where the IP address resides, in
      the form of projects/{project_id}/global/networks/{network_id}.
    projectId: Required. The consumer project_id where the forwarding rule is
      created from.
    pscConnectionId: Output only. The PSC connection id of the forwarding rule
      connected to the service attachment.
  """

  forwardingRule = _messages.StringField(1)
  ipAddress = _messages.StringField(2)
  network = _messages.StringField(3)
  projectId = _messages.StringField(4)
  pscConnectionId = _messages.StringField(5)


class RDBConfig(_messages.Message):
  r"""Configuration for RDB based persistence.

  Enums:
    RdbSnapshotPeriodValueValuesEnum: Optional. Period between RDB snapshots.

  Fields:
    rdbSnapshotPeriod: Optional. Period between RDB snapshots.
    rdbSnapshotStartTime: Optional. Time that the first snapshot was/will be
      attempted, and to which future snapshots will be aligned. If not
      provided, the current time will be used.
  """

  class RdbSnapshotPeriodValueValuesEnum(_messages.Enum):
    r"""Optional. Period between RDB snapshots.

    Values:
      SNAPSHOT_PERIOD_UNSPECIFIED: Not set.
      ONE_HOUR: One hour.
      SIX_HOURS: Six hours.
      TWELVE_HOURS: Twelve hours.
      TWENTY_FOUR_HOURS: Twenty four hours.
    """
    SNAPSHOT_PERIOD_UNSPECIFIED = 0
    ONE_HOUR = 1
    SIX_HOURS = 2
    TWELVE_HOURS = 3
    TWENTY_FOUR_HOURS = 4

  rdbSnapshotPeriod = _messages.EnumField('RdbSnapshotPeriodValueValuesEnum', 1)
  rdbSnapshotStartTime = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class StateInfo(_messages.Message):
  r"""Additional information about the state of the instance.

  Fields:
    updateInfo: Output only. Describes ongoing update when instance state is
      UPDATING.
  """

  updateInfo = _messages.MessageField('UpdateInfo', 1)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class UpdateInfo(_messages.Message):
  r"""Represents information about instance with state UPDATING.

  Fields:
    targetReplicaCount: Output only. Target number of replica nodes per shard
      for the instance.
    targetShardCount: Output only. Target number of shards for the instance.
  """

  targetReplicaCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  targetShardCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class ZoneDistributionConfig(_messages.Message):
  r"""Zone distribution configuration for allocation of instance resources.

  Enums:
    ModeValueValuesEnum: Optional. Current zone distribution mode. Defaults to
      MULTI_ZONE.

  Fields:
    mode: Optional. Current zone distribution mode. Defaults to MULTI_ZONE.
    zone: Optional. Defines zone where all resources will be allocated with
      SINGLE_ZONE mode. Ignored for MULTI_ZONE mode.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""Optional. Current zone distribution mode. Defaults to MULTI_ZONE.

    Values:
      ZONE_DISTRIBUTION_MODE_UNSPECIFIED: Not Set. Default: MULTI_ZONE
      MULTI_ZONE: Distribute resources across 3 zones picked at random within
        the region.
      SINGLE_ZONE: Provision resources in a single zone. Zone field must be
        specified.
    """
    ZONE_DISTRIBUTION_MODE_UNSPECIFIED = 0
    MULTI_ZONE = 1
    SINGLE_ZONE = 2

  mode = _messages.EnumField('ModeValueValuesEnum', 1)
  zone = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
