"""Generated message classes for managedflink version v1alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'managedflink'


class AutotuningConfig(_messages.Message):
  r"""The autotuning configuration for the Flink job.

  Fields:
    enableHorizontalAutoscaling: Optional. Whether to enable horizontal
      autoscaling for the Flink job.
    fixed: Fixed policy to disable autoscaling.
    maxParallelism: Optional. The maximum task parallelism for the Flink job.
    minParallelism: Optional. The minimum task parallelism for the Flink job.
    throughputBased: The throughput based autoscaling policy leveraging
      observed throughput, true processing rate (i.e. estimated maximum
      achievable throughput) to autoscale the task parallelism per job vertex.
  """

  enableHorizontalAutoscaling = _messages.BooleanField(1)
  fixed = _messages.MessageField('Fixed', 2)
  maxParallelism = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  minParallelism = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  throughputBased = _messages.MessageField('Elastic', 5)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class Deployment(_messages.Message):
  r"""Message describing the Flink Deployment resource.

  Enums:
    StateValueValuesEnum: Output only. The state of the Flink deployment.

  Messages:
    LabelsValue: Optional. Labels as key value pairs

  Fields:
    createTime: Output only. The time when the deployment was created.
    deploymentSpec: Optional. Spec that describes a Flink deployment.
    displayName: Optional. The display name of the deployment.
    labels: Optional. Labels as key value pairs
    name: Identifier. The name of the deployment.
    state: Output only. The state of the Flink deployment.
    updateTime: Output only. The time when the deployment was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the Flink deployment.

    Values:
      STATE_UNSPECIFIED: State unspecified.
      INITIALIZING: Deployment is initializing.
      CREATED: Deployment has been created.
      RUNNING: Deployment is running.
      TERMINATING: Deployment is terminating.
      TERMINATED: Deployment has terminated.
    """
    STATE_UNSPECIFIED = 0
    INITIALIZING = 1
    CREATED = 2
    RUNNING = 3
    TERMINATING = 4
    TERMINATED = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  deploymentSpec = _messages.MessageField('DeploymentSpec', 2)
  displayName = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  updateTime = _messages.StringField(7)


class DeploymentSpec(_messages.Message):
  r"""The specification of the Flink deployment.

  Fields:
    limits: Optional. The limit for the deployment.
    networkConfig: Optional. Network configuration for the deployment.
    secretsPath: Optional. The path to the secret in Secret Manager to be
      associated with this deployment. Format: projects//secrets//versions/
  """

  limits = _messages.MessageField('Limits', 1)
  networkConfig = _messages.MessageField('NetworkConfig', 2)
  secretsPath = _messages.StringField(3)


class Elastic(_messages.Message):
  r"""Elastic autoscaling policy to enable autoscaling with min/max limits.

  Fields:
    maxParallelism: Optional. The maximum task parallelism for the Flink job.
    minParallelism: Optional. The minimum task parallelism for the Flink job.
    parallelism: Optional. The initial task parallelism for the Flink job.
  """

  maxParallelism = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minParallelism = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  parallelism = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Fixed(_messages.Message):
  r"""Fixed policy to disable autoscaling.

  Fields:
    parallelism: Optional. The fixed task parallelism for the Flink job.
  """

  parallelism = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class Job(_messages.Message):
  r"""Message describing the Flink Job resource.

  Enums:
    StateValueValuesEnum: Output only. The state of the flink job.

  Messages:
    LabelsValue: Optional. User defined labels as key value pairs.

  Fields:
    createTime: Output only. The time when the job was created.
    deploymentId: Optional. The flink deployment that this job belongs to. If
      empty, the job is created in an ephemeral on-demand flink cluster.
    jobSpec: Required. The specification of the Flink job.
    labels: Optional. User defined labels as key value pairs.
    name: Identifier. The name of the job.
    state: Output only. The state of the flink job.
    updateTime: Output only. The time when the job was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the flink job.

    Values:
      STATE_UNSPECIFIED: state unspecified.
      INITIALIZING: job is initializing.
      CREATED: job has been created.
      RUNNING: job is running .
      FAILING: job is failing.
      FAILED: job has failed.
      CANCELLING: job is getting cancelled.
      CANCELLED: job has been cancelled.
      FINISHED: job has finished.
      RESTARTING: job is restarting.
      SUSPENDED: job has been suspended.
      RECONCILING: job is reconciling.
    """
    STATE_UNSPECIFIED = 0
    INITIALIZING = 1
    CREATED = 2
    RUNNING = 3
    FAILING = 4
    FAILED = 5
    CANCELLING = 6
    CANCELLED = 7
    FINISHED = 8
    RESTARTING = 9
    SUSPENDED = 10
    RECONCILING = 11

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User defined labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  deploymentId = _messages.StringField(2)
  jobSpec = _messages.MessageField('JobSpec', 3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  updateTime = _messages.StringField(7)


class JobSpec(_messages.Message):
  r"""The specification of the Flink job.

  Fields:
    artifactUris: Required. The list of URIs for the flink job artifact files
      in cloud storage.
    autotuningConfig: Optional. Autotuning configuration for the job.
    displayName: Optional. Display name of the Flink job, derived from the
      Flink job graph.
    jarUris: Optional. The list of URIs for the job jars in cloud storage.
    jobGraphUri: Required. The flink job graph uri in cloud storage.
    managedKafkaClusters: Optional. DEPRECATED FIELD. To be deleted once the
      clients are regenerated. Use managed_kafka_config instead.
    managedKafkaConfig: Optional. The configuration for the Managed Kafka
      clusters to be used by the job.
    networkConfig: Optional. Network configuration for the job.
  """

  artifactUris = _messages.StringField(1, repeated=True)
  autotuningConfig = _messages.MessageField('AutotuningConfig', 2)
  displayName = _messages.StringField(3)
  jarUris = _messages.StringField(4, repeated=True)
  jobGraphUri = _messages.StringField(5)
  managedKafkaClusters = _messages.StringField(6, repeated=True)
  managedKafkaConfig = _messages.MessageField('ManagedKafkaConfig', 7)
  networkConfig = _messages.MessageField('NetworkConfig', 8)


class Limits(_messages.Message):
  r"""The limit constraints of the deployment. The limits are based on the
  upper bounds for the different underlying resources.

  Fields:
    maxSlots: Optional. The maximum number of slots for the deployment.
  """

  maxSlots = _messages.IntegerField(1)


class ListDeploymentsResponse(_messages.Message):
  r"""Message for response to listing Deployments

  Fields:
    deployments: The list of Deployment
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  deployments = _messages.MessageField('Deployment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListJobsResponse(_messages.Message):
  r"""Message for response to listing Jobs

  Fields:
    jobs: The list of Job
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  jobs = _messages.MessageField('Job', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListSessionsResponse(_messages.Message):
  r"""Message for response to listing Sessions

  Fields:
    nextPageToken: The maximum number of sessions to return. The service may
      return fewer than this value. If unspecified, at most 50 sessions will
      be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    sessions: The list of Session
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  sessions = _messages.MessageField('Session', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class ManagedKafkaConfig(_messages.Message):
  r"""The configuration for the Managed Kafka clusters to be used by the job.

  Fields:
    managedKafkaClusters: Optional. The list of Managed Kafka clusters
      connected to the job. Expected to be in the format
      projects//locations//clusters/.
  """

  managedKafkaClusters = _messages.StringField(1, repeated=True)


class ManagedflinkProjectsLocationsDeploymentsCreateRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsDeploymentsCreateRequest object.

  Fields:
    deployment: A Deployment resource to be passed as the request body.
    deploymentId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and deployment_id from the
      method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  deployment = _messages.MessageField('Deployment', 1)
  deploymentId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ManagedflinkProjectsLocationsDeploymentsDeleteRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsDeploymentsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class ManagedflinkProjectsLocationsDeploymentsGetRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsDeploymentsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class ManagedflinkProjectsLocationsDeploymentsListRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsDeploymentsListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListDeploymentsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ManagedflinkProjectsLocationsDeploymentsPatchRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsDeploymentsPatchRequest object.

  Fields:
    deployment: A Deployment resource to be passed as the request body.
    name: Identifier. The name of the deployment.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Deployment resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  deployment = _messages.MessageField('Deployment', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class ManagedflinkProjectsLocationsGetRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class ManagedflinkProjectsLocationsJobsCreateRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsJobsCreateRequest object.

  Fields:
    job: A Job resource to be passed as the request body.
    jobId: Required. The ID to use for the job, which will become the final
      component of the job's name.
    parent: Required. The parent region in which to create the job. Structured
      like `projects/{project}/locations/{location}`.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  job = _messages.MessageField('Job', 1)
  jobId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class ManagedflinkProjectsLocationsJobsDeleteRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsJobsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class ManagedflinkProjectsLocationsJobsGetRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsJobsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class ManagedflinkProjectsLocationsJobsListRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsJobsListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListJobsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ManagedflinkProjectsLocationsJobsPatchRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsJobsPatchRequest object.

  Fields:
    job: A Job resource to be passed as the request body.
    name: Identifier. The name of the job.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Job resource by the update. The fields specified in
      the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  job = _messages.MessageField('Job', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class ManagedflinkProjectsLocationsListRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ManagedflinkProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class ManagedflinkProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class ManagedflinkProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class ManagedflinkProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ManagedflinkProjectsLocationsSessionsCreateRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsSessionsCreateRequest object.

  Fields:
    parent: Required. Value for parent, in this case the location Format:
      projects/{project}/locations/{location}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    session: A Session resource to be passed as the request body.
    sessionId: Required. ID to use for the Session
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  session = _messages.MessageField('Session', 3)
  sessionId = _messages.StringField(4)


class ManagedflinkProjectsLocationsSessionsDeleteRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsSessionsDeleteRequest object.

  Fields:
    name: Required. Name of the session Format:
      projects/{project}/locations/{location}/sessions/{session}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class ManagedflinkProjectsLocationsSessionsGetRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsSessionsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class ManagedflinkProjectsLocationsSessionsListRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsSessionsListRequest object.

  Fields:
    filter: Optional. An expression for filtering the list of sessions
      returned. The expression must be in the format of
      https://cloud.google.com/apis/design/design_patterns#list_filtering and
      most commonly will used to filter for active sessions.
    orderBy: Optional. Optional ordering for the list of sessions, such as by
      time of creation or last change.
    pageSize: Optional. Requested page size. Service may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListSessionsRequest, in this case it is
      the location. Format: projects/{project}/locations/{location}
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ManagedflinkProjectsLocationsSessionsPatchRequest(_messages.Message):
  r"""A ManagedflinkProjectsLocationsSessionsPatchRequest object.

  Fields:
    name: Identifier. name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    session: A Session resource to be passed as the request body.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Session resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If an empty mask is
      provided then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  session = _messages.MessageField('Session', 3)
  updateMask = _messages.StringField(4)


class NetworkConfig(_messages.Message):
  r"""The VPC, region, subnetwork that can connect to this Flink Cluster.

  Fields:
    subnetwork: Optional. The subnetwork of the ManagedFlink resource.
    vpc: Optional. The name of the VPC Network to assocaite ManagedFlink
      resources with. Formatted as:
      projects/{project}/global/networks/{network_id}
  """

  subnetwork = _messages.StringField(1)
  vpc = _messages.StringField(2)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Session(_messages.Message):
  r"""Message describing Session object

  Messages:
    LabelsValue: Optional. Labels as key value pairs

  Fields:
    createTime: Output only. [Output only] Create time stamp
    labels: Optional. Labels as key value pairs
    name: Identifier. name of resource
    updateTime: Output only. [Output only] Update time stamp
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  updateTime = _messages.StringField(4)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
