"""Generated message classes for backupdr version v1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'backupdr'


class AcceleratorConfig(_messages.Message):
  r"""A specification of the type and number of accelerator cards attached to
  the instance.

  Fields:
    acceleratorCount: Optional. The number of the guest accelerator cards
      exposed to this instance.
    acceleratorType: Optional. Full or partial URL of the accelerator type
      resource to attach to this instance.
  """

  acceleratorCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  acceleratorType = _messages.StringField(2)


class AccessConfig(_messages.Message):
  r"""An access configuration attached to an instance's network interface.
  Only one access config per instance is supported.

  Enums:
    NetworkTierValueValuesEnum: Optional. This signifies the networking tier
      used for configuring this access
    TypeValueValuesEnum: Optional. In accessConfigs (IPv4), the default and
      only option is ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default and
      only option is DIRECT_IPV6.

  Fields:
    externalIpv6: Optional. The external IPv6 address of this access
      configuration.
    externalIpv6PrefixLength: Optional. The prefix length of the external IPv6
      range.
    name: Optional. The name of this access configuration.
    natIP: Optional. The external IP address of this access configuration.
    networkTier: Optional. This signifies the networking tier used for
      configuring this access
    publicPtrDomainName: Optional. The DNS domain name for the public PTR
      record.
    setPublicPtr: Optional. Specifies whether a public DNS 'PTR' record should
      be created to map the external IP address of the instance to a DNS
      domain name.
    type: Optional. In accessConfigs (IPv4), the default and only option is
      ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default and only option is
      DIRECT_IPV6.
  """

  class NetworkTierValueValuesEnum(_messages.Enum):
    r"""Optional. This signifies the networking tier used for configuring this
    access

    Values:
      NETWORK_TIER_UNSPECIFIED: Default value. This value is unused.
      PREMIUM: High quality, Google-grade network tier, support for all
        networking products.
      STANDARD: Public internet quality, only limited support for other
        networking products.
    """
    NETWORK_TIER_UNSPECIFIED = 0
    PREMIUM = 1
    STANDARD = 2

  class TypeValueValuesEnum(_messages.Enum):
    r"""Optional. In accessConfigs (IPv4), the default and only option is
    ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default and only option is
    DIRECT_IPV6.

    Values:
      ACCESS_TYPE_UNSPECIFIED: Default value. This value is unused.
      ONE_TO_ONE_NAT: ONE_TO_ONE_NAT
      DIRECT_IPV6: Direct IPv6 access.
    """
    ACCESS_TYPE_UNSPECIFIED = 0
    ONE_TO_ONE_NAT = 1
    DIRECT_IPV6 = 2

  externalIpv6 = _messages.StringField(1)
  externalIpv6PrefixLength = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  name = _messages.StringField(3)
  natIP = _messages.StringField(4)
  networkTier = _messages.EnumField('NetworkTierValueValuesEnum', 5)
  publicPtrDomainName = _messages.StringField(6)
  setPublicPtr = _messages.BooleanField(7)
  type = _messages.EnumField('TypeValueValuesEnum', 8)


class AdvancedMachineFeatures(_messages.Message):
  r"""Specifies options for controlling advanced machine features.

  Fields:
    enableNestedVirtualization: Optional. Whether to enable nested
      virtualization or not (default is false).
    enableUefiNetworking: Optional. Whether to enable UEFI networking for
      instance creation.
    threadsPerCore: Optional. The number of threads per physical core. To
      disable simultaneous multithreading (SMT) set this to 1. If unset, the
      maximum number of threads supported per core by the underlying processor
      is assumed.
    visibleCoreCount: Optional. The number of physical cores to expose to an
      instance. Multiply by the number of threads per core to compute the
      total number of virtual CPUs to expose to the instance. If unset, the
      number of cores is inferred from the instance's nominal CPU count and
      the underlying platform's SMT width.
  """

  enableNestedVirtualization = _messages.BooleanField(1)
  enableUefiNetworking = _messages.BooleanField(2)
  threadsPerCore = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  visibleCoreCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class AliasIpRange(_messages.Message):
  r"""An alias IP range attached to an instance's network interface.

  Fields:
    ipCidrRange: Optional. The IP alias ranges to allocate for this interface.
    subnetworkRangeName: Optional. The name of a subnetwork secondary IP range
      from which to allocate an IP alias range. If not specified, the primary
      range of the subnetwork is used.
  """

  ipCidrRange = _messages.StringField(1)
  subnetworkRangeName = _messages.StringField(2)


class AllocationAffinity(_messages.Message):
  r"""Specifies the reservations that this instance can consume from.

  Enums:
    ConsumeReservationTypeValueValuesEnum: Optional. Specifies the type of
      reservation from which this instance can consume

  Fields:
    consumeReservationType: Optional. Specifies the type of reservation from
      which this instance can consume
    key: Optional. Corresponds to the label key of a reservation resource.
    values: Optional. Corresponds to the label values of a reservation
      resource.
  """

  class ConsumeReservationTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies the type of reservation from which this instance
    can consume

    Values:
      TYPE_UNSPECIFIED: Default value. This value is unused.
      NO_RESERVATION: Do not consume from any allocated capacity.
      ANY_RESERVATION: Consume any allocation available.
      SPECIFIC_RESERVATION: Must consume from a specific reservation. Must
        specify key value fields for specifying the reservations.
    """
    TYPE_UNSPECIFIED = 0
    NO_RESERVATION = 1
    ANY_RESERVATION = 2
    SPECIFIC_RESERVATION = 3

  consumeReservationType = _messages.EnumField('ConsumeReservationTypeValueValuesEnum', 1)
  key = _messages.StringField(2)
  values = _messages.StringField(3, repeated=True)


class AttachedDisk(_messages.Message):
  r"""An instance-attached disk resource.

  Fields:
    deviceName: Optional. This is used as an identifier for the disks. This is
      the unique name has to provided to modify disk parameters like disk_name
      and replica_zones (in case of RePDs)
    initializeParams: Optional. Specifies the parameters to initialize this
      disk.
  """

  deviceName = _messages.StringField(1)
  initializeParams = _messages.MessageField('InitializeParams', 2)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts `jose@example.com` from DATA_READ logging, and
  `aliya@example.com` from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Backup(_messages.Message):
  r"""Message describing Backup object.

  Enums:
    BackupTypeValueValuesEnum:
    StateValueValuesEnum: Output only. The Backup resource instance state.

  Messages:
    LabelsValue: Optional. Resource labels to represent user provided
      metadata. No labels currently defined.

  Fields:
    backupApplianceBackupProperties: A BackupApplianceBackupProperties
      attribute.
    backupApplianceLocks: Optional. The list of BackupLocks taken by the
      accessor Backup Appliance.
    backupType: A BackupTypeValueValuesEnum attribute.
    computeInstanceBackupProperties: A ComputeInstanceBackupProperties
      attribute.
    consistencyTime: Output only. The point in time when this backup was
      captured from the source.
    createTime: Output only. The time when the instance was created.
    description: Output only. The description of the Backup instance (2048
      characters or less).
    enforcedRetentionEndTime: Optional. The backup can not be deleted before
      this time.
    etag: Optional. Server specified ETag to prevent updates from overwriting
      each other.
    expireTime: Optional. When this backup is automatically expired.
    gcpBackupPlanInfo: Output only. Configuration for a GCP resource.
    labels: Optional. Resource labels to represent user provided metadata. No
      labels currently defined.
    name: Output only. Name of the resource.
    resourceSizeBytes: Output only. source resource size in bytes at the time
      of the backup.
    serviceLocks: Output only. The list of BackupLocks taken by the service to
      prevent the deletion of the backup.
    state: Output only. The Backup resource instance state.
    updateTime: Output only. The time when the instance was updated.
  """

  class BackupTypeValueValuesEnum(_messages.Enum):
    r"""BackupTypeValueValuesEnum enum type.

    Values:
      BACKUP_TYPE_UNSPECIFIED: <no description>
      SCHEDULED: <no description>
      ON_DEMAND: <no description>
    """
    BACKUP_TYPE_UNSPECIFIED = 0
    SCHEDULED = 1
    ON_DEMAND = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The Backup resource instance state.

    Values:
      STATE_UNSPECIFIED: State not set.
      CREATING: The backup is being created.
      ACTIVE: The backup has been created and is fully usable.
      DELETING: The backup is being deleted.
      ERROR: The backup is experiencing an issue and might be unusable.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DELETING = 3
    ERROR = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Resource labels to represent user provided metadata. No
    labels currently defined.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  backupApplianceBackupProperties = _messages.MessageField('BackupApplianceBackupProperties', 1)
  backupApplianceLocks = _messages.MessageField('BackupLock', 2, repeated=True)
  backupType = _messages.EnumField('BackupTypeValueValuesEnum', 3)
  computeInstanceBackupProperties = _messages.MessageField('ComputeInstanceBackupProperties', 4)
  consistencyTime = _messages.StringField(5)
  createTime = _messages.StringField(6)
  description = _messages.StringField(7)
  enforcedRetentionEndTime = _messages.StringField(8)
  etag = _messages.StringField(9)
  expireTime = _messages.StringField(10)
  gcpBackupPlanInfo = _messages.MessageField('GCPBackupPlanInfo', 11)
  labels = _messages.MessageField('LabelsValue', 12)
  name = _messages.StringField(13)
  resourceSizeBytes = _messages.IntegerField(14)
  serviceLocks = _messages.MessageField('BackupLock', 15, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 16)
  updateTime = _messages.StringField(17)


class BackupApplianceBackupConfig(_messages.Message):
  r"""BackupApplianceBackupConfig captures the backup configuration for
  applications that are protected by Backup Appliances.

  Fields:
    applicationName: The name of the application.
    backupApplianceId: The ID of the backup appliance.
    backupApplianceName: The name of the backup appliance.
    hostName: The name of the host where the application is running.
    slaId: The ID of the SLA of this application.
    slpName: The name of the SLP associated with the application.
    sltName: The name of the SLT associated with the application.
  """

  applicationName = _messages.StringField(1)
  backupApplianceId = _messages.IntegerField(2)
  backupApplianceName = _messages.StringField(3)
  hostName = _messages.StringField(4)
  slaId = _messages.IntegerField(5)
  slpName = _messages.StringField(6)
  sltName = _messages.StringField(7)


class BackupApplianceBackupProperties(_messages.Message):
  r"""BackupApplianceBackupProperties represents Compute Engine instance
  backup properties.

  Fields:
    finalizeTime: Output only. The time when this backup object was finalized
      (if none, backup is not finalized).
    generationId: Output only. The numeric generation ID of the backup
      (monotonically increasing).
    recoveryRangeEndTime: Optional. The latest timestamp of data available in
      this Backup.
    recoveryRangeStartTime: Optional. The earliest timestamp of data available
      in this Backup.
  """

  finalizeTime = _messages.StringField(1)
  generationId = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  recoveryRangeEndTime = _messages.StringField(3)
  recoveryRangeStartTime = _messages.StringField(4)


class BackupApplianceLockInfo(_messages.Message):
  r"""BackupApplianceLockInfo contains metadata about the backupappliance that
  created the lock.

  Fields:
    backupApplianceId: Required. The ID of the backup/recovery appliance that
      created this lock.
    backupApplianceName: Required. The name of the backup/recovery appliance
      that created this lock.
    backupImage: The image name that depends on this Backup.
    jobName: The job name on the backup/recovery appliance that created this
      lock.
    lockReason: Required. The reason for the lock: e.g.
      MOUNT/RESTORE/BACKUP/etc. The value of this string is only meaningful to
      the client and it is not interpreted by the BackupVault service.
    slaId: The SLA on the backup/recovery appliance that owns the lock.
  """

  backupApplianceId = _messages.IntegerField(1)
  backupApplianceName = _messages.StringField(2)
  backupImage = _messages.StringField(3)
  jobName = _messages.StringField(4)
  lockReason = _messages.StringField(5)
  slaId = _messages.IntegerField(6)


class BackupConfigInfo(_messages.Message):
  r"""BackupConfigInfo has information about how the resource is configured
  for Backup and about the most recent backup to this vault.

  Enums:
    LastBackupStateValueValuesEnum: Output only. The status of the last backup
      to this BackupVault

  Fields:
    backupApplianceBackupConfig: Configuration for an application backed up by
      a Backup Appliance.
    gcpBackupConfig: Configuration for a GCP resource.
    lastBackupError: Output only. If the last backup failed, this field has
      the error message.
    lastBackupState: Output only. The status of the last backup to this
      BackupVault
    lastSuccessfulBackupConsistencyTime: Output only. If the last backup were
      successful, this field has the consistency date.
  """

  class LastBackupStateValueValuesEnum(_messages.Enum):
    r"""Output only. The status of the last backup to this BackupVault

    Values:
      LAST_BACKUP_STATE_UNSPECIFIED: Status not set.
      FIRST_BACKUP_PENDING: The first backup has not yet completed
      SUCCEEDED: The most recent backup was successful
      FAILED: The most recent backup failed
      PERMISSION_DENIED: The most recent backup could not be run/failed
        because of the lack of permissions
    """
    LAST_BACKUP_STATE_UNSPECIFIED = 0
    FIRST_BACKUP_PENDING = 1
    SUCCEEDED = 2
    FAILED = 3
    PERMISSION_DENIED = 4

  backupApplianceBackupConfig = _messages.MessageField('BackupApplianceBackupConfig', 1)
  gcpBackupConfig = _messages.MessageField('GcpBackupConfig', 2)
  lastBackupError = _messages.MessageField('Status', 3)
  lastBackupState = _messages.EnumField('LastBackupStateValueValuesEnum', 4)
  lastSuccessfulBackupConsistencyTime = _messages.StringField(5)


class BackupLock(_messages.Message):
  r"""BackupLock represents a single lock on a Backup resource. An unexpired
  lock on a Backup prevents the Backup from being deleted.

  Fields:
    backupApplianceLockInfo: If the client is a backup and recovery appliance,
      this contains metadata about why the lock exists.
    lockUntilTime: Required. The time after which this lock is not considered
      valid and will no longer protect the Backup from deletion.
    serviceLockInfo: Output only. Contains metadata about the lock exist for
      GCP native backups.
  """

  backupApplianceLockInfo = _messages.MessageField('BackupApplianceLockInfo', 1)
  lockUntilTime = _messages.StringField(2)
  serviceLockInfo = _messages.MessageField('ServiceLockInfo', 3)


class BackupPlan(_messages.Message):
  r"""A `BackupPlan` specifies some common fields, such as `display_name` as
  well as one or more `BackupRule` messages. Each `BackupRule` has a retention
  policy and defines a schedule by which the system is to perform backup
  workloads.

  Enums:
    StateValueValuesEnum: Output only. The `State` for the `BackupPlan`.

  Messages:
    LabelsValue: Optional. This collection of key/value pairs allows for
      custom labels to be supplied by the user. Example, {"tag": "Weekly"}.

  Fields:
    adminScope: Optional. TODO b/325560313: Deprecated and field will be
      removed after UI integration change. The resource name of AdminScope
      with which this `BackupPlan` is associated. Format :
      projects/{project}/locations/{location}/adminScopes/{admin_scope}
    backupRules: Required. The backup rules for this `BackupPlan`. There must
      be at least one `BackupRule` message.
    createTime: Output only. When the `BackupPlan` was created.
    description: Optional. The description of the `BackupPlan` resource. The
      description allows for additional details about `BackupPlan` and its use
      cases to be provided. An example description is the following: "This is
      a backup plan that performs a daily backup at 6pm and retains data for 3
      months". The description must be at most 2048 characters.
    displayName: Optional. TODO b/325560313: Deprecated and field will be
      removed after UI integration change. The display name of the
      `BackupPlan`.
    etag: Optional. `etag` is returned from the service in the response. As a
      user of the service, you may provide an etag value in this field to
      prevent stale resources.
    labels: Optional. This collection of key/value pairs allows for custom
      labels to be supplied by the user. Example, {"tag": "Weekly"}.
    name: Output only. The resource name of the `BackupPlan`. Format:
      `projects/{project}/locations/{location}/backupPlans/{backup_plan}`
    resourceType: Required. The resource type to which the `BackupPlan` will
      be applied. Examples include, "compute.googleapis.com/Instance" and
      "storage.googleapis.com/Bucket".
    state: Output only. The `State` for the `BackupPlan`.
    updateTime: Output only. When the `BackupPlan` was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The `State` for the `BackupPlan`.

    Values:
      STATE_UNSPECIFIED: State not set.
      CREATING: The resource is being created.
      ACTIVE: The resource has been created and is fully usable.
      DELETING: The resource is being deleted.
      READY: TODO b/325560313: Deprecated and field will be removed after UI
        integration change. The resource has been created.
      INACTIVE: The resource has been created but is not usable.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DELETING = 3
    READY = 4
    INACTIVE = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. This collection of key/value pairs allows for custom labels
    to be supplied by the user. Example, {"tag": "Weekly"}.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  adminScope = _messages.StringField(1)
  backupRules = _messages.MessageField('BackupRule', 2, repeated=True)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  displayName = _messages.StringField(5)
  etag = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  resourceType = _messages.StringField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  updateTime = _messages.StringField(11)


class BackupPlanAssociation(_messages.Message):
  r"""A BackupPlanAssociation represents a single BackupPlanAssociation which
  contains details like workload, backup plan etc

  Enums:
    StateValueValuesEnum: Output only. The BackupPlanAssociation resource
      state.

  Fields:
    backupCollectionId: Output only. TODO b/325560313: Deprecated and field
      will be removed after UI integration change. Output only. This will
      return the relative url of the AGM application object which will be used
      to redirect to AGM UI from the pantheon to show a list of backups.
    backupPlan: Required. Resource name of backup plan which needs to be
      applied on workload. Format:
      projects/{project}/locations/{location}/backupPlans/{backupPlanId}
    createTime: Output only. The time when the instance was created.
    name: Output only. The resource name of BackupPlanAssociation in below
      format Format : projects/{project}/locations/{location}/backupPlanAssoci
      ations/{backupPlanAssociationId}
    resource: Required. Immutable. Resource name of workload on which
      backupplan is applied
    resourceType: Output only. Output Only. Resource type of workload on which
      backupplan is applied
    rulesConfigInfo: Output only. The config info related to backup rules.
    scopeId: Output only. TODO b/325560313: Deprecated and field will be
      removed after UI integration change. This will return the scope with
      which this backup plan association is associated with.
    state: Output only. The BackupPlanAssociation resource state.
    updateTime: Output only. The time when the instance was updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The BackupPlanAssociation resource state.

    Values:
      STATE_UNSPECIFIED: State not set.
      CREATING: The resource is being created.
      ACTIVE: The resource has been created and is fully usable.
      DELETING: The resource is being deleted.
      READY: TODO b/325560313: Deprecated and field will be removed after UI
        integration change. The resource has been created and is fully usable.
      INACTIVE: The resource has been created but is not usable.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DELETING = 3
    READY = 4
    INACTIVE = 5

  backupCollectionId = _messages.StringField(1)
  backupPlan = _messages.StringField(2)
  createTime = _messages.StringField(3)
  name = _messages.StringField(4)
  resource = _messages.StringField(5)
  resourceType = _messages.StringField(6)
  rulesConfigInfo = _messages.MessageField('RuleConfigInfo', 7, repeated=True)
  scopeId = _messages.StringField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  updateTime = _messages.StringField(10)


class BackupRule(_messages.Message):
  r"""`BackupRule` binds the backup schedule to a retention policy.

  Fields:
    backupRetentionDays: Required. Configures the duration for which backup
      data will be kept. It is defined in "days". The value should be greater
      than or equal to minimum enforced retention of the backup vault.
    backupVault: Required. Resource name of backup vault which will be used as
      storage location for backups. Format:
      projects/{project}/locations/{location}/backupVaults/{backupvault}
    backupVaultServiceAccount: Output only. The Google Cloud Platform Service
      Account to be used by the BackupVault for taking backups. Specify the
      email address of the Backup Vault Service Account. (precedent: https://s
      ource.corp.google.com/piper///depot/google3/google/container/v1/cluster_
      service.proto;l=1014-1019)
    displayName: Optional. TODO b/325560313: Deprecated and field will be
      removed after UI integration change. The display name of the
      `BackupRule`.
    ruleId: Required. Immutable. The unique id of this `BackupRule`. The
      `rule_id` is unique per `BackupPlan`.The `rule_id` must start with a
      lowercase letter followed by up to 62 lowercase letters, numbers, or
      hyphens. Pattern, /a-z{,62}/.
    standardSchedule: Required. Defines a schedule that runs within the
      confines of a defined window of time.
  """

  backupRetentionDays = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  backupVault = _messages.StringField(2)
  backupVaultServiceAccount = _messages.StringField(3)
  displayName = _messages.StringField(4)
  ruleId = _messages.StringField(5)
  standardSchedule = _messages.MessageField('StandardSchedule', 6)


class BackupVault(_messages.Message):
  r"""Message describing BackupVault object.

  Enums:
    StateValueValuesEnum: Output only. The BackupVault resource instance
      state.

  Messages:
    LabelsValue: Optional. Resource labels to represent user provided
      metadata. No labels currently defined:

  Fields:
    backupCount: Output only. The number of backups in this backup vault.
    createTime: Output only. The time when the instance was created.
    deletable: Output only. Set to true when there are no backups nested under
      this resource.
    description: Optional. The description of the BackupVault instance (2048
      characters or less).
    effectiveTime: Optional. Time after which the BackupVault resource is
      locked.
    enforcedRetentionDuration: Required. The default retention period for each
      backup in the backup vault.
    etag: Optional. Server specified ETag for the backup vault resource to
      prevent simultaneous updates from overwiting each other.
    labels: Optional. Resource labels to represent user provided metadata. No
      labels currently defined:
    name: Output only. The resource name.
    serviceAccount: Output only. Service account used by the BackupVault
      Service for this BackupVault. The user should grant this account
      permissions in their workload project to enable the service to run
      backups and restores there.
    state: Output only. The BackupVault resource instance state.
    totalStoredBytes: Output only. Total size of the storage used by all
      backup resources.
    updateTime: Output only. The time when the instance was updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The BackupVault resource instance state.

    Values:
      STATE_UNSPECIFIED: State not set.
      CREATING: The backup vault is being created.
      ACTIVE: The backup vault has been created and is fully usable.
      DELETING: The backup vault is being deleted.
      ERROR: The backup vault is experiencing an issue and might be unusable.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DELETING = 3
    ERROR = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Resource labels to represent user provided metadata. No
    labels currently defined:

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  backupCount = _messages.IntegerField(1)
  createTime = _messages.StringField(2)
  deletable = _messages.BooleanField(3)
  description = _messages.StringField(4)
  effectiveTime = _messages.StringField(5)
  enforcedRetentionDuration = _messages.StringField(6)
  etag = _messages.StringField(7)
  labels = _messages.MessageField('LabelsValue', 8)
  name = _messages.StringField(9)
  serviceAccount = _messages.StringField(10)
  state = _messages.EnumField('StateValueValuesEnum', 11)
  totalStoredBytes = _messages.IntegerField(12)
  updateTime = _messages.StringField(13)


class BackupWindow(_messages.Message):
  r"""`BackupWindow` defines a window of the day during which backup jobs will
  run.

  Fields:
    endHourOfDay: Required. The hour of day (1-24) when the window end for
      e.g. if value of end hour of day is 10 that mean backup window end time
      is 10:00. End hour of day should be greater than start hour of day. 0 <=
      start_hour_of_day < end_hour_of_day <= 24 End hour of day is not include
      in backup window that mean if end_hour_of_day= 10 jobs should start
      before 10:00.
    endTime: Optional. TODO b/325560313: Deprecated and field will be removed
      after UI integration change. The end time of the window in which to pick
      backup jobs to run.
    startHourOfDay: Required. The hour of day (0-23) when the window starts
      for e.g. if value of start hour of day is 6 that mean backup window
      start at 6:00.
    startTime: Optional. TODO b/325560313: Deprecated and field will be
      removed after UI integration change. The start time of the window in
      which to pick backup jobs to run.
  """

  endHourOfDay = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  endTime = _messages.MessageField('TimeOfDay', 2)
  startHourOfDay = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  startTime = _messages.MessageField('TimeOfDay', 4)


class BackupdrProjectsLocationsBackupPlanAssociationsCreateRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupPlanAssociationsCreateRequest object.

  Fields:
    backupPlanAssociation: A BackupPlanAssociation resource to be passed as
      the request body.
    backupPlanAssociationId: Required. The name of the backup plan association
      to create. The name must be unique for the specified project and
      location.
    parent: Required. The backup plan association project and location in the
      format `projects/{project_id}/locations/{location}`. In Cloud BackupDR
      locations map to GCP regions, for example **us-central1**.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  backupPlanAssociation = _messages.MessageField('BackupPlanAssociation', 1)
  backupPlanAssociationId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class BackupdrProjectsLocationsBackupPlanAssociationsDeleteRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupPlanAssociationsDeleteRequest object.

  Fields:
    name: Required. Name of the backup plan association resource, in the
      format `projects/{project}/locations/{location}/backupPlanAssociations/{
      backupPlanAssociationId}`
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class BackupdrProjectsLocationsBackupPlanAssociationsGetRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupPlanAssociationsGetRequest object.

  Fields:
    name: Required. Name of the backup plan association resource, in the
      format `projects/{project}/locations/{location}/backupPlanAssociations/{
      backupPlanAssociationId}`
  """

  name = _messages.StringField(1, required=True)


class BackupdrProjectsLocationsBackupPlanAssociationsListRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupPlanAssociationsListRequest object.

  Fields:
    filter: Optional. Filtering results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The project and location for which to retrieve backup
      Plan Associations information, in the format
      `projects/{project_id}/locations/{location}`. In Cloud BackupDR,
      locations map to GCP regions, for example **us-central1**. To retrieve
      backup plan associations for all locations, use "-" for the `{location}`
      value.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class BackupdrProjectsLocationsBackupPlanAssociationsTriggerBackupRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupPlanAssociationsTriggerBackupRequest
  object.

  Fields:
    name: Required. Name of the backup plan association resource, in the
      format `projects/{project}/locations/{location}/backupPlanAssociations/{
      backupPlanAssociationId}`
    triggerBackupRequest: A TriggerBackupRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  triggerBackupRequest = _messages.MessageField('TriggerBackupRequest', 2)


class BackupdrProjectsLocationsBackupPlansCreateRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupPlansCreateRequest object.

  Fields:
    backupPlan: A BackupPlan resource to be passed as the request body.
    backupPlanId: Required. The name of the `BackupPlan` to create. The name
      must be unique for the specified project and location.The name must
      start with a lowercase letter followed by up to 62 lowercase letters,
      numbers, or hyphens. Pattern, /a-z{,62}/.
    parent: Required. The `BackupPlan` project and location in the format
      `projects/{project}/locations/{location}`. In Cloud BackupDR locations
      map to GCP regions, for example **us-central1**.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  backupPlan = _messages.MessageField('BackupPlan', 1)
  backupPlanId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class BackupdrProjectsLocationsBackupPlansDeleteRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupPlansDeleteRequest object.

  Fields:
    name: Required. The resource name of the `BackupPlan` to delete. Format:
      `projects/{project}/locations/{location}/backupPlans/{backup_plan}`
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class BackupdrProjectsLocationsBackupPlansGetRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupPlansGetRequest object.

  Fields:
    name: Required. The resource name of the `BackupPlan` to retrieve. Format:
      `projects/{project}/locations/{location}/backupPlans/{backup_plan}`
  """

  name = _messages.StringField(1, required=True)


class BackupdrProjectsLocationsBackupPlansListRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupPlansListRequest object.

  Fields:
    filter: Optional. Field match expression used to filter the results.
    orderBy: Optional. Field by which to sort the results.
    pageSize: Optional. The maximum number of `BackupPlans` to return in a
      single response. If not specified, a default value will be chosen by the
      service. Note that the response may include a partial list and a caller
      should only rely on the response's next_page_token to determine if there
      are more instances left to be queried.
    pageToken: Optional. The value of next_page_token received from a previous
      `ListBackupPlans` call. Provide this to retrieve the subsequent page in
      a multi-page list of results. When paginating, all other parameters
      provided to `ListBackupPlans` must match the call that provided the page
      token.
    parent: Required. The project and location for which to retrieve
      `BackupPlans` information. Format:
      `projects/{project}/locations/{location}`. In Cloud BackupDR, locations
      map to GCP regions, for e.g. **us-central1**. To retrieve backup plans
      for all locations, use "-" for the `{location}` value.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class BackupdrProjectsLocationsBackupVaultsCreateRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupVaultsCreateRequest object.

  Fields:
    backupVault: A BackupVault resource to be passed as the request body.
    backupVaultId: Required. ID of the requesting object If auto-generating ID
      server-side, remove this field and backup_vault_id from the
      method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is `false`.
  """

  backupVault = _messages.MessageField('BackupVault', 1)
  backupVaultId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class BackupdrProjectsLocationsBackupVaultsDataSourcesBackupsDeleteRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupVaultsDataSourcesBackupsDeleteRequest
  object.

  Fields:
    name: Required. Name of the resource.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class BackupdrProjectsLocationsBackupVaultsDataSourcesBackupsGetRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupVaultsDataSourcesBackupsGetRequest
  object.

  Fields:
    name: Required. Name of the data source resource name, in the format `proj
      ects/{project_id}/locations/{location}/backupVaults/{backupVault}/dataSo
      urces/{datasource}/backups/{backup}`
  """

  name = _messages.StringField(1, required=True)


class BackupdrProjectsLocationsBackupVaultsDataSourcesBackupsListRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupVaultsDataSourcesBackupsListRequest
  object.

  Fields:
    filter: Optional. Filtering results.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The project and location for which to retrieve backup
      information, in the format `projects/{project_id}/locations/{location}`.
      In Cloud Backup and DR, locations map to GCP regions, for example **us-
      central1**. To retrieve data sources for all locations, use "-" for the
      `{location}` value.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class BackupdrProjectsLocationsBackupVaultsDataSourcesBackupsRestoreRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupVaultsDataSourcesBackupsRestoreRequest
  object.

  Fields:
    name: Required. The resource name of the Backup instance, in the format
      `projects/*/locations/*/backupVaults/*/dataSources/*/backups/`.
    restoreBackupRequest: A RestoreBackupRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  restoreBackupRequest = _messages.MessageField('RestoreBackupRequest', 2)


class BackupdrProjectsLocationsBackupVaultsDataSourcesGetRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupVaultsDataSourcesGetRequest object.

  Fields:
    name: Required. Name of the data source resource name, in the format `proj
      ects/{project_id}/locations/{location}/backupVaults/{resource_name}/data
      Source/{resource_name}`
  """

  name = _messages.StringField(1, required=True)


class BackupdrProjectsLocationsBackupVaultsDataSourcesListRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupVaultsDataSourcesListRequest object.

  Fields:
    filter: Optional. Filtering results.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The project and location for which to retrieve data
      sources information, in the format
      `projects/{project_id}/locations/{location}`. In Cloud Backup and DR,
      locations map to GCP regions, for example **us-central1**. To retrieve
      data sources for all locations, use "-" for the `{location}` value.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class BackupdrProjectsLocationsBackupVaultsDeleteRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupVaultsDeleteRequest object.

  Fields:
    etag: The current etag of the backup vault. If an etag is provided and
      does not match the current etag of the connection, deletion will be
      blocked.
    force: Optional. If set to true, any data source from this backup vault
      will also be deleted.
    name: Required. Name of the resource.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is `false`.
  """

  etag = _messages.StringField(1)
  force = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class BackupdrProjectsLocationsBackupVaultsGetRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupVaultsGetRequest object.

  Fields:
    name: Required. Name of the backupvault store resource name, in the format
      `projects/{project_id}/locations/{location}/backupVaults/{resource_name}
      `
  """

  name = _messages.StringField(1, required=True)


class BackupdrProjectsLocationsBackupVaultsListRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupVaultsListRequest object.

  Fields:
    filter: Optional. Filtering results.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The project and location for which to retrieve
      backupvault stores information, in the format
      `projects/{project_id}/locations/{location}`. In Cloud Backup and DR,
      locations map to GCP regions, for example **us-central1**. To retrieve
      backupvault stores for all locations, use "-" for the `{location}`
      value.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class BackupdrProjectsLocationsBackupVaultsPatchRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupVaultsPatchRequest object.

  Fields:
    backupVault: A BackupVault resource to be passed as the request body.
    name: Output only. The resource name.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the BackupVault resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then the request will fail.
    validateOnly: Optional. Only validate the request, but do not perform
      mutations. The default is `false`.
  """

  backupVault = _messages.MessageField('BackupVault', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class BackupdrProjectsLocationsBackupVaultsTestIamPermissionsRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsBackupVaultsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class BackupdrProjectsLocationsGetRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class BackupdrProjectsLocationsListRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class BackupdrProjectsLocationsManagementServersCreateRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsManagementServersCreateRequest object.

  Fields:
    managementServer: A ManagementServer resource to be passed as the request
      body.
    managementServerId: Required. The name of the management server to create.
      The name must be unique for the specified project and location.
    parent: Required. The management server project and location in the format
      `projects/{project_id}/locations/{location}`. In Cloud Backup and DR
      locations map to GCP regions, for example **us-central1**.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  managementServer = _messages.MessageField('ManagementServer', 1)
  managementServerId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class BackupdrProjectsLocationsManagementServersDeleteRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsManagementServersDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class BackupdrProjectsLocationsManagementServersGetIamPolicyRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsManagementServersGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class BackupdrProjectsLocationsManagementServersGetRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsManagementServersGetRequest object.

  Fields:
    name: Required. Name of the management server resource name, in the format
      `projects/{project_id}/locations/{location}/managementServers/{resource_
      name}`
  """

  name = _messages.StringField(1, required=True)


class BackupdrProjectsLocationsManagementServersListRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsManagementServersListRequest object.

  Fields:
    filter: Optional. Filtering results.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The project and location for which to retrieve
      management servers information, in the format
      `projects/{project_id}/locations/{location}`. In Cloud BackupDR,
      locations map to GCP regions, for example **us-central1**. To retrieve
      management servers for all locations, use "-" for the `{location}`
      value.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class BackupdrProjectsLocationsManagementServersSetIamPolicyRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsManagementServersSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class BackupdrProjectsLocationsManagementServersTestIamPermissionsRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsManagementServersTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class BackupdrProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class BackupdrProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class BackupdrProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class BackupdrProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A BackupdrProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. * `principal://iam.googleapis.com/locatio
      ns/global/workforcePools/{pool_id}/subject/{subject_attribute_value}`: A
      single identity in a workforce identity pool. * `principalSet://iam.goog
      leapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}`:
      All workforce identities in a group. * `principalSet://iam.googleapis.co
      m/locations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{
      attribute_value}`: All workforce identities with a specific attribute
      value. * `principalSet://iam.googleapis.com/locations/global/workforcePo
      ols/{pool_id}/*`: All identities in a workforce identity pool. * `princi
      pal://iam.googleapis.com/projects/{project_number}/locations/global/work
      loadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
      identity in a workload identity pool. * `principalSet://iam.googleapis.c
      om/projects/{project_number}/locations/global/workloadIdentityPools/{poo
      l_id}/group/{group_id}`: A workload identity pool group. * `principalSet
      ://iam.googleapis.com/projects/{project_number}/locations/global/workloa
      dIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}`:
      All identities in a workload identity pool with a certain attribute. * `
      principalSet://iam.googleapis.com/projects/{project_number}/locations/gl
      obal/workloadIdentityPools/{pool_id}/*`: All identities in a workload
      identity pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email
      address (plus unique identifier) representing a user that has been
      recently deleted. For example,
      `alice@example.com?uid=123456789012345678901`. If the user is recovered,
      this value reverts to `user:{emailid}` and the recovered user retains
      the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `deleted:principal://iam.google
      apis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attr
      ibute_value}`: Deleted single identity in a workforce identity pool. For
      example, `deleted:principal://iam.googleapis.com/locations/global/workfo
      rcePools/my-pool-id/subject/my-subject-attribute-value`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an
      overview of the IAM roles and permissions, see the [IAM
      documentation](https://cloud.google.com/iam/docs/roles-overview). For a
      list of the available pre-defined roles, see
      [here](https://cloud.google.com/iam/docs/understanding-roles).
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class ComputeInstanceBackupProperties(_messages.Message):
  r"""ComputeInstanceBackupProperties represents Compute Engine instance
  backup properties.

  Enums:
    KeyRevocationActionTypeValueValuesEnum: KeyRevocationActionType of the
      instance. Supported options are "STOP" and "NONE". The default value is
      "NONE" if it is not specified.

  Fields:
    canIpForward: Enables instances created based on these properties to send
      packets with source IP addresses other than their own and receive
      packets with destination IP addresses other than their own. If these
      instances will be used as an IP gateway or it will be set as the next-
      hop in a Route resource, specify `true`. If unsure, leave this set to
      `false`. See the https://cloud.google.com/vpc/docs/using-
      routes#canipforward documentation for more information.
    description: An optional text description for the instances that are
      created from these properties.
    disk: An array of disks that are associated with the instances that are
      created from these properties.
    guestAccelerator: A list of guest accelerator cards' type and count to use
      for instances created from these properties.
    keyRevocationActionType: KeyRevocationActionType of the instance.
      Supported options are "STOP" and "NONE". The default value is "NONE" if
      it is not specified.
    machineType: The machine type to use for instances that are created from
      these properties.
    metadata: The metadata key/value pairs to assign to instances that are
      created from these properties. These pairs can consist of custom
      metadata or predefined keys. See
      https://cloud.google.com/compute/docs/metadata/overview for more
      information.
    minCpuPlatform: Minimum cpu/platform to be used by instances. The instance
      may be scheduled on the specified or newer cpu/platform. Applicable
      values are the friendly names of CPU platforms, such as `minCpuPlatform:
      Intel Haswell` or `minCpuPlatform: Intel Sandy Bridge`. For more
      information, read
      https://cloud.google.com/compute/docs/instances/specify-min-cpu-
      platform.
    networkInterface: An array of network access configurations for this
      interface.
    scheduling: Specifies the scheduling options for the instances that are
      created from these properties.
    serviceAccount: A list of service accounts with specified scopes. Access
      tokens for these service accounts are available to the instances that
      are created from these properties. Use metadata queries to obtain the
      access tokens for these instances.
    tags: A list of tags to apply to the instances that are created from these
      properties. The tags identify valid sources or targets for network
      firewalls. The setTags method can modify this list of tags. Each tag
      within the list must comply with RFC1035
      (https://www.ietf.org/rfc/rfc1035.txt).
  """

  class KeyRevocationActionTypeValueValuesEnum(_messages.Enum):
    r"""KeyRevocationActionType of the instance. Supported options are "STOP"
    and "NONE". The default value is "NONE" if it is not specified.

    Values:
      KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED: Default value. This value is
        unused.
      NONE: Indicates user chose no operation.
      STOP: Indicates user chose to opt for VM shutdown on key revocation.
    """
    KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED = 0
    NONE = 1
    STOP = 2

  canIpForward = _messages.BooleanField(1)
  description = _messages.StringField(2)
  disk = _messages.MessageField('AttachedDisk', 3, repeated=True)
  guestAccelerator = _messages.MessageField('AcceleratorConfig', 4, repeated=True)
  keyRevocationActionType = _messages.EnumField('KeyRevocationActionTypeValueValuesEnum', 5)
  machineType = _messages.StringField(6)
  metadata = _messages.MessageField('Metadata', 7)
  minCpuPlatform = _messages.StringField(8)
  networkInterface = _messages.MessageField('NetworkInterface', 9, repeated=True)
  scheduling = _messages.MessageField('Scheduling', 10)
  serviceAccount = _messages.MessageField('ServiceAccount', 11, repeated=True)
  tags = _messages.MessageField('Tags', 12)


class ComputeInstanceDataSourceProperties(_messages.Message):
  r"""ComputeInstanceDataSourceProperties represents the properties of a
  ComputeEngine resource that are stored in the DataSource.

  Fields:
    description: The description of the Compute Engine instance.
    machineType: The machine type of the instance.
    name: Name of the compute instance backed up by the datasource.
    totalDiskCount: The total number of disks attached to the Instance.
    totalDiskSizeGb: The sum of all the disk sizes.
  """

  description = _messages.StringField(1)
  machineType = _messages.StringField(2)
  name = _messages.StringField(3)
  totalDiskCount = _messages.IntegerField(4)
  totalDiskSizeGb = _messages.IntegerField(5)


class ComputeInstanceRestoreProperties(_messages.Message):
  r"""ComputeInstanceRestoreProperties represents Compute Engine instance
  properties to be overridden during restore.

  Enums:
    KeyRevocationActionTypeValueValuesEnum: Optional. KeyRevocationActionType
      of the instance.
    PrivateIpv6GoogleAccessValueValuesEnum: Optional. The private IPv6 google
      access type for the VM. If not specified, use INHERIT_FROM_SUBNETWORK as
      default.

  Messages:
    LabelsValue: Optional. Labels to apply to this instance.

  Fields:
    advancedMachineFeatures: Optional. Controls for advanced machine-related
      behavior features.
    canIpForward: Optional. Allows this instance to send and receive packets
      with non-matching destination or source IPs.
    confidentialInstanceConfig: Optional. Controls Confidential compute
      options on the instance
    deletionProtection: Optional. Whether the resource should be protected
      against deletion.
    description: Optional. An optional description of this resource. Provide
      this property when you create the resource.
    disks: Optional. Array of disks associated with this instance. Persistent
      disks must be created before you can assign them.
    displayDevice: Optional. Enables display device for the instance.
    guestAccelerators: Optional. A list of the type and count of accelerator
      cards attached to the instance.
    hostname: Optional. Specifies the hostname of the instance. The specified
      hostname must be RFC1035 compliant. If hostname is not specified, the
      default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using
      the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when
      using zonal DNS.
    instanceEncryptionKey: Optional. Encrypts suspended data for an instance
      with a customer-managed encryption key.
    keyRevocationActionType: Optional. KeyRevocationActionType of the
      instance.
    labels: Optional. Labels to apply to this instance.
    machineType: Optional. Full or partial URL of the machine type resource to
      use for this instance.
    metadata: Optional. This includes custom metadata and predefined keys.
    minCpuPlatform: Optional. Minimum CPU platform to use for this instance.
    name: Required. Name of the compute instance.
    networkInterfaces: Optional. An array of network configurations for this
      instance. These specify how interfaces are configured to interact with
      other network services, such as connecting to the internet. Multiple
      interfaces are supported per instance.
    networkPerformanceConfig: Optional. Configure network performance such as
      egress bandwidth tier.
    params: Input only. Additional params passed with the request, but not
      persisted as part of resource payload.
    privateIpv6GoogleAccess: Optional. The private IPv6 google access type for
      the VM. If not specified, use INHERIT_FROM_SUBNETWORK as default.
    reservationAffinity: Optional. Specifies the reservations that this
      instance can consume from.
    resourcePolicies: Optional. Resource policies applied to this instance.
    scheduling: Optional. Sets the scheduling options for this instance.
    serviceAccounts: Optional. A list of service accounts, with their
      specified scopes, authorized for this instance. Only one service account
      per VM instance is supported.
    shieldedInstanceConfig: Optional. Controls Shielded compute options on the
      instance.
    tags: Optional. Tags to apply to this instance. Tags are used to identify
      valid sources or targets for network firewalls and are specified by the
      client during instance creation.
  """

  class KeyRevocationActionTypeValueValuesEnum(_messages.Enum):
    r"""Optional. KeyRevocationActionType of the instance.

    Values:
      KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED: Default value. This value is
        unused.
      NONE: Indicates user chose no operation.
      STOP: Indicates user chose to opt for VM shutdown on key revocation.
    """
    KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED = 0
    NONE = 1
    STOP = 2

  class PrivateIpv6GoogleAccessValueValuesEnum(_messages.Enum):
    r"""Optional. The private IPv6 google access type for the VM. If not
    specified, use INHERIT_FROM_SUBNETWORK as default.

    Values:
      INSTANCE_PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED: Default value. This
        value is unused.
      INHERIT_FROM_SUBNETWORK: Each network interface inherits
        PrivateIpv6GoogleAccess from its subnetwork.
      ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE: Outbound private IPv6 access from
        VMs in this subnet to Google services. If specified, the subnetwork
        who is attached to the instance's default network interface will be
        assigned an internal IPv6 prefix if it doesn't have before.
      ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE: Bidirectional private IPv6 access
        to/from Google services. If specified, the subnetwork who is attached
        to the instance's default network interface will be assigned an
        internal IPv6 prefix if it doesn't have before.
    """
    INSTANCE_PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED = 0
    INHERIT_FROM_SUBNETWORK = 1
    ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE = 2
    ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels to apply to this instance.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  advancedMachineFeatures = _messages.MessageField('AdvancedMachineFeatures', 1)
  canIpForward = _messages.BooleanField(2)
  confidentialInstanceConfig = _messages.MessageField('ConfidentialInstanceConfig', 3)
  deletionProtection = _messages.BooleanField(4)
  description = _messages.StringField(5)
  disks = _messages.MessageField('AttachedDisk', 6, repeated=True)
  displayDevice = _messages.MessageField('DisplayDevice', 7)
  guestAccelerators = _messages.MessageField('AcceleratorConfig', 8, repeated=True)
  hostname = _messages.StringField(9)
  instanceEncryptionKey = _messages.MessageField('CustomerEncryptionKey', 10)
  keyRevocationActionType = _messages.EnumField('KeyRevocationActionTypeValueValuesEnum', 11)
  labels = _messages.MessageField('LabelsValue', 12)
  machineType = _messages.StringField(13)
  metadata = _messages.MessageField('Metadata', 14)
  minCpuPlatform = _messages.StringField(15)
  name = _messages.StringField(16)
  networkInterfaces = _messages.MessageField('NetworkInterface', 17, repeated=True)
  networkPerformanceConfig = _messages.MessageField('NetworkPerformanceConfig', 18)
  params = _messages.MessageField('InstanceParams', 19)
  privateIpv6GoogleAccess = _messages.EnumField('PrivateIpv6GoogleAccessValueValuesEnum', 20)
  reservationAffinity = _messages.MessageField('AllocationAffinity', 21)
  resourcePolicies = _messages.StringField(22, repeated=True)
  scheduling = _messages.MessageField('Scheduling', 23)
  serviceAccounts = _messages.MessageField('ServiceAccount', 24, repeated=True)
  shieldedInstanceConfig = _messages.MessageField('ShieldedInstanceConfig', 25)
  tags = _messages.MessageField('Tags', 26)


class ComputeInstanceTargetEnvironment(_messages.Message):
  r"""ComputeInstanceTargetEnvironment represents Compute Engine target
  environment to be used during restore.

  Fields:
    project: Required. Name of the restore target project in the format
      `projects/{project_id}.
    zone: Required. The zone of the Compute Engine instance.
  """

  project = _messages.StringField(1)
  zone = _messages.StringField(2)


class ConfidentialInstanceConfig(_messages.Message):
  r"""A set of Confidential Instance options.

  Fields:
    enableConfidentialCompute: Optional. Defines whether the instance should
      have confidential compute enabled.
  """

  enableConfidentialCompute = _messages.BooleanField(1)


class CustomerEncryptionKey(_messages.Message):
  r"""A customer-supplied encryption key.

  Fields:
    kmsKeyName: Optional. The name of the encryption key that is stored in
      Google Cloud KMS.
    kmsKeyServiceAccount: Optional. The service account being used for the
      encryption request for the given KMS key. If absent, the Compute Engine
      default service account is used.
    rawKey: Optional. Specifies a 256-bit customer-supplied encryption key.
    rsaEncryptedKey: Optional. RSA-wrapped 2048-bit customer-supplied
      encryption key to either encrypt or decrypt this resource.
  """

  kmsKeyName = _messages.StringField(1)
  kmsKeyServiceAccount = _messages.StringField(2)
  rawKey = _messages.StringField(3)
  rsaEncryptedKey = _messages.StringField(4)


class DataSource(_messages.Message):
  r"""Message describing DataSource object. Datasource object used to
  represent Datasource details for both admin and basic view.

  Enums:
    ConfigStateValueValuesEnum: The backup configuration state.
    StateValueValuesEnum: Output only. The DataSource resource instance state.

  Messages:
    LabelsValue: Optional. Resource labels to represent user provided
      metadata. No labels currently defined:

  Fields:
    backupConfigInfo: Output only. Details of how the resource is configured
      for backup.
    backupCount: Number of backups in the data source.
    configState: The backup configuration state.
    createTime: Output only. The time when the instance was created.
    dataSourceBackupApplianceApplication: The backed up resource is a backup
      appliance application.
    dataSourceGcpResource: The backed up resource is a GCP resource. The word
      "DataSource" was included in the names to indicate that this is the
      representation of the GCP resource used within the DataSource object.
    etag: Server specified ETag for the ManagementServer resource to prevent
      simultaneous updates from overwiting each other.
    labels: Optional. Resource labels to represent user provided metadata. No
      labels currently defined:
    name: Output only. The resource name.
    state: Output only. The DataSource resource instance state.
    totalStoredBytes: The number of bytes (metadata and data) stored in this
      datasource.
    updateTime: Output only. The time when the instance was updated.
  """

  class ConfigStateValueValuesEnum(_messages.Enum):
    r"""The backup configuration state.

    Values:
      BACKUP_CONFIG_STATE_UNSPECIFIED: The possible states of backup
        configuration. Status not set.
      ACTIVE: The data source is actively protected (i.e. there is a
        BackupPlanAssociation or Appliance SLA pointing to it)
      PASSIVE: The data source is no longer protected (but may have backups
        under it)
    """
    BACKUP_CONFIG_STATE_UNSPECIFIED = 0
    ACTIVE = 1
    PASSIVE = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The DataSource resource instance state.

    Values:
      STATE_UNSPECIFIED: State not set.
      CREATING: The data source is being created.
      ACTIVE: The data source has been created and is fully usable.
      DELETING: The data source is being deleted.
      ERROR: The data source is experiencing an issue and might be unusable.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DELETING = 3
    ERROR = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Resource labels to represent user provided metadata. No
    labels currently defined:

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  backupConfigInfo = _messages.MessageField('BackupConfigInfo', 1)
  backupCount = _messages.IntegerField(2)
  configState = _messages.EnumField('ConfigStateValueValuesEnum', 3)
  createTime = _messages.StringField(4)
  dataSourceBackupApplianceApplication = _messages.MessageField('DataSourceBackupApplianceApplication', 5)
  dataSourceGcpResource = _messages.MessageField('DataSourceGcpResource', 6)
  etag = _messages.StringField(7)
  labels = _messages.MessageField('LabelsValue', 8)
  name = _messages.StringField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  totalStoredBytes = _messages.IntegerField(11)
  updateTime = _messages.StringField(12)


class DataSourceBackupApplianceApplication(_messages.Message):
  r"""BackupApplianceApplication describes a Source Resource when it is an
  application backed up by a BackupAppliance.

  Fields:
    applianceId: Appliance Id of the Backup Appliance.
    applicationId: The appid field of the application within the Backup
      Appliance.
    applicationName: The name of the Application as known to the Backup
      Appliance.
    backupAppliance: Appliance name.
    hostId: Hostid of the application host.
    hostname: Hostname of the host where the application is running.
    type: The type of the application. e.g. VMBackup
  """

  applianceId = _messages.IntegerField(1)
  applicationId = _messages.IntegerField(2)
  applicationName = _messages.StringField(3)
  backupAppliance = _messages.StringField(4)
  hostId = _messages.IntegerField(5)
  hostname = _messages.StringField(6)
  type = _messages.StringField(7)


class DataSourceGcpResource(_messages.Message):
  r"""DataSourceGcpResource is used for protected resources that are GCP
  Resources. This name is easeier to understand than GcpResourceDataSource or
  GcpDataSourceResource

  Fields:
    computeInstanceDatasourceProperties: ComputeInstanceDataSourceProperties
      has a subset of Compute Instance properties that are useful at the
      Datasource level.
    gcpResourcename: Output only. Full resource pathname URL of the source GCP
      resource.
    location: Location of the resource: //"global"/"unspecified".
    type: The type of the GCP resource. Use the Unified Resource Type, eg.
      compute.googleapis.com/Instance.
  """

  computeInstanceDatasourceProperties = _messages.MessageField('ComputeInstanceDataSourceProperties', 1)
  gcpResourcename = _messages.StringField(2)
  location = _messages.StringField(3)
  type = _messages.StringField(4)


class DisplayDevice(_messages.Message):
  r"""A set of Display Device options

  Fields:
    enableDisplay: Optional. Enables display for the Compute Engine VM
  """

  enableDisplay = _messages.BooleanField(1)


class Duration(_messages.Message):
  r"""A Duration represents a fixed-length span of time represented as a count
  of seconds and fractions of seconds at nanosecond resolution. It is
  independent of any calendar and concepts like "day" or "month". Range is
  approximately 10,000 years.

  Fields:
    nanos: Optional. Span of time that's a fraction of a second at nanosecond
      resolution.
    seconds: Optional. Span of time at a resolution of a second.
  """

  nanos = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  seconds = _messages.IntegerField(2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Entry(_messages.Message):
  r"""A key/value pair to be used for storing metadata.

  Fields:
    key: Optional. Key for the metadata entry.
    value: Optional. Value for the metadata entry. These are free-form
      strings, and only have meaning as interpreted by the image running in
      the instance. The only restriction placed on values is that their size
      must be less than or equal to 262144 bytes (256 KiB).
  """

  key = _messages.StringField(1)
  value = _messages.StringField(2)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GCPBackupPlanInfo(_messages.Message):
  r"""GCPBackupPlanInfo captures the plan configuration details of GCP
  resources at the time of backup.

  Fields:
    backupPlan: Resource name of backup plan by which workload is protected at
      the time of the backup. Format:
      projects/{project}/locations/{location}/backupPlans/{backupPlanId}
    backupPlanRuleId: The rule id of the backup plan which triggered this
      backup in case of scheduled backup or used for
  """

  backupPlan = _messages.StringField(1)
  backupPlanRuleId = _messages.StringField(2)


class GcpBackupConfig(_messages.Message):
  r"""GcpBackupConfig captures the Backup configuration details for GCP
  resources. All GCP resources regardless of type are protected with backup
  plan associations.

  Fields:
    backupPlan: The name of the backup plan.
    backupPlanAssociation: The name of the backup plan association.
    backupPlanDescription: The description of the backup plan.
    backupPlanRules: The names of the backup plan rules which point to this
      backupvault
  """

  backupPlan = _messages.StringField(1)
  backupPlanAssociation = _messages.StringField(2)
  backupPlanDescription = _messages.StringField(3)
  backupPlanRules = _messages.StringField(4, repeated=True)


class InitializeParams(_messages.Message):
  r"""Specifies the parameters to initialize this disk.

  Fields:
    diskName: Optional. Specifies the disk name. If not specified, the default
      is to use the name of the instance.
    replicaZones: Optional. Required for each regional disk associated with
      the instance.
  """

  diskName = _messages.StringField(1)
  replicaZones = _messages.StringField(2, repeated=True)


class InstanceParams(_messages.Message):
  r"""Additional instance params.

  Messages:
    ResourceManagerTagsValue: Optional. Resource manager tags to be bound to
      the instance.

  Fields:
    resourceManagerTags: Optional. Resource manager tags to be bound to the
      instance.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResourceManagerTagsValue(_messages.Message):
    r"""Optional. Resource manager tags to be bound to the instance.

    Messages:
      AdditionalProperty: An additional property for a
        ResourceManagerTagsValue object.

    Fields:
      additionalProperties: Additional properties of type
        ResourceManagerTagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResourceManagerTagsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  resourceManagerTags = _messages.MessageField('ResourceManagerTagsValue', 1)


class ListBackupPlanAssociationsResponse(_messages.Message):
  r"""Response message for List BackupPlanAssociation

  Fields:
    backupPlanAssociations: The list of Backup Plan Associations in the
      project for the specified location. If the `{location}` value in the
      request is "-", the response contains a list of instances from all
      locations. In case any location is unreachable, the response will only
      return backup plan associations in reachable locations and the
      'unreachable' field will be populated with a list of unreachable
      locations.
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  backupPlanAssociations = _messages.MessageField('BackupPlanAssociation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListBackupPlansResponse(_messages.Message):
  r"""The response message for getting a list of `BackupPlan`.

  Fields:
    backupPlans: The list of `BackupPlans` in the project for the specified
      location. If the `{location}` value in the request is "-", the response
      contains a list of resources from all locations. In case any location is
      unreachable, the response will only return backup plans in reachable
      locations and the 'unreachable' field will be populated with a list of
      unreachable locations. BackupPlan
    nextPageToken: A token which may be sent as page_token in a subsequent
      `ListBackupPlans` call to retrieve the next page of results. If this
      field is omitted or empty, then there are no more results to return.
    unreachable: Locations that could not be reached.
  """

  backupPlans = _messages.MessageField('BackupPlan', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListBackupVaultsResponse(_messages.Message):
  r"""Response message for listing backup vaults.

  Fields:
    backupVaults: The list of BackupVault instances in the project for the
      specified location. If the `{location}` value in the request is "-", the
      response contains a list of instances from all locations. In case any
      location is unreachable, the response will only return backup vaults in
      reachable locations and the 'unreachable' field will be populated with a
      list of unreachable locations.
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  backupVaults = _messages.MessageField('BackupVault', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListBackupsResponse(_messages.Message):
  r"""Response message for listing backups.

  Fields:
    backups: The list of Backup instances in the project for the specified
      location. If the `{location}` value in the request is "-", the response
      contains a list of instances from all locations. In case any location is
      unreachable, the response will only return data sources in reachable
      locations and the 'unreachable' field will be populated with a list of
      unreachable locations.
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  backups = _messages.MessageField('Backup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListDataSourcesResponse(_messages.Message):
  r"""Response message for listing data sources.

  Fields:
    dataSources: The list of DataSource instances in the project for the
      specified location. If the `{location}` value in the request is "-", the
      response contains a list of instances from all locations. In case any
      location is unreachable, the response will only return data sources in
      reachable locations and the 'unreachable' field will be populated with a
      list of unreachable locations.
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  dataSources = _messages.MessageField('DataSource', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListManagementServersResponse(_messages.Message):
  r"""Response message for listing management servers.

  Fields:
    managementServers: The list of ManagementServer instances in the project
      for the specified location. If the `{location}` value in the request is
      "-", the response contains a list of instances from all locations. In
      case any location is unreachable, the response will only return
      management servers in reachable locations and the 'unreachable' field
      will be populated with a list of unreachable locations.
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  managementServers = _messages.MessageField('ManagementServer', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class ManagementServer(_messages.Message):
  r"""ManagementServer describes a single BackupDR ManagementServer instance.

  Enums:
    StateValueValuesEnum: Output only. The ManagementServer state.
    TypeValueValuesEnum: Optional. The type of the ManagementServer resource.

  Messages:
    LabelsValue: Optional. Resource labels to represent user provided
      metadata. Labels currently defined: 1. migrate_from_go= If set to true,
      the MS is created in migration ready mode.

  Fields:
    baProxyUri: Output only. The hostname or ip address of the exposed AGM
      endpoints, used by BAs to connect to BA proxy.
    createTime: Output only. The time when the instance was created.
    description: Optional. The description of the ManagementServer instance
      (2048 characters or less).
    etag: Optional. Server specified ETag for the ManagementServer resource to
      prevent simultaneous updates from overwiting each other.
    labels: Optional. Resource labels to represent user provided metadata.
      Labels currently defined: 1. migrate_from_go= If set to true, the MS is
      created in migration ready mode.
    managementUri: Output only. The hostname or ip address of the exposed AGM
      endpoints, used by clients to connect to AGM/RD graphical user interface
      and APIs.
    name: Output only. Identifier. The resource name.
    networks: Required. VPC networks to which the ManagementServer instance is
      connected. For this version, only a single network is supported.
    oauth2ClientId: Output only. The OAuth 2.0 client id is required to make
      API calls to the BackupDR instance API of this ManagementServer. This is
      the value that should be provided in the 'aud' field of the OIDC ID
      Token (see openid specification https://openid.net/specs/openid-connect-
      core-1_0.html#IDToken).
    state: Output only. The ManagementServer state.
    type: Optional. The type of the ManagementServer resource.
    updateTime: Output only. The time when the instance was updated.
    workforceIdentityBasedManagementUri: Output only. The hostnames of the
      exposed AGM endpoints for both types of user i.e. 1p and 3p, used to
      connect AGM/RM UI.
    workforceIdentityBasedOauth2ClientId: Output only. The OAuth client IDs
      for both types of user i.e. 1p and 3p.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The ManagementServer state.

    Values:
      INSTANCE_STATE_UNSPECIFIED: State not set.
      CREATING: The instance is being created.
      READY: The instance has been created and is fully usable.
      UPDATING: The instance configuration is being updated. Certain kinds of
        updates may cause the instance to become unusable while the update is
        in progress.
      DELETING: The instance is being deleted.
      REPAIRING: The instance is being repaired and may be unstable.
      MAINTENANCE: Maintenance is being performed on this instance.
      ERROR: The instance is experiencing an issue and might be unusable. You
        can get further details from the statusMessage field of Instance
        resource.
    """
    INSTANCE_STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    UPDATING = 3
    DELETING = 4
    REPAIRING = 5
    MAINTENANCE = 6
    ERROR = 7

  class TypeValueValuesEnum(_messages.Enum):
    r"""Optional. The type of the ManagementServer resource.

    Values:
      INSTANCE_TYPE_UNSPECIFIED: Instance type is not mentioned.
      BACKUP_RESTORE: Instance for backup and restore management (i.e., AGM).
    """
    INSTANCE_TYPE_UNSPECIFIED = 0
    BACKUP_RESTORE = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Resource labels to represent user provided metadata. Labels
    currently defined: 1. migrate_from_go= If set to true, the MS is created
    in migration ready mode.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  baProxyUri = _messages.StringField(1, repeated=True)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  etag = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  managementUri = _messages.MessageField('ManagementURI', 6)
  name = _messages.StringField(7)
  networks = _messages.MessageField('NetworkConfig', 8, repeated=True)
  oauth2ClientId = _messages.StringField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  type = _messages.EnumField('TypeValueValuesEnum', 11)
  updateTime = _messages.StringField(12)
  workforceIdentityBasedManagementUri = _messages.MessageField('WorkforceIdentityBasedManagementURI', 13)
  workforceIdentityBasedOauth2ClientId = _messages.MessageField('WorkforceIdentityBasedOAuth2ClientID', 14)


class ManagementURI(_messages.Message):
  r"""ManagementURI for the Management Server resource.

  Fields:
    api: Output only. The ManagementServer AGM/RD API URL.
    webUi: Output only. The ManagementServer AGM/RD WebUI URL.
  """

  api = _messages.StringField(1)
  webUi = _messages.StringField(2)


class Metadata(_messages.Message):
  r"""A metadata key/value entry.

  Fields:
    items: Optional. Array of key/value pairs. The total size of all keys and
      values must be less than 512 KB.
  """

  items = _messages.MessageField('Entry', 1, repeated=True)


class NetworkConfig(_messages.Message):
  r"""Network configuration for ManagementServer instance.

  Enums:
    PeeringModeValueValuesEnum: Optional. The network connect mode of the
      ManagementServer instance. For this version, only PRIVATE_SERVICE_ACCESS
      is supported.

  Fields:
    network: Optional. The resource name of the Google Compute Engine VPC
      network to which the ManagementServer instance is connected.
    peeringMode: Optional. The network connect mode of the ManagementServer
      instance. For this version, only PRIVATE_SERVICE_ACCESS is supported.
  """

  class PeeringModeValueValuesEnum(_messages.Enum):
    r"""Optional. The network connect mode of the ManagementServer instance.
    For this version, only PRIVATE_SERVICE_ACCESS is supported.

    Values:
      PEERING_MODE_UNSPECIFIED: Peering mode not set.
      PRIVATE_SERVICE_ACCESS: Connect using Private Service Access to the
        Management Server. Private services access provides an IP address
        range for multiple Google Cloud services, including Cloud BackupDR.
    """
    PEERING_MODE_UNSPECIFIED = 0
    PRIVATE_SERVICE_ACCESS = 1

  network = _messages.StringField(1)
  peeringMode = _messages.EnumField('PeeringModeValueValuesEnum', 2)


class NetworkInterface(_messages.Message):
  r"""A network interface resource attached to an instance. s

  Enums:
    Ipv6AccessTypeValueValuesEnum: Optional. [Output Only] One of EXTERNAL,
      INTERNAL to indicate whether the IP can be accessed from the Internet.
      This field is always inherited from its subnetwork.
    NicTypeValueValuesEnum: Optional. The type of vNIC to be used on this
      interface. This may be gVNIC or VirtioNet.
    StackTypeValueValuesEnum: The stack type for this network interface.

  Fields:
    accessConfigs: Optional. An array of configurations for this interface.
      Currently, only one access config,ONE_TO_ONE_NAT is supported. If there
      are no accessConfigs specified, then this instance will have no external
      internet access.
    aliasIpRanges: Optional. An array of alias IP ranges for this network
      interface. You can only specify this field for network interfaces in VPC
      networks.
    internalIpv6PrefixLength: Optional. The prefix length of the primary
      internal IPv6 range.
    ipv6AccessConfigs: Optional. An array of IPv6 access configurations for
      this interface. Currently, only one IPv6 access config, DIRECT_IPV6, is
      supported. If there is no ipv6AccessConfig specified, then this instance
      will have no external IPv6 Internet access.
    ipv6AccessType: Optional. [Output Only] One of EXTERNAL, INTERNAL to
      indicate whether the IP can be accessed from the Internet. This field is
      always inherited from its subnetwork.
    ipv6Address: Optional. An IPv6 internal network address for this network
      interface. To use a static internal IP address, it must be unused and in
      the same region as the instance's zone. If not specified, Google Cloud
      will automatically assign an internal IPv6 address from the instance's
      subnetwork.
    name: Output only. [Output Only] The name of the network interface, which
      is generated by the server.
    network: Optional. URL of the VPC network resource for this instance.
    networkAttachment: Optional. The URL of the network attachment that this
      interface should connect to in the following format: projects/{project_n
      umber}/regions/{region_name}/networkAttachments/{network_attachment_name
      }.
    networkIP: Optional. An IPv4 internal IP address to assign to the instance
      for this network interface. If not specified by the user, an unused
      internal IP is assigned by the system.
    nicType: Optional. The type of vNIC to be used on this interface. This may
      be gVNIC or VirtioNet.
    queueCount: Optional. The networking queue count that's specified by users
      for the network interface. Both Rx and Tx queues will be set to this
      number. It'll be empty if not specified by the users.
    stackType: The stack type for this network interface.
    subnetwork: Optional. The URL of the Subnetwork resource for this
      instance.
  """

  class Ipv6AccessTypeValueValuesEnum(_messages.Enum):
    r"""Optional. [Output Only] One of EXTERNAL, INTERNAL to indicate whether
    the IP can be accessed from the Internet. This field is always inherited
    from its subnetwork.

    Values:
      UNSPECIFIED_IPV6_ACCESS_TYPE: IPv6 access type not set. Means this
        network interface hasn't been turned on IPv6 yet.
      INTERNAL: This network interface can have internal IPv6.
      EXTERNAL: This network interface can have external IPv6.
    """
    UNSPECIFIED_IPV6_ACCESS_TYPE = 0
    INTERNAL = 1
    EXTERNAL = 2

  class NicTypeValueValuesEnum(_messages.Enum):
    r"""Optional. The type of vNIC to be used on this interface. This may be
    gVNIC or VirtioNet.

    Values:
      NIC_TYPE_UNSPECIFIED: Default should be NIC_TYPE_UNSPECIFIED.
      VIRTIO_NET: VIRTIO
      GVNIC: GVNIC
    """
    NIC_TYPE_UNSPECIFIED = 0
    VIRTIO_NET = 1
    GVNIC = 2

  class StackTypeValueValuesEnum(_messages.Enum):
    r"""The stack type for this network interface.

    Values:
      STACK_TYPE_UNSPECIFIED: Default should be STACK_TYPE_UNSPECIFIED.
      IPV4_ONLY: The network interface will be assigned IPv4 address.
      IPV4_IPV6: The network interface can have both IPv4 and IPv6 addresses.
    """
    STACK_TYPE_UNSPECIFIED = 0
    IPV4_ONLY = 1
    IPV4_IPV6 = 2

  accessConfigs = _messages.MessageField('AccessConfig', 1, repeated=True)
  aliasIpRanges = _messages.MessageField('AliasIpRange', 2, repeated=True)
  internalIpv6PrefixLength = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  ipv6AccessConfigs = _messages.MessageField('AccessConfig', 4, repeated=True)
  ipv6AccessType = _messages.EnumField('Ipv6AccessTypeValueValuesEnum', 5)
  ipv6Address = _messages.StringField(6)
  name = _messages.StringField(7)
  network = _messages.StringField(8)
  networkAttachment = _messages.StringField(9)
  networkIP = _messages.StringField(10)
  nicType = _messages.EnumField('NicTypeValueValuesEnum', 11)
  queueCount = _messages.IntegerField(12, variant=_messages.Variant.INT32)
  stackType = _messages.EnumField('StackTypeValueValuesEnum', 13)
  subnetwork = _messages.StringField(14)


class NetworkPerformanceConfig(_messages.Message):
  r"""Network performance configuration.

  Enums:
    TotalEgressBandwidthTierValueValuesEnum: Optional. The tier of the total
      egress bandwidth.

  Fields:
    totalEgressBandwidthTier: Optional. The tier of the total egress
      bandwidth.
  """

  class TotalEgressBandwidthTierValueValuesEnum(_messages.Enum):
    r"""Optional. The tier of the total egress bandwidth.

    Values:
      TIER_UNSPECIFIED: This value is unused.
      DEFAULT: Default network performance config.
      TIER_1: Tier 1 network performance config.
    """
    TIER_UNSPECIFIED = 0
    DEFAULT = 1
    TIER_1 = 2

  totalEgressBandwidthTier = _messages.EnumField('TotalEgressBandwidthTierValueValuesEnum', 1)


class NodeAffinity(_messages.Message):
  r"""Node Affinity: the configuration of desired nodes onto which this
  Instance could be scheduled.

  Enums:
    OperatorValueValuesEnum: Optional. Defines the operation of node
      selection.

  Fields:
    key: Optional. Corresponds to the label key of Node resource.
    operator: Optional. Defines the operation of node selection.
    values: Optional. Corresponds to the label values of Node resource.
  """

  class OperatorValueValuesEnum(_messages.Enum):
    r"""Optional. Defines the operation of node selection.

    Values:
      OPERATOR_UNSPECIFIED: Default value. This value is unused.
      IN: Requires Compute Engine to seek for matched nodes.
      NOT_IN: Requires Compute Engine to avoid certain nodes.
    """
    OPERATOR_UNSPECIFIED = 0
    IN = 1
    NOT_IN = 2

  key = _messages.StringField(1)
  operator = _messages.EnumField('OperatorValueValuesEnum', 2)
  values = _messages.StringField(3, repeated=True)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Messages:
    AdditionalInfoValue: Output only. AdditionalInfo contains additional Info
      related to backup plan association resource.

  Fields:
    additionalInfo: Output only. AdditionalInfo contains additional Info
      related to backup plan association resource.
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AdditionalInfoValue(_messages.Message):
    r"""Output only. AdditionalInfo contains additional Info related to backup
    plan association resource.

    Messages:
      AdditionalProperty: An additional property for a AdditionalInfoValue
        object.

    Fields:
      additionalProperties: Additional properties of type AdditionalInfoValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AdditionalInfoValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalInfo = _messages.MessageField('AdditionalInfoValue', 1)
  apiVersion = _messages.StringField(2)
  createTime = _messages.StringField(3)
  endTime = _messages.StringField(4)
  requestedCancellation = _messages.BooleanField(5)
  statusMessage = _messages.StringField(6)
  target = _messages.StringField(7)
  verb = _messages.StringField(8)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** ``` { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
  members: - user:mike@example.com - group:admins@example.com -
  domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
  role: roles/resourcemanager.organizationAdmin - members: -
  user:eve@example.com role: roles/resourcemanager.organizationViewer
  condition: title: expirable access description: Does not grant access after
  Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
  etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
  see the [IAM documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class RestoreBackupRequest(_messages.Message):
  r"""Request message for restoring a Backup instance.

  Fields:
    computeInstanceRestoreProperties: Compute Engine instance properties to be
      overridden during restore.
    computeInstanceTargetEnvironment: Compute Engine target environment to be
      used during restore.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  computeInstanceRestoreProperties = _messages.MessageField('ComputeInstanceRestoreProperties', 1)
  computeInstanceTargetEnvironment = _messages.MessageField('ComputeInstanceTargetEnvironment', 2)
  requestId = _messages.StringField(3)


class RuleConfigInfo(_messages.Message):
  r"""Message for rules config info.

  Enums:
    LastBackupStateValueValuesEnum: Output only. The last backup state for
      rule.

  Fields:
    dataSource: Output only. Output Only. Resource name of data source which
      will be used as storage location for backups taken by specified rule.
      Format : projects/{project}/locations/{location}/backupVaults/{backupvau
      lt}/dataSources/{datasource}
    lastBackupError: Output only. Output Only. google.rpc.Status object to
      store the last backup error.
    lastBackupState: Output only. The last backup state for rule.
    lastSuccessfulBackupConsistencyTime: Output only. The point in time when
      the last successful backup was captured from the source.
    ruleId: Output only. Output Only. Backup Rule id fetched from backup plan.
  """

  class LastBackupStateValueValuesEnum(_messages.Enum):
    r"""Output only. The last backup state for rule.

    Values:
      LAST_BACKUP_STATE_UNSPECIFIED: State not set.
      FIRST_BACKUP_PENDING: The first backup is pending.
      PERMISSION_DENIED: The most recent backup could not be run/failed
        because of the lack of permissions.
      SUCCEEDED: The last backup operation succeeded.
      FAILED: The last backup operation failed.
    """
    LAST_BACKUP_STATE_UNSPECIFIED = 0
    FIRST_BACKUP_PENDING = 1
    PERMISSION_DENIED = 2
    SUCCEEDED = 3
    FAILED = 4

  dataSource = _messages.StringField(1)
  lastBackupError = _messages.MessageField('Status', 2)
  lastBackupState = _messages.EnumField('LastBackupStateValueValuesEnum', 3)
  lastSuccessfulBackupConsistencyTime = _messages.StringField(4)
  ruleId = _messages.StringField(5)


class Scheduling(_messages.Message):
  r"""Sets the scheduling options for an Instance.

  Enums:
    InstanceTerminationActionValueValuesEnum: Optional. Specifies the
      termination action for the instance.
    OnHostMaintenanceValueValuesEnum: Optional. Defines the maintenance
      behavior for this instance.
    ProvisioningModelValueValuesEnum: Optional. Specifies the provisioning
      model of the instance.

  Fields:
    automaticRestart: Optional. Specifies whether the instance should be
      automatically restarted if it is terminated by Compute Engine (not
      terminated by a user).
    instanceTerminationAction: Optional. Specifies the termination action for
      the instance.
    localSsdRecoveryTimeout: Optional. Specifies the maximum amount of time a
      Local Ssd Vm should wait while recovery of the Local Ssd state is
      attempted. Its value should be in between 0 and 168 hours with hour
      granularity and the default value being 1 hour.
    minNodeCpus: Optional. The minimum number of virtual CPUs this instance
      will consume when running on a sole-tenant node.
    nodeAffinities: Optional. A set of node affinity and anti-affinity
      configurations. Overrides reservationAffinity.
    onHostMaintenance: Optional. Defines the maintenance behavior for this
      instance.
    preemptible: Optional. Defines whether the instance is preemptible.
    provisioningModel: Optional. Specifies the provisioning model of the
      instance.
  """

  class InstanceTerminationActionValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies the termination action for the instance.

    Values:
      INSTANCE_TERMINATION_ACTION_UNSPECIFIED: Default value. This value is
        unused.
      DELETE: Delete the VM.
      STOP: Stop the VM without storing in-memory content. default action.
    """
    INSTANCE_TERMINATION_ACTION_UNSPECIFIED = 0
    DELETE = 1
    STOP = 2

  class OnHostMaintenanceValueValuesEnum(_messages.Enum):
    r"""Optional. Defines the maintenance behavior for this instance.

    Values:
      ON_HOST_MAINTENANCE_UNSPECIFIED: Default value. This value is unused.
      TERMINATE: Tells Compute Engine to terminate and (optionally) restart
        the instance away from the maintenance activity.
      MIGRATE: Default, Allows Compute Engine to automatically migrate
        instances out of the way of maintenance events.
    """
    ON_HOST_MAINTENANCE_UNSPECIFIED = 0
    TERMINATE = 1
    MIGRATE = 2

  class ProvisioningModelValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies the provisioning model of the instance.

    Values:
      PROVISIONING_MODEL_UNSPECIFIED: Default value. This value is not used.
      STANDARD: Standard provisioning with user controlled runtime, no
        discounts.
      SPOT: Heavily discounted, no guaranteed runtime.
    """
    PROVISIONING_MODEL_UNSPECIFIED = 0
    STANDARD = 1
    SPOT = 2

  automaticRestart = _messages.BooleanField(1)
  instanceTerminationAction = _messages.EnumField('InstanceTerminationActionValueValuesEnum', 2)
  localSsdRecoveryTimeout = _messages.MessageField('Duration', 3)
  minNodeCpus = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  nodeAffinities = _messages.MessageField('NodeAffinity', 5, repeated=True)
  onHostMaintenance = _messages.EnumField('OnHostMaintenanceValueValuesEnum', 6)
  preemptible = _messages.BooleanField(7)
  provisioningModel = _messages.EnumField('ProvisioningModelValueValuesEnum', 8)


class ServiceAccount(_messages.Message):
  r"""A service account.

  Fields:
    email: Optional. Email address of the service account.
    scopes: Optional. The list of scopes to be made available for this service
      account.
  """

  email = _messages.StringField(1)
  scopes = _messages.StringField(2, repeated=True)


class ServiceLockInfo(_messages.Message):
  r"""ServiceLockInfo represents the details of a lock taken by the service on
  a Backup resource.

  Fields:
    operation: Output only. The name of the operation that created this lock.
      The lock will automatically be released when the operation completes.
  """

  operation = _messages.StringField(1)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class ShieldedInstanceConfig(_messages.Message):
  r"""A set of Shielded Instance options.

  Fields:
    enableIntegrityMonitoring: Optional. Whether to enable integrity
      monitoring.
    enableSecureBoot: Optional. Whether to enable secure boot.
    enableVtpm: Optional. Whether to enable VTPM.
  """

  enableIntegrityMonitoring = _messages.BooleanField(1)
  enableSecureBoot = _messages.BooleanField(2)
  enableVtpm = _messages.BooleanField(3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class StandardSchedule(_messages.Message):
  r"""`StandardSchedule` defines a schedule that run within the confines of a
  defined window of days. We can define recurrence type for schedule as
  HOURLY, DAILY, WEEKLY, MONTHLY or YEARLY.

  Enums:
    DaysOfWeekValueListEntryValuesEnum:
    MonthsValueListEntryValuesEnum:
    RecurrenceTypeValueValuesEnum: Required. Specifies the `RecurrenceType`
      for the schedule.

  Fields:
    backupWindow: Required. A BackupWindow defines the window of day during
      which backup jobs will run. Jobs are queued at the beginning of the
      window and will be marked as `NOT_RUN` if they do not start by the end
      of the window. Note: running jobs will not be cancelled at the end of
      the window.
    daysOfMonth: Optional. Specifies days of months like 1, 5, or 14 on which
      jobs will run. Values for `days_of_month` are only applicable for
      `recurrence_type`, `MONTHLY` and `YEARLY`. A validation error will occur
      if other values are supplied.
    daysOfWeek: Optional. Specifies days of week like, MONDAY or TUESDAY, on
      which jobs will run. This is required for `recurrence_type`, `WEEKLY`
      and is not applicable otherwise. A validation error will occur if a
      value is supplied and `recurrence_type` is not `WEEKLY`.
    hourlyFrequency: Optional. Specifies frequency for hourly backups. A
      hourly frequency of 2 means jobs will run every 2 hours from start time
      till end time defined. This is required for `recurrence_type`, `HOURLY`
      and is not applicable otherwise. A validation error will occur if a
      value is supplied and `recurrence_type` is not `HOURLY`. Value of hourly
      frequency should be between 6 and 23. Reason for limit : We found that
      there is bandwidth limitation of 3GB/S for GMI while taking a backup and
      5GB/S while doing a restore. Given the amount of parallel backups and
      restore we are targeting, this will potentially take the backup time to
      mins and hours (in worst case scenario).
    months: Optional. Specifies the months of year, like `FEBRUARY` and/or
      `MAY`, on which jobs will run. This field is only applicable when
      `recurrence_type` is `YEARLY`. A validation error will occur if other
      values are supplied.
    recurrenceType: Required. Specifies the `RecurrenceType` for the schedule.
    repeatInterval: Required. TODO b/325560313: Deprecated and field will be
      removed after UI integration change. Repeat interval
    timeZone: Optional. The time zone to be used when interpreting the
      schedule. The value of this field must be a time zone name from the IANA
      tz database. See
      https://en.wikipedia.org/wiki/List_of_tz_database_time_zones for the
      list of valid timezone names. The default value is UTC. For e.g.,
      Europe/Paris.
    weekDayOfMonth: Optional. This will be supported in GA not in PP.
      Specifies a week day of the month like, FIRST SUNDAY or LAST MONDAY, on
      which jobs will run. This will be specified by two fields in
      `WeekDayOfMonth`, one for the day, e.g. `MONDAY`, and one for the week,
      e.g. `LAST`. This field is only applicable for `recurrence_type`,
      `MONTHLY` and `YEARLY`. A validation error will occur if other values
      are supplied.
  """

  class DaysOfWeekValueListEntryValuesEnum(_messages.Enum):
    r"""DaysOfWeekValueListEntryValuesEnum enum type.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  class MonthsValueListEntryValuesEnum(_messages.Enum):
    r"""MonthsValueListEntryValuesEnum enum type.

    Values:
      MONTH_UNSPECIFIED: The unspecified month.
      JANUARY: The month of January.
      FEBRUARY: The month of February.
      MARCH: The month of March.
      APRIL: The month of April.
      MAY: The month of May.
      JUNE: The month of June.
      JULY: The month of July.
      AUGUST: The month of August.
      SEPTEMBER: The month of September.
      OCTOBER: The month of October.
      NOVEMBER: The month of November.
      DECEMBER: The month of December.
    """
    MONTH_UNSPECIFIED = 0
    JANUARY = 1
    FEBRUARY = 2
    MARCH = 3
    APRIL = 4
    MAY = 5
    JUNE = 6
    JULY = 7
    AUGUST = 8
    SEPTEMBER = 9
    OCTOBER = 10
    NOVEMBER = 11
    DECEMBER = 12

  class RecurrenceTypeValueValuesEnum(_messages.Enum):
    r"""Required. Specifies the `RecurrenceType` for the schedule.

    Values:
      RECURRENCE_TYPE_UNSPECIFIED: recurrence type not set
      HOURLY: The `BackupRule` is to be applied hourly.
      DAILY: The `BackupRule` is to be applied daily.
      WEEKLY: The `BackupRule` is to be applied weekly.
      MONTHLY: The `BackupRule` is to be applied monthly.
      YEARLY: The `BackupRule` is to be applied yearly.
    """
    RECURRENCE_TYPE_UNSPECIFIED = 0
    HOURLY = 1
    DAILY = 2
    WEEKLY = 3
    MONTHLY = 4
    YEARLY = 5

  backupWindow = _messages.MessageField('BackupWindow', 1)
  daysOfMonth = _messages.IntegerField(2, repeated=True, variant=_messages.Variant.INT32)
  daysOfWeek = _messages.EnumField('DaysOfWeekValueListEntryValuesEnum', 3, repeated=True)
  hourlyFrequency = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  months = _messages.EnumField('MonthsValueListEntryValuesEnum', 5, repeated=True)
  recurrenceType = _messages.EnumField('RecurrenceTypeValueValuesEnum', 6)
  repeatInterval = _messages.IntegerField(7)
  timeZone = _messages.StringField(8)
  weekDayOfMonth = _messages.MessageField('WeekDayOfMonth', 9)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Tags(_messages.Message):
  r"""A set of instance tags.

  Fields:
    items: Optional. An array of tags. Each tag must be 1-63 characters long,
      and comply with RFC1035.
  """

  items = _messages.StringField(1, repeated=True)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class TimeOfDay(_messages.Message):
  r"""Represents a time of day. The date and time zone are either not
  significant or are specified elsewhere. An API may choose to allow leap
  seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.

  Fields:
    hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may
      choose to allow the value "24:00:00" for scenarios like business closing
      time.
    minutes: Minutes of hour of day. Must be from 0 to 59.
    nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An
      API may allow the value 60 if it allows leap-seconds.
  """

  hours = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minutes = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  nanos = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  seconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class TriggerBackupRequest(_messages.Message):
  r"""Request message for triggering a backup.

  Fields:
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    ruleId: Required. backup rule_id for which a backup needs to be triggered.
  """

  requestId = _messages.StringField(1)
  ruleId = _messages.StringField(2)


class WeekDayOfMonth(_messages.Message):
  r"""`WeekDayOfMonth` defines the week day of the month on which the backups
  will run. The message combines a `WeekOfMonth` and `DayOfWeek` to produce
  values like `FIRST`/`MONDAY` or `LAST`/`FRIDAY`.

  Enums:
    DayOfWeekValueValuesEnum: Required. Specifies the day of the week.
    WeekOfMonthValueValuesEnum: Required. Specifies the week of the month.

  Fields:
    dayOfWeek: Required. Specifies the day of the week.
    weekOfMonth: Required. Specifies the week of the month.
  """

  class DayOfWeekValueValuesEnum(_messages.Enum):
    r"""Required. Specifies the day of the week.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  class WeekOfMonthValueValuesEnum(_messages.Enum):
    r"""Required. Specifies the week of the month.

    Values:
      WEEK_OF_MONTH_UNSPECIFIED: The zero value. Do not use.
      FIRST: The first week of the month.
      SECOND: The second week of the month.
      THIRD: The third week of the month.
      FOURTH: The fourth week of the month.
      LAST: The last week of the month.
    """
    WEEK_OF_MONTH_UNSPECIFIED = 0
    FIRST = 1
    SECOND = 2
    THIRD = 3
    FOURTH = 4
    LAST = 5

  dayOfWeek = _messages.EnumField('DayOfWeekValueValuesEnum', 1)
  weekOfMonth = _messages.EnumField('WeekOfMonthValueValuesEnum', 2)


class WorkforceIdentityBasedManagementURI(_messages.Message):
  r"""ManagementURI depending on the Workforce Identity i.e. either 1p or 3p.

  Fields:
    firstPartyManagementUri: Output only. First party Management URI for
      Google Identities.
    thirdPartyManagementUri: Output only. Third party Management URI for
      External Identity Providers.
  """

  firstPartyManagementUri = _messages.StringField(1)
  thirdPartyManagementUri = _messages.StringField(2)


class WorkforceIdentityBasedOAuth2ClientID(_messages.Message):
  r"""OAuth Client ID depending on the Workforce Identity i.e. either 1p or
  3p,

  Fields:
    firstPartyOauth2ClientId: Output only. First party OAuth Client ID for
      Google Identities.
    thirdPartyOauth2ClientId: Output only. Third party OAuth Client ID for
      External Identity Providers.
  """

  firstPartyOauth2ClientId = _messages.StringField(1)
  thirdPartyOauth2ClientId = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
encoding.AddCustomJsonFieldMapping(
    BackupdrProjectsLocationsManagementServersGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
