"""Generated client library for compute version beta."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.compute.beta import compute_beta_messages as messages


class ComputeBeta(base_api.BaseApiClient):
  """Generated client library for service compute version beta."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://compute.googleapis.com/compute/beta/'
  MTLS_BASE_URL = 'https://compute.mtls.googleapis.com/compute/beta/'

  _PACKAGE = 'compute'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform', 'https://www.googleapis.com/auth/compute', 'https://www.googleapis.com/auth/compute.readonly', 'https://www.googleapis.com/auth/devstorage.full_control', 'https://www.googleapis.com/auth/devstorage.read_only', 'https://www.googleapis.com/auth/devstorage.read_write']
  _VERSION = 'beta'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'ComputeBeta'
  _URL_VERSION = 'beta'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new compute handle."""
    url = url or self.BASE_URL
    super(ComputeBeta, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.acceleratorTypes = self.AcceleratorTypesService(self)
    self.addresses = self.AddressesService(self)
    self.autoscalers = self.AutoscalersService(self)
    self.backendBuckets = self.BackendBucketsService(self)
    self.backendServices = self.BackendServicesService(self)
    self.diskTypes = self.DiskTypesService(self)
    self.disks = self.DisksService(self)
    self.externalVpnGateways = self.ExternalVpnGatewaysService(self)
    self.firewallPolicies = self.FirewallPoliciesService(self)
    self.firewalls = self.FirewallsService(self)
    self.forwardingRules = self.ForwardingRulesService(self)
    self.globalAddresses = self.GlobalAddressesService(self)
    self.globalForwardingRules = self.GlobalForwardingRulesService(self)
    self.globalNetworkEndpointGroups = self.GlobalNetworkEndpointGroupsService(self)
    self.globalOperations = self.GlobalOperationsService(self)
    self.globalOrganizationOperations = self.GlobalOrganizationOperationsService(self)
    self.globalPublicDelegatedPrefixes = self.GlobalPublicDelegatedPrefixesService(self)
    self.healthChecks = self.HealthChecksService(self)
    self.httpHealthChecks = self.HttpHealthChecksService(self)
    self.httpsHealthChecks = self.HttpsHealthChecksService(self)
    self.imageFamilyViews = self.ImageFamilyViewsService(self)
    self.images = self.ImagesService(self)
    self.instanceGroupManagers = self.InstanceGroupManagersService(self)
    self.instanceGroups = self.InstanceGroupsService(self)
    self.instanceTemplates = self.InstanceTemplatesService(self)
    self.instances = self.InstancesService(self)
    self.interconnectAttachments = self.InterconnectAttachmentsService(self)
    self.interconnectLocations = self.InterconnectLocationsService(self)
    self.interconnects = self.InterconnectsService(self)
    self.licenseCodes = self.LicenseCodesService(self)
    self.licenses = self.LicensesService(self)
    self.machineImages = self.MachineImagesService(self)
    self.machineTypes = self.MachineTypesService(self)
    self.networkEdgeSecurityServices = self.NetworkEdgeSecurityServicesService(self)
    self.networkEndpointGroups = self.NetworkEndpointGroupsService(self)
    self.networkFirewallPolicies = self.NetworkFirewallPoliciesService(self)
    self.networks = self.NetworksService(self)
    self.nodeGroups = self.NodeGroupsService(self)
    self.nodeTemplates = self.NodeTemplatesService(self)
    self.nodeTypes = self.NodeTypesService(self)
    self.organizationSecurityPolicies = self.OrganizationSecurityPoliciesService(self)
    self.packetMirrorings = self.PacketMirroringsService(self)
    self.projects = self.ProjectsService(self)
    self.publicAdvertisedPrefixes = self.PublicAdvertisedPrefixesService(self)
    self.publicDelegatedPrefixes = self.PublicDelegatedPrefixesService(self)
    self.regionAutoscalers = self.RegionAutoscalersService(self)
    self.regionBackendServices = self.RegionBackendServicesService(self)
    self.regionCommitments = self.RegionCommitmentsService(self)
    self.regionDiskTypes = self.RegionDiskTypesService(self)
    self.regionDisks = self.RegionDisksService(self)
    self.regionHealthCheckServices = self.RegionHealthCheckServicesService(self)
    self.regionHealthChecks = self.RegionHealthChecksService(self)
    self.regionInstanceGroupManagers = self.RegionInstanceGroupManagersService(self)
    self.regionInstanceGroups = self.RegionInstanceGroupsService(self)
    self.regionInstances = self.RegionInstancesService(self)
    self.regionNetworkEndpointGroups = self.RegionNetworkEndpointGroupsService(self)
    self.regionNetworkFirewallPolicies = self.RegionNetworkFirewallPoliciesService(self)
    self.regionNotificationEndpoints = self.RegionNotificationEndpointsService(self)
    self.regionOperations = self.RegionOperationsService(self)
    self.regionSecurityPolicies = self.RegionSecurityPoliciesService(self)
    self.regionSslCertificates = self.RegionSslCertificatesService(self)
    self.regionSslPolicies = self.RegionSslPoliciesService(self)
    self.regionTargetHttpProxies = self.RegionTargetHttpProxiesService(self)
    self.regionTargetHttpsProxies = self.RegionTargetHttpsProxiesService(self)
    self.regionTargetTcpProxies = self.RegionTargetTcpProxiesService(self)
    self.regionUrlMaps = self.RegionUrlMapsService(self)
    self.regions = self.RegionsService(self)
    self.reservations = self.ReservationsService(self)
    self.resourcePolicies = self.ResourcePoliciesService(self)
    self.routers = self.RoutersService(self)
    self.routes = self.RoutesService(self)
    self.securityPolicies = self.SecurityPoliciesService(self)
    self.serviceAttachments = self.ServiceAttachmentsService(self)
    self.snapshots = self.SnapshotsService(self)
    self.sslCertificates = self.SslCertificatesService(self)
    self.sslPolicies = self.SslPoliciesService(self)
    self.subnetworks = self.SubnetworksService(self)
    self.targetGrpcProxies = self.TargetGrpcProxiesService(self)
    self.targetHttpProxies = self.TargetHttpProxiesService(self)
    self.targetHttpsProxies = self.TargetHttpsProxiesService(self)
    self.targetInstances = self.TargetInstancesService(self)
    self.targetPools = self.TargetPoolsService(self)
    self.targetSslProxies = self.TargetSslProxiesService(self)
    self.targetTcpProxies = self.TargetTcpProxiesService(self)
    self.targetVpnGateways = self.TargetVpnGatewaysService(self)
    self.urlMaps = self.UrlMapsService(self)
    self.vpnGateways = self.VpnGatewaysService(self)
    self.vpnTunnels = self.VpnTunnelsService(self)
    self.zoneOperations = self.ZoneOperationsService(self)
    self.zones = self.ZonesService(self)

  class AcceleratorTypesService(base_api.BaseApiService):
    """Service class for the acceleratorTypes resource."""

    _NAME = 'acceleratorTypes'

    def __init__(self, client):
      super(ComputeBeta.AcceleratorTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of accelerator types.

      Args:
        request: (ComputeAcceleratorTypesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AcceleratorTypeAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.acceleratorTypes.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/acceleratorTypes',
        request_field='',
        request_type_name='ComputeAcceleratorTypesAggregatedListRequest',
        response_type_name='AcceleratorTypeAggregatedList',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified accelerator type.

      Args:
        request: (ComputeAcceleratorTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AcceleratorType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.acceleratorTypes.get',
        ordered_params=['project', 'zone', 'acceleratorType'],
        path_params=['acceleratorType', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/acceleratorTypes/{acceleratorType}',
        request_field='',
        request_type_name='ComputeAcceleratorTypesGetRequest',
        response_type_name='AcceleratorType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of accelerator types that are available to the specified project.

      Args:
        request: (ComputeAcceleratorTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AcceleratorTypeList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.acceleratorTypes.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/acceleratorTypes',
        request_field='',
        request_type_name='ComputeAcceleratorTypesListRequest',
        response_type_name='AcceleratorTypeList',
        supports_download=False,
    )

  class AddressesService(base_api.BaseApiService):
    """Service class for the addresses resource."""

    _NAME = 'addresses'

    def __init__(self, client):
      super(ComputeBeta.AddressesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of addresses.

      Args:
        request: (ComputeAddressesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AddressAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.addresses.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/addresses',
        request_field='',
        request_type_name='ComputeAddressesAggregatedListRequest',
        response_type_name='AddressAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified address resource.

      Args:
        request: (ComputeAddressesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.addresses.delete',
        ordered_params=['project', 'region', 'address'],
        path_params=['address', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/addresses/{address}',
        request_field='',
        request_type_name='ComputeAddressesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified address resource.

      Args:
        request: (ComputeAddressesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Address) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.addresses.get',
        ordered_params=['project', 'region', 'address'],
        path_params=['address', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/addresses/{address}',
        request_field='',
        request_type_name='ComputeAddressesGetRequest',
        response_type_name='Address',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an address resource in the specified project by using the data included in the request.

      Args:
        request: (ComputeAddressesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.addresses.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/addresses',
        request_field='address',
        request_type_name='ComputeAddressesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of addresses contained within the specified region.

      Args:
        request: (ComputeAddressesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AddressList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.addresses.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/addresses',
        request_field='',
        request_type_name='ComputeAddressesListRequest',
        response_type_name='AddressList',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on an Address. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeAddressesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.addresses.setLabels',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/addresses/{resource}/setLabels',
        request_field='regionSetLabelsRequest',
        request_type_name='ComputeAddressesSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeAddressesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.addresses.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/addresses/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeAddressesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class AutoscalersService(base_api.BaseApiService):
    """Service class for the autoscalers resource."""

    _NAME = 'autoscalers'

    def __init__(self, client):
      super(ComputeBeta.AutoscalersService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of autoscalers.

      Args:
        request: (ComputeAutoscalersAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AutoscalerAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.autoscalers.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/autoscalers',
        request_field='',
        request_type_name='ComputeAutoscalersAggregatedListRequest',
        response_type_name='AutoscalerAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified autoscaler.

      Args:
        request: (ComputeAutoscalersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.autoscalers.delete',
        ordered_params=['project', 'zone', 'autoscaler'],
        path_params=['autoscaler', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/autoscalers/{autoscaler}',
        request_field='',
        request_type_name='ComputeAutoscalersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified autoscaler resource. Gets a list of available autoscalers by making a list() request.

      Args:
        request: (ComputeAutoscalersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Autoscaler) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.autoscalers.get',
        ordered_params=['project', 'zone', 'autoscaler'],
        path_params=['autoscaler', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/autoscalers/{autoscaler}',
        request_field='',
        request_type_name='ComputeAutoscalersGetRequest',
        response_type_name='Autoscaler',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an autoscaler in the specified project using the data included in the request.

      Args:
        request: (ComputeAutoscalersInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.autoscalers.insert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/autoscalers',
        request_field='autoscaler',
        request_type_name='ComputeAutoscalersInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of autoscalers contained within the specified zone.

      Args:
        request: (ComputeAutoscalersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AutoscalerList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.autoscalers.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/autoscalers',
        request_field='',
        request_type_name='ComputeAutoscalersListRequest',
        response_type_name='AutoscalerList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an autoscaler in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeAutoscalersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.autoscalers.patch',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['autoscaler', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/autoscalers',
        request_field='autoscalerResource',
        request_type_name='ComputeAutoscalersPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeAutoscalersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.autoscalers.testIamPermissions',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/autoscalers/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeAutoscalersTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an autoscaler in the specified project using the data included in the request.

      Args:
        request: (ComputeAutoscalersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.autoscalers.update',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['autoscaler', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/autoscalers',
        request_field='autoscalerResource',
        request_type_name='ComputeAutoscalersUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class BackendBucketsService(base_api.BaseApiService):
    """Service class for the backendBuckets resource."""

    _NAME = 'backendBuckets'

    def __init__(self, client):
      super(ComputeBeta.BackendBucketsService, self).__init__(client)
      self._upload_configs = {
          }

    def AddSignedUrlKey(self, request, global_params=None):
      r"""Adds a key for validating requests with signed URLs for this backend bucket.

      Args:
        request: (ComputeBackendBucketsAddSignedUrlKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddSignedUrlKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddSignedUrlKey.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendBuckets.addSignedUrlKey',
        ordered_params=['project', 'backendBucket'],
        path_params=['backendBucket', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendBuckets/{backendBucket}/addSignedUrlKey',
        request_field='signedUrlKey',
        request_type_name='ComputeBackendBucketsAddSignedUrlKeyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified BackendBucket resource.

      Args:
        request: (ComputeBackendBucketsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.backendBuckets.delete',
        ordered_params=['project', 'backendBucket'],
        path_params=['backendBucket', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendBuckets/{backendBucket}',
        request_field='',
        request_type_name='ComputeBackendBucketsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DeleteSignedUrlKey(self, request, global_params=None):
      r"""Deletes a key for validating requests with signed URLs for this backend bucket.

      Args:
        request: (ComputeBackendBucketsDeleteSignedUrlKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteSignedUrlKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteSignedUrlKey.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendBuckets.deleteSignedUrlKey',
        ordered_params=['project', 'backendBucket', 'keyName'],
        path_params=['backendBucket', 'project'],
        query_params=['keyName', 'requestId'],
        relative_path='projects/{project}/global/backendBuckets/{backendBucket}/deleteSignedUrlKey',
        request_field='',
        request_type_name='ComputeBackendBucketsDeleteSignedUrlKeyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified BackendBucket resource. Gets a list of available backend buckets by making a list() request.

      Args:
        request: (ComputeBackendBucketsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendBucket) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.backendBuckets.get',
        ordered_params=['project', 'backendBucket'],
        path_params=['backendBucket', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/backendBuckets/{backendBucket}',
        request_field='',
        request_type_name='ComputeBackendBucketsGetRequest',
        response_type_name='BackendBucket',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeBackendBucketsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.backendBuckets.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/backendBuckets/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeBackendBucketsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a BackendBucket resource in the specified project using the data included in the request.

      Args:
        request: (ComputeBackendBucketsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendBuckets.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendBuckets',
        request_field='backendBucket',
        request_type_name='ComputeBackendBucketsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of BackendBucket resources available to the specified project.

      Args:
        request: (ComputeBackendBucketsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendBucketList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.backendBuckets.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/backendBuckets',
        request_field='',
        request_type_name='ComputeBackendBucketsListRequest',
        response_type_name='BackendBucketList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified BackendBucket resource with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeBackendBucketsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.backendBuckets.patch',
        ordered_params=['project', 'backendBucket'],
        path_params=['backendBucket', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendBuckets/{backendBucket}',
        request_field='backendBucketResource',
        request_type_name='ComputeBackendBucketsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetEdgeSecurityPolicy(self, request, global_params=None):
      r"""Sets the edge security policy for the specified backend bucket.

      Args:
        request: (ComputeBackendBucketsSetEdgeSecurityPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetEdgeSecurityPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetEdgeSecurityPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendBuckets.setEdgeSecurityPolicy',
        ordered_params=['project', 'backendBucket'],
        path_params=['backendBucket', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendBuckets/{backendBucket}/setEdgeSecurityPolicy',
        request_field='securityPolicyReference',
        request_type_name='ComputeBackendBucketsSetEdgeSecurityPolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeBackendBucketsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendBuckets.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/backendBuckets/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeBackendBucketsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeBackendBucketsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendBuckets.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/backendBuckets/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeBackendBucketsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified BackendBucket resource with the data included in the request.

      Args:
        request: (ComputeBackendBucketsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.backendBuckets.update',
        ordered_params=['project', 'backendBucket'],
        path_params=['backendBucket', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendBuckets/{backendBucket}',
        request_field='backendBucketResource',
        request_type_name='ComputeBackendBucketsUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class BackendServicesService(base_api.BaseApiService):
    """Service class for the backendServices resource."""

    _NAME = 'backendServices'

    def __init__(self, client):
      super(ComputeBeta.BackendServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddSignedUrlKey(self, request, global_params=None):
      r"""Adds a key for validating requests with signed URLs for this backend service.

      Args:
        request: (ComputeBackendServicesAddSignedUrlKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddSignedUrlKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddSignedUrlKey.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendServices.addSignedUrlKey',
        ordered_params=['project', 'backendService'],
        path_params=['backendService', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendServices/{backendService}/addSignedUrlKey',
        request_field='signedUrlKey',
        request_type_name='ComputeBackendServicesAddSignedUrlKeyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all BackendService resources, regional and global, available to the specified project.

      Args:
        request: (ComputeBackendServicesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendServiceAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.backendServices.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/backendServices',
        request_field='',
        request_type_name='ComputeBackendServicesAggregatedListRequest',
        response_type_name='BackendServiceAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified BackendService resource.

      Args:
        request: (ComputeBackendServicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.backendServices.delete',
        ordered_params=['project', 'backendService'],
        path_params=['backendService', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendServices/{backendService}',
        request_field='',
        request_type_name='ComputeBackendServicesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DeleteSignedUrlKey(self, request, global_params=None):
      r"""Deletes a key for validating requests with signed URLs for this backend service.

      Args:
        request: (ComputeBackendServicesDeleteSignedUrlKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteSignedUrlKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteSignedUrlKey.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendServices.deleteSignedUrlKey',
        ordered_params=['project', 'backendService', 'keyName'],
        path_params=['backendService', 'project'],
        query_params=['keyName', 'requestId'],
        relative_path='projects/{project}/global/backendServices/{backendService}/deleteSignedUrlKey',
        request_field='',
        request_type_name='ComputeBackendServicesDeleteSignedUrlKeyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified BackendService resource. Gets a list of available backend services.

      Args:
        request: (ComputeBackendServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendService) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.backendServices.get',
        ordered_params=['project', 'backendService'],
        path_params=['backendService', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/backendServices/{backendService}',
        request_field='',
        request_type_name='ComputeBackendServicesGetRequest',
        response_type_name='BackendService',
        supports_download=False,
    )

    def GetHealth(self, request, global_params=None):
      r"""Gets the most recent health check results for this BackendService. Example request body: { "group": "/zones/us-east1-b/instanceGroups/lb-backend-example" }.

      Args:
        request: (ComputeBackendServicesGetHealthRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendServiceGroupHealth) The response message.
      """
      config = self.GetMethodConfig('GetHealth')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetHealth.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendServices.getHealth',
        ordered_params=['project', 'backendService'],
        path_params=['backendService', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/backendServices/{backendService}/getHealth',
        request_field='resourceGroupReference',
        request_type_name='ComputeBackendServicesGetHealthRequest',
        response_type_name='BackendServiceGroupHealth',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeBackendServicesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.backendServices.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/backendServices/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeBackendServicesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a BackendService resource in the specified project using the data included in the request. For more information, see Backend services overview .

      Args:
        request: (ComputeBackendServicesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendServices.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendServices',
        request_field='backendService',
        request_type_name='ComputeBackendServicesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of BackendService resources available to the specified project.

      Args:
        request: (ComputeBackendServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendServiceList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.backendServices.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/backendServices',
        request_field='',
        request_type_name='ComputeBackendServicesListRequest',
        response_type_name='BackendServiceList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified BackendService resource with the data included in the request. For more information, see Backend services overview. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeBackendServicesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.backendServices.patch',
        ordered_params=['project', 'backendService'],
        path_params=['backendService', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendServices/{backendService}',
        request_field='backendServiceResource',
        request_type_name='ComputeBackendServicesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetEdgeSecurityPolicy(self, request, global_params=None):
      r"""Sets the edge security policy for the specified backend service.

      Args:
        request: (ComputeBackendServicesSetEdgeSecurityPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetEdgeSecurityPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetEdgeSecurityPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendServices.setEdgeSecurityPolicy',
        ordered_params=['project', 'backendService'],
        path_params=['backendService', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendServices/{backendService}/setEdgeSecurityPolicy',
        request_field='securityPolicyReference',
        request_type_name='ComputeBackendServicesSetEdgeSecurityPolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeBackendServicesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendServices.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/backendServices/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeBackendServicesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetSecurityPolicy(self, request, global_params=None):
      r"""Sets the Google Cloud Armor security policy for the specified backend service. For more information, see Google Cloud Armor Overview.

      Args:
        request: (ComputeBackendServicesSetSecurityPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSecurityPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSecurityPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendServices.setSecurityPolicy',
        ordered_params=['project', 'backendService'],
        path_params=['backendService', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendServices/{backendService}/setSecurityPolicy',
        request_field='securityPolicyReference',
        request_type_name='ComputeBackendServicesSetSecurityPolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeBackendServicesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.backendServices.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/backendServices/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeBackendServicesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified BackendService resource with the data included in the request. For more information, see Backend services overview.

      Args:
        request: (ComputeBackendServicesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.backendServices.update',
        ordered_params=['project', 'backendService'],
        path_params=['backendService', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/backendServices/{backendService}',
        request_field='backendServiceResource',
        request_type_name='ComputeBackendServicesUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class DiskTypesService(base_api.BaseApiService):
    """Service class for the diskTypes resource."""

    _NAME = 'diskTypes'

    def __init__(self, client):
      super(ComputeBeta.DiskTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of disk types.

      Args:
        request: (ComputeDiskTypesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskTypeAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.diskTypes.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/diskTypes',
        request_field='',
        request_type_name='ComputeDiskTypesAggregatedListRequest',
        response_type_name='DiskTypeAggregatedList',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified disk type. Gets a list of available disk types by making a list() request.

      Args:
        request: (ComputeDiskTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.diskTypes.get',
        ordered_params=['project', 'zone', 'diskType'],
        path_params=['diskType', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/diskTypes/{diskType}',
        request_field='',
        request_type_name='ComputeDiskTypesGetRequest',
        response_type_name='DiskType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of disk types available to the specified project.

      Args:
        request: (ComputeDiskTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskTypeList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.diskTypes.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/diskTypes',
        request_field='',
        request_type_name='ComputeDiskTypesListRequest',
        response_type_name='DiskTypeList',
        supports_download=False,
    )

  class DisksService(base_api.BaseApiService):
    """Service class for the disks resource."""

    _NAME = 'disks'

    def __init__(self, client):
      super(ComputeBeta.DisksService, self).__init__(client)
      self._upload_configs = {
          }

    def AddResourcePolicies(self, request, global_params=None):
      r"""Adds existing resource policies to a disk. You can only add one policy which will be applied to this disk for scheduling snapshot creation.

      Args:
        request: (ComputeDisksAddResourcePoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddResourcePolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddResourcePolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.addResourcePolicies',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}/addResourcePolicies',
        request_field='disksAddResourcePoliciesRequest',
        request_type_name='ComputeDisksAddResourcePoliciesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of persistent disks.

      Args:
        request: (ComputeDisksAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.disks.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/disks',
        request_field='',
        request_type_name='ComputeDisksAggregatedListRequest',
        response_type_name='DiskAggregatedList',
        supports_download=False,
    )

    def CreateSnapshot(self, request, global_params=None):
      r"""Creates a snapshot of a specified persistent disk. For regular snapshot creation, consider using snapshots.insert instead, as that method supports more features, such as creating snapshots in a project different from the source disk project.

      Args:
        request: (ComputeDisksCreateSnapshotRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CreateSnapshot')
      return self._RunMethod(
          config, request, global_params=global_params)

    CreateSnapshot.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.createSnapshot',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=['guestFlush', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}/createSnapshot',
        request_field='snapshot',
        request_type_name='ComputeDisksCreateSnapshotRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified persistent disk. Deleting a disk removes its data permanently and is irreversible. However, deleting a disk does not delete any snapshots previously made from the disk. You must separately delete snapshots.

      Args:
        request: (ComputeDisksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.disks.delete',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}',
        request_field='',
        request_type_name='ComputeDisksDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns a specified persistent disk. Gets a list of available persistent disks by making a list() request.

      Args:
        request: (ComputeDisksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Disk) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.disks.get',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}',
        request_field='',
        request_type_name='ComputeDisksGetRequest',
        response_type_name='Disk',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeDisksGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.disks.getIamPolicy',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/zones/{zone}/disks/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeDisksGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a persistent disk in the specified project using the data in the request. You can create a disk from a source (sourceImage, sourceSnapshot, or sourceDisk) or create an empty 500 GB data disk by omitting all properties. You can also create a disk that is larger than the default size by specifying the sizeGb property.

      Args:
        request: (ComputeDisksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.insert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId', 'sourceImage'],
        relative_path='projects/{project}/zones/{zone}/disks',
        request_field='disk',
        request_type_name='ComputeDisksInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of persistent disks contained within the specified zone.

      Args:
        request: (ComputeDisksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.disks.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/disks',
        request_field='',
        request_type_name='ComputeDisksListRequest',
        response_type_name='DiskList',
        supports_download=False,
    )

    def RemoveResourcePolicies(self, request, global_params=None):
      r"""Removes resource policies from a disk.

      Args:
        request: (ComputeDisksRemoveResourcePoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveResourcePolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveResourcePolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.removeResourcePolicies',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}/removeResourcePolicies',
        request_field='disksRemoveResourcePoliciesRequest',
        request_type_name='ComputeDisksRemoveResourcePoliciesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Resize(self, request, global_params=None):
      r"""Resizes the specified persistent disk. You can only increase the size of the disk.

      Args:
        request: (ComputeDisksResizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Resize')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resize.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.resize',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}/resize',
        request_field='disksResizeRequest',
        request_type_name='ComputeDisksResizeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeDisksSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.setIamPolicy',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/disks/{resource}/setIamPolicy',
        request_field='zoneSetPolicyRequest',
        request_type_name='ComputeDisksSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a disk. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeDisksSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.setLabels',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/disks/{resource}/setLabels',
        request_field='zoneSetLabelsRequest',
        request_type_name='ComputeDisksSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeDisksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.disks.testIamPermissions',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/disks/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeDisksTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified disk with the data included in the request. The update is performed only on selected fields included as part of update-mask. Only the following fields can be modified: user_license.

      Args:
        request: (ComputeDisksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.disks.update',
        ordered_params=['project', 'zone', 'disk'],
        path_params=['disk', 'project', 'zone'],
        query_params=['paths', 'requestId', 'updateMask'],
        relative_path='projects/{project}/zones/{zone}/disks/{disk}',
        request_field='diskResource',
        request_type_name='ComputeDisksUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ExternalVpnGatewaysService(base_api.BaseApiService):
    """Service class for the externalVpnGateways resource."""

    _NAME = 'externalVpnGateways'

    def __init__(self, client):
      super(ComputeBeta.ExternalVpnGatewaysService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified externalVpnGateway.

      Args:
        request: (ComputeExternalVpnGatewaysDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.externalVpnGateways.delete',
        ordered_params=['project', 'externalVpnGateway'],
        path_params=['externalVpnGateway', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/externalVpnGateways/{externalVpnGateway}',
        request_field='',
        request_type_name='ComputeExternalVpnGatewaysDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified externalVpnGateway. Get a list of available externalVpnGateways by making a list() request.

      Args:
        request: (ComputeExternalVpnGatewaysGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ExternalVpnGateway) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.externalVpnGateways.get',
        ordered_params=['project', 'externalVpnGateway'],
        path_params=['externalVpnGateway', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/externalVpnGateways/{externalVpnGateway}',
        request_field='',
        request_type_name='ComputeExternalVpnGatewaysGetRequest',
        response_type_name='ExternalVpnGateway',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a ExternalVpnGateway in the specified project using the data included in the request.

      Args:
        request: (ComputeExternalVpnGatewaysInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.externalVpnGateways.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/externalVpnGateways',
        request_field='externalVpnGateway',
        request_type_name='ComputeExternalVpnGatewaysInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of ExternalVpnGateway available to the specified project.

      Args:
        request: (ComputeExternalVpnGatewaysListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ExternalVpnGatewayList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.externalVpnGateways.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/externalVpnGateways',
        request_field='',
        request_type_name='ComputeExternalVpnGatewaysListRequest',
        response_type_name='ExternalVpnGatewayList',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on an ExternalVpnGateway. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeExternalVpnGatewaysSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.externalVpnGateways.setLabels',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/externalVpnGateways/{resource}/setLabels',
        request_field='globalSetLabelsRequest',
        request_type_name='ComputeExternalVpnGatewaysSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeExternalVpnGatewaysTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.externalVpnGateways.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/externalVpnGateways/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeExternalVpnGatewaysTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class FirewallPoliciesService(base_api.BaseApiService):
    """Service class for the firewallPolicies resource."""

    _NAME = 'firewallPolicies'

    def __init__(self, client):
      super(ComputeBeta.FirewallPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddAssociation(self, request, global_params=None):
      r"""Inserts an association for the specified firewall policy.

      Args:
        request: (ComputeFirewallPoliciesAddAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.addAssociation',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['replaceExistingAssociation', 'requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/addAssociation',
        request_field='firewallPolicyAssociation',
        request_type_name='ComputeFirewallPoliciesAddAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AddRule(self, request, global_params=None):
      r"""Inserts a rule into a firewall policy.

      Args:
        request: (ComputeFirewallPoliciesAddRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.addRule',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/addRule',
        request_field='firewallPolicyRule',
        request_type_name='ComputeFirewallPoliciesAddRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def CloneRules(self, request, global_params=None):
      r"""Copies rules to the specified firewall policy.

      Args:
        request: (ComputeFirewallPoliciesCloneRulesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CloneRules')
      return self._RunMethod(
          config, request, global_params=global_params)

    CloneRules.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.cloneRules',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['requestId', 'sourceFirewallPolicy'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/cloneRules',
        request_field='',
        request_type_name='ComputeFirewallPoliciesCloneRulesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified policy.

      Args:
        request: (ComputeFirewallPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.firewallPolicies.delete',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}',
        request_field='',
        request_type_name='ComputeFirewallPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified firewall policy.

      Args:
        request: (ComputeFirewallPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.firewallPolicies.get',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=[],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}',
        request_field='',
        request_type_name='ComputeFirewallPoliciesGetRequest',
        response_type_name='FirewallPolicy',
        supports_download=False,
    )

    def GetAssociation(self, request, global_params=None):
      r"""Gets an association with the specified name.

      Args:
        request: (ComputeFirewallPoliciesGetAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyAssociation) The response message.
      """
      config = self.GetMethodConfig('GetAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.firewallPolicies.getAssociation',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['name'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/getAssociation',
        request_field='',
        request_type_name='ComputeFirewallPoliciesGetAssociationRequest',
        response_type_name='FirewallPolicyAssociation',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeFirewallPoliciesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.firewallPolicies.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='locations/global/firewallPolicies/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeFirewallPoliciesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def GetRule(self, request, global_params=None):
      r"""Gets a rule of the specified priority.

      Args:
        request: (ComputeFirewallPoliciesGetRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyRule) The response message.
      """
      config = self.GetMethodConfig('GetRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.firewallPolicies.getRule',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['priority'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/getRule',
        request_field='',
        request_type_name='ComputeFirewallPoliciesGetRuleRequest',
        response_type_name='FirewallPolicyRule',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new policy in the specified project using the data included in the request.

      Args:
        request: (ComputeFirewallPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.insert',
        ordered_params=[],
        path_params=[],
        query_params=['parentId', 'requestId'],
        relative_path='locations/global/firewallPolicies',
        request_field='firewallPolicy',
        request_type_name='ComputeFirewallPoliciesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the policies that have been configured for the specified folder or organization.

      Args:
        request: (ComputeFirewallPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.firewallPolicies.list',
        ordered_params=[],
        path_params=[],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'parentId', 'returnPartialSuccess'],
        relative_path='locations/global/firewallPolicies',
        request_field='',
        request_type_name='ComputeFirewallPoliciesListRequest',
        response_type_name='FirewallPolicyList',
        supports_download=False,
    )

    def ListAssociations(self, request, global_params=None):
      r"""Lists associations of a specified target, i.e., organization or folder.

      Args:
        request: (ComputeFirewallPoliciesListAssociationsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPoliciesListAssociationsResponse) The response message.
      """
      config = self.GetMethodConfig('ListAssociations')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListAssociations.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.firewallPolicies.listAssociations',
        ordered_params=[],
        path_params=[],
        query_params=['targetResource'],
        relative_path='locations/global/firewallPolicies/listAssociations',
        request_field='',
        request_type_name='ComputeFirewallPoliciesListAssociationsRequest',
        response_type_name='FirewallPoliciesListAssociationsResponse',
        supports_download=False,
    )

    def Move(self, request, global_params=None):
      r"""Moves the specified firewall policy.

      Args:
        request: (ComputeFirewallPoliciesMoveRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Move')
      return self._RunMethod(
          config, request, global_params=global_params)

    Move.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.move',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['parentId', 'requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/move',
        request_field='',
        request_type_name='ComputeFirewallPoliciesMoveRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified policy with the data included in the request.

      Args:
        request: (ComputeFirewallPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.firewallPolicies.patch',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}',
        request_field='firewallPolicyResource',
        request_type_name='ComputeFirewallPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchRule(self, request, global_params=None):
      r"""Patches a rule of the specified priority.

      Args:
        request: (ComputeFirewallPoliciesPatchRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.patchRule',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['priority', 'requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/patchRule',
        request_field='firewallPolicyRule',
        request_type_name='ComputeFirewallPoliciesPatchRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveAssociation(self, request, global_params=None):
      r"""Removes an association for the specified firewall policy.

      Args:
        request: (ComputeFirewallPoliciesRemoveAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.removeAssociation',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['name', 'requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/removeAssociation',
        request_field='',
        request_type_name='ComputeFirewallPoliciesRemoveAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveRule(self, request, global_params=None):
      r"""Deletes a rule of the specified priority.

      Args:
        request: (ComputeFirewallPoliciesRemoveRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.removeRule',
        ordered_params=['firewallPolicy'],
        path_params=['firewallPolicy'],
        query_params=['priority', 'requestId'],
        relative_path='locations/global/firewallPolicies/{firewallPolicy}/removeRule',
        request_field='',
        request_type_name='ComputeFirewallPoliciesRemoveRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeFirewallPoliciesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='locations/global/firewallPolicies/{resource}/setIamPolicy',
        request_field='globalOrganizationSetPolicyRequest',
        request_type_name='ComputeFirewallPoliciesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeFirewallPoliciesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewallPolicies.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='locations/global/firewallPolicies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeFirewallPoliciesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class FirewallsService(base_api.BaseApiService):
    """Service class for the firewalls resource."""

    _NAME = 'firewalls'

    def __init__(self, client):
      super(ComputeBeta.FirewallsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified firewall.

      Args:
        request: (ComputeFirewallsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.firewalls.delete',
        ordered_params=['project', 'firewall'],
        path_params=['firewall', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/firewalls/{firewall}',
        request_field='',
        request_type_name='ComputeFirewallsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified firewall.

      Args:
        request: (ComputeFirewallsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Firewall) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.firewalls.get',
        ordered_params=['project', 'firewall'],
        path_params=['firewall', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/firewalls/{firewall}',
        request_field='',
        request_type_name='ComputeFirewallsGetRequest',
        response_type_name='Firewall',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a firewall rule in the specified project using the data included in the request.

      Args:
        request: (ComputeFirewallsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewalls.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/firewalls',
        request_field='firewall',
        request_type_name='ComputeFirewallsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of firewall rules available to the specified project.

      Args:
        request: (ComputeFirewallsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.firewalls.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/firewalls',
        request_field='',
        request_type_name='ComputeFirewallsListRequest',
        response_type_name='FirewallList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified firewall rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeFirewallsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.firewalls.patch',
        ordered_params=['project', 'firewall'],
        path_params=['firewall', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/firewalls/{firewall}',
        request_field='firewallResource',
        request_type_name='ComputeFirewallsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeFirewallsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.firewalls.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/firewalls/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeFirewallsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified firewall rule with the data included in the request. Note that all fields will be updated if using PUT, even fields that are not specified. To update individual fields, please use PATCH instead.

      Args:
        request: (ComputeFirewallsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.firewalls.update',
        ordered_params=['project', 'firewall'],
        path_params=['firewall', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/firewalls/{firewall}',
        request_field='firewallResource',
        request_type_name='ComputeFirewallsUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ForwardingRulesService(base_api.BaseApiService):
    """Service class for the forwardingRules resource."""

    _NAME = 'forwardingRules'

    def __init__(self, client):
      super(ComputeBeta.ForwardingRulesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of forwarding rules.

      Args:
        request: (ComputeForwardingRulesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ForwardingRuleAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.forwardingRules.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/forwardingRules',
        request_field='',
        request_type_name='ComputeForwardingRulesAggregatedListRequest',
        response_type_name='ForwardingRuleAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified ForwardingRule resource.

      Args:
        request: (ComputeForwardingRulesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.forwardingRules.delete',
        ordered_params=['project', 'region', 'forwardingRule'],
        path_params=['forwardingRule', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/forwardingRules/{forwardingRule}',
        request_field='',
        request_type_name='ComputeForwardingRulesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified ForwardingRule resource.

      Args:
        request: (ComputeForwardingRulesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ForwardingRule) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.forwardingRules.get',
        ordered_params=['project', 'region', 'forwardingRule'],
        path_params=['forwardingRule', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/forwardingRules/{forwardingRule}',
        request_field='',
        request_type_name='ComputeForwardingRulesGetRequest',
        response_type_name='ForwardingRule',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a ForwardingRule resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeForwardingRulesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.forwardingRules.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/forwardingRules',
        request_field='forwardingRule',
        request_type_name='ComputeForwardingRulesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of ForwardingRule resources available to the specified project and region.

      Args:
        request: (ComputeForwardingRulesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ForwardingRuleList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.forwardingRules.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/forwardingRules',
        request_field='',
        request_type_name='ComputeForwardingRulesListRequest',
        response_type_name='ForwardingRuleList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified forwarding rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. Currently, you can only patch the network_tier field.

      Args:
        request: (ComputeForwardingRulesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.forwardingRules.patch',
        ordered_params=['project', 'region', 'forwardingRule'],
        path_params=['forwardingRule', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/forwardingRules/{forwardingRule}',
        request_field='forwardingRuleResource',
        request_type_name='ComputeForwardingRulesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on the specified resource. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeForwardingRulesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.forwardingRules.setLabels',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/forwardingRules/{resource}/setLabels',
        request_field='regionSetLabelsRequest',
        request_type_name='ComputeForwardingRulesSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetTarget(self, request, global_params=None):
      r"""Changes target URL for forwarding rule. The new target should be of the same type as the old target.

      Args:
        request: (ComputeForwardingRulesSetTargetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetTarget')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetTarget.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.forwardingRules.setTarget',
        ordered_params=['project', 'region', 'forwardingRule'],
        path_params=['forwardingRule', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/forwardingRules/{forwardingRule}/setTarget',
        request_field='targetReference',
        request_type_name='ComputeForwardingRulesSetTargetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeForwardingRulesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.forwardingRules.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/forwardingRules/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeForwardingRulesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class GlobalAddressesService(base_api.BaseApiService):
    """Service class for the globalAddresses resource."""

    _NAME = 'globalAddresses'

    def __init__(self, client):
      super(ComputeBeta.GlobalAddressesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified address resource.

      Args:
        request: (ComputeGlobalAddressesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.globalAddresses.delete',
        ordered_params=['project', 'address'],
        path_params=['address', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/addresses/{address}',
        request_field='',
        request_type_name='ComputeGlobalAddressesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified address resource. Gets a list of available addresses by making a list() request.

      Args:
        request: (ComputeGlobalAddressesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Address) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalAddresses.get',
        ordered_params=['project', 'address'],
        path_params=['address', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/addresses/{address}',
        request_field='',
        request_type_name='ComputeGlobalAddressesGetRequest',
        response_type_name='Address',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an address resource in the specified project by using the data included in the request.

      Args:
        request: (ComputeGlobalAddressesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalAddresses.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/addresses',
        request_field='address',
        request_type_name='ComputeGlobalAddressesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of global addresses.

      Args:
        request: (ComputeGlobalAddressesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AddressList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalAddresses.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/addresses',
        request_field='',
        request_type_name='ComputeGlobalAddressesListRequest',
        response_type_name='AddressList',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a GlobalAddress. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeGlobalAddressesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalAddresses.setLabels',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/addresses/{resource}/setLabels',
        request_field='globalSetLabelsRequest',
        request_type_name='ComputeGlobalAddressesSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeGlobalAddressesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalAddresses.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/addresses/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeGlobalAddressesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class GlobalForwardingRulesService(base_api.BaseApiService):
    """Service class for the globalForwardingRules resource."""

    _NAME = 'globalForwardingRules'

    def __init__(self, client):
      super(ComputeBeta.GlobalForwardingRulesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified GlobalForwardingRule resource.

      Args:
        request: (ComputeGlobalForwardingRulesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.globalForwardingRules.delete',
        ordered_params=['project', 'forwardingRule'],
        path_params=['forwardingRule', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/forwardingRules/{forwardingRule}',
        request_field='',
        request_type_name='ComputeGlobalForwardingRulesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified GlobalForwardingRule resource. Gets a list of available forwarding rules by making a list() request.

      Args:
        request: (ComputeGlobalForwardingRulesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ForwardingRule) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalForwardingRules.get',
        ordered_params=['project', 'forwardingRule'],
        path_params=['forwardingRule', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/forwardingRules/{forwardingRule}',
        request_field='',
        request_type_name='ComputeGlobalForwardingRulesGetRequest',
        response_type_name='ForwardingRule',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a GlobalForwardingRule resource in the specified project using the data included in the request.

      Args:
        request: (ComputeGlobalForwardingRulesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalForwardingRules.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/forwardingRules',
        request_field='forwardingRule',
        request_type_name='ComputeGlobalForwardingRulesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of GlobalForwardingRule resources available to the specified project.

      Args:
        request: (ComputeGlobalForwardingRulesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ForwardingRuleList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalForwardingRules.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/forwardingRules',
        request_field='',
        request_type_name='ComputeGlobalForwardingRulesListRequest',
        response_type_name='ForwardingRuleList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified forwarding rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. Currently, you can only patch the network_tier field.

      Args:
        request: (ComputeGlobalForwardingRulesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.globalForwardingRules.patch',
        ordered_params=['project', 'forwardingRule'],
        path_params=['forwardingRule', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/forwardingRules/{forwardingRule}',
        request_field='forwardingRuleResource',
        request_type_name='ComputeGlobalForwardingRulesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on the specified resource. To learn more about labels, read the Labeling resources documentation.

      Args:
        request: (ComputeGlobalForwardingRulesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalForwardingRules.setLabels',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/forwardingRules/{resource}/setLabels',
        request_field='globalSetLabelsRequest',
        request_type_name='ComputeGlobalForwardingRulesSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetTarget(self, request, global_params=None):
      r"""Changes target URL for the GlobalForwardingRule resource. The new target should be of the same type as the old target.

      Args:
        request: (ComputeGlobalForwardingRulesSetTargetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetTarget')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetTarget.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalForwardingRules.setTarget',
        ordered_params=['project', 'forwardingRule'],
        path_params=['forwardingRule', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/forwardingRules/{forwardingRule}/setTarget',
        request_field='targetReference',
        request_type_name='ComputeGlobalForwardingRulesSetTargetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeGlobalForwardingRulesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalForwardingRules.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/forwardingRules/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeGlobalForwardingRulesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class GlobalNetworkEndpointGroupsService(base_api.BaseApiService):
    """Service class for the globalNetworkEndpointGroups resource."""

    _NAME = 'globalNetworkEndpointGroups'

    def __init__(self, client):
      super(ComputeBeta.GlobalNetworkEndpointGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def AttachNetworkEndpoints(self, request, global_params=None):
      r"""Attach a network endpoint to the specified network endpoint group.

      Args:
        request: (ComputeGlobalNetworkEndpointGroupsAttachNetworkEndpointsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AttachNetworkEndpoints')
      return self._RunMethod(
          config, request, global_params=global_params)

    AttachNetworkEndpoints.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalNetworkEndpointGroups.attachNetworkEndpoints',
        ordered_params=['project', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networkEndpointGroups/{networkEndpointGroup}/attachNetworkEndpoints',
        request_field='globalNetworkEndpointGroupsAttachEndpointsRequest',
        request_type_name='ComputeGlobalNetworkEndpointGroupsAttachNetworkEndpointsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified network endpoint group.Note that the NEG cannot be deleted if there are backend services referencing it.

      Args:
        request: (ComputeGlobalNetworkEndpointGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.globalNetworkEndpointGroups.delete',
        ordered_params=['project', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networkEndpointGroups/{networkEndpointGroup}',
        request_field='',
        request_type_name='ComputeGlobalNetworkEndpointGroupsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DetachNetworkEndpoints(self, request, global_params=None):
      r"""Detach the network endpoint from the specified network endpoint group.

      Args:
        request: (ComputeGlobalNetworkEndpointGroupsDetachNetworkEndpointsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DetachNetworkEndpoints')
      return self._RunMethod(
          config, request, global_params=global_params)

    DetachNetworkEndpoints.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalNetworkEndpointGroups.detachNetworkEndpoints',
        ordered_params=['project', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networkEndpointGroups/{networkEndpointGroup}/detachNetworkEndpoints',
        request_field='globalNetworkEndpointGroupsDetachEndpointsRequest',
        request_type_name='ComputeGlobalNetworkEndpointGroupsDetachNetworkEndpointsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified network endpoint group. Gets a list of available network endpoint groups by making a list() request.

      Args:
        request: (ComputeGlobalNetworkEndpointGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalNetworkEndpointGroups.get',
        ordered_params=['project', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/networkEndpointGroups/{networkEndpointGroup}',
        request_field='',
        request_type_name='ComputeGlobalNetworkEndpointGroupsGetRequest',
        response_type_name='NetworkEndpointGroup',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a network endpoint group in the specified project using the parameters that are included in the request.

      Args:
        request: (ComputeGlobalNetworkEndpointGroupsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalNetworkEndpointGroups.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networkEndpointGroups',
        request_field='networkEndpointGroup',
        request_type_name='ComputeGlobalNetworkEndpointGroupsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of network endpoint groups that are located in the specified project.

      Args:
        request: (ComputeGlobalNetworkEndpointGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroupList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalNetworkEndpointGroups.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/networkEndpointGroups',
        request_field='',
        request_type_name='ComputeGlobalNetworkEndpointGroupsListRequest',
        response_type_name='NetworkEndpointGroupList',
        supports_download=False,
    )

    def ListNetworkEndpoints(self, request, global_params=None):
      r"""Lists the network endpoints in the specified network endpoint group.

      Args:
        request: (ComputeGlobalNetworkEndpointGroupsListNetworkEndpointsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroupsListNetworkEndpoints) The response message.
      """
      config = self.GetMethodConfig('ListNetworkEndpoints')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListNetworkEndpoints.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalNetworkEndpointGroups.listNetworkEndpoints',
        ordered_params=['project', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/networkEndpointGroups/{networkEndpointGroup}/listNetworkEndpoints',
        request_field='',
        request_type_name='ComputeGlobalNetworkEndpointGroupsListNetworkEndpointsRequest',
        response_type_name='NetworkEndpointGroupsListNetworkEndpoints',
        supports_download=False,
    )

  class GlobalOperationsService(base_api.BaseApiService):
    """Service class for the globalOperations resource."""

    _NAME = 'globalOperations'

    def __init__(self, client):
      super(ComputeBeta.GlobalOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of all operations.

      Args:
        request: (ComputeGlobalOperationsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OperationAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalOperations.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/operations',
        request_field='',
        request_type_name='ComputeGlobalOperationsAggregatedListRequest',
        response_type_name='OperationAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Operations resource.

      Args:
        request: (ComputeGlobalOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ComputeGlobalOperationsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.globalOperations.delete',
        ordered_params=['project', 'operation'],
        path_params=['operation', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/operations/{operation}',
        request_field='',
        request_type_name='ComputeGlobalOperationsDeleteRequest',
        response_type_name='ComputeGlobalOperationsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the specified Operations resource.

      Args:
        request: (ComputeGlobalOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalOperations.get',
        ordered_params=['project', 'operation'],
        path_params=['operation', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/operations/{operation}',
        request_field='',
        request_type_name='ComputeGlobalOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of Operation resources contained within the specified project.

      Args:
        request: (ComputeGlobalOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OperationList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalOperations.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/operations',
        request_field='',
        request_type_name='ComputeGlobalOperationsListRequest',
        response_type_name='OperationList',
        supports_download=False,
    )

    def Wait(self, request, global_params=None):
      r"""Waits for the specified Operation resource to return as `DONE` or for the request to approach the 2 minute deadline, and retrieves the specified Operation resource. This method differs from the `GET` method in that it waits for no more than the default deadline (2 minutes) and then returns the current state of the operation, which might be `DONE` or still in progress. This method is called on a best-effort basis. Specifically: - In uncommon cases, when the server is overloaded, the request might return before the default deadline is reached, or might return after zero seconds. - If the default deadline is reached, there is no guarantee that the operation is actually done when the method returns. Be prepared to retry if the operation is not `DONE`. .

      Args:
        request: (ComputeGlobalOperationsWaitRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Wait')
      return self._RunMethod(
          config, request, global_params=global_params)

    Wait.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalOperations.wait',
        ordered_params=['project', 'operation'],
        path_params=['operation', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/operations/{operation}/wait',
        request_field='',
        request_type_name='ComputeGlobalOperationsWaitRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class GlobalOrganizationOperationsService(base_api.BaseApiService):
    """Service class for the globalOrganizationOperations resource."""

    _NAME = 'globalOrganizationOperations'

    def __init__(self, client):
      super(ComputeBeta.GlobalOrganizationOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Operations resource.

      Args:
        request: (ComputeGlobalOrganizationOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ComputeGlobalOrganizationOperationsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.globalOrganizationOperations.delete',
        ordered_params=['operation'],
        path_params=['operation'],
        query_params=['parentId'],
        relative_path='locations/global/operations/{operation}',
        request_field='',
        request_type_name='ComputeGlobalOrganizationOperationsDeleteRequest',
        response_type_name='ComputeGlobalOrganizationOperationsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the specified Operations resource. Gets a list of operations by making a `list()` request.

      Args:
        request: (ComputeGlobalOrganizationOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalOrganizationOperations.get',
        ordered_params=['operation'],
        path_params=['operation'],
        query_params=['parentId'],
        relative_path='locations/global/operations/{operation}',
        request_field='',
        request_type_name='ComputeGlobalOrganizationOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of Operation resources contained within the specified organization.

      Args:
        request: (ComputeGlobalOrganizationOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OperationList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalOrganizationOperations.list',
        ordered_params=[],
        path_params=[],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'parentId', 'returnPartialSuccess'],
        relative_path='locations/global/operations',
        request_field='',
        request_type_name='ComputeGlobalOrganizationOperationsListRequest',
        response_type_name='OperationList',
        supports_download=False,
    )

  class GlobalPublicDelegatedPrefixesService(base_api.BaseApiService):
    """Service class for the globalPublicDelegatedPrefixes resource."""

    _NAME = 'globalPublicDelegatedPrefixes'

    def __init__(self, client):
      super(ComputeBeta.GlobalPublicDelegatedPrefixesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified global PublicDelegatedPrefix.

      Args:
        request: (ComputeGlobalPublicDelegatedPrefixesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.globalPublicDelegatedPrefixes.delete',
        ordered_params=['project', 'publicDelegatedPrefix'],
        path_params=['project', 'publicDelegatedPrefix'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/publicDelegatedPrefixes/{publicDelegatedPrefix}',
        request_field='',
        request_type_name='ComputeGlobalPublicDelegatedPrefixesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified global PublicDelegatedPrefix resource.

      Args:
        request: (ComputeGlobalPublicDelegatedPrefixesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PublicDelegatedPrefix) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalPublicDelegatedPrefixes.get',
        ordered_params=['project', 'publicDelegatedPrefix'],
        path_params=['project', 'publicDelegatedPrefix'],
        query_params=[],
        relative_path='projects/{project}/global/publicDelegatedPrefixes/{publicDelegatedPrefix}',
        request_field='',
        request_type_name='ComputeGlobalPublicDelegatedPrefixesGetRequest',
        response_type_name='PublicDelegatedPrefix',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a global PublicDelegatedPrefix in the specified project using the parameters that are included in the request.

      Args:
        request: (ComputeGlobalPublicDelegatedPrefixesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.globalPublicDelegatedPrefixes.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/publicDelegatedPrefixes',
        request_field='publicDelegatedPrefix',
        request_type_name='ComputeGlobalPublicDelegatedPrefixesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the global PublicDelegatedPrefixes for a project.

      Args:
        request: (ComputeGlobalPublicDelegatedPrefixesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PublicDelegatedPrefixList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.globalPublicDelegatedPrefixes.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/publicDelegatedPrefixes',
        request_field='',
        request_type_name='ComputeGlobalPublicDelegatedPrefixesListRequest',
        response_type_name='PublicDelegatedPrefixList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified global PublicDelegatedPrefix resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputeGlobalPublicDelegatedPrefixesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.globalPublicDelegatedPrefixes.patch',
        ordered_params=['project', 'publicDelegatedPrefix'],
        path_params=['project', 'publicDelegatedPrefix'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/publicDelegatedPrefixes/{publicDelegatedPrefix}',
        request_field='publicDelegatedPrefixResource',
        request_type_name='ComputeGlobalPublicDelegatedPrefixesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class HealthChecksService(base_api.BaseApiService):
    """Service class for the healthChecks resource."""

    _NAME = 'healthChecks'

    def __init__(self, client):
      super(ComputeBeta.HealthChecksService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all HealthCheck resources, regional and global, available to the specified project.

      Args:
        request: (ComputeHealthChecksAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthChecksAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.healthChecks.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/healthChecks',
        request_field='',
        request_type_name='ComputeHealthChecksAggregatedListRequest',
        response_type_name='HealthChecksAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified HealthCheck resource.

      Args:
        request: (ComputeHealthChecksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.healthChecks.delete',
        ordered_params=['project', 'healthCheck'],
        path_params=['healthCheck', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/healthChecks/{healthCheck}',
        request_field='',
        request_type_name='ComputeHealthChecksDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified HealthCheck resource. Gets a list of available health checks by making a list() request.

      Args:
        request: (ComputeHealthChecksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthCheck) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.healthChecks.get',
        ordered_params=['project', 'healthCheck'],
        path_params=['healthCheck', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/healthChecks/{healthCheck}',
        request_field='',
        request_type_name='ComputeHealthChecksGetRequest',
        response_type_name='HealthCheck',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a HealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeHealthChecksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.healthChecks.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/healthChecks',
        request_field='healthCheck',
        request_type_name='ComputeHealthChecksInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of HealthCheck resources available to the specified project.

      Args:
        request: (ComputeHealthChecksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthCheckList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.healthChecks.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/healthChecks',
        request_field='',
        request_type_name='ComputeHealthChecksListRequest',
        response_type_name='HealthCheckList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a HealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeHealthChecksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.healthChecks.patch',
        ordered_params=['project', 'healthCheck'],
        path_params=['healthCheck', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/healthChecks/{healthCheck}',
        request_field='healthCheckResource',
        request_type_name='ComputeHealthChecksPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeHealthChecksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.healthChecks.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/healthChecks/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeHealthChecksTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a HealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeHealthChecksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.healthChecks.update',
        ordered_params=['project', 'healthCheck'],
        path_params=['healthCheck', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/healthChecks/{healthCheck}',
        request_field='healthCheckResource',
        request_type_name='ComputeHealthChecksUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class HttpHealthChecksService(base_api.BaseApiService):
    """Service class for the httpHealthChecks resource."""

    _NAME = 'httpHealthChecks'

    def __init__(self, client):
      super(ComputeBeta.HttpHealthChecksService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified HttpHealthCheck resource.

      Args:
        request: (ComputeHttpHealthChecksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.httpHealthChecks.delete',
        ordered_params=['project', 'httpHealthCheck'],
        path_params=['httpHealthCheck', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/httpHealthChecks/{httpHealthCheck}',
        request_field='',
        request_type_name='ComputeHttpHealthChecksDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified HttpHealthCheck resource. Gets a list of available HTTP health checks by making a list() request.

      Args:
        request: (ComputeHttpHealthChecksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpHealthCheck) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.httpHealthChecks.get',
        ordered_params=['project', 'httpHealthCheck'],
        path_params=['httpHealthCheck', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/httpHealthChecks/{httpHealthCheck}',
        request_field='',
        request_type_name='ComputeHttpHealthChecksGetRequest',
        response_type_name='HttpHealthCheck',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a HttpHealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeHttpHealthChecksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.httpHealthChecks.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/httpHealthChecks',
        request_field='httpHealthCheck',
        request_type_name='ComputeHttpHealthChecksInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of HttpHealthCheck resources available to the specified project.

      Args:
        request: (ComputeHttpHealthChecksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpHealthCheckList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.httpHealthChecks.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/httpHealthChecks',
        request_field='',
        request_type_name='ComputeHttpHealthChecksListRequest',
        response_type_name='HttpHealthCheckList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a HttpHealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeHttpHealthChecksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.httpHealthChecks.patch',
        ordered_params=['project', 'httpHealthCheck'],
        path_params=['httpHealthCheck', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/httpHealthChecks/{httpHealthCheck}',
        request_field='httpHealthCheckResource',
        request_type_name='ComputeHttpHealthChecksPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeHttpHealthChecksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.httpHealthChecks.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/httpHealthChecks/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeHttpHealthChecksTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a HttpHealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeHttpHealthChecksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.httpHealthChecks.update',
        ordered_params=['project', 'httpHealthCheck'],
        path_params=['httpHealthCheck', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/httpHealthChecks/{httpHealthCheck}',
        request_field='httpHealthCheckResource',
        request_type_name='ComputeHttpHealthChecksUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class HttpsHealthChecksService(base_api.BaseApiService):
    """Service class for the httpsHealthChecks resource."""

    _NAME = 'httpsHealthChecks'

    def __init__(self, client):
      super(ComputeBeta.HttpsHealthChecksService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified HttpsHealthCheck resource.

      Args:
        request: (ComputeHttpsHealthChecksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.httpsHealthChecks.delete',
        ordered_params=['project', 'httpsHealthCheck'],
        path_params=['httpsHealthCheck', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}',
        request_field='',
        request_type_name='ComputeHttpsHealthChecksDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified HttpsHealthCheck resource. Gets a list of available HTTPS health checks by making a list() request.

      Args:
        request: (ComputeHttpsHealthChecksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpsHealthCheck) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.httpsHealthChecks.get',
        ordered_params=['project', 'httpsHealthCheck'],
        path_params=['httpsHealthCheck', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}',
        request_field='',
        request_type_name='ComputeHttpsHealthChecksGetRequest',
        response_type_name='HttpsHealthCheck',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a HttpsHealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeHttpsHealthChecksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.httpsHealthChecks.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/httpsHealthChecks',
        request_field='httpsHealthCheck',
        request_type_name='ComputeHttpsHealthChecksInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of HttpsHealthCheck resources available to the specified project.

      Args:
        request: (ComputeHttpsHealthChecksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpsHealthCheckList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.httpsHealthChecks.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/httpsHealthChecks',
        request_field='',
        request_type_name='ComputeHttpsHealthChecksListRequest',
        response_type_name='HttpsHealthCheckList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a HttpsHealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeHttpsHealthChecksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.httpsHealthChecks.patch',
        ordered_params=['project', 'httpsHealthCheck'],
        path_params=['httpsHealthCheck', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}',
        request_field='httpsHealthCheckResource',
        request_type_name='ComputeHttpsHealthChecksPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeHttpsHealthChecksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.httpsHealthChecks.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/httpsHealthChecks/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeHttpsHealthChecksTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a HttpsHealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeHttpsHealthChecksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.httpsHealthChecks.update',
        ordered_params=['project', 'httpsHealthCheck'],
        path_params=['httpsHealthCheck', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}',
        request_field='httpsHealthCheckResource',
        request_type_name='ComputeHttpsHealthChecksUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ImageFamilyViewsService(base_api.BaseApiService):
    """Service class for the imageFamilyViews resource."""

    _NAME = 'imageFamilyViews'

    def __init__(self, client):
      super(ComputeBeta.ImageFamilyViewsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the latest image that is part of an image family, is not deprecated and is rolled out in the specified zone.

      Args:
        request: (ComputeImageFamilyViewsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ImageFamilyView) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.imageFamilyViews.get',
        ordered_params=['project', 'zone', 'family'],
        path_params=['family', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/imageFamilyViews/{family}',
        request_field='',
        request_type_name='ComputeImageFamilyViewsGetRequest',
        response_type_name='ImageFamilyView',
        supports_download=False,
    )

  class ImagesService(base_api.BaseApiService):
    """Service class for the images resource."""

    _NAME = 'images'

    def __init__(self, client):
      super(ComputeBeta.ImagesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified image.

      Args:
        request: (ComputeImagesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.images.delete',
        ordered_params=['project', 'image'],
        path_params=['image', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/images/{image}',
        request_field='',
        request_type_name='ComputeImagesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Deprecate(self, request, global_params=None):
      r"""Sets the deprecation status of an image. If an empty request body is given, clears the deprecation status instead.

      Args:
        request: (ComputeImagesDeprecateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Deprecate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Deprecate.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.images.deprecate',
        ordered_params=['project', 'image'],
        path_params=['image', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/images/{image}/deprecate',
        request_field='deprecationStatus',
        request_type_name='ComputeImagesDeprecateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified image. Gets a list of available images by making a list() request.

      Args:
        request: (ComputeImagesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Image) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.images.get',
        ordered_params=['project', 'image'],
        path_params=['image', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/images/{image}',
        request_field='',
        request_type_name='ComputeImagesGetRequest',
        response_type_name='Image',
        supports_download=False,
    )

    def GetFromFamily(self, request, global_params=None):
      r"""Returns the latest image that is part of an image family and is not deprecated.

      Args:
        request: (ComputeImagesGetFromFamilyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Image) The response message.
      """
      config = self.GetMethodConfig('GetFromFamily')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetFromFamily.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.images.getFromFamily',
        ordered_params=['project', 'family'],
        path_params=['family', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/images/family/{family}',
        request_field='',
        request_type_name='ComputeImagesGetFromFamilyRequest',
        response_type_name='Image',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeImagesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.images.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/images/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeImagesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an image in the specified project using the data included in the request.

      Args:
        request: (ComputeImagesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.images.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['forceCreate', 'requestId'],
        relative_path='projects/{project}/global/images',
        request_field='image',
        request_type_name='ComputeImagesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of custom images available to the specified project. Custom images are images you create that belong to your project. This method does not get any images that belong to other projects, including publicly-available images, like Debian 8. If you want to get a list of publicly-available images, use this method to make a request to the respective image project, such as debian-cloud or windows-cloud.

      Args:
        request: (ComputeImagesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ImageList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.images.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/images',
        request_field='',
        request_type_name='ComputeImagesListRequest',
        response_type_name='ImageList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified image with the data included in the request. Only the following fields can be modified: family, description, deprecation status.

      Args:
        request: (ComputeImagesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.images.patch',
        ordered_params=['project', 'image'],
        path_params=['image', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/images/{image}',
        request_field='imageResource',
        request_type_name='ComputeImagesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeImagesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.images.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/images/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeImagesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on an image. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeImagesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.images.setLabels',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/images/{resource}/setLabels',
        request_field='globalSetLabelsRequest',
        request_type_name='ComputeImagesSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeImagesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.images.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/images/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeImagesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class InstanceGroupManagersService(base_api.BaseApiService):
    """Service class for the instanceGroupManagers resource."""

    _NAME = 'instanceGroupManagers'

    def __init__(self, client):
      super(ComputeBeta.InstanceGroupManagersService, self).__init__(client)
      self._upload_configs = {
          }

    def AbandonInstances(self, request, global_params=None):
      r"""Flags the specified instances to be removed from the managed instance group. Abandoning an instance does not delete the instance, but it does remove the instance from any target pools that are applied by the managed instance group. This method reduces the targetSize of the managed instance group by the number of instances that you abandon. This operation is marked as DONE when the action is scheduled even if the instances have not yet been removed from the group. You must separately verify the status of the abandoning action with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeInstanceGroupManagersAbandonInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AbandonInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    AbandonInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.abandonInstances',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/abandonInstances',
        request_field='instanceGroupManagersAbandonInstancesRequest',
        request_type_name='ComputeInstanceGroupManagersAbandonInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of managed instance groups and groups them by zone.

      Args:
        request: (ComputeInstanceGroupManagersAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManagerAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceGroupManagers.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/instanceGroupManagers',
        request_field='',
        request_type_name='ComputeInstanceGroupManagersAggregatedListRequest',
        response_type_name='InstanceGroupManagerAggregatedList',
        supports_download=False,
    )

    def ApplyUpdatesToInstances(self, request, global_params=None):
      r"""Applies changes to selected instances on the managed instance group. This method can be used to apply new overrides and/or new versions.

      Args:
        request: (ComputeInstanceGroupManagersApplyUpdatesToInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ApplyUpdatesToInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ApplyUpdatesToInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.applyUpdatesToInstances',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/applyUpdatesToInstances',
        request_field='instanceGroupManagersApplyUpdatesRequest',
        request_type_name='ComputeInstanceGroupManagersApplyUpdatesToInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def CreateInstances(self, request, global_params=None):
      r"""Creates instances with per-instance configurations in this managed instance group. Instances are created using the current instance template. The create instances operation is marked DONE if the createInstances request is successful. The underlying actions take additional time. You must separately verify the status of the creating or actions with the listmanagedinstances method.

      Args:
        request: (ComputeInstanceGroupManagersCreateInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CreateInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    CreateInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.createInstances',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/createInstances',
        request_field='instanceGroupManagersCreateInstancesRequest',
        request_type_name='ComputeInstanceGroupManagersCreateInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified managed instance group and all of the instances in that group. Note that the instance group must not belong to a backend service. Read Deleting an instance group for more information.

      Args:
        request: (ComputeInstanceGroupManagersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.instanceGroupManagers.delete',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}',
        request_field='',
        request_type_name='ComputeInstanceGroupManagersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DeleteInstances(self, request, global_params=None):
      r"""Flags the specified instances in the managed instance group for immediate deletion. The instances are also removed from any target pools of which they were a member. This method reduces the targetSize of the managed instance group by the number of instances that you delete. This operation is marked as DONE when the action is scheduled even if the instances are still being deleted. You must separately verify the status of the deleting action with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeInstanceGroupManagersDeleteInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.deleteInstances',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/deleteInstances',
        request_field='instanceGroupManagersDeleteInstancesRequest',
        request_type_name='ComputeInstanceGroupManagersDeleteInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DeletePerInstanceConfigs(self, request, global_params=None):
      r"""Deletes selected per-instance configurations for the managed instance group.

      Args:
        request: (ComputeInstanceGroupManagersDeletePerInstanceConfigsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeletePerInstanceConfigs')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeletePerInstanceConfigs.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.deletePerInstanceConfigs',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/deletePerInstanceConfigs',
        request_field='instanceGroupManagersDeletePerInstanceConfigsReq',
        request_type_name='ComputeInstanceGroupManagersDeletePerInstanceConfigsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns all of the details about the specified managed instance group. Gets a list of available managed instance groups by making a list() request.

      Args:
        request: (ComputeInstanceGroupManagersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManager) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceGroupManagers.get',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}',
        request_field='',
        request_type_name='ComputeInstanceGroupManagersGetRequest',
        response_type_name='InstanceGroupManager',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a managed instance group using the information that you specify in the request. After the group is created, instances in the group are created using the specified instance template. This operation is marked as DONE when the group is created even if the instances in the group have not yet been created. You must separately verify the status of the individual instances with the listmanagedinstances method. A managed instance group can have up to 1000 VM instances per group. Please contact Cloud Support if you need an increase in this limit.

      Args:
        request: (ComputeInstanceGroupManagersInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.insert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers',
        request_field='instanceGroupManager',
        request_type_name='ComputeInstanceGroupManagersInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of managed instance groups that are contained within the specified project and zone.

      Args:
        request: (ComputeInstanceGroupManagersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManagerList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceGroupManagers.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers',
        request_field='',
        request_type_name='ComputeInstanceGroupManagersListRequest',
        response_type_name='InstanceGroupManagerList',
        supports_download=False,
    )

    def ListErrors(self, request, global_params=None):
      r"""Lists all errors thrown by actions on instances for a given managed instance group. The filter and orderBy query parameters are not supported.

      Args:
        request: (ComputeInstanceGroupManagersListErrorsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManagersListErrorsResponse) The response message.
      """
      config = self.GetMethodConfig('ListErrors')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListErrors.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceGroupManagers.listErrors',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/listErrors',
        request_field='',
        request_type_name='ComputeInstanceGroupManagersListErrorsRequest',
        response_type_name='InstanceGroupManagersListErrorsResponse',
        supports_download=False,
    )

    def ListManagedInstances(self, request, global_params=None):
      r"""Lists all of the instances in the managed instance group. Each instance in the list has a currentAction, which indicates the action that the managed instance group is performing on the instance. For example, if the group is still creating an instance, the currentAction is CREATING. If a previous action failed, the list displays the errors for that failed action. The orderBy query parameter is not supported. The `pageToken` query parameter is supported only in the alpha and beta API and only if the group's `listManagedInstancesResults` field is set to `PAGINATED`.

      Args:
        request: (ComputeInstanceGroupManagersListManagedInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManagersListManagedInstancesResponse) The response message.
      """
      config = self.GetMethodConfig('ListManagedInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListManagedInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.listManagedInstances',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/listManagedInstances',
        request_field='',
        request_type_name='ComputeInstanceGroupManagersListManagedInstancesRequest',
        response_type_name='InstanceGroupManagersListManagedInstancesResponse',
        supports_download=False,
    )

    def ListPerInstanceConfigs(self, request, global_params=None):
      r"""Lists all of the per-instance configurations defined for the managed instance group. The orderBy query parameter is not supported.

      Args:
        request: (ComputeInstanceGroupManagersListPerInstanceConfigsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManagersListPerInstanceConfigsResp) The response message.
      """
      config = self.GetMethodConfig('ListPerInstanceConfigs')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListPerInstanceConfigs.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.listPerInstanceConfigs',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/listPerInstanceConfigs',
        request_field='',
        request_type_name='ComputeInstanceGroupManagersListPerInstanceConfigsRequest',
        response_type_name='InstanceGroupManagersListPerInstanceConfigsResp',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is patched even if the instances in the group are still in the process of being patched. You must separately verify the status of the individual instances with the listManagedInstances method. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. If you update your group to specify a new template or instance configuration, it's possible that your intended specification for each VM in the group is different from the current state of that VM. To learn how to apply an updated configuration to the VMs in a MIG, see Updating instances in a MIG.

      Args:
        request: (ComputeInstanceGroupManagersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.instanceGroupManagers.patch',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}',
        request_field='instanceGroupManagerResource',
        request_type_name='ComputeInstanceGroupManagersPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchPerInstanceConfigs(self, request, global_params=None):
      r"""Inserts or patches per-instance configurations for the managed instance group. perInstanceConfig.name serves as a key used to distinguish whether to perform insert or patch.

      Args:
        request: (ComputeInstanceGroupManagersPatchPerInstanceConfigsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchPerInstanceConfigs')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchPerInstanceConfigs.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.patchPerInstanceConfigs',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/patchPerInstanceConfigs',
        request_field='instanceGroupManagersPatchPerInstanceConfigsReq',
        request_type_name='ComputeInstanceGroupManagersPatchPerInstanceConfigsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RecreateInstances(self, request, global_params=None):
      r"""Flags the specified VM instances in the managed instance group to be immediately recreated. Each instance is recreated using the group's current configuration. This operation is marked as DONE when the flag is set even if the instances have not yet been recreated. You must separately verify the status of each instance by checking its currentAction field; for more information, see Checking the status of managed instances. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeInstanceGroupManagersRecreateInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RecreateInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    RecreateInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.recreateInstances',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/recreateInstances',
        request_field='instanceGroupManagersRecreateInstancesRequest',
        request_type_name='ComputeInstanceGroupManagersRecreateInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Resize(self, request, global_params=None):
      r"""Resizes the managed instance group. If you increase the size, the group creates new instances using the current instance template. If you decrease the size, the group deletes instances. The resize operation is marked DONE when the resize actions are scheduled even if the group has not yet added or deleted any instances. You must separately verify the status of the creating or deleting actions with the listmanagedinstances method. When resizing down, the instance group arbitrarily chooses the order in which VMs are deleted. The group takes into account some VM attributes when making the selection including: + The status of the VM instance. + The health of the VM instance. + The instance template version the VM is based on. + For regional managed instance groups, the location of the VM instance. This list is subject to change. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.

      Args:
        request: (ComputeInstanceGroupManagersResizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Resize')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resize.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.resize',
        ordered_params=['project', 'zone', 'instanceGroupManager', 'size'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId', 'size'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resize',
        request_field='',
        request_type_name='ComputeInstanceGroupManagersResizeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def ResizeAdvanced(self, request, global_params=None):
      r"""Resizes the managed instance group with advanced configuration options like disabling creation retries. This is an extended version of the resize method. If you increase the size of the instance group, the group creates new instances using the current instance template. If you decrease the size, the group deletes instances. The resize operation is marked DONE when the resize actions are scheduled even if the group has not yet added or deleted any instances. You must separately verify the status of the creating, creatingWithoutRetries, or deleting actions with the get or listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.

      Args:
        request: (ComputeInstanceGroupManagersResizeAdvancedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ResizeAdvanced')
      return self._RunMethod(
          config, request, global_params=global_params)

    ResizeAdvanced.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.resizeAdvanced',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resizeAdvanced',
        request_field='instanceGroupManagersResizeAdvancedRequest',
        request_type_name='ComputeInstanceGroupManagersResizeAdvancedRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetAutoHealingPolicies(self, request, global_params=None):
      r"""Motifies the autohealing policy for the instances in this managed instance group. [Deprecated] This method is deprecated. Use instanceGroupManagers.patch instead.

      Args:
        request: (ComputeInstanceGroupManagersSetAutoHealingPoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetAutoHealingPolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetAutoHealingPolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.setAutoHealingPolicies',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/setAutoHealingPolicies',
        request_field='instanceGroupManagersSetAutoHealingRequest',
        request_type_name='ComputeInstanceGroupManagersSetAutoHealingPoliciesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetInstanceTemplate(self, request, global_params=None):
      r"""Specifies the instance template to use when creating new instances in this group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.

      Args:
        request: (ComputeInstanceGroupManagersSetInstanceTemplateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetInstanceTemplate')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetInstanceTemplate.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.setInstanceTemplate',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/setInstanceTemplate',
        request_field='instanceGroupManagersSetInstanceTemplateRequest',
        request_type_name='ComputeInstanceGroupManagersSetInstanceTemplateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetTargetPools(self, request, global_params=None):
      r"""Modifies the target pools to which all instances in this managed instance group are assigned. The target pools automatically apply to all of the instances in the managed instance group. This operation is marked DONE when you make the request even if the instances have not yet been added to their target pools. The change might take some time to apply to all of the instances in the group depending on the size of the group.

      Args:
        request: (ComputeInstanceGroupManagersSetTargetPoolsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetTargetPools')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetTargetPools.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.setTargetPools',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/setTargetPools',
        request_field='instanceGroupManagersSetTargetPoolsRequest',
        request_type_name='ComputeInstanceGroupManagersSetTargetPoolsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInstanceGroupManagersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.testIamPermissions',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeInstanceGroupManagersTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is updated even if the instances in the group have not yet been updated. You must separately verify the status of the individual instances with the listManagedInstances method. If you update your group to specify a new template or instance configuration, it's possible that your intended specification for each VM in the group is different from the current state of that VM. To learn how to apply an updated configuration to the VMs in a MIG, see Updating instances in a MIG.

      Args:
        request: (ComputeInstanceGroupManagersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.instanceGroupManagers.update',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}',
        request_field='instanceGroupManagerResource',
        request_type_name='ComputeInstanceGroupManagersUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdatePerInstanceConfigs(self, request, global_params=None):
      r"""Inserts or updates per-instance configurations for the managed instance group. perInstanceConfig.name serves as a key used to distinguish whether to perform insert or patch.

      Args:
        request: (ComputeInstanceGroupManagersUpdatePerInstanceConfigsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdatePerInstanceConfigs')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdatePerInstanceConfigs.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroupManagers.updatePerInstanceConfigs',
        ordered_params=['project', 'zone', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/updatePerInstanceConfigs',
        request_field='instanceGroupManagersUpdatePerInstanceConfigsReq',
        request_type_name='ComputeInstanceGroupManagersUpdatePerInstanceConfigsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class InstanceGroupsService(base_api.BaseApiService):
    """Service class for the instanceGroups resource."""

    _NAME = 'instanceGroups'

    def __init__(self, client):
      super(ComputeBeta.InstanceGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def AddInstances(self, request, global_params=None):
      r"""Adds a list of instances to the specified instance group. All of the instances in the instance group must be in the same network/subnetwork. Read Adding instances for more information.

      Args:
        request: (ComputeInstanceGroupsAddInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroups.addInstances',
        ordered_params=['project', 'zone', 'instanceGroup'],
        path_params=['instanceGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}/addInstances',
        request_field='instanceGroupsAddInstancesRequest',
        request_type_name='ComputeInstanceGroupsAddInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of instance groups and sorts them by zone.

      Args:
        request: (ComputeInstanceGroupsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceGroups.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/instanceGroups',
        request_field='',
        request_type_name='ComputeInstanceGroupsAggregatedListRequest',
        response_type_name='InstanceGroupAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified instance group. The instances in the group are not deleted. Note that instance group must not belong to a backend service. Read Deleting an instance group for more information.

      Args:
        request: (ComputeInstanceGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.instanceGroups.delete',
        ordered_params=['project', 'zone', 'instanceGroup'],
        path_params=['instanceGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}',
        request_field='',
        request_type_name='ComputeInstanceGroupsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified zonal instance group. Get a list of available zonal instance groups by making a list() request. For managed instance groups, use the instanceGroupManagers or regionInstanceGroupManagers methods instead.

      Args:
        request: (ComputeInstanceGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceGroups.get',
        ordered_params=['project', 'zone', 'instanceGroup'],
        path_params=['instanceGroup', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}',
        request_field='',
        request_type_name='ComputeInstanceGroupsGetRequest',
        response_type_name='InstanceGroup',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an instance group in the specified project using the parameters that are included in the request.

      Args:
        request: (ComputeInstanceGroupsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroups.insert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroups',
        request_field='instanceGroup',
        request_type_name='ComputeInstanceGroupsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of zonal instance group resources contained within the specified zone. For managed instance groups, use the instanceGroupManagers or regionInstanceGroupManagers methods instead.

      Args:
        request: (ComputeInstanceGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceGroups.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/instanceGroups',
        request_field='',
        request_type_name='ComputeInstanceGroupsListRequest',
        response_type_name='InstanceGroupList',
        supports_download=False,
    )

    def ListInstances(self, request, global_params=None):
      r"""Lists the instances in the specified instance group. The orderBy query parameter is not supported. The filter query parameter is supported, but only for expressions that use `eq` (equal) or `ne` (not equal) operators.

      Args:
        request: (ComputeInstanceGroupsListInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupsListInstances) The response message.
      """
      config = self.GetMethodConfig('ListInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroups.listInstances',
        ordered_params=['project', 'zone', 'instanceGroup'],
        path_params=['instanceGroup', 'project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}/listInstances',
        request_field='instanceGroupsListInstancesRequest',
        request_type_name='ComputeInstanceGroupsListInstancesRequest',
        response_type_name='InstanceGroupsListInstances',
        supports_download=False,
    )

    def RemoveInstances(self, request, global_params=None):
      r"""Removes one or more instances from the specified instance group, but does not delete those instances. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration before the VM instance is removed or deleted.

      Args:
        request: (ComputeInstanceGroupsRemoveInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroups.removeInstances',
        ordered_params=['project', 'zone', 'instanceGroup'],
        path_params=['instanceGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}/removeInstances',
        request_field='instanceGroupsRemoveInstancesRequest',
        request_type_name='ComputeInstanceGroupsRemoveInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetNamedPorts(self, request, global_params=None):
      r"""Sets the named ports for the specified instance group.

      Args:
        request: (ComputeInstanceGroupsSetNamedPortsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetNamedPorts')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetNamedPorts.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroups.setNamedPorts',
        ordered_params=['project', 'zone', 'instanceGroup'],
        path_params=['instanceGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instanceGroups/{instanceGroup}/setNamedPorts',
        request_field='instanceGroupsSetNamedPortsRequest',
        request_type_name='ComputeInstanceGroupsSetNamedPortsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInstanceGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceGroups.testIamPermissions',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instanceGroups/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeInstanceGroupsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class InstanceTemplatesService(base_api.BaseApiService):
    """Service class for the instanceTemplates resource."""

    _NAME = 'instanceTemplates'

    def __init__(self, client):
      super(ComputeBeta.InstanceTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified instance template. Deleting an instance template is permanent and cannot be undone. It is not possible to delete templates that are already in use by a managed instance group.

      Args:
        request: (ComputeInstanceTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.instanceTemplates.delete',
        ordered_params=['project', 'instanceTemplate'],
        path_params=['instanceTemplate', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/instanceTemplates/{instanceTemplate}',
        request_field='',
        request_type_name='ComputeInstanceTemplatesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified instance template. Gets a list of available instance templates by making a list() request.

      Args:
        request: (ComputeInstanceTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceTemplates.get',
        ordered_params=['project', 'instanceTemplate'],
        path_params=['instanceTemplate', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/instanceTemplates/{instanceTemplate}',
        request_field='',
        request_type_name='ComputeInstanceTemplatesGetRequest',
        response_type_name='InstanceTemplate',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeInstanceTemplatesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceTemplates.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/instanceTemplates/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeInstanceTemplatesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an instance template in the specified project using the data that is included in the request. If you are creating a new template to update an existing instance group, your new instance template must use the same network or, if applicable, the same subnetwork as the original template.

      Args:
        request: (ComputeInstanceTemplatesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceTemplates.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/instanceTemplates',
        request_field='instanceTemplate',
        request_type_name='ComputeInstanceTemplatesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of instance templates that are contained within the specified project.

      Args:
        request: (ComputeInstanceTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceTemplateList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instanceTemplates.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/instanceTemplates',
        request_field='',
        request_type_name='ComputeInstanceTemplatesListRequest',
        response_type_name='InstanceTemplateList',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeInstanceTemplatesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceTemplates.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/instanceTemplates/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeInstanceTemplatesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInstanceTemplatesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instanceTemplates.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/instanceTemplates/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeInstanceTemplatesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class InstancesService(base_api.BaseApiService):
    """Service class for the instances resource."""

    _NAME = 'instances'

    def __init__(self, client):
      super(ComputeBeta.InstancesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddAccessConfig(self, request, global_params=None):
      r"""Adds an access config to an instance's network interface.

      Args:
        request: (ComputeInstancesAddAccessConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddAccessConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddAccessConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.addAccessConfig',
        ordered_params=['project', 'zone', 'instance', 'networkInterface'],
        path_params=['instance', 'project', 'zone'],
        query_params=['networkInterface', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/addAccessConfig',
        request_field='accessConfig',
        request_type_name='ComputeInstancesAddAccessConfigRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AddResourcePolicies(self, request, global_params=None):
      r"""Adds existing resource policies to an instance. You can only add one policy right now which will be applied to this instance for scheduling live migrations.

      Args:
        request: (ComputeInstancesAddResourcePoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddResourcePolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddResourcePolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.addResourcePolicies',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/addResourcePolicies',
        request_field='instancesAddResourcePoliciesRequest',
        request_type_name='ComputeInstancesAddResourcePoliciesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of all of the instances in your project across all regions and zones. The performance of this method degrades when a filter is specified on a project that has a very large number of instances.

      Args:
        request: (ComputeInstancesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/instances',
        request_field='',
        request_type_name='ComputeInstancesAggregatedListRequest',
        response_type_name='InstanceAggregatedList',
        supports_download=False,
    )

    def AttachDisk(self, request, global_params=None):
      r"""Attaches an existing Disk resource to an instance. You must first create the disk before you can attach it. It is not possible to create and attach a disk at the same time. For more information, read Adding a persistent disk to your instance.

      Args:
        request: (ComputeInstancesAttachDiskRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AttachDisk')
      return self._RunMethod(
          config, request, global_params=global_params)

    AttachDisk.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.attachDisk',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['forceAttach', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/attachDisk',
        request_field='attachedDisk',
        request_type_name='ComputeInstancesAttachDiskRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def BulkInsert(self, request, global_params=None):
      r"""Creates multiple instances. Count specifies the number of instances to create. For more information, see About bulk creation of VMs.

      Args:
        request: (ComputeInstancesBulkInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('BulkInsert')
      return self._RunMethod(
          config, request, global_params=global_params)

    BulkInsert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.bulkInsert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/bulkInsert',
        request_field='bulkInsertInstanceResource',
        request_type_name='ComputeInstancesBulkInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Instance resource. For more information, see Deleting an instance.

      Args:
        request: (ComputeInstancesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.instances.delete',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}',
        request_field='',
        request_type_name='ComputeInstancesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DeleteAccessConfig(self, request, global_params=None):
      r"""Deletes an access config from an instance's network interface.

      Args:
        request: (ComputeInstancesDeleteAccessConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteAccessConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteAccessConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.deleteAccessConfig',
        ordered_params=['project', 'zone', 'instance', 'accessConfig', 'networkInterface'],
        path_params=['instance', 'project', 'zone'],
        query_params=['accessConfig', 'networkInterface', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/deleteAccessConfig',
        request_field='',
        request_type_name='ComputeInstancesDeleteAccessConfigRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DetachDisk(self, request, global_params=None):
      r"""Detaches a disk from an instance.

      Args:
        request: (ComputeInstancesDetachDiskRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DetachDisk')
      return self._RunMethod(
          config, request, global_params=global_params)

    DetachDisk.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.detachDisk',
        ordered_params=['project', 'zone', 'instance', 'deviceName'],
        path_params=['instance', 'project', 'zone'],
        query_params=['deviceName', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/detachDisk',
        request_field='',
        request_type_name='ComputeInstancesDetachDiskRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified Instance resource. Gets a list of available instances by making a list() request.

      Args:
        request: (ComputeInstancesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Instance) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.get',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}',
        request_field='',
        request_type_name='ComputeInstancesGetRequest',
        response_type_name='Instance',
        supports_download=False,
    )

    def GetEffectiveFirewalls(self, request, global_params=None):
      r"""Returns effective firewalls applied to an interface of the instance.

      Args:
        request: (ComputeInstancesGetEffectiveFirewallsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstancesGetEffectiveFirewallsResponse) The response message.
      """
      config = self.GetMethodConfig('GetEffectiveFirewalls')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetEffectiveFirewalls.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.getEffectiveFirewalls',
        ordered_params=['project', 'zone', 'instance', 'networkInterface'],
        path_params=['instance', 'project', 'zone'],
        query_params=['networkInterface'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/getEffectiveFirewalls',
        request_field='',
        request_type_name='ComputeInstancesGetEffectiveFirewallsRequest',
        response_type_name='InstancesGetEffectiveFirewallsResponse',
        supports_download=False,
    )

    def GetGuestAttributes(self, request, global_params=None):
      r"""Returns the specified guest attributes entry.

      Args:
        request: (ComputeInstancesGetGuestAttributesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GuestAttributes) The response message.
      """
      config = self.GetMethodConfig('GetGuestAttributes')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetGuestAttributes.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.getGuestAttributes',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['queryPath', 'variableKey'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/getGuestAttributes',
        request_field='',
        request_type_name='ComputeInstancesGetGuestAttributesRequest',
        response_type_name='GuestAttributes',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeInstancesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.getIamPolicy',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/zones/{zone}/instances/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeInstancesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def GetScreenshot(self, request, global_params=None):
      r"""Returns the screenshot from the specified instance.

      Args:
        request: (ComputeInstancesGetScreenshotRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Screenshot) The response message.
      """
      config = self.GetMethodConfig('GetScreenshot')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetScreenshot.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.getScreenshot',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/screenshot',
        request_field='',
        request_type_name='ComputeInstancesGetScreenshotRequest',
        response_type_name='Screenshot',
        supports_download=False,
    )

    def GetSerialPortOutput(self, request, global_params=None):
      r"""Returns the last 1 MB of serial port output from the specified instance.

      Args:
        request: (ComputeInstancesGetSerialPortOutputRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SerialPortOutput) The response message.
      """
      config = self.GetMethodConfig('GetSerialPortOutput')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetSerialPortOutput.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.getSerialPortOutput',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['port', 'start'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/serialPort',
        request_field='',
        request_type_name='ComputeInstancesGetSerialPortOutputRequest',
        response_type_name='SerialPortOutput',
        supports_download=False,
    )

    def GetShieldedInstanceIdentity(self, request, global_params=None):
      r"""Returns the Shielded Instance Identity of an instance.

      Args:
        request: (ComputeInstancesGetShieldedInstanceIdentityRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ShieldedInstanceIdentity) The response message.
      """
      config = self.GetMethodConfig('GetShieldedInstanceIdentity')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetShieldedInstanceIdentity.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.getShieldedInstanceIdentity',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/getShieldedInstanceIdentity',
        request_field='',
        request_type_name='ComputeInstancesGetShieldedInstanceIdentityRequest',
        response_type_name='ShieldedInstanceIdentity',
        supports_download=False,
    )

    def GetShieldedVmIdentity(self, request, global_params=None):
      r"""Returns the Shielded VM Identity of an instance.

      Args:
        request: (ComputeInstancesGetShieldedVmIdentityRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ShieldedVmIdentity) The response message.
      """
      config = self.GetMethodConfig('GetShieldedVmIdentity')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetShieldedVmIdentity.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.getShieldedVmIdentity',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/getShieldedVmIdentity',
        request_field='',
        request_type_name='ComputeInstancesGetShieldedVmIdentityRequest',
        response_type_name='ShieldedVmIdentity',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an instance resource in the specified project using the data included in the request.

      Args:
        request: (ComputeInstancesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.insert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId', 'sourceInstanceTemplate', 'sourceMachineImage'],
        relative_path='projects/{project}/zones/{zone}/instances',
        request_field='instance',
        request_type_name='ComputeInstancesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of instances contained within the specified zone.

      Args:
        request: (ComputeInstancesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/instances',
        request_field='',
        request_type_name='ComputeInstancesListRequest',
        response_type_name='InstanceList',
        supports_download=False,
    )

    def ListReferrers(self, request, global_params=None):
      r"""Retrieves a list of resources that refer to the VM instance specified in the request. For example, if the VM instance is part of a managed or unmanaged instance group, the referrers list includes the instance group. For more information, read Viewing referrers to VM instances.

      Args:
        request: (ComputeInstancesListReferrersRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceListReferrers) The response message.
      """
      config = self.GetMethodConfig('ListReferrers')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListReferrers.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.instances.listReferrers',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/referrers',
        request_field='',
        request_type_name='ComputeInstancesListReferrersRequest',
        response_type_name='InstanceListReferrers',
        supports_download=False,
    )

    def RemoveResourcePolicies(self, request, global_params=None):
      r"""Removes resource policies from an instance.

      Args:
        request: (ComputeInstancesRemoveResourcePoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveResourcePolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveResourcePolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.removeResourcePolicies',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/removeResourcePolicies',
        request_field='instancesRemoveResourcePoliciesRequest',
        request_type_name='ComputeInstancesRemoveResourcePoliciesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Reset(self, request, global_params=None):
      r"""Performs a reset on the instance. This is a hard reset. The VM does not do a graceful shutdown. For more information, see Resetting an instance.

      Args:
        request: (ComputeInstancesResetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Reset')
      return self._RunMethod(
          config, request, global_params=global_params)

    Reset.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.reset',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/reset',
        request_field='',
        request_type_name='ComputeInstancesResetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Resume(self, request, global_params=None):
      r"""Resumes an instance that was suspended using the instances().suspend method.

      Args:
        request: (ComputeInstancesResumeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Resume')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resume.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.resume',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/resume',
        request_field='instancesResumeRequest',
        request_type_name='ComputeInstancesResumeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SendDiagnosticInterrupt(self, request, global_params=None):
      r"""Sends diagnostic interrupt to the instance.

      Args:
        request: (ComputeInstancesSendDiagnosticInterruptRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ComputeInstancesSendDiagnosticInterruptResponse) The response message.
      """
      config = self.GetMethodConfig('SendDiagnosticInterrupt')
      return self._RunMethod(
          config, request, global_params=global_params)

    SendDiagnosticInterrupt.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.sendDiagnosticInterrupt',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/sendDiagnosticInterrupt',
        request_field='',
        request_type_name='ComputeInstancesSendDiagnosticInterruptRequest',
        response_type_name='ComputeInstancesSendDiagnosticInterruptResponse',
        supports_download=False,
    )

    def SetDeletionProtection(self, request, global_params=None):
      r"""Sets deletion protection on the instance.

      Args:
        request: (ComputeInstancesSetDeletionProtectionRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetDeletionProtection')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetDeletionProtection.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setDeletionProtection',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=['deletionProtection', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{resource}/setDeletionProtection',
        request_field='',
        request_type_name='ComputeInstancesSetDeletionProtectionRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetDiskAutoDelete(self, request, global_params=None):
      r"""Sets the auto-delete flag for a disk attached to an instance.

      Args:
        request: (ComputeInstancesSetDiskAutoDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetDiskAutoDelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetDiskAutoDelete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setDiskAutoDelete',
        ordered_params=['project', 'zone', 'instance', 'autoDelete', 'deviceName'],
        path_params=['instance', 'project', 'zone'],
        query_params=['autoDelete', 'deviceName', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setDiskAutoDelete',
        request_field='',
        request_type_name='ComputeInstancesSetDiskAutoDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeInstancesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setIamPolicy',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instances/{resource}/setIamPolicy',
        request_field='zoneSetPolicyRequest',
        request_type_name='ComputeInstancesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets labels on an instance. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeInstancesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setLabels',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setLabels',
        request_field='instancesSetLabelsRequest',
        request_type_name='ComputeInstancesSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetMachineResources(self, request, global_params=None):
      r"""Changes the number and/or type of accelerator for a stopped instance to the values specified in the request.

      Args:
        request: (ComputeInstancesSetMachineResourcesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMachineResources')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMachineResources.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setMachineResources',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setMachineResources',
        request_field='instancesSetMachineResourcesRequest',
        request_type_name='ComputeInstancesSetMachineResourcesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetMachineType(self, request, global_params=None):
      r"""Changes the machine type for a stopped instance to the machine type specified in the request.

      Args:
        request: (ComputeInstancesSetMachineTypeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMachineType')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMachineType.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setMachineType',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setMachineType',
        request_field='instancesSetMachineTypeRequest',
        request_type_name='ComputeInstancesSetMachineTypeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetMetadata(self, request, global_params=None):
      r"""Sets metadata for the specified instance to the data included in the request.

      Args:
        request: (ComputeInstancesSetMetadataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMetadata')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMetadata.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setMetadata',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setMetadata',
        request_field='metadata',
        request_type_name='ComputeInstancesSetMetadataRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetMinCpuPlatform(self, request, global_params=None):
      r"""Changes the minimum CPU platform that this instance should use. This method can only be called on a stopped instance. For more information, read Specifying a Minimum CPU Platform.

      Args:
        request: (ComputeInstancesSetMinCpuPlatformRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetMinCpuPlatform')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetMinCpuPlatform.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setMinCpuPlatform',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setMinCpuPlatform',
        request_field='instancesSetMinCpuPlatformRequest',
        request_type_name='ComputeInstancesSetMinCpuPlatformRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetName(self, request, global_params=None):
      r"""Sets name of an instance.

      Args:
        request: (ComputeInstancesSetNameRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetName')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetName.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setName',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setName',
        request_field='instancesSetNameRequest',
        request_type_name='ComputeInstancesSetNameRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetScheduling(self, request, global_params=None):
      r"""Sets an instance's scheduling options. You can only call this method on a stopped instance, that is, a VM instance that is in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states. For more information about setting scheduling options for a VM, see Set VM host maintenance policy.

      Args:
        request: (ComputeInstancesSetSchedulingRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetScheduling')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetScheduling.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setScheduling',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setScheduling',
        request_field='scheduling',
        request_type_name='ComputeInstancesSetSchedulingRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetServiceAccount(self, request, global_params=None):
      r"""Sets the service account on the instance. For more information, read Changing the service account and access scopes for an instance.

      Args:
        request: (ComputeInstancesSetServiceAccountRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetServiceAccount')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetServiceAccount.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setServiceAccount',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setServiceAccount',
        request_field='instancesSetServiceAccountRequest',
        request_type_name='ComputeInstancesSetServiceAccountRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetShieldedInstanceIntegrityPolicy(self, request, global_params=None):
      r"""Sets the Shielded Instance integrity policy for an instance. You can only use this method on a running instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstancesSetShieldedInstanceIntegrityPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetShieldedInstanceIntegrityPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetShieldedInstanceIntegrityPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.instances.setShieldedInstanceIntegrityPolicy',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setShieldedInstanceIntegrityPolicy',
        request_field='shieldedInstanceIntegrityPolicy',
        request_type_name='ComputeInstancesSetShieldedInstanceIntegrityPolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetShieldedVmIntegrityPolicy(self, request, global_params=None):
      r"""Sets the Shielded VM integrity policy for a VM instance. You can only use this method on a running VM instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstancesSetShieldedVmIntegrityPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetShieldedVmIntegrityPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetShieldedVmIntegrityPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.instances.setShieldedVmIntegrityPolicy',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setShieldedVmIntegrityPolicy',
        request_field='shieldedVmIntegrityPolicy',
        request_type_name='ComputeInstancesSetShieldedVmIntegrityPolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetTags(self, request, global_params=None):
      r"""Sets network tags for the specified instance to the data included in the request.

      Args:
        request: (ComputeInstancesSetTagsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetTags')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetTags.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.setTags',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/setTags',
        request_field='tags',
        request_type_name='ComputeInstancesSetTagsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SimulateMaintenanceEvent(self, request, global_params=None):
      r"""Simulates a host maintenance event on a VM. For more information, see Simulate a host maintenance event.

      Args:
        request: (ComputeInstancesSimulateMaintenanceEventRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SimulateMaintenanceEvent')
      return self._RunMethod(
          config, request, global_params=global_params)

    SimulateMaintenanceEvent.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.simulateMaintenanceEvent',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/simulateMaintenanceEvent',
        request_field='',
        request_type_name='ComputeInstancesSimulateMaintenanceEventRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Start(self, request, global_params=None):
      r"""Starts an instance that was stopped using the instances().stop method. For more information, see Restart an instance.

      Args:
        request: (ComputeInstancesStartRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Start')
      return self._RunMethod(
          config, request, global_params=global_params)

    Start.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.start',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/start',
        request_field='',
        request_type_name='ComputeInstancesStartRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def StartWithEncryptionKey(self, request, global_params=None):
      r"""Starts an instance that was stopped using the instances().stop method. For more information, see Restart an instance.

      Args:
        request: (ComputeInstancesStartWithEncryptionKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('StartWithEncryptionKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    StartWithEncryptionKey.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.startWithEncryptionKey',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/startWithEncryptionKey',
        request_field='instancesStartWithEncryptionKeyRequest',
        request_type_name='ComputeInstancesStartWithEncryptionKeyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Stop(self, request, global_params=None):
      r"""Stops a running instance, shutting it down cleanly, and allows you to restart the instance at a later time. Stopped instances do not incur VM usage charges while they are stopped. However, resources that the VM is using, such as persistent disks and static IP addresses, will continue to be charged until they are deleted. For more information, see Stopping an instance.

      Args:
        request: (ComputeInstancesStopRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Stop')
      return self._RunMethod(
          config, request, global_params=global_params)

    Stop.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.stop',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/stop',
        request_field='',
        request_type_name='ComputeInstancesStopRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Suspend(self, request, global_params=None):
      r"""This method suspends a running instance, saving its state to persistent storage, and allows you to resume the instance at a later time. Suspended instances have no compute costs (cores or RAM), and incur only storage charges for the saved VM memory and localSSD data. Any charged resources the virtual machine was using, such as persistent disks and static IP addresses, will continue to be charged while the instance is suspended. For more information, see Suspending and resuming an instance.

      Args:
        request: (ComputeInstancesSuspendRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Suspend')
      return self._RunMethod(
          config, request, global_params=global_params)

    Suspend.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.suspend',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['discardLocalSsd', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/suspend',
        request_field='',
        request_type_name='ComputeInstancesSuspendRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInstancesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.testIamPermissions',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/instances/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeInstancesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an instance only if the necessary resources are available. This method can update only a specific set of instance properties. See Updating a running instance for a list of updatable instance properties.

      Args:
        request: (ComputeInstancesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.instances.update',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['minimalAction', 'mostDisruptiveAllowedAction', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}',
        request_field='instanceResource',
        request_type_name='ComputeInstancesUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdateAccessConfig(self, request, global_params=None):
      r"""Updates the specified access config from an instance's network interface with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstancesUpdateAccessConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateAccessConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateAccessConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.instances.updateAccessConfig',
        ordered_params=['project', 'zone', 'instance', 'networkInterface'],
        path_params=['instance', 'project', 'zone'],
        query_params=['networkInterface', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/updateAccessConfig',
        request_field='accessConfig',
        request_type_name='ComputeInstancesUpdateAccessConfigRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdateDisplayDevice(self, request, global_params=None):
      r"""Updates the Display config for a VM instance. You can only use this method on a stopped VM instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstancesUpdateDisplayDeviceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateDisplayDevice')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateDisplayDevice.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.instances.updateDisplayDevice',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/updateDisplayDevice',
        request_field='displayDevice',
        request_type_name='ComputeInstancesUpdateDisplayDeviceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdateNetworkInterface(self, request, global_params=None):
      r"""Updates an instance's network interface. This method can only update an interface's alias IP range and attached network. See Modifying alias IP ranges for an existing instance for instructions on changing alias IP ranges. See Migrating a VM between networks for instructions on migrating an interface. This method follows PATCH semantics.

      Args:
        request: (ComputeInstancesUpdateNetworkInterfaceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateNetworkInterface')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateNetworkInterface.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.instances.updateNetworkInterface',
        ordered_params=['project', 'zone', 'instance', 'networkInterface'],
        path_params=['instance', 'project', 'zone'],
        query_params=['networkInterface', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/updateNetworkInterface',
        request_field='networkInterfaceResource',
        request_type_name='ComputeInstancesUpdateNetworkInterfaceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdateShieldedInstanceConfig(self, request, global_params=None):
      r"""Updates the Shielded Instance config for an instance. You can only use this method on a stopped instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstancesUpdateShieldedInstanceConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateShieldedInstanceConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateShieldedInstanceConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.instances.updateShieldedInstanceConfig',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/updateShieldedInstanceConfig',
        request_field='shieldedInstanceConfig',
        request_type_name='ComputeInstancesUpdateShieldedInstanceConfigRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdateShieldedVmConfig(self, request, global_params=None):
      r"""Updates the Shielded VM config for a VM instance. You can only use this method on a stopped VM instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInstancesUpdateShieldedVmConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateShieldedVmConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateShieldedVmConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.instances.updateShieldedVmConfig',
        ordered_params=['project', 'zone', 'instance'],
        path_params=['instance', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/instances/{instance}/updateShieldedVmConfig',
        request_field='shieldedVmConfig',
        request_type_name='ComputeInstancesUpdateShieldedVmConfigRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class InterconnectAttachmentsService(base_api.BaseApiService):
    """Service class for the interconnectAttachments resource."""

    _NAME = 'interconnectAttachments'

    def __init__(self, client):
      super(ComputeBeta.InterconnectAttachmentsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of interconnect attachments.

      Args:
        request: (ComputeInterconnectAttachmentsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectAttachmentAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectAttachments.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/interconnectAttachments',
        request_field='',
        request_type_name='ComputeInterconnectAttachmentsAggregatedListRequest',
        response_type_name='InterconnectAttachmentAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified interconnect attachment.

      Args:
        request: (ComputeInterconnectAttachmentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.interconnectAttachments.delete',
        ordered_params=['project', 'region', 'interconnectAttachment'],
        path_params=['interconnectAttachment', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/interconnectAttachments/{interconnectAttachment}',
        request_field='',
        request_type_name='ComputeInterconnectAttachmentsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified interconnect attachment.

      Args:
        request: (ComputeInterconnectAttachmentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectAttachment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectAttachments.get',
        ordered_params=['project', 'region', 'interconnectAttachment'],
        path_params=['interconnectAttachment', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/interconnectAttachments/{interconnectAttachment}',
        request_field='',
        request_type_name='ComputeInterconnectAttachmentsGetRequest',
        response_type_name='InterconnectAttachment',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an InterconnectAttachment in the specified project using the data included in the request.

      Args:
        request: (ComputeInterconnectAttachmentsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnectAttachments.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId', 'validateOnly'],
        relative_path='projects/{project}/regions/{region}/interconnectAttachments',
        request_field='interconnectAttachment',
        request_type_name='ComputeInterconnectAttachmentsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of interconnect attachments contained within the specified region.

      Args:
        request: (ComputeInterconnectAttachmentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectAttachmentList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectAttachments.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/interconnectAttachments',
        request_field='',
        request_type_name='ComputeInterconnectAttachmentsListRequest',
        response_type_name='InterconnectAttachmentList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified interconnect attachment with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInterconnectAttachmentsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.interconnectAttachments.patch',
        ordered_params=['project', 'region', 'interconnectAttachment'],
        path_params=['interconnectAttachment', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/interconnectAttachments/{interconnectAttachment}',
        request_field='interconnectAttachmentResource',
        request_type_name='ComputeInterconnectAttachmentsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on an InterconnectAttachment. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeInterconnectAttachmentsSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnectAttachments.setLabels',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/interconnectAttachments/{resource}/setLabels',
        request_field='regionSetLabelsRequest',
        request_type_name='ComputeInterconnectAttachmentsSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInterconnectAttachmentsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnectAttachments.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/interconnectAttachments/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeInterconnectAttachmentsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class InterconnectLocationsService(base_api.BaseApiService):
    """Service class for the interconnectLocations resource."""

    _NAME = 'interconnectLocations'

    def __init__(self, client):
      super(ComputeBeta.InterconnectLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the details for the specified interconnect location. Gets a list of available interconnect locations by making a list() request.

      Args:
        request: (ComputeInterconnectLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectLocation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectLocations.get',
        ordered_params=['project', 'interconnectLocation'],
        path_params=['interconnectLocation', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/interconnectLocations/{interconnectLocation}',
        request_field='',
        request_type_name='ComputeInterconnectLocationsGetRequest',
        response_type_name='InterconnectLocation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of interconnect locations available to the specified project.

      Args:
        request: (ComputeInterconnectLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectLocationList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnectLocations.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/interconnectLocations',
        request_field='',
        request_type_name='ComputeInterconnectLocationsListRequest',
        response_type_name='InterconnectLocationList',
        supports_download=False,
    )

  class InterconnectsService(base_api.BaseApiService):
    """Service class for the interconnects resource."""

    _NAME = 'interconnects'

    def __init__(self, client):
      super(ComputeBeta.InterconnectsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified interconnect.

      Args:
        request: (ComputeInterconnectsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.interconnects.delete',
        ordered_params=['project', 'interconnect'],
        path_params=['interconnect', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/interconnects/{interconnect}',
        request_field='',
        request_type_name='ComputeInterconnectsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified interconnect. Get a list of available interconnects by making a list() request.

      Args:
        request: (ComputeInterconnectsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Interconnect) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnects.get',
        ordered_params=['project', 'interconnect'],
        path_params=['interconnect', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/interconnects/{interconnect}',
        request_field='',
        request_type_name='ComputeInterconnectsGetRequest',
        response_type_name='Interconnect',
        supports_download=False,
    )

    def GetDiagnostics(self, request, global_params=None):
      r"""Returns the interconnectDiagnostics for the specified interconnect.

      Args:
        request: (ComputeInterconnectsGetDiagnosticsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectsGetDiagnosticsResponse) The response message.
      """
      config = self.GetMethodConfig('GetDiagnostics')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetDiagnostics.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnects.getDiagnostics',
        ordered_params=['project', 'interconnect'],
        path_params=['interconnect', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/interconnects/{interconnect}/getDiagnostics',
        request_field='',
        request_type_name='ComputeInterconnectsGetDiagnosticsRequest',
        response_type_name='InterconnectsGetDiagnosticsResponse',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a Interconnect in the specified project using the data included in the request.

      Args:
        request: (ComputeInterconnectsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnects.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/interconnects',
        request_field='interconnect',
        request_type_name='ComputeInterconnectsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of interconnect available to the specified project.

      Args:
        request: (ComputeInterconnectsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InterconnectList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.interconnects.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/interconnects',
        request_field='',
        request_type_name='ComputeInterconnectsListRequest',
        response_type_name='InterconnectList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified interconnect with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeInterconnectsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.interconnects.patch',
        ordered_params=['project', 'interconnect'],
        path_params=['interconnect', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/interconnects/{interconnect}',
        request_field='interconnectResource',
        request_type_name='ComputeInterconnectsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on an Interconnect. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeInterconnectsSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnects.setLabels',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/interconnects/{resource}/setLabels',
        request_field='globalSetLabelsRequest',
        request_type_name='ComputeInterconnectsSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeInterconnectsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.interconnects.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/interconnects/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeInterconnectsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class LicenseCodesService(base_api.BaseApiService):
    """Service class for the licenseCodes resource."""

    _NAME = 'licenseCodes'

    def __init__(self, client):
      super(ComputeBeta.LicenseCodesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Return a specified license code. License codes are mirrored across all projects that have permissions to read the License Code. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicenseCodesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LicenseCode) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.licenseCodes.get',
        ordered_params=['project', 'licenseCode'],
        path_params=['licenseCode', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/licenseCodes/{licenseCode}',
        request_field='',
        request_type_name='ComputeLicenseCodesGetRequest',
        response_type_name='LicenseCode',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicenseCodesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.licenseCodes.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/licenseCodes/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeLicenseCodesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class LicensesService(base_api.BaseApiService):
    """Service class for the licenses resource."""

    _NAME = 'licenses'

    def __init__(self, client):
      super(ComputeBeta.LicensesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified license. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicensesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.licenses.delete',
        ordered_params=['project', 'license'],
        path_params=['license', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/licenses/{license}',
        request_field='',
        request_type_name='ComputeLicensesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified License resource. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicensesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (License) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.licenses.get',
        ordered_params=['project', 'license'],
        path_params=['license', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/licenses/{license}',
        request_field='',
        request_type_name='ComputeLicensesGetRequest',
        response_type_name='License',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicensesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.licenses.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/licenses/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeLicensesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Create a License resource in the specified project. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicensesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.licenses.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/licenses',
        request_field='license',
        request_type_name='ComputeLicensesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of licenses available in the specified project. This method does not get any licenses that belong to other projects, including licenses attached to publicly-available images, like Debian 9. If you want to get a list of publicly-available licenses, use this method to make a request to the respective image project, such as debian-cloud or windows-cloud. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicensesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LicensesListResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.licenses.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/licenses',
        request_field='',
        request_type_name='ComputeLicensesListRequest',
        response_type_name='LicensesListResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicensesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.licenses.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/licenses/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeLicensesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. .

      Args:
        request: (ComputeLicensesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.licenses.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/licenses/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeLicensesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class MachineImagesService(base_api.BaseApiService):
    """Service class for the machineImages resource."""

    _NAME = 'machineImages'

    def __init__(self, client):
      super(ComputeBeta.MachineImagesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified machine image. Deleting a machine image is permanent and cannot be undone.

      Args:
        request: (ComputeMachineImagesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.machineImages.delete',
        ordered_params=['project', 'machineImage'],
        path_params=['machineImage', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/machineImages/{machineImage}',
        request_field='',
        request_type_name='ComputeMachineImagesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified machine image. Gets a list of available machine images by making a list() request.

      Args:
        request: (ComputeMachineImagesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MachineImage) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.machineImages.get',
        ordered_params=['project', 'machineImage'],
        path_params=['machineImage', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/machineImages/{machineImage}',
        request_field='',
        request_type_name='ComputeMachineImagesGetRequest',
        response_type_name='MachineImage',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeMachineImagesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.machineImages.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/machineImages/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeMachineImagesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a machine image in the specified project using the data that is included in the request. If you are creating a new machine image to update an existing instance, your new machine image should use the same network or, if applicable, the same subnetwork as the original instance.

      Args:
        request: (ComputeMachineImagesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.machineImages.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId', 'sourceInstance'],
        relative_path='projects/{project}/global/machineImages',
        request_field='machineImage',
        request_type_name='ComputeMachineImagesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of machine images that are contained within the specified project.

      Args:
        request: (ComputeMachineImagesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MachineImageList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.machineImages.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/machineImages',
        request_field='',
        request_type_name='ComputeMachineImagesListRequest',
        response_type_name='MachineImageList',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeMachineImagesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.machineImages.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/machineImages/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeMachineImagesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeMachineImagesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.machineImages.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/machineImages/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeMachineImagesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class MachineTypesService(base_api.BaseApiService):
    """Service class for the machineTypes resource."""

    _NAME = 'machineTypes'

    def __init__(self, client):
      super(ComputeBeta.MachineTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of machine types.

      Args:
        request: (ComputeMachineTypesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MachineTypeAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.machineTypes.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/machineTypes',
        request_field='',
        request_type_name='ComputeMachineTypesAggregatedListRequest',
        response_type_name='MachineTypeAggregatedList',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified machine type. Gets a list of available machine types by making a list() request.

      Args:
        request: (ComputeMachineTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MachineType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.machineTypes.get',
        ordered_params=['project', 'zone', 'machineType'],
        path_params=['machineType', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/machineTypes/{machineType}',
        request_field='',
        request_type_name='ComputeMachineTypesGetRequest',
        response_type_name='MachineType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of machine types available to the specified project.

      Args:
        request: (ComputeMachineTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (MachineTypeList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.machineTypes.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/machineTypes',
        request_field='',
        request_type_name='ComputeMachineTypesListRequest',
        response_type_name='MachineTypeList',
        supports_download=False,
    )

  class NetworkEdgeSecurityServicesService(base_api.BaseApiService):
    """Service class for the networkEdgeSecurityServices resource."""

    _NAME = 'networkEdgeSecurityServices'

    def __init__(self, client):
      super(ComputeBeta.NetworkEdgeSecurityServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all NetworkEdgeSecurityService resources available to the specified project.

      Args:
        request: (ComputeNetworkEdgeSecurityServicesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEdgeSecurityServiceAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkEdgeSecurityServices.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/networkEdgeSecurityServices',
        request_field='',
        request_type_name='ComputeNetworkEdgeSecurityServicesAggregatedListRequest',
        response_type_name='NetworkEdgeSecurityServiceAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified service.

      Args:
        request: (ComputeNetworkEdgeSecurityServicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.networkEdgeSecurityServices.delete',
        ordered_params=['project', 'region', 'networkEdgeSecurityService'],
        path_params=['networkEdgeSecurityService', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/networkEdgeSecurityServices/{networkEdgeSecurityService}',
        request_field='',
        request_type_name='ComputeNetworkEdgeSecurityServicesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a specified NetworkEdgeSecurityService.

      Args:
        request: (ComputeNetworkEdgeSecurityServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEdgeSecurityService) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkEdgeSecurityServices.get',
        ordered_params=['project', 'region', 'networkEdgeSecurityService'],
        path_params=['networkEdgeSecurityService', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/networkEdgeSecurityServices/{networkEdgeSecurityService}',
        request_field='',
        request_type_name='ComputeNetworkEdgeSecurityServicesGetRequest',
        response_type_name='NetworkEdgeSecurityService',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new service in the specified project using the data included in the request.

      Args:
        request: (ComputeNetworkEdgeSecurityServicesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkEdgeSecurityServices.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId', 'validateOnly'],
        relative_path='projects/{project}/regions/{region}/networkEdgeSecurityServices',
        request_field='networkEdgeSecurityService',
        request_type_name='ComputeNetworkEdgeSecurityServicesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified policy with the data included in the request.

      Args:
        request: (ComputeNetworkEdgeSecurityServicesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.networkEdgeSecurityServices.patch',
        ordered_params=['project', 'region', 'networkEdgeSecurityService'],
        path_params=['networkEdgeSecurityService', 'project', 'region'],
        query_params=['paths', 'requestId', 'updateMask'],
        relative_path='projects/{project}/regions/{region}/networkEdgeSecurityServices/{networkEdgeSecurityService}',
        request_field='networkEdgeSecurityServiceResource',
        request_type_name='ComputeNetworkEdgeSecurityServicesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class NetworkEndpointGroupsService(base_api.BaseApiService):
    """Service class for the networkEndpointGroups resource."""

    _NAME = 'networkEndpointGroups'

    def __init__(self, client):
      super(ComputeBeta.NetworkEndpointGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of network endpoint groups and sorts them by zone.

      Args:
        request: (ComputeNetworkEndpointGroupsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroupAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkEndpointGroups.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/networkEndpointGroups',
        request_field='',
        request_type_name='ComputeNetworkEndpointGroupsAggregatedListRequest',
        response_type_name='NetworkEndpointGroupAggregatedList',
        supports_download=False,
    )

    def AttachNetworkEndpoints(self, request, global_params=None):
      r"""Attach a list of network endpoints to the specified network endpoint group.

      Args:
        request: (ComputeNetworkEndpointGroupsAttachNetworkEndpointsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AttachNetworkEndpoints')
      return self._RunMethod(
          config, request, global_params=global_params)

    AttachNetworkEndpoints.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkEndpointGroups.attachNetworkEndpoints',
        ordered_params=['project', 'zone', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}/attachNetworkEndpoints',
        request_field='networkEndpointGroupsAttachEndpointsRequest',
        request_type_name='ComputeNetworkEndpointGroupsAttachNetworkEndpointsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified network endpoint group. The network endpoints in the NEG and the VM instances they belong to are not terminated when the NEG is deleted. Note that the NEG cannot be deleted if there are backend services referencing it.

      Args:
        request: (ComputeNetworkEndpointGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.networkEndpointGroups.delete',
        ordered_params=['project', 'zone', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}',
        request_field='',
        request_type_name='ComputeNetworkEndpointGroupsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DetachNetworkEndpoints(self, request, global_params=None):
      r"""Detach a list of network endpoints from the specified network endpoint group.

      Args:
        request: (ComputeNetworkEndpointGroupsDetachNetworkEndpointsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DetachNetworkEndpoints')
      return self._RunMethod(
          config, request, global_params=global_params)

    DetachNetworkEndpoints.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkEndpointGroups.detachNetworkEndpoints',
        ordered_params=['project', 'zone', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}/detachNetworkEndpoints',
        request_field='networkEndpointGroupsDetachEndpointsRequest',
        request_type_name='ComputeNetworkEndpointGroupsDetachNetworkEndpointsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified network endpoint group. Gets a list of available network endpoint groups by making a list() request.

      Args:
        request: (ComputeNetworkEndpointGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkEndpointGroups.get',
        ordered_params=['project', 'zone', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}',
        request_field='',
        request_type_name='ComputeNetworkEndpointGroupsGetRequest',
        response_type_name='NetworkEndpointGroup',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a network endpoint group in the specified project using the parameters that are included in the request.

      Args:
        request: (ComputeNetworkEndpointGroupsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkEndpointGroups.insert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/networkEndpointGroups',
        request_field='networkEndpointGroup',
        request_type_name='ComputeNetworkEndpointGroupsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of network endpoint groups that are located in the specified project and zone.

      Args:
        request: (ComputeNetworkEndpointGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroupList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkEndpointGroups.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/networkEndpointGroups',
        request_field='',
        request_type_name='ComputeNetworkEndpointGroupsListRequest',
        response_type_name='NetworkEndpointGroupList',
        supports_download=False,
    )

    def ListNetworkEndpoints(self, request, global_params=None):
      r"""Lists the network endpoints in the specified network endpoint group.

      Args:
        request: (ComputeNetworkEndpointGroupsListNetworkEndpointsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroupsListNetworkEndpoints) The response message.
      """
      config = self.GetMethodConfig('ListNetworkEndpoints')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListNetworkEndpoints.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkEndpointGroups.listNetworkEndpoints',
        ordered_params=['project', 'zone', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}/listNetworkEndpoints',
        request_field='networkEndpointGroupsListEndpointsRequest',
        request_type_name='ComputeNetworkEndpointGroupsListNetworkEndpointsRequest',
        response_type_name='NetworkEndpointGroupsListNetworkEndpoints',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeNetworkEndpointGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkEndpointGroups.testIamPermissions',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/networkEndpointGroups/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeNetworkEndpointGroupsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class NetworkFirewallPoliciesService(base_api.BaseApiService):
    """Service class for the networkFirewallPolicies resource."""

    _NAME = 'networkFirewallPolicies'

    def __init__(self, client):
      super(ComputeBeta.NetworkFirewallPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddAssociation(self, request, global_params=None):
      r"""Inserts an association for the specified firewall policy.

      Args:
        request: (ComputeNetworkFirewallPoliciesAddAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.addAssociation',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['replaceExistingAssociation', 'requestId'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/addAssociation',
        request_field='firewallPolicyAssociation',
        request_type_name='ComputeNetworkFirewallPoliciesAddAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AddRule(self, request, global_params=None):
      r"""Inserts a rule into a firewall policy.

      Args:
        request: (ComputeNetworkFirewallPoliciesAddRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.addRule',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['maxPriority', 'minPriority', 'requestId'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/addRule',
        request_field='firewallPolicyRule',
        request_type_name='ComputeNetworkFirewallPoliciesAddRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def CloneRules(self, request, global_params=None):
      r"""Copies rules to the specified firewall policy.

      Args:
        request: (ComputeNetworkFirewallPoliciesCloneRulesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CloneRules')
      return self._RunMethod(
          config, request, global_params=global_params)

    CloneRules.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.cloneRules',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['requestId', 'sourceFirewallPolicy'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/cloneRules',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesCloneRulesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified policy.

      Args:
        request: (ComputeNetworkFirewallPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.networkFirewallPolicies.delete',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified network firewall policy.

      Args:
        request: (ComputeNetworkFirewallPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkFirewallPolicies.get',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesGetRequest',
        response_type_name='FirewallPolicy',
        supports_download=False,
    )

    def GetAssociation(self, request, global_params=None):
      r"""Gets an association with the specified name.

      Args:
        request: (ComputeNetworkFirewallPoliciesGetAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyAssociation) The response message.
      """
      config = self.GetMethodConfig('GetAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkFirewallPolicies.getAssociation',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['name'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/getAssociation',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesGetAssociationRequest',
        response_type_name='FirewallPolicyAssociation',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeNetworkFirewallPoliciesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkFirewallPolicies.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/firewallPolicies/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def GetRule(self, request, global_params=None):
      r"""Gets a rule of the specified priority.

      Args:
        request: (ComputeNetworkFirewallPoliciesGetRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyRule) The response message.
      """
      config = self.GetMethodConfig('GetRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkFirewallPolicies.getRule',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['priority'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/getRule',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesGetRuleRequest',
        response_type_name='FirewallPolicyRule',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new policy in the specified project using the data included in the request.

      Args:
        request: (ComputeNetworkFirewallPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/firewallPolicies',
        request_field='firewallPolicy',
        request_type_name='ComputeNetworkFirewallPoliciesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the policies that have been configured for the specified project.

      Args:
        request: (ComputeNetworkFirewallPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networkFirewallPolicies.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/firewallPolicies',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesListRequest',
        response_type_name='FirewallPolicyList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified policy with the data included in the request.

      Args:
        request: (ComputeNetworkFirewallPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.networkFirewallPolicies.patch',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}',
        request_field='firewallPolicyResource',
        request_type_name='ComputeNetworkFirewallPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchRule(self, request, global_params=None):
      r"""Patches a rule of the specified priority.

      Args:
        request: (ComputeNetworkFirewallPoliciesPatchRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.patchRule',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['priority', 'requestId'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/patchRule',
        request_field='firewallPolicyRule',
        request_type_name='ComputeNetworkFirewallPoliciesPatchRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveAssociation(self, request, global_params=None):
      r"""Removes an association for the specified firewall policy.

      Args:
        request: (ComputeNetworkFirewallPoliciesRemoveAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.removeAssociation',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['name', 'requestId'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/removeAssociation',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesRemoveAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveRule(self, request, global_params=None):
      r"""Deletes a rule of the specified priority.

      Args:
        request: (ComputeNetworkFirewallPoliciesRemoveRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.removeRule',
        ordered_params=['project', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project'],
        query_params=['priority', 'requestId'],
        relative_path='projects/{project}/global/firewallPolicies/{firewallPolicy}/removeRule',
        request_field='',
        request_type_name='ComputeNetworkFirewallPoliciesRemoveRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeNetworkFirewallPoliciesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/firewallPolicies/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeNetworkFirewallPoliciesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeNetworkFirewallPoliciesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networkFirewallPolicies.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/firewallPolicies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeNetworkFirewallPoliciesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class NetworksService(base_api.BaseApiService):
    """Service class for the networks resource."""

    _NAME = 'networks'

    def __init__(self, client):
      super(ComputeBeta.NetworksService, self).__init__(client)
      self._upload_configs = {
          }

    def AddPeering(self, request, global_params=None):
      r"""Adds a peering to the specified network.

      Args:
        request: (ComputeNetworksAddPeeringRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddPeering')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddPeering.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networks.addPeering',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networks/{network}/addPeering',
        request_field='networksAddPeeringRequest',
        request_type_name='ComputeNetworksAddPeeringRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified network.

      Args:
        request: (ComputeNetworksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.networks.delete',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networks/{network}',
        request_field='',
        request_type_name='ComputeNetworksDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified network. Gets a list of available networks by making a list() request.

      Args:
        request: (ComputeNetworksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Network) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networks.get',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/networks/{network}',
        request_field='',
        request_type_name='ComputeNetworksGetRequest',
        response_type_name='Network',
        supports_download=False,
    )

    def GetEffectiveFirewalls(self, request, global_params=None):
      r"""Returns the effective firewalls on a given network.

      Args:
        request: (ComputeNetworksGetEffectiveFirewallsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworksGetEffectiveFirewallsResponse) The response message.
      """
      config = self.GetMethodConfig('GetEffectiveFirewalls')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetEffectiveFirewalls.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networks.getEffectiveFirewalls',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=[],
        relative_path='projects/{project}/global/networks/{network}/getEffectiveFirewalls',
        request_field='',
        request_type_name='ComputeNetworksGetEffectiveFirewallsRequest',
        response_type_name='NetworksGetEffectiveFirewallsResponse',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a network in the specified project using the data included in the request.

      Args:
        request: (ComputeNetworksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networks.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networks',
        request_field='network',
        request_type_name='ComputeNetworksInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of networks available to the specified project.

      Args:
        request: (ComputeNetworksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networks.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/networks',
        request_field='',
        request_type_name='ComputeNetworksListRequest',
        response_type_name='NetworkList',
        supports_download=False,
    )

    def ListPeeringRoutes(self, request, global_params=None):
      r"""Lists the peering routes exchanged over peering connection.

      Args:
        request: (ComputeNetworksListPeeringRoutesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ExchangedPeeringRoutesList) The response message.
      """
      config = self.GetMethodConfig('ListPeeringRoutes')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListPeeringRoutes.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.networks.listPeeringRoutes',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=['direction', 'filter', 'maxResults', 'orderBy', 'pageToken', 'peeringName', 'region', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/networks/{network}/listPeeringRoutes',
        request_field='',
        request_type_name='ComputeNetworksListPeeringRoutesRequest',
        response_type_name='ExchangedPeeringRoutesList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified network with the data included in the request. Only the following fields can be modified: routingConfig.routingMode.

      Args:
        request: (ComputeNetworksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.networks.patch',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networks/{network}',
        request_field='networkResource',
        request_type_name='ComputeNetworksPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemovePeering(self, request, global_params=None):
      r"""Removes a peering from the specified network.

      Args:
        request: (ComputeNetworksRemovePeeringRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemovePeering')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemovePeering.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networks.removePeering',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networks/{network}/removePeering',
        request_field='networksRemovePeeringRequest',
        request_type_name='ComputeNetworksRemovePeeringRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SwitchToCustomMode(self, request, global_params=None):
      r"""Switches the network mode from auto subnet mode to custom subnet mode.

      Args:
        request: (ComputeNetworksSwitchToCustomModeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SwitchToCustomMode')
      return self._RunMethod(
          config, request, global_params=global_params)

    SwitchToCustomMode.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networks.switchToCustomMode',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networks/{network}/switchToCustomMode',
        request_field='',
        request_type_name='ComputeNetworksSwitchToCustomModeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeNetworksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.networks.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/networks/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeNetworksTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def UpdatePeering(self, request, global_params=None):
      r"""Updates the specified network peering with the data included in the request. You can only modify the NetworkPeering.export_custom_routes field and the NetworkPeering.import_custom_routes field.

      Args:
        request: (ComputeNetworksUpdatePeeringRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdatePeering')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdatePeering.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.networks.updatePeering',
        ordered_params=['project', 'network'],
        path_params=['network', 'project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/networks/{network}/updatePeering',
        request_field='networksUpdatePeeringRequest',
        request_type_name='ComputeNetworksUpdatePeeringRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class NodeGroupsService(base_api.BaseApiService):
    """Service class for the nodeGroups resource."""

    _NAME = 'nodeGroups'

    def __init__(self, client):
      super(ComputeBeta.NodeGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def AddNodes(self, request, global_params=None):
      r"""Adds specified number of nodes to the node group.

      Args:
        request: (ComputeNodeGroupsAddNodesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddNodes')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddNodes.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeGroups.addNodes',
        ordered_params=['project', 'zone', 'nodeGroup'],
        path_params=['nodeGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/addNodes',
        request_field='nodeGroupsAddNodesRequest',
        request_type_name='ComputeNodeGroupsAddNodesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of node groups. Note: use nodeGroups.listNodes for more details about each group.

      Args:
        request: (ComputeNodeGroupsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeGroupAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeGroups.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/nodeGroups',
        request_field='',
        request_type_name='ComputeNodeGroupsAggregatedListRequest',
        response_type_name='NodeGroupAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified NodeGroup resource.

      Args:
        request: (ComputeNodeGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.nodeGroups.delete',
        ordered_params=['project', 'zone', 'nodeGroup'],
        path_params=['nodeGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}',
        request_field='',
        request_type_name='ComputeNodeGroupsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DeleteNodes(self, request, global_params=None):
      r"""Deletes specified nodes from the node group.

      Args:
        request: (ComputeNodeGroupsDeleteNodesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteNodes')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteNodes.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeGroups.deleteNodes',
        ordered_params=['project', 'zone', 'nodeGroup'],
        path_params=['nodeGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/deleteNodes',
        request_field='nodeGroupsDeleteNodesRequest',
        request_type_name='ComputeNodeGroupsDeleteNodesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified NodeGroup. Get a list of available NodeGroups by making a list() request. Note: the "nodes" field should not be used. Use nodeGroups.listNodes instead.

      Args:
        request: (ComputeNodeGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeGroups.get',
        ordered_params=['project', 'zone', 'nodeGroup'],
        path_params=['nodeGroup', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}',
        request_field='',
        request_type_name='ComputeNodeGroupsGetRequest',
        response_type_name='NodeGroup',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeNodeGroupsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeGroups.getIamPolicy',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeNodeGroupsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a NodeGroup resource in the specified project using the data included in the request.

      Args:
        request: (ComputeNodeGroupsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeGroups.insert',
        ordered_params=['project', 'zone', 'initialNodeCount'],
        path_params=['project', 'zone'],
        query_params=['initialNodeCount', 'requestId'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups',
        request_field='nodeGroup',
        request_type_name='ComputeNodeGroupsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of node groups available to the specified project. Note: use nodeGroups.listNodes for more details about each group.

      Args:
        request: (ComputeNodeGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeGroupList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeGroups.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups',
        request_field='',
        request_type_name='ComputeNodeGroupsListRequest',
        response_type_name='NodeGroupList',
        supports_download=False,
    )

    def ListNodes(self, request, global_params=None):
      r"""Lists nodes in the node group.

      Args:
        request: (ComputeNodeGroupsListNodesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeGroupsListNodes) The response message.
      """
      config = self.GetMethodConfig('ListNodes')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListNodes.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeGroups.listNodes',
        ordered_params=['project', 'zone', 'nodeGroup'],
        path_params=['nodeGroup', 'project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/listNodes',
        request_field='',
        request_type_name='ComputeNodeGroupsListNodesRequest',
        response_type_name='NodeGroupsListNodes',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified node group.

      Args:
        request: (ComputeNodeGroupsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.nodeGroups.patch',
        ordered_params=['project', 'zone', 'nodeGroup'],
        path_params=['nodeGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}',
        request_field='nodeGroupResource',
        request_type_name='ComputeNodeGroupsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeNodeGroupsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeGroups.setIamPolicy',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{resource}/setIamPolicy',
        request_field='zoneSetPolicyRequest',
        request_type_name='ComputeNodeGroupsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetNodeTemplate(self, request, global_params=None):
      r"""Updates the node template of the node group.

      Args:
        request: (ComputeNodeGroupsSetNodeTemplateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetNodeTemplate')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetNodeTemplate.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeGroups.setNodeTemplate',
        ordered_params=['project', 'zone', 'nodeGroup'],
        path_params=['nodeGroup', 'project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/setNodeTemplate',
        request_field='nodeGroupsSetNodeTemplateRequest',
        request_type_name='ComputeNodeGroupsSetNodeTemplateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeNodeGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeGroups.testIamPermissions',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/nodeGroups/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeNodeGroupsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class NodeTemplatesService(base_api.BaseApiService):
    """Service class for the nodeTemplates resource."""

    _NAME = 'nodeTemplates'

    def __init__(self, client):
      super(ComputeBeta.NodeTemplatesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of node templates.

      Args:
        request: (ComputeNodeTemplatesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeTemplateAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeTemplates.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/nodeTemplates',
        request_field='',
        request_type_name='ComputeNodeTemplatesAggregatedListRequest',
        response_type_name='NodeTemplateAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified NodeTemplate resource.

      Args:
        request: (ComputeNodeTemplatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.nodeTemplates.delete',
        ordered_params=['project', 'region', 'nodeTemplate'],
        path_params=['nodeTemplate', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/nodeTemplates/{nodeTemplate}',
        request_field='',
        request_type_name='ComputeNodeTemplatesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified node template. Gets a list of available node templates by making a list() request.

      Args:
        request: (ComputeNodeTemplatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeTemplate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeTemplates.get',
        ordered_params=['project', 'region', 'nodeTemplate'],
        path_params=['nodeTemplate', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/nodeTemplates/{nodeTemplate}',
        request_field='',
        request_type_name='ComputeNodeTemplatesGetRequest',
        response_type_name='NodeTemplate',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeNodeTemplatesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeTemplates.getIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/regions/{region}/nodeTemplates/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeNodeTemplatesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a NodeTemplate resource in the specified project using the data included in the request.

      Args:
        request: (ComputeNodeTemplatesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeTemplates.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/nodeTemplates',
        request_field='nodeTemplate',
        request_type_name='ComputeNodeTemplatesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of node templates available to the specified project.

      Args:
        request: (ComputeNodeTemplatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeTemplateList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeTemplates.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/nodeTemplates',
        request_field='',
        request_type_name='ComputeNodeTemplatesListRequest',
        response_type_name='NodeTemplateList',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeNodeTemplatesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeTemplates.setIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/nodeTemplates/{resource}/setIamPolicy',
        request_field='regionSetPolicyRequest',
        request_type_name='ComputeNodeTemplatesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeNodeTemplatesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.nodeTemplates.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/nodeTemplates/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeNodeTemplatesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class NodeTypesService(base_api.BaseApiService):
    """Service class for the nodeTypes resource."""

    _NAME = 'nodeTypes'

    def __init__(self, client):
      super(ComputeBeta.NodeTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of node types.

      Args:
        request: (ComputeNodeTypesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeTypeAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeTypes.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/nodeTypes',
        request_field='',
        request_type_name='ComputeNodeTypesAggregatedListRequest',
        response_type_name='NodeTypeAggregatedList',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified node type. Gets a list of available node types by making a list() request.

      Args:
        request: (ComputeNodeTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeTypes.get',
        ordered_params=['project', 'zone', 'nodeType'],
        path_params=['nodeType', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/nodeTypes/{nodeType}',
        request_field='',
        request_type_name='ComputeNodeTypesGetRequest',
        response_type_name='NodeType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of node types available to the specified project.

      Args:
        request: (ComputeNodeTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NodeTypeList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.nodeTypes.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/nodeTypes',
        request_field='',
        request_type_name='ComputeNodeTypesListRequest',
        response_type_name='NodeTypeList',
        supports_download=False,
    )

  class OrganizationSecurityPoliciesService(base_api.BaseApiService):
    """Service class for the organizationSecurityPolicies resource."""

    _NAME = 'organizationSecurityPolicies'

    def __init__(self, client):
      super(ComputeBeta.OrganizationSecurityPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddAssociation(self, request, global_params=None):
      r"""Inserts an association for the specified security policy.

      Args:
        request: (ComputeOrganizationSecurityPoliciesAddAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.organizationSecurityPolicies.addAssociation',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['replaceExistingAssociation', 'requestId'],
        relative_path='locations/global/securityPolicies/{securityPolicy}/addAssociation',
        request_field='securityPolicyAssociation',
        request_type_name='ComputeOrganizationSecurityPoliciesAddAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AddRule(self, request, global_params=None):
      r"""Inserts a rule into a security policy.

      Args:
        request: (ComputeOrganizationSecurityPoliciesAddRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.organizationSecurityPolicies.addRule',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['requestId'],
        relative_path='locations/global/securityPolicies/{securityPolicy}/addRule',
        request_field='securityPolicyRule',
        request_type_name='ComputeOrganizationSecurityPoliciesAddRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def CopyRules(self, request, global_params=None):
      r"""Copies rules to the specified security policy.

      Args:
        request: (ComputeOrganizationSecurityPoliciesCopyRulesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CopyRules')
      return self._RunMethod(
          config, request, global_params=global_params)

    CopyRules.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.organizationSecurityPolicies.copyRules',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['requestId', 'sourceSecurityPolicy'],
        relative_path='locations/global/securityPolicies/{securityPolicy}/copyRules',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesCopyRulesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified policy.

      Args:
        request: (ComputeOrganizationSecurityPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.organizationSecurityPolicies.delete',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['requestId'],
        relative_path='locations/global/securityPolicies/{securityPolicy}',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""List all of the ordered rules present in a single specified policy.

      Args:
        request: (ComputeOrganizationSecurityPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.organizationSecurityPolicies.get',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=[],
        relative_path='locations/global/securityPolicies/{securityPolicy}',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesGetRequest',
        response_type_name='SecurityPolicy',
        supports_download=False,
    )

    def GetAssociation(self, request, global_params=None):
      r"""Gets an association with the specified name.

      Args:
        request: (ComputeOrganizationSecurityPoliciesGetAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicyAssociation) The response message.
      """
      config = self.GetMethodConfig('GetAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.organizationSecurityPolicies.getAssociation',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['name'],
        relative_path='locations/global/securityPolicies/{securityPolicy}/getAssociation',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesGetAssociationRequest',
        response_type_name='SecurityPolicyAssociation',
        supports_download=False,
    )

    def GetRule(self, request, global_params=None):
      r"""Gets a rule at the specified priority.

      Args:
        request: (ComputeOrganizationSecurityPoliciesGetRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicyRule) The response message.
      """
      config = self.GetMethodConfig('GetRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.organizationSecurityPolicies.getRule',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['priority'],
        relative_path='locations/global/securityPolicies/{securityPolicy}/getRule',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesGetRuleRequest',
        response_type_name='SecurityPolicyRule',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new policy in the specified project using the data included in the request.

      Args:
        request: (ComputeOrganizationSecurityPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.organizationSecurityPolicies.insert',
        ordered_params=[],
        path_params=[],
        query_params=['parentId', 'requestId'],
        relative_path='locations/global/securityPolicies',
        request_field='securityPolicy',
        request_type_name='ComputeOrganizationSecurityPoliciesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List all the policies that have been configured for the specified project.

      Args:
        request: (ComputeOrganizationSecurityPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.organizationSecurityPolicies.list',
        ordered_params=[],
        path_params=[],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'parentId', 'returnPartialSuccess'],
        relative_path='locations/global/securityPolicies',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesListRequest',
        response_type_name='SecurityPolicyList',
        supports_download=False,
    )

    def ListAssociations(self, request, global_params=None):
      r"""Lists associations of a specified target, i.e., organization or folder.

      Args:
        request: (ComputeOrganizationSecurityPoliciesListAssociationsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrganizationSecurityPoliciesListAssociationsResponse) The response message.
      """
      config = self.GetMethodConfig('ListAssociations')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListAssociations.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.organizationSecurityPolicies.listAssociations',
        ordered_params=[],
        path_params=[],
        query_params=['targetResource'],
        relative_path='locations/global/securityPolicies/listAssociations',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesListAssociationsRequest',
        response_type_name='OrganizationSecurityPoliciesListAssociationsResponse',
        supports_download=False,
    )

    def Move(self, request, global_params=None):
      r"""Moves the specified security policy.

      Args:
        request: (ComputeOrganizationSecurityPoliciesMoveRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Move')
      return self._RunMethod(
          config, request, global_params=global_params)

    Move.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.organizationSecurityPolicies.move',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['parentId', 'requestId'],
        relative_path='locations/global/securityPolicies/{securityPolicy}/move',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesMoveRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified policy with the data included in the request.

      Args:
        request: (ComputeOrganizationSecurityPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.organizationSecurityPolicies.patch',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['requestId'],
        relative_path='locations/global/securityPolicies/{securityPolicy}',
        request_field='securityPolicyResource',
        request_type_name='ComputeOrganizationSecurityPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchRule(self, request, global_params=None):
      r"""Patches a rule at the specified priority.

      Args:
        request: (ComputeOrganizationSecurityPoliciesPatchRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.organizationSecurityPolicies.patchRule',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['priority', 'requestId'],
        relative_path='locations/global/securityPolicies/{securityPolicy}/patchRule',
        request_field='securityPolicyRule',
        request_type_name='ComputeOrganizationSecurityPoliciesPatchRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveAssociation(self, request, global_params=None):
      r"""Removes an association for the specified security policy.

      Args:
        request: (ComputeOrganizationSecurityPoliciesRemoveAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.organizationSecurityPolicies.removeAssociation',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['name', 'requestId'],
        relative_path='locations/global/securityPolicies/{securityPolicy}/removeAssociation',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesRemoveAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveRule(self, request, global_params=None):
      r"""Deletes a rule at the specified priority.

      Args:
        request: (ComputeOrganizationSecurityPoliciesRemoveRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.organizationSecurityPolicies.removeRule',
        ordered_params=['securityPolicy'],
        path_params=['securityPolicy'],
        query_params=['priority', 'requestId'],
        relative_path='locations/global/securityPolicies/{securityPolicy}/removeRule',
        request_field='',
        request_type_name='ComputeOrganizationSecurityPoliciesRemoveRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class PacketMirroringsService(base_api.BaseApiService):
    """Service class for the packetMirrorings resource."""

    _NAME = 'packetMirrorings'

    def __init__(self, client):
      super(ComputeBeta.PacketMirroringsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of packetMirrorings.

      Args:
        request: (ComputePacketMirroringsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PacketMirroringAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.packetMirrorings.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/packetMirrorings',
        request_field='',
        request_type_name='ComputePacketMirroringsAggregatedListRequest',
        response_type_name='PacketMirroringAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified PacketMirroring resource.

      Args:
        request: (ComputePacketMirroringsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.packetMirrorings.delete',
        ordered_params=['project', 'region', 'packetMirroring'],
        path_params=['packetMirroring', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/packetMirrorings/{packetMirroring}',
        request_field='',
        request_type_name='ComputePacketMirroringsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified PacketMirroring resource.

      Args:
        request: (ComputePacketMirroringsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PacketMirroring) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.packetMirrorings.get',
        ordered_params=['project', 'region', 'packetMirroring'],
        path_params=['packetMirroring', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/packetMirrorings/{packetMirroring}',
        request_field='',
        request_type_name='ComputePacketMirroringsGetRequest',
        response_type_name='PacketMirroring',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a PacketMirroring resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputePacketMirroringsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.packetMirrorings.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/packetMirrorings',
        request_field='packetMirroring',
        request_type_name='ComputePacketMirroringsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of PacketMirroring resources available to the specified project and region.

      Args:
        request: (ComputePacketMirroringsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PacketMirroringList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.packetMirrorings.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/packetMirrorings',
        request_field='',
        request_type_name='ComputePacketMirroringsListRequest',
        response_type_name='PacketMirroringList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified PacketMirroring resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputePacketMirroringsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.packetMirrorings.patch',
        ordered_params=['project', 'region', 'packetMirroring'],
        path_params=['packetMirroring', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/packetMirrorings/{packetMirroring}',
        request_field='packetMirroringResource',
        request_type_name='ComputePacketMirroringsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputePacketMirroringsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.packetMirrorings.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/packetMirrorings/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputePacketMirroringsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(ComputeBeta.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

    def DisableXpnHost(self, request, global_params=None):
      r"""Disable this project as a shared VPC host project.

      Args:
        request: (ComputeProjectsDisableXpnHostRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DisableXpnHost')
      return self._RunMethod(
          config, request, global_params=global_params)

    DisableXpnHost.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.disableXpnHost',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/disableXpnHost',
        request_field='',
        request_type_name='ComputeProjectsDisableXpnHostRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DisableXpnResource(self, request, global_params=None):
      r"""Disable a service resource (also known as service project) associated with this host project.

      Args:
        request: (ComputeProjectsDisableXpnResourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DisableXpnResource')
      return self._RunMethod(
          config, request, global_params=global_params)

    DisableXpnResource.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.disableXpnResource',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/disableXpnResource',
        request_field='projectsDisableXpnResourceRequest',
        request_type_name='ComputeProjectsDisableXpnResourceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def EnableXpnHost(self, request, global_params=None):
      r"""Enable this project as a shared VPC host project.

      Args:
        request: (ComputeProjectsEnableXpnHostRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('EnableXpnHost')
      return self._RunMethod(
          config, request, global_params=global_params)

    EnableXpnHost.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.enableXpnHost',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/enableXpnHost',
        request_field='',
        request_type_name='ComputeProjectsEnableXpnHostRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def EnableXpnResource(self, request, global_params=None):
      r"""Enable service resource (a.k.a service project) for a host project, so that subnets in the host project can be used by instances in the service project.

      Args:
        request: (ComputeProjectsEnableXpnResourceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('EnableXpnResource')
      return self._RunMethod(
          config, request, global_params=global_params)

    EnableXpnResource.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.enableXpnResource',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/enableXpnResource',
        request_field='projectsEnableXpnResourceRequest',
        request_type_name='ComputeProjectsEnableXpnResourceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified Project resource. To decrease latency for this method, you can optionally omit any unneeded information from the response by using a field mask. This practice is especially recommended for unused quota information (the `quotas` field). To exclude one or more fields, set your request's `fields` query parameter to only include the fields you need. For example, to only include the `id` and `selfLink` fields, add the query parameter `?fields=id,selfLink` to your request.

      Args:
        request: (ComputeProjectsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Project) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.projects.get',
        ordered_params=['project'],
        path_params=['project'],
        query_params=[],
        relative_path='projects/{project}',
        request_field='',
        request_type_name='ComputeProjectsGetRequest',
        response_type_name='Project',
        supports_download=False,
    )

    def GetXpnHost(self, request, global_params=None):
      r"""Gets the shared VPC host project that this project links to. May be empty if no link exists.

      Args:
        request: (ComputeProjectsGetXpnHostRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Project) The response message.
      """
      config = self.GetMethodConfig('GetXpnHost')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetXpnHost.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.projects.getXpnHost',
        ordered_params=['project'],
        path_params=['project'],
        query_params=[],
        relative_path='projects/{project}/getXpnHost',
        request_field='',
        request_type_name='ComputeProjectsGetXpnHostRequest',
        response_type_name='Project',
        supports_download=False,
    )

    def GetXpnResources(self, request, global_params=None):
      r"""Gets service resources (a.k.a service project) associated with this host project.

      Args:
        request: (ComputeProjectsGetXpnResourcesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ProjectsGetXpnResources) The response message.
      """
      config = self.GetMethodConfig('GetXpnResources')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetXpnResources.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.projects.getXpnResources',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/getXpnResources',
        request_field='',
        request_type_name='ComputeProjectsGetXpnResourcesRequest',
        response_type_name='ProjectsGetXpnResources',
        supports_download=False,
    )

    def ListXpnHosts(self, request, global_params=None):
      r"""Lists all shared VPC host projects visible to the user in an organization.

      Args:
        request: (ComputeProjectsListXpnHostsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (XpnHostList) The response message.
      """
      config = self.GetMethodConfig('ListXpnHosts')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListXpnHosts.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.listXpnHosts',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/listXpnHosts',
        request_field='projectsListXpnHostsRequest',
        request_type_name='ComputeProjectsListXpnHostsRequest',
        response_type_name='XpnHostList',
        supports_download=False,
    )

    def MoveDisk(self, request, global_params=None):
      r"""Moves a persistent disk from one zone to another.

      Args:
        request: (ComputeProjectsMoveDiskRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('MoveDisk')
      return self._RunMethod(
          config, request, global_params=global_params)

    MoveDisk.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.moveDisk',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/moveDisk',
        request_field='diskMoveRequest',
        request_type_name='ComputeProjectsMoveDiskRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def MoveInstance(self, request, global_params=None):
      r"""Moves an instance and its attached persistent disks from one zone to another. *Note*: Moving VMs or disks by using this method might cause unexpected behavior. For more information, see the [known issue](/compute/docs/troubleshooting/known-issues#moving_vms_or_disks_using_the_moveinstance_api_or_the_causes_unexpected_behavior).

      Args:
        request: (ComputeProjectsMoveInstanceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('MoveInstance')
      return self._RunMethod(
          config, request, global_params=global_params)

    MoveInstance.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.moveInstance',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/moveInstance',
        request_field='instanceMoveRequest',
        request_type_name='ComputeProjectsMoveInstanceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetCommonInstanceMetadata(self, request, global_params=None):
      r"""Sets metadata common to all instances within the specified project using the data included in the request.

      Args:
        request: (ComputeProjectsSetCommonInstanceMetadataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetCommonInstanceMetadata')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetCommonInstanceMetadata.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.setCommonInstanceMetadata',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/setCommonInstanceMetadata',
        request_field='metadata',
        request_type_name='ComputeProjectsSetCommonInstanceMetadataRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetDefaultNetworkTier(self, request, global_params=None):
      r"""Sets the default network tier of the project. The default network tier is used when an address/forwardingRule/instance is created without specifying the network tier field.

      Args:
        request: (ComputeProjectsSetDefaultNetworkTierRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetDefaultNetworkTier')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetDefaultNetworkTier.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.setDefaultNetworkTier',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/setDefaultNetworkTier',
        request_field='projectsSetDefaultNetworkTierRequest',
        request_type_name='ComputeProjectsSetDefaultNetworkTierRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetUsageExportBucket(self, request, global_params=None):
      r"""Enables the usage export feature and sets the usage export bucket where reports are stored. If you provide an empty request body using this method, the usage export feature will be disabled.

      Args:
        request: (ComputeProjectsSetUsageExportBucketRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetUsageExportBucket')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetUsageExportBucket.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.projects.setUsageExportBucket',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/setUsageExportBucket',
        request_field='usageExportLocation',
        request_type_name='ComputeProjectsSetUsageExportBucketRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class PublicAdvertisedPrefixesService(base_api.BaseApiService):
    """Service class for the publicAdvertisedPrefixes resource."""

    _NAME = 'publicAdvertisedPrefixes'

    def __init__(self, client):
      super(ComputeBeta.PublicAdvertisedPrefixesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified PublicAdvertisedPrefix.

      Args:
        request: (ComputePublicAdvertisedPrefixesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.publicAdvertisedPrefixes.delete',
        ordered_params=['project', 'publicAdvertisedPrefix'],
        path_params=['project', 'publicAdvertisedPrefix'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/publicAdvertisedPrefixes/{publicAdvertisedPrefix}',
        request_field='',
        request_type_name='ComputePublicAdvertisedPrefixesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified PublicAdvertisedPrefix resource.

      Args:
        request: (ComputePublicAdvertisedPrefixesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PublicAdvertisedPrefix) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.publicAdvertisedPrefixes.get',
        ordered_params=['project', 'publicAdvertisedPrefix'],
        path_params=['project', 'publicAdvertisedPrefix'],
        query_params=[],
        relative_path='projects/{project}/global/publicAdvertisedPrefixes/{publicAdvertisedPrefix}',
        request_field='',
        request_type_name='ComputePublicAdvertisedPrefixesGetRequest',
        response_type_name='PublicAdvertisedPrefix',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a PublicAdvertisedPrefix in the specified project using the parameters that are included in the request.

      Args:
        request: (ComputePublicAdvertisedPrefixesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.publicAdvertisedPrefixes.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/publicAdvertisedPrefixes',
        request_field='publicAdvertisedPrefix',
        request_type_name='ComputePublicAdvertisedPrefixesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the PublicAdvertisedPrefixes for a project.

      Args:
        request: (ComputePublicAdvertisedPrefixesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PublicAdvertisedPrefixList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.publicAdvertisedPrefixes.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/publicAdvertisedPrefixes',
        request_field='',
        request_type_name='ComputePublicAdvertisedPrefixesListRequest',
        response_type_name='PublicAdvertisedPrefixList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified Router resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputePublicAdvertisedPrefixesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.publicAdvertisedPrefixes.patch',
        ordered_params=['project', 'publicAdvertisedPrefix'],
        path_params=['project', 'publicAdvertisedPrefix'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/publicAdvertisedPrefixes/{publicAdvertisedPrefix}',
        request_field='publicAdvertisedPrefixResource',
        request_type_name='ComputePublicAdvertisedPrefixesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class PublicDelegatedPrefixesService(base_api.BaseApiService):
    """Service class for the publicDelegatedPrefixes resource."""

    _NAME = 'publicDelegatedPrefixes'

    def __init__(self, client):
      super(ComputeBeta.PublicDelegatedPrefixesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Lists all PublicDelegatedPrefix resources owned by the specific project across all scopes.

      Args:
        request: (ComputePublicDelegatedPrefixesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PublicDelegatedPrefixAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.publicDelegatedPrefixes.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/publicDelegatedPrefixes',
        request_field='',
        request_type_name='ComputePublicDelegatedPrefixesAggregatedListRequest',
        response_type_name='PublicDelegatedPrefixAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified PublicDelegatedPrefix in the given region.

      Args:
        request: (ComputePublicDelegatedPrefixesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.publicDelegatedPrefixes.delete',
        ordered_params=['project', 'region', 'publicDelegatedPrefix'],
        path_params=['project', 'publicDelegatedPrefix', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/publicDelegatedPrefixes/{publicDelegatedPrefix}',
        request_field='',
        request_type_name='ComputePublicDelegatedPrefixesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified PublicDelegatedPrefix resource in the given region.

      Args:
        request: (ComputePublicDelegatedPrefixesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PublicDelegatedPrefix) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.publicDelegatedPrefixes.get',
        ordered_params=['project', 'region', 'publicDelegatedPrefix'],
        path_params=['project', 'publicDelegatedPrefix', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/publicDelegatedPrefixes/{publicDelegatedPrefix}',
        request_field='',
        request_type_name='ComputePublicDelegatedPrefixesGetRequest',
        response_type_name='PublicDelegatedPrefix',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a PublicDelegatedPrefix in the specified project in the given region using the parameters that are included in the request.

      Args:
        request: (ComputePublicDelegatedPrefixesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.publicDelegatedPrefixes.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/publicDelegatedPrefixes',
        request_field='publicDelegatedPrefix',
        request_type_name='ComputePublicDelegatedPrefixesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the PublicDelegatedPrefixes for a project in the given region.

      Args:
        request: (ComputePublicDelegatedPrefixesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (PublicDelegatedPrefixList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.publicDelegatedPrefixes.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/publicDelegatedPrefixes',
        request_field='',
        request_type_name='ComputePublicDelegatedPrefixesListRequest',
        response_type_name='PublicDelegatedPrefixList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified PublicDelegatedPrefix resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputePublicDelegatedPrefixesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.publicDelegatedPrefixes.patch',
        ordered_params=['project', 'region', 'publicDelegatedPrefix'],
        path_params=['project', 'publicDelegatedPrefix', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/publicDelegatedPrefixes/{publicDelegatedPrefix}',
        request_field='publicDelegatedPrefixResource',
        request_type_name='ComputePublicDelegatedPrefixesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionAutoscalersService(base_api.BaseApiService):
    """Service class for the regionAutoscalers resource."""

    _NAME = 'regionAutoscalers'

    def __init__(self, client):
      super(ComputeBeta.RegionAutoscalersService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified autoscaler.

      Args:
        request: (ComputeRegionAutoscalersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionAutoscalers.delete',
        ordered_params=['project', 'region', 'autoscaler'],
        path_params=['autoscaler', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/autoscalers/{autoscaler}',
        request_field='',
        request_type_name='ComputeRegionAutoscalersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified autoscaler.

      Args:
        request: (ComputeRegionAutoscalersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Autoscaler) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionAutoscalers.get',
        ordered_params=['project', 'region', 'autoscaler'],
        path_params=['autoscaler', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/autoscalers/{autoscaler}',
        request_field='',
        request_type_name='ComputeRegionAutoscalersGetRequest',
        response_type_name='Autoscaler',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates an autoscaler in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionAutoscalersInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionAutoscalers.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/autoscalers',
        request_field='autoscaler',
        request_type_name='ComputeRegionAutoscalersInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of autoscalers contained within the specified region.

      Args:
        request: (ComputeRegionAutoscalersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionAutoscalerList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionAutoscalers.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/autoscalers',
        request_field='',
        request_type_name='ComputeRegionAutoscalersListRequest',
        response_type_name='RegionAutoscalerList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an autoscaler in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionAutoscalersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionAutoscalers.patch',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['autoscaler', 'requestId'],
        relative_path='projects/{project}/regions/{region}/autoscalers',
        request_field='autoscalerResource',
        request_type_name='ComputeRegionAutoscalersPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionAutoscalersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionAutoscalers.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/autoscalers/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionAutoscalersTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an autoscaler in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionAutoscalersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.regionAutoscalers.update',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['autoscaler', 'requestId'],
        relative_path='projects/{project}/regions/{region}/autoscalers',
        request_field='autoscalerResource',
        request_type_name='ComputeRegionAutoscalersUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionBackendServicesService(base_api.BaseApiService):
    """Service class for the regionBackendServices resource."""

    _NAME = 'regionBackendServices'

    def __init__(self, client):
      super(ComputeBeta.RegionBackendServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified regional BackendService resource.

      Args:
        request: (ComputeRegionBackendServicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionBackendServices.delete',
        ordered_params=['project', 'region', 'backendService'],
        path_params=['backendService', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/backendServices/{backendService}',
        request_field='',
        request_type_name='ComputeRegionBackendServicesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified regional BackendService resource.

      Args:
        request: (ComputeRegionBackendServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendService) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionBackendServices.get',
        ordered_params=['project', 'region', 'backendService'],
        path_params=['backendService', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/backendServices/{backendService}',
        request_field='',
        request_type_name='ComputeRegionBackendServicesGetRequest',
        response_type_name='BackendService',
        supports_download=False,
    )

    def GetHealth(self, request, global_params=None):
      r"""Gets the most recent health check results for this regional BackendService.

      Args:
        request: (ComputeRegionBackendServicesGetHealthRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendServiceGroupHealth) The response message.
      """
      config = self.GetMethodConfig('GetHealth')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetHealth.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionBackendServices.getHealth',
        ordered_params=['project', 'region', 'backendService'],
        path_params=['backendService', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/backendServices/{backendService}/getHealth',
        request_field='resourceGroupReference',
        request_type_name='ComputeRegionBackendServicesGetHealthRequest',
        response_type_name='BackendServiceGroupHealth',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeRegionBackendServicesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionBackendServices.getIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/regions/{region}/backendServices/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeRegionBackendServicesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a regional BackendService resource in the specified project using the data included in the request. For more information, see Backend services overview.

      Args:
        request: (ComputeRegionBackendServicesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionBackendServices.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/backendServices',
        request_field='backendService',
        request_type_name='ComputeRegionBackendServicesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of regional BackendService resources available to the specified project in the given region.

      Args:
        request: (ComputeRegionBackendServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BackendServiceList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionBackendServices.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/backendServices',
        request_field='',
        request_type_name='ComputeRegionBackendServicesListRequest',
        response_type_name='BackendServiceList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified regional BackendService resource with the data included in the request. For more information, see Understanding backend services This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionBackendServicesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionBackendServices.patch',
        ordered_params=['project', 'region', 'backendService'],
        path_params=['backendService', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/backendServices/{backendService}',
        request_field='backendServiceResource',
        request_type_name='ComputeRegionBackendServicesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeRegionBackendServicesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionBackendServices.setIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/backendServices/{resource}/setIamPolicy',
        request_field='regionSetPolicyRequest',
        request_type_name='ComputeRegionBackendServicesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionBackendServicesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionBackendServices.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/backendServices/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionBackendServicesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified regional BackendService resource with the data included in the request. For more information, see Backend services overview .

      Args:
        request: (ComputeRegionBackendServicesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.regionBackendServices.update',
        ordered_params=['project', 'region', 'backendService'],
        path_params=['backendService', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/backendServices/{backendService}',
        request_field='backendServiceResource',
        request_type_name='ComputeRegionBackendServicesUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionCommitmentsService(base_api.BaseApiService):
    """Service class for the regionCommitments resource."""

    _NAME = 'regionCommitments'

    def __init__(self, client):
      super(ComputeBeta.RegionCommitmentsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of commitments by region.

      Args:
        request: (ComputeRegionCommitmentsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CommitmentAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionCommitments.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/commitments',
        request_field='',
        request_type_name='ComputeRegionCommitmentsAggregatedListRequest',
        response_type_name='CommitmentAggregatedList',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified commitment resource. Gets a list of available commitments by making a list() request.

      Args:
        request: (ComputeRegionCommitmentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Commitment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionCommitments.get',
        ordered_params=['project', 'region', 'commitment'],
        path_params=['commitment', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/commitments/{commitment}',
        request_field='',
        request_type_name='ComputeRegionCommitmentsGetRequest',
        response_type_name='Commitment',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a commitment in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionCommitmentsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionCommitments.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/commitments',
        request_field='commitment',
        request_type_name='ComputeRegionCommitmentsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of commitments contained within the specified region.

      Args:
        request: (ComputeRegionCommitmentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CommitmentList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionCommitments.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/commitments',
        request_field='',
        request_type_name='ComputeRegionCommitmentsListRequest',
        response_type_name='CommitmentList',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionCommitmentsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionCommitments.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/commitments/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionCommitmentsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified commitment with the data included in the request. Update is performed only on selected fields included as part of update-mask. Only the following fields can be modified: auto_renew.

      Args:
        request: (ComputeRegionCommitmentsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionCommitments.update',
        ordered_params=['project', 'region', 'commitment'],
        path_params=['commitment', 'project', 'region'],
        query_params=['paths', 'requestId', 'updateMask'],
        relative_path='projects/{project}/regions/{region}/commitments/{commitment}',
        request_field='commitmentResource',
        request_type_name='ComputeRegionCommitmentsUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdateReservations(self, request, global_params=None):
      r"""Transfers GPUs or local SSDs between reservations within commitments.

      Args:
        request: (ComputeRegionCommitmentsUpdateReservationsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateReservations')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateReservations.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionCommitments.updateReservations',
        ordered_params=['project', 'region', 'commitment'],
        path_params=['commitment', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/commitments/{commitment}/updateReservations',
        request_field='regionCommitmentsUpdateReservationsRequest',
        request_type_name='ComputeRegionCommitmentsUpdateReservationsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionDiskTypesService(base_api.BaseApiService):
    """Service class for the regionDiskTypes resource."""

    _NAME = 'regionDiskTypes'

    def __init__(self, client):
      super(ComputeBeta.RegionDiskTypesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the specified regional disk type. Gets a list of available disk types by making a list() request.

      Args:
        request: (ComputeRegionDiskTypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionDiskTypes.get',
        ordered_params=['project', 'region', 'diskType'],
        path_params=['diskType', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/diskTypes/{diskType}',
        request_field='',
        request_type_name='ComputeRegionDiskTypesGetRequest',
        response_type_name='DiskType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of regional disk types available to the specified project.

      Args:
        request: (ComputeRegionDiskTypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionDiskTypeList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionDiskTypes.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/diskTypes',
        request_field='',
        request_type_name='ComputeRegionDiskTypesListRequest',
        response_type_name='RegionDiskTypeList',
        supports_download=False,
    )

  class RegionDisksService(base_api.BaseApiService):
    """Service class for the regionDisks resource."""

    _NAME = 'regionDisks'

    def __init__(self, client):
      super(ComputeBeta.RegionDisksService, self).__init__(client)
      self._upload_configs = {
          }

    def AddResourcePolicies(self, request, global_params=None):
      r"""Adds existing resource policies to a regional disk. You can only add one policy which will be applied to this disk for scheduling snapshot creation.

      Args:
        request: (ComputeRegionDisksAddResourcePoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddResourcePolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddResourcePolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.addResourcePolicies',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/disks/{disk}/addResourcePolicies',
        request_field='regionDisksAddResourcePoliciesRequest',
        request_type_name='ComputeRegionDisksAddResourcePoliciesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def CreateSnapshot(self, request, global_params=None):
      r"""Creates a snapshot of a specified persistent disk. For regular snapshot creation, consider using snapshots.insert instead, as that method supports more features, such as creating snapshots in a project different from the source disk project.

      Args:
        request: (ComputeRegionDisksCreateSnapshotRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CreateSnapshot')
      return self._RunMethod(
          config, request, global_params=global_params)

    CreateSnapshot.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.createSnapshot',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/disks/{disk}/createSnapshot',
        request_field='snapshot',
        request_type_name='ComputeRegionDisksCreateSnapshotRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified regional persistent disk. Deleting a regional disk removes all the replicas of its data permanently and is irreversible. However, deleting a disk does not delete any snapshots previously made from the disk. You must separately delete snapshots.

      Args:
        request: (ComputeRegionDisksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionDisks.delete',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/disks/{disk}',
        request_field='',
        request_type_name='ComputeRegionDisksDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns a specified regional persistent disk.

      Args:
        request: (ComputeRegionDisksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Disk) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionDisks.get',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/disks/{disk}',
        request_field='',
        request_type_name='ComputeRegionDisksGetRequest',
        response_type_name='Disk',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeRegionDisksGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionDisks.getIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/regions/{region}/disks/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeRegionDisksGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a persistent regional disk in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionDisksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId', 'sourceImage'],
        relative_path='projects/{project}/regions/{region}/disks',
        request_field='disk',
        request_type_name='ComputeRegionDisksInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of persistent disks contained within the specified region.

      Args:
        request: (ComputeRegionDisksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiskList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionDisks.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/disks',
        request_field='',
        request_type_name='ComputeRegionDisksListRequest',
        response_type_name='DiskList',
        supports_download=False,
    )

    def RemoveResourcePolicies(self, request, global_params=None):
      r"""Removes resource policies from a regional disk.

      Args:
        request: (ComputeRegionDisksRemoveResourcePoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveResourcePolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveResourcePolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.removeResourcePolicies',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/disks/{disk}/removeResourcePolicies',
        request_field='regionDisksRemoveResourcePoliciesRequest',
        request_type_name='ComputeRegionDisksRemoveResourcePoliciesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Resize(self, request, global_params=None):
      r"""Resizes the specified regional persistent disk.

      Args:
        request: (ComputeRegionDisksResizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Resize')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resize.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.resize',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/disks/{disk}/resize',
        request_field='regionDisksResizeRequest',
        request_type_name='ComputeRegionDisksResizeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeRegionDisksSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.setIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/disks/{resource}/setIamPolicy',
        request_field='regionSetPolicyRequest',
        request_type_name='ComputeRegionDisksSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on the target regional disk.

      Args:
        request: (ComputeRegionDisksSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.setLabels',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/disks/{resource}/setLabels',
        request_field='regionSetLabelsRequest',
        request_type_name='ComputeRegionDisksSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionDisksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionDisks.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/disks/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionDisksTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Update the specified disk with the data included in the request. Update is performed only on selected fields included as part of update-mask. Only the following fields can be modified: user_license.

      Args:
        request: (ComputeRegionDisksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionDisks.update',
        ordered_params=['project', 'region', 'disk'],
        path_params=['disk', 'project', 'region'],
        query_params=['paths', 'requestId', 'updateMask'],
        relative_path='projects/{project}/regions/{region}/disks/{disk}',
        request_field='diskResource',
        request_type_name='ComputeRegionDisksUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionHealthCheckServicesService(base_api.BaseApiService):
    """Service class for the regionHealthCheckServices resource."""

    _NAME = 'regionHealthCheckServices'

    def __init__(self, client):
      super(ComputeBeta.RegionHealthCheckServicesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified regional HealthCheckService.

      Args:
        request: (ComputeRegionHealthCheckServicesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionHealthCheckServices.delete',
        ordered_params=['project', 'region', 'healthCheckService'],
        path_params=['healthCheckService', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthCheckServices/{healthCheckService}',
        request_field='',
        request_type_name='ComputeRegionHealthCheckServicesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified regional HealthCheckService resource.

      Args:
        request: (ComputeRegionHealthCheckServicesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthCheckService) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionHealthCheckServices.get',
        ordered_params=['project', 'region', 'healthCheckService'],
        path_params=['healthCheckService', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/healthCheckServices/{healthCheckService}',
        request_field='',
        request_type_name='ComputeRegionHealthCheckServicesGetRequest',
        response_type_name='HealthCheckService',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a regional HealthCheckService resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeRegionHealthCheckServicesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionHealthCheckServices.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthCheckServices',
        request_field='healthCheckService',
        request_type_name='ComputeRegionHealthCheckServicesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the HealthCheckService resources that have been configured for the specified project in the given region.

      Args:
        request: (ComputeRegionHealthCheckServicesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthCheckServicesList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionHealthCheckServices.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/healthCheckServices',
        request_field='',
        request_type_name='ComputeRegionHealthCheckServicesListRequest',
        response_type_name='HealthCheckServicesList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the specified regional HealthCheckService resource with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionHealthCheckServicesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionHealthCheckServices.patch',
        ordered_params=['project', 'region', 'healthCheckService'],
        path_params=['healthCheckService', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthCheckServices/{healthCheckService}',
        request_field='healthCheckServiceResource',
        request_type_name='ComputeRegionHealthCheckServicesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionHealthCheckServicesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionHealthCheckServices.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/healthCheckServices/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionHealthCheckServicesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionHealthChecksService(base_api.BaseApiService):
    """Service class for the regionHealthChecks resource."""

    _NAME = 'regionHealthChecks'

    def __init__(self, client):
      super(ComputeBeta.RegionHealthChecksService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified HealthCheck resource.

      Args:
        request: (ComputeRegionHealthChecksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionHealthChecks.delete',
        ordered_params=['project', 'region', 'healthCheck'],
        path_params=['healthCheck', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthChecks/{healthCheck}',
        request_field='',
        request_type_name='ComputeRegionHealthChecksDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified HealthCheck resource. Gets a list of available health checks by making a list() request.

      Args:
        request: (ComputeRegionHealthChecksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthCheck) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionHealthChecks.get',
        ordered_params=['project', 'region', 'healthCheck'],
        path_params=['healthCheck', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/healthChecks/{healthCheck}',
        request_field='',
        request_type_name='ComputeRegionHealthChecksGetRequest',
        response_type_name='HealthCheck',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a HealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionHealthChecksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionHealthChecks.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthChecks',
        request_field='healthCheck',
        request_type_name='ComputeRegionHealthChecksInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of HealthCheck resources available to the specified project.

      Args:
        request: (ComputeRegionHealthChecksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HealthCheckList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionHealthChecks.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/healthChecks',
        request_field='',
        request_type_name='ComputeRegionHealthChecksListRequest',
        response_type_name='HealthCheckList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a HealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionHealthChecksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionHealthChecks.patch',
        ordered_params=['project', 'region', 'healthCheck'],
        path_params=['healthCheck', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthChecks/{healthCheck}',
        request_field='healthCheckResource',
        request_type_name='ComputeRegionHealthChecksPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionHealthChecksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionHealthChecks.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/healthChecks/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionHealthChecksTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a HealthCheck resource in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionHealthChecksUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.regionHealthChecks.update',
        ordered_params=['project', 'region', 'healthCheck'],
        path_params=['healthCheck', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/healthChecks/{healthCheck}',
        request_field='healthCheckResource',
        request_type_name='ComputeRegionHealthChecksUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionInstanceGroupManagersService(base_api.BaseApiService):
    """Service class for the regionInstanceGroupManagers resource."""

    _NAME = 'regionInstanceGroupManagers'

    def __init__(self, client):
      super(ComputeBeta.RegionInstanceGroupManagersService, self).__init__(client)
      self._upload_configs = {
          }

    def AbandonInstances(self, request, global_params=None):
      r"""Flags the specified instances to be immediately removed from the managed instance group. Abandoning an instance does not delete the instance, but it does remove the instance from any target pools that are applied by the managed instance group. This method reduces the targetSize of the managed instance group by the number of instances that you abandon. This operation is marked as DONE when the action is scheduled even if the instances have not yet been removed from the group. You must separately verify the status of the abandoning action with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeRegionInstanceGroupManagersAbandonInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AbandonInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    AbandonInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.abandonInstances',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/abandonInstances',
        request_field='regionInstanceGroupManagersAbandonInstancesRequest',
        request_type_name='ComputeRegionInstanceGroupManagersAbandonInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def ApplyUpdatesToInstances(self, request, global_params=None):
      r"""Apply updates to selected instances the managed instance group.

      Args:
        request: (ComputeRegionInstanceGroupManagersApplyUpdatesToInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ApplyUpdatesToInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ApplyUpdatesToInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.applyUpdatesToInstances',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/applyUpdatesToInstances',
        request_field='regionInstanceGroupManagersApplyUpdatesRequest',
        request_type_name='ComputeRegionInstanceGroupManagersApplyUpdatesToInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def CreateInstances(self, request, global_params=None):
      r"""Creates instances with per-instance configurations in this regional managed instance group. Instances are created using the current instance template. The create instances operation is marked DONE if the createInstances request is successful. The underlying actions take additional time. You must separately verify the status of the creating or actions with the listmanagedinstances method.

      Args:
        request: (ComputeRegionInstanceGroupManagersCreateInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CreateInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    CreateInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.createInstances',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/createInstances',
        request_field='regionInstanceGroupManagersCreateInstancesRequest',
        request_type_name='ComputeRegionInstanceGroupManagersCreateInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified managed instance group and all of the instances in that group.

      Args:
        request: (ComputeRegionInstanceGroupManagersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionInstanceGroupManagers.delete',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupManagersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DeleteInstances(self, request, global_params=None):
      r"""Flags the specified instances in the managed instance group to be immediately deleted. The instances are also removed from any target pools of which they were a member. This method reduces the targetSize of the managed instance group by the number of instances that you delete. The deleteInstances operation is marked DONE if the deleteInstances request is successful. The underlying actions take additional time. You must separately verify the status of the deleting action with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeRegionInstanceGroupManagersDeleteInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeleteInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.deleteInstances',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/deleteInstances',
        request_field='regionInstanceGroupManagersDeleteInstancesRequest',
        request_type_name='ComputeRegionInstanceGroupManagersDeleteInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def DeletePerInstanceConfigs(self, request, global_params=None):
      r"""Deletes selected per-instance configurations for the managed instance group.

      Args:
        request: (ComputeRegionInstanceGroupManagersDeletePerInstanceConfigsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('DeletePerInstanceConfigs')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeletePerInstanceConfigs.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.deletePerInstanceConfigs',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/deletePerInstanceConfigs',
        request_field='regionInstanceGroupManagerDeleteInstanceConfigReq',
        request_type_name='ComputeRegionInstanceGroupManagersDeletePerInstanceConfigsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns all of the details about the specified managed instance group.

      Args:
        request: (ComputeRegionInstanceGroupManagersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroupManager) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstanceGroupManagers.get',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupManagersGetRequest',
        response_type_name='InstanceGroupManager',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a managed instance group using the information that you specify in the request. After the group is created, instances in the group are created using the specified instance template. This operation is marked as DONE when the group is created even if the instances in the group have not yet been created. You must separately verify the status of the individual instances with the listmanagedinstances method. A regional managed instance group can contain up to 2000 instances.

      Args:
        request: (ComputeRegionInstanceGroupManagersInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers',
        request_field='instanceGroupManager',
        request_type_name='ComputeRegionInstanceGroupManagersInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of managed instance groups that are contained within the specified region.

      Args:
        request: (ComputeRegionInstanceGroupManagersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionInstanceGroupManagerList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstanceGroupManagers.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupManagersListRequest',
        response_type_name='RegionInstanceGroupManagerList',
        supports_download=False,
    )

    def ListErrors(self, request, global_params=None):
      r"""Lists all errors thrown by actions on instances for a given regional managed instance group. The filter and orderBy query parameters are not supported.

      Args:
        request: (ComputeRegionInstanceGroupManagersListErrorsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionInstanceGroupManagersListErrorsResponse) The response message.
      """
      config = self.GetMethodConfig('ListErrors')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListErrors.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstanceGroupManagers.listErrors',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/listErrors',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupManagersListErrorsRequest',
        response_type_name='RegionInstanceGroupManagersListErrorsResponse',
        supports_download=False,
    )

    def ListManagedInstances(self, request, global_params=None):
      r"""Lists the instances in the managed instance group and instances that are scheduled to be created. The list includes any current actions that the group has scheduled for its instances. The orderBy query parameter is not supported. The `pageToken` query parameter is supported only in the alpha and beta API and only if the group's `listManagedInstancesResults` field is set to `PAGINATED`.

      Args:
        request: (ComputeRegionInstanceGroupManagersListManagedInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionInstanceGroupManagersListInstancesResponse) The response message.
      """
      config = self.GetMethodConfig('ListManagedInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListManagedInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.listManagedInstances',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/listManagedInstances',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupManagersListManagedInstancesRequest',
        response_type_name='RegionInstanceGroupManagersListInstancesResponse',
        supports_download=False,
    )

    def ListPerInstanceConfigs(self, request, global_params=None):
      r"""Lists all of the per-instance configurations defined for the managed instance group. The orderBy query parameter is not supported.

      Args:
        request: (ComputeRegionInstanceGroupManagersListPerInstanceConfigsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionInstanceGroupManagersListInstanceConfigsResp) The response message.
      """
      config = self.GetMethodConfig('ListPerInstanceConfigs')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListPerInstanceConfigs.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.listPerInstanceConfigs',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/listPerInstanceConfigs',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupManagersListPerInstanceConfigsRequest',
        response_type_name='RegionInstanceGroupManagersListInstanceConfigsResp',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is patched even if the instances in the group are still in the process of being patched. You must separately verify the status of the individual instances with the listmanagedinstances method. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. If you update your group to specify a new template or instance configuration, it's possible that your intended specification for each VM in the group is different from the current state of that VM. To learn how to apply an updated configuration to the VMs in a MIG, see Updating instances in a MIG.

      Args:
        request: (ComputeRegionInstanceGroupManagersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionInstanceGroupManagers.patch',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}',
        request_field='instanceGroupManagerResource',
        request_type_name='ComputeRegionInstanceGroupManagersPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchPerInstanceConfigs(self, request, global_params=None):
      r"""Inserts or patches per-instance configurations for the managed instance group. perInstanceConfig.name serves as a key used to distinguish whether to perform insert or patch.

      Args:
        request: (ComputeRegionInstanceGroupManagersPatchPerInstanceConfigsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchPerInstanceConfigs')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchPerInstanceConfigs.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.patchPerInstanceConfigs',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/patchPerInstanceConfigs',
        request_field='regionInstanceGroupManagerPatchInstanceConfigReq',
        request_type_name='ComputeRegionInstanceGroupManagersPatchPerInstanceConfigsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RecreateInstances(self, request, global_params=None):
      r"""Flags the specified VM instances in the managed instance group to be immediately recreated. Each instance is recreated using the group's current configuration. This operation is marked as DONE when the flag is set even if the instances have not yet been recreated. You must separately verify the status of each instance by checking its currentAction field; for more information, see Checking the status of managed instances. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.

      Args:
        request: (ComputeRegionInstanceGroupManagersRecreateInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RecreateInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    RecreateInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.recreateInstances',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/recreateInstances',
        request_field='regionInstanceGroupManagersRecreateRequest',
        request_type_name='ComputeRegionInstanceGroupManagersRecreateInstancesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Resize(self, request, global_params=None):
      r"""Changes the intended size of the managed instance group. If you increase the size, the group creates new instances using the current instance template. If you decrease the size, the group deletes one or more instances. The resize operation is marked DONE if the resize request is successful. The underlying actions take additional time. You must separately verify the status of the creating or deleting actions with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.

      Args:
        request: (ComputeRegionInstanceGroupManagersResizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Resize')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resize.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.resize',
        ordered_params=['project', 'region', 'instanceGroupManager', 'size'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId', 'size'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resize',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupManagersResizeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def ResizeAdvanced(self, request, global_params=None):
      r"""Resizes the regional managed instance group with advanced configuration options like disabling creation retries. This is an extended version of the resize method. If you increase the size, the group creates new instances using the current instance template. If you decrease the size, the group deletes one or more instances. The resize operation is marked DONE if the resize request is successful. The underlying actions take additional time. You must separately verify the status of the creating or deleting actions with the get or listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.

      Args:
        request: (ComputeRegionInstanceGroupManagersResizeAdvancedRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ResizeAdvanced')
      return self._RunMethod(
          config, request, global_params=global_params)

    ResizeAdvanced.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.resizeAdvanced',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resizeAdvanced',
        request_field='regionInstanceGroupManagersResizeAdvancedRequest',
        request_type_name='ComputeRegionInstanceGroupManagersResizeAdvancedRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetAutoHealingPolicies(self, request, global_params=None):
      r"""Modifies the autohealing policy for the instances in this managed instance group. [Deprecated] This method is deprecated. Use regionInstanceGroupManagers.patch instead.

      Args:
        request: (ComputeRegionInstanceGroupManagersSetAutoHealingPoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetAutoHealingPolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetAutoHealingPolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.setAutoHealingPolicies',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/setAutoHealingPolicies',
        request_field='regionInstanceGroupManagersSetAutoHealingRequest',
        request_type_name='ComputeRegionInstanceGroupManagersSetAutoHealingPoliciesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetInstanceTemplate(self, request, global_params=None):
      r"""Sets the instance template to use when creating new instances or recreating instances in this group. Existing instances are not affected.

      Args:
        request: (ComputeRegionInstanceGroupManagersSetInstanceTemplateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetInstanceTemplate')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetInstanceTemplate.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.setInstanceTemplate',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/setInstanceTemplate',
        request_field='regionInstanceGroupManagersSetTemplateRequest',
        request_type_name='ComputeRegionInstanceGroupManagersSetInstanceTemplateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetTargetPools(self, request, global_params=None):
      r"""Modifies the target pools to which all new instances in this group are assigned. Existing instances in the group are not affected.

      Args:
        request: (ComputeRegionInstanceGroupManagersSetTargetPoolsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetTargetPools')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetTargetPools.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.setTargetPools',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/setTargetPools',
        request_field='regionInstanceGroupManagersSetTargetPoolsRequest',
        request_type_name='ComputeRegionInstanceGroupManagersSetTargetPoolsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionInstanceGroupManagersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionInstanceGroupManagersTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is updated even if the instances in the group have not yet been updated. You must separately verify the status of the individual instances with the listmanagedinstances method. If you update your group to specify a new template or instance configuration, it's possible that your intended specification for each VM in the group is different from the current state of that VM. To learn how to apply an updated configuration to the VMs in a MIG, see Updating instances in a MIG.

      Args:
        request: (ComputeRegionInstanceGroupManagersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.regionInstanceGroupManagers.update',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}',
        request_field='instanceGroupManagerResource',
        request_type_name='ComputeRegionInstanceGroupManagersUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def UpdatePerInstanceConfigs(self, request, global_params=None):
      r"""Inserts or updates per-instance configurations for the managed instance group. perInstanceConfig.name serves as a key used to distinguish whether to perform insert or patch.

      Args:
        request: (ComputeRegionInstanceGroupManagersUpdatePerInstanceConfigsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdatePerInstanceConfigs')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdatePerInstanceConfigs.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroupManagers.updatePerInstanceConfigs',
        ordered_params=['project', 'region', 'instanceGroupManager'],
        path_params=['instanceGroupManager', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/updatePerInstanceConfigs',
        request_field='regionInstanceGroupManagerUpdateInstanceConfigReq',
        request_type_name='ComputeRegionInstanceGroupManagersUpdatePerInstanceConfigsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionInstanceGroupsService(base_api.BaseApiService):
    """Service class for the regionInstanceGroups resource."""

    _NAME = 'regionInstanceGroups'

    def __init__(self, client):
      super(ComputeBeta.RegionInstanceGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the specified instance group resource.

      Args:
        request: (ComputeRegionInstanceGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InstanceGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstanceGroups.get',
        ordered_params=['project', 'region', 'instanceGroup'],
        path_params=['instanceGroup', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instanceGroups/{instanceGroup}',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupsGetRequest',
        response_type_name='InstanceGroup',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of instance group resources contained within the specified region.

      Args:
        request: (ComputeRegionInstanceGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionInstanceGroupList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionInstanceGroups.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/instanceGroups',
        request_field='',
        request_type_name='ComputeRegionInstanceGroupsListRequest',
        response_type_name='RegionInstanceGroupList',
        supports_download=False,
    )

    def ListInstances(self, request, global_params=None):
      r"""Lists the instances in the specified instance group and displays information about the named ports. Depending on the specified options, this method can list all instances or only the instances that are running. The orderBy query parameter is not supported.

      Args:
        request: (ComputeRegionInstanceGroupsListInstancesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionInstanceGroupsListInstances) The response message.
      """
      config = self.GetMethodConfig('ListInstances')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListInstances.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroups.listInstances',
        ordered_params=['project', 'region', 'instanceGroup'],
        path_params=['instanceGroup', 'project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/instanceGroups/{instanceGroup}/listInstances',
        request_field='regionInstanceGroupsListInstancesRequest',
        request_type_name='ComputeRegionInstanceGroupsListInstancesRequest',
        response_type_name='RegionInstanceGroupsListInstances',
        supports_download=False,
    )

    def SetNamedPorts(self, request, global_params=None):
      r"""Sets the named ports for the specified regional instance group.

      Args:
        request: (ComputeRegionInstanceGroupsSetNamedPortsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetNamedPorts')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetNamedPorts.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroups.setNamedPorts',
        ordered_params=['project', 'region', 'instanceGroup'],
        path_params=['instanceGroup', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instanceGroups/{instanceGroup}/setNamedPorts',
        request_field='regionInstanceGroupsSetNamedPortsRequest',
        request_type_name='ComputeRegionInstanceGroupsSetNamedPortsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionInstanceGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstanceGroups.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/instanceGroups/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionInstanceGroupsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionInstancesService(base_api.BaseApiService):
    """Service class for the regionInstances resource."""

    _NAME = 'regionInstances'

    def __init__(self, client):
      super(ComputeBeta.RegionInstancesService, self).__init__(client)
      self._upload_configs = {
          }

    def BulkInsert(self, request, global_params=None):
      r"""Creates multiple instances in a given region. Count specifies the number of instances to create.

      Args:
        request: (ComputeRegionInstancesBulkInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('BulkInsert')
      return self._RunMethod(
          config, request, global_params=global_params)

    BulkInsert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionInstances.bulkInsert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/instances/bulkInsert',
        request_field='bulkInsertInstanceResource',
        request_type_name='ComputeRegionInstancesBulkInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionNetworkEndpointGroupsService(base_api.BaseApiService):
    """Service class for the regionNetworkEndpointGroups resource."""

    _NAME = 'regionNetworkEndpointGroups'

    def __init__(self, client):
      super(ComputeBeta.RegionNetworkEndpointGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified network endpoint group. Note that the NEG cannot be deleted if it is configured as a backend of a backend service.

      Args:
        request: (ComputeRegionNetworkEndpointGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionNetworkEndpointGroups.delete',
        ordered_params=['project', 'region', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/networkEndpointGroups/{networkEndpointGroup}',
        request_field='',
        request_type_name='ComputeRegionNetworkEndpointGroupsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified network endpoint group. Gets a list of available network endpoint groups by making a list() request.

      Args:
        request: (ComputeRegionNetworkEndpointGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkEndpointGroups.get',
        ordered_params=['project', 'region', 'networkEndpointGroup'],
        path_params=['networkEndpointGroup', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/networkEndpointGroups/{networkEndpointGroup}',
        request_field='',
        request_type_name='ComputeRegionNetworkEndpointGroupsGetRequest',
        response_type_name='NetworkEndpointGroup',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a network endpoint group in the specified project using the parameters that are included in the request.

      Args:
        request: (ComputeRegionNetworkEndpointGroupsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkEndpointGroups.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/networkEndpointGroups',
        request_field='networkEndpointGroup',
        request_type_name='ComputeRegionNetworkEndpointGroupsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of regional network endpoint groups available to the specified project in the given region.

      Args:
        request: (ComputeRegionNetworkEndpointGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NetworkEndpointGroupList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkEndpointGroups.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/networkEndpointGroups',
        request_field='',
        request_type_name='ComputeRegionNetworkEndpointGroupsListRequest',
        response_type_name='NetworkEndpointGroupList',
        supports_download=False,
    )

  class RegionNetworkFirewallPoliciesService(base_api.BaseApiService):
    """Service class for the regionNetworkFirewallPolicies resource."""

    _NAME = 'regionNetworkFirewallPolicies'

    def __init__(self, client):
      super(ComputeBeta.RegionNetworkFirewallPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddAssociation(self, request, global_params=None):
      r"""Inserts an association for the specified network firewall policy.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesAddAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.addAssociation',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['replaceExistingAssociation', 'requestId'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/addAssociation',
        request_field='firewallPolicyAssociation',
        request_type_name='ComputeRegionNetworkFirewallPoliciesAddAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AddRule(self, request, global_params=None):
      r"""Inserts a rule into a network firewall policy.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesAddRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.addRule',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['maxPriority', 'minPriority', 'requestId'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/addRule',
        request_field='firewallPolicyRule',
        request_type_name='ComputeRegionNetworkFirewallPoliciesAddRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def CloneRules(self, request, global_params=None):
      r"""Copies rules to the specified network firewall policy.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesCloneRulesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('CloneRules')
      return self._RunMethod(
          config, request, global_params=global_params)

    CloneRules.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.cloneRules',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['requestId', 'sourceFirewallPolicy'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/cloneRules',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesCloneRulesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified network firewall policy.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionNetworkFirewallPolicies.delete',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified network firewall policy.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkFirewallPolicies.get',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesGetRequest',
        response_type_name='FirewallPolicy',
        supports_download=False,
    )

    def GetAssociation(self, request, global_params=None):
      r"""Gets an association with the specified name.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesGetAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyAssociation) The response message.
      """
      config = self.GetMethodConfig('GetAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkFirewallPolicies.getAssociation',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['name'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/getAssociation',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesGetAssociationRequest',
        response_type_name='FirewallPolicyAssociation',
        supports_download=False,
    )

    def GetEffectiveFirewalls(self, request, global_params=None):
      r"""Returns the effective firewalls on a given network.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesGetEffectiveFirewallsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse) The response message.
      """
      config = self.GetMethodConfig('GetEffectiveFirewalls')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetEffectiveFirewalls.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkFirewallPolicies.getEffectiveFirewalls',
        ordered_params=['project', 'region', 'network'],
        path_params=['project', 'region'],
        query_params=['network'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/getEffectiveFirewalls',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesGetEffectiveFirewallsRequest',
        response_type_name='RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkFirewallPolicies.getIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def GetRule(self, request, global_params=None):
      r"""Gets a rule of the specified priority.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesGetRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyRule) The response message.
      """
      config = self.GetMethodConfig('GetRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkFirewallPolicies.getRule',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['priority'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/getRule',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesGetRuleRequest',
        response_type_name='FirewallPolicyRule',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new network firewall policy in the specified project and region.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies',
        request_field='firewallPolicy',
        request_type_name='ComputeRegionNetworkFirewallPoliciesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the network firewall policies that have been configured for the specified project in the given region.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FirewallPolicyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNetworkFirewallPolicies.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesListRequest',
        response_type_name='FirewallPolicyList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified network firewall policy.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionNetworkFirewallPolicies.patch',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}',
        request_field='firewallPolicyResource',
        request_type_name='ComputeRegionNetworkFirewallPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchRule(self, request, global_params=None):
      r"""Patches a rule of the specified priority.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesPatchRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.patchRule',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['priority', 'requestId'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/patchRule',
        request_field='firewallPolicyRule',
        request_type_name='ComputeRegionNetworkFirewallPoliciesPatchRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveAssociation(self, request, global_params=None):
      r"""Removes an association for the specified network firewall policy.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesRemoveAssociationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveAssociation')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveAssociation.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.removeAssociation',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['name', 'requestId'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/removeAssociation',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesRemoveAssociationRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveRule(self, request, global_params=None):
      r"""Deletes a rule of the specified priority.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesRemoveRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.removeRule',
        ordered_params=['project', 'region', 'firewallPolicy'],
        path_params=['firewallPolicy', 'project', 'region'],
        query_params=['priority', 'requestId'],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/removeRule',
        request_field='',
        request_type_name='ComputeRegionNetworkFirewallPoliciesRemoveRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.setIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{resource}/setIamPolicy',
        request_field='regionSetPolicyRequest',
        request_type_name='ComputeRegionNetworkFirewallPoliciesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionNetworkFirewallPoliciesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNetworkFirewallPolicies.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/firewallPolicies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionNetworkFirewallPoliciesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionNotificationEndpointsService(base_api.BaseApiService):
    """Service class for the regionNotificationEndpoints resource."""

    _NAME = 'regionNotificationEndpoints'

    def __init__(self, client):
      super(ComputeBeta.RegionNotificationEndpointsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified NotificationEndpoint in the given region.

      Args:
        request: (ComputeRegionNotificationEndpointsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionNotificationEndpoints.delete',
        ordered_params=['project', 'region', 'notificationEndpoint'],
        path_params=['notificationEndpoint', 'project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/notificationEndpoints/{notificationEndpoint}',
        request_field='',
        request_type_name='ComputeRegionNotificationEndpointsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified NotificationEndpoint resource in the given region.

      Args:
        request: (ComputeRegionNotificationEndpointsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NotificationEndpoint) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNotificationEndpoints.get',
        ordered_params=['project', 'region', 'notificationEndpoint'],
        path_params=['notificationEndpoint', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/notificationEndpoints/{notificationEndpoint}',
        request_field='',
        request_type_name='ComputeRegionNotificationEndpointsGetRequest',
        response_type_name='NotificationEndpoint',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Create a NotificationEndpoint in the specified project in the given region using the parameters that are included in the request.

      Args:
        request: (ComputeRegionNotificationEndpointsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNotificationEndpoints.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/notificationEndpoints',
        request_field='notificationEndpoint',
        request_type_name='ComputeRegionNotificationEndpointsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the NotificationEndpoints for a project in the given region.

      Args:
        request: (ComputeRegionNotificationEndpointsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (NotificationEndpointList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionNotificationEndpoints.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/notificationEndpoints',
        request_field='',
        request_type_name='ComputeRegionNotificationEndpointsListRequest',
        response_type_name='NotificationEndpointList',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionNotificationEndpointsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionNotificationEndpoints.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/notificationEndpoints/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionNotificationEndpointsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionOperationsService(base_api.BaseApiService):
    """Service class for the regionOperations resource."""

    _NAME = 'regionOperations'

    def __init__(self, client):
      super(ComputeBeta.RegionOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified region-specific Operations resource.

      Args:
        request: (ComputeRegionOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ComputeRegionOperationsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionOperations.delete',
        ordered_params=['project', 'region', 'operation'],
        path_params=['operation', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/operations/{operation}',
        request_field='',
        request_type_name='ComputeRegionOperationsDeleteRequest',
        response_type_name='ComputeRegionOperationsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the specified region-specific Operations resource.

      Args:
        request: (ComputeRegionOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionOperations.get',
        ordered_params=['project', 'region', 'operation'],
        path_params=['operation', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/operations/{operation}',
        request_field='',
        request_type_name='ComputeRegionOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of Operation resources contained within the specified region.

      Args:
        request: (ComputeRegionOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OperationList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionOperations.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/operations',
        request_field='',
        request_type_name='ComputeRegionOperationsListRequest',
        response_type_name='OperationList',
        supports_download=False,
    )

    def Wait(self, request, global_params=None):
      r"""Waits for the specified Operation resource to return as `DONE` or for the request to approach the 2 minute deadline, and retrieves the specified Operation resource. This method differs from the `GET` method in that it waits for no more than the default deadline (2 minutes) and then returns the current state of the operation, which might be `DONE` or still in progress. This method is called on a best-effort basis. Specifically: - In uncommon cases, when the server is overloaded, the request might return before the default deadline is reached, or might return after zero seconds. - If the default deadline is reached, there is no guarantee that the operation is actually done when the method returns. Be prepared to retry if the operation is not `DONE`. .

      Args:
        request: (ComputeRegionOperationsWaitRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Wait')
      return self._RunMethod(
          config, request, global_params=global_params)

    Wait.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionOperations.wait',
        ordered_params=['project', 'region', 'operation'],
        path_params=['operation', 'project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/operations/{operation}/wait',
        request_field='',
        request_type_name='ComputeRegionOperationsWaitRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionSecurityPoliciesService(base_api.BaseApiService):
    """Service class for the regionSecurityPolicies resource."""

    _NAME = 'regionSecurityPolicies'

    def __init__(self, client):
      super(ComputeBeta.RegionSecurityPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified policy.

      Args:
        request: (ComputeRegionSecurityPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionSecurityPolicies.delete',
        ordered_params=['project', 'region', 'securityPolicy'],
        path_params=['project', 'region', 'securityPolicy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/securityPolicies/{securityPolicy}',
        request_field='',
        request_type_name='ComputeRegionSecurityPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""List all of the ordered rules present in a single specified policy.

      Args:
        request: (ComputeRegionSecurityPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSecurityPolicies.get',
        ordered_params=['project', 'region', 'securityPolicy'],
        path_params=['project', 'region', 'securityPolicy'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/securityPolicies/{securityPolicy}',
        request_field='',
        request_type_name='ComputeRegionSecurityPoliciesGetRequest',
        response_type_name='SecurityPolicy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new policy in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionSecurityPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSecurityPolicies.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId', 'validateOnly'],
        relative_path='projects/{project}/regions/{region}/securityPolicies',
        request_field='securityPolicy',
        request_type_name='ComputeRegionSecurityPoliciesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List all the policies that have been configured for the specified project and region.

      Args:
        request: (ComputeRegionSecurityPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSecurityPolicies.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/securityPolicies',
        request_field='',
        request_type_name='ComputeRegionSecurityPoliciesListRequest',
        response_type_name='SecurityPolicyList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified policy with the data included in the request.

      Args:
        request: (ComputeRegionSecurityPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionSecurityPolicies.patch',
        ordered_params=['project', 'region', 'securityPolicy'],
        path_params=['project', 'region', 'securityPolicy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/securityPolicies/{securityPolicy}',
        request_field='securityPolicyResource',
        request_type_name='ComputeRegionSecurityPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RegionSslCertificatesService(base_api.BaseApiService):
    """Service class for the regionSslCertificates resource."""

    _NAME = 'regionSslCertificates'

    def __init__(self, client):
      super(ComputeBeta.RegionSslCertificatesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified SslCertificate resource in the region.

      Args:
        request: (ComputeRegionSslCertificatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionSslCertificates.delete',
        ordered_params=['project', 'region', 'sslCertificate'],
        path_params=['project', 'region', 'sslCertificate'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/sslCertificates/{sslCertificate}',
        request_field='',
        request_type_name='ComputeRegionSslCertificatesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified SslCertificate resource in the specified region. Get a list of available SSL certificates by making a list() request.

      Args:
        request: (ComputeRegionSslCertificatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslCertificate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSslCertificates.get',
        ordered_params=['project', 'region', 'sslCertificate'],
        path_params=['project', 'region', 'sslCertificate'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/sslCertificates/{sslCertificate}',
        request_field='',
        request_type_name='ComputeRegionSslCertificatesGetRequest',
        response_type_name='SslCertificate',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a SslCertificate resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeRegionSslCertificatesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSslCertificates.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/sslCertificates',
        request_field='sslCertificate',
        request_type_name='ComputeRegionSslCertificatesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of SslCertificate resources available to the specified project in the specified region.

      Args:
        request: (ComputeRegionSslCertificatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslCertificateList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSslCertificates.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/sslCertificates',
        request_field='',
        request_type_name='ComputeRegionSslCertificatesListRequest',
        response_type_name='SslCertificateList',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource and region.

      Args:
        request: (ComputeRegionSslCertificatesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSslCertificates.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/sslCertificates/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionSslCertificatesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionSslPoliciesService(base_api.BaseApiService):
    """Service class for the regionSslPolicies resource."""

    _NAME = 'regionSslPolicies'

    def __init__(self, client):
      super(ComputeBeta.RegionSslPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified SSL policy. The SSL policy resource can be deleted only if it is not in use by any TargetHttpsProxy or TargetSslProxy resources.

      Args:
        request: (ComputeRegionSslPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionSslPolicies.delete',
        ordered_params=['project', 'region', 'sslPolicy'],
        path_params=['project', 'region', 'sslPolicy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/sslPolicies/{sslPolicy}',
        request_field='',
        request_type_name='ComputeRegionSslPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Lists all of the ordered rules present in a single specified policy.

      Args:
        request: (ComputeRegionSslPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSslPolicies.get',
        ordered_params=['project', 'region', 'sslPolicy'],
        path_params=['project', 'region', 'sslPolicy'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/sslPolicies/{sslPolicy}',
        request_field='',
        request_type_name='ComputeRegionSslPoliciesGetRequest',
        response_type_name='SslPolicy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new policy in the specified project and region using the data included in the request.

      Args:
        request: (ComputeRegionSslPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSslPolicies.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/sslPolicies',
        request_field='sslPolicy',
        request_type_name='ComputeRegionSslPoliciesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the SSL policies that have been configured for the specified project and region.

      Args:
        request: (ComputeRegionSslPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslPoliciesList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSslPolicies.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/sslPolicies',
        request_field='',
        request_type_name='ComputeRegionSslPoliciesListRequest',
        response_type_name='SslPoliciesList',
        supports_download=False,
    )

    def ListAvailableFeatures(self, request, global_params=None):
      r"""Lists all features that can be specified in the SSL policy when using custom profile.

      Args:
        request: (ComputeRegionSslPoliciesListAvailableFeaturesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslPoliciesListAvailableFeaturesResponse) The response message.
      """
      config = self.GetMethodConfig('ListAvailableFeatures')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListAvailableFeatures.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionSslPolicies.listAvailableFeatures',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/sslPolicies/listAvailableFeatures',
        request_field='',
        request_type_name='ComputeRegionSslPoliciesListAvailableFeaturesRequest',
        response_type_name='SslPoliciesListAvailableFeaturesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified SSL policy with the data included in the request.

      Args:
        request: (ComputeRegionSslPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionSslPolicies.patch',
        ordered_params=['project', 'region', 'sslPolicy'],
        path_params=['project', 'region', 'sslPolicy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/sslPolicies/{sslPolicy}',
        request_field='sslPolicyResource',
        request_type_name='ComputeRegionSslPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionSslPoliciesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionSslPolicies.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/sslPolicies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionSslPoliciesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionTargetHttpProxiesService(base_api.BaseApiService):
    """Service class for the regionTargetHttpProxies resource."""

    _NAME = 'regionTargetHttpProxies'

    def __init__(self, client):
      super(ComputeBeta.RegionTargetHttpProxiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetHttpProxy resource.

      Args:
        request: (ComputeRegionTargetHttpProxiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionTargetHttpProxies.delete',
        ordered_params=['project', 'region', 'targetHttpProxy'],
        path_params=['project', 'region', 'targetHttpProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetHttpProxies/{targetHttpProxy}',
        request_field='',
        request_type_name='ComputeRegionTargetHttpProxiesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetHttpProxy resource in the specified region. Gets a list of available target HTTP proxies by making a list() request.

      Args:
        request: (ComputeRegionTargetHttpProxiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpProxy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionTargetHttpProxies.get',
        ordered_params=['project', 'region', 'targetHttpProxy'],
        path_params=['project', 'region', 'targetHttpProxy'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/targetHttpProxies/{targetHttpProxy}',
        request_field='',
        request_type_name='ComputeRegionTargetHttpProxiesGetRequest',
        response_type_name='TargetHttpProxy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetHttpProxy resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeRegionTargetHttpProxiesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionTargetHttpProxies.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetHttpProxies',
        request_field='targetHttpProxy',
        request_type_name='ComputeRegionTargetHttpProxiesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of TargetHttpProxy resources available to the specified project in the specified region.

      Args:
        request: (ComputeRegionTargetHttpProxiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpProxyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionTargetHttpProxies.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/targetHttpProxies',
        request_field='',
        request_type_name='ComputeRegionTargetHttpProxiesListRequest',
        response_type_name='TargetHttpProxyList',
        supports_download=False,
    )

    def SetUrlMap(self, request, global_params=None):
      r"""Changes the URL map for TargetHttpProxy.

      Args:
        request: (ComputeRegionTargetHttpProxiesSetUrlMapRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetUrlMap')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetUrlMap.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionTargetHttpProxies.setUrlMap',
        ordered_params=['project', 'region', 'targetHttpProxy'],
        path_params=['project', 'region', 'targetHttpProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetHttpProxies/{targetHttpProxy}/setUrlMap',
        request_field='urlMapReference',
        request_type_name='ComputeRegionTargetHttpProxiesSetUrlMapRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionTargetHttpProxiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionTargetHttpProxies.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/targetHttpProxies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionTargetHttpProxiesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionTargetHttpsProxiesService(base_api.BaseApiService):
    """Service class for the regionTargetHttpsProxies resource."""

    _NAME = 'regionTargetHttpsProxies'

    def __init__(self, client):
      super(ComputeBeta.RegionTargetHttpsProxiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetHttpsProxy resource.

      Args:
        request: (ComputeRegionTargetHttpsProxiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionTargetHttpsProxies.delete',
        ordered_params=['project', 'region', 'targetHttpsProxy'],
        path_params=['project', 'region', 'targetHttpsProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetHttpsProxies/{targetHttpsProxy}',
        request_field='',
        request_type_name='ComputeRegionTargetHttpsProxiesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetHttpsProxy resource in the specified region. Gets a list of available target HTTP proxies by making a list() request.

      Args:
        request: (ComputeRegionTargetHttpsProxiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpsProxy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionTargetHttpsProxies.get',
        ordered_params=['project', 'region', 'targetHttpsProxy'],
        path_params=['project', 'region', 'targetHttpsProxy'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/targetHttpsProxies/{targetHttpsProxy}',
        request_field='',
        request_type_name='ComputeRegionTargetHttpsProxiesGetRequest',
        response_type_name='TargetHttpsProxy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetHttpsProxy resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeRegionTargetHttpsProxiesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionTargetHttpsProxies.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetHttpsProxies',
        request_field='targetHttpsProxy',
        request_type_name='ComputeRegionTargetHttpsProxiesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of TargetHttpsProxy resources available to the specified project in the specified region.

      Args:
        request: (ComputeRegionTargetHttpsProxiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpsProxyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionTargetHttpsProxies.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/targetHttpsProxies',
        request_field='',
        request_type_name='ComputeRegionTargetHttpsProxiesListRequest',
        response_type_name='TargetHttpsProxyList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified regional TargetHttpsProxy resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionTargetHttpsProxiesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionTargetHttpsProxies.patch',
        ordered_params=['project', 'region', 'targetHttpsProxy'],
        path_params=['project', 'region', 'targetHttpsProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetHttpsProxies/{targetHttpsProxy}',
        request_field='targetHttpsProxyResource',
        request_type_name='ComputeRegionTargetHttpsProxiesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetSslCertificates(self, request, global_params=None):
      r"""Replaces SslCertificates for TargetHttpsProxy.

      Args:
        request: (ComputeRegionTargetHttpsProxiesSetSslCertificatesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSslCertificates')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSslCertificates.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionTargetHttpsProxies.setSslCertificates',
        ordered_params=['project', 'region', 'targetHttpsProxy'],
        path_params=['project', 'region', 'targetHttpsProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetHttpsProxies/{targetHttpsProxy}/setSslCertificates',
        request_field='regionTargetHttpsProxiesSetSslCertificatesRequest',
        request_type_name='ComputeRegionTargetHttpsProxiesSetSslCertificatesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetUrlMap(self, request, global_params=None):
      r"""Changes the URL map for TargetHttpsProxy.

      Args:
        request: (ComputeRegionTargetHttpsProxiesSetUrlMapRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetUrlMap')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetUrlMap.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionTargetHttpsProxies.setUrlMap',
        ordered_params=['project', 'region', 'targetHttpsProxy'],
        path_params=['project', 'region', 'targetHttpsProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetHttpsProxies/{targetHttpsProxy}/setUrlMap',
        request_field='urlMapReference',
        request_type_name='ComputeRegionTargetHttpsProxiesSetUrlMapRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionTargetHttpsProxiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionTargetHttpsProxies.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/targetHttpsProxies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionTargetHttpsProxiesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionTargetTcpProxiesService(base_api.BaseApiService):
    """Service class for the regionTargetTcpProxies resource."""

    _NAME = 'regionTargetTcpProxies'

    def __init__(self, client):
      super(ComputeBeta.RegionTargetTcpProxiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetTcpProxy resource.

      Args:
        request: (ComputeRegionTargetTcpProxiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionTargetTcpProxies.delete',
        ordered_params=['project', 'region', 'targetTcpProxy'],
        path_params=['project', 'region', 'targetTcpProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetTcpProxies/{targetTcpProxy}',
        request_field='',
        request_type_name='ComputeRegionTargetTcpProxiesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetTcpProxy resource.

      Args:
        request: (ComputeRegionTargetTcpProxiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetTcpProxy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionTargetTcpProxies.get',
        ordered_params=['project', 'region', 'targetTcpProxy'],
        path_params=['project', 'region', 'targetTcpProxy'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/targetTcpProxies/{targetTcpProxy}',
        request_field='',
        request_type_name='ComputeRegionTargetTcpProxiesGetRequest',
        response_type_name='TargetTcpProxy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetTcpProxy resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeRegionTargetTcpProxiesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionTargetTcpProxies.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetTcpProxies',
        request_field='targetTcpProxy',
        request_type_name='ComputeRegionTargetTcpProxiesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of TargetTcpProxy resources available to the specified project in a given region.

      Args:
        request: (ComputeRegionTargetTcpProxiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetTcpProxyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionTargetTcpProxies.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/targetTcpProxies',
        request_field='',
        request_type_name='ComputeRegionTargetTcpProxiesListRequest',
        response_type_name='TargetTcpProxyList',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionTargetTcpProxiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionTargetTcpProxies.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/targetTcpProxies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionTargetTcpProxiesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RegionUrlMapsService(base_api.BaseApiService):
    """Service class for the regionUrlMaps resource."""

    _NAME = 'regionUrlMaps'

    def __init__(self, client):
      super(ComputeBeta.RegionUrlMapsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified UrlMap resource.

      Args:
        request: (ComputeRegionUrlMapsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.regionUrlMaps.delete',
        ordered_params=['project', 'region', 'urlMap'],
        path_params=['project', 'region', 'urlMap'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/urlMaps/{urlMap}',
        request_field='',
        request_type_name='ComputeRegionUrlMapsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified UrlMap resource. Gets a list of available URL maps by making a list() request.

      Args:
        request: (ComputeRegionUrlMapsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UrlMap) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionUrlMaps.get',
        ordered_params=['project', 'region', 'urlMap'],
        path_params=['project', 'region', 'urlMap'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/urlMaps/{urlMap}',
        request_field='',
        request_type_name='ComputeRegionUrlMapsGetRequest',
        response_type_name='UrlMap',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a UrlMap resource in the specified project using the data included in the request.

      Args:
        request: (ComputeRegionUrlMapsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionUrlMaps.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/urlMaps',
        request_field='urlMap',
        request_type_name='ComputeRegionUrlMapsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def InvalidateCache(self, request, global_params=None):
      r"""Initiates a cache invalidation operation, invalidating the specified path, scoped to the specified UrlMap. For more information, see [Invalidating cached content](/cdn/docs/invalidating-cached-content).

      Args:
        request: (ComputeRegionUrlMapsInvalidateCacheRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('InvalidateCache')
      return self._RunMethod(
          config, request, global_params=global_params)

    InvalidateCache.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionUrlMaps.invalidateCache',
        ordered_params=['project', 'region', 'urlMap'],
        path_params=['project', 'region', 'urlMap'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/urlMaps/{urlMap}/invalidateCache',
        request_field='cacheInvalidationRule',
        request_type_name='ComputeRegionUrlMapsInvalidateCacheRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of UrlMap resources available to the specified project in the specified region.

      Args:
        request: (ComputeRegionUrlMapsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UrlMapList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regionUrlMaps.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/urlMaps',
        request_field='',
        request_type_name='ComputeRegionUrlMapsListRequest',
        response_type_name='UrlMapList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified UrlMap resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputeRegionUrlMapsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.regionUrlMaps.patch',
        ordered_params=['project', 'region', 'urlMap'],
        path_params=['project', 'region', 'urlMap'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/urlMaps/{urlMap}',
        request_field='urlMapResource',
        request_type_name='ComputeRegionUrlMapsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRegionUrlMapsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionUrlMaps.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/urlMaps/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRegionUrlMapsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified UrlMap resource with the data included in the request.

      Args:
        request: (ComputeRegionUrlMapsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.regionUrlMaps.update',
        ordered_params=['project', 'region', 'urlMap'],
        path_params=['project', 'region', 'urlMap'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/urlMaps/{urlMap}',
        request_field='urlMapResource',
        request_type_name='ComputeRegionUrlMapsUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Validate(self, request, global_params=None):
      r"""Runs static validation for the UrlMap. In particular, the tests of the provided UrlMap will be run. Calling this method does NOT create the UrlMap.

      Args:
        request: (ComputeRegionUrlMapsValidateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UrlMapsValidateResponse) The response message.
      """
      config = self.GetMethodConfig('Validate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Validate.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.regionUrlMaps.validate',
        ordered_params=['project', 'region', 'urlMap'],
        path_params=['project', 'region', 'urlMap'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/urlMaps/{urlMap}/validate',
        request_field='regionUrlMapsValidateRequest',
        request_type_name='ComputeRegionUrlMapsValidateRequest',
        response_type_name='UrlMapsValidateResponse',
        supports_download=False,
    )

  class RegionsService(base_api.BaseApiService):
    """Service class for the regions resource."""

    _NAME = 'regions'

    def __init__(self, client):
      super(ComputeBeta.RegionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the specified Region resource. Gets a list of available regions by making a list() request. To decrease latency for this method, you can optionally omit any unneeded information from the response by using a field mask. This practice is especially recommended for unused quota information (the `quotas` field). To exclude one or more fields, set your request's `fields` query parameter to only include the fields you need. For example, to only include the `id` and `selfLink` fields, add the query parameter `?fields=id,selfLink` to your request.

      Args:
        request: (ComputeRegionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Region) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regions.get',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}',
        request_field='',
        request_type_name='ComputeRegionsGetRequest',
        response_type_name='Region',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of region resources available to the specified project. To decrease latency for this method, you can optionally omit any unneeded information from the response by using a field mask. This practice is especially recommended for unused quota information (the `items.quotas` field). To exclude one or more fields, set your request's `fields` query parameter to only include the fields you need. For example, to only include the `id` and `selfLink` fields, add the query parameter `?fields=id,selfLink` to your request.

      Args:
        request: (ComputeRegionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegionList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.regions.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions',
        request_field='',
        request_type_name='ComputeRegionsListRequest',
        response_type_name='RegionList',
        supports_download=False,
    )

  class ReservationsService(base_api.BaseApiService):
    """Service class for the reservations resource."""

    _NAME = 'reservations'

    def __init__(self, client):
      super(ComputeBeta.ReservationsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of reservations.

      Args:
        request: (ComputeReservationsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReservationAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.reservations.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/reservations',
        request_field='',
        request_type_name='ComputeReservationsAggregatedListRequest',
        response_type_name='ReservationAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified reservation.

      Args:
        request: (ComputeReservationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.reservations.delete',
        ordered_params=['project', 'zone', 'reservation'],
        path_params=['project', 'reservation', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/reservations/{reservation}',
        request_field='',
        request_type_name='ComputeReservationsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves information about the specified reservation.

      Args:
        request: (ComputeReservationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Reservation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.reservations.get',
        ordered_params=['project', 'zone', 'reservation'],
        path_params=['project', 'reservation', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/reservations/{reservation}',
        request_field='',
        request_type_name='ComputeReservationsGetRequest',
        response_type_name='Reservation',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeReservationsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.reservations.getIamPolicy',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/zones/{zone}/reservations/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeReservationsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new reservation. For more information, read Reserving zonal resources.

      Args:
        request: (ComputeReservationsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.reservations.insert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/reservations',
        request_field='reservation',
        request_type_name='ComputeReservationsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""A list of all the reservations that have been configured for the specified project in specified zone.

      Args:
        request: (ComputeReservationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReservationList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.reservations.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/reservations',
        request_field='',
        request_type_name='ComputeReservationsListRequest',
        response_type_name='ReservationList',
        supports_download=False,
    )

    def Resize(self, request, global_params=None):
      r"""Resizes the reservation (applicable to standalone reservations only). For more information, read Modifying reservations.

      Args:
        request: (ComputeReservationsResizeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Resize')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resize.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.reservations.resize',
        ordered_params=['project', 'zone', 'reservation'],
        path_params=['project', 'reservation', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/reservations/{reservation}/resize',
        request_field='reservationsResizeRequest',
        request_type_name='ComputeReservationsResizeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeReservationsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.reservations.setIamPolicy',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/reservations/{resource}/setIamPolicy',
        request_field='zoneSetPolicyRequest',
        request_type_name='ComputeReservationsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeReservationsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.reservations.testIamPermissions',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/reservations/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeReservationsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Update share settings of the reservation.

      Args:
        request: (ComputeReservationsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.reservations.update',
        ordered_params=['project', 'zone', 'reservation'],
        path_params=['project', 'reservation', 'zone'],
        query_params=['paths', 'requestId', 'updateMask'],
        relative_path='projects/{project}/zones/{zone}/reservations/{reservation}',
        request_field='reservationResource',
        request_type_name='ComputeReservationsUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ResourcePoliciesService(base_api.BaseApiService):
    """Service class for the resourcePolicies resource."""

    _NAME = 'resourcePolicies'

    def __init__(self, client):
      super(ComputeBeta.ResourcePoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of resource policies.

      Args:
        request: (ComputeResourcePoliciesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ResourcePolicyAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.resourcePolicies.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/resourcePolicies',
        request_field='',
        request_type_name='ComputeResourcePoliciesAggregatedListRequest',
        response_type_name='ResourcePolicyAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified resource policy.

      Args:
        request: (ComputeResourcePoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.resourcePolicies.delete',
        ordered_params=['project', 'region', 'resourcePolicy'],
        path_params=['project', 'region', 'resourcePolicy'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/resourcePolicies/{resourcePolicy}',
        request_field='',
        request_type_name='ComputeResourcePoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves all information of the specified resource policy.

      Args:
        request: (ComputeResourcePoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ResourcePolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.resourcePolicies.get',
        ordered_params=['project', 'region', 'resourcePolicy'],
        path_params=['project', 'region', 'resourcePolicy'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/resourcePolicies/{resourcePolicy}',
        request_field='',
        request_type_name='ComputeResourcePoliciesGetRequest',
        response_type_name='ResourcePolicy',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeResourcePoliciesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.resourcePolicies.getIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/regions/{region}/resourcePolicies/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeResourcePoliciesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new resource policy.

      Args:
        request: (ComputeResourcePoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.resourcePolicies.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/resourcePolicies',
        request_field='resourcePolicy',
        request_type_name='ComputeResourcePoliciesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""A list all the resource policies that have been configured for the specified project in specified region.

      Args:
        request: (ComputeResourcePoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ResourcePolicyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.resourcePolicies.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/resourcePolicies',
        request_field='',
        request_type_name='ComputeResourcePoliciesListRequest',
        response_type_name='ResourcePolicyList',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeResourcePoliciesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.resourcePolicies.setIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/resourcePolicies/{resource}/setIamPolicy',
        request_field='regionSetPolicyRequest',
        request_type_name='ComputeResourcePoliciesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeResourcePoliciesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.resourcePolicies.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/resourcePolicies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeResourcePoliciesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class RoutersService(base_api.BaseApiService):
    """Service class for the routers resource."""

    _NAME = 'routers'

    def __init__(self, client):
      super(ComputeBeta.RoutersService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of routers.

      Args:
        request: (ComputeRoutersAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RouterAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.routers.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/routers',
        request_field='',
        request_type_name='ComputeRoutersAggregatedListRequest',
        response_type_name='RouterAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Router resource.

      Args:
        request: (ComputeRoutersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.routers.delete',
        ordered_params=['project', 'region', 'router'],
        path_params=['project', 'region', 'router'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/routers/{router}',
        request_field='',
        request_type_name='ComputeRoutersDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified Router resource. Gets a list of available routers by making a list() request.

      Args:
        request: (ComputeRoutersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Router) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.routers.get',
        ordered_params=['project', 'region', 'router'],
        path_params=['project', 'region', 'router'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/routers/{router}',
        request_field='',
        request_type_name='ComputeRoutersGetRequest',
        response_type_name='Router',
        supports_download=False,
    )

    def GetNatMappingInfo(self, request, global_params=None):
      r"""Retrieves runtime Nat mapping information of VM endpoints.

      Args:
        request: (ComputeRoutersGetNatMappingInfoRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VmEndpointNatMappingsList) The response message.
      """
      config = self.GetMethodConfig('GetNatMappingInfo')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetNatMappingInfo.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.routers.getNatMappingInfo',
        ordered_params=['project', 'region', 'router'],
        path_params=['project', 'region', 'router'],
        query_params=['filter', 'maxResults', 'natName', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/routers/{router}/getNatMappingInfo',
        request_field='',
        request_type_name='ComputeRoutersGetNatMappingInfoRequest',
        response_type_name='VmEndpointNatMappingsList',
        supports_download=False,
    )

    def GetRouterStatus(self, request, global_params=None):
      r"""Retrieves runtime information of the specified router.

      Args:
        request: (ComputeRoutersGetRouterStatusRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RouterStatusResponse) The response message.
      """
      config = self.GetMethodConfig('GetRouterStatus')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetRouterStatus.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.routers.getRouterStatus',
        ordered_params=['project', 'region', 'router'],
        path_params=['project', 'region', 'router'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/routers/{router}/getRouterStatus',
        request_field='',
        request_type_name='ComputeRoutersGetRouterStatusRequest',
        response_type_name='RouterStatusResponse',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a Router resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeRoutersInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.routers.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/routers',
        request_field='router',
        request_type_name='ComputeRoutersInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of Router resources available to the specified project.

      Args:
        request: (ComputeRoutersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RouterList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.routers.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/routers',
        request_field='',
        request_type_name='ComputeRoutersListRequest',
        response_type_name='RouterList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified Router resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputeRoutersPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.routers.patch',
        ordered_params=['project', 'region', 'router'],
        path_params=['project', 'region', 'router'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/routers/{router}',
        request_field='routerResource',
        request_type_name='ComputeRoutersPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Preview(self, request, global_params=None):
      r"""Preview fields auto-generated during router create and update operations. Calling this method does NOT create or update the router.

      Args:
        request: (ComputeRoutersPreviewRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RoutersPreviewResponse) The response message.
      """
      config = self.GetMethodConfig('Preview')
      return self._RunMethod(
          config, request, global_params=global_params)

    Preview.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.routers.preview',
        ordered_params=['project', 'region', 'router'],
        path_params=['project', 'region', 'router'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/routers/{router}/preview',
        request_field='routerResource',
        request_type_name='ComputeRoutersPreviewRequest',
        response_type_name='RoutersPreviewResponse',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRoutersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.routers.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/routers/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRoutersTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified Router resource with the data included in the request. This method conforms to PUT semantics, which requests that the state of the target resource be created or replaced with the state defined by the representation enclosed in the request message payload.

      Args:
        request: (ComputeRoutersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.routers.update',
        ordered_params=['project', 'region', 'router'],
        path_params=['project', 'region', 'router'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/routers/{router}',
        request_field='routerResource',
        request_type_name='ComputeRoutersUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class RoutesService(base_api.BaseApiService):
    """Service class for the routes resource."""

    _NAME = 'routes'

    def __init__(self, client):
      super(ComputeBeta.RoutesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Route resource.

      Args:
        request: (ComputeRoutesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.routes.delete',
        ordered_params=['project', 'route'],
        path_params=['project', 'route'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/routes/{route}',
        request_field='',
        request_type_name='ComputeRoutesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified Route resource. Gets a list of available routes by making a list() request.

      Args:
        request: (ComputeRoutesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Route) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.routes.get',
        ordered_params=['project', 'route'],
        path_params=['project', 'route'],
        query_params=[],
        relative_path='projects/{project}/global/routes/{route}',
        request_field='',
        request_type_name='ComputeRoutesGetRequest',
        response_type_name='Route',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a Route resource in the specified project using the data included in the request.

      Args:
        request: (ComputeRoutesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.routes.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/routes',
        request_field='route',
        request_type_name='ComputeRoutesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of Route resources available to the specified project.

      Args:
        request: (ComputeRoutesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RouteList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.routes.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/routes',
        request_field='',
        request_type_name='ComputeRoutesListRequest',
        response_type_name='RouteList',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeRoutesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.routes.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/routes/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeRoutesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class SecurityPoliciesService(base_api.BaseApiService):
    """Service class for the securityPolicies resource."""

    _NAME = 'securityPolicies'

    def __init__(self, client):
      super(ComputeBeta.SecurityPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def AddRule(self, request, global_params=None):
      r"""Inserts a rule into a security policy.

      Args:
        request: (ComputeSecurityPoliciesAddRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.securityPolicies.addRule',
        ordered_params=['project', 'securityPolicy'],
        path_params=['project', 'securityPolicy'],
        query_params=['validateOnly'],
        relative_path='projects/{project}/global/securityPolicies/{securityPolicy}/addRule',
        request_field='securityPolicyRule',
        request_type_name='ComputeSecurityPoliciesAddRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all SecurityPolicy resources, regional and global, available to the specified project.

      Args:
        request: (ComputeSecurityPoliciesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPoliciesAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.securityPolicies.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/securityPolicies',
        request_field='',
        request_type_name='ComputeSecurityPoliciesAggregatedListRequest',
        response_type_name='SecurityPoliciesAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified policy.

      Args:
        request: (ComputeSecurityPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.securityPolicies.delete',
        ordered_params=['project', 'securityPolicy'],
        path_params=['project', 'securityPolicy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/securityPolicies/{securityPolicy}',
        request_field='',
        request_type_name='ComputeSecurityPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""List all of the ordered rules present in a single specified policy.

      Args:
        request: (ComputeSecurityPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.securityPolicies.get',
        ordered_params=['project', 'securityPolicy'],
        path_params=['project', 'securityPolicy'],
        query_params=[],
        relative_path='projects/{project}/global/securityPolicies/{securityPolicy}',
        request_field='',
        request_type_name='ComputeSecurityPoliciesGetRequest',
        response_type_name='SecurityPolicy',
        supports_download=False,
    )

    def GetRule(self, request, global_params=None):
      r"""Gets a rule at the specified priority.

      Args:
        request: (ComputeSecurityPoliciesGetRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicyRule) The response message.
      """
      config = self.GetMethodConfig('GetRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.securityPolicies.getRule',
        ordered_params=['project', 'securityPolicy'],
        path_params=['project', 'securityPolicy'],
        query_params=['priority'],
        relative_path='projects/{project}/global/securityPolicies/{securityPolicy}/getRule',
        request_field='',
        request_type_name='ComputeSecurityPoliciesGetRuleRequest',
        response_type_name='SecurityPolicyRule',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new policy in the specified project using the data included in the request.

      Args:
        request: (ComputeSecurityPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.securityPolicies.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId', 'validateOnly'],
        relative_path='projects/{project}/global/securityPolicies',
        request_field='securityPolicy',
        request_type_name='ComputeSecurityPoliciesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List all the policies that have been configured for the specified project.

      Args:
        request: (ComputeSecurityPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPolicyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.securityPolicies.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/securityPolicies',
        request_field='',
        request_type_name='ComputeSecurityPoliciesListRequest',
        response_type_name='SecurityPolicyList',
        supports_download=False,
    )

    def ListPreconfiguredExpressionSets(self, request, global_params=None):
      r"""Gets the current list of preconfigured Web Application Firewall (WAF) expressions.

      Args:
        request: (ComputeSecurityPoliciesListPreconfiguredExpressionSetsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SecurityPoliciesListPreconfiguredExpressionSetsResponse) The response message.
      """
      config = self.GetMethodConfig('ListPreconfiguredExpressionSets')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListPreconfiguredExpressionSets.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.securityPolicies.listPreconfiguredExpressionSets',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/securityPolicies/listPreconfiguredExpressionSets',
        request_field='',
        request_type_name='ComputeSecurityPoliciesListPreconfiguredExpressionSetsRequest',
        response_type_name='SecurityPoliciesListPreconfiguredExpressionSetsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified policy with the data included in the request. This cannot be used to be update the rules in the policy. Please use the per rule methods like addRule, patchRule, and removeRule instead.

      Args:
        request: (ComputeSecurityPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.securityPolicies.patch',
        ordered_params=['project', 'securityPolicy'],
        path_params=['project', 'securityPolicy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/securityPolicies/{securityPolicy}',
        request_field='securityPolicyResource',
        request_type_name='ComputeSecurityPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def PatchRule(self, request, global_params=None):
      r"""Patches a rule at the specified priority.

      Args:
        request: (ComputeSecurityPoliciesPatchRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PatchRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    PatchRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.securityPolicies.patchRule',
        ordered_params=['project', 'securityPolicy'],
        path_params=['project', 'securityPolicy'],
        query_params=['priority', 'validateOnly'],
        relative_path='projects/{project}/global/securityPolicies/{securityPolicy}/patchRule',
        request_field='securityPolicyRule',
        request_type_name='ComputeSecurityPoliciesPatchRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveRule(self, request, global_params=None):
      r"""Deletes a rule at the specified priority.

      Args:
        request: (ComputeSecurityPoliciesRemoveRuleRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveRule')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveRule.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.securityPolicies.removeRule',
        ordered_params=['project', 'securityPolicy'],
        path_params=['project', 'securityPolicy'],
        query_params=['priority'],
        relative_path='projects/{project}/global/securityPolicies/{securityPolicy}/removeRule',
        request_field='',
        request_type_name='ComputeSecurityPoliciesRemoveRuleRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a security policy. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeSecurityPoliciesSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.securityPolicies.setLabels',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/securityPolicies/{resource}/setLabels',
        request_field='globalSetLabelsRequest',
        request_type_name='ComputeSecurityPoliciesSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeSecurityPoliciesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.securityPolicies.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/securityPolicies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeSecurityPoliciesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class ServiceAttachmentsService(base_api.BaseApiService):
    """Service class for the serviceAttachments resource."""

    _NAME = 'serviceAttachments'

    def __init__(self, client):
      super(ComputeBeta.ServiceAttachmentsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all ServiceAttachment resources, regional and global, available to the specified project.

      Args:
        request: (ComputeServiceAttachmentsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAttachmentAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.serviceAttachments.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/serviceAttachments',
        request_field='',
        request_type_name='ComputeServiceAttachmentsAggregatedListRequest',
        response_type_name='ServiceAttachmentAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified ServiceAttachment in the given scope.

      Args:
        request: (ComputeServiceAttachmentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.serviceAttachments.delete',
        ordered_params=['project', 'region', 'serviceAttachment'],
        path_params=['project', 'region', 'serviceAttachment'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/serviceAttachments/{serviceAttachment}',
        request_field='',
        request_type_name='ComputeServiceAttachmentsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified ServiceAttachment resource in the given scope.

      Args:
        request: (ComputeServiceAttachmentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAttachment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.serviceAttachments.get',
        ordered_params=['project', 'region', 'serviceAttachment'],
        path_params=['project', 'region', 'serviceAttachment'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/serviceAttachments/{serviceAttachment}',
        request_field='',
        request_type_name='ComputeServiceAttachmentsGetRequest',
        response_type_name='ServiceAttachment',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeServiceAttachmentsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.serviceAttachments.getIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/regions/{region}/serviceAttachments/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeServiceAttachmentsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a ServiceAttachment in the specified project in the given scope using the parameters that are included in the request.

      Args:
        request: (ComputeServiceAttachmentsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.serviceAttachments.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/serviceAttachments',
        request_field='serviceAttachment',
        request_type_name='ComputeServiceAttachmentsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the ServiceAttachments for a project in the given scope.

      Args:
        request: (ComputeServiceAttachmentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAttachmentList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.serviceAttachments.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/serviceAttachments',
        request_field='',
        request_type_name='ComputeServiceAttachmentsListRequest',
        response_type_name='ServiceAttachmentList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified ServiceAttachment resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputeServiceAttachmentsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.serviceAttachments.patch',
        ordered_params=['project', 'region', 'serviceAttachment'],
        path_params=['project', 'region', 'serviceAttachment'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/serviceAttachments/{serviceAttachment}',
        request_field='serviceAttachmentResource',
        request_type_name='ComputeServiceAttachmentsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeServiceAttachmentsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.serviceAttachments.setIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/serviceAttachments/{resource}/setIamPolicy',
        request_field='regionSetPolicyRequest',
        request_type_name='ComputeServiceAttachmentsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeServiceAttachmentsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.serviceAttachments.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/serviceAttachments/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeServiceAttachmentsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class SnapshotsService(base_api.BaseApiService):
    """Service class for the snapshots resource."""

    _NAME = 'snapshots'

    def __init__(self, client):
      super(ComputeBeta.SnapshotsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified Snapshot resource. Keep in mind that deleting a single snapshot might not necessarily delete all the data on that snapshot. If any data on the snapshot that is marked for deletion is needed for subsequent snapshots, the data will be moved to the next corresponding snapshot. For more information, see Deleting snapshots.

      Args:
        request: (ComputeSnapshotsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.snapshots.delete',
        ordered_params=['project', 'snapshot'],
        path_params=['project', 'snapshot'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/snapshots/{snapshot}',
        request_field='',
        request_type_name='ComputeSnapshotsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified Snapshot resource. Gets a list of available snapshots by making a list() request.

      Args:
        request: (ComputeSnapshotsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Snapshot) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.snapshots.get',
        ordered_params=['project', 'snapshot'],
        path_params=['project', 'snapshot'],
        query_params=[],
        relative_path='projects/{project}/global/snapshots/{snapshot}',
        request_field='',
        request_type_name='ComputeSnapshotsGetRequest',
        response_type_name='Snapshot',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeSnapshotsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.snapshots.getIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/global/snapshots/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeSnapshotsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a snapshot in the specified project using the data included in the request. For regular snapshot creation, consider using this method instead of disks.createSnapshot, as this method supports more features, such as creating snapshots in a project different from the source disk project.

      Args:
        request: (ComputeSnapshotsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.snapshots.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/snapshots',
        request_field='snapshot',
        request_type_name='ComputeSnapshotsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of Snapshot resources contained within the specified project.

      Args:
        request: (ComputeSnapshotsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SnapshotList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.snapshots.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/snapshots',
        request_field='',
        request_type_name='ComputeSnapshotsListRequest',
        response_type_name='SnapshotList',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeSnapshotsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.snapshots.setIamPolicy',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/snapshots/{resource}/setIamPolicy',
        request_field='globalSetPolicyRequest',
        request_type_name='ComputeSnapshotsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a snapshot. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeSnapshotsSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.snapshots.setLabels',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/snapshots/{resource}/setLabels',
        request_field='globalSetLabelsRequest',
        request_type_name='ComputeSnapshotsSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeSnapshotsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.snapshots.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/snapshots/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeSnapshotsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class SslCertificatesService(base_api.BaseApiService):
    """Service class for the sslCertificates resource."""

    _NAME = 'sslCertificates'

    def __init__(self, client):
      super(ComputeBeta.SslCertificatesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all SslCertificate resources, regional and global, available to the specified project.

      Args:
        request: (ComputeSslCertificatesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslCertificateAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.sslCertificates.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/sslCertificates',
        request_field='',
        request_type_name='ComputeSslCertificatesAggregatedListRequest',
        response_type_name='SslCertificateAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified SslCertificate resource.

      Args:
        request: (ComputeSslCertificatesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.sslCertificates.delete',
        ordered_params=['project', 'sslCertificate'],
        path_params=['project', 'sslCertificate'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/sslCertificates/{sslCertificate}',
        request_field='',
        request_type_name='ComputeSslCertificatesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified SslCertificate resource. Gets a list of available SSL certificates by making a list() request.

      Args:
        request: (ComputeSslCertificatesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslCertificate) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.sslCertificates.get',
        ordered_params=['project', 'sslCertificate'],
        path_params=['project', 'sslCertificate'],
        query_params=[],
        relative_path='projects/{project}/global/sslCertificates/{sslCertificate}',
        request_field='',
        request_type_name='ComputeSslCertificatesGetRequest',
        response_type_name='SslCertificate',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a SslCertificate resource in the specified project using the data included in the request.

      Args:
        request: (ComputeSslCertificatesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.sslCertificates.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/sslCertificates',
        request_field='sslCertificate',
        request_type_name='ComputeSslCertificatesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of SslCertificate resources available to the specified project.

      Args:
        request: (ComputeSslCertificatesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslCertificateList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.sslCertificates.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/sslCertificates',
        request_field='',
        request_type_name='ComputeSslCertificatesListRequest',
        response_type_name='SslCertificateList',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeSslCertificatesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.sslCertificates.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/sslCertificates/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeSslCertificatesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class SslPoliciesService(base_api.BaseApiService):
    """Service class for the sslPolicies resource."""

    _NAME = 'sslPolicies'

    def __init__(self, client):
      super(ComputeBeta.SslPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all SslPolicy resources, regional and global, available to the specified project.

      Args:
        request: (ComputeSslPoliciesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslPoliciesAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.sslPolicies.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/sslPolicies',
        request_field='',
        request_type_name='ComputeSslPoliciesAggregatedListRequest',
        response_type_name='SslPoliciesAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified SSL policy. The SSL policy resource can be deleted only if it is not in use by any TargetHttpsProxy or TargetSslProxy resources.

      Args:
        request: (ComputeSslPoliciesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.sslPolicies.delete',
        ordered_params=['project', 'sslPolicy'],
        path_params=['project', 'sslPolicy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/sslPolicies/{sslPolicy}',
        request_field='',
        request_type_name='ComputeSslPoliciesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Lists all of the ordered rules present in a single specified policy.

      Args:
        request: (ComputeSslPoliciesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslPolicy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.sslPolicies.get',
        ordered_params=['project', 'sslPolicy'],
        path_params=['project', 'sslPolicy'],
        query_params=[],
        relative_path='projects/{project}/global/sslPolicies/{sslPolicy}',
        request_field='',
        request_type_name='ComputeSslPoliciesGetRequest',
        response_type_name='SslPolicy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Returns the specified SSL policy resource. Gets a list of available SSL policies by making a list() request.

      Args:
        request: (ComputeSslPoliciesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.sslPolicies.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/sslPolicies',
        request_field='sslPolicy',
        request_type_name='ComputeSslPoliciesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the SSL policies that have been configured for the specified project.

      Args:
        request: (ComputeSslPoliciesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslPoliciesList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.sslPolicies.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/sslPolicies',
        request_field='',
        request_type_name='ComputeSslPoliciesListRequest',
        response_type_name='SslPoliciesList',
        supports_download=False,
    )

    def ListAvailableFeatures(self, request, global_params=None):
      r"""Lists all features that can be specified in the SSL policy when using custom profile.

      Args:
        request: (ComputeSslPoliciesListAvailableFeaturesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SslPoliciesListAvailableFeaturesResponse) The response message.
      """
      config = self.GetMethodConfig('ListAvailableFeatures')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListAvailableFeatures.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.sslPolicies.listAvailableFeatures',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/sslPolicies/listAvailableFeatures',
        request_field='',
        request_type_name='ComputeSslPoliciesListAvailableFeaturesRequest',
        response_type_name='SslPoliciesListAvailableFeaturesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified SSL policy with the data included in the request.

      Args:
        request: (ComputeSslPoliciesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.sslPolicies.patch',
        ordered_params=['project', 'sslPolicy'],
        path_params=['project', 'sslPolicy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/sslPolicies/{sslPolicy}',
        request_field='sslPolicyResource',
        request_type_name='ComputeSslPoliciesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeSslPoliciesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.sslPolicies.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/sslPolicies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeSslPoliciesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class SubnetworksService(base_api.BaseApiService):
    """Service class for the subnetworks resource."""

    _NAME = 'subnetworks'

    def __init__(self, client):
      super(ComputeBeta.SubnetworksService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of subnetworks.

      Args:
        request: (ComputeSubnetworksAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SubnetworkAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.subnetworks.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/subnetworks',
        request_field='',
        request_type_name='ComputeSubnetworksAggregatedListRequest',
        response_type_name='SubnetworkAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified subnetwork.

      Args:
        request: (ComputeSubnetworksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.subnetworks.delete',
        ordered_params=['project', 'region', 'subnetwork'],
        path_params=['project', 'region', 'subnetwork'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/subnetworks/{subnetwork}',
        request_field='',
        request_type_name='ComputeSubnetworksDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def ExpandIpCidrRange(self, request, global_params=None):
      r"""Expands the IP CIDR range of the subnetwork to a specified value.

      Args:
        request: (ComputeSubnetworksExpandIpCidrRangeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('ExpandIpCidrRange')
      return self._RunMethod(
          config, request, global_params=global_params)

    ExpandIpCidrRange.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.subnetworks.expandIpCidrRange',
        ordered_params=['project', 'region', 'subnetwork'],
        path_params=['project', 'region', 'subnetwork'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/subnetworks/{subnetwork}/expandIpCidrRange',
        request_field='subnetworksExpandIpCidrRangeRequest',
        request_type_name='ComputeSubnetworksExpandIpCidrRangeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified subnetwork. Gets a list of available subnetworks list() request.

      Args:
        request: (ComputeSubnetworksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Subnetwork) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.subnetworks.get',
        ordered_params=['project', 'region', 'subnetwork'],
        path_params=['project', 'region', 'subnetwork'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/subnetworks/{subnetwork}',
        request_field='',
        request_type_name='ComputeSubnetworksGetRequest',
        response_type_name='Subnetwork',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. May be empty if no such policy or resource exists.

      Args:
        request: (ComputeSubnetworksGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.subnetworks.getIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['optionsRequestedPolicyVersion'],
        relative_path='projects/{project}/regions/{region}/subnetworks/{resource}/getIamPolicy',
        request_field='',
        request_type_name='ComputeSubnetworksGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a subnetwork in the specified project using the data included in the request.

      Args:
        request: (ComputeSubnetworksInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.subnetworks.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/subnetworks',
        request_field='subnetwork',
        request_type_name='ComputeSubnetworksInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of subnetworks available to the specified project.

      Args:
        request: (ComputeSubnetworksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SubnetworkList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.subnetworks.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/subnetworks',
        request_field='',
        request_type_name='ComputeSubnetworksListRequest',
        response_type_name='SubnetworkList',
        supports_download=False,
    )

    def ListUsable(self, request, global_params=None):
      r"""Retrieves an aggregated list of all usable subnetworks in the project.

      Args:
        request: (ComputeSubnetworksListUsableRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UsableSubnetworksAggregatedList) The response message.
      """
      config = self.GetMethodConfig('ListUsable')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListUsable.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.subnetworks.listUsable',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess', 'serviceProject'],
        relative_path='projects/{project}/aggregated/subnetworks/listUsable',
        request_field='',
        request_type_name='ComputeSubnetworksListUsableRequest',
        response_type_name='UsableSubnetworksAggregatedList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified subnetwork with the data included in the request. Only certain fields can be updated with a patch request as indicated in the field descriptions. You must specify the current fingerprint of the subnetwork resource being patched.

      Args:
        request: (ComputeSubnetworksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.subnetworks.patch',
        ordered_params=['project', 'region', 'subnetwork'],
        path_params=['project', 'region', 'subnetwork'],
        query_params=['drainTimeoutSeconds', 'requestId'],
        relative_path='projects/{project}/regions/{region}/subnetworks/{subnetwork}',
        request_field='subnetworkResource',
        request_type_name='ComputeSubnetworksPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy.

      Args:
        request: (ComputeSubnetworksSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.subnetworks.setIamPolicy',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/subnetworks/{resource}/setIamPolicy',
        request_field='regionSetPolicyRequest',
        request_type_name='ComputeSubnetworksSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetPrivateIpGoogleAccess(self, request, global_params=None):
      r"""Set whether VMs in this subnet can access Google services without assigning external IP addresses through Private Google Access.

      Args:
        request: (ComputeSubnetworksSetPrivateIpGoogleAccessRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetPrivateIpGoogleAccess')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetPrivateIpGoogleAccess.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.subnetworks.setPrivateIpGoogleAccess',
        ordered_params=['project', 'region', 'subnetwork'],
        path_params=['project', 'region', 'subnetwork'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/subnetworks/{subnetwork}/setPrivateIpGoogleAccess',
        request_field='subnetworksSetPrivateIpGoogleAccessRequest',
        request_type_name='ComputeSubnetworksSetPrivateIpGoogleAccessRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeSubnetworksTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.subnetworks.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/subnetworks/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeSubnetworksTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class TargetGrpcProxiesService(base_api.BaseApiService):
    """Service class for the targetGrpcProxies resource."""

    _NAME = 'targetGrpcProxies'

    def __init__(self, client):
      super(ComputeBeta.TargetGrpcProxiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetGrpcProxy in the given scope.

      Args:
        request: (ComputeTargetGrpcProxiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.targetGrpcProxies.delete',
        ordered_params=['project', 'targetGrpcProxy'],
        path_params=['project', 'targetGrpcProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetGrpcProxies/{targetGrpcProxy}',
        request_field='',
        request_type_name='ComputeTargetGrpcProxiesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetGrpcProxy resource in the given scope.

      Args:
        request: (ComputeTargetGrpcProxiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetGrpcProxy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetGrpcProxies.get',
        ordered_params=['project', 'targetGrpcProxy'],
        path_params=['project', 'targetGrpcProxy'],
        query_params=[],
        relative_path='projects/{project}/global/targetGrpcProxies/{targetGrpcProxy}',
        request_field='',
        request_type_name='ComputeTargetGrpcProxiesGetRequest',
        response_type_name='TargetGrpcProxy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetGrpcProxy in the specified project in the given scope using the parameters that are included in the request.

      Args:
        request: (ComputeTargetGrpcProxiesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetGrpcProxies.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetGrpcProxies',
        request_field='targetGrpcProxy',
        request_type_name='ComputeTargetGrpcProxiesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the TargetGrpcProxies for a project in the given scope.

      Args:
        request: (ComputeTargetGrpcProxiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetGrpcProxyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetGrpcProxies.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/targetGrpcProxies',
        request_field='',
        request_type_name='ComputeTargetGrpcProxiesListRequest',
        response_type_name='TargetGrpcProxyList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified TargetGrpcProxy resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputeTargetGrpcProxiesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.targetGrpcProxies.patch',
        ordered_params=['project', 'targetGrpcProxy'],
        path_params=['project', 'targetGrpcProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetGrpcProxies/{targetGrpcProxy}',
        request_field='targetGrpcProxyResource',
        request_type_name='ComputeTargetGrpcProxiesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeTargetGrpcProxiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetGrpcProxies.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/targetGrpcProxies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeTargetGrpcProxiesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class TargetHttpProxiesService(base_api.BaseApiService):
    """Service class for the targetHttpProxies resource."""

    _NAME = 'targetHttpProxies'

    def __init__(self, client):
      super(ComputeBeta.TargetHttpProxiesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all TargetHttpProxy resources, regional and global, available to the specified project.

      Args:
        request: (ComputeTargetHttpProxiesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpProxyAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetHttpProxies.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/targetHttpProxies',
        request_field='',
        request_type_name='ComputeTargetHttpProxiesAggregatedListRequest',
        response_type_name='TargetHttpProxyAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetHttpProxy resource.

      Args:
        request: (ComputeTargetHttpProxiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.targetHttpProxies.delete',
        ordered_params=['project', 'targetHttpProxy'],
        path_params=['project', 'targetHttpProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetHttpProxies/{targetHttpProxy}',
        request_field='',
        request_type_name='ComputeTargetHttpProxiesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetHttpProxy resource. Gets a list of available target HTTP proxies by making a list() request.

      Args:
        request: (ComputeTargetHttpProxiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpProxy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetHttpProxies.get',
        ordered_params=['project', 'targetHttpProxy'],
        path_params=['project', 'targetHttpProxy'],
        query_params=[],
        relative_path='projects/{project}/global/targetHttpProxies/{targetHttpProxy}',
        request_field='',
        request_type_name='ComputeTargetHttpProxiesGetRequest',
        response_type_name='TargetHttpProxy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetHttpProxy resource in the specified project using the data included in the request.

      Args:
        request: (ComputeTargetHttpProxiesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetHttpProxies.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetHttpProxies',
        request_field='targetHttpProxy',
        request_type_name='ComputeTargetHttpProxiesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of TargetHttpProxy resources available to the specified project.

      Args:
        request: (ComputeTargetHttpProxiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpProxyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetHttpProxies.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/targetHttpProxies',
        request_field='',
        request_type_name='ComputeTargetHttpProxiesListRequest',
        response_type_name='TargetHttpProxyList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified TargetHttpProxy resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputeTargetHttpProxiesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.targetHttpProxies.patch',
        ordered_params=['project', 'targetHttpProxy'],
        path_params=['project', 'targetHttpProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetHttpProxies/{targetHttpProxy}',
        request_field='targetHttpProxyResource',
        request_type_name='ComputeTargetHttpProxiesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetUrlMap(self, request, global_params=None):
      r"""Changes the URL map for TargetHttpProxy.

      Args:
        request: (ComputeTargetHttpProxiesSetUrlMapRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetUrlMap')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetUrlMap.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetHttpProxies.setUrlMap',
        ordered_params=['project', 'targetHttpProxy'],
        path_params=['project', 'targetHttpProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/targetHttpProxies/{targetHttpProxy}/setUrlMap',
        request_field='urlMapReference',
        request_type_name='ComputeTargetHttpProxiesSetUrlMapRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeTargetHttpProxiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetHttpProxies.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/targetHttpProxies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeTargetHttpProxiesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class TargetHttpsProxiesService(base_api.BaseApiService):
    """Service class for the targetHttpsProxies resource."""

    _NAME = 'targetHttpsProxies'

    def __init__(self, client):
      super(ComputeBeta.TargetHttpsProxiesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all TargetHttpsProxy resources, regional and global, available to the specified project.

      Args:
        request: (ComputeTargetHttpsProxiesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpsProxyAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetHttpsProxies.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/targetHttpsProxies',
        request_field='',
        request_type_name='ComputeTargetHttpsProxiesAggregatedListRequest',
        response_type_name='TargetHttpsProxyAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetHttpsProxy resource.

      Args:
        request: (ComputeTargetHttpsProxiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.targetHttpsProxies.delete',
        ordered_params=['project', 'targetHttpsProxy'],
        path_params=['project', 'targetHttpsProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}',
        request_field='',
        request_type_name='ComputeTargetHttpsProxiesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetHttpsProxy resource. Gets a list of available target HTTPS proxies by making a list() request.

      Args:
        request: (ComputeTargetHttpsProxiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpsProxy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetHttpsProxies.get',
        ordered_params=['project', 'targetHttpsProxy'],
        path_params=['project', 'targetHttpsProxy'],
        query_params=[],
        relative_path='projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}',
        request_field='',
        request_type_name='ComputeTargetHttpsProxiesGetRequest',
        response_type_name='TargetHttpsProxy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetHttpsProxy resource in the specified project using the data included in the request.

      Args:
        request: (ComputeTargetHttpsProxiesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetHttpsProxies.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetHttpsProxies',
        request_field='targetHttpsProxy',
        request_type_name='ComputeTargetHttpsProxiesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of TargetHttpsProxy resources available to the specified project.

      Args:
        request: (ComputeTargetHttpsProxiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetHttpsProxyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetHttpsProxies.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/targetHttpsProxies',
        request_field='',
        request_type_name='ComputeTargetHttpsProxiesListRequest',
        response_type_name='TargetHttpsProxyList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified TargetHttpsProxy resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.

      Args:
        request: (ComputeTargetHttpsProxiesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.targetHttpsProxies.patch',
        ordered_params=['project', 'targetHttpsProxy'],
        path_params=['project', 'targetHttpsProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}',
        request_field='targetHttpsProxyResource',
        request_type_name='ComputeTargetHttpsProxiesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetCertificateMap(self, request, global_params=None):
      r"""Changes the Certificate Map for TargetHttpsProxy.

      Args:
        request: (ComputeTargetHttpsProxiesSetCertificateMapRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetCertificateMap')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetCertificateMap.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetHttpsProxies.setCertificateMap',
        ordered_params=['project', 'targetHttpsProxy'],
        path_params=['project', 'targetHttpsProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}/setCertificateMap',
        request_field='targetHttpsProxiesSetCertificateMapRequest',
        request_type_name='ComputeTargetHttpsProxiesSetCertificateMapRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetQuicOverride(self, request, global_params=None):
      r"""Sets the QUIC override policy for TargetHttpsProxy.

      Args:
        request: (ComputeTargetHttpsProxiesSetQuicOverrideRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetQuicOverride')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetQuicOverride.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetHttpsProxies.setQuicOverride',
        ordered_params=['project', 'targetHttpsProxy'],
        path_params=['project', 'targetHttpsProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}/setQuicOverride',
        request_field='targetHttpsProxiesSetQuicOverrideRequest',
        request_type_name='ComputeTargetHttpsProxiesSetQuicOverrideRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetSslCertificates(self, request, global_params=None):
      r"""Replaces SslCertificates for TargetHttpsProxy.

      Args:
        request: (ComputeTargetHttpsProxiesSetSslCertificatesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSslCertificates')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSslCertificates.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetHttpsProxies.setSslCertificates',
        ordered_params=['project', 'targetHttpsProxy'],
        path_params=['project', 'targetHttpsProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/targetHttpsProxies/{targetHttpsProxy}/setSslCertificates',
        request_field='targetHttpsProxiesSetSslCertificatesRequest',
        request_type_name='ComputeTargetHttpsProxiesSetSslCertificatesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetSslPolicy(self, request, global_params=None):
      r"""Sets the SSL policy for TargetHttpsProxy. The SSL policy specifies the server-side support for SSL features. This affects connections between clients and the HTTPS proxy load balancer. They do not affect the connection between the load balancer and the backends.

      Args:
        request: (ComputeTargetHttpsProxiesSetSslPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSslPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSslPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetHttpsProxies.setSslPolicy',
        ordered_params=['project', 'targetHttpsProxy'],
        path_params=['project', 'targetHttpsProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}/setSslPolicy',
        request_field='sslPolicyReference',
        request_type_name='ComputeTargetHttpsProxiesSetSslPolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetUrlMap(self, request, global_params=None):
      r"""Changes the URL map for TargetHttpsProxy.

      Args:
        request: (ComputeTargetHttpsProxiesSetUrlMapRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetUrlMap')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetUrlMap.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetHttpsProxies.setUrlMap',
        ordered_params=['project', 'targetHttpsProxy'],
        path_params=['project', 'targetHttpsProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/targetHttpsProxies/{targetHttpsProxy}/setUrlMap',
        request_field='urlMapReference',
        request_type_name='ComputeTargetHttpsProxiesSetUrlMapRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeTargetHttpsProxiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetHttpsProxies.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/targetHttpsProxies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeTargetHttpsProxiesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class TargetInstancesService(base_api.BaseApiService):
    """Service class for the targetInstances resource."""

    _NAME = 'targetInstances'

    def __init__(self, client):
      super(ComputeBeta.TargetInstancesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of target instances.

      Args:
        request: (ComputeTargetInstancesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetInstanceAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetInstances.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/targetInstances',
        request_field='',
        request_type_name='ComputeTargetInstancesAggregatedListRequest',
        response_type_name='TargetInstanceAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetInstance resource.

      Args:
        request: (ComputeTargetInstancesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.targetInstances.delete',
        ordered_params=['project', 'zone', 'targetInstance'],
        path_params=['project', 'targetInstance', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/targetInstances/{targetInstance}',
        request_field='',
        request_type_name='ComputeTargetInstancesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetInstance resource. Gets a list of available target instances by making a list() request.

      Args:
        request: (ComputeTargetInstancesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetInstance) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetInstances.get',
        ordered_params=['project', 'zone', 'targetInstance'],
        path_params=['project', 'targetInstance', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/targetInstances/{targetInstance}',
        request_field='',
        request_type_name='ComputeTargetInstancesGetRequest',
        response_type_name='TargetInstance',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetInstance resource in the specified project and zone using the data included in the request.

      Args:
        request: (ComputeTargetInstancesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetInstances.insert',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['requestId'],
        relative_path='projects/{project}/zones/{zone}/targetInstances',
        request_field='targetInstance',
        request_type_name='ComputeTargetInstancesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of TargetInstance resources available to the specified project and zone.

      Args:
        request: (ComputeTargetInstancesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetInstanceList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetInstances.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/targetInstances',
        request_field='',
        request_type_name='ComputeTargetInstancesListRequest',
        response_type_name='TargetInstanceList',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeTargetInstancesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetInstances.testIamPermissions',
        ordered_params=['project', 'zone', 'resource'],
        path_params=['project', 'resource', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/targetInstances/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeTargetInstancesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class TargetPoolsService(base_api.BaseApiService):
    """Service class for the targetPools resource."""

    _NAME = 'targetPools'

    def __init__(self, client):
      super(ComputeBeta.TargetPoolsService, self).__init__(client)
      self._upload_configs = {
          }

    def AddHealthCheck(self, request, global_params=None):
      r"""Adds health check URLs to a target pool.

      Args:
        request: (ComputeTargetPoolsAddHealthCheckRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddHealthCheck')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddHealthCheck.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetPools.addHealthCheck',
        ordered_params=['project', 'region', 'targetPool'],
        path_params=['project', 'region', 'targetPool'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetPools/{targetPool}/addHealthCheck',
        request_field='targetPoolsAddHealthCheckRequest',
        request_type_name='ComputeTargetPoolsAddHealthCheckRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AddInstance(self, request, global_params=None):
      r"""Adds an instance to a target pool.

      Args:
        request: (ComputeTargetPoolsAddInstanceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('AddInstance')
      return self._RunMethod(
          config, request, global_params=global_params)

    AddInstance.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetPools.addInstance',
        ordered_params=['project', 'region', 'targetPool'],
        path_params=['project', 'region', 'targetPool'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetPools/{targetPool}/addInstance',
        request_field='targetPoolsAddInstanceRequest',
        request_type_name='ComputeTargetPoolsAddInstanceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of target pools.

      Args:
        request: (ComputeTargetPoolsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetPoolAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetPools.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/targetPools',
        request_field='',
        request_type_name='ComputeTargetPoolsAggregatedListRequest',
        response_type_name='TargetPoolAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified target pool.

      Args:
        request: (ComputeTargetPoolsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.targetPools.delete',
        ordered_params=['project', 'region', 'targetPool'],
        path_params=['project', 'region', 'targetPool'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetPools/{targetPool}',
        request_field='',
        request_type_name='ComputeTargetPoolsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified target pool. Gets a list of available target pools by making a list() request.

      Args:
        request: (ComputeTargetPoolsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetPool) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetPools.get',
        ordered_params=['project', 'region', 'targetPool'],
        path_params=['project', 'region', 'targetPool'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/targetPools/{targetPool}',
        request_field='',
        request_type_name='ComputeTargetPoolsGetRequest',
        response_type_name='TargetPool',
        supports_download=False,
    )

    def GetHealth(self, request, global_params=None):
      r"""Gets the most recent health check results for each IP for the instance that is referenced by the given target pool.

      Args:
        request: (ComputeTargetPoolsGetHealthRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetPoolInstanceHealth) The response message.
      """
      config = self.GetMethodConfig('GetHealth')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetHealth.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetPools.getHealth',
        ordered_params=['project', 'region', 'targetPool'],
        path_params=['project', 'region', 'targetPool'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/targetPools/{targetPool}/getHealth',
        request_field='instanceReference',
        request_type_name='ComputeTargetPoolsGetHealthRequest',
        response_type_name='TargetPoolInstanceHealth',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a target pool in the specified project and region using the data included in the request.

      Args:
        request: (ComputeTargetPoolsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetPools.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetPools',
        request_field='targetPool',
        request_type_name='ComputeTargetPoolsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of target pools available to the specified project and region.

      Args:
        request: (ComputeTargetPoolsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetPoolList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetPools.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/targetPools',
        request_field='',
        request_type_name='ComputeTargetPoolsListRequest',
        response_type_name='TargetPoolList',
        supports_download=False,
    )

    def RemoveHealthCheck(self, request, global_params=None):
      r"""Removes health check URL from a target pool.

      Args:
        request: (ComputeTargetPoolsRemoveHealthCheckRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveHealthCheck')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveHealthCheck.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetPools.removeHealthCheck',
        ordered_params=['project', 'region', 'targetPool'],
        path_params=['project', 'region', 'targetPool'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetPools/{targetPool}/removeHealthCheck',
        request_field='targetPoolsRemoveHealthCheckRequest',
        request_type_name='ComputeTargetPoolsRemoveHealthCheckRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RemoveInstance(self, request, global_params=None):
      r"""Removes instance URL from a target pool.

      Args:
        request: (ComputeTargetPoolsRemoveInstanceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RemoveInstance')
      return self._RunMethod(
          config, request, global_params=global_params)

    RemoveInstance.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetPools.removeInstance',
        ordered_params=['project', 'region', 'targetPool'],
        path_params=['project', 'region', 'targetPool'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetPools/{targetPool}/removeInstance',
        request_field='targetPoolsRemoveInstanceRequest',
        request_type_name='ComputeTargetPoolsRemoveInstanceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetBackup(self, request, global_params=None):
      r"""Changes a backup target pool's configurations.

      Args:
        request: (ComputeTargetPoolsSetBackupRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetBackup')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetBackup.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetPools.setBackup',
        ordered_params=['project', 'region', 'targetPool'],
        path_params=['project', 'region', 'targetPool'],
        query_params=['failoverRatio', 'requestId'],
        relative_path='projects/{project}/regions/{region}/targetPools/{targetPool}/setBackup',
        request_field='targetReference',
        request_type_name='ComputeTargetPoolsSetBackupRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeTargetPoolsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetPools.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/targetPools/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeTargetPoolsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class TargetSslProxiesService(base_api.BaseApiService):
    """Service class for the targetSslProxies resource."""

    _NAME = 'targetSslProxies'

    def __init__(self, client):
      super(ComputeBeta.TargetSslProxiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetSslProxy resource.

      Args:
        request: (ComputeTargetSslProxiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.targetSslProxies.delete',
        ordered_params=['project', 'targetSslProxy'],
        path_params=['project', 'targetSslProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetSslProxies/{targetSslProxy}',
        request_field='',
        request_type_name='ComputeTargetSslProxiesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetSslProxy resource. Gets a list of available target SSL proxies by making a list() request.

      Args:
        request: (ComputeTargetSslProxiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetSslProxy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetSslProxies.get',
        ordered_params=['project', 'targetSslProxy'],
        path_params=['project', 'targetSslProxy'],
        query_params=[],
        relative_path='projects/{project}/global/targetSslProxies/{targetSslProxy}',
        request_field='',
        request_type_name='ComputeTargetSslProxiesGetRequest',
        response_type_name='TargetSslProxy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetSslProxy resource in the specified project using the data included in the request.

      Args:
        request: (ComputeTargetSslProxiesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetSslProxies.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetSslProxies',
        request_field='targetSslProxy',
        request_type_name='ComputeTargetSslProxiesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of TargetSslProxy resources available to the specified project.

      Args:
        request: (ComputeTargetSslProxiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetSslProxyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetSslProxies.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/targetSslProxies',
        request_field='',
        request_type_name='ComputeTargetSslProxiesListRequest',
        response_type_name='TargetSslProxyList',
        supports_download=False,
    )

    def SetBackendService(self, request, global_params=None):
      r"""Changes the BackendService for TargetSslProxy.

      Args:
        request: (ComputeTargetSslProxiesSetBackendServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetBackendService')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetBackendService.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetSslProxies.setBackendService',
        ordered_params=['project', 'targetSslProxy'],
        path_params=['project', 'targetSslProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetSslProxies/{targetSslProxy}/setBackendService',
        request_field='targetSslProxiesSetBackendServiceRequest',
        request_type_name='ComputeTargetSslProxiesSetBackendServiceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetCertificateMap(self, request, global_params=None):
      r"""Changes the Certificate Map for TargetSslProxy.

      Args:
        request: (ComputeTargetSslProxiesSetCertificateMapRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetCertificateMap')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetCertificateMap.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetSslProxies.setCertificateMap',
        ordered_params=['project', 'targetSslProxy'],
        path_params=['project', 'targetSslProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetSslProxies/{targetSslProxy}/setCertificateMap',
        request_field='targetSslProxiesSetCertificateMapRequest',
        request_type_name='ComputeTargetSslProxiesSetCertificateMapRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetProxyHeader(self, request, global_params=None):
      r"""Changes the ProxyHeaderType for TargetSslProxy.

      Args:
        request: (ComputeTargetSslProxiesSetProxyHeaderRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetProxyHeader')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetProxyHeader.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetSslProxies.setProxyHeader',
        ordered_params=['project', 'targetSslProxy'],
        path_params=['project', 'targetSslProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetSslProxies/{targetSslProxy}/setProxyHeader',
        request_field='targetSslProxiesSetProxyHeaderRequest',
        request_type_name='ComputeTargetSslProxiesSetProxyHeaderRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetSslCertificates(self, request, global_params=None):
      r"""Changes SslCertificates for TargetSslProxy.

      Args:
        request: (ComputeTargetSslProxiesSetSslCertificatesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSslCertificates')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSslCertificates.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetSslProxies.setSslCertificates',
        ordered_params=['project', 'targetSslProxy'],
        path_params=['project', 'targetSslProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetSslProxies/{targetSslProxy}/setSslCertificates',
        request_field='targetSslProxiesSetSslCertificatesRequest',
        request_type_name='ComputeTargetSslProxiesSetSslCertificatesRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetSslPolicy(self, request, global_params=None):
      r"""Sets the SSL policy for TargetSslProxy. The SSL policy specifies the server-side support for SSL features. This affects connections between clients and the SSL proxy load balancer. They do not affect the connection between the load balancer and the backends.

      Args:
        request: (ComputeTargetSslProxiesSetSslPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetSslPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSslPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetSslProxies.setSslPolicy',
        ordered_params=['project', 'targetSslProxy'],
        path_params=['project', 'targetSslProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetSslProxies/{targetSslProxy}/setSslPolicy',
        request_field='sslPolicyReference',
        request_type_name='ComputeTargetSslProxiesSetSslPolicyRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeTargetSslProxiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetSslProxies.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/targetSslProxies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeTargetSslProxiesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class TargetTcpProxiesService(base_api.BaseApiService):
    """Service class for the targetTcpProxies resource."""

    _NAME = 'targetTcpProxies'

    def __init__(self, client):
      super(ComputeBeta.TargetTcpProxiesService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all TargetTcpProxy resources, regional and global, available to the specified project.

      Args:
        request: (ComputeTargetTcpProxiesAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetTcpProxyAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetTcpProxies.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/targetTcpProxies',
        request_field='',
        request_type_name='ComputeTargetTcpProxiesAggregatedListRequest',
        response_type_name='TargetTcpProxyAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified TargetTcpProxy resource.

      Args:
        request: (ComputeTargetTcpProxiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.targetTcpProxies.delete',
        ordered_params=['project', 'targetTcpProxy'],
        path_params=['project', 'targetTcpProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetTcpProxies/{targetTcpProxy}',
        request_field='',
        request_type_name='ComputeTargetTcpProxiesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified TargetTcpProxy resource. Gets a list of available target TCP proxies by making a list() request.

      Args:
        request: (ComputeTargetTcpProxiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetTcpProxy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetTcpProxies.get',
        ordered_params=['project', 'targetTcpProxy'],
        path_params=['project', 'targetTcpProxy'],
        query_params=[],
        relative_path='projects/{project}/global/targetTcpProxies/{targetTcpProxy}',
        request_field='',
        request_type_name='ComputeTargetTcpProxiesGetRequest',
        response_type_name='TargetTcpProxy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a TargetTcpProxy resource in the specified project using the data included in the request.

      Args:
        request: (ComputeTargetTcpProxiesInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetTcpProxies.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetTcpProxies',
        request_field='targetTcpProxy',
        request_type_name='ComputeTargetTcpProxiesInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of TargetTcpProxy resources available to the specified project.

      Args:
        request: (ComputeTargetTcpProxiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetTcpProxyList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetTcpProxies.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/targetTcpProxies',
        request_field='',
        request_type_name='ComputeTargetTcpProxiesListRequest',
        response_type_name='TargetTcpProxyList',
        supports_download=False,
    )

    def SetBackendService(self, request, global_params=None):
      r"""Changes the BackendService for TargetTcpProxy.

      Args:
        request: (ComputeTargetTcpProxiesSetBackendServiceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetBackendService')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetBackendService.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetTcpProxies.setBackendService',
        ordered_params=['project', 'targetTcpProxy'],
        path_params=['project', 'targetTcpProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetTcpProxies/{targetTcpProxy}/setBackendService',
        request_field='targetTcpProxiesSetBackendServiceRequest',
        request_type_name='ComputeTargetTcpProxiesSetBackendServiceRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetProxyHeader(self, request, global_params=None):
      r"""Changes the ProxyHeaderType for TargetTcpProxy.

      Args:
        request: (ComputeTargetTcpProxiesSetProxyHeaderRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetProxyHeader')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetProxyHeader.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetTcpProxies.setProxyHeader',
        ordered_params=['project', 'targetTcpProxy'],
        path_params=['project', 'targetTcpProxy'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/targetTcpProxies/{targetTcpProxy}/setProxyHeader',
        request_field='targetTcpProxiesSetProxyHeaderRequest',
        request_type_name='ComputeTargetTcpProxiesSetProxyHeaderRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeTargetTcpProxiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetTcpProxies.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/targetTcpProxies/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeTargetTcpProxiesTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class TargetVpnGatewaysService(base_api.BaseApiService):
    """Service class for the targetVpnGateways resource."""

    _NAME = 'targetVpnGateways'

    def __init__(self, client):
      super(ComputeBeta.TargetVpnGatewaysService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of target VPN gateways.

      Args:
        request: (ComputeTargetVpnGatewaysAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetVpnGatewayAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetVpnGateways.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/targetVpnGateways',
        request_field='',
        request_type_name='ComputeTargetVpnGatewaysAggregatedListRequest',
        response_type_name='TargetVpnGatewayAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified target VPN gateway.

      Args:
        request: (ComputeTargetVpnGatewaysDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.targetVpnGateways.delete',
        ordered_params=['project', 'region', 'targetVpnGateway'],
        path_params=['project', 'region', 'targetVpnGateway'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetVpnGateways/{targetVpnGateway}',
        request_field='',
        request_type_name='ComputeTargetVpnGatewaysDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified target VPN gateway. Gets a list of available target VPN gateways by making a list() request.

      Args:
        request: (ComputeTargetVpnGatewaysGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetVpnGateway) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetVpnGateways.get',
        ordered_params=['project', 'region', 'targetVpnGateway'],
        path_params=['project', 'region', 'targetVpnGateway'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/targetVpnGateways/{targetVpnGateway}',
        request_field='',
        request_type_name='ComputeTargetVpnGatewaysGetRequest',
        response_type_name='TargetVpnGateway',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a target VPN gateway in the specified project and region using the data included in the request.

      Args:
        request: (ComputeTargetVpnGatewaysInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetVpnGateways.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetVpnGateways',
        request_field='targetVpnGateway',
        request_type_name='ComputeTargetVpnGatewaysInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of target VPN gateways available to the specified project and region.

      Args:
        request: (ComputeTargetVpnGatewaysListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TargetVpnGatewayList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.targetVpnGateways.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/targetVpnGateways',
        request_field='',
        request_type_name='ComputeTargetVpnGatewaysListRequest',
        response_type_name='TargetVpnGatewayList',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a TargetVpnGateway. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeTargetVpnGatewaysSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetVpnGateways.setLabels',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/targetVpnGateways/{resource}/setLabels',
        request_field='regionSetLabelsRequest',
        request_type_name='ComputeTargetVpnGatewaysSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeTargetVpnGatewaysTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.targetVpnGateways.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/targetVpnGateways/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeTargetVpnGatewaysTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class UrlMapsService(base_api.BaseApiService):
    """Service class for the urlMaps resource."""

    _NAME = 'urlMaps'

    def __init__(self, client):
      super(ComputeBeta.UrlMapsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves the list of all UrlMap resources, regional and global, available to the specified project.

      Args:
        request: (ComputeUrlMapsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UrlMapsAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.urlMaps.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/urlMaps',
        request_field='',
        request_type_name='ComputeUrlMapsAggregatedListRequest',
        response_type_name='UrlMapsAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified UrlMap resource.

      Args:
        request: (ComputeUrlMapsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.urlMaps.delete',
        ordered_params=['project', 'urlMap'],
        path_params=['project', 'urlMap'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/urlMaps/{urlMap}',
        request_field='',
        request_type_name='ComputeUrlMapsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified UrlMap resource. Gets a list of available URL maps by making a list() request.

      Args:
        request: (ComputeUrlMapsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UrlMap) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.urlMaps.get',
        ordered_params=['project', 'urlMap'],
        path_params=['project', 'urlMap'],
        query_params=[],
        relative_path='projects/{project}/global/urlMaps/{urlMap}',
        request_field='',
        request_type_name='ComputeUrlMapsGetRequest',
        response_type_name='UrlMap',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a UrlMap resource in the specified project using the data included in the request.

      Args:
        request: (ComputeUrlMapsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.urlMaps.insert',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/urlMaps',
        request_field='urlMap',
        request_type_name='ComputeUrlMapsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def InvalidateCache(self, request, global_params=None):
      r"""Initiates a cache invalidation operation, invalidating the specified path, scoped to the specified UrlMap. For more information, see [Invalidating cached content](/cdn/docs/invalidating-cached-content).

      Args:
        request: (ComputeUrlMapsInvalidateCacheRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('InvalidateCache')
      return self._RunMethod(
          config, request, global_params=global_params)

    InvalidateCache.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.urlMaps.invalidateCache',
        ordered_params=['project', 'urlMap'],
        path_params=['project', 'urlMap'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/urlMaps/{urlMap}/invalidateCache',
        request_field='cacheInvalidationRule',
        request_type_name='ComputeUrlMapsInvalidateCacheRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of UrlMap resources available to the specified project.

      Args:
        request: (ComputeUrlMapsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UrlMapList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.urlMaps.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/global/urlMaps',
        request_field='',
        request_type_name='ComputeUrlMapsListRequest',
        response_type_name='UrlMapList',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the specified UrlMap resource with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.

      Args:
        request: (ComputeUrlMapsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='compute.urlMaps.patch',
        ordered_params=['project', 'urlMap'],
        path_params=['project', 'urlMap'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/urlMaps/{urlMap}',
        request_field='urlMapResource',
        request_type_name='ComputeUrlMapsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeUrlMapsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.urlMaps.testIamPermissions',
        ordered_params=['project', 'resource'],
        path_params=['project', 'resource'],
        query_params=[],
        relative_path='projects/{project}/global/urlMaps/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeUrlMapsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the specified UrlMap resource with the data included in the request.

      Args:
        request: (ComputeUrlMapsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='compute.urlMaps.update',
        ordered_params=['project', 'urlMap'],
        path_params=['project', 'urlMap'],
        query_params=['requestId'],
        relative_path='projects/{project}/global/urlMaps/{urlMap}',
        request_field='urlMapResource',
        request_type_name='ComputeUrlMapsUpdateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Validate(self, request, global_params=None):
      r"""Runs static validation for the UrlMap. In particular, the tests of the provided UrlMap will be run. Calling this method does NOT create the UrlMap.

      Args:
        request: (ComputeUrlMapsValidateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UrlMapsValidateResponse) The response message.
      """
      config = self.GetMethodConfig('Validate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Validate.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.urlMaps.validate',
        ordered_params=['project', 'urlMap'],
        path_params=['project', 'urlMap'],
        query_params=[],
        relative_path='projects/{project}/global/urlMaps/{urlMap}/validate',
        request_field='urlMapsValidateRequest',
        request_type_name='ComputeUrlMapsValidateRequest',
        response_type_name='UrlMapsValidateResponse',
        supports_download=False,
    )

  class VpnGatewaysService(base_api.BaseApiService):
    """Service class for the vpnGateways resource."""

    _NAME = 'vpnGateways'

    def __init__(self, client):
      super(ComputeBeta.VpnGatewaysService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of VPN gateways.

      Args:
        request: (ComputeVpnGatewaysAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VpnGatewayAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.vpnGateways.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/vpnGateways',
        request_field='',
        request_type_name='ComputeVpnGatewaysAggregatedListRequest',
        response_type_name='VpnGatewayAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified VPN gateway.

      Args:
        request: (ComputeVpnGatewaysDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.vpnGateways.delete',
        ordered_params=['project', 'region', 'vpnGateway'],
        path_params=['project', 'region', 'vpnGateway'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/vpnGateways/{vpnGateway}',
        request_field='',
        request_type_name='ComputeVpnGatewaysDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified VPN gateway. Gets a list of available VPN gateways by making a list() request.

      Args:
        request: (ComputeVpnGatewaysGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VpnGateway) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.vpnGateways.get',
        ordered_params=['project', 'region', 'vpnGateway'],
        path_params=['project', 'region', 'vpnGateway'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/vpnGateways/{vpnGateway}',
        request_field='',
        request_type_name='ComputeVpnGatewaysGetRequest',
        response_type_name='VpnGateway',
        supports_download=False,
    )

    def GetStatus(self, request, global_params=None):
      r"""Returns the status for the specified VPN gateway.

      Args:
        request: (ComputeVpnGatewaysGetStatusRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VpnGatewaysGetStatusResponse) The response message.
      """
      config = self.GetMethodConfig('GetStatus')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetStatus.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.vpnGateways.getStatus',
        ordered_params=['project', 'region', 'vpnGateway'],
        path_params=['project', 'region', 'vpnGateway'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/vpnGateways/{vpnGateway}/getStatus',
        request_field='',
        request_type_name='ComputeVpnGatewaysGetStatusRequest',
        response_type_name='VpnGatewaysGetStatusResponse',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a VPN gateway in the specified project and region using the data included in the request.

      Args:
        request: (ComputeVpnGatewaysInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.vpnGateways.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/vpnGateways',
        request_field='vpnGateway',
        request_type_name='ComputeVpnGatewaysInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of VPN gateways available to the specified project and region.

      Args:
        request: (ComputeVpnGatewaysListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VpnGatewayList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.vpnGateways.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/vpnGateways',
        request_field='',
        request_type_name='ComputeVpnGatewaysListRequest',
        response_type_name='VpnGatewayList',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a VpnGateway. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeVpnGatewaysSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.vpnGateways.setLabels',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/vpnGateways/{resource}/setLabels',
        request_field='regionSetLabelsRequest',
        request_type_name='ComputeVpnGatewaysSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeVpnGatewaysTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.vpnGateways.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/vpnGateways/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeVpnGatewaysTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class VpnTunnelsService(base_api.BaseApiService):
    """Service class for the vpnTunnels resource."""

    _NAME = 'vpnTunnels'

    def __init__(self, client):
      super(ComputeBeta.VpnTunnelsService, self).__init__(client)
      self._upload_configs = {
          }

    def AggregatedList(self, request, global_params=None):
      r"""Retrieves an aggregated list of VPN tunnels.

      Args:
        request: (ComputeVpnTunnelsAggregatedListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VpnTunnelAggregatedList) The response message.
      """
      config = self.GetMethodConfig('AggregatedList')
      return self._RunMethod(
          config, request, global_params=global_params)

    AggregatedList.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.vpnTunnels.aggregatedList',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'includeAllScopes', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/aggregated/vpnTunnels',
        request_field='',
        request_type_name='ComputeVpnTunnelsAggregatedListRequest',
        response_type_name='VpnTunnelAggregatedList',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified VpnTunnel resource.

      Args:
        request: (ComputeVpnTunnelsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.vpnTunnels.delete',
        ordered_params=['project', 'region', 'vpnTunnel'],
        path_params=['project', 'region', 'vpnTunnel'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/vpnTunnels/{vpnTunnel}',
        request_field='',
        request_type_name='ComputeVpnTunnelsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the specified VpnTunnel resource. Gets a list of available VPN tunnels by making a list() request.

      Args:
        request: (ComputeVpnTunnelsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VpnTunnel) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.vpnTunnels.get',
        ordered_params=['project', 'region', 'vpnTunnel'],
        path_params=['project', 'region', 'vpnTunnel'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/vpnTunnels/{vpnTunnel}',
        request_field='',
        request_type_name='ComputeVpnTunnelsGetRequest',
        response_type_name='VpnTunnel',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a VpnTunnel resource in the specified project and region using the data included in the request.

      Args:
        request: (ComputeVpnTunnelsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.vpnTunnels.insert',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/vpnTunnels',
        request_field='vpnTunnel',
        request_type_name='ComputeVpnTunnelsInsertRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of VpnTunnel resources contained in the specified project and region.

      Args:
        request: (ComputeVpnTunnelsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VpnTunnelList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.vpnTunnels.list',
        ordered_params=['project', 'region'],
        path_params=['project', 'region'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/regions/{region}/vpnTunnels',
        request_field='',
        request_type_name='ComputeVpnTunnelsListRequest',
        response_type_name='VpnTunnelList',
        supports_download=False,
    )

    def SetLabels(self, request, global_params=None):
      r"""Sets the labels on a VpnTunnel. To learn more about labels, read the Labeling Resources documentation.

      Args:
        request: (ComputeVpnTunnelsSetLabelsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('SetLabels')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetLabels.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.vpnTunnels.setLabels',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=['requestId'],
        relative_path='projects/{project}/regions/{region}/vpnTunnels/{resource}/setLabels',
        request_field='regionSetLabelsRequest',
        request_type_name='ComputeVpnTunnelsSetLabelsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.

      Args:
        request: (ComputeVpnTunnelsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.vpnTunnels.testIamPermissions',
        ordered_params=['project', 'region', 'resource'],
        path_params=['project', 'region', 'resource'],
        query_params=[],
        relative_path='projects/{project}/regions/{region}/vpnTunnels/{resource}/testIamPermissions',
        request_field='testPermissionsRequest',
        request_type_name='ComputeVpnTunnelsTestIamPermissionsRequest',
        response_type_name='TestPermissionsResponse',
        supports_download=False,
    )

  class ZoneOperationsService(base_api.BaseApiService):
    """Service class for the zoneOperations resource."""

    _NAME = 'zoneOperations'

    def __init__(self, client):
      super(ComputeBeta.ZoneOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes the specified zone-specific Operations resource.

      Args:
        request: (ComputeZoneOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ComputeZoneOperationsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='compute.zoneOperations.delete',
        ordered_params=['project', 'zone', 'operation'],
        path_params=['operation', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/operations/{operation}',
        request_field='',
        request_type_name='ComputeZoneOperationsDeleteRequest',
        response_type_name='ComputeZoneOperationsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves the specified zone-specific Operations resource.

      Args:
        request: (ComputeZoneOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.zoneOperations.get',
        ordered_params=['project', 'zone', 'operation'],
        path_params=['operation', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/operations/{operation}',
        request_field='',
        request_type_name='ComputeZoneOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of Operation resources contained within the specified zone.

      Args:
        request: (ComputeZoneOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OperationList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.zoneOperations.list',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones/{zone}/operations',
        request_field='',
        request_type_name='ComputeZoneOperationsListRequest',
        response_type_name='OperationList',
        supports_download=False,
    )

    def Wait(self, request, global_params=None):
      r"""Waits for the specified Operation resource to return as `DONE` or for the request to approach the 2 minute deadline, and retrieves the specified Operation resource. This method waits for no more than the 2 minutes and then returns the current state of the operation, which might be `DONE` or still in progress. This method is called on a best-effort basis. Specifically: - In uncommon cases, when the server is overloaded, the request might return before the default deadline is reached, or might return after zero seconds. - If the default deadline is reached, there is no guarantee that the operation is actually done when the method returns. Be prepared to retry if the operation is not `DONE`. .

      Args:
        request: (ComputeZoneOperationsWaitRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Wait')
      return self._RunMethod(
          config, request, global_params=global_params)

    Wait.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='compute.zoneOperations.wait',
        ordered_params=['project', 'zone', 'operation'],
        path_params=['operation', 'project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}/operations/{operation}/wait',
        request_field='',
        request_type_name='ComputeZoneOperationsWaitRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ZonesService(base_api.BaseApiService):
    """Service class for the zones resource."""

    _NAME = 'zones'

    def __init__(self, client):
      super(ComputeBeta.ZonesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the specified Zone resource. Gets a list of available zones by making a list() request.

      Args:
        request: (ComputeZonesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Zone) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.zones.get',
        ordered_params=['project', 'zone'],
        path_params=['project', 'zone'],
        query_params=[],
        relative_path='projects/{project}/zones/{zone}',
        request_field='',
        request_type_name='ComputeZonesGetRequest',
        response_type_name='Zone',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves the list of Zone resources available to the specified project.

      Args:
        request: (ComputeZonesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ZoneList) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='compute.zones.list',
        ordered_params=['project'],
        path_params=['project'],
        query_params=['filter', 'maxResults', 'orderBy', 'pageToken', 'returnPartialSuccess'],
        relative_path='projects/{project}/zones',
        request_field='',
        request_type_name='ComputeZonesListRequest',
        response_type_name='ZoneList',
        supports_download=False,
    )
