"""Generated message classes for gkeonprem version v1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'gkeonprem'


class Authorization(_messages.Message):
  r"""Authorization defines the On-Prem User Cluster authorization
  configuration to bootstrap onto the admin cluster.

  Fields:
    adminUsers: Required. Users that will be granted the cluster-admin role on
      the cluster, providing full access to the cluster.
  """

  adminUsers = _messages.MessageField('ClusterUser', 1, repeated=True)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class ClusterUser(_messages.Message):
  r"""ClusterUser configures user principals for an RBAC policy.

  Fields:
    username: Required. The name of the user, e.g. `my-gcp-id@gmail.com`.
  """

  username = _messages.StringField(1)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class EnrollVmwareClusterRequest(_messages.Message):
  r"""Message for enrolling an existing VMware Cluster to the GKE on-prem API.

  Fields:
    adminClusterMembership: Required. The admin cluster this VMware User
      Cluster belongs to. This is the full resource name of the admin
      cluster's hub membership. In the future, references to other resource
      types might be allowed if admin clusters are modeled as their own
      resources.
    localName: The object name of the VMware OnPremUserCluster custom resource
      on the associated admin cluster. This field is used to support
      conflicting resource names when enrolling existing clusters to the API.
      When not provided, this field will resolve to the vmware_cluster_id.
      Otherwise, it must match the object name of the VMware OnPremUserCluster
      custom resource. It is not modifiable outside / beyond the enrollment
      operation.
    vmwareClusterId: User provided OnePlatform identifier that is used as part
      of the resource name. This must be unique among all GKE on-prem clusters
      within a project and location and will return a 409 if the cluster
      already exists. This value must be up to 40 characters and follow
      RFC-1123 (https://tools.ietf.org/html/rfc1123) format.
  """

  adminClusterMembership = _messages.StringField(1)
  localName = _messages.StringField(2)
  vmwareClusterId = _messages.StringField(3)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class Fleet(_messages.Message):
  r"""Fleet related configuration. Fleets are a Google Cloud concept for
  logically organizing clusters, letting you use and manage multi-cluster
  capabilities and apply consistent policies across your systems. See [Anthos
  Fleets](https://cloud.google.com/anthos/multicluster-management/fleets) for
  more details on Anthos multi-cluster capabilities using Fleets. ##

  Fields:
    membership: Output only. The name of the managed Hub Membership resource
      associated to this cluster. Membership names are formatted as
      `projects//locations//memberships/`.
  """

  membership = _messages.StringField(1)


class GkeonpremProjectsLocationsBareMetalAdminClustersGetIamPolicyRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsBareMetalAdminClustersGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class GkeonpremProjectsLocationsBareMetalAdminClustersOperationsGetRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsBareMetalAdminClustersOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class GkeonpremProjectsLocationsBareMetalAdminClustersOperationsListRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsBareMetalAdminClustersOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GkeonpremProjectsLocationsBareMetalAdminClustersSetIamPolicyRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsBareMetalAdminClustersSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class GkeonpremProjectsLocationsBareMetalAdminClustersTestIamPermissionsRequest(_messages.Message):
  r"""A
  GkeonpremProjectsLocationsBareMetalAdminClustersTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class GkeonpremProjectsLocationsBareMetalClustersBareMetalNodePoolsGetIamPolicyRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsBareMetalClustersBareMetalNodePoolsGetIamPol
  icyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class GkeonpremProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsGetRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsBareMetalClustersBareMetalNodePoolsOperation
  sGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class GkeonpremProjectsLocationsBareMetalClustersBareMetalNodePoolsOperationsListRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsBareMetalClustersBareMetalNodePoolsOperation
  sListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GkeonpremProjectsLocationsBareMetalClustersBareMetalNodePoolsSetIamPolicyRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsBareMetalClustersBareMetalNodePoolsSetIamPol
  icyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class GkeonpremProjectsLocationsBareMetalClustersBareMetalNodePoolsTestIamPermissionsRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsBareMetalClustersBareMetalNodePoolsTestIamPe
  rmissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class GkeonpremProjectsLocationsBareMetalClustersGetIamPolicyRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsBareMetalClustersGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class GkeonpremProjectsLocationsBareMetalClustersOperationsGetRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsBareMetalClustersOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class GkeonpremProjectsLocationsBareMetalClustersOperationsListRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsBareMetalClustersOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GkeonpremProjectsLocationsBareMetalClustersSetIamPolicyRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsBareMetalClustersSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class GkeonpremProjectsLocationsBareMetalClustersTestIamPermissionsRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsBareMetalClustersTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class GkeonpremProjectsLocationsGetRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class GkeonpremProjectsLocationsListRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GkeonpremProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class GkeonpremProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class GkeonpremProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class GkeonpremProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GkeonpremProjectsLocationsVmwareAdminClustersGetIamPolicyRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareAdminClustersGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class GkeonpremProjectsLocationsVmwareAdminClustersOperationsGetRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareAdminClustersOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class GkeonpremProjectsLocationsVmwareAdminClustersOperationsListRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareAdminClustersOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GkeonpremProjectsLocationsVmwareAdminClustersSetIamPolicyRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareAdminClustersSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class GkeonpremProjectsLocationsVmwareAdminClustersTestIamPermissionsRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareAdminClustersTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class GkeonpremProjectsLocationsVmwareClustersCreateRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareClustersCreateRequest object.

  Fields:
    parent: Required. The parent of the project and location that we are
      creating this cluster in. Format:
      "projects/{project}/locations/{location}"
    validateOnly: Validate the request without actually doing any updates.
    vmwareCluster: A VmwareCluster resource to be passed as the request body.
    vmwareClusterId: User provided identifier that is used as part of the
      resource name; This value must be up to 40 characters and follow
      RFC-1123 (https://tools.ietf.org/html/rfc1123) format.
  """

  parent = _messages.StringField(1, required=True)
  validateOnly = _messages.BooleanField(2)
  vmwareCluster = _messages.MessageField('VmwareCluster', 3)
  vmwareClusterId = _messages.StringField(4)


class GkeonpremProjectsLocationsVmwareClustersDeleteRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareClustersDeleteRequest object.

  Fields:
    allowMissing: If set to true, and the VMware Cluster is not found, the
      request will succeed but no action will be taken on the server and
      return a completed LRO.
    etag: The current etag of the VMware Cluster. If an etag is provided and
      does not match the current etag of the cluster, deletion will be blocked
      and an ABORTED error will be returned.
    force: If set to true, any node pools from the cluster will also be
      deleted.
    name: Required. Name of the VMware User Cluster to be deleted. Format:
      "projects/{project}/locations/{location}/vmwareClusters/{vmware_cluster}
      "
    validateOnly: Validate the request without actually doing any updates.
  """

  allowMissing = _messages.BooleanField(1)
  etag = _messages.StringField(2)
  force = _messages.BooleanField(3)
  name = _messages.StringField(4, required=True)
  validateOnly = _messages.BooleanField(5)


class GkeonpremProjectsLocationsVmwareClustersEnrollRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareClustersEnrollRequest object.

  Fields:
    enrollVmwareClusterRequest: A EnrollVmwareClusterRequest resource to be
      passed as the request body.
    parent: Required. The parent of the project and location that we are
      Enrolling this cluster in. Format:
      "projects/{project}/locations/{location}"
  """

  enrollVmwareClusterRequest = _messages.MessageField('EnrollVmwareClusterRequest', 1)
  parent = _messages.StringField(2, required=True)


class GkeonpremProjectsLocationsVmwareClustersGetIamPolicyRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareClustersGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class GkeonpremProjectsLocationsVmwareClustersGetRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareClustersGetRequest object.

  Fields:
    name: Required. Name of the VMware User Cluster to be returned. Format:
      "projects/{project}/locations/{location}/vmwareClusters/{vmware_cluster}
      "
  """

  name = _messages.StringField(1, required=True)


class GkeonpremProjectsLocationsVmwareClustersListRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareClustersListRequest object.

  Fields:
    filter: A resource filtering expression following
      https://google.aip.dev/160. When non-empty, only resource's whose
      attributes field matches the filter are returned.
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, at most 50 clusters will be returned. The
      maximum value is 1000; values above 1000 will be coerced to 1000.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. The parent of the project and location that we are
      listing existing VMware clusters in. Format:
      "projects/{project}/locations/{location}"
    showDeleted: If true, shows deleted VMware Clusters.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  showDeleted = _messages.BooleanField(5)


class GkeonpremProjectsLocationsVmwareClustersOperationsGetRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareClustersOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class GkeonpremProjectsLocationsVmwareClustersOperationsListRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareClustersOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GkeonpremProjectsLocationsVmwareClustersPatchRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareClustersPatchRequest object.

  Fields:
    allowMissing: If set to true, and the VMware Cluster is not found, the
      request will create a new VMware Cluster with the provided
      configuration. The user must have both create and update permission to
      call Update with allow_missing set to true.
    name: Required. The VMware User Cluster resource name.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the VMwareCluster resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all populated fields in the VmwareCluster
      message will be updated. Empty fields will be ignored unless a field
      mask is used.
    validateOnly: Validate the request without actually doing any updates.
    vmwareCluster: A VmwareCluster resource to be passed as the request body.
  """

  allowMissing = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)
  vmwareCluster = _messages.MessageField('VmwareCluster', 5)


class GkeonpremProjectsLocationsVmwareClustersSetIamPolicyRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareClustersSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class GkeonpremProjectsLocationsVmwareClustersTestIamPermissionsRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareClustersTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class GkeonpremProjectsLocationsVmwareClustersUnenrollRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareClustersUnenrollRequest object.

  Fields:
    allowMissing: If set to true, and the VMware Cluster is not found, the
      request will succeed but no action will be taken on the server and
      return a completed LRO.
    etag: The current etag of the VMware Cluster. If an etag is provided and
      does not match the current etag of the cluster, deletion will be blocked
      and an ABORTED error will be returned.
    force: This is required if the cluster has any associated node pools. When
      set, any child node pools will also be unenrolled.
    name: Required. Name of the VMware User Cluster to be unenrolled. Format:
      "projects/{project}/locations/{location}/vmwareClusters/{vmware_cluster}
      "
    validateOnly: Validate the request without actually doing any updates.
  """

  allowMissing = _messages.BooleanField(1)
  etag = _messages.StringField(2)
  force = _messages.BooleanField(3)
  name = _messages.StringField(4, required=True)
  validateOnly = _messages.BooleanField(5)


class GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsCreateRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsCreateRequest
  object.

  Fields:
    parent: Required. The parent resource where this node pool will be
      created.
      projects/{project}/locations/{location}/vmwareClusters/{cluster}
    validateOnly: If set, only validate the request, but do not actually
      create the node pool.
    vmwareNodePool: A VmwareNodePool resource to be passed as the request
      body.
    vmwareNodePoolId: The ID to use for the node pool, which will become the
      final component of the node pool's resource name. This value must be up
      to 40 characters and follow RFC-1123
      (https://tools.ietf.org/html/rfc1123) format. The value must not be
      permitted to be a UUID (or UUID-like: anything matching
      /^[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}$/i).
  """

  parent = _messages.StringField(1, required=True)
  validateOnly = _messages.BooleanField(2)
  vmwareNodePool = _messages.MessageField('VmwareNodePool', 3)
  vmwareNodePoolId = _messages.StringField(4)


class GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsDeleteRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsDeleteRequest
  object.

  Fields:
    allowMissing: If set to true, and the Vmware Node Pool is not found, the
      request will succeed but no action will be taken on the server and
      return a completed LRO.
    etag: The current etag of the VmwareNodePool. If an etag is provided and
      does not match the current etag of the node pool, deletion will be
      blocked and an ABORTED error will be returned.
    name: Required. The name of the node pool to delete. Format: projects/{pro
      ject}/locations/{location}/vmwareClusters/{cluster}/vmwareNodePools/{nod
      epool}
    validateOnly: If set, only validate the request, but do not actually
      delete the node pool.
  """

  allowMissing = _messages.BooleanField(1)
  etag = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  validateOnly = _messages.BooleanField(4)


class GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsGetIamPolicyRequest(_messages.Message):
  r"""A
  GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsGetRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsGetRequest
  object.

  Fields:
    name: Required. The name of the node pool to retrieve. projects/{project}/
      locations/{location}/vmwareClusters/{cluster}/vmwareNodePools/{nodepool}
  """

  name = _messages.StringField(1, required=True)


class GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsListRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsListRequest
  object.

  Fields:
    pageSize: The maximum number of node pools to return. The service may
      return fewer than this value. If unspecified, at most 50 node pools will
      be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: A page token, received from a previous `ListVmwareNodePools`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListVmwareNodePools` must match the call
      that provided the page token.
    parent: Required. The parent, which owns this collection of node pools.
      Format:
      projects/{project}/locations/{location}/vmwareClusters/{vmwareCluster}
    showDeleted: If true, shows deleted VMware Node Pools.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  showDeleted = _messages.BooleanField(4)


class GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsOperationsGetRequest(_messages.Message):
  r"""A
  GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListRequest(_messages.Message):
  r"""A
  GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsPatchRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsPatchRequest
  object.

  Fields:
    allowMissing: If set to true, and the VMware Node Pool is not found, the
      request will create a new VMware Node Pool with the provided
      configuration. The user must have both create and update permission to
      call Update with allow_missing set to true.
    name: Required. The resource name of this node pool.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the VMwareNodePool resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all populated fields in the VMwareNodePool
      message will be updated. Empty fields will be ignored unless a field
      mask is used.
    validateOnly: Validate the request without actually doing any updates.
    vmwareNodePool: A VmwareNodePool resource to be passed as the request
      body.
  """

  allowMissing = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)
  vmwareNodePool = _messages.MessageField('VmwareNodePool', 5)


class GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsSetIamPolicyRequest(_messages.Message):
  r"""A
  GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsTestIamPermissionsRequest(_messages.Message):
  r"""A GkeonpremProjectsLocationsVmwareClustersVmwareNodePoolsTestIamPermissi
  onsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListVmwareClustersResponse(_messages.Message):
  r"""Response message for listing VMware Clusters.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return. If the token is not empty this means that more results are
      available and should be retrieved by repeating the request with the
      provided page token.
    unreachable: Locations that could not be reached.
    vmwareClusters: The list of VMware Cluster.
  """

  nextPageToken = _messages.StringField(1)
  unreachable = _messages.StringField(2, repeated=True)
  vmwareClusters = _messages.MessageField('VmwareCluster', 3, repeated=True)


class ListVmwareNodePoolsResponse(_messages.Message):
  r"""Response message for listing VMware Node Pools.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    unreachable: Locations that could not be reached.
    vmwareNodePools: The node pools from the specified parent resource.
  """

  nextPageToken = _messages.StringField(1)
  unreachable = _messages.StringField(2, repeated=True)
  vmwareNodePools = _messages.MessageField('VmwareNodePool', 3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class NodeTaint(_messages.Message):
  r"""NodeTaint applied to every Kubernetes node in a node pool. Kubernetes
  taints can be used together with tolerations to control how workloads are
  scheduled to your nodes. Node taints are permanent.

  Enums:
    EffectValueValuesEnum: The taint effect.

  Fields:
    effect: The taint effect.
    key: Key associated with the effect.
    value: Value associated with the effect.
  """

  class EffectValueValuesEnum(_messages.Enum):
    r"""The taint effect.

    Values:
      EFFECT_UNSPECIFIED: Not set.
      NO_SCHEDULE: Do not allow new pods to schedule onto the node unless they
        tolerate the taint, but allow all pods submitted to Kubelet without
        going through the scheduler to start, and allow all already-running
        pods to continue running. Enforced by the scheduler.
      PREFER_NO_SCHEDULE: Like TaintEffectNoSchedule, but the scheduler tries
        not to schedule new pods onto the node, rather than prohibiting new
        pods from scheduling onto the node entirely. Enforced by the
        scheduler.
      NO_EXECUTE: Evict any already-running pods that do not tolerate the
        taint. Currently enforced by NodeController.
    """
    EFFECT_UNSPECIFIED = 0
    NO_SCHEDULE = 1
    PREFER_NO_SCHEDULE = 2
    NO_EXECUTE = 3

  effect = _messages.EnumField('EffectValueValuesEnum', 1)
  key = _messages.StringField(2)
  value = _messages.StringField(3)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  bindings = _messages.MessageField('Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class ResourceCondition(_messages.Message):
  r"""ResourceCondition provides a standard mechanism for higher-level status
  reporting from user cluster controller.

  Enums:
    StateValueValuesEnum: state of the condition.

  Fields:
    lastTransitionTime: Last time the condition transit from one status to
      another.
    message: Human-readable message indicating details about last transition.
    reason: Machine-readable message indicating details about last transition.
    state: state of the condition.
    type: Type of the condition. (e.g., ClusterRunning, NodePoolRunning or
      ServerSidePreflightReady)
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""state of the condition.

    Values:
      STATE_UNSPECIFIED: Not set.
      STATE_TRUE: Resource is in the condition.
      STATE_FALSE: Resource is not in the condition.
      STATE_UNKNOWN: Kubernetes controller can't decide if the resource is in
        the condition or not.
    """
    STATE_UNSPECIFIED = 0
    STATE_TRUE = 1
    STATE_FALSE = 2
    STATE_UNKNOWN = 3

  lastTransitionTime = _messages.StringField(1)
  message = _messages.StringField(2)
  reason = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  type = _messages.StringField(5)


class ResourceStatus(_messages.Message):
  r"""ResourceStatus describes why a cluster or node pool has a certain
  status. (e.g., ERROR or DEGRADED).

  Fields:
    conditions: ResourceCondition provide a standard mechanism for higher-
      level status reporting from user cluster controller.
    errorMessage: Human-friendly representation of the error message from the
      user cluster controller. The error message can be temporary as the user
      cluster controller creates a cluster or node pool. If the error message
      persists for a longer period of time, it can be used to surface error
      message to indicate real problems requiring user intervention.
  """

  conditions = _messages.MessageField('ResourceCondition', 1, repeated=True)
  errorMessage = _messages.StringField(2)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
  """

  policy = _messages.MessageField('Policy', 1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class ValidationCheck(_messages.Message):
  r"""ValidationCheck represents the result of preflight check.

  Enums:
    OptionValueValuesEnum: Options used for the validation check
    ScenarioValueValuesEnum: Output only. The scenario when the preflight
      checks were run.

  Fields:
    option: Options used for the validation check
    scenario: Output only. The scenario when the preflight checks were run.
    status: Output only. The detailed validation check status.
  """

  class OptionValueValuesEnum(_messages.Enum):
    r"""Options used for the validation check

    Values:
      OPTIONS_UNSPECIFIED: Default value. Standard preflight validation check
        will be used.
      SKIP_VALIDATION_CHECK_BLOCKING: Prevent failed preflight checks from
        failing.
      SKIP_VALIDATION_ALL: Skip all preflight check validations.
    """
    OPTIONS_UNSPECIFIED = 0
    SKIP_VALIDATION_CHECK_BLOCKING = 1
    SKIP_VALIDATION_ALL = 2

  class ScenarioValueValuesEnum(_messages.Enum):
    r"""Output only. The scenario when the preflight checks were run.

    Values:
      SCENARIO_UNSPECIFIED: Default value. This value is unused.
      CREATE: The validation check occurred during an create flow.
      UPDATE: The validation check occurred during an update flow.
    """
    SCENARIO_UNSPECIFIED = 0
    CREATE = 1
    UPDATE = 2

  option = _messages.EnumField('OptionValueValuesEnum', 1)
  scenario = _messages.EnumField('ScenarioValueValuesEnum', 2)
  status = _messages.MessageField('ValidationCheckStatus', 3)


class ValidationCheckResult(_messages.Message):
  r"""ValidationCheckResult defines the details about the validation check.

  Enums:
    StateValueValuesEnum: The validation check state.

  Fields:
    category: The category of the validation.
    description: The description of the validation check.
    details: Detailed failure information, which might be unformatted.
    reason: A human-readable message of the check failure.
    state: The validation check state.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The validation check state.

    Values:
      STATE_UNKNOWN: The default value. The check result is unknown.
      STATE_FAILURE: The check failed.
      STATE_SKIPPED: The check was skipped.
      STATE_FATAL: The check itself failed to complete.
      STATE_WARNING: The check encountered a warning.
    """
    STATE_UNKNOWN = 0
    STATE_FAILURE = 1
    STATE_SKIPPED = 2
    STATE_FATAL = 3
    STATE_WARNING = 4

  category = _messages.StringField(1)
  description = _messages.StringField(2)
  details = _messages.StringField(3)
  reason = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class ValidationCheckStatus(_messages.Message):
  r"""ValidationCheckStatus defines the detailed validation check status.

  Fields:
    result: Individual checks which failed as part of the Preflight check
      execution.
  """

  result = _messages.MessageField('ValidationCheckResult', 1, repeated=True)


class VmwareAAGConfig(_messages.Message):
  r"""VmwareAAGConfig specifies anti affinity group config for VMware User
  Cluster.

  Fields:
    aagConfigDisabled: Spread nodes across at least three physical hosts
      (requires at least three hosts). Enabled by default.
  """

  aagConfigDisabled = _messages.BooleanField(1)


class VmwareAddressPool(_messages.Message):
  r"""VmwareAddressPool represents an IP pool used by a load balancer.

  Fields:
    addresses: Required. The addresses that are part of this pool. Each
      address must be either in the CIDR form (1.2.3.0/24) or range form
      (1.2.3.1-1.2.3.5).
    avoidBuggyIps: If true, avoid using IPs ending in .0 or .255. This avoids
      buggy consumer devices mistakenly dropping IPv4 traffic for those
      special IP addresses.
    manualAssign: If true, prevent IP addresses from being automatically
      assigned.
    pool: Required. The name of the address pool.
  """

  addresses = _messages.StringField(1, repeated=True)
  avoidBuggyIps = _messages.BooleanField(2)
  manualAssign = _messages.BooleanField(3)
  pool = _messages.StringField(4)


class VmwareAutoRepairConfig(_messages.Message):
  r"""VmwareAutoRepairConfig is used to enable/disable auto repair. The
  cluster-health-controller is deployed only if Enabled is true.

  Fields:
    enabled: Whether auto repair is enabled.
  """

  enabled = _messages.BooleanField(1)


class VmwareAutoResizeConfig(_messages.Message):
  r"""VmwareAutoResizeConfig provides auto resizing configurations.

  Fields:
    enabled: Whether to enable master node auto resizing.
  """

  enabled = _messages.BooleanField(1)


class VmwareCluster(_messages.Message):
  r"""Resource that represents a VMware User Cluster. ##

  Enums:
    StateValueValuesEnum: Output only. The current state of VMware User
      Cluster.

  Messages:
    AnnotationsValue: Annotations on the VMware User Cluster. This field has
      the same restrictions as Kubernetes annotations. The total size of all
      keys and values combined is limited to 256k. Key can have 2 segments:
      prefix (optional) and name (required), separated by a slash (/). Prefix
      must be a DNS subdomain. Name must be 63 characters or less, begin and
      end with alphanumerics, with dashes (-), underscores (_), dots (.), and
      alphanumerics between.

  Fields:
    adminClusterMembership: Required. The admin cluster this VMware User
      Cluster belongs to. This is the full resource name of the admin
      cluster's hub membership. In the future, references to other resource
      types might be allowed if admin clusters are modeled as their own
      resources.
    annotations: Annotations on the VMware User Cluster. This field has the
      same restrictions as Kubernetes annotations. The total size of all keys
      and values combined is limited to 256k. Key can have 2 segments: prefix
      (optional) and name (required), separated by a slash (/). Prefix must be
      a DNS subdomain. Name must be 63 characters or less, begin and end with
      alphanumerics, with dashes (-), underscores (_), dots (.), and
      alphanumerics between.
    antiAffinityGroups: AAGConfig specifies whether to spread VMware User
      Cluster nodes across at least three physical hosts in the datacenter.
    authorization: RBAC policy that will be applied and managed by GKE On-
      Prem.
    autoRepairConfig: Configuration for auto repairing.
    controlPlaneNode: VMware User Cluster control plane nodes must have either
      1 or 3 replicas.
    createTime: Output only. The time at which VMware User Cluster was
      created.
    dataplaneV2: VmwareDataplaneV2Config specifies configuration for Dataplane
      V2.
    deleteTime: Output only. The time at which VMware User Cluster was
      deleted.
    description: A human readable description of this VMware User Cluster.
    endpoint: Output only. The DNS name of VMware User Cluster's API server.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding. Allows clients to
      perform consistent read-modify-writes through optimistic concurrency
      control.
    fleet: Output only. Fleet configuration for the cluster.
    loadBalancer: Load Balancer configuration.
    localName: Output only. The object name of the VMware OnPremUserCluster
      custom resource on the associated admin cluster. This field is used to
      support conflicting names when enrolling existing clusters to the API.
      When used as a part of cluster enrollment, this field will differ from
      the ID in the resource name. For new clusters, this field will match the
      user provided cluster ID and be visible in the last component of the
      resource name. It is not modifiable. All users should use this name to
      access their cluster using gkectl or kubectl and should expect to see
      the local name when viewing admin cluster controller logs.
    name: Required. The VMware User Cluster resource name.
    networkConfig: The VMware User Cluster network configuration.
    onPremVersion: The Anthos clusters on the VMware version for your user
      cluster. Defaults to the admin cluster version.
    reconciling: Output only. If set, there are currently changes in flight to
      the VMware User Cluster.
    state: Output only. The current state of VMware User Cluster.
    status: Output only. ResourceStatus representing detailed cluster state.
    storage: Storage configuration.
    uid: Output only. The unique identifier of the VMware User Cluster.
    updateTime: Output only. The time at which VMware User Cluster was last
      updated.
    validationCheck: Output only. ValidationCheck represents the result of the
      preflight check job.
    vcenter: Output only. VmwareVCenterConfig specifies vCenter config for the
      user cluster. Inherited from the admin cluster.
    vmTrackingEnabled: Enable VM tracking.
    workloadIdentity: Authenticate to Google without requiring you to
      download, manually rotate, and generally manage Google Cloud service
      account keys. By using Workload Identity, the Connect Agent and other
      workloads can authenticate using short-lived tokens generated by the
      cluster.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of VMware User Cluster.

    Values:
      STATE_UNSPECIFIED: Not set.
      PROVISIONING: The PROVISIONING state indicates the cluster is being
        created.
      RUNNING: The RUNNING state indicates the cluster has been created and is
        fully usable.
      RECONCILING: The RECONCILING state indicates that the cluster is being
        updated. It remains available, but potentially with degraded
        performance.
      STOPPING: The STOPPING state indicates the cluster is being deleted.
      ERROR: The ERROR state indicates the cluster is in a broken
        unrecoverable state.
      DEGRADED: The DEGRADED state indicates the cluster requires user action
        to restore full functionality.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    RUNNING = 2
    RECONCILING = 3
    STOPPING = 4
    ERROR = 5
    DEGRADED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Annotations on the VMware User Cluster. This field has the same
    restrictions as Kubernetes annotations. The total size of all keys and
    values combined is limited to 256k. Key can have 2 segments: prefix
    (optional) and name (required), separated by a slash (/). Prefix must be a
    DNS subdomain. Name must be 63 characters or less, begin and end with
    alphanumerics, with dashes (-), underscores (_), dots (.), and
    alphanumerics between.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  adminClusterMembership = _messages.StringField(1)
  annotations = _messages.MessageField('AnnotationsValue', 2)
  antiAffinityGroups = _messages.MessageField('VmwareAAGConfig', 3)
  authorization = _messages.MessageField('Authorization', 4)
  autoRepairConfig = _messages.MessageField('VmwareAutoRepairConfig', 5)
  controlPlaneNode = _messages.MessageField('VmwareControlPlaneNodeConfig', 6)
  createTime = _messages.StringField(7)
  dataplaneV2 = _messages.MessageField('VmwareDataplaneV2Config', 8)
  deleteTime = _messages.StringField(9)
  description = _messages.StringField(10)
  endpoint = _messages.StringField(11)
  etag = _messages.StringField(12)
  fleet = _messages.MessageField('Fleet', 13)
  loadBalancer = _messages.MessageField('VmwareLoadBalancerConfig', 14)
  localName = _messages.StringField(15)
  name = _messages.StringField(16)
  networkConfig = _messages.MessageField('VmwareNetworkConfig', 17)
  onPremVersion = _messages.StringField(18)
  reconciling = _messages.BooleanField(19)
  state = _messages.EnumField('StateValueValuesEnum', 20)
  status = _messages.MessageField('ResourceStatus', 21)
  storage = _messages.MessageField('VmwareStorageConfig', 22)
  uid = _messages.StringField(23)
  updateTime = _messages.StringField(24)
  validationCheck = _messages.MessageField('ValidationCheck', 25)
  vcenter = _messages.MessageField('VmwareVCenterConfig', 26)
  vmTrackingEnabled = _messages.BooleanField(27)
  workloadIdentity = _messages.MessageField('VmwareWorkloadIdentityConfig', 28)


class VmwareControlPlaneNodeConfig(_messages.Message):
  r"""VmwareControlPlaneNodeConfig specifies control plane node config for
  VMware User Cluster.

  Fields:
    autoResizeConfig: AutoResizeConfig provides auto resizing configurations.
    cpus: The number of CPUs for each admin cluster node that serve as control
      planes for this VMware User Cluster. (default: 4 CPUs)
    memory: The megabytes of memory for each admin cluster node that serves as
      a control plane for this VMware User Cluster (default: 8192 MB memory).
    replicas: The number of control plane nodes for this VMware User Cluster.
      (default: 1 replica).
    vsphereConfig: Output only. Vsphere-specific config.
  """

  autoResizeConfig = _messages.MessageField('VmwareAutoResizeConfig', 1)
  cpus = _messages.IntegerField(2)
  memory = _messages.IntegerField(3)
  replicas = _messages.IntegerField(4)
  vsphereConfig = _messages.MessageField('VmwareControlPlaneVsphereConfig', 5)


class VmwareControlPlaneVsphereConfig(_messages.Message):
  r"""VmwareControlPlaneVsphereConfig Control Plane Node config.

  Fields:
    datastore: The Vsphere datastore used by the Master Node.
  """

  datastore = _messages.StringField(1)


class VmwareDataplaneV2Config(_messages.Message):
  r"""VmwareDataplaneV2Config contains configurations for Dataplane V2, which
  is optimized dataplane for Kubernetes networking. For more information, see:
  https://cloud.google.com/kubernetes-engine/docs/concepts/dataplane-v2

  Fields:
    advancedNetworking: Enable advanced networking which requires
      dataplane_v2_enabled to be set true.
    dataplaneV2Enabled: Enables Dataplane V2.
    windowsDataplaneV2Enabled: Enable Dataplane V2 for clusters with Windows
      nodes.
  """

  advancedNetworking = _messages.BooleanField(1)
  dataplaneV2Enabled = _messages.BooleanField(2)
  windowsDataplaneV2Enabled = _messages.BooleanField(3)


class VmwareDhcpIpConfig(_messages.Message):
  r"""VmwareDhcpIpConfig represents the network configuration required for
  VMware user clusters with DHCP IP configurations.

  Fields:
    enabled: enabled is a flag to mark if DHCP IP allocation is used for
      VMware user clusters.
  """

  enabled = _messages.BooleanField(1)


class VmwareF5BigIpConfig(_messages.Message):
  r"""VmwareF5BigIpConfig represents configuration parameters for an F5 BIG-IP
  load balancer.

  Fields:
    address: The load balancer's IP address.
    partition: The preexisting partition to be used by the load balancer. This
      partition is usually created for the admin cluster for example:
      'my-f5-admin-partition'.
    snatPool: The pool name. Only necessary, if using SNAT.
  """

  address = _messages.StringField(1)
  partition = _messages.StringField(2)
  snatPool = _messages.StringField(3)


class VmwareHostConfig(_messages.Message):
  r"""VmwareHostConfig represents the common parameters for all hosts
  irrespective of their IP address.

  Fields:
    dnsSearchDomains: DNS search domains.
    dnsServers: DNS servers.
    ntpServers: NTP servers.
  """

  dnsSearchDomains = _messages.StringField(1, repeated=True)
  dnsServers = _messages.StringField(2, repeated=True)
  ntpServers = _messages.StringField(3, repeated=True)


class VmwareHostIp(_messages.Message):
  r"""VmwareHostIp represents a node's network configuration.

  Fields:
    hostname: Hostname of the machine. VM's name will be used if this field is
      empty.
    ip: IP could be an IP address (like 1.2.3.4) or a CIDR (like 1.2.3.0/24).
  """

  hostname = _messages.StringField(1)
  ip = _messages.StringField(2)


class VmwareIpBlock(_messages.Message):
  r"""VmwareIpBlock represents a collection of IP addresses to assign to nodes
  from.

  Fields:
    gateway: The network gateway used by the VMware User Cluster.
    ips: The node's network configurations used by the VMware User Cluster.
    netmask: The netmask used by the VMware User Cluster.
  """

  gateway = _messages.StringField(1)
  ips = _messages.MessageField('VmwareHostIp', 2, repeated=True)
  netmask = _messages.StringField(3)


class VmwareLoadBalancerConfig(_messages.Message):
  r"""VmwareLoadBalancerConfig for VMware User Cluster.

  Fields:
    f5Config: Configuration for F5 Big IP typed load balancers.
    manualLbConfig: Manually configured load balancers.
    metalLbConfig: Configuration for MetalLB typed load balancers.
    seesawConfig: Configuration for Seesaw typed load balancers.
    vipConfig: The VIPs used by the load balancer.
  """

  f5Config = _messages.MessageField('VmwareF5BigIpConfig', 1)
  manualLbConfig = _messages.MessageField('VmwareManualLbConfig', 2)
  metalLbConfig = _messages.MessageField('VmwareMetalLbConfig', 3)
  seesawConfig = _messages.MessageField('VmwareSeesawConfig', 4)
  vipConfig = _messages.MessageField('VmwareVipConfig', 5)


class VmwareManualLbConfig(_messages.Message):
  r"""A VmwareManualLbConfig object.

  Fields:
    controlPlaneNodePort: NodePort for control plane service. The Kubernetes
      API server in the admin cluster is implemented as a Service of type
      NodePort (ex. 30968).
    ingressHttpNodePort: NodePort for ingress service's http. The ingress
      service in the admin cluster is implemented as a Service of type
      NodePort (ex. 32527).
    ingressHttpsNodePort: NodePort for ingress service's https. The ingress
      service in the admin cluster is implemented as a Service of type
      NodePort (ex. 30139).
    konnectivityServerNodePort: NodePort for konnectivity server service
      running as a sidecar in each kube-apiserver pod (ex. 30564).
  """

  controlPlaneNodePort = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  ingressHttpNodePort = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  ingressHttpsNodePort = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  konnectivityServerNodePort = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class VmwareMetalLbConfig(_messages.Message):
  r"""VmwareMetalLbConfig represents configuration parameters for a MetalLB
  load balancer.

  Fields:
    addressPools: Required. AddressPools is a list of non-overlapping IP pools
      used by load balancer typed services. All addresses must be routable to
      load balancer nodes. IngressVIP must be included in the pools.
  """

  addressPools = _messages.MessageField('VmwareAddressPool', 1, repeated=True)


class VmwareNetworkConfig(_messages.Message):
  r"""VmwareNetworkConfig for VMware User Cluster.

  Fields:
    dhcpIpConfig: Configuration settings for a DHCP IP configuration.
    hostConfig: Represents common network settings irrespective of the host's
      IP address.
    podAddressCidrBlocks: Required. All pods in the cluster are assigned an
      RFC1918 IPv4 address from these ranges. Only a single range is
      supported. This field cannot be changed after creation.
    serviceAddressCidrBlocks: Required. All services in the cluster are
      assigned an RFC1918 IPv4 address from these ranges. Only a single range
      is supported. This field cannot be changed after creation.
    staticIpConfig: Configuration settings for a static IP configuration.
    vcenterNetwork: Output only. vcenter_network specifies vCenter network
      name. Inherited from the admin cluster.
  """

  dhcpIpConfig = _messages.MessageField('VmwareDhcpIpConfig', 1)
  hostConfig = _messages.MessageField('VmwareHostConfig', 2)
  podAddressCidrBlocks = _messages.StringField(3, repeated=True)
  serviceAddressCidrBlocks = _messages.StringField(4, repeated=True)
  staticIpConfig = _messages.MessageField('VmwareStaticIpConfig', 5)
  vcenterNetwork = _messages.StringField(6)


class VmwareNodeConfig(_messages.Message):
  r"""Parameters that describe the configuration of all nodes within a given
  node pool.

  Messages:
    LabelsValue: The map of Kubernetes labels (key/value pairs) to be applied
      to each node. These will added in addition to any default label(s) that
      Kubernetes may apply to the node. In case of conflict in label keys, the
      applied set may differ depending on the Kubernetes version -- it's best
      to assume the behavior is undefined and conflicts should be avoided. For
      more information, including usage and the valid values, see:
      https://kubernetes.io/docs/concepts/overview/working-with-
      objects/labels/

  Fields:
    bootDiskSizeGb: VMware disk size to be used during creation.
    cpus: The number of CPUs for each node in the node pool.
    enableLoadBalancer: Allow node pool traffic to be load balanced. Only
      works for clusters with MetalLB load balancers.
    image: The OS image name in vCenter, only valid when using Windows.
    imageType: Required. The OS image to be used for each node in a node pool.
      Currently `cos`, `ubuntu`, `ubuntu_containerd` and `windows` are
      supported.
    labels: The map of Kubernetes labels (key/value pairs) to be applied to
      each node. These will added in addition to any default label(s) that
      Kubernetes may apply to the node. In case of conflict in label keys, the
      applied set may differ depending on the Kubernetes version -- it's best
      to assume the behavior is undefined and conflicts should be avoided. For
      more information, including usage and the valid values, see:
      https://kubernetes.io/docs/concepts/overview/working-with-
      objects/labels/
    memoryMb: The megabytes of memory for each node in the node pool.
    replicas: The number of nodes in the node pool.
    taints: The initial taints assigned to nodes of this node pool.
    vsphereConfig: Output only. Specifies the vSphere config for node pool.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The map of Kubernetes labels (key/value pairs) to be applied to each
    node. These will added in addition to any default label(s) that Kubernetes
    may apply to the node. In case of conflict in label keys, the applied set
    may differ depending on the Kubernetes version -- it's best to assume the
    behavior is undefined and conflicts should be avoided. For more
    information, including usage and the valid values, see:
    https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  bootDiskSizeGb = _messages.IntegerField(1)
  cpus = _messages.IntegerField(2)
  enableLoadBalancer = _messages.BooleanField(3)
  image = _messages.StringField(4)
  imageType = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  memoryMb = _messages.IntegerField(7)
  replicas = _messages.IntegerField(8)
  taints = _messages.MessageField('NodeTaint', 9, repeated=True)
  vsphereConfig = _messages.MessageField('VmwareVsphereConfig', 10)


class VmwareNodePool(_messages.Message):
  r"""Resource VmwareNodePool represents a Vmware node pool. ##

  Enums:
    StateValueValuesEnum: Output only. The current state of the node pool.

  Messages:
    AnnotationsValue: Annotations on the node pool. This field has the same
      restrictions as Kubernetes annotations. The total size of all keys and
      values combined is limited to 256k. Key can have 2 segments: prefix
      (optional) and name (required), separated by a slash (/). Prefix must be
      a DNS subdomain. Name must be 63 characters or less, begin and end with
      alphanumerics, with dashes (-), underscores (_), dots (.), and
      alphanumerics between.

  Fields:
    annotations: Annotations on the node pool. This field has the same
      restrictions as Kubernetes annotations. The total size of all keys and
      values combined is limited to 256k. Key can have 2 segments: prefix
      (optional) and name (required), separated by a slash (/). Prefix must be
      a DNS subdomain. Name must be 63 characters or less, begin and end with
      alphanumerics, with dashes (-), underscores (_), dots (.), and
      alphanumerics between.
    config: Required. The node configuration of the node pool.
    createTime: Output only. The time at which this node pool was created.
    deleteTime: Output only. The time at which this node pool was deleted. If
      the resource is not deleted, this must be empty
    displayName: The display name for the node pool.
    etag: This checksum is computed by the server based on the value of other
      fields, and may be sent on update and delete requests to ensure the
      client has an up-to-date value before proceeding. Allows clients to
      perform consistent read-modify-writes through optimistic concurrency
      control.
    name: Required. The resource name of this node pool.
    nodePoolAutoscaling: Node Pool autoscaling config for the Nodepool.
    reconciling: Output only. If set, there are currently changes in flight to
      the node pool.
    state: Output only. The current state of the node pool.
    status: Output only. ResourceStatus representing the detailed VMware Node
      Pool state.
    uid: Output only. The unique identifier of the node pool.
    updateTime: Output only. The time at which this node pool was last
      updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the node pool.

    Values:
      STATE_UNSPECIFIED: Not set.
      PROVISIONING: The PROVISIONING state indicates the node pool is being
        created.
      RUNNING: The RUNNING state indicates the node pool has been created and
        is fully usable.
      RECONCILING: The RECONCILING state indicates that the node pool is being
        updated. It remains available, but potentially with degraded
        performance.
      STOPPING: The STOPPING state indicates the cluster is being deleted
      ERROR: The ERROR state indicates the node pool is in a broken
        unrecoverable state.
      DEGRADED: The DEGRADED state indicates the node pool requires user
        action to restore full functionality.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    RUNNING = 2
    RECONCILING = 3
    STOPPING = 4
    ERROR = 5
    DEGRADED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Annotations on the node pool. This field has the same restrictions as
    Kubernetes annotations. The total size of all keys and values combined is
    limited to 256k. Key can have 2 segments: prefix (optional) and name
    (required), separated by a slash (/). Prefix must be a DNS subdomain. Name
    must be 63 characters or less, begin and end with alphanumerics, with
    dashes (-), underscores (_), dots (.), and alphanumerics between.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  config = _messages.MessageField('VmwareNodeConfig', 2)
  createTime = _messages.StringField(3)
  deleteTime = _messages.StringField(4)
  displayName = _messages.StringField(5)
  etag = _messages.StringField(6)
  name = _messages.StringField(7)
  nodePoolAutoscaling = _messages.MessageField('VmwareNodePoolAutoscalingConfig', 8)
  reconciling = _messages.BooleanField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  status = _messages.MessageField('ResourceStatus', 11)
  uid = _messages.StringField(12)
  updateTime = _messages.StringField(13)


class VmwareNodePoolAutoscalingConfig(_messages.Message):
  r"""NodePoolAutoscaling config for the NodePool to allow for the kubernetes
  to scale NodePool.

  Fields:
    maxReplicas: Maximum number of replicas in the NodePool.
    minReplicas: Minimum number of replicas in the NodePool.
  """

  maxReplicas = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minReplicas = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class VmwareSeesawConfig(_messages.Message):
  r"""A VmwareSeesawConfig object.

  Fields:
    enableHa: Enable two load balancer VMs to achieve a highly-available
      Seesaw load balancer.
    group: Required. In general the following format should be used for the
      Seesaw group name: seesaw-for-[cluster_name].
    ipBlocks: Required. The IP Blocks to be used by the Seesaw load balancer
    masterIp: Required. MasterIP is the IP announced by the master of Seesaw
      group.
    vms: Names of the VMs created for this Seesaw group.
  """

  enableHa = _messages.BooleanField(1)
  group = _messages.StringField(2)
  ipBlocks = _messages.MessageField('VmwareIpBlock', 3, repeated=True)
  masterIp = _messages.StringField(4)
  vms = _messages.StringField(5, repeated=True)


class VmwareStaticIpConfig(_messages.Message):
  r"""VmwareStaticIpConfig represents the network configuration required for
  VMware User Clusters with Static IP configurations.

  Fields:
    ipBlocks: Represents the configuration values for static IP allocation to
      nodes.
  """

  ipBlocks = _messages.MessageField('VmwareIpBlock', 1, repeated=True)


class VmwareStorageConfig(_messages.Message):
  r"""VmwareStorageConfig specifies whether to deploy vSphere CSI components
  in the VMware User Cluster.

  Fields:
    vsphereCsiDisabled: Whether or not to deploy vSphere CSI components in the
      VMware User Cluster. Enabled by default.
  """

  vsphereCsiDisabled = _messages.BooleanField(1)


class VmwareVCenterConfig(_messages.Message):
  r"""VmwareVCenterConfig represents configuration for the VMware VCenter for
  the user cluster.

  Fields:
    address: The vCenter IP address.
    caCertData: Contains the vCenter CA certificate public key for SSL
      verification.
    cluster: The name of the vCenter cluster for the user cluster.
    datacenter: The name of the vCenter datacenter for the user cluster.
    datastore: The name of the vCenter datastore for the user cluster.
    folder: The name of the vCenter folder for the user cluster.
    resourcePool: The name of the vCenter resource pool for the user cluster.
  """

  address = _messages.StringField(1)
  caCertData = _messages.StringField(2)
  cluster = _messages.StringField(3)
  datacenter = _messages.StringField(4)
  datastore = _messages.StringField(5)
  folder = _messages.StringField(6)
  resourcePool = _messages.StringField(7)


class VmwareVipConfig(_messages.Message):
  r"""VmwareVipConfig for Vmware Load Balancer Config.

  Fields:
    controlPlaneVip: The VIP which you previously set aside for the Kubernetes
      API of this cluster.
    ingressVip: The VIP which you previously set aside for ingress traffic
      into this cluster.
  """

  controlPlaneVip = _messages.StringField(1)
  ingressVip = _messages.StringField(2)


class VmwareVsphereConfig(_messages.Message):
  r"""VmwareVsphereConfig represents configuration for the VMware VCenter for
  node pool.

  Fields:
    datastore: The name of the vCenter datastore. Inherited from the user
      cluster.
    tags: Tags to apply to VMs.
  """

  datastore = _messages.StringField(1)
  tags = _messages.MessageField('VmwareVsphereTag', 2, repeated=True)


class VmwareVsphereTag(_messages.Message):
  r"""VmwareVsphereTag describes a vSphere tag to be placed on VMs in the node
  pool. For more information, see https://docs.vmware.com/en/VMware-
  vSphere/7.0/com.vmware.vsphere.vcenterhost.doc/GUID-E8E854DD-
  AA97-4E0C-8419-CE84F93C4058.html

  Fields:
    category: The Vsphere tag category.
    tag: The Vsphere tag name.
  """

  category = _messages.StringField(1)
  tag = _messages.StringField(2)


class VmwareWorkloadIdentityConfig(_messages.Message):
  r"""VmwareWorkloadIdentityConfig for VMware User Cluster.

  Fields:
    workloadIdentityDisabled: Whether or not workload identity is disabled in
      the cluster. Workload Identity is enabled by default.
  """

  workloadIdentityDisabled = _messages.BooleanField(1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
