"""Generated message classes for storagetransfer version v1.

Transfers data from external data sources to a Google Cloud Storage bucket or
between Google Cloud Storage buckets.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'storagetransfer'


class AgentPool(_messages.Message):
  r"""Represents an On-Premises Agent pool.

  Enums:
    StateValueValuesEnum: Output only. Specifies the state of the AgentPool.

  Fields:
    bandwidthLimit: Specifies the bandwidth limit details. If this field is
      unspecified, the default value is set as 'No Limit'.
    displayName: Specifies the client-specified AgentPool description.
    name: Required. Specifies a unique string that identifies the agent pool.
      Format: `projects/{project_id}/agentPools/{agent_pool_id}`
    state: Output only. Specifies the state of the AgentPool.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Specifies the state of the AgentPool.

    Values:
      STATE_UNSPECIFIED: Default value. This value is unused.
      CREATING: This is an initialization state. During this stage, the
        resources such as Pub/Sub topics are allocated for the AgentPool.
      CREATED: Determines that the AgentPool is created for use. At this
        state, Agents can join the AgentPool and participate in the transfer
        jobs in that pool.
      DELETING: Determines that the AgentPool deletion has been initiated, and
        all the resources are scheduled to be cleaned up and freed.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    CREATED = 2
    DELETING = 3

  bandwidthLimit = _messages.MessageField('BandwidthLimit', 1)
  displayName = _messages.StringField(2)
  name = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)


class AwsAccessKey(_messages.Message):
  r"""AWS access key (see [AWS Security
  Credentials](https://docs.aws.amazon.com/general/latest/gr/aws-security-
  credentials.html)). For information on our data retention policy for user
  credentials, see [User credentials](/storage-transfer/docs/data-
  retention#user-credentials).

  Fields:
    accessKeyId: Required. AWS access key ID.
    secretAccessKey: Required. AWS secret access key. This field is not
      returned in RPC responses.
  """

  accessKeyId = _messages.StringField(1)
  secretAccessKey = _messages.StringField(2)


class AwsS3Data(_messages.Message):
  r"""An AwsS3Data resource can be a data source, but not a data sink. In an
  AwsS3Data resource, an object's name is the S3 object's key name.

  Fields:
    awsAccessKey: Input only. AWS access key used to sign the API requests to
      the AWS S3 bucket. Permissions on the bucket must be granted to the
      access ID of the AWS access key. This field is required. For information
      on our data retention policy for user credentials, see [User
      credentials](/storage-transfer/docs/data-retention#user-credentials).
    bucketName: Required. S3 Bucket name (see [Creating a
      bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-
      get-location-example.html)).
    path: Root path to transfer objects. Must be an empty string or full path
      name that ends with a '/'. This field is treated as an object prefix. As
      such, it should generally not begin with a '/'.
    roleArn: The Amazon Resource Name (ARN) of the role to support temporary
      credentials via `AssumeRoleWithWebIdentity`. For more information about
      ARNs, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/re
      ference_identifiers.html#identifiers-arns). When a role ARN is provided,
      Transfer Service fetches temporary credentials for the session using a
      `AssumeRoleWithWebIdentity` call for the provided role using the
      GoogleServiceAccount for this project.
  """

  awsAccessKey = _messages.MessageField('AwsAccessKey', 1)
  bucketName = _messages.StringField(2)
  path = _messages.StringField(3)
  roleArn = _messages.StringField(4)


class AzureBlobStorageData(_messages.Message):
  r"""An AzureBlobStorageData resource can be a data source, but not a data
  sink. An AzureBlobStorageData resource represents one Azure container. The
  storage account determines the [Azure
  endpoint](https://docs.microsoft.com/en-us/azure/storage/common/storage-
  create-storage-account#storage-account-endpoints). In an
  AzureBlobStorageData resource, a blobs's name is the [Azure Blob Storage
  blob's key name](https://docs.microsoft.com/en-
  us/rest/api/storageservices/naming-and-referencing-containers--blobs--and-
  metadata#blob-names).

  Fields:
    azureCredentials: Required. Input only. Credentials used to authenticate
      API requests to Azure. For information on our data retention policy for
      user credentials, see [User credentials](/storage-transfer/docs/data-
      retention#user-credentials).
    container: Required. The container to transfer from the Azure Storage
      account.
    path: Root path to transfer objects. Must be an empty string or full path
      name that ends with a '/'. This field is treated as an object prefix. As
      such, it should generally not begin with a '/'.
    storageAccount: Required. The name of the Azure Storage account.
  """

  azureCredentials = _messages.MessageField('AzureCredentials', 1)
  container = _messages.StringField(2)
  path = _messages.StringField(3)
  storageAccount = _messages.StringField(4)


class AzureCredentials(_messages.Message):
  r"""Azure credentials For information on our data retention policy for user
  credentials, see [User credentials](/storage-transfer/docs/data-
  retention#user-credentials).

  Fields:
    sasToken: Required. Azure shared access signature (SAS). *Note:*Copying
      data from Azure Data Lake Storage (ADLS) Gen 2 is in
      [Preview](/products/#product-launch-stages). During Preview, if you are
      copying data from ADLS Gen 2, you must use an account SAS. For more
      information about SAS, see [Grant limited access to Azure Storage
      resources using shared access signatures
      (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-
      sas-overview).
  """

  sasToken = _messages.StringField(1)


class BandwidthLimit(_messages.Message):
  r"""Specifies a bandwidth limit for an agent pool.

  Fields:
    limitMbps: Bandwidth rate in megabytes per second, distributed across all
      the agents in the pool.
  """

  limitMbps = _messages.IntegerField(1)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class Date(_messages.Message):
  r"""Represents a whole or partial calendar date, such as a birthday. The
  time of day and time zone are either specified elsewhere or are
  insignificant. The date is relative to the Gregorian Calendar. This can
  represent one of the following: * A full date, with non-zero year, month,
  and day values * A month and day value, with a zero year, such as an
  anniversary * A year on its own, with zero month and day values * A year and
  month value, with a zero day, such as a credit card expiration date Related
  types are google.type.TimeOfDay and `google.protobuf.Timestamp`.

  Fields:
    day: Day of a month. Must be from 1 to 31 and valid for the year and
      month, or 0 to specify a year by itself or a year and month where the
      day isn't significant.
    month: Month of a year. Must be from 1 to 12, or 0 to specify a year
      without a month and day.
    year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
      without a year.
  """

  day = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  month = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  year = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class ErrorLogEntry(_messages.Message):
  r"""An entry describing an error that has occurred.

  Fields:
    errorDetails: A list of messages that carry the error details.
    url: Required. A URL that refers to the target (a data source, a data
      sink, or an object) with which the error is associated.
  """

  errorDetails = _messages.StringField(1, repeated=True)
  url = _messages.StringField(2)


class ErrorSummary(_messages.Message):
  r"""A summary of errors by error code, plus a count and sample error log
  entries.

  Enums:
    ErrorCodeValueValuesEnum: Required.

  Fields:
    errorCode: Required.
    errorCount: Required. Count of this type of error.
    errorLogEntries: Error samples. At most 5 error log entries are recorded
      for a given error code for a single transfer operation.
  """

  class ErrorCodeValueValuesEnum(_messages.Enum):
    r"""Required.

    Values:
      OK: Not an error; returned on success HTTP Mapping: 200 OK
      CANCELLED: The operation was cancelled, typically by the caller. HTTP
        Mapping: 499 Client Closed Request
      UNKNOWN: Unknown error. For example, this error may be returned when a
        `Status` value received from another address space belongs to an error
        space that is not known in this address space. Also errors raised by
        APIs that do not return enough error information may be converted to
        this error. HTTP Mapping: 500 Internal Server Error
      INVALID_ARGUMENT: The client specified an invalid argument. Note that
        this differs from `FAILED_PRECONDITION`. `INVALID_ARGUMENT` indicates
        arguments that are problematic regardless of the state of the system
        (e.g., a malformed file name). HTTP Mapping: 400 Bad Request
      DEADLINE_EXCEEDED: The deadline expired before the operation could
        complete. For operations that change the state of the system, this
        error may be returned even if the operation has completed
        successfully. For example, a successful response from a server could
        have been delayed long enough for the deadline to expire. HTTP
        Mapping: 504 Gateway Timeout
      NOT_FOUND: Some requested entity (e.g., file or directory) was not
        found. Note to server developers: if a request is denied for an entire
        class of users, such as gradual feature rollout or undocumented
        allowlist, `NOT_FOUND` may be used. If a request is denied for some
        users within a class of users, such as user-based access control,
        `PERMISSION_DENIED` must be used. HTTP Mapping: 404 Not Found
      ALREADY_EXISTS: The entity that a client attempted to create (e.g., file
        or directory) already exists. HTTP Mapping: 409 Conflict
      PERMISSION_DENIED: The caller does not have permission to execute the
        specified operation. `PERMISSION_DENIED` must not be used for
        rejections caused by exhausting some resource (use
        `RESOURCE_EXHAUSTED` instead for those errors). `PERMISSION_DENIED`
        must not be used if the caller can not be identified (use
        `UNAUTHENTICATED` instead for those errors). This error code does not
        imply the request is valid or the requested entity exists or satisfies
        other pre-conditions. HTTP Mapping: 403 Forbidden
      UNAUTHENTICATED: The request does not have valid authentication
        credentials for the operation. HTTP Mapping: 401 Unauthorized
      RESOURCE_EXHAUSTED: Some resource has been exhausted, perhaps a per-user
        quota, or perhaps the entire file system is out of space. HTTP
        Mapping: 429 Too Many Requests
      FAILED_PRECONDITION: The operation was rejected because the system is
        not in a state required for the operation's execution. For example,
        the directory to be deleted is non-empty, an rmdir operation is
        applied to a non-directory, etc. Service implementors can use the
        following guidelines to decide between `FAILED_PRECONDITION`,
        `ABORTED`, and `UNAVAILABLE`: (a) Use `UNAVAILABLE` if the client can
        retry just the failing call. (b) Use `ABORTED` if the client should
        retry at a higher level. For example, when a client-specified test-
        and-set fails, indicating the client should restart a read-modify-
        write sequence. (c) Use `FAILED_PRECONDITION` if the client should not
        retry until the system state has been explicitly fixed. For example,
        if an "rmdir" fails because the directory is non-empty,
        `FAILED_PRECONDITION` should be returned since the client should not
        retry unless the files are deleted from the directory. HTTP Mapping:
        400 Bad Request
      ABORTED: The operation was aborted, typically due to a concurrency issue
        such as a sequencer check failure or transaction abort. See the
        guidelines above for deciding between `FAILED_PRECONDITION`,
        `ABORTED`, and `UNAVAILABLE`. HTTP Mapping: 409 Conflict
      OUT_OF_RANGE: The operation was attempted past the valid range. E.g.,
        seeking or reading past end-of-file. Unlike `INVALID_ARGUMENT`, this
        error indicates a problem that may be fixed if the system state
        changes. For example, a 32-bit file system will generate
        `INVALID_ARGUMENT` if asked to read at an offset that is not in the
        range [0,2^32-1], but it will generate `OUT_OF_RANGE` if asked to read
        from an offset past the current file size. There is a fair bit of
        overlap between `FAILED_PRECONDITION` and `OUT_OF_RANGE`. We recommend
        using `OUT_OF_RANGE` (the more specific error) when it applies so that
        callers who are iterating through a space can easily look for an
        `OUT_OF_RANGE` error to detect when they are done. HTTP Mapping: 400
        Bad Request
      UNIMPLEMENTED: The operation is not implemented or is not
        supported/enabled in this service. HTTP Mapping: 501 Not Implemented
      INTERNAL: Internal errors. This means that some invariants expected by
        the underlying system have been broken. This error code is reserved
        for serious errors. HTTP Mapping: 500 Internal Server Error
      UNAVAILABLE: The service is currently unavailable. This is most likely a
        transient condition, which can be corrected by retrying with a
        backoff. Note that it is not always safe to retry non-idempotent
        operations. See the guidelines above for deciding between
        `FAILED_PRECONDITION`, `ABORTED`, and `UNAVAILABLE`. HTTP Mapping: 503
        Service Unavailable
      DATA_LOSS: Unrecoverable data loss or corruption. HTTP Mapping: 500
        Internal Server Error
    """
    OK = 0
    CANCELLED = 1
    UNKNOWN = 2
    INVALID_ARGUMENT = 3
    DEADLINE_EXCEEDED = 4
    NOT_FOUND = 5
    ALREADY_EXISTS = 6
    PERMISSION_DENIED = 7
    UNAUTHENTICATED = 8
    RESOURCE_EXHAUSTED = 9
    FAILED_PRECONDITION = 10
    ABORTED = 11
    OUT_OF_RANGE = 12
    UNIMPLEMENTED = 13
    INTERNAL = 14
    UNAVAILABLE = 15
    DATA_LOSS = 16

  errorCode = _messages.EnumField('ErrorCodeValueValuesEnum', 1)
  errorCount = _messages.IntegerField(2)
  errorLogEntries = _messages.MessageField('ErrorLogEntry', 3, repeated=True)


class GcsData(_messages.Message):
  r"""In a GcsData resource, an object's name is the Cloud Storage object's
  name and its "last modification time" refers to the object's `updated`
  property of Cloud Storage objects, which changes when the content or the
  metadata of the object is updated.

  Fields:
    bucketName: Required. Cloud Storage bucket name. Must meet [Bucket Name
      Requirements](/storage/docs/naming#requirements).
    path: Root path to transfer objects. Must be an empty string or full path
      name that ends with a '/'. This field is treated as an object prefix. As
      such, it should generally not begin with a '/'. The root path value must
      meet [Object Name Requirements](/storage/docs/naming#objectnames).
  """

  bucketName = _messages.StringField(1)
  path = _messages.StringField(2)


class GoogleServiceAccount(_messages.Message):
  r"""Google service account

  Fields:
    accountEmail: Email address of the service account.
    subjectId: Unique identifier for the service account.
  """

  accountEmail = _messages.StringField(1)
  subjectId = _messages.StringField(2)


class HttpData(_messages.Message):
  r"""An HttpData resource specifies a list of objects on the web to be
  transferred over HTTP. The information of the objects to be transferred is
  contained in a file referenced by a URL. The first line in the file must be
  `"TsvHttpData-1.0"`, which specifies the format of the file. Subsequent
  lines specify the information of the list of objects, one object per list
  entry. Each entry has the following tab-delimited fields: * **HTTP URL** -
  The location of the object. * **Length** - The size of the object in bytes.
  * **MD5** - The base64-encoded MD5 hash of the object. For an example of a
  valid TSV file, see [Transferring data from
  URLs](https://cloud.google.com/storage-transfer/docs/create-url-list). When
  transferring data based on a URL list, keep the following in mind: * When an
  object located at `http(s)://hostname:port/` is transferred to a data sink,
  the name of the object at the data sink is `/`. * If the specified size of
  an object does not match the actual size of the object fetched, the object
  is not transferred. * If the specified MD5 does not match the MD5 computed
  from the transferred bytes, the object transfer fails. * Ensure that each
  URL you specify is publicly accessible. For example, in Cloud Storage you
  can [share an object publicly] (/storage/docs/cloud-console#_sharingdata)
  and get a link to it. * Storage Transfer Service obeys `robots.txt` rules
  and requires the source HTTP server to support `Range` requests and to
  return a `Content-Length` header in each response. * ObjectConditions have
  no effect when filtering objects to transfer.

  Fields:
    listUrl: Required. The URL that points to the file that stores the object
      list entries. This file must allow public access. Currently, only URLs
      with HTTP and HTTPS schemes are supported.
  """

  listUrl = _messages.StringField(1)


class ListAgentPoolsResponse(_messages.Message):
  r"""Response from ListAgentPools.

  Fields:
    agentPools: A list of agent pools.
    nextPageToken: The list next page token.
  """

  agentPools = _messages.MessageField('AgentPool', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListTransferJobsResponse(_messages.Message):
  r"""Response from ListTransferJobs.

  Fields:
    nextPageToken: The list next page token.
    transferJobs: A list of transfer jobs.
  """

  nextPageToken = _messages.StringField(1)
  transferJobs = _messages.MessageField('TransferJob', 2, repeated=True)


class LoggingConfig(_messages.Message):
  r"""Logging configuration.

  Enums:
    LogActionStatesValueListEntryValuesEnum:
    LogActionsValueListEntryValuesEnum:

  Fields:
    enableOnpremGcsTransferLogs: Enables the Cloud Storage transfer logs for
      this transfer. This is only supported for transfer jobs with
      PosixFilesystem sources. The default is that logs are not generated for
      this transfer.
    logActionStates: States in which `log_actions` are logged. If empty, no
      logs are generated. This is not yet supported for transfers with
      PosixFilesystem data sources.
    logActions: Actions to be logged. If empty, no logs are generated. This is
      not yet supported for transfers with PosixFilesystem data sources.
  """

  class LogActionStatesValueListEntryValuesEnum(_messages.Enum):
    r"""LogActionStatesValueListEntryValuesEnum enum type.

    Values:
      LOGGABLE_ACTION_STATE_UNSPECIFIED: Default value. This value is unused.
      SUCCEEDED: `LoggableAction` is completed successfully. `SUCCEEDED`
        actions are logged as INFO.
      FAILED: `LoggableAction` is terminated in an error state. `FAILED`
        actions are logged as ERROR.
    """
    LOGGABLE_ACTION_STATE_UNSPECIFIED = 0
    SUCCEEDED = 1
    FAILED = 2

  class LogActionsValueListEntryValuesEnum(_messages.Enum):
    r"""LogActionsValueListEntryValuesEnum enum type.

    Values:
      LOGGABLE_ACTION_UNSPECIFIED: Default value. This value is unused.
      FIND: Finding objects to transfer e.g. listing objects of the source
        bucket.
      DELETE: Deleting objects at source or destination.
      COPY: Copying objects from source to destination.
    """
    LOGGABLE_ACTION_UNSPECIFIED = 0
    FIND = 1
    DELETE = 2
    COPY = 3

  enableOnpremGcsTransferLogs = _messages.BooleanField(1)
  logActionStates = _messages.EnumField('LogActionStatesValueListEntryValuesEnum', 2, repeated=True)
  logActions = _messages.EnumField('LogActionsValueListEntryValuesEnum', 3, repeated=True)


class NotificationConfig(_messages.Message):
  r"""Specification to configure notifications published to Pub/Sub.
  Notifications are published to the customer-provided topic using the
  following `PubsubMessage.attributes`: * `"eventType"`: one of the EventType
  values * `"payloadFormat"`: one of the PayloadFormat values * `"projectId"`:
  the project_id of the `TransferOperation` * `"transferJobName"`: the
  transfer_job_name of the `TransferOperation` * `"transferOperationName"`:
  the name of the `TransferOperation` The `PubsubMessage.data` contains a
  TransferOperation resource formatted according to the specified
  `PayloadFormat`.

  Enums:
    EventTypesValueListEntryValuesEnum:
    PayloadFormatValueValuesEnum: Required. The desired format of the
      notification message payloads.

  Fields:
    eventTypes: Event types for which a notification is desired. If empty,
      send notifications for all event types.
    payloadFormat: Required. The desired format of the notification message
      payloads.
    pubsubTopic: Required. The `Topic.name` of the Pub/Sub topic to which to
      publish notifications. Must be of the format:
      `projects/{project}/topics/{topic}`. Not matching this format results in
      an INVALID_ARGUMENT error.
  """

  class EventTypesValueListEntryValuesEnum(_messages.Enum):
    r"""EventTypesValueListEntryValuesEnum enum type.

    Values:
      EVENT_TYPE_UNSPECIFIED: Illegal value, to avoid allowing a default.
      TRANSFER_OPERATION_SUCCESS: `TransferOperation` completed with status
        SUCCESS.
      TRANSFER_OPERATION_FAILED: `TransferOperation` completed with status
        FAILED.
      TRANSFER_OPERATION_ABORTED: `TransferOperation` completed with status
        ABORTED.
    """
    EVENT_TYPE_UNSPECIFIED = 0
    TRANSFER_OPERATION_SUCCESS = 1
    TRANSFER_OPERATION_FAILED = 2
    TRANSFER_OPERATION_ABORTED = 3

  class PayloadFormatValueValuesEnum(_messages.Enum):
    r"""Required. The desired format of the notification message payloads.

    Values:
      PAYLOAD_FORMAT_UNSPECIFIED: Illegal value, to avoid allowing a default.
      NONE: No payload is included with the notification.
      JSON: `TransferOperation` is [formatted as a JSON
        response](https://developers.google.com/protocol-
        buffers/docs/proto3#json), in application/json.
    """
    PAYLOAD_FORMAT_UNSPECIFIED = 0
    NONE = 1
    JSON = 2

  eventTypes = _messages.EnumField('EventTypesValueListEntryValuesEnum', 1, repeated=True)
  payloadFormat = _messages.EnumField('PayloadFormatValueValuesEnum', 2)
  pubsubTopic = _messages.StringField(3)


class ObjectConditions(_messages.Message):
  r"""Conditions that determine which objects are transferred. Applies only to
  Cloud Data Sources such as S3, Azure, and Cloud Storage. The "last
  modification time" refers to the time of the last change to the object's
  content or metadata - specifically, this is the `updated` property of Cloud
  Storage objects, the `LastModified` field of S3 objects, and the `Last-
  Modified` header of Azure blobs. Transfers with a PosixFilesystem source or
  destination don't support `ObjectConditions`.

  Fields:
    excludePrefixes: If you specify `exclude_prefixes`, Storage Transfer
      Service uses the items in the `exclude_prefixes` array to determine
      which objects to exclude from a transfer. Objects must not start with
      one of the matching `exclude_prefixes` for inclusion in a transfer. The
      following are requirements of `exclude_prefixes`: * Each exclude-prefix
      can contain any sequence of Unicode characters, to a max length of 1024
      bytes when UTF8-encoded, and must not contain Carriage Return or Line
      Feed characters. Wildcard matching and regular expression matching are
      not supported. * Each exclude-prefix must omit the leading slash. For
      example, to exclude the object `s3://my-aws-
      bucket/logs/y=2015/requests.gz`, specify the exclude-prefix as
      `logs/y=2015/requests.gz`. * None of the exclude-prefix values can be
      empty, if specified. * Each exclude-prefix must exclude a distinct
      portion of the object namespace. No exclude-prefix may be a prefix of
      another exclude-prefix. * If include_prefixes is specified, then each
      exclude-prefix must start with the value of a path explicitly included
      by `include_prefixes`. The max size of `exclude_prefixes` is 1000. For
      more information, see [Filtering objects from transfers](/storage-
      transfer/docs/filtering-objects-from-transfers).
    includePrefixes: If you specify `include_prefixes`, Storage Transfer
      Service uses the items in the `include_prefixes` array to determine
      which objects to include in a transfer. Objects must start with one of
      the matching `include_prefixes` for inclusion in the transfer. If
      exclude_prefixes is specified, objects must not start with any of the
      `exclude_prefixes` specified for inclusion in the transfer. The
      following are requirements of `include_prefixes`: * Each include-prefix
      can contain any sequence of Unicode characters, to a max length of 1024
      bytes when UTF8-encoded, and must not contain Carriage Return or Line
      Feed characters. Wildcard matching and regular expression matching are
      not supported. * Each include-prefix must omit the leading slash. For
      example, to include the object `s3://my-aws-
      bucket/logs/y=2015/requests.gz`, specify the include-prefix as
      `logs/y=2015/requests.gz`. * None of the include-prefix values can be
      empty, if specified. * Each include-prefix must include a distinct
      portion of the object namespace. No include-prefix may be a prefix of
      another include-prefix. The max size of `include_prefixes` is 1000. For
      more information, see [Filtering objects from transfers](/storage-
      transfer/docs/filtering-objects-from-transfers).
    lastModifiedBefore: If specified, only objects with a "last modification
      time" before this timestamp and objects that don't have a "last
      modification time" are transferred.
    lastModifiedSince: If specified, only objects with a "last modification
      time" on or after this timestamp and objects that don't have a "last
      modification time" are transferred. The `last_modified_since` and
      `last_modified_before` fields can be used together for chunked data
      processing. For example, consider a script that processes each day's
      worth of data at a time. For that you'd set each of the fields as
      follows: * `last_modified_since` to the start of the day *
      `last_modified_before` to the end of the day
    maxTimeElapsedSinceLastModification: Ensures that objects are not
      transferred if a specific maximum time has elapsed since the "last
      modification time". When a TransferOperation begins, objects with a
      "last modification time" are transferred only if the elapsed time
      between the start_time of the `TransferOperation`and the "last
      modification time" of the object is less than the value of
      max_time_elapsed_since_last_modification`. Objects that do not have a
      "last modification time" are also transferred.
    minTimeElapsedSinceLastModification: Ensures that objects are not
      transferred until a specific minimum time has elapsed after the "last
      modification time". When a TransferOperation begins, objects with a
      "last modification time" are transferred only if the elapsed time
      between the start_time of the `TransferOperation` and the "last
      modification time" of the object is equal to or greater than the value
      of min_time_elapsed_since_last_modification`. Objects that do not have a
      "last modification time" are also transferred.
  """

  excludePrefixes = _messages.StringField(1, repeated=True)
  includePrefixes = _messages.StringField(2, repeated=True)
  lastModifiedBefore = _messages.StringField(3)
  lastModifiedSince = _messages.StringField(4)
  maxTimeElapsedSinceLastModification = _messages.StringField(5)
  minTimeElapsedSinceLastModification = _messages.StringField(6)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Represents the transfer operation object. To request a
      TransferOperation object, use transferOperations.get.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Represents the transfer operation object. To request a
      TransferOperation object, use transferOperations.get.
    name: The server-assigned unique name. The format of `name` is
      `transferOperations/some/unique/name`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Represents the transfer operation object. To request a
    TransferOperation object, use transferOperations.get.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class PauseTransferOperationRequest(_messages.Message):
  r"""Request passed to PauseTransferOperation."""


class PosixFilesystem(_messages.Message):
  r"""A POSIX filesystem resource.

  Fields:
    rootDirectory: Root directory path to the filesystem.
  """

  rootDirectory = _messages.StringField(1)


class ResumeTransferOperationRequest(_messages.Message):
  r"""Request passed to ResumeTransferOperation."""


class RunTransferJobRequest(_messages.Message):
  r"""Request passed to RunTransferJob.

  Fields:
    projectId: Required. The ID of the Google Cloud project that owns the
      transfer job.
  """

  projectId = _messages.StringField(1)


class Schedule(_messages.Message):
  r"""Transfers can be scheduled to recur or to run just once.

  Fields:
    endTimeOfDay: The time in UTC that no further transfer operations are
      scheduled. Combined with schedule_end_date, `end_time_of_day` specifies
      the end date and time for starting new transfer operations. This field
      must be greater than or equal to the timestamp corresponding to the
      combintation of schedule_start_date and start_time_of_day, and is
      subject to the following: * If `end_time_of_day` is not set and
      `schedule_end_date` is set, then a default value of `23:59:59` is used
      for `end_time_of_day`. * If `end_time_of_day` is set and
      `schedule_end_date` is not set, then INVALID_ARGUMENT is returned.
    repeatInterval: Interval between the start of each scheduled
      TransferOperation. If unspecified, the default value is 24 hours. This
      value may not be less than 1 hour.
    scheduleEndDate: The last day a transfer runs. Date boundaries are
      determined relative to UTC time. A job runs once per 24 hours within the
      following guidelines: * If `schedule_end_date` and schedule_start_date
      are the same and in the future relative to UTC, the transfer is executed
      only one time. * If `schedule_end_date` is later than
      `schedule_start_date` and `schedule_end_date` is in the future relative
      to UTC, the job runs each day at start_time_of_day through
      `schedule_end_date`.
    scheduleStartDate: Required. The start date of a transfer. Date boundaries
      are determined relative to UTC time. If `schedule_start_date` and
      start_time_of_day are in the past relative to the job's creation time,
      the transfer starts the day after you schedule the transfer request.
      **Note:** When starting jobs at or near midnight UTC it is possible that
      a job starts later than expected. For example, if you send an outbound
      request on June 1 one millisecond prior to midnight UTC and the Storage
      Transfer Service server receives the request on June 2, then it creates
      a TransferJob with `schedule_start_date` set to June 2 and a
      `start_time_of_day` set to midnight UTC. The first scheduled
      TransferOperation takes place on June 3 at midnight UTC.
    startTimeOfDay: The time in UTC that a transfer job is scheduled to run.
      Transfers may start later than this time. If `start_time_of_day` is not
      specified: * One-time transfers run immediately. * Recurring transfers
      run immediately, and each day at midnight UTC, through
      schedule_end_date. If `start_time_of_day` is specified: * One-time
      transfers run at the specified time. * Recurring transfers run at the
      specified time each day, through `schedule_end_date`.
  """

  endTimeOfDay = _messages.MessageField('TimeOfDay', 1)
  repeatInterval = _messages.StringField(2)
  scheduleEndDate = _messages.MessageField('Date', 3)
  scheduleStartDate = _messages.MessageField('Date', 4)
  startTimeOfDay = _messages.MessageField('TimeOfDay', 5)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StoragetransferGoogleServiceAccountsGetRequest(_messages.Message):
  r"""A StoragetransferGoogleServiceAccountsGetRequest object.

  Fields:
    projectId: Required. The ID of the Google Cloud project that the Google
      service account is associated with.
  """

  projectId = _messages.StringField(1, required=True)


class StoragetransferProjectsAgentPoolsCreateRequest(_messages.Message):
  r"""A StoragetransferProjectsAgentPoolsCreateRequest object.

  Fields:
    agentPool: A AgentPool resource to be passed as the request body.
    agentPoolId: Required. The ID of the agent pool to create. The
      `agent_pool_id` must meet the following requirements: * Length of 128
      characters or less. * Not start with the string `goog`. * Start with a
      lowercase ASCII character, followed by: * Zero or more: lowercase Latin
      alphabet characters, numerals, hyphens (`-`), periods (`.`), underscores
      (`_`), or tildes (`~`). * One or more numerals or lowercase ASCII
      characters. As expressed by the regular expression:
      `^(?!goog)[a-z]([a-z0-9-._~]*[a-z0-9])?$`.
    projectId: Required. The ID of the Google Cloud project that owns the
      agent pool.
  """

  agentPool = _messages.MessageField('AgentPool', 1)
  agentPoolId = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)


class StoragetransferProjectsAgentPoolsDeleteRequest(_messages.Message):
  r"""A StoragetransferProjectsAgentPoolsDeleteRequest object.

  Fields:
    name: Required. The name of the agent pool to delete.
  """

  name = _messages.StringField(1, required=True)


class StoragetransferProjectsAgentPoolsGetRequest(_messages.Message):
  r"""A StoragetransferProjectsAgentPoolsGetRequest object.

  Fields:
    name: Required. The name of the agent pool to get.
  """

  name = _messages.StringField(1, required=True)


class StoragetransferProjectsAgentPoolsListRequest(_messages.Message):
  r"""A StoragetransferProjectsAgentPoolsListRequest object.

  Fields:
    filter: An optional list of query parameters specified as JSON text in the
      form of: `{"agentPoolNames":["agentpool1","agentpool2",...]}` Since
      `agentPoolNames` support multiple values, its values must be specified
      with array notation. When the filter is either empty or not provided,
      the list returns all agent pools for the project.
    pageSize: The list page size. The max allowed value is `256`.
    pageToken: The list page token.
    projectId: Required. The ID of the Google Cloud project that owns the job.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  projectId = _messages.StringField(4, required=True)


class StoragetransferProjectsAgentPoolsPatchRequest(_messages.Message):
  r"""A StoragetransferProjectsAgentPoolsPatchRequest object.

  Fields:
    agentPool: A AgentPool resource to be passed as the request body.
    name: Required. Specifies a unique string that identifies the agent pool.
      Format: `projects/{project_id}/agentPools/{agent_pool_id}`
    updateMask: The [field mask] (https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf) of the fields in `agentPool` to
      update in this request. The following `agentPool` fields can be updated:
      * display_name * bandwidth_limit
  """

  agentPool = _messages.MessageField('AgentPool', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class StoragetransferTransferJobsGetRequest(_messages.Message):
  r"""A StoragetransferTransferJobsGetRequest object.

  Fields:
    jobName: Required. The job to get.
    projectId: Required. The ID of the Google Cloud project that owns the job.
  """

  jobName = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)


class StoragetransferTransferJobsListRequest(_messages.Message):
  r"""A StoragetransferTransferJobsListRequest object.

  Fields:
    filter: Required. A list of query parameters specified as JSON text in the
      form of: `{"projectId":"my_project_id",
      "jobNames":["jobid1","jobid2",...],
      "jobStatuses":["status1","status2",...]}` Since `jobNames` and
      `jobStatuses` support multiple values, their values must be specified
      with array notation. `projectId` is required. `jobNames` and
      `jobStatuses` are optional. The valid values for `jobStatuses` are case-
      insensitive: ENABLED, DISABLED, and DELETED.
    pageSize: The list page size. The max allowed value is 256.
    pageToken: The list page token.
  """

  filter = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class StoragetransferTransferJobsPatchRequest(_messages.Message):
  r"""A StoragetransferTransferJobsPatchRequest object.

  Fields:
    jobName: Required. The name of job to update.
    updateTransferJobRequest: A UpdateTransferJobRequest resource to be passed
      as the request body.
  """

  jobName = _messages.StringField(1, required=True)
  updateTransferJobRequest = _messages.MessageField('UpdateTransferJobRequest', 2)


class StoragetransferTransferJobsRunRequest(_messages.Message):
  r"""A StoragetransferTransferJobsRunRequest object.

  Fields:
    jobName: Required. The name of the transfer job.
    runTransferJobRequest: A RunTransferJobRequest resource to be passed as
      the request body.
  """

  jobName = _messages.StringField(1, required=True)
  runTransferJobRequest = _messages.MessageField('RunTransferJobRequest', 2)


class StoragetransferTransferOperationsCancelRequest(_messages.Message):
  r"""A StoragetransferTransferOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class StoragetransferTransferOperationsGetRequest(_messages.Message):
  r"""A StoragetransferTransferOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class StoragetransferTransferOperationsListRequest(_messages.Message):
  r"""A StoragetransferTransferOperationsListRequest object.

  Fields:
    filter: Required. A list of query parameters specified as JSON text in the
      form of: `{"projectId":"my_project_id",
      "jobNames":["jobid1","jobid2",...],
      "operationNames":["opid1","opid2",...],
      "transferStatuses":["status1","status2",...]}` Since `jobNames`,
      `operationNames`, and `transferStatuses` support multiple values, they
      must be specified with array notation. `projectId` is required.
      `jobNames`, `operationNames`, and `transferStatuses` are optional. The
      valid values for `transferStatuses` are case-insensitive: IN_PROGRESS,
      PAUSED, SUCCESS, FAILED, and ABORTED.
    name: Not used.
    pageSize: The list page size. The max allowed value is 256.
    pageToken: The list page token.
  """

  filter = _messages.StringField(1, required=True)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class StoragetransferTransferOperationsPauseRequest(_messages.Message):
  r"""A StoragetransferTransferOperationsPauseRequest object.

  Fields:
    name: Required. The name of the transfer operation.
    pauseTransferOperationRequest: A PauseTransferOperationRequest resource to
      be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  pauseTransferOperationRequest = _messages.MessageField('PauseTransferOperationRequest', 2)


class StoragetransferTransferOperationsResumeRequest(_messages.Message):
  r"""A StoragetransferTransferOperationsResumeRequest object.

  Fields:
    name: Required. The name of the transfer operation.
    resumeTransferOperationRequest: A ResumeTransferOperationRequest resource
      to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  resumeTransferOperationRequest = _messages.MessageField('ResumeTransferOperationRequest', 2)


class TimeOfDay(_messages.Message):
  r"""Represents a time of day. The date and time zone are either not
  significant or are specified elsewhere. An API may choose to allow leap
  seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.

  Fields:
    hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may
      choose to allow the value "24:00:00" for scenarios like business closing
      time.
    minutes: Minutes of hour of day. Must be from 0 to 59.
    nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An
      API may allow the value 60 if it allows leap-seconds.
  """

  hours = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minutes = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  nanos = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  seconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class TransferCounters(_messages.Message):
  r"""A collection of counters that report the progress of a transfer
  operation.

  Fields:
    bytesCopiedToSink: Bytes that are copied to the data sink.
    bytesDeletedFromSink: Bytes that are deleted from the data sink.
    bytesDeletedFromSource: Bytes that are deleted from the data source.
    bytesFailedToDeleteFromSink: Bytes that failed to be deleted from the data
      sink.
    bytesFoundFromSource: Bytes found in the data source that are scheduled to
      be transferred, excluding any that are filtered based on object
      conditions or skipped due to sync.
    bytesFoundOnlyFromSink: Bytes found only in the data sink that are
      scheduled to be deleted.
    bytesFromSourceFailed: Bytes in the data source that failed to be
      transferred or that failed to be deleted after being transferred.
    bytesFromSourceSkippedBySync: Bytes in the data source that are not
      transferred because they already exist in the data sink.
    directoriesFailedToListFromSource: For transfers involving PosixFilesystem
      only. Number of listing failures for each directory found at the source.
      Potential failures when listing a directory include permission failure
      or block failure. If listing a directory fails, no files in the
      directory are transferred.
    directoriesFoundFromSource: For transfers involving PosixFilesystem only.
      Number of directories found while listing. For example, if the root
      directory of the transfer is `base/` and there are two other
      directories, `a/` and `b/` under this directory, the count after listing
      `base/`, `base/a/` and `base/b/` is 3.
    directoriesSuccessfullyListedFromSource: For transfers involving
      PosixFilesystem only. Number of successful listings for each directory
      found at the source.
    intermediateObjectsCleanedUp: Number of successfully cleaned up
      intermediate objects.
    intermediateObjectsFailedCleanedUp: Number of intermediate objects failed
      cleaned up.
    objectsCopiedToSink: Objects that are copied to the data sink.
    objectsDeletedFromSink: Objects that are deleted from the data sink.
    objectsDeletedFromSource: Objects that are deleted from the data source.
    objectsFailedToDeleteFromSink: Objects that failed to be deleted from the
      data sink.
    objectsFoundFromSource: Objects found in the data source that are
      scheduled to be transferred, excluding any that are filtered based on
      object conditions or skipped due to sync.
    objectsFoundOnlyFromSink: Objects found only in the data sink that are
      scheduled to be deleted.
    objectsFromSourceFailed: Objects in the data source that failed to be
      transferred or that failed to be deleted after being transferred.
    objectsFromSourceSkippedBySync: Objects in the data source that are not
      transferred because they already exist in the data sink.
  """

  bytesCopiedToSink = _messages.IntegerField(1)
  bytesDeletedFromSink = _messages.IntegerField(2)
  bytesDeletedFromSource = _messages.IntegerField(3)
  bytesFailedToDeleteFromSink = _messages.IntegerField(4)
  bytesFoundFromSource = _messages.IntegerField(5)
  bytesFoundOnlyFromSink = _messages.IntegerField(6)
  bytesFromSourceFailed = _messages.IntegerField(7)
  bytesFromSourceSkippedBySync = _messages.IntegerField(8)
  directoriesFailedToListFromSource = _messages.IntegerField(9)
  directoriesFoundFromSource = _messages.IntegerField(10)
  directoriesSuccessfullyListedFromSource = _messages.IntegerField(11)
  intermediateObjectsCleanedUp = _messages.IntegerField(12)
  intermediateObjectsFailedCleanedUp = _messages.IntegerField(13)
  objectsCopiedToSink = _messages.IntegerField(14)
  objectsDeletedFromSink = _messages.IntegerField(15)
  objectsDeletedFromSource = _messages.IntegerField(16)
  objectsFailedToDeleteFromSink = _messages.IntegerField(17)
  objectsFoundFromSource = _messages.IntegerField(18)
  objectsFoundOnlyFromSink = _messages.IntegerField(19)
  objectsFromSourceFailed = _messages.IntegerField(20)
  objectsFromSourceSkippedBySync = _messages.IntegerField(21)


class TransferJob(_messages.Message):
  r"""This resource represents the configuration of a transfer job that runs
  periodically.

  Enums:
    StatusValueValuesEnum: Status of the job. This value MUST be specified for
      `CreateTransferJobRequests`. **Note:** The effect of the new job status
      takes place during a subsequent job run. For example, if you change the
      job status from ENABLED to DISABLED, and an operation spawned by the
      transfer is running, the status change would not affect the current
      operation.

  Fields:
    creationTime: Output only. The time that the transfer job was created.
    deletionTime: Output only. The time that the transfer job was deleted.
    description: A description provided by the user for the job. Its max
      length is 1024 bytes when Unicode-encoded.
    lastModificationTime: Output only. The time that the transfer job was last
      modified.
    latestOperationName: The name of the most recently started
      TransferOperation of this JobConfig. Present if a TransferOperation has
      been created for this JobConfig.
    loggingConfig: Logging configuration.
    name: A unique name (within the transfer project) assigned when the job is
      created. If this field is empty in a CreateTransferJobRequest, Storage
      Transfer Service assigns a unique name. Otherwise, the specified name is
      used as the unique name for this job. If the specified name is in use by
      a job, the creation request fails with an ALREADY_EXISTS error. This
      name must start with `"transferJobs/"` prefix and end with a letter or a
      number, and should be no more than 128 characters. For transfers
      involving PosixFilesystem, this name must start with `transferJobs/OPI`
      specifically. For all other transfer types, this name must not start
      with `transferJobs/OPI`. Non-PosixFilesystem example:
      `"transferJobs/^(?!OPI)[A-Za-z0-9-._~]*[A-Za-z0-9]$"` PosixFilesystem
      example: `"transferJobs/OPI^[A-Za-z0-9-._~]*[A-Za-z0-9]$"` Applications
      must not rely on the enforcement of naming requirements involving OPI.
      Invalid job names fail with an INVALID_ARGUMENT error.
    notificationConfig: Notification configuration. This is not supported for
      transfers involving PosixFilesystem.
    projectId: The ID of the Google Cloud project that owns the job.
    schedule: Specifies schedule for the transfer job. This is an optional
      field. When the field is not set, the job never executes a transfer,
      unless you invoke RunTransferJob or update the job to have a non-empty
      schedule.
    status: Status of the job. This value MUST be specified for
      `CreateTransferJobRequests`. **Note:** The effect of the new job status
      takes place during a subsequent job run. For example, if you change the
      job status from ENABLED to DISABLED, and an operation spawned by the
      transfer is running, the status change would not affect the current
      operation.
    transferSpec: Transfer specification.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Status of the job. This value MUST be specified for
    `CreateTransferJobRequests`. **Note:** The effect of the new job status
    takes place during a subsequent job run. For example, if you change the
    job status from ENABLED to DISABLED, and an operation spawned by the
    transfer is running, the status change would not affect the current
    operation.

    Values:
      STATUS_UNSPECIFIED: Zero is an illegal value.
      ENABLED: New transfers are performed based on the schedule.
      DISABLED: New transfers are not scheduled.
      DELETED: This is a soft delete state. After a transfer job is set to
        this state, the job and all the transfer executions are subject to
        garbage collection. Transfer jobs become eligible for garbage
        collection 30 days after their status is set to `DELETED`.
    """
    STATUS_UNSPECIFIED = 0
    ENABLED = 1
    DISABLED = 2
    DELETED = 3

  creationTime = _messages.StringField(1)
  deletionTime = _messages.StringField(2)
  description = _messages.StringField(3)
  lastModificationTime = _messages.StringField(4)
  latestOperationName = _messages.StringField(5)
  loggingConfig = _messages.MessageField('LoggingConfig', 6)
  name = _messages.StringField(7)
  notificationConfig = _messages.MessageField('NotificationConfig', 8)
  projectId = _messages.StringField(9)
  schedule = _messages.MessageField('Schedule', 10)
  status = _messages.EnumField('StatusValueValuesEnum', 11)
  transferSpec = _messages.MessageField('TransferSpec', 12)


class TransferManifest(_messages.Message):
  r"""Specifies where the manifest is located.

  Fields:
    location: Specifies the path to the manifest in Cloud Storage. The Google-
      managed service account for the transfer must have `storage.objects.get`
      permission for this object. An example path is
      `gs://bucket_name/path/manifest.csv`.
  """

  location = _messages.StringField(1)


class TransferOperation(_messages.Message):
  r"""A description of the execution of a transfer.

  Enums:
    StatusValueValuesEnum: Status of the transfer operation.

  Fields:
    counters: Information about the progress of the transfer operation.
    endTime: End time of this transfer execution.
    errorBreakdowns: Summarizes errors encountered with sample error log
      entries.
    name: A globally unique ID assigned by the system.
    notificationConfig: Notification configuration.
    projectId: The ID of the Google Cloud project that owns the operation.
    startTime: Start time of this transfer execution.
    status: Status of the transfer operation.
    transferJobName: The name of the transfer job that triggers this transfer
      operation.
    transferSpec: Transfer specification.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Status of the transfer operation.

    Values:
      STATUS_UNSPECIFIED: Zero is an illegal value.
      IN_PROGRESS: In progress.
      PAUSED: Paused.
      SUCCESS: Completed successfully.
      FAILED: Terminated due to an unrecoverable failure.
      ABORTED: Aborted by the user.
      QUEUED: Temporarily delayed by the system. No user action is required.
    """
    STATUS_UNSPECIFIED = 0
    IN_PROGRESS = 1
    PAUSED = 2
    SUCCESS = 3
    FAILED = 4
    ABORTED = 5
    QUEUED = 6

  counters = _messages.MessageField('TransferCounters', 1)
  endTime = _messages.StringField(2)
  errorBreakdowns = _messages.MessageField('ErrorSummary', 3, repeated=True)
  name = _messages.StringField(4)
  notificationConfig = _messages.MessageField('NotificationConfig', 5)
  projectId = _messages.StringField(6)
  startTime = _messages.StringField(7)
  status = _messages.EnumField('StatusValueValuesEnum', 8)
  transferJobName = _messages.StringField(9)
  transferSpec = _messages.MessageField('TransferSpec', 10)


class TransferOptions(_messages.Message):
  r"""TransferOptions define the actions to be performed on objects in a
  transfer.

  Fields:
    deleteObjectsFromSourceAfterTransfer: Whether objects should be deleted
      from the source after they are transferred to the sink. **Note:** This
      option and delete_objects_unique_in_sink are mutually exclusive.
    deleteObjectsUniqueInSink: Whether objects that exist only in the sink
      should be deleted. **Note:** This option and
      delete_objects_from_source_after_transfer are mutually exclusive.
    overwriteObjectsAlreadyExistingInSink: When to overwrite objects that
      already exist in the sink. The default is that only objects that are
      different from the source are ovewritten. If true, all objects in the
      sink whose name matches an object in the source are overwritten with the
      source object.
  """

  deleteObjectsFromSourceAfterTransfer = _messages.BooleanField(1)
  deleteObjectsUniqueInSink = _messages.BooleanField(2)
  overwriteObjectsAlreadyExistingInSink = _messages.BooleanField(3)


class TransferSpec(_messages.Message):
  r"""Configuration for running a transfer.

  Fields:
    awsS3DataSource: An AWS S3 data source.
    azureBlobStorageDataSource: An Azure Blob Storage data source.
    gcsDataSink: A Cloud Storage data sink.
    gcsDataSource: A Cloud Storage data source.
    httpDataSource: An HTTP URL data source.
    objectConditions: Only objects that satisfy these object conditions are
      included in the set of data source and data sink objects. Object
      conditions based on objects' "last modification time" do not exclude
      objects in a data sink.
    posixDataSink: A POSIX Filesystem data sink.
    posixDataSource: A POSIX Filesystem data source.
    sinkAgentPoolName: Specifies the agent pool name associated with the posix
      data sink. When unspecified, the default name is used.
    sourceAgentPoolName: Specifies the agent pool name associated with the
      posix data source. When unspecified, the default name is used.
    transferManifest: A manifest file provides a list of objects to be
      transferred from the data source. This field points to the location of
      the manifest file. Otherwise, the entire source bucket is used.
      ObjectConditions still apply.
    transferOptions: If the option delete_objects_unique_in_sink is `true` and
      time-based object conditions such as 'last modification time' are
      specified, the request fails with an INVALID_ARGUMENT error.
  """

  awsS3DataSource = _messages.MessageField('AwsS3Data', 1)
  azureBlobStorageDataSource = _messages.MessageField('AzureBlobStorageData', 2)
  gcsDataSink = _messages.MessageField('GcsData', 3)
  gcsDataSource = _messages.MessageField('GcsData', 4)
  httpDataSource = _messages.MessageField('HttpData', 5)
  objectConditions = _messages.MessageField('ObjectConditions', 6)
  posixDataSink = _messages.MessageField('PosixFilesystem', 7)
  posixDataSource = _messages.MessageField('PosixFilesystem', 8)
  sinkAgentPoolName = _messages.StringField(9)
  sourceAgentPoolName = _messages.StringField(10)
  transferManifest = _messages.MessageField('TransferManifest', 11)
  transferOptions = _messages.MessageField('TransferOptions', 12)


class UpdateTransferJobRequest(_messages.Message):
  r"""Request passed to UpdateTransferJob.

  Fields:
    projectId: Required. The ID of the Google Cloud project that owns the job.
    transferJob: Required. The job to update. `transferJob` is expected to
      specify only four fields: description, transfer_spec,
      notification_config, and status. An `UpdateTransferJobRequest` that
      specifies other fields are rejected with the error INVALID_ARGUMENT.
      Updating a job status to DELETED requires `storagetransfer.jobs.delete`
      permissions.
    updateTransferJobFieldMask: The field mask of the fields in `transferJob`
      that are to be updated in this request. Fields in `transferJob` that can
      be updated are: description, transfer_spec, notification_config, and
      status. To update the `transfer_spec` of the job, a complete transfer
      specification must be provided. An incomplete specification missing any
      required fields is rejected with the error INVALID_ARGUMENT.
  """

  projectId = _messages.StringField(1)
  transferJob = _messages.MessageField('TransferJob', 2)
  updateTransferJobFieldMask = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
