"""Generated message classes for runapps version v1alpha1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'runapps'


class Application(_messages.Message):
  r"""Message describing Application object Next tag: 8

  Messages:
    AnnotationsValue: Unstructured key value map that may be set by external
      tools to store and arbitrary metadata. They are not queryable and should
      be preserved when modifying objects. This field follows Kubernetes
      annotations' namespacing, limits, and rules. More info:
      http://kubernetes.io/docs/user-guide/annotations
    LabelsValue: Labels as key value pairs

  Fields:
    annotations: Unstructured key value map that may be set by external tools
      to store and arbitrary metadata. They are not queryable and should be
      preserved when modifying objects. This field follows Kubernetes
      annotations' namespacing, limits, and rules. More info:
      http://kubernetes.io/docs/user-guide/annotations
    config: The application configuration. On output, both intent repo and
      application config are populated. On input, only one can be modified at
      a time.
    createTime: Output only. Create time stamp
    deleteTime: Output only. For a deleted resource, the deletion time. It is
      only populated as a response to a Delete request.
    etag: Output only. A system-generated fingerprint for this version of the
      resource. May be used to detect modification conflict during updates.
    labels: Labels as key value pairs
    name: name of resource
    reconciling: Output only. Indicates whether the resource's reconciliation
      is still in progress.
    updateTime: Output only. Update time stamp
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Unstructured key value map that may be set by external tools to store
    and arbitrary metadata. They are not queryable and should be preserved
    when modifying objects. This field follows Kubernetes annotations'
    namespacing, limits, and rules. More info: http://kubernetes.io/docs/user-
    guide/annotations

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  config = _messages.MessageField('Config', 2)
  createTime = _messages.StringField(3)
  deleteTime = _messages.StringField(4)
  etag = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  reconciling = _messages.BooleanField(8)
  updateTime = _messages.StringField(9)


class ApplicationStatus(_messages.Message):
  r"""Status of the application.

  Fields:
    modifyTime: Time at which the status was last updated.
    name: The resource name of the application status, in the following form:
      `projects/{project}/locations/{location}/applications/{name}/status`
    resource: Repeated field with status per resource.
  """

  modifyTime = _messages.StringField(1)
  name = _messages.StringField(2)
  resource = _messages.MessageField('ResourceStatus', 3, repeated=True)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Cloud Platform
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloudRunServiceConfig(_messages.Message):
  r"""Message for Cloud Run service configs.

  Fields:
    image: The container image to deploy the service with.
    resources: Bindings to other resources.
  """

  image = _messages.StringField(1)
  resources = _messages.MessageField('ServiceResourceBindingConfig', 2, repeated=True)


class CloudSqlConfig(_messages.Message):
  r"""Message for a Cloud SQL resource.

  Fields:
    settings: Settings for the Cloud SQL instance.
    version: The database version. e.g. "MYSQL_8_0". The version must match
      one of the values at https://cloud.google.com/sql/docs/mysql/admin-
      api/rest/v1beta4/SqlDatabaseVersion.
  """

  settings = _messages.MessageField('CloudSqlSettings', 1)
  version = _messages.StringField(2)


class CloudSqlSettings(_messages.Message):
  r"""Message for settings for a CloudSql instance.

  Fields:
    activation_policy: The activation policy of the Cloud SQL instance. e.g.
      "ALWAYS".
    availability_type: The availability type of the Cloud SQL instance. e.g.
      "REGIONAL".
    disk_size: The disk size of the Cloud SQL instance, in GB. This value
      cannot be decreased on Update.
    disk_type: The type of disk for the Cloud SQL instance. e.g. "PD_SSD".
    tier: Tier of the Cloud SQL instance. e.g. "db-f1-micro".
  """

  activation_policy = _messages.StringField(1)
  availability_type = _messages.StringField(2)
  disk_size = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  disk_type = _messages.StringField(4)
  tier = _messages.StringField(5)


class CloudStorage(_messages.Message):
  r"""Configures a Cloud Storage location.

  Fields:
    bucket: Google Cloud Storage bucket containing the source (see Bucket Name
      Requirements).
    object: Google Cloud Storage object containing the source.
  """

  bucket = _messages.StringField(1)
  object = _messages.StringField(2)


class Config(_messages.Message):
  r"""Message for the Application Config Next tag: 6

  Messages:
    ResourcesValue: A ResourcesValue object.

  Fields:
    config: A byte array encapsulating the contents of the application config.
      This can be of any type of supported config (Simple SAF Yaml, multi-file
      in-app config, etc.)
    resources: A ResourcesValue attribute.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResourcesValue(_messages.Message):
    r"""A ResourcesValue object.

    Messages:
      AdditionalProperty: An additional property for a ResourcesValue object.

    Fields:
      additionalProperties: Additional properties of type ResourcesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResourcesValue object.

      Fields:
        key: Name of the additional property.
        value: A ResourceConfig attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ResourceConfig', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  config = _messages.BytesField(1)
  resources = _messages.MessageField('ResourcesValue', 2)


class Deployment(_messages.Message):
  r"""Message describing Deployment object Next tag: 13

  Messages:
    AnnotationsValue: Unstructured key value map that may be set by external
      tools to store and arbitrary metadata. They are not queryable and should
      be preserved when modifying objects. This field follows Kubernetes
      annotations' namespacing, limits, and rules. More info:
      http://kubernetes.io/docs/user-guide/annotations
    LabelsValue: Labels as key value pairs

  Fields:
    annotations: Unstructured key value map that may be set by external tools
      to store and arbitrary metadata. They are not queryable and should be
      preserved when modifying objects. This field follows Kubernetes
      annotations' namespacing, limits, and rules. More info:
      http://kubernetes.io/docs/user-guide/annotations
    application: Output only. The name of the parent application.
    createSelector: Optional selectors that should be applied to limit the
      scope of the deployment creation.
    createTime: Output only. Create time stamp
    deleteSelector: Optional selectors that should be applied to limit the
      scope of the deployment deletion.
    deleteTime: Output only. For a deleted resource, the deletion time. It is
      only populated as a response to a Delete request.
    etag: Output only. A system-generated fingerprint for this version of the
      resource. May be used to detect modification conflict during updates.
    labels: Labels as key value pairs
    name: Output only. Canonical name of resource
    reconciling: Output only. Indicates whether the resource's reconciliation
      is still in progress.
    render: If specified, the configurations for the deployment will be output
      as described but the underlying resources will not be actuated.
    serviceAccount: Email address of the service account to use for the
      resource actuation.
    status: Output only. The status of the deployment
    updateTime: Output only. Update time stamp
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Unstructured key value map that may be set by external tools to store
    and arbitrary metadata. They are not queryable and should be preserved
    when modifying objects. This field follows Kubernetes annotations'
    namespacing, limits, and rules. More info: http://kubernetes.io/docs/user-
    guide/annotations

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  application = _messages.StringField(2)
  createSelector = _messages.MessageField('Selector', 3)
  createTime = _messages.StringField(4)
  deleteSelector = _messages.MessageField('Selector', 5)
  deleteTime = _messages.StringField(6)
  etag = _messages.StringField(7)
  labels = _messages.MessageField('LabelsValue', 8)
  name = _messages.StringField(9)
  reconciling = _messages.BooleanField(10)
  render = _messages.MessageField('Render', 11)
  serviceAccount = _messages.StringField(12)
  status = _messages.MessageField('DeploymentStatus', 13)
  updateTime = _messages.StringField(14)


class DeploymentStatus(_messages.Message):
  r"""Message to encapsulate the current status of the deployment.

  Fields:
    errorMessage: The error message associated with a failed deployment state,
      if applicable.
    status: The status message associated with the current state of the
      deployment.
  """

  errorMessage = _messages.StringField(1)
  status = _messages.StringField(2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GcpResourceStatus(_messages.Message):
  r"""Status for a GCP resource.

  Enums:
    StateValueValuesEnum: The state of the GCP resource.

  Fields:
    errorMessage: The error message associated with the GCP resource, if
      applicable.
    gcpResourceName: The full path of the GCP resource, which can be used to
      query other GCP services.
    state: The state of the GCP resource.
    type: The type of the GCP resource (e.g. "redis").
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of the GCP resource.

    Values:
      GCP_RESOURCE_STATE_UNKNOWN: <no description>
      GCP_RESOURCE_STATE_DEPLOYED: The resource has been deployed.
    """
    GCP_RESOURCE_STATE_UNKNOWN = 0
    GCP_RESOURCE_STATE_DEPLOYED = 1

  errorMessage = _messages.StringField(1)
  gcpResourceName = _messages.StringField(2)
  state = _messages.EnumField('StateValueValuesEnum', 3)
  type = _messages.StringField(4)


class ListApplicationsResponse(_messages.Message):
  r"""Message for response to listing Applications

  Fields:
    applications: The list of Application
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  applications = _messages.MessageField('Application', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListDeploymentsResponse(_messages.Message):
  r"""Message for response to listing Deployments

  Fields:
    deployments: The list of Deployment
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  deployments = _messages.MessageField('Deployment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: API version used to start the operation.
    createTime: The time the operation was created.
    endTime: The time the operation finished running.
    requestedCancellation: Identifies whether the user has requested
      cancellation of the operation. Operations that have successfully been
      cancelled have Operation.error value with a google.rpc.Status.code of 1,
      corresponding to `Code.CANCELLED`.
    statusMessage: Human-readable status of the operation, if any.
    target: Server-defined resource path for the target of the operation.
    verb: Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  bindings = _messages.MessageField('Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class RedisConfig(_messages.Message):
  r"""Message for Redis configs.

  Fields:
    instance: Configs for the Redis instance.
  """

  instance = _messages.MessageField('RedisInstanceConfig', 1)


class RedisInstanceConfig(_messages.Message):
  r"""Message for Redis instance configs.

  Messages:
    RedisParametersValue: The "raw" Redis configs:
      https://redis.io/topics/config

  Fields:
    memory_size_gb: The redis instance memory size, in GB.
    redis_parameters: The "raw" Redis configs: https://redis.io/topics/config
    tier: The Redis instance tier, e.g. "STANDARD_HA".
    version: The Redis instance version, e.g. "REDIS_4_0".
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RedisParametersValue(_messages.Message):
    r"""The "raw" Redis configs: https://redis.io/topics/config

    Messages:
      AdditionalProperty: An additional property for a RedisParametersValue
        object.

    Fields:
      additionalProperties: Additional properties of type RedisParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RedisParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  memory_size_gb = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  redis_parameters = _messages.MessageField('RedisParametersValue', 2)
  tier = _messages.StringField(3)
  version = _messages.StringField(4)


class Render(_messages.Message):
  r"""Message to encapsulate the parameters for a Render.

  Enums:
    FormatValueValuesEnum: The format in which to render the Application.

  Fields:
    format: The format in which to render the Application.
    outputLocation: The output location to push the rendered configs to.
  """

  class FormatValueValuesEnum(_messages.Enum):
    r"""The format in which to render the Application.

    Values:
      RENDER_FORMAT_UNKNOWN: No render format specified.
      RENDER_FORMAT_TERRAFORM: Render into Terraform configs.
      RENDER_FORMAT_KRM: Render into KRM configs.
    """
    RENDER_FORMAT_UNKNOWN = 0
    RENDER_FORMAT_TERRAFORM = 1
    RENDER_FORMAT_KRM = 2

  format = _messages.EnumField('FormatValueValuesEnum', 1)
  outputLocation = _messages.MessageField('Target', 2)


class ResourceConfig(_messages.Message):
  r"""Message for the Resource configuration.

  Fields:
    cloudsql: CloudSql configuration.
    redis: Redis configuration.
    router: Router configuration.
    service: Cloud Run service configuration.
    vpc: VPC configuration.
  """

  cloudsql = _messages.MessageField('CloudSqlConfig', 1)
  redis = _messages.MessageField('RedisConfig', 2)
  router = _messages.MessageField('RouterConfig', 3)
  service = _messages.MessageField('CloudRunServiceConfig', 4)
  vpc = _messages.MessageField('VPCConfig', 5)


class ResourceStatus(_messages.Message):
  r"""Status for a resource.

  Enums:
    StateValueValuesEnum: The enum status of the resource.

  Fields:
    errorMessage: The error message associated with the resource, if
      applicable.
    gcpResource: Repeated field with status per GCP resource created for this
      resource.
    resourceName: Name of the resource, pulled from the Application Config.
    state: The enum status of the resource.
    type: Type of resource.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The enum status of the resource.

    Values:
      RESOURCE_STATE_UNKNOWN: <no description>
      RESOURCE_STATE_DEPLOYED: The resource has been deployed.
    """
    RESOURCE_STATE_UNKNOWN = 0
    RESOURCE_STATE_DEPLOYED = 1

  errorMessage = _messages.StringField(1)
  gcpResource = _messages.MessageField('GcpResourceStatus', 2, repeated=True)
  resourceName = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  type = _messages.StringField(5)


class Route(_messages.Message):
  r"""Message for a single routeable resource within a Router.

  Fields:
    cdn: Whether to enable CDN on the route.
    paths: List of paths to be routed to this route. e.g. ["/*, /api/*"]. The
      path must fit the constraints at https://cloud.google.com/load-
      balancing/docs/url-map-concepts#pm-constraints.
    ref: Required. A reference to the resource in the config to which this is
      routing. e.g. "cloudsql/sql_db".
  """

  cdn = _messages.BooleanField(1)
  paths = _messages.StringField(2, repeated=True)
  ref = _messages.StringField(3)


class RouterConfig(_messages.Message):
  r"""Message for a Router resource.

  Fields:
    default_route: The default route config. The URL paths field is not
      required for this route config.
    dns_zone: DNSZone represents an existing DNS zone for the router. It's
      used for bring-your-own-DNSZone case. If empty, a new managed DNS zone
      shall be created.
    domain: Domain name to associate with the router.
    routes: A list of route configurations to associate with the router. Each
      Route configuration must include a paths configuration.
  """

  default_route = _messages.MessageField('Route', 1)
  dns_zone = _messages.StringField(2)
  domain = _messages.StringField(3)
  routes = _messages.MessageField('Route', 4, repeated=True)


class RunappsProjectsLocationsApplicationsCreateRequest(_messages.Message):
  r"""A RunappsProjectsLocationsApplicationsCreateRequest object.

  Fields:
    application: A Application resource to be passed as the request body.
    applicationId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and application_id from the
      method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  application = _messages.MessageField('Application', 1)
  applicationId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class RunappsProjectsLocationsApplicationsDeleteRequest(_messages.Message):
  r"""A RunappsProjectsLocationsApplicationsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and t he request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class RunappsProjectsLocationsApplicationsDeploymentsCreateRequest(_messages.Message):
  r"""A RunappsProjectsLocationsApplicationsDeploymentsCreateRequest object.

  Fields:
    deployment: A Deployment resource to be passed as the request body.
    deploymentId: Required. Id of the requesting object If auto-generating Id
      server-side, remove this field and deployment_id from the
      method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    validateOnly: If true, the Create request will just do a dry run of the
      deploy instead of actuating anything.
  """

  deployment = _messages.MessageField('Deployment', 1)
  deploymentId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  validateOnly = _messages.BooleanField(5)


class RunappsProjectsLocationsApplicationsDeploymentsGetRequest(_messages.Message):
  r"""A RunappsProjectsLocationsApplicationsDeploymentsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class RunappsProjectsLocationsApplicationsDeploymentsListRequest(_messages.Message):
  r"""A RunappsProjectsLocationsApplicationsDeploymentsListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListDeploymentsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class RunappsProjectsLocationsApplicationsGetIamPolicyRequest(_messages.Message):
  r"""A RunappsProjectsLocationsApplicationsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class RunappsProjectsLocationsApplicationsGetRequest(_messages.Message):
  r"""A RunappsProjectsLocationsApplicationsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class RunappsProjectsLocationsApplicationsGetStatusRequest(_messages.Message):
  r"""A RunappsProjectsLocationsApplicationsGetStatusRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class RunappsProjectsLocationsApplicationsListRequest(_messages.Message):
  r"""A RunappsProjectsLocationsApplicationsListRequest object.

  Fields:
    filter: Filtering results
    orderBy: Hint for how to order the results
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A token identifying a page of results the server should return.
    parent: Required. Parent value for ListApplicationsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class RunappsProjectsLocationsApplicationsPatchRequest(_messages.Message):
  r"""A RunappsProjectsLocationsApplicationsPatchRequest object.

  Fields:
    application: A Application resource to be passed as the request body.
    name: name of resource
    requestId: An optional request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server will know
      to ignore the request if it has already been completed. The server will
      guarantee that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and t he
      request times out. If you make the request again with the same request
      ID, the server can check if original operation with the same request ID
      was received, and if so, will ignore the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the Application resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  application = _messages.MessageField('Application', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class RunappsProjectsLocationsApplicationsSetIamPolicyRequest(_messages.Message):
  r"""A RunappsProjectsLocationsApplicationsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class RunappsProjectsLocationsApplicationsTestIamPermissionsRequest(_messages.Message):
  r"""A RunappsProjectsLocationsApplicationsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class RunappsProjectsLocationsGetRequest(_messages.Message):
  r"""A RunappsProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class RunappsProjectsLocationsListRequest(_messages.Message):
  r"""A RunappsProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like "displayName=tokyo", and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class RunappsProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A RunappsProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class RunappsProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A RunappsProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class RunappsProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A RunappsProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class RunappsProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A RunappsProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class Selector(_messages.Message):
  r"""Message for selecting the resources within an application. Next tag: 3

  Fields:
    matchTypeNames: match_type_names is a list resource name + type to match.
      Use '*' or empty string for wildcard either the name or the type. E.g.
      type='service' name='' will match all services. type='*' name='default'
      will match all resources named as 'default'.
    notTypeNames: not_type_names excludes the names + types. If a type+name is
      in this list as well as match_type_names, it will not be selected.
  """

  matchTypeNames = _messages.MessageField('TypedName', 1, repeated=True)
  notTypeNames = _messages.MessageField('TypedName', 2, repeated=True)


class ServiceResourceBindingConfig(_messages.Message):
  r"""Message for a binding between a Cloud Run service and a resource.

  Messages:
    BindingConfigValue: Any configs associated with the binding. e.g. "db-
      name-env-name": "SQL_NAME".

  Fields:
    binding_config: Any configs associated with the binding. e.g. "db-name-
      env-name": "SQL_NAME".
    ref: Ref to another resource. Format: "/", e.g. "cloudsql/sql_db".
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class BindingConfigValue(_messages.Message):
    r"""Any configs associated with the binding. e.g. "db-name-env-name":
    "SQL_NAME".

    Messages:
      AdditionalProperty: An additional property for a BindingConfigValue
        object.

    Fields:
      additionalProperties: Additional properties of type BindingConfigValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a BindingConfigValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  binding_config = _messages.MessageField('BindingConfigValue', 1)
  ref = _messages.StringField(2)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
  """

  policy = _messages.MessageField('Policy', 1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Target(_messages.Message):
  r"""A type of persisted data store to which Render outputs.

  Fields:
    cloudStorage: A Cloud Storage target location.
  """

  cloudStorage = _messages.MessageField('CloudStorage', 1)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class TypedName(_messages.Message):
  r"""TypedName is a resource name + its type. Next tag: 3

  Fields:
    name: The name of the resource.
    type: The type of the resource.
  """

  name = _messages.StringField(1)
  type = _messages.StringField(2)


class VPCConfig(_messages.Message):
  r"""Message for VPC configs.

  Fields:
    network: Network is an existing network name. If omitted, a new network
      will be created for the application.
  """

  network = _messages.StringField(1)


encoding.AddCustomJsonFieldMapping(
    CloudSqlSettings, 'activation_policy', 'activation-policy')
encoding.AddCustomJsonFieldMapping(
    CloudSqlSettings, 'availability_type', 'availability-type')
encoding.AddCustomJsonFieldMapping(
    CloudSqlSettings, 'disk_size', 'disk-size')
encoding.AddCustomJsonFieldMapping(
    CloudSqlSettings, 'disk_type', 'disk-type')
encoding.AddCustomJsonFieldMapping(
    RedisInstanceConfig, 'memory_size_gb', 'memory-size-gb')
encoding.AddCustomJsonFieldMapping(
    RedisInstanceConfig, 'redis_parameters', 'redis-parameters')
encoding.AddCustomJsonFieldMapping(
    RouterConfig, 'default_route', 'default-route')
encoding.AddCustomJsonFieldMapping(
    RouterConfig, 'dns_zone', 'dns-zone')
encoding.AddCustomJsonFieldMapping(
    ServiceResourceBindingConfig, 'binding_config', 'binding-config')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
