"""Generated message classes for managedidentities version v1alpha1.

The Managed Service for Microsoft Active Directory API is used for managing a
highly available, hardened service running Microsoft Active Directory (AD).
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'managedidentities'


class AttachTrustRequest(_messages.Message):
  r"""A AttachTrustRequest object.

  Fields:
    trust: The domain trust resource.
  """

  trust = _messages.MessageField('Trust', 1)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the members in this binding.
      To learn which resources support conditions in their IAM policies, see
      the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. * `user:{emailid}`: An email address that
      represents a specific Google account. For example, `alice@example.com` .
      * `serviceAccount:{emailid}`: An email address that represents a service
      account. For example, `my-other-app@appspot.gserviceaccount.com`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `domain:{domain}`: The G Suite
      domain (primary) that represents all the users of that domain. For
      example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class Certificate(_messages.Message):
  r"""Certificate used to configure LDAPS.

  Fields:
    expireTime: The certificate expire time.
    issuingCertificate: The issuer of this certificate.
    subject: The certificate subject.
    subjectAlternativeName: The additional hostnames for the domain.
    thumbprint: The certificate thumbprint which uniquely identifies the
      certificate.
  """

  expireTime = _messages.StringField(1)
  issuingCertificate = _messages.MessageField('Certificate', 2)
  subject = _messages.StringField(3)
  subjectAlternativeName = _messages.StringField(4, repeated=True)
  thumbprint = _messages.StringField(5)


class DailyCycle(_messages.Message):
  r"""Time window specified for daily operations.

  Fields:
    duration: Output only. Duration of the time window, set by service
      producer.
    startTime: Time within the day to start the operations.
  """

  duration = _messages.StringField(1)
  startTime = _messages.MessageField('TimeOfDay', 2)


class Date(_messages.Message):
  r"""Represents a whole or partial calendar date, such as a birthday. The
  time of day and time zone are either specified elsewhere or are
  insignificant. The date is relative to the Gregorian Calendar. This can
  represent one of the following: * A full date, with non-zero year, month,
  and day values * A month and day value, with a zero year, such as an
  anniversary * A year on its own, with zero month and day values * A year and
  month value, with a zero day, such as a credit card expiration date Related
  types are google.type.TimeOfDay and `google.protobuf.Timestamp`.

  Fields:
    day: Day of a month. Must be from 1 to 31 and valid for the year and
      month, or 0 to specify a year by itself or a year and month where the
      day isn't significant.
    month: Month of a year. Must be from 1 to 12, or 0 to specify a year
      without a month and day.
    year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
      without a year.
  """

  day = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  month = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  year = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class DenyMaintenancePeriod(_messages.Message):
  r"""DenyMaintenancePeriod definition. Maintenance is forbidden within the
  deny period. The start_date must be less than the end_date.

  Fields:
    endDate: Deny period end date. This can be: * A full date, with non-zero
      year, month and day values. * A month and day value, with a zero year.
      Allows recurring deny periods each year. Date matching this period will
      have to be before the end.
    startDate: Deny period start date. This can be: * A full date, with non-
      zero year, month and day values. * A month and day value, with a zero
      year. Allows recurring deny periods each year. Date matching this period
      will have to be the same or after the start.
    time: Time in UTC when the Blackout period starts on start_date and ends
      on end_date. This can be: * Full time. * All zeros for 00:00:00 UTC
  """

  endDate = _messages.MessageField('Date', 1)
  startDate = _messages.MessageField('Date', 2)
  time = _messages.MessageField('TimeOfDay', 3)


class DetachTrustRequest(_messages.Message):
  r"""A DetachTrustRequest object.

  Fields:
    trust: The domain trust resource to removed.
  """

  trust = _messages.MessageField('Trust', 1)


class Domain(_messages.Message):
  r"""If the domain is being changed, it will be placed into the UPDATING
  state, which indicates that the resource is being reconciled. At this point,
  Get will reflect an intermediate state.

  Enums:
    StateValueValuesEnum: Output only. The current state of this domain.

  Messages:
    LabelsValue: Optional. Resource labels to represent user provided metadata

  Fields:
    auditLogsEnabled: Optional. Configuration for audit logs. True if audit
      logs are enabled, else false. Default is audit logs disabled.
    authorizedNetworks: Optional. The full names of the Google Compute Engine
      [networks](/compute/docs/networks-and-firewalls#networks) to which the
      instance is connected. Network can be added using UpdateDomain later.
      Domain is only available on network part of authorized_networks. Caller
      needs to make sure that CIDR subnets do not overlap between networks,
      else domain creation will fail.
    createTime: Output only. The time the instance was created. Synthetic
      field is populated automatically by CCFE. go/ccfe-synthetic-field-user-
      guide
    fqdn: Output only. Fully-qualified domain name of the exposed domain used
      by clients to connect to the service. Similar to what would be chosen
      for an Active Directory that is set up on an internal network.
    labels: Optional. Resource labels to represent user provided metadata
    locations: Required. Locations where domain needs to be provisioned.
      regions e.g. us-west1 or us-east4 Service supports up to 4 locations at
      once. Each location will use a /26 block.
    managedIdentitiesAdminName: Optional. Name of customer-visible admin used
      to perform Active Directory operations. If not specified `setupadmin`
      would be used.
    name: Output only. Unique name of the domain in this scope including
      projects and location using the form:
      `projects/{project_id}/locations/global/domains/{domain_name}`.
    reservedIpRange: Required. The CIDR range of internal addresses that are
      reserved for this domain. Reserved networks must be /24 or larger.
      Ranges must be unique and non-overlapping with existing subnets in
      [Domain].[authorized_networks].
    state: Output only. The current state of this domain.
    statusMessage: Output only. Additional information about the current
      status of this domain, if available.
    trusts: Output only. The current trusts associated with the domain.
    updateTime: Output only. Last update time. Synthetic field is populated
      automatically by CCFE.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of this domain.

    Values:
      STATE_UNSPECIFIED: Not set.
      CREATING: ManagedIdentities domain is being created.
      READY: ManagedIdentities domain has been created and is fully usable.
      UPDATING: ManagedIdentities domain configuration is being updated.
      DELETING: ManagedIdentities domain is being deleted.
      REPAIRING: ManagedIdentities domain is being repaired and may be
        unusable. Details can be found in the `status_message` field.
      PERFORMING_MAINTENANCE: ManagedIdentities domain is undergoing
        maintenance.
      DOWN: ManagedIdentities domain is not serving customer requests.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    UPDATING = 3
    DELETING = 4
    REPAIRING = 5
    PERFORMING_MAINTENANCE = 6
    DOWN = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Resource labels to represent user provided metadata

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  auditLogsEnabled = _messages.BooleanField(1)
  authorizedNetworks = _messages.StringField(2, repeated=True)
  createTime = _messages.StringField(3)
  fqdn = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  locations = _messages.StringField(6, repeated=True)
  managedIdentitiesAdminName = _messages.StringField(7)
  name = _messages.StringField(8)
  reservedIpRange = _messages.StringField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  statusMessage = _messages.StringField(11)
  trusts = _messages.MessageField('Trust', 12, repeated=True)
  updateTime = _messages.StringField(13)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GoogleCloudManagedidentitiesV1OpMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  target = _messages.StringField(5)
  verb = _messages.StringField(6)


class GoogleCloudManagedidentitiesV1alpha1OpMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  target = _messages.StringField(5)
  verb = _messages.StringField(6)


class GoogleCloudManagedidentitiesV1beta1OpMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have
      successfully been cancelled have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  target = _messages.StringField(5)
  verb = _messages.StringField(6)


class GoogleCloudSaasacceleratorManagementProvidersV1Instance(_messages.Message):
  r"""A GoogleCloudSaasacceleratorManagementProvidersV1Instance object.

  Enums:
    StateValueValuesEnum: Output only. Current lifecycle state of the resource
      (e.g. if it's being created or ready to use).

  Messages:
    LabelsValue: Optional. Resource labels to represent user provided
      metadata. Each label is a key-value pair, where both the key and the
      value are arbitrary strings provided by the user.
    MaintenancePolicyNamesValue: Deprecated. The MaintenancePolicies that have
      been attached to the instance. The key must be of the type name of the
      oneof policy name defined in MaintenancePolicy, and the referenced
      policy must define the same policy type. For complete details of
      MaintenancePolicy, please refer to go/cloud-saas-mw-ug.
    MaintenanceSchedulesValue: The MaintenanceSchedule contains the scheduling
      information of published maintenance schedule with same key as
      software_versions.
    ProducerMetadataValue: Output only. Custom string attributes used
      primarily to expose producer-specific information in monitoring
      dashboards. See go/get-instance-metadata.
    SoftwareVersionsValue: Software versions that are used to deploy this
      instance. This can be mutated by rollout services.

  Fields:
    consumerDefinedName: consumer_defined_name is the name that is set by the
      consumer. On the other hand Name field represents system-assigned id of
      an instance so consumers are not necessarily aware of it.
      consumer_defined_name is used for notification/UI purposes for consumer
      to recognize their instances.
    createTime: Output only. Timestamp when the resource was created.
    labels: Optional. Resource labels to represent user provided metadata.
      Each label is a key-value pair, where both the key and the value are
      arbitrary strings provided by the user.
    maintenancePolicyNames: Deprecated. The MaintenancePolicies that have been
      attached to the instance. The key must be of the type name of the oneof
      policy name defined in MaintenancePolicy, and the referenced policy must
      define the same policy type. For complete details of MaintenancePolicy,
      please refer to go/cloud-saas-mw-ug.
    maintenanceSchedules: The MaintenanceSchedule contains the scheduling
      information of published maintenance schedule with same key as
      software_versions.
    maintenanceSettings: Optional. The MaintenanceSettings associated with
      instance.
    name: Unique name of the resource. It uses the form:
      `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
    producerMetadata: Output only. Custom string attributes used primarily to
      expose producer-specific information in monitoring dashboards. See
      go/get-instance-metadata.
    provisionedResources: Output only. The list of data plane resources
      provisioned for this instance, e.g. compute VMs. See go/get-instance-
      metadata.
    slmInstanceTemplate: Link to the SLM instance template. Only populated
      when updating SLM instances via SSA's Actuation service adaptor. Service
      producers with custom control plane (e.g. Cloud SQL) doesn't need to
      populate this field. Instead they should use software_versions.
    sloMetadata: Output only. SLO metadata for instance classification in the
      Standardized dataplane SLO platform. See go/cloud-ssa-standard-slo for
      feature description.
    softwareVersions: Software versions that are used to deploy this instance.
      This can be mutated by rollout services.
    state: Output only. Current lifecycle state of the resource (e.g. if it's
      being created or ready to use).
    tenantProjectId: Output only. ID of the associated GCP tenant project. See
      go/get-instance-metadata.
    updateTime: Output only. Timestamp when the resource was last modified.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Current lifecycle state of the resource (e.g. if it's
    being created or ready to use).

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      CREATING: Instance is being created.
      READY: Instance has been created and is ready to use.
      UPDATING: Instance is being updated.
      REPAIRING: Instance is unheathy and under repair.
      DELETING: Instance is being deleted.
      ERROR: Instance encountered an error and is in indeterministic state.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    READY = 2
    UPDATING = 3
    REPAIRING = 4
    DELETING = 5
    ERROR = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Resource labels to represent user provided metadata. Each
    label is a key-value pair, where both the key and the value are arbitrary
    strings provided by the user.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MaintenancePolicyNamesValue(_messages.Message):
    r"""Deprecated. The MaintenancePolicies that have been attached to the
    instance. The key must be of the type name of the oneof policy name
    defined in MaintenancePolicy, and the referenced policy must define the
    same policy type. For complete details of MaintenancePolicy, please refer
    to go/cloud-saas-mw-ug.

    Messages:
      AdditionalProperty: An additional property for a
        MaintenancePolicyNamesValue object.

    Fields:
      additionalProperties: Additional properties of type
        MaintenancePolicyNamesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MaintenancePolicyNamesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MaintenanceSchedulesValue(_messages.Message):
    r"""The MaintenanceSchedule contains the scheduling information of
    published maintenance schedule with same key as software_versions.

    Messages:
      AdditionalProperty: An additional property for a
        MaintenanceSchedulesValue object.

    Fields:
      additionalProperties: Additional properties of type
        MaintenanceSchedulesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MaintenanceSchedulesValue object.

      Fields:
        key: Name of the additional property.
        value: A
          GoogleCloudSaasacceleratorManagementProvidersV1MaintenanceSchedule
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1MaintenanceSchedule', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ProducerMetadataValue(_messages.Message):
    r"""Output only. Custom string attributes used primarily to expose
    producer-specific information in monitoring dashboards. See go/get-
    instance-metadata.

    Messages:
      AdditionalProperty: An additional property for a ProducerMetadataValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        ProducerMetadataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ProducerMetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SoftwareVersionsValue(_messages.Message):
    r"""Software versions that are used to deploy this instance. This can be
    mutated by rollout services.

    Messages:
      AdditionalProperty: An additional property for a SoftwareVersionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        SoftwareVersionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SoftwareVersionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  consumerDefinedName = _messages.StringField(1)
  createTime = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  maintenancePolicyNames = _messages.MessageField('MaintenancePolicyNamesValue', 4)
  maintenanceSchedules = _messages.MessageField('MaintenanceSchedulesValue', 5)
  maintenanceSettings = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1MaintenanceSettings', 6)
  name = _messages.StringField(7)
  producerMetadata = _messages.MessageField('ProducerMetadataValue', 8)
  provisionedResources = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1ProvisionedResource', 9, repeated=True)
  slmInstanceTemplate = _messages.StringField(10)
  sloMetadata = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1SloMetadata', 11)
  softwareVersions = _messages.MessageField('SoftwareVersionsValue', 12)
  state = _messages.EnumField('StateValueValuesEnum', 13)
  tenantProjectId = _messages.StringField(14)
  updateTime = _messages.StringField(15)


class GoogleCloudSaasacceleratorManagementProvidersV1MaintenanceSchedule(_messages.Message):
  r"""Maintenance schedule which is exposed to customer and potentially end
  user, indicating published upcoming future maintenance schedule

  Fields:
    canReschedule: Can this scheduled update be rescheduled? By default, it's
      true and API needs to do explicitly check whether it's set, if it's set
      as false explicitly, it's false
    endTime: The scheduled end time for the maintenance.
    rolloutManagementPolicy: The rollout management policy this maintenance
      schedule is associated with. When doing reschedule update request, the
      reschedule should be against this given policy.
    scheduleDeadlineTime: schedule_deadline_time is the time deadline any
      schedule start time cannot go beyond, including reschedule. It's
      normally the initial schedule start time plus a week. If the reschedule
      type is next window, simply take this value as start time. If reschedule
      type is IMMEDIATELY or BY_TIME, current or selected time cannot go
      beyond this deadline.
    startTime: The scheduled start time for the maintenance.
  """

  canReschedule = _messages.BooleanField(1)
  endTime = _messages.StringField(2)
  rolloutManagementPolicy = _messages.StringField(3)
  scheduleDeadlineTime = _messages.StringField(4)
  startTime = _messages.StringField(5)


class GoogleCloudSaasacceleratorManagementProvidersV1MaintenanceSettings(_messages.Message):
  r"""Maintenance settings associated with instance. Allows service producers
  and end users to assign settings that controls maintenance on this instance.

  Messages:
    MaintenancePoliciesValue: Optional. The MaintenancePolicies that have been
      attached to the instance. The key must be of the type name of the oneof
      policy name defined in MaintenancePolicy, and the embedded policy must
      define the same policy type. For complete details of MaintenancePolicy,
      please refer to go/cloud-saas-mw-ug. If only the name is needed (like in
      the deprecated Instance.maintenance_policy_names field) then only
      populate MaintenancePolicy.name.

  Fields:
    exclude: Optional. Exclude instance from maintenance. When true, rollout
      service will not attempt maintenance on the instance. Rollout service
      will include the instance in reported rollout progress as not attempted.
    isRollback: Optional. If the update call is triggered from rollback, set
      the value as true.
    maintenancePolicies: Optional. The MaintenancePolicies that have been
      attached to the instance. The key must be of the type name of the oneof
      policy name defined in MaintenancePolicy, and the embedded policy must
      define the same policy type. For complete details of MaintenancePolicy,
      please refer to go/cloud-saas-mw-ug. If only the name is needed (like in
      the deprecated Instance.maintenance_policy_names field) then only
      populate MaintenancePolicy.name.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MaintenancePoliciesValue(_messages.Message):
    r"""Optional. The MaintenancePolicies that have been attached to the
    instance. The key must be of the type name of the oneof policy name
    defined in MaintenancePolicy, and the embedded policy must define the same
    policy type. For complete details of MaintenancePolicy, please refer to
    go/cloud-saas-mw-ug. If only the name is needed (like in the deprecated
    Instance.maintenance_policy_names field) then only populate
    MaintenancePolicy.name.

    Messages:
      AdditionalProperty: An additional property for a
        MaintenancePoliciesValue object.

    Fields:
      additionalProperties: Additional properties of type
        MaintenancePoliciesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MaintenancePoliciesValue object.

      Fields:
        key: Name of the additional property.
        value: A MaintenancePolicy attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('MaintenancePolicy', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  exclude = _messages.BooleanField(1)
  isRollback = _messages.BooleanField(2)
  maintenancePolicies = _messages.MessageField('MaintenancePoliciesValue', 3)


class GoogleCloudSaasacceleratorManagementProvidersV1NodeSloMetadata(_messages.Message):
  r"""Node information for custom per-node SLO implementations. SSA does not
  support per-node SLO, but producers can populate per-node information in
  SloMetadata for custom precomputations. SSA Eligibility Exporter will emit
  per-node metric based on this information.

  Fields:
    exclusions: By default node is eligible if instance is eligible. But
      individual node might be excluded from SLO by adding entry here. For
      semantic see SloMetadata.exclusions. If both instance and node level
      exclusions are present for time period, the node level's reason will be
      reported by Eligibility Exporter.
    location: The location of the node, if different from instance location.
    nodeId: The id of the node. This should be equal to
      SaasInstanceNode.node_id.
  """

  exclusions = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1SloExclusion', 1, repeated=True)
  location = _messages.StringField(2)
  nodeId = _messages.StringField(3)


class GoogleCloudSaasacceleratorManagementProvidersV1ProvisionedResource(_messages.Message):
  r"""Describes provisioned dataplane resources.

  Fields:
    resourceType: Type of the resource. This can be either a GCP resource or a
      custom one (e.g. another cloud provider's VM). For GCP compute resources
      use singular form of the names listed in GCP compute API documentation
      (https://cloud.google.com/compute/docs/reference/rest/v1/), prefixed
      with 'compute-', for example: 'compute-instance', 'compute-disk',
      'compute-autoscaler'.
    resourceUrl: URL identifying the resource, e.g.
      "https://www.googleapis.com/compute/v1/projects/...)".
  """

  resourceType = _messages.StringField(1)
  resourceUrl = _messages.StringField(2)


class GoogleCloudSaasacceleratorManagementProvidersV1SloEligibility(_messages.Message):
  r"""SloEligibility is a tuple containing eligibility value: true if an
  instance is eligible for SLO calculation or false if it should be excluded
  from all SLO-related calculations along with a user-defined reason.

  Fields:
    eligible: Whether an instance is eligible or ineligible.
    reason: User-defined reason for the current value of instance eligibility.
      Usually, this can be directly mapped to the internal state. An empty
      reason is allowed.
  """

  eligible = _messages.BooleanField(1)
  reason = _messages.StringField(2)


class GoogleCloudSaasacceleratorManagementProvidersV1SloExclusion(_messages.Message):
  r"""SloExclusion represents an exclusion in SLI calculation applies to all
  SLOs.

  Fields:
    duration: Exclusion duration. No restrictions on the possible values. When
      an ongoing operation is taking longer than initially expected, an
      existing entry in the exclusion list can be updated by extending the
      duration. This is supported by the subsystem exporting eligibility data
      as long as such extension is committed at least 10 minutes before the
      original exclusion expiration - otherwise it is possible that there will
      be "gaps" in the exclusion application in the exported timeseries.
    reason: Human-readable reason for the exclusion. This should be a static
      string (e.g. "Disruptive update in progress") and should not contain
      dynamically generated data (e.g. instance name). Can be left empty.
    sliName: Name of an SLI that this exclusion applies to. Can be left empty,
      signaling that the instance should be excluded from all SLIs defined in
      the service SLO configuration.
    startTime: Start time of the exclusion. No alignment (e.g. to a full
      minute) needed.
  """

  duration = _messages.StringField(1)
  reason = _messages.StringField(2)
  sliName = _messages.StringField(3)
  startTime = _messages.StringField(4)


class GoogleCloudSaasacceleratorManagementProvidersV1SloMetadata(_messages.Message):
  r"""SloMetadata contains resources required for proper SLO classification of
  the instance.

  Fields:
    eligibility: Optional. User-defined instance eligibility.
    exclusions: List of SLO exclusion windows. When multiple entries in the
      list match (matching the exclusion time-window against current time
      point) the exclusion reason used in the first matching entry will be
      published. It is not needed to include expired exclusion in this list,
      as only the currently applicable exclusions are taken into account by
      the eligibility exporting subsystem (the historical state of exclusions
      will be reflected in the historically produced timeseries regardless of
      the current state). This field can be used to mark the instance as
      temporary ineligible for the purpose of SLO calculation. For permanent
      instance SLO exclusion, use of custom instance eligibility is
      recommended. See 'eligibility' field below.
    nodes: Optional. List of nodes. Some producers need to use per-node
      metadata to calculate SLO. This field allows such producers to publish
      per-node SLO meta data, which will be consumed by SSA Eligibility
      Exporter and published in the form of per node metric to Monarch.
    tier: Name of the SLO tier the Instance belongs to. This name will be
      expected to match the tiers specified in the service SLO configuration.
      Field is mandatory and must not be empty.
  """

  eligibility = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1SloEligibility', 1)
  exclusions = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1SloExclusion', 2, repeated=True)
  nodes = _messages.MessageField('GoogleCloudSaasacceleratorManagementProvidersV1NodeSloMetadata', 3, repeated=True)
  tier = _messages.StringField(4)


class LDAPSSettings(_messages.Message):
  r"""LDAPSSettings represents the ldaps settings for domain resource. LDAP is
  the Lightweight Directory Access Protocol, defined in
  https://tools.ietf.org/html/rfc4511. The settings object configures LDAP
  over SSL/TLS, whether it is over port 636 or the StartTLS operation. If
  LDAPSSettings is being changed, it will be placed into the UPDATING state,
  which indicates that the resource is being reconciled. At this point, Get
  will reflect an intermediate state.

  Enums:
    StateValueValuesEnum: Output only. The current state of this LDAPS
      settings.

  Fields:
    certificate: Output only. The certificate used to configure LDAPS.
      Certificates can be chained with a maximum length of 15.
    certificatePassword: Input only. The password used to encrypt the uploaded
      pfx certificate.
    certificatePfx: Input only. The uploaded PKCS12-formatted certificate to
      configure LDAPS with. It will enable the domain controllers in this
      domain to accept LDAPS connections (either LDAP over SSL/TLS or the
      StartTLS operation). A valid certificate chain must form a valid x.509
      certificate chain (or be comprised of a single self-signed certificate.
      It must be encrypted with either: 1) PBES2 + PBKDF2 + AES256 encryption
      and SHA256 PRF; or 2) pbeWithSHA1And3-KeyTripleDES-CBC Private key must
      be included for the leaf / single self-signed certificate. Note: For a
      fqdn your-example-domain.com, the wildcard fqdn is *.your-example-
      domain.com. Specifically the leaf certificate must have: - Either a
      blank subject or a subject with CN matching the wildcard fqdn. - Exactly
      two SANs - the fqdn adn wildcard fqdn. - Encipherment and digital key
      signature key usages. - Server authentication extended key usage
      (OID=1.3.6.1.5.5.7.3.1) - Private key must be in one of the following
      formats: RSA, ECDSA, ED25519. - Private key must have appropriate key
      length: 2048 for RSA, 256 for ECDSA - Signature algorithm of the leaf
      certificate cannot be MD2, MD5 or SHA1.
    name: The resource name of the LDAPS settings. Uses the form:
      `projects/{project}/locations/{location}/domains/{domain}`.
    state: Output only. The current state of this LDAPS settings.
    updateTime: Output only. Last update time.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of this LDAPS settings.

    Values:
      STATE_UNSPECIFIED: Not Set
      UPDATING: The LDAPS setting is being updated.
      ACTIVE: The LDAPS setting is ready.
      FAILED: The LDAPS setting is not applied correctly.
    """
    STATE_UNSPECIFIED = 0
    UPDATING = 1
    ACTIVE = 2
    FAILED = 3

  certificate = _messages.MessageField('Certificate', 1)
  certificatePassword = _messages.StringField(2)
  certificatePfx = _messages.BytesField(3)
  name = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  updateTime = _messages.StringField(6)


class ListDomainsResponse(_messages.Message):
  r"""A ListDomainsResponse object.

  Fields:
    domains: A list of Managed Identities Service domains in the project.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    unreachable: Locations that could not be reached.
  """

  domains = _messages.MessageField('Domain', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListSQLIntegrationsResponse(_messages.Message):
  r"""ListSQLIntegrationsResponse is the response message for
  ListSQLIntegrations method.

  Fields:
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
    sqlIntegrations: A list of SQLIntegrations of a domain.
    unreachable: A list of locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  sqlIntegrations = _messages.MessageField('SQLIntegration', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class MaintenancePolicy(_messages.Message):
  r"""Defines policies to service maintenance events.

  Enums:
    StateValueValuesEnum: Optional. The state of the policy.

  Messages:
    LabelsValue: Optional. Resource labels to represent user provided
      metadata. Each label is a key-value pair, where both the key and the
      value are arbitrary strings provided by the user.

  Fields:
    createTime: Output only. The time when the resource was created.
    description: Optional. Description of what this policy is for.
      Create/Update methods return INVALID_ARGUMENT if the length is greater
      than 512.
    labels: Optional. Resource labels to represent user provided metadata.
      Each label is a key-value pair, where both the key and the value are
      arbitrary strings provided by the user.
    name: Required. MaintenancePolicy name using the form: `projects/{project_
      id}/locations/{location_id}/maintenancePolicies/{maintenance_policy_id}`
      where {project_id} refers to a GCP consumer project ID, {location_id}
      refers to a GCP region/zone, {maintenance_policy_id} must be 1-63
      characters long and match the regular expression
      `[a-z0-9]([-a-z0-9]*[a-z0-9])?`.
    state: Optional. The state of the policy.
    updatePolicy: Maintenance policy applicable to instance update.
    updateTime: Output only. The time when the resource was updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Optional. The state of the policy.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      READY: Resource is ready to be used.
      DELETING: Resource is being deleted. It can no longer be attached to
        instances.
    """
    STATE_UNSPECIFIED = 0
    READY = 1
    DELETING = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Resource labels to represent user provided metadata. Each
    label is a key-value pair, where both the key and the value are arbitrary
    strings provided by the user.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  updatePolicy = _messages.MessageField('UpdatePolicy', 6)
  updateTime = _messages.StringField(7)


class MaintenanceWindow(_messages.Message):
  r"""MaintenanceWindow definition.

  Fields:
    dailyCycle: Daily cycle.
    weeklyCycle: Weekly cycle.
  """

  dailyCycle = _messages.MessageField('DailyCycle', 1)
  weeklyCycle = _messages.MessageField('WeeklyCycle', 2)


class ManagedidentitiesProjectsLocationsGetRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsAttachTrustRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsAttachTrustRequest
  object.

  Fields:
    attachTrustRequest: A AttachTrustRequest resource to be passed as the
      request body.
    name: The resource domain name, project name and location using the form:
      `projects/{project_id}/locations/global/domains/{domain_name}`
  """

  attachTrustRequest = _messages.MessageField('AttachTrustRequest', 1)
  name = _messages.StringField(2, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsCreateRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsCreateRequest object.

  Fields:
    domain: A Domain resource to be passed as the request body.
    domainName: The fully qualified domain name. e.g.
      mydomain.myorganization.com, with the following restrictions: * Must
      contain only lowercase letters, numbers, periods and hyphens. * Must
      start with a letter. * Must contain between 2-64 characters. * Must end
      with a number or a letter. * Must not start with period. * Must be
      unique within the project. * First segement length (mydomain form
      example above) shouldn't exceed 15 chars. * The last segment cannot be
      fully numeric.
    parent: Resource project name and location using the form:
      `projects/{project_id}/locations/global`
  """

  domain = _messages.MessageField('Domain', 1)
  domainName = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsDeleteRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsDeleteRequest object.

  Fields:
    name: Domain resource name using the form:
      `projects/{project_id}/locations/global/domains/{domain_name}`
  """

  name = _messages.StringField(1, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsDetachTrustRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsDetachTrustRequest
  object.

  Fields:
    detachTrustRequest: A DetachTrustRequest resource to be passed as the
      request body.
    name: The resource domain name, project name, and location using the form:
      `projects/{project_id}/locations/global/domains/{domain_name}`
  """

  detachTrustRequest = _messages.MessageField('DetachTrustRequest', 1)
  name = _messages.StringField(2, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsGetIamPolicyRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The policy format version to be
      returned. Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected. Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset. To learn
      which resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsGetLdapssettingsRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsGetLdapssettingsRequest
  object.

  Fields:
    name: Required. The domain resource name using the form:
      `projects/{project_id}/locations/global/domains/{domain_name}`
  """

  name = _messages.StringField(1, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsGetRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsGetRequest object.

  Fields:
    name: Domain resource name using the form:
      `projects/{project_id}/locations/global/domains/{domain_name}`
  """

  name = _messages.StringField(1, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsListRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsListRequest object.

  Fields:
    filter: Optional. Filter specifying constraints of a list operation. For
      example, `Domain.fqdn="mydomain.myorginization"`.
    orderBy: Optional. Specifies the ordering of results following syntax at
      https://cloud.google.com/apis/design/design_patterns#sorting_order.
    pageSize: If not specified, a default value of 1000 will be used by the
      service. Regardless of the page_size value, the response may include a
      partial list and a caller should only rely on response's next_page_token
      to determine if there are more instances left to be queried.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: Required. The resource name of the domain location using the form:
      `projects/{project_id}/locations/global`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsPatchRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsPatchRequest object.

  Fields:
    domain: A Domain resource to be passed as the request body.
    name: Output only. Unique name of the domain in this scope including
      projects and location using the form:
      `projects/{project_id}/locations/global/domains/{domain_name}`.
    updateMask: Mask of fields to update. At least one path must be supplied
      in this field. The elements of the repeated paths field may only include
      these fields from Domain: * `labels` * `locations` *
      `authorized_networks` * `audit_logs_enabled`
  """

  domain = _messages.MessageField('Domain', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class ManagedidentitiesProjectsLocationsGlobalDomainsReconfigureTrustRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsReconfigureTrustRequest
  object.

  Fields:
    name: The resource domain name, project name and location using the form:
      `projects/{project_id}/locations/global/domains/{domain_name}`
    reconfigureTrustRequest: A ReconfigureTrustRequest resource to be passed
      as the request body.
  """

  name = _messages.StringField(1, required=True)
  reconfigureTrustRequest = _messages.MessageField('ReconfigureTrustRequest', 2)


class ManagedidentitiesProjectsLocationsGlobalDomainsResetAdminPasswordRequest(_messages.Message):
  r"""A
  ManagedidentitiesProjectsLocationsGlobalDomainsResetAdminPasswordRequest
  object.

  Fields:
    name: The domain resource name using the form:
      `projects/{project_id}/locations/global/domains/{domain_name}`
    resetAdminPasswordRequest: A ResetAdminPasswordRequest resource to be
      passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  resetAdminPasswordRequest = _messages.MessageField('ResetAdminPasswordRequest', 2)


class ManagedidentitiesProjectsLocationsGlobalDomainsSetIamPolicyRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ManagedidentitiesProjectsLocationsGlobalDomainsSqlIntegrationsGetRequest(_messages.Message):
  r"""A
  ManagedidentitiesProjectsLocationsGlobalDomainsSqlIntegrationsGetRequest
  object.

  Fields:
    name: Required. MangedOU resource name using the form:
      `projects/{project_id}/locations/global/domains/*/sqlIntegrations/{name}
      `
  """

  name = _messages.StringField(1, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsSqlIntegrationsListRequest(_messages.Message):
  r"""A
  ManagedidentitiesProjectsLocationsGlobalDomainsSqlIntegrationsListRequest
  object.

  Fields:
    filter: Optional. Filter specifying constraints of a list operation. For
      example, `SqlIntegration.name="sql"`.
    orderBy: Optional. Specifies the ordering of results following syntax at
      https://cloud.google.com/apis/design/design_patterns#sorting_order.
    pageSize: Optional. The maximum number of items to return. If not
      specified, a default value of 1000 will be used by the service.
      Regardless of the page_size value, the response may include a partial
      list and a caller should only rely on response'ANIZATIONs
      next_page_token to determine if there are more instances left to be
      queried.
    pageToken: Optional. The next_page_token value returned from a previous
      List request, if any.
    parent: Required. The resource name of the SqlIntegrations using the form:
      `projects/{project_id}/locations/global/domains/*`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ManagedidentitiesProjectsLocationsGlobalDomainsTestIamPermissionsRequest(_messages.Message):
  r"""A
  ManagedidentitiesProjectsLocationsGlobalDomainsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ManagedidentitiesProjectsLocationsGlobalDomainsUpdateLdapssettingsRequest(_messages.Message):
  r"""A
  ManagedidentitiesProjectsLocationsGlobalDomainsUpdateLdapssettingsRequest
  object.

  Fields:
    lDAPSSettings: A LDAPSSettings resource to be passed as the request body.
    name: The resource name of the LDAPS settings. Uses the form:
      `projects/{project}/locations/{location}/domains/{domain}`.
    updateMask: Required. Mask of fields to update. At least one path must be
      supplied in this field. For the `FieldMask` definition, see
      https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  lDAPSSettings = _messages.MessageField('LDAPSSettings', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class ManagedidentitiesProjectsLocationsGlobalDomainsValidateTrustRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalDomainsValidateTrustRequest
  object.

  Fields:
    name: The resource domain name, project name, and location using the form:
      `projects/{project_id}/locations/global/domains/{domain_name}`
    validateTrustRequest: A ValidateTrustRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  validateTrustRequest = _messages.MessageField('ValidateTrustRequest', 2)


class ManagedidentitiesProjectsLocationsGlobalOperationsCancelRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalOperationsCancelRequest
  object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class ManagedidentitiesProjectsLocationsGlobalOperationsDeleteRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class ManagedidentitiesProjectsLocationsGlobalOperationsGetRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class ManagedidentitiesProjectsLocationsGlobalOperationsListRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsGlobalOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ManagedidentitiesProjectsLocationsListRequest(_messages.Message):
  r"""A ManagedidentitiesProjectsLocationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: [Output only] API version used to start the operation.
    cancelRequested: [Output only] Identifies whether the user has requested
      cancellation of the operation. Operations that have successfully been
      cancelled have Operation.error value with a google.rpc.Status.code of 1,
      corresponding to `Code.CANCELLED`.
    createTime: [Output only] The time the operation was created.
    endTime: [Output only] The time the operation finished running.
    statusDetail: [Output only] Human-readable status of the operation, if
      any.
    target: [Output only] Server-defined resource path for the target of the
      operation.
    verb: [Output only] Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  cancelRequested = _messages.BooleanField(2)
  createTime = _messages.StringField(3)
  endTime = _messages.StringField(4)
  statusDetail = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members` to a single `role`.
  Members can be user accounts, service accounts, Google groups, and domains
  (such as G Suite). A `role` is a named list of permissions; each `role` can
  be an IAM predefined role or a user-created custom role. For some types of
  Google Cloud resources, a `binding` can also specify a `condition`, which is
  a logical expression that allows access to a resource only if the expression
  evaluates to `true`. A condition can add constraints based on attributes of
  the request, the resource, or both. To learn which resources support
  conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: -
  user:mike@example.com - group:admins@example.com - domain:google.com -
  serviceAccount:my-project-id@appspot.gserviceaccount.com role:
  roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
  role: roles/resourcemanager.organizationViewer condition: title: expirable
  access description: Does not grant access after Sep 2020 expression:
  request.time < timestamp('2020-10-01T00:00:00.000Z') - etag: BwWWja0YfJA= -
  version: 3 For a description of IAM and its features, see the [IAM
  documentation](https://cloud.google.com/iam/docs/).

  Fields:
    bindings: Associates a list of `members` to a `role`. Optionally, may
      specify a `condition` that determines how and when the `bindings` are
      applied. Each of the `bindings` must contain at least one member.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  bindings = _messages.MessageField('Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class ReconfigureTrustRequest(_messages.Message):
  r"""A ReconfigureTrustRequest object.

  Fields:
    trust: The domain trust resource with updated dns conditional forwarder.
  """

  trust = _messages.MessageField('Trust', 1)


class ResetAdminPasswordRequest(_messages.Message):
  r"""A ResetAdminPasswordRequest object."""


class ResetAdminPasswordResponse(_messages.Message):
  r"""A ResetAdminPasswordResponse object.

  Fields:
    password: A random password. See admin for more information.
  """

  password = _messages.StringField(1)


class SQLIntegration(_messages.Message):
  r"""Represents the SQL instance integrated with AD.

  Enums:
    StateValueValuesEnum: Output only. The current state of the managed OU.

  Fields:
    createTime: Output only. The time the instance was created. Synthetic
      field is populated automatically by CCFE. go/ccfe-synthetic-field-user-
      guide
    name: The unique name of the sql integration in the form of `projects/{pro
      ject_id}/locations/global/domains/{domain_name}/sqlIntegrations/{sql_int
      egration}`
    sqlInstance: The full resource name of an integrated sql instance
    state: Output only. The current state of the managed OU.
    updateTime: Output only. Last update time. Synthetic field is populated
      automatically by CCFE.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the managed OU.

    Values:
      STATE_UNSPECIFIED: Not Set
      CREATING: The sqlIntegration is being created.
      DELETING: The sqlIntegration is being deleted.
      READY: The sqlIntegration is ready.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    DELETING = 2
    READY = 3

  createTime = _messages.StringField(1)
  name = _messages.StringField(2)
  sqlInstance = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  updateTime = _messages.StringField(5)


class Schedule(_messages.Message):
  r"""Configure the schedule.

  Enums:
    DayValueValuesEnum: Allows to define schedule that runs specified day of
      the week.

  Fields:
    day: Allows to define schedule that runs specified day of the week.
    duration: Output only. Duration of the time window, set by service
      producer.
    startTime: Time within the window to start the operations.
  """

  class DayValueValuesEnum(_messages.Enum):
    r"""Allows to define schedule that runs specified day of the week.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  day = _messages.EnumField('DayValueValuesEnum', 1)
  duration = _messages.StringField(2)
  startTime = _messages.MessageField('TimeOfDay', 3)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
  """

  policy = _messages.MessageField('Policy', 1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class TimeOfDay(_messages.Message):
  r"""Represents a time of day. The date and time zone are either not
  significant or are specified elsewhere. An API may choose to allow leap
  seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.

  Fields:
    hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may
      choose to allow the value "24:00:00" for scenarios like business closing
      time.
    minutes: Minutes of hour of day. Must be from 0 to 59.
    nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An
      API may allow the value 60 if it allows leap-seconds.
  """

  hours = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minutes = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  nanos = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  seconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Trust(_messages.Message):
  r"""Represents a relationship between two domains which makes it possible
  for users in one domain to be authenticated by a dc in another domain. Refer
  https://docs.microsoft.com/en-us/previous-versions/windows/it-pro/windows-
  server-2008-R2-and-2008/cc731335(v%3dws.10) If the trust is being changed,
  it will be placed into the UPDATING state, which indicates that the resource
  is being reconciled. At this point, Get will reflect an intermediate state.

  Enums:
    StateValueValuesEnum: Output only. The current state of this trust.
    TrustDirectionValueValuesEnum: The trust direction decides the current
      domain is trusted, trusting or both.
    TrustTypeValueValuesEnum: The type of trust represented by the trust
      resource.

  Fields:
    createTime: Output only. The time the instance was created.
    lastKnownTrustConnectedHeartbeatTime: Output only. The last heartbeat time
      when the trust was known to be connected.
    selectiveAuthentication: The trust authentication type which decides
      whether the trusted side has forest/domain wide access or selective
      access to approved set of resources.
    state: Output only. The current state of this trust.
    stateDescription: Output only. Additional information about the current
      state of this trust, if available.
    targetDnsIpAddresses: The target dns server ip addresses which can resolve
      the remote domain involved in trust.
    targetDomainName: The fully qualified target domain name which will be in
      trust with current domain.
    trustDirection: The trust direction decides the current domain is trusted,
      trusting or both.
    trustHandshakeSecret: Input only, and will not be stored. The trust secret
      used for handshake with target domain.
    trustType: The type of trust represented by the trust resource.
    updateTime: Output only. Last update time.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of this trust.

    Values:
      STATE_UNSPECIFIED: Not Set
      CREATING: Domain trust is being created.
      UPDATING: Domain trust is being updated.
      DELETING: Domain trust is being deleted.
      CONNECTED: Domain trust is connected.
      DISCONNECTED: Domain trust is disconnected.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    UPDATING = 2
    DELETING = 3
    CONNECTED = 4
    DISCONNECTED = 5

  class TrustDirectionValueValuesEnum(_messages.Enum):
    r"""The trust direction decides the current domain is trusted, trusting or
    both.

    Values:
      TRUST_DIRECTION_UNSPECIFIED: Not Set
      INBOUND: The inbound direction represents the trusting side.
      OUTBOUND: The outboud direction represents the trusted side.
      BIDIRECTIONAL: The bidirectional direction represents the trusted /
        trusting side.
    """
    TRUST_DIRECTION_UNSPECIFIED = 0
    INBOUND = 1
    OUTBOUND = 2
    BIDIRECTIONAL = 3

  class TrustTypeValueValuesEnum(_messages.Enum):
    r"""The type of trust represented by the trust resource.

    Values:
      TRUST_TYPE_UNSPECIFIED: Not Set
      FOREST: The forest trust.
      EXTERNAL: The external domain trust.
    """
    TRUST_TYPE_UNSPECIFIED = 0
    FOREST = 1
    EXTERNAL = 2

  createTime = _messages.StringField(1)
  lastKnownTrustConnectedHeartbeatTime = _messages.StringField(2)
  selectiveAuthentication = _messages.BooleanField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)
  stateDescription = _messages.StringField(5)
  targetDnsIpAddresses = _messages.StringField(6, repeated=True)
  targetDomainName = _messages.StringField(7)
  trustDirection = _messages.EnumField('TrustDirectionValueValuesEnum', 8)
  trustHandshakeSecret = _messages.StringField(9)
  trustType = _messages.EnumField('TrustTypeValueValuesEnum', 10)
  updateTime = _messages.StringField(11)


class UpdatePolicy(_messages.Message):
  r"""Maintenance policy applicable to instance updates.

  Enums:
    ChannelValueValuesEnum: Optional. Relative scheduling channel applied to
      resource.

  Fields:
    channel: Optional. Relative scheduling channel applied to resource.
    denyMaintenancePeriods: Deny Maintenance Period that is applied to
      resource to indicate when maintenance is forbidden. User can specify
      zero or more non-overlapping deny periods. For V1, Maximum number of
      deny_maintenance_periods is expected to be one.
    window: Optional. Maintenance window that is applied to resources covered
      by this policy.
  """

  class ChannelValueValuesEnum(_messages.Enum):
    r"""Optional. Relative scheduling channel applied to resource.

    Values:
      UPDATE_CHANNEL_UNSPECIFIED: Unspecified channel.
      EARLIER: Early channel within a customer project.
      LATER: Later channel within a customer project.
    """
    UPDATE_CHANNEL_UNSPECIFIED = 0
    EARLIER = 1
    LATER = 2

  channel = _messages.EnumField('ChannelValueValuesEnum', 1)
  denyMaintenancePeriods = _messages.MessageField('DenyMaintenancePeriod', 2, repeated=True)
  window = _messages.MessageField('MaintenanceWindow', 3)


class ValidateTrustRequest(_messages.Message):
  r"""A ValidateTrustRequest object.

  Fields:
    trust: The domain trust to validate trust state for.
  """

  trust = _messages.MessageField('Trust', 1)


class WeeklyCycle(_messages.Message):
  r"""Time window specified for weekly operations.

  Fields:
    schedule: User can specify multiple windows in a week. Minimum of 1
      window.
  """

  schedule = _messages.MessageField('Schedule', 1, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
