"""Generated message classes for datastore version v1beta1.

Accesses the schemaless NoSQL database to provide fully managed, robust,
scalable storage for your application.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'datastore'


class DatastoreProjectsExportRequest(_messages.Message):
  r"""A DatastoreProjectsExportRequest object.

  Fields:
    googleDatastoreAdminV1beta1ExportEntitiesRequest: A
      GoogleDatastoreAdminV1beta1ExportEntitiesRequest resource to be passed
      as the request body.
    projectId: Project ID against which to make the request.
  """

  googleDatastoreAdminV1beta1ExportEntitiesRequest = _messages.MessageField('GoogleDatastoreAdminV1beta1ExportEntitiesRequest', 1)
  projectId = _messages.StringField(2, required=True)


class DatastoreProjectsImportRequest(_messages.Message):
  r"""A DatastoreProjectsImportRequest object.

  Fields:
    googleDatastoreAdminV1beta1ImportEntitiesRequest: A
      GoogleDatastoreAdminV1beta1ImportEntitiesRequest resource to be passed
      as the request body.
    projectId: Project ID against which to make the request.
  """

  googleDatastoreAdminV1beta1ImportEntitiesRequest = _messages.MessageField('GoogleDatastoreAdminV1beta1ImportEntitiesRequest', 1)
  projectId = _messages.StringField(2, required=True)


class GoogleDatastoreAdminV1CommonMetadata(_messages.Message):
  r"""Metadata common to all Datastore Admin operations.

  Enums:
    OperationTypeValueValuesEnum: The type of the operation. Can be used as a
      filter in ListOperationsRequest.
    StateValueValuesEnum: The current state of the Operation.

  Messages:
    LabelsValue: The client-assigned labels which were provided when the
      operation was created. May also include additional labels.

  Fields:
    endTime: The time the operation ended, either successfully or otherwise.
    labels: The client-assigned labels which were provided when the operation
      was created. May also include additional labels.
    operationType: The type of the operation. Can be used as a filter in
      ListOperationsRequest.
    startTime: The time that work began on the operation.
    state: The current state of the Operation.
  """

  class OperationTypeValueValuesEnum(_messages.Enum):
    r"""The type of the operation. Can be used as a filter in
    ListOperationsRequest.

    Values:
      OPERATION_TYPE_UNSPECIFIED: Unspecified.
      EXPORT_ENTITIES: ExportEntities.
      IMPORT_ENTITIES: ImportEntities.
      CREATE_INDEX: CreateIndex.
      DELETE_INDEX: DeleteIndex.
    """
    OPERATION_TYPE_UNSPECIFIED = 0
    EXPORT_ENTITIES = 1
    IMPORT_ENTITIES = 2
    CREATE_INDEX = 3
    DELETE_INDEX = 4

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the Operation.

    Values:
      STATE_UNSPECIFIED: Unspecified.
      INITIALIZING: Request is being prepared for processing.
      PROCESSING: Request is actively being processed.
      CANCELLING: Request is in the process of being cancelled after user
        called google.longrunning.Operations.CancelOperation on the operation.
      FINALIZING: Request has been processed and is in its finalization stage.
      SUCCESSFUL: Request has completed successfully.
      FAILED: Request has finished being processed, but encountered an error.
      CANCELLED: Request has finished being cancelled after user called
        google.longrunning.Operations.CancelOperation.
    """
    STATE_UNSPECIFIED = 0
    INITIALIZING = 1
    PROCESSING = 2
    CANCELLING = 3
    FINALIZING = 4
    SUCCESSFUL = 5
    FAILED = 6
    CANCELLED = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The client-assigned labels which were provided when the operation was
    created. May also include additional labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  endTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  operationType = _messages.EnumField('OperationTypeValueValuesEnum', 3)
  startTime = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class GoogleDatastoreAdminV1EntityFilter(_messages.Message):
  r"""Identifies a subset of entities in a project. This is specified as
  combinations of kinds and namespaces (either or both of which may be all, as
  described in the following examples). Example usage: Entire project:
  kinds=[], namespace_ids=[] Kinds Foo and Bar in all namespaces:
  kinds=['Foo', 'Bar'], namespace_ids=[] Kinds Foo and Bar only in the default
  namespace: kinds=['Foo', 'Bar'], namespace_ids=[''] Kinds Foo and Bar in
  both the default and Baz namespaces: kinds=['Foo', 'Bar'],
  namespace_ids=['', 'Baz'] The entire Baz namespace: kinds=[],
  namespace_ids=['Baz']

  Fields:
    kinds: If empty, then this represents all kinds.
    namespaceIds: An empty list represents all namespaces. This is the
      preferred usage for projects that don't use namespaces. An empty string
      element represents the default namespace. This should be used if the
      project has data in non-default namespaces, but doesn't want to include
      them. Each namespace in this list must be unique.
  """

  kinds = _messages.StringField(1, repeated=True)
  namespaceIds = _messages.StringField(2, repeated=True)


class GoogleDatastoreAdminV1ExportEntitiesMetadata(_messages.Message):
  r"""Metadata for ExportEntities operations.

  Fields:
    common: Metadata common to all Datastore Admin operations.
    entityFilter: Description of which entities are being exported.
    outputUrlPrefix: Location for the export metadata and data files. This
      will be the same value as the
      google.datastore.admin.v1.ExportEntitiesRequest.output_url_prefix field.
      The final output location is provided in
      google.datastore.admin.v1.ExportEntitiesResponse.output_url.
    progressBytes: An estimate of the number of bytes processed.
    progressEntities: An estimate of the number of entities processed.
  """

  common = _messages.MessageField('GoogleDatastoreAdminV1CommonMetadata', 1)
  entityFilter = _messages.MessageField('GoogleDatastoreAdminV1EntityFilter', 2)
  outputUrlPrefix = _messages.StringField(3)
  progressBytes = _messages.MessageField('GoogleDatastoreAdminV1Progress', 4)
  progressEntities = _messages.MessageField('GoogleDatastoreAdminV1Progress', 5)


class GoogleDatastoreAdminV1ExportEntitiesResponse(_messages.Message):
  r"""The response for
  google.datastore.admin.v1.DatastoreAdmin.ExportEntities.

  Fields:
    outputUrl: Location of the output metadata file. This can be used to begin
      an import into Cloud Datastore (this project or another project). See
      google.datastore.admin.v1.ImportEntitiesRequest.input_url. Only present
      if the operation completed successfully.
  """

  outputUrl = _messages.StringField(1)


class GoogleDatastoreAdminV1ImportEntitiesMetadata(_messages.Message):
  r"""Metadata for ImportEntities operations.

  Fields:
    common: Metadata common to all Datastore Admin operations.
    entityFilter: Description of which entities are being imported.
    inputUrl: The location of the import metadata file. This will be the same
      value as the google.datastore.admin.v1.ExportEntitiesResponse.output_url
      field.
    progressBytes: An estimate of the number of bytes processed.
    progressEntities: An estimate of the number of entities processed.
  """

  common = _messages.MessageField('GoogleDatastoreAdminV1CommonMetadata', 1)
  entityFilter = _messages.MessageField('GoogleDatastoreAdminV1EntityFilter', 2)
  inputUrl = _messages.StringField(3)
  progressBytes = _messages.MessageField('GoogleDatastoreAdminV1Progress', 4)
  progressEntities = _messages.MessageField('GoogleDatastoreAdminV1Progress', 5)


class GoogleDatastoreAdminV1IndexOperationMetadata(_messages.Message):
  r"""Metadata for Index operations.

  Fields:
    common: Metadata common to all Datastore Admin operations.
    indexId: The index resource ID that this operation is acting on.
    progressEntities: An estimate of the number of entities processed.
  """

  common = _messages.MessageField('GoogleDatastoreAdminV1CommonMetadata', 1)
  indexId = _messages.StringField(2)
  progressEntities = _messages.MessageField('GoogleDatastoreAdminV1Progress', 3)


class GoogleDatastoreAdminV1Progress(_messages.Message):
  r"""Measures the progress of a particular metric.

  Fields:
    workCompleted: The amount of work that has been completed. Note that this
      may be greater than work_estimated.
    workEstimated: An estimate of how much work needs to be performed. May be
      zero if the work estimate is unavailable.
  """

  workCompleted = _messages.IntegerField(1)
  workEstimated = _messages.IntegerField(2)


class GoogleDatastoreAdminV1beta1CommonMetadata(_messages.Message):
  r"""Metadata common to all Datastore Admin operations.

  Enums:
    OperationTypeValueValuesEnum: The type of the operation. Can be used as a
      filter in ListOperationsRequest.
    StateValueValuesEnum: The current state of the Operation.

  Messages:
    LabelsValue: The client-assigned labels which were provided when the
      operation was created. May also include additional labels.

  Fields:
    endTime: The time the operation ended, either successfully or otherwise.
    labels: The client-assigned labels which were provided when the operation
      was created. May also include additional labels.
    operationType: The type of the operation. Can be used as a filter in
      ListOperationsRequest.
    startTime: The time that work began on the operation.
    state: The current state of the Operation.
  """

  class OperationTypeValueValuesEnum(_messages.Enum):
    r"""The type of the operation. Can be used as a filter in
    ListOperationsRequest.

    Values:
      OPERATION_TYPE_UNSPECIFIED: Unspecified.
      EXPORT_ENTITIES: ExportEntities.
      IMPORT_ENTITIES: ImportEntities.
    """
    OPERATION_TYPE_UNSPECIFIED = 0
    EXPORT_ENTITIES = 1
    IMPORT_ENTITIES = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""The current state of the Operation.

    Values:
      STATE_UNSPECIFIED: Unspecified.
      INITIALIZING: Request is being prepared for processing.
      PROCESSING: Request is actively being processed.
      CANCELLING: Request is in the process of being cancelled after user
        called google.longrunning.Operations.CancelOperation on the operation.
      FINALIZING: Request has been processed and is in its finalization stage.
      SUCCESSFUL: Request has completed successfully.
      FAILED: Request has finished being processed, but encountered an error.
      CANCELLED: Request has finished being cancelled after user called
        google.longrunning.Operations.CancelOperation.
    """
    STATE_UNSPECIFIED = 0
    INITIALIZING = 1
    PROCESSING = 2
    CANCELLING = 3
    FINALIZING = 4
    SUCCESSFUL = 5
    FAILED = 6
    CANCELLED = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The client-assigned labels which were provided when the operation was
    created. May also include additional labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  endTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  operationType = _messages.EnumField('OperationTypeValueValuesEnum', 3)
  startTime = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class GoogleDatastoreAdminV1beta1EntityFilter(_messages.Message):
  r"""Identifies a subset of entities in a project. This is specified as
  combinations of kinds and namespaces (either or both of which may be all, as
  described in the following examples). Example usage: Entire project:
  kinds=[], namespace_ids=[] Kinds Foo and Bar in all namespaces:
  kinds=['Foo', 'Bar'], namespace_ids=[] Kinds Foo and Bar only in the default
  namespace: kinds=['Foo', 'Bar'], namespace_ids=[''] Kinds Foo and Bar in
  both the default and Baz namespaces: kinds=['Foo', 'Bar'],
  namespace_ids=['', 'Baz'] The entire Baz namespace: kinds=[],
  namespace_ids=['Baz']

  Fields:
    kinds: If empty, then this represents all kinds.
    namespaceIds: An empty list represents all namespaces. This is the
      preferred usage for projects that don't use namespaces. An empty string
      element represents the default namespace. This should be used if the
      project has data in non-default namespaces, but doesn't want to include
      them. Each namespace in this list must be unique.
  """

  kinds = _messages.StringField(1, repeated=True)
  namespaceIds = _messages.StringField(2, repeated=True)


class GoogleDatastoreAdminV1beta1ExportEntitiesMetadata(_messages.Message):
  r"""Metadata for ExportEntities operations.

  Fields:
    common: Metadata common to all Datastore Admin operations.
    entityFilter: Description of which entities are being exported.
    outputUrlPrefix: Location for the export metadata and data files. This
      will be the same value as the
      google.datastore.admin.v1beta1.ExportEntitiesRequest.output_url_prefix
      field. The final output location is provided in
      google.datastore.admin.v1beta1.ExportEntitiesResponse.output_url.
    progressBytes: An estimate of the number of bytes processed.
    progressEntities: An estimate of the number of entities processed.
  """

  common = _messages.MessageField('GoogleDatastoreAdminV1beta1CommonMetadata', 1)
  entityFilter = _messages.MessageField('GoogleDatastoreAdminV1beta1EntityFilter', 2)
  outputUrlPrefix = _messages.StringField(3)
  progressBytes = _messages.MessageField('GoogleDatastoreAdminV1beta1Progress', 4)
  progressEntities = _messages.MessageField('GoogleDatastoreAdminV1beta1Progress', 5)


class GoogleDatastoreAdminV1beta1ExportEntitiesRequest(_messages.Message):
  r"""The request for
  google.datastore.admin.v1beta1.DatastoreAdmin.ExportEntities.

  Messages:
    LabelsValue: Client-assigned labels.

  Fields:
    entityFilter: Description of what data from the project is included in the
      export.
    labels: Client-assigned labels.
    outputUrlPrefix: Location for the export metadata and data files. The full
      resource URL of the external storage location. Currently, only Google
      Cloud Storage is supported. So output_url_prefix should be of the form:
      `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the name of
      the Cloud Storage bucket and `NAMESPACE_PATH` is an optional Cloud
      Storage namespace path (this is not a Cloud Datastore namespace). For
      more information about Cloud Storage namespace paths, see [Object name
      considerations](https://cloud.google.com/storage/docs/naming#object-
      considerations). The resulting files will be nested deeper than the
      specified URL prefix. The final output URL will be provided in the
      google.datastore.admin.v1beta1.ExportEntitiesResponse.output_url field.
      That value should be used for subsequent ImportEntities operations. By
      nesting the data files deeper, the same Cloud Storage bucket can be used
      in multiple ExportEntities operations without conflict.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Client-assigned labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  entityFilter = _messages.MessageField('GoogleDatastoreAdminV1beta1EntityFilter', 1)
  labels = _messages.MessageField('LabelsValue', 2)
  outputUrlPrefix = _messages.StringField(3)


class GoogleDatastoreAdminV1beta1ExportEntitiesResponse(_messages.Message):
  r"""The response for
  google.datastore.admin.v1beta1.DatastoreAdmin.ExportEntities.

  Fields:
    outputUrl: Location of the output metadata file. This can be used to begin
      an import into Cloud Datastore (this project or another project). See
      google.datastore.admin.v1beta1.ImportEntitiesRequest.input_url. Only
      present if the operation completed successfully.
  """

  outputUrl = _messages.StringField(1)


class GoogleDatastoreAdminV1beta1ImportEntitiesMetadata(_messages.Message):
  r"""Metadata for ImportEntities operations.

  Fields:
    common: Metadata common to all Datastore Admin operations.
    entityFilter: Description of which entities are being imported.
    inputUrl: The location of the import metadata file. This will be the same
      value as the
      google.datastore.admin.v1beta1.ExportEntitiesResponse.output_url field.
    progressBytes: An estimate of the number of bytes processed.
    progressEntities: An estimate of the number of entities processed.
  """

  common = _messages.MessageField('GoogleDatastoreAdminV1beta1CommonMetadata', 1)
  entityFilter = _messages.MessageField('GoogleDatastoreAdminV1beta1EntityFilter', 2)
  inputUrl = _messages.StringField(3)
  progressBytes = _messages.MessageField('GoogleDatastoreAdminV1beta1Progress', 4)
  progressEntities = _messages.MessageField('GoogleDatastoreAdminV1beta1Progress', 5)


class GoogleDatastoreAdminV1beta1ImportEntitiesRequest(_messages.Message):
  r"""The request for
  google.datastore.admin.v1beta1.DatastoreAdmin.ImportEntities.

  Messages:
    LabelsValue: Client-assigned labels.

  Fields:
    entityFilter: Optionally specify which kinds/namespaces are to be
      imported. If provided, the list must be a subset of the EntityFilter
      used in creating the export, otherwise a FAILED_PRECONDITION error will
      be returned. If no filter is specified then all entities from the export
      are imported.
    inputUrl: The full resource URL of the external storage location.
      Currently, only Google Cloud Storage is supported. So input_url should
      be of the form:
      `gs://BUCKET_NAME[/NAMESPACE_PATH]/OVERALL_EXPORT_METADATA_FILE`, where
      `BUCKET_NAME` is the name of the Cloud Storage bucket, `NAMESPACE_PATH`
      is an optional Cloud Storage namespace path (this is not a Cloud
      Datastore namespace), and `OVERALL_EXPORT_METADATA_FILE` is the metadata
      file written by the ExportEntities operation. For more information about
      Cloud Storage namespace paths, see [Object name
      considerations](https://cloud.google.com/storage/docs/naming#object-
      considerations). For more information, see
      google.datastore.admin.v1beta1.ExportEntitiesResponse.output_url.
    labels: Client-assigned labels.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Client-assigned labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  entityFilter = _messages.MessageField('GoogleDatastoreAdminV1beta1EntityFilter', 1)
  inputUrl = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)


class GoogleDatastoreAdminV1beta1Progress(_messages.Message):
  r"""Measures the progress of a particular metric.

  Fields:
    workCompleted: The amount of work that has been completed. Note that this
      may be greater than work_estimated.
    workEstimated: An estimate of how much work needs to be performed. May be
      zero if the work estimate is unavailable.
  """

  workCompleted = _messages.IntegerField(1)
  workEstimated = _messages.IntegerField(2)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
