"""Generated message classes for cloudcommerceconsumerprocurement version v1alpha1.

Enables consumers to procure products served by Cloud CommerceMarketplace
platform
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudcommerceconsumerprocurement'


class CloudcommerceconsumerprocurementBillingAccountsAccountsCreateRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementBillingAccountsAccountsCreateRequest
  object.

  Fields:
    googleCloudCommerceConsumerProcurementV1alpha1Account: A
      GoogleCloudCommerceConsumerProcurementV1alpha1Account resource to be
      passed as the request body.
    parent: Required. The parent resource of this account. This field is of
      the form "/". Currently supported type: 'billingAccounts/{billing-
      account-id}'
  """

  googleCloudCommerceConsumerProcurementV1alpha1Account = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1Account', 1)
  parent = _messages.StringField(2, required=True)


class CloudcommerceconsumerprocurementBillingAccountsAccountsDeleteRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementBillingAccountsAccountsDeleteRequest
  object.

  Fields:
    name: Required. The resource name of the account to delete.
  """

  name = _messages.StringField(1, required=True)


class CloudcommerceconsumerprocurementBillingAccountsAccountsGetRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementBillingAccountsAccountsGetRequest
  object.

  Fields:
    name: Required. The resource name of the account to retrieve.
  """

  name = _messages.StringField(1, required=True)


class CloudcommerceconsumerprocurementBillingAccountsAccountsListRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementBillingAccountsAccountsListRequest
  object.

  Fields:
    pageSize: The maximum number of entries that are requested.
    pageToken: The token for fetching the next page.
    parent: Required. The parent resource to query for accounts. This field is
      of the form `billingAccounts/{billing-account-id}`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudcommerceconsumerprocurementBillingAccountsAccountsOperationsCancelRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementBillingAccountsAccountsOperationsCance
  lRequest object.

  Fields:
    googleLongrunningCancelOperationRequest: A
      GoogleLongrunningCancelOperationRequest resource to be passed as the
      request body.
    name: The name of the operation resource to be cancelled.
  """

  googleLongrunningCancelOperationRequest = _messages.MessageField('GoogleLongrunningCancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudcommerceconsumerprocurementBillingAccountsAccountsOperationsDeleteRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementBillingAccountsAccountsOperationsDelet
  eRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class CloudcommerceconsumerprocurementBillingAccountsAccountsOperationsGetRequest(_messages.Message):
  r"""A
  CloudcommerceconsumerprocurementBillingAccountsAccountsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CloudcommerceconsumerprocurementBillingAccountsAccountsOperationsListRequest(_messages.Message):
  r"""A
  CloudcommerceconsumerprocurementBillingAccountsAccountsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class CloudcommerceconsumerprocurementBillingAccountsOrdersCancelRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementBillingAccountsOrdersCancelRequest
  object.

  Fields:
    googleCloudCommerceConsumerProcurementV1alpha1CancelOrderRequest: A
      GoogleCloudCommerceConsumerProcurementV1alpha1CancelOrderRequest
      resource to be passed as the request body.
    name: Required. The resource name of the order.
  """

  googleCloudCommerceConsumerProcurementV1alpha1CancelOrderRequest = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1CancelOrderRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudcommerceconsumerprocurementBillingAccountsOrdersGetRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementBillingAccountsOrdersGetRequest
  object.

  Fields:
    name: Required. The name of the order to retrieve.
  """

  name = _messages.StringField(1, required=True)


class CloudcommerceconsumerprocurementBillingAccountsOrdersListRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementBillingAccountsOrdersListRequest
  object.

  Fields:
    filter: The filter that can be used to limit the list request. The filter
      is a query string that can match a selected set of attributes with
      string values. For example `display_name=abc`. Supported query
      attributes are * `display_name` If the query contains some special
      characters other than letters, underscore, or digits, the phrase must be
      quoted with double quotes. For example, `display_name="foo:bar"`, where
      the display name needs to be quoted because it contains special
      character colon. Queries can be combined with `OR`, and `NOT` to form
      more complex queries. They can also be grouped to force a desired
      evaluation order. For example, `display_name=abc OR display_name=def`.
    pageSize: The maximum number of entries that are requested.
    pageToken: The token for fetching the next page.
    parent: Required. The parent resource to query for orders. This field is
      of the form `billingAccounts/{billing-account-id}`.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class CloudcommerceconsumerprocurementBillingAccountsOrdersMigrateRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementBillingAccountsOrdersMigrateRequest
  object.

  Fields:
    googleCloudCommerceConsumerProcurementV1alpha1MigrateOrderRequest: A
      GoogleCloudCommerceConsumerProcurementV1alpha1MigrateOrderRequest
      resource to be passed as the request body.
    name: Required. Name of the order to migrate. This field is in this form:
      billingAccounts/{billing-account-id}/orders/{order-id}.
  """

  googleCloudCommerceConsumerProcurementV1alpha1MigrateOrderRequest = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1MigrateOrderRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudcommerceconsumerprocurementBillingAccountsOrdersModifyRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementBillingAccountsOrdersModifyRequest
  object.

  Fields:
    googleCloudCommerceConsumerProcurementV1alpha1ModifyOrderRequest: A
      GoogleCloudCommerceConsumerProcurementV1alpha1ModifyOrderRequest
      resource to be passed as the request body.
    name: Required. Name of the order to update.
  """

  googleCloudCommerceConsumerProcurementV1alpha1ModifyOrderRequest = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1ModifyOrderRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudcommerceconsumerprocurementBillingAccountsOrdersOperationsCancelRequest(_messages.Message):
  r"""A
  CloudcommerceconsumerprocurementBillingAccountsOrdersOperationsCancelRequest
  object.

  Fields:
    googleLongrunningCancelOperationRequest: A
      GoogleLongrunningCancelOperationRequest resource to be passed as the
      request body.
    name: The name of the operation resource to be cancelled.
  """

  googleLongrunningCancelOperationRequest = _messages.MessageField('GoogleLongrunningCancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudcommerceconsumerprocurementBillingAccountsOrdersOperationsDeleteRequest(_messages.Message):
  r"""A
  CloudcommerceconsumerprocurementBillingAccountsOrdersOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class CloudcommerceconsumerprocurementBillingAccountsOrdersOperationsGetRequest(_messages.Message):
  r"""A
  CloudcommerceconsumerprocurementBillingAccountsOrdersOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CloudcommerceconsumerprocurementBillingAccountsOrdersOperationsListRequest(_messages.Message):
  r"""A
  CloudcommerceconsumerprocurementBillingAccountsOrdersOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class CloudcommerceconsumerprocurementBillingAccountsOrdersOrderAllocationsCreateRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementBillingAccountsOrdersOrderAllocationsC
  reateRequest object.

  Fields:
    googleCloudCommerceConsumerProcurementV1alpha1OrderAllocation: A
      GoogleCloudCommerceConsumerProcurementV1alpha1OrderAllocation resource
      to be passed as the request body.
    parent: Required. The parent resource of this OrderAllocation. This field
      is of the form 'billingAccounts/{billing-account-id}/orders/{order-id}'.
  """

  googleCloudCommerceConsumerProcurementV1alpha1OrderAllocation = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1OrderAllocation', 1)
  parent = _messages.StringField(2, required=True)


class CloudcommerceconsumerprocurementBillingAccountsOrdersOrderAllocationsDeleteRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementBillingAccountsOrdersOrderAllocationsD
  eleteRequest object.

  Fields:
    name: Required. The resource name of the OrderAllocation to delete.
  """

  name = _messages.StringField(1, required=True)


class CloudcommerceconsumerprocurementBillingAccountsOrdersOrderAllocationsGetRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementBillingAccountsOrdersOrderAllocationsG
  etRequest object.

  Fields:
    name: Required. The name of the OrderAllocation to retrieve. This field is
      of the form `billingAccounts/{billing-account-id}/orders/{order-
      id}/orderAllocations/{order-allocation-id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudcommerceconsumerprocurementBillingAccountsOrdersOrderAllocationsListRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementBillingAccountsOrdersOrderAllocationsL
  istRequest object.

  Fields:
    pageSize: The maximum number of entries that are requested.
    pageToken: The token for fetching the next page.
    parent: Required. The parent resource to query for OrderAllocations. This
      field is of the form `billingAccounts/{billing-account-
      id}/orders/{order-id}`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudcommerceconsumerprocurementBillingAccountsOrdersOrderAllocationsPatchRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementBillingAccountsOrdersOrderAllocationsP
  atchRequest object.

  Fields:
    googleCloudCommerceConsumerProcurementV1alpha1OrderAllocation: A
      GoogleCloudCommerceConsumerProcurementV1alpha1OrderAllocation resource
      to be passed as the request body.
    name: Output only. The resource name of the allocation. This field is of
      the form: `billingAccounts/{billing-account-id}/orders/{order-
      id}/orderAllocations/{order-allocation-id}`.
    updateMask: The update mask that applies to the resource. See the
      [FieldMask definition] (https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask) for more details.
  """

  googleCloudCommerceConsumerProcurementV1alpha1OrderAllocation = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1OrderAllocation', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudcommerceconsumerprocurementBillingAccountsOrdersPlaceRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementBillingAccountsOrdersPlaceRequest
  object.

  Fields:
    googleCloudCommerceConsumerProcurementV1alpha1PlaceOrderRequest: A
      GoogleCloudCommerceConsumerProcurementV1alpha1PlaceOrderRequest resource
      to be passed as the request body.
    parent: Required. The resource name of the parent resource. This field is
      of the form `billingAccounts/{billing-account-id}`.
  """

  googleCloudCommerceConsumerProcurementV1alpha1PlaceOrderRequest = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1PlaceOrderRequest', 1)
  parent = _messages.StringField(2, required=True)


class CloudcommerceconsumerprocurementProjectsEntitlementsGetRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementProjectsEntitlementsGetRequest object.

  Fields:
    name: Required. The name of the entitlement to retrieve. This field is one
      of the following forms: `projects/{project-
      number}/entitlements/{entitlement-id}` `projects/{project-
      id}/entitlements/{entitlement-id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudcommerceconsumerprocurementProjectsEntitlementsListRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementProjectsEntitlementsListRequest
  object.

  Fields:
    pageSize: The maximum number of entries that are requested.
    pageToken: The token for fetching the next page.
    parent: Required. The parent resource to query for Entitlements. Currently
      the only parents supported are "projects/{project-number}" and
      "projects/{project-id}".
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudcommerceconsumerprocurementProjectsFreeTrialsCreateRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementProjectsFreeTrialsCreateRequest
  object.

  Fields:
    googleCloudCommerceConsumerProcurementV1alpha1FreeTrial: A
      GoogleCloudCommerceConsumerProcurementV1alpha1FreeTrial resource to be
      passed as the request body.
    parent: Required. The parent resource to query for FreeTrials. Currently
      the only parent supported is "projects/{project-id}".
  """

  googleCloudCommerceConsumerProcurementV1alpha1FreeTrial = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1FreeTrial', 1)
  parent = _messages.StringField(2, required=True)


class CloudcommerceconsumerprocurementProjectsFreeTrialsGetRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementProjectsFreeTrialsGetRequest object.

  Fields:
    name: Required. The name of the freeTrial to retrieve. This field is of
      the form `projects/{project-id}/freeTrials/{freetrial-id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudcommerceconsumerprocurementProjectsFreeTrialsListRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementProjectsFreeTrialsListRequest object.

  Fields:
    filter: The filter that can be used to limit the list request. The filter
      is a query string that can match a selected set of attributes with
      string values. For example `product_external_name=1234-5678-ABCD-EFG`.
      Supported query attributes are * `product_external_name` * `provider` If
      the query contains some special characters other than letters,
      underscore, or digits, the phrase must be quoted with double quotes. For
      example, `product_external_name="foo:bar"`, where the product name needs
      to be quoted because it contains special character colon. Queries can be
      combined with `AND`, `OR`, and `NOT` to form more complex queries. They
      can also be grouped to force a desired evaluation order. For example,
      `provider=providers/E-1234 OR provider=providers/5678 AND NOT
      (product_external_name=foo-product)`. Connective `AND` can be omitted
      between two predicates. For example `provider=providers/E-1234
      product_external_name=foo` is equivalent to `provider=providers/E-1234
      AND product_external_name=foo`.
    pageSize: The maximum number of entries that are requested.
    pageToken: The token for fetching the next page.
    parent: Required. The parent resource to query for FreeTrials. Currently
      the only parent supported is "projects/{project-id}".
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class CloudcommerceconsumerprocurementProjectsFreeTrialsOperationsCancelRequest(_messages.Message):
  r"""A
  CloudcommerceconsumerprocurementProjectsFreeTrialsOperationsCancelRequest
  object.

  Fields:
    googleLongrunningCancelOperationRequest: A
      GoogleLongrunningCancelOperationRequest resource to be passed as the
      request body.
    name: The name of the operation resource to be cancelled.
  """

  googleLongrunningCancelOperationRequest = _messages.MessageField('GoogleLongrunningCancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudcommerceconsumerprocurementProjectsFreeTrialsOperationsDeleteRequest(_messages.Message):
  r"""A
  CloudcommerceconsumerprocurementProjectsFreeTrialsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class CloudcommerceconsumerprocurementProjectsFreeTrialsOperationsGetRequest(_messages.Message):
  r"""A CloudcommerceconsumerprocurementProjectsFreeTrialsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CloudcommerceconsumerprocurementProjectsFreeTrialsOperationsListRequest(_messages.Message):
  r"""A
  CloudcommerceconsumerprocurementProjectsFreeTrialsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GoogleCloudCommerceConsumerProcurementV1alpha1Account(_messages.Message):
  r"""Represents an account that was established by the customer with a
  service provider. When consuming services on external service provider's
  systems, the service provider generally needs to create a linked-account on
  their system to track customers. The account resource represents this
  relationship. Products/Services that are hosted by external service
  providers generally require an account to be present before they can be
  purchased and used. The metadata that indicates whether an Account is
  required for a purchase, or what parameters are needed for creating an
  Account is configured by service providers.

  Messages:
    PropertiesValue: Output only. Set of properties that the service provider
      supplied during account creation.

  Fields:
    approvals: Output only. The approvals for this account. These approvals
      are used to track actions that are permitted or have been completed by a
      customer within the context of the provider. This might include a sign
      up flow or a provisioning step, for example, that the provider can admit
      to having happened.
    createTime: Output only. The creation timestamp.
    name: Output only. The resource name of the account. Account names have
      the form `billingAccounts/{billing_account_id}/accounts/{account_id}`.
    properties: Output only. Set of properties that the service provider
      supplied during account creation.
    provider: Required. The identifier of the service provider that this
      account was created against. Provider has the format of
      `providers/{provider_id}`.
    updateTime: Output only. The last update timestamp.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Output only. Set of properties that the service provider supplied
    during account creation.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  approvals = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1AccountApproval', 1, repeated=True)
  createTime = _messages.StringField(2)
  name = _messages.StringField(3)
  properties = _messages.MessageField('PropertiesValue', 4)
  provider = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class GoogleCloudCommerceConsumerProcurementV1alpha1AccountApproval(_messages.Message):
  r"""An approval for some action on an account.

  Enums:
    StateValueValuesEnum: The state of the approval.

  Fields:
    name: The name of the approval.
    reason: An explanation for the state of the approval.
    state: The state of the approval.
    updateTime: The last update timestamp of the approval.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of the approval.

    Values:
      STATE_UNSPECIFIED: Sentinel value; do not use.
      PENDING: The approval is pending response from the provider. The
        approval state can transition to Account.Approval.State.APPROVED or
        Account.Approval.State.REJECTED.
      APPROVED: The approval has been granted by the provider.
      REJECTED: The approval has been rejected by the provider. A provider may
        choose to approve a previously rejected approval, so is it possible to
        transition to Account.Approval.State.APPROVED.
    """
    STATE_UNSPECIFIED = 0
    PENDING = 1
    APPROVED = 2
    REJECTED = 3

  name = _messages.StringField(1)
  reason = _messages.StringField(2)
  state = _messages.EnumField('StateValueValuesEnum', 3)
  updateTime = _messages.StringField(4)


class GoogleCloudCommerceConsumerProcurementV1alpha1AddOnDetails(_messages.Message):
  r"""Information about an add-on line item.

  Fields:
    isAddOn: Output only. Indicates whether this item is an add-on.
  """

  isAddOn = _messages.BooleanField(1)


class GoogleCloudCommerceConsumerProcurementV1alpha1CancelOrderRequest(_messages.Message):
  r"""Request message for ConsumerProcurementService.CancelOrder.

  Enums:
    CancellationPolicyValueValuesEnum: Cancellation policy of this request.

  Fields:
    cancellationPolicy: Cancellation policy of this request.
    etag: The weak etag, which can be optionally populated, of the order that
      this cancel request is based on. Validation checking will only happen if
      the invoker supplies this field.
  """

  class CancellationPolicyValueValuesEnum(_messages.Enum):
    r"""Cancellation policy of this request.

    Values:
      CANCELLATION_POLICY_UNSPECIFIED: If unspecified, cancellation will try
        to cancel the order, if order cannot be immediately cancelled, auto
        renewal will be turned off.
      CANCELLATION_POLICY_CANCEL_IMMEDIATELY: Request will cancel the whole
        order immediately, if order cannot be immediately cancelled, the
        request will fail.
      CANCELLATION_POLICY_CANCEL_AT_TERM_END: Request will cancel the auto
        renewal, if order is not subscription based, the request will fail.
    """
    CANCELLATION_POLICY_UNSPECIFIED = 0
    CANCELLATION_POLICY_CANCEL_IMMEDIATELY = 1
    CANCELLATION_POLICY_CANCEL_AT_TERM_END = 2

  cancellationPolicy = _messages.EnumField('CancellationPolicyValueValuesEnum', 1)
  etag = _messages.StringField(2)


class GoogleCloudCommerceConsumerProcurementV1alpha1CustomPricing(_messages.Message):
  r"""Information about custom pricing on a resource.

  Fields:
    endTime: The end time of the custom pricing.
  """

  endTime = _messages.StringField(1)


class GoogleCloudCommerceConsumerProcurementV1alpha1Entitlement(_messages.Message):
  r"""Entitlement represents the ability to use a product or services
  associated with a purchase within a Project. When the customer creates an
  Order, the system will create Entitlement resources under projects
  associated with the same billing account as the order, for all
  products/services procured in the order. Users can enable/disable
  Entitlements to allow/disallow using the product/service in a project. Next
  Id: 17

  Enums:
    StateValueValuesEnum: Output only. The state of the entitlement.

  Fields:
    changeHistory: Output only. Changes that are not pending anymore, e.g. it
      was effective at some point, or the change was reverted by the customer,
      or the change was rejected by partner. No more operations are allowed on
      these changes.
    createTime: Output only. The create timestamp.
    flavorExternalName: Output only. External name of the flavor this
      entitlement is created against. This field is populated when entitlement
      has currently associated flavor, it is empty when entitlement is
      UNAVAILABLE (if order is pending activation or order is already
      cancelled).
    name: Output only. The resource Name of the Entitlement. Entitlement names
      have the form `projects/{project_id}/entitlements/{entitlement_id}`.
    order: Output only. Order associated with this Entitlement.
    pendingChange: Output only. A change which is pending and not yet
      effective.
    productExternalName: Output only. External name of the product this
      entitlement is created against.
    provider: Output only. Provider associated with this Entitlement. In the
      format of `providers/{provider_id}`.
    services: Output only. Services associated with the entitlement.
    state: Output only. The state of the entitlement.
    stateReason: Output only. An explanation for the entitlement's state.
      Mainly used in the case of
      `EntitlementState.ENTITLEMENT_STATE_UNAVAILABLE` states to explain why
      the entitlement is unavailable.
    updateTime: Output only. The last update timestamp.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the entitlement.

    Values:
      ENTITLEMENT_STATE_UNSPECIFIED: Sentinel value. Do not use.
      ENTITLEMENT_STATE_UNAVAILABLE: Indicates that the entitlement is
        unavailable and cannot be enabled.
      ENTITLEMENT_STATE_ENABLED: Indicates that the entitlement is enabled.
        The procured item is now usable.
      ENTITLEMENT_STATE_DISABLED: Indicates that the entitlement is disabled.
        The procured item is not usable.
    """
    ENTITLEMENT_STATE_UNSPECIFIED = 0
    ENTITLEMENT_STATE_UNAVAILABLE = 1
    ENTITLEMENT_STATE_ENABLED = 2
    ENTITLEMENT_STATE_DISABLED = 3

  changeHistory = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1EntitlementChange', 1, repeated=True)
  createTime = _messages.StringField(2)
  flavorExternalName = _messages.StringField(3)
  name = _messages.StringField(4)
  order = _messages.StringField(5)
  pendingChange = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1EntitlementChange', 6)
  productExternalName = _messages.StringField(7)
  provider = _messages.StringField(8)
  services = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1EntitlementService', 9, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  stateReason = _messages.StringField(11)
  updateTime = _messages.StringField(12)


class GoogleCloudCommerceConsumerProcurementV1alpha1EntitlementChange(_messages.Message):
  r"""Entitlement change information. Next Id: 7

  Enums:
    ChangeStateValueValuesEnum: Output only. State of the change.

  Fields:
    changeEffectiveTime: Output only. A time at which the change became or
      will become (in case of pending change) effective.
    changeState: Output only. State of the change.
    newFlavorExternalName: Output only. Flavor external name after the change.
    oldFlavorExternalName: Output only. Flavor external name before the
      change.
  """

  class ChangeStateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the change.

    Values:
      CHANGE_STATE_UNSPECIFIED: Sentinel value. Do not use.
      CHANGE_STATE_PENDING_APPROVAL: Change is in this state when a change is
        initiated and waiting for partner approval.
      CHANGE_STATE_APPROVED: Change is in this state, if the change was
        approved by partner or auto-approved but is pending to be effective.
      CHANGE_STATE_COMPLETED: Change is in this state, if the change was
        activated and completed successfully.
      CHANGE_STATE_REJECTED: Change is in this state, if the change was
        rejected by partner.
      CHANGE_STATE_ABANDONED: Change is in this state, if it was abandoned by
        user.
    """
    CHANGE_STATE_UNSPECIFIED = 0
    CHANGE_STATE_PENDING_APPROVAL = 1
    CHANGE_STATE_APPROVED = 2
    CHANGE_STATE_COMPLETED = 3
    CHANGE_STATE_REJECTED = 4
    CHANGE_STATE_ABANDONED = 5

  changeEffectiveTime = _messages.StringField(1)
  changeState = _messages.EnumField('ChangeStateValueValuesEnum', 2)
  newFlavorExternalName = _messages.StringField(3)
  oldFlavorExternalName = _messages.StringField(4)


class GoogleCloudCommerceConsumerProcurementV1alpha1EntitlementInfo(_messages.Message):
  r"""The benefit associated with a product purchase.

  Fields:
    id: ID of the entitlement info. Unique across all orders.
    services: The names of the Inception services to enable.
  """

  id = _messages.StringField(1)
  services = _messages.StringField(2, repeated=True)


class GoogleCloudCommerceConsumerProcurementV1alpha1EntitlementService(_messages.Message):
  r"""A service associated with the entitlement.

  Enums:
    ServiceStateValueValuesEnum: Current state of the service within project.

  Fields:
    serviceName: The name of the service.
    serviceState: Current state of the service within project.
  """

  class ServiceStateValueValuesEnum(_messages.Enum):
    r"""Current state of the service within project.

    Values:
      STATE_UNSPECIFIED: Sentinel value. Do not use.
      ENABLED: Indicates service is enabled within project.
      DISABLED: Indicates service is disabled within project.
    """
    STATE_UNSPECIFIED = 0
    ENABLED = 1
    DISABLED = 2

  serviceName = _messages.StringField(1)
  serviceState = _messages.EnumField('ServiceStateValueValuesEnum', 2)


class GoogleCloudCommerceConsumerProcurementV1alpha1FreeTrial(_messages.Message):
  r"""FreeTrial represents the free trial created for a specific provider,
  product id and billing id with argentum. Free Trial resource are created for
  products by placing orders for 3p or just enabling free trials for 1p
  product. Next Id: 5

  Fields:
    credit: Output only. Credit tracking the real time credit status.
    name: Output only. The resource name of the free trial item. This field is
      of the form: `projects/{project_id}/freeTrials/{freetrial_id}`. Present
      if free trial is created under the project's associated billing account
      for 3p, or free trial is enabled for 1p product.
    productExternalName: External name for the product for which free trial
      exist.
    provider: Provider of the products for which free trial exist. Provider
      has the format of `providers/{provider_id}`.
  """

  credit = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1FreeTrialCredit', 1)
  name = _messages.StringField(2)
  productExternalName = _messages.StringField(3)
  provider = _messages.StringField(4)


class GoogleCloudCommerceConsumerProcurementV1alpha1FreeTrialCredit(_messages.Message):
  r"""Credit represents the real time credit information.

  Fields:
    creationDate: Date credit was created.
    endTime: When the credit expires. If empty then there's no upper bound of
      credit's effective timespan (i.e. the credit never expires).
    remainingAmount: The amount of the credit remaining.
    startTime: When the credit becomes effective. If empty then there's no
      lower bound of credit's effective timespan (i.e. the credit becomes
      effective at the time of its creation). For credit creation, this cannot
      be in the past.
    value: The value of the credit.
  """

  creationDate = _messages.StringField(1)
  endTime = _messages.StringField(2)
  remainingAmount = _messages.MessageField('GoogleTypeMoney', 3)
  startTime = _messages.StringField(4)
  value = _messages.MessageField('GoogleTypeMoney', 5)


class GoogleCloudCommerceConsumerProcurementV1alpha1LineItem(_messages.Message):
  r"""A single item within an order.

  Fields:
    changeHistory: Output only. Changes made on the item that are not pending
      anymore, e.g. it was effective at some point, or the change was reverted
      by the customer, or the change was rejected by partner. No more
      operations are allowed on these changes.
    lineItemId: Output only. Line item ID.
    lineItemInfo: Output only. Current state and information of this item. It
      tells what, e.g. which plan, is currently effective.
    pendingChange: Output only. A change made on the item which is pending and
      not yet effective. Absence of this field indicates the line item is not
      undergoing a change.
  """

  changeHistory = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1LineItemChange', 1, repeated=True)
  lineItemId = _messages.StringField(2)
  lineItemInfo = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1LineItemInfo', 3)
  pendingChange = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1LineItemChange', 4)


class GoogleCloudCommerceConsumerProcurementV1alpha1LineItemChange(_messages.Message):
  r"""A change made on a line item.

  Enums:
    ChangeStateValueValuesEnum: Output only. State of the change.
    ChangeTypeValueValuesEnum: Required. Type of the change to make.

  Fields:
    changeEffectiveTime: Output only. A time at which the change became or
      will become (in case of pending change) effective.
    changeId: Output only. Change ID. All changes made within one order update
      operation have the same change_id.
    changeState: Output only. State of the change.
    changeType: Required. Type of the change to make.
    createTime: Output only. The time when change was initiated.
    newLineItemInfo: Line item info after the change.
    oldLineItemInfo: Output only. Line item info before the change.
    stateReason: Output only. Provider supplied message explanation for the
      LineItemChange's state. Mainly used to communicate progress and ETA for
      provisioning in the case of `PENDING_APPROVAL`, and to explain why the
      change request was denied or canceled in the case of `REJECTED` and
      `CANCELED` states.
    updateTime: Output only. The time when change was updated, e.g.
      approved/rejected by partners or cancelled by the user.
  """

  class ChangeStateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the change.

    Values:
      LINE_ITEM_CHANGE_STATE_UNSPECIFIED: Sentinel value. Do not use.
      LINE_ITEM_CHANGE_STATE_PENDING_APPROVAL: Change is in this state when a
        change is initiated and waiting for partner approval.
      LINE_ITEM_CHANGE_STATE_APPROVED: Change is in this state, if the change
        was approved by partner or auto-approved but is pending to be
        effective.
      LINE_ITEM_CHANGE_STATE_COMPLETED: Change is in this state, if the change
        was activated and completed successfully.
      LINE_ITEM_CHANGE_STATE_REJECTED: Change is in this state, if the change
        was rejected by partner.
      LINE_ITEM_CHANGE_STATE_ABANDONED: Change is in this state, if it was
        abandoned by user.
    """
    LINE_ITEM_CHANGE_STATE_UNSPECIFIED = 0
    LINE_ITEM_CHANGE_STATE_PENDING_APPROVAL = 1
    LINE_ITEM_CHANGE_STATE_APPROVED = 2
    LINE_ITEM_CHANGE_STATE_COMPLETED = 3
    LINE_ITEM_CHANGE_STATE_REJECTED = 4
    LINE_ITEM_CHANGE_STATE_ABANDONED = 5

  class ChangeTypeValueValuesEnum(_messages.Enum):
    r"""Required. Type of the change to make.

    Values:
      LINE_ITEM_CHANGE_TYPE_UNSPECIFIED: Sentinel value. Do not use.
      LINE_ITEM_CHANGE_TYPE_CREATE: The change is to create a new line item.
      LINE_ITEM_CHANGE_TYPE_UPDATE: The change is to update an existing line
        item.
      LINE_ITEM_CHANGE_TYPE_CANCEL: The change is to cancel an existing line
        item.
      LINE_ITEM_CHANGE_TYPE_REVERT_CANCELLATION: The change is to revert a
        cancellation.
    """
    LINE_ITEM_CHANGE_TYPE_UNSPECIFIED = 0
    LINE_ITEM_CHANGE_TYPE_CREATE = 1
    LINE_ITEM_CHANGE_TYPE_UPDATE = 2
    LINE_ITEM_CHANGE_TYPE_CANCEL = 3
    LINE_ITEM_CHANGE_TYPE_REVERT_CANCELLATION = 4

  changeEffectiveTime = _messages.StringField(1)
  changeId = _messages.StringField(2)
  changeState = _messages.EnumField('ChangeStateValueValuesEnum', 3)
  changeType = _messages.EnumField('ChangeTypeValueValuesEnum', 4)
  createTime = _messages.StringField(5)
  newLineItemInfo = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1LineItemInfo', 6)
  oldLineItemInfo = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1LineItemInfo', 7)
  stateReason = _messages.StringField(8)
  updateTime = _messages.StringField(9)


class GoogleCloudCommerceConsumerProcurementV1alpha1LineItemInfo(_messages.Message):
  r"""Line item information. Next Id: 14

  Messages:
    SystemPropertiesValue: Output only. System provided key value pairs.

  Fields:
    addOnDetails: Output only. Add on information of a line item, if
      applicable.
    customPricing: Output only. The custom pricing information for this line
      item, if applicable.
    entitlementInfo: Output only. Entitlement info associated with this line
      item.
    flavorExternalName: External name of the flavor being purchased.
    offer: Optional. The name of the offer is accepted in either of these
      formats: 'billingAccounts/{billing_account}/offers/{offer}', or
      'projects/{consumer_project}/services/{service}/standardOffers/{offer}'.
    parameters: Optional. User provided parameters.
    pricePlanVersion: The price plan version being purchased.
    productExternalName: External name of the product being purchased.
    quoteExternalName: Output only. External name of the quote this product is
      associated with. Present if the product is part of a Quote.
    subscription: Output only. Information about the subscription created, if
      applicable.
    systemProperties: Output only. System provided key value pairs.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SystemPropertiesValue(_messages.Message):
    r"""Output only. System provided key value pairs.

    Messages:
      AdditionalProperty: An additional property for a SystemPropertiesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        SystemPropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SystemPropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  addOnDetails = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1AddOnDetails', 1)
  customPricing = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1CustomPricing', 2)
  entitlementInfo = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1EntitlementInfo', 3)
  flavorExternalName = _messages.StringField(4)
  offer = _messages.StringField(5)
  parameters = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1Parameter', 6, repeated=True)
  pricePlanVersion = _messages.StringField(7)
  productExternalName = _messages.StringField(8)
  quoteExternalName = _messages.StringField(9)
  subscription = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1Subscription', 10)
  systemProperties = _messages.MessageField('SystemPropertiesValue', 11)


class GoogleCloudCommerceConsumerProcurementV1alpha1ListAccountsResponse(_messages.Message):
  r"""Response message for ConsumerProcurementService.ListAccounts.

  Fields:
    accounts: The list of accounts in this response.
    nextPageToken: The token for fetching the next page.
  """

  accounts = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1Account', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudCommerceConsumerProcurementV1alpha1ListEntitlementsResponse(_messages.Message):
  r"""Response message for ConsumerProcurementService.ListEntitlements.

  Fields:
    entitlements: The list of Entitlements in this response.
    nextPageToken: The token for fetching the next page.
  """

  entitlements = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1Entitlement', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudCommerceConsumerProcurementV1alpha1ListFreeTrialsResponse(_messages.Message):
  r"""Response message for ConsumerProcurementService.ListFreeTrials.

  Fields:
    freeTrials: The list of FreeTrialss in this response.
    nextPageToken: The token for fetching the next page.
  """

  freeTrials = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1FreeTrial', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudCommerceConsumerProcurementV1alpha1ListOrderAllocationsResponse(_messages.Message):
  r"""Response message for ConsumerProcurementService.ListOrderAllocations.

  Fields:
    nextPageToken: The token for fetching the next page.
    orderAllocations: The list of OrderAllocations in this response.
  """

  nextPageToken = _messages.StringField(1)
  orderAllocations = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1OrderAllocation', 2, repeated=True)


class GoogleCloudCommerceConsumerProcurementV1alpha1ListOrdersResponse(_messages.Message):
  r"""Response message for ConsumerProcurementService.ListOrders.

  Fields:
    nextPageToken: The token for fetching the next page.
    orders: The list of orders in this response.
  """

  nextPageToken = _messages.StringField(1)
  orders = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1Order', 2, repeated=True)


class GoogleCloudCommerceConsumerProcurementV1alpha1MigrateOrderRequest(_messages.Message):
  r"""Request message for ConsumerProcurementService.MigrateOrder.

  Fields:
    newParent: Required. Destination billing account where the order will be
      migrated to. This field is of the form: 'billingAccounts/{billing-
      account-id}.
  """

  newParent = _messages.StringField(1)


class GoogleCloudCommerceConsumerProcurementV1alpha1ModifyOrderRequest(_messages.Message):
  r"""Request message for ConsumerProcurementService.ModifyOrder. Next Id: 7

  Fields:
    displayName: Optional. Updated display name of the order, leave as empty
      if you do not want to update current display name.
    etag: The weak etag, which can be optionally populated, of the order that
      this modify request is based on. Validation checking will only happen if
      the invoker supplies this field.
    modifications: Optional. Modifications for an existing Order created by an
      Offer. Required when Offer based Order is being modified.
    modifyProductsOrderRequest: Required. Modifies an existing order for non-
      quote products.
    modifyQuoteOrderRequest: Required. Modifies an existing order for quote.
  """

  displayName = _messages.StringField(1)
  etag = _messages.StringField(2)
  modifications = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1ModifyOrderRequestModification', 3, repeated=True)
  modifyProductsOrderRequest = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1ModifyProductsOrderRequest', 4)
  modifyQuoteOrderRequest = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1ModifyQuoteOrderRequest', 5)


class GoogleCloudCommerceConsumerProcurementV1alpha1ModifyOrderRequestModification(_messages.Message):
  r"""Modifications to make on the order.

  Enums:
    AutoRenewalBehaviorValueValuesEnum: Auto renewal behavior of the
      subscription for the update. Applied when change_type is
      [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_UPDATE]. Follows plan default
      config when this field is not specified.
    ChangeTypeValueValuesEnum: Required. Type of change to make.

  Fields:
    autoRenewalBehavior: Auto renewal behavior of the subscription for the
      update. Applied when change_type is
      [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_UPDATE]. Follows plan default
      config when this field is not specified.
    changeType: Required. Type of change to make.
    lineItemId: ID of the existing line item to make change to. Required when
      change type is [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_UPDATE] or
      [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_CANCEL].
    newLineItemInfo: The line item to update to. Required when change_type is
      [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_CREATE] or
      [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_UPDATE].
  """

  class AutoRenewalBehaviorValueValuesEnum(_messages.Enum):
    r"""Auto renewal behavior of the subscription for the update. Applied when
    change_type is [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_UPDATE]. Follows
    plan default config when this field is not specified.

    Values:
      AUTO_RENEWAL_BEHAVIOR_UNSPECIFIED: If unspecified, the auto renewal
        behavior will follow the default config.
      AUTO_RENEWAL_BEHAVIOR_ENABLE: Auto Renewal will be enabled on
        subscription.
      AUTO_RENEWAL_BEHAVIOR_DISABLE: Auto Renewal will be disabled on
        subscription.
    """
    AUTO_RENEWAL_BEHAVIOR_UNSPECIFIED = 0
    AUTO_RENEWAL_BEHAVIOR_ENABLE = 1
    AUTO_RENEWAL_BEHAVIOR_DISABLE = 2

  class ChangeTypeValueValuesEnum(_messages.Enum):
    r"""Required. Type of change to make.

    Values:
      LINE_ITEM_CHANGE_TYPE_UNSPECIFIED: Sentinel value. Do not use.
      LINE_ITEM_CHANGE_TYPE_CREATE: The change is to create a new line item.
      LINE_ITEM_CHANGE_TYPE_UPDATE: The change is to update an existing line
        item.
      LINE_ITEM_CHANGE_TYPE_CANCEL: The change is to cancel an existing line
        item.
      LINE_ITEM_CHANGE_TYPE_REVERT_CANCELLATION: The change is to revert a
        cancellation.
    """
    LINE_ITEM_CHANGE_TYPE_UNSPECIFIED = 0
    LINE_ITEM_CHANGE_TYPE_CREATE = 1
    LINE_ITEM_CHANGE_TYPE_UPDATE = 2
    LINE_ITEM_CHANGE_TYPE_CANCEL = 3
    LINE_ITEM_CHANGE_TYPE_REVERT_CANCELLATION = 4

  autoRenewalBehavior = _messages.EnumField('AutoRenewalBehaviorValueValuesEnum', 1)
  changeType = _messages.EnumField('ChangeTypeValueValuesEnum', 2)
  lineItemId = _messages.StringField(3)
  newLineItemInfo = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1LineItemInfo', 4)


class GoogleCloudCommerceConsumerProcurementV1alpha1ModifyProductsOrderRequest(_messages.Message):
  r"""Request message to update an order for non-quote products.

  Fields:
    modifications: A GoogleCloudCommerceConsumerProcurementV1alpha1ModifyProdu
      ctsOrderRequestModification attribute.
  """

  modifications = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1ModifyProductsOrderRequestModification', 1, repeated=True)


class GoogleCloudCommerceConsumerProcurementV1alpha1ModifyProductsOrderRequestModification(_messages.Message):
  r"""Modifications to make on the order.

  Enums:
    AutoRenewalBehaviorValueValuesEnum: Auto renewal behavior of the
      subscription for the update. Applied when change_type is
      [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_UPDATE].
    ChangeTypeValueValuesEnum: Required. Type of change to make.

  Fields:
    autoRenewalBehavior: Auto renewal behavior of the subscription for the
      update. Applied when change_type is
      [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_UPDATE].
    changeType: Required. Type of change to make.
    lineItemId: ID of the existing line item to make change to. Required when
      change type is [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_UPDATE] or
      [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_CANCEL].
    newLineItemInfo: The line item to update to. Required when change_type is
      [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_CREATE] or
      [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_UPDATE].
  """

  class AutoRenewalBehaviorValueValuesEnum(_messages.Enum):
    r"""Auto renewal behavior of the subscription for the update. Applied when
    change_type is [LineItemChangeType.LINE_ITEM_CHANGE_TYPE_UPDATE].

    Values:
      AUTO_RENEWAL_BEHAVIOR_UNSPECIFIED: If unspecified, the auto renewal
        behavior will follow the default config.
      AUTO_RENEWAL_BEHAVIOR_ENABLE: Auto Renewal will be enabled on
        subscription.
      AUTO_RENEWAL_BEHAVIOR_DISABLE: Auto Renewal will be disabled on
        subscription.
    """
    AUTO_RENEWAL_BEHAVIOR_UNSPECIFIED = 0
    AUTO_RENEWAL_BEHAVIOR_ENABLE = 1
    AUTO_RENEWAL_BEHAVIOR_DISABLE = 2

  class ChangeTypeValueValuesEnum(_messages.Enum):
    r"""Required. Type of change to make.

    Values:
      LINE_ITEM_CHANGE_TYPE_UNSPECIFIED: Sentinel value. Do not use.
      LINE_ITEM_CHANGE_TYPE_CREATE: The change is to create a new line item.
      LINE_ITEM_CHANGE_TYPE_UPDATE: The change is to update an existing line
        item.
      LINE_ITEM_CHANGE_TYPE_CANCEL: The change is to cancel an existing line
        item.
      LINE_ITEM_CHANGE_TYPE_REVERT_CANCELLATION: The change is to revert a
        cancellation.
    """
    LINE_ITEM_CHANGE_TYPE_UNSPECIFIED = 0
    LINE_ITEM_CHANGE_TYPE_CREATE = 1
    LINE_ITEM_CHANGE_TYPE_UPDATE = 2
    LINE_ITEM_CHANGE_TYPE_CANCEL = 3
    LINE_ITEM_CHANGE_TYPE_REVERT_CANCELLATION = 4

  autoRenewalBehavior = _messages.EnumField('AutoRenewalBehaviorValueValuesEnum', 1)
  changeType = _messages.EnumField('ChangeTypeValueValuesEnum', 2)
  lineItemId = _messages.StringField(3)
  newLineItemInfo = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1LineItemInfo', 4)


class GoogleCloudCommerceConsumerProcurementV1alpha1ModifyQuoteOrderRequest(_messages.Message):
  r"""Request message for ConsumerProcurementService.ModifyOrder.

  Enums:
    AutoRenewalBehaviorValueValuesEnum: Auto renewal behavior of the
      subscription for the update. Applied when change_type is
      [QuoteChangeType.QUOTE_CHANGE_TYPE_UPDATE].
    ChangeTypeValueValuesEnum: Required. Type of change to make.

  Fields:
    autoRenewalBehavior: Auto renewal behavior of the subscription for the
      update. Applied when change_type is
      [QuoteChangeType.QUOTE_CHANGE_TYPE_UPDATE].
    changeType: Required. Type of change to make.
    newQuoteExternalName: External name of the new quote to update to.
      Required when change_type is [QuoteChangeType.QUOTE_CHANGE_TYPE_UPDATE].
  """

  class AutoRenewalBehaviorValueValuesEnum(_messages.Enum):
    r"""Auto renewal behavior of the subscription for the update. Applied when
    change_type is [QuoteChangeType.QUOTE_CHANGE_TYPE_UPDATE].

    Values:
      AUTO_RENEWAL_BEHAVIOR_UNSPECIFIED: If unspecified, the auto renewal
        behavior will follow the default config.
      AUTO_RENEWAL_BEHAVIOR_ENABLE: Auto Renewal will be enabled on
        subscription.
      AUTO_RENEWAL_BEHAVIOR_DISABLE: Auto Renewal will be disabled on
        subscription.
    """
    AUTO_RENEWAL_BEHAVIOR_UNSPECIFIED = 0
    AUTO_RENEWAL_BEHAVIOR_ENABLE = 1
    AUTO_RENEWAL_BEHAVIOR_DISABLE = 2

  class ChangeTypeValueValuesEnum(_messages.Enum):
    r"""Required. Type of change to make.

    Values:
      QUOTE_CHANGE_TYPE_UNSPECIFIED: Sentinel value. Do not use.
      QUOTE_CHANGE_TYPE_UPDATE: The change is to update an existing order for
        quote.
      QUOTE_CHANGE_TYPE_CANCEL: The change is to cancel an existing order for
        quote.
      QUOTE_CHANGE_TYPE_REVERT_CANCELLATION: The change is to revert a
        cancellation for an order for quote.
    """
    QUOTE_CHANGE_TYPE_UNSPECIFIED = 0
    QUOTE_CHANGE_TYPE_UPDATE = 1
    QUOTE_CHANGE_TYPE_CANCEL = 2
    QUOTE_CHANGE_TYPE_REVERT_CANCELLATION = 3

  autoRenewalBehavior = _messages.EnumField('AutoRenewalBehaviorValueValuesEnum', 1)
  changeType = _messages.EnumField('ChangeTypeValueValuesEnum', 2)
  newQuoteExternalName = _messages.StringField(3)


class GoogleCloudCommerceConsumerProcurementV1alpha1Order(_messages.Message):
  r"""Order represents a purchase made by a customer on the Cloud Commerce
  Platform. Creation of an order programs both the Google backend systems as
  well as external service provider's systems (if needed) to allow use of
  purchased products and to ensure the appropriate billing events occur. An
  Order can be made against one Product with multiple add-ons (optional) or
  one Quote which could potentially references multiple products. Customers
  typically choose a price plan for each Product purchased when creating an
  order and can change their plan later, if the product allows. Customers can
  also cancel their purchases through the Order resource once they no longer
  need it. The metadata that is needed during an Order's creation is hosted on
  the Cloud Commerce Inventory system, as part of a Product's definition. Next
  Id: 13

  Enums:
    OrderStateValueValuesEnum: Output only. The state of the order.

  Fields:
    account: The resource name of the account that this order is based on.
      Required if the creation of any products in the order requires an
      account to be present.
    cancelledLineItems: Output only. Line items that were cancelled.
    createTime: Output only. The creation timestamp.
    displayName: Required. The user-specified name of the order. Must be
      unique within a billing account.
    etag: The weak etag of the order.
    lineItems: Output only. The items being purchased.
    name: Output only. The resource name of the order. Order names have the
      form `billingAccounts/{billing-account-id}/orders/{order_id}`.
    orderState: Output only. The state of the order.
    provider: Provider of the products being purchased. Provider has the
      format of `providers/{provider_id}`.
    stateReason: Output only. An explanation for the order's state. Mainly
      used in the case of `OrderState.ORDER_STATE_CANCELLED` states to explain
      why the order is cancelled.
    updateTime: Output only. The last update timestamp.
  """

  class OrderStateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the order.

    Values:
      ORDER_STATE_UNSPECIFIED: Sentinel value. Do not use.
      ORDER_STATE_ACTIVE: The order is active.
      ORDER_STATE_CANCELLED: The order is cancelled.
      ORDER_STATE_PENDING_CANCELLATION: The order is being cancelled either by
        the user or by the system. The order stays in this state, if any
        product in the order allows use of the underlying resource until the
        end of the current billing cycle. Once the billing cycle completes,
        the resource will transition to OrderState.ORDER_STATE_CANCELLED
        state.
    """
    ORDER_STATE_UNSPECIFIED = 0
    ORDER_STATE_ACTIVE = 1
    ORDER_STATE_CANCELLED = 2
    ORDER_STATE_PENDING_CANCELLATION = 3

  account = _messages.StringField(1)
  cancelledLineItems = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1LineItem', 2, repeated=True)
  createTime = _messages.StringField(3)
  displayName = _messages.StringField(4)
  etag = _messages.StringField(5)
  lineItems = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1LineItem', 6, repeated=True)
  name = _messages.StringField(7)
  orderState = _messages.EnumField('OrderStateValueValuesEnum', 8)
  provider = _messages.StringField(9)
  stateReason = _messages.StringField(10)
  updateTime = _messages.StringField(11)


class GoogleCloudCommerceConsumerProcurementV1alpha1OrderAllocation(_messages.Message):
  r"""OrderAllocation represents the allocation of resources within a specific
  order to a set of targets (projects). Next Id: 8

  Enums:
    StateValueValuesEnum: Output only. The state of the allocation.

  Fields:
    allocationEntry: Required. The currently effective allocation entry.
    createTime: Output only. The time when the resource was created.
    displayName: Optional. The user-specified name of the allocation. Must be
      unique within an Order if specified.
    name: Output only. The resource name of the allocation. This field is of
      the form: `billingAccounts/{billing-account-id}/orders/{order-
      id}/orderAllocations/{order-allocation-id}`.
    pendingAllocationEntry: Output only. The upcoming allocation entry.
    state: Output only. The state of the allocation.
    updateTime: Output only. The time when the resource was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the allocation.

    Values:
      STATE_UNSPECIFIED: Sentinel value. Do not use.
      STATE_PENDING_ACTIVATION: The allocation is pending activation.
      STATE_ACTIVE: The allocation is active.
      STATE_PENDING_DELETION: The allocation is pending deletion.
      STATE_CANCELLED: The allocation is cancelled. This can be caused by
        failure in creating the allocation or the associated Order being
        cancelled.
    """
    STATE_UNSPECIFIED = 0
    STATE_PENDING_ACTIVATION = 1
    STATE_ACTIVE = 2
    STATE_PENDING_DELETION = 3
    STATE_CANCELLED = 4

  allocationEntry = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1OrderAllocationAllocationEntry', 1)
  createTime = _messages.StringField(2)
  displayName = _messages.StringField(3)
  name = _messages.StringField(4)
  pendingAllocationEntry = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1OrderAllocationAllocationEntry', 5)
  state = _messages.EnumField('StateValueValuesEnum', 6)
  updateTime = _messages.StringField(7)


class GoogleCloudCommerceConsumerProcurementV1alpha1OrderAllocationAllocationEntry(_messages.Message):
  r"""An allocation entry representing what resource is being allocated to
  which targets.

  Fields:
    doubleResourceValue: Represents a double value.
    int64ResourceValue: Represents an int64 value.
    stringResourceValue: Represents a string value.
    targets: Required. The targets of the allocation, only projects are
      allowed at the moment.
  """

  doubleResourceValue = _messages.FloatField(1)
  int64ResourceValue = _messages.IntegerField(2)
  stringResourceValue = _messages.StringField(3)
  targets = _messages.StringField(4, repeated=True)


class GoogleCloudCommerceConsumerProcurementV1alpha1Parameter(_messages.Message):
  r"""LINT.IfChange User provided Parameters.

  Fields:
    name: Name of the parameter.
    value: Value of parameter.
  """

  name = _messages.StringField(1)
  value = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1ParameterValue', 2)


class GoogleCloudCommerceConsumerProcurementV1alpha1ParameterValue(_messages.Message):
  r"""A GoogleCloudCommerceConsumerProcurementV1alpha1ParameterValue object.

  Fields:
    doubleValue: Represents a double value.
    int64Value: Represents an int64 value.
    stringValue: Represents a string value.
  """

  doubleValue = _messages.FloatField(1)
  int64Value = _messages.IntegerField(2)
  stringValue = _messages.StringField(3)


class GoogleCloudCommerceConsumerProcurementV1alpha1PlaceOrderRequest(_messages.Message):
  r"""Request message for ConsumerProcurementService.PlaceOrder. Next Id: 11

  Enums:
    AutoRenewalBehaviorValueValuesEnum: Optional. Auto renewal behavior of the
      subscription associated with the order.

  Fields:
    account: The resource name of the account that this order is based on. If
      this field is not specified and the creation of any products in the
      order requires an account, system will look for existing account and
      auto create one if there is no existing one.
    autoRenewalBehavior: Optional. Auto renewal behavior of the subscription
      associated with the order.
    displayName: Required. The user-specified name of the order being placed.
      Must be unique within a billing account.
    lineItemInfo: Optional. Places order for offer. Required when offer based
      order is being placed. Setting `line_item_info` will take precedence to
      place offer order if request is also set.
    placeProductsOrderRequest: Optional. Places order for non-quote products.
    placeQuoteOrderRequest: Optional. Places order for quote.
    provider: Required. Provider of the items being purchased. Provider has
      the format of `providers/{provider_id}`.
    requestId: Optional. A unique identifier for this request. The server will
      ignore subsequent requests that provide a duplicate request ID for at
      least 120 minutes after the first request. The request ID must be a
      valid [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier
      #Format).
  """

  class AutoRenewalBehaviorValueValuesEnum(_messages.Enum):
    r"""Optional. Auto renewal behavior of the subscription associated with
    the order.

    Values:
      AUTO_RENEWAL_BEHAVIOR_UNSPECIFIED: If unspecified, the auto renewal
        behavior will follow the default config.
      AUTO_RENEWAL_BEHAVIOR_ENABLE: Auto Renewal will be enabled on
        subscription.
      AUTO_RENEWAL_BEHAVIOR_DISABLE: Auto Renewal will be disabled on
        subscription.
    """
    AUTO_RENEWAL_BEHAVIOR_UNSPECIFIED = 0
    AUTO_RENEWAL_BEHAVIOR_ENABLE = 1
    AUTO_RENEWAL_BEHAVIOR_DISABLE = 2

  account = _messages.StringField(1)
  autoRenewalBehavior = _messages.EnumField('AutoRenewalBehaviorValueValuesEnum', 2)
  displayName = _messages.StringField(3)
  lineItemInfo = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1LineItemInfo', 4, repeated=True)
  placeProductsOrderRequest = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1PlaceProductsOrderRequest', 5)
  placeQuoteOrderRequest = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1PlaceQuoteOrderRequest', 6)
  provider = _messages.StringField(7)
  requestId = _messages.StringField(8)


class GoogleCloudCommerceConsumerProcurementV1alpha1PlaceProductsOrderRequest(_messages.Message):
  r"""Request message to place an order for non-quote products.

  Fields:
    lineItemInfo: Required. Items to purchase within an order.
  """

  lineItemInfo = _messages.MessageField('GoogleCloudCommerceConsumerProcurementV1alpha1LineItemInfo', 1, repeated=True)


class GoogleCloudCommerceConsumerProcurementV1alpha1PlaceQuoteOrderRequest(_messages.Message):
  r"""Request message to place an order for a quote.

  Fields:
    quoteExternalName: Required. External name of the quote to purchase.
  """

  quoteExternalName = _messages.StringField(1)


class GoogleCloudCommerceConsumerProcurementV1alpha1Subscription(_messages.Message):
  r"""Subscription information.

  Fields:
    autoRenewalEnabled: Whether auto renewal is enabled by user choice on
      current subscription. This field indicates order/subscription status
      after pending plan change is cancelled or rejected.
    endTime: The timestamp when the subscription ends, if applicable.
  """

  autoRenewalEnabled = _messages.BooleanField(1)
  endTime = _messages.StringField(2)


class GoogleLongrunningCancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleProtobufEmpty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class GoogleTypeMoney(_messages.Message):
  r"""Represents an amount of money with its currency type.

  Fields:
    currencyCode: The 3-letter currency code defined in ISO 4217.
    nanos: Number of nano (10^-9) units of the amount. The value must be
      between -999,999,999 and +999,999,999 inclusive. If `units` is positive,
      `nanos` must be positive or zero. If `units` is zero, `nanos` can be
      positive, zero, or negative. If `units` is negative, `nanos` must be
      negative or zero. For example $-1.75 is represented as `units`=-1 and
      `nanos`=-750,000,000.
    units: The whole units of the amount. For example if `currencyCode` is
      `"USD"`, then 1 unit is one US dollar.
  """

  currencyCode = _messages.StringField(1)
  nanos = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  units = _messages.IntegerField(3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
