"""Generated client library for apigee version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.apigee.v1 import apigee_v1_messages as messages


class ApigeeV1(base_api.BaseApiClient):
  """Generated client library for service apigee version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://apigee.googleapis.com/'
  MTLS_BASE_URL = 'https://apigee.mtls.googleapis.com/'

  _PACKAGE = 'apigee'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'ApigeeV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new apigee handle."""
    url = url or self.BASE_URL
    super(ApigeeV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.hybrid_issuers = self.HybridIssuersService(self)
    self.hybrid = self.HybridService(self)
    self.organizations_apiproducts_attributes = self.OrganizationsApiproductsAttributesService(self)
    self.organizations_apiproducts = self.OrganizationsApiproductsService(self)
    self.organizations_apis_deployments = self.OrganizationsApisDeploymentsService(self)
    self.organizations_apis_keyvaluemaps = self.OrganizationsApisKeyvaluemapsService(self)
    self.organizations_apis_revisions_deployments = self.OrganizationsApisRevisionsDeploymentsService(self)
    self.organizations_apis_revisions = self.OrganizationsApisRevisionsService(self)
    self.organizations_apis = self.OrganizationsApisService(self)
    self.organizations_apps = self.OrganizationsAppsService(self)
    self.organizations_deployments = self.OrganizationsDeploymentsService(self)
    self.organizations_developers_apps_attributes = self.OrganizationsDevelopersAppsAttributesService(self)
    self.organizations_developers_apps_keys_apiproducts = self.OrganizationsDevelopersAppsKeysApiproductsService(self)
    self.organizations_developers_apps_keys_create = self.OrganizationsDevelopersAppsKeysCreateService(self)
    self.organizations_developers_apps_keys = self.OrganizationsDevelopersAppsKeysService(self)
    self.organizations_developers_apps = self.OrganizationsDevelopersAppsService(self)
    self.organizations_developers_attributes = self.OrganizationsDevelopersAttributesService(self)
    self.organizations_developers = self.OrganizationsDevelopersService(self)
    self.organizations_envgroups_attachments = self.OrganizationsEnvgroupsAttachmentsService(self)
    self.organizations_envgroups = self.OrganizationsEnvgroupsService(self)
    self.organizations_environments_analytics_admin = self.OrganizationsEnvironmentsAnalyticsAdminService(self)
    self.organizations_environments_analytics = self.OrganizationsEnvironmentsAnalyticsService(self)
    self.organizations_environments_apis_deployments = self.OrganizationsEnvironmentsApisDeploymentsService(self)
    self.organizations_environments_apis_revisions_debugsessions_data = self.OrganizationsEnvironmentsApisRevisionsDebugsessionsDataService(self)
    self.organizations_environments_apis_revisions_debugsessions = self.OrganizationsEnvironmentsApisRevisionsDebugsessionsService(self)
    self.organizations_environments_apis_revisions_deployments = self.OrganizationsEnvironmentsApisRevisionsDeploymentsService(self)
    self.organizations_environments_apis_revisions = self.OrganizationsEnvironmentsApisRevisionsService(self)
    self.organizations_environments_apis = self.OrganizationsEnvironmentsApisService(self)
    self.organizations_environments_caches = self.OrganizationsEnvironmentsCachesService(self)
    self.organizations_environments_deployments = self.OrganizationsEnvironmentsDeploymentsService(self)
    self.organizations_environments_flowhooks = self.OrganizationsEnvironmentsFlowhooksService(self)
    self.organizations_environments_keystores_aliases = self.OrganizationsEnvironmentsKeystoresAliasesService(self)
    self.organizations_environments_keystores = self.OrganizationsEnvironmentsKeystoresService(self)
    self.organizations_environments_keyvaluemaps = self.OrganizationsEnvironmentsKeyvaluemapsService(self)
    self.organizations_environments_optimizedStats = self.OrganizationsEnvironmentsOptimizedStatsService(self)
    self.organizations_environments_queries = self.OrganizationsEnvironmentsQueriesService(self)
    self.organizations_environments_references = self.OrganizationsEnvironmentsReferencesService(self)
    self.organizations_environments_resourcefiles = self.OrganizationsEnvironmentsResourcefilesService(self)
    self.organizations_environments_sharedflows_deployments = self.OrganizationsEnvironmentsSharedflowsDeploymentsService(self)
    self.organizations_environments_sharedflows_revisions = self.OrganizationsEnvironmentsSharedflowsRevisionsService(self)
    self.organizations_environments_sharedflows = self.OrganizationsEnvironmentsSharedflowsService(self)
    self.organizations_environments_stats = self.OrganizationsEnvironmentsStatsService(self)
    self.organizations_environments_targetservers = self.OrganizationsEnvironmentsTargetserversService(self)
    self.organizations_environments = self.OrganizationsEnvironmentsService(self)
    self.organizations_instances_attachments = self.OrganizationsInstancesAttachmentsService(self)
    self.organizations_instances = self.OrganizationsInstancesService(self)
    self.organizations_keyvaluemaps = self.OrganizationsKeyvaluemapsService(self)
    self.organizations_operations = self.OrganizationsOperationsService(self)
    self.organizations_reports = self.OrganizationsReportsService(self)
    self.organizations_sharedflows_deployments = self.OrganizationsSharedflowsDeploymentsService(self)
    self.organizations_sharedflows_revisions_deployments = self.OrganizationsSharedflowsRevisionsDeploymentsService(self)
    self.organizations_sharedflows_revisions = self.OrganizationsSharedflowsRevisionsService(self)
    self.organizations_sharedflows = self.OrganizationsSharedflowsService(self)
    self.organizations = self.OrganizationsService(self)

  class HybridIssuersService(base_api.BaseApiService):
    """Service class for the hybrid_issuers resource."""

    _NAME = 'hybrid_issuers'

    def __init__(self, client):
      super(ApigeeV1.HybridIssuersService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists hybrid services and its trusted issuers service account ids.
This api is authenticated and unauthorized(allow all the users) and used by
runtime authn-authz service to query control plane's issuer service account
ids.

      Args:
        request: (ApigeeHybridIssuersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListHybridIssuersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/hybrid/issuers',
        http_method='GET',
        method_id='apigee.hybrid.issuers.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeHybridIssuersListRequest',
        response_type_name='GoogleCloudApigeeV1ListHybridIssuersResponse',
        supports_download=False,
    )

  class HybridService(base_api.BaseApiService):
    """Service class for the hybrid resource."""

    _NAME = 'hybrid'

    def __init__(self, client):
      super(ApigeeV1.HybridService, self).__init__(client)
      self._upload_configs = {
          }

  class OrganizationsApiproductsAttributesService(base_api.BaseApiService):
    """Service class for the organizations_apiproducts_attributes resource."""

    _NAME = 'organizations_apiproducts_attributes'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsApiproductsAttributesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes an API product attribute.

      Args:
        request: (ApigeeOrganizationsApiproductsAttributesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Attribute) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apiproducts/{apiproductsId}/attributes/{attributesId}',
        http_method='DELETE',
        method_id='apigee.organizations.apiproducts.attributes.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsApiproductsAttributesDeleteRequest',
        response_type_name='GoogleCloudApigeeV1Attribute',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the value of an API product attribute.

      Args:
        request: (ApigeeOrganizationsApiproductsAttributesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Attribute) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apiproducts/{apiproductsId}/attributes/{attributesId}',
        http_method='GET',
        method_id='apigee.organizations.apiproducts.attributes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsApiproductsAttributesGetRequest',
        response_type_name='GoogleCloudApigeeV1Attribute',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns a list of all API product attributes.

      Args:
        request: (ApigeeOrganizationsApiproductsAttributesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Attributes) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apiproducts/{apiproductsId}/attributes',
        http_method='GET',
        method_id='apigee.organizations.apiproducts.attributes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/attributes',
        request_field='',
        request_type_name='ApigeeOrganizationsApiproductsAttributesListRequest',
        response_type_name='GoogleCloudApigeeV1Attributes',
        supports_download=False,
    )

    def UpdateApiProductAttribute(self, request, global_params=None):
      r"""Updates the value of an API product attribute. Limitations are:.

OAuth access tokens and Key Management Service (KMS) entities (apps,
developers, and API products) are cached for 180 seconds (current default).
Any custom attributes associated with entities also get cached for at least
180 seconds after entity is accessed during runtime.
In this case, the `ExpiresIn` element on the OAuthV2 policy won't be able
to expire an access token in less than 180 seconds.

      Args:
        request: (GoogleCloudApigeeV1Attribute) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Attribute) The response message.
      """
      config = self.GetMethodConfig('UpdateApiProductAttribute')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateApiProductAttribute.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apiproducts/{apiproductsId}/attributes/{attributesId}',
        http_method='POST',
        method_id='apigee.organizations.apiproducts.attributes.updateApiProductAttribute',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='<request>',
        request_type_name='GoogleCloudApigeeV1Attribute',
        response_type_name='GoogleCloudApigeeV1Attribute',
        supports_download=False,
    )

  class OrganizationsApiproductsService(base_api.BaseApiService):
    """Service class for the organizations_apiproducts resource."""

    _NAME = 'organizations_apiproducts'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsApiproductsService, self).__init__(client)
      self._upload_configs = {
          }

    def Attributes(self, request, global_params=None):
      r"""Updates or creates API product attributes. This API **replaces** the.
current list of attributes with the attributes specified in the request
body. In this way, you can update existing attributes, add new attributes,
or delete existing attributes by omitting them from the request body.

OAuth access tokens and Key Management Service (KMS) entities (apps,
developers, and API products) are cached for 180 seconds (current default).
Any custom attributes associated with entities also get cached for at least
180 seconds after entity is accessed during runtime.
In this case, the `ExpiresIn` element on the OAuthV2 policy won't be able
to expire an access token in less than 180 seconds.

      Args:
        request: (ApigeeOrganizationsApiproductsAttributesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Attributes) The response message.
      """
      config = self.GetMethodConfig('Attributes')
      return self._RunMethod(
          config, request, global_params=global_params)

    Attributes.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apiproducts/{apiproductsId}/attributes',
        http_method='POST',
        method_id='apigee.organizations.apiproducts.attributes',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}/attributes',
        request_field='googleCloudApigeeV1Attributes',
        request_type_name='ApigeeOrganizationsApiproductsAttributesRequest',
        response_type_name='GoogleCloudApigeeV1Attributes',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates an API product in an organization.
You create API products after
you have proxied backend services using API proxies.
An API product is a
collection of API resources combined with quota settings and metadata that
you can use to deliver customized and productized API bundles to your
developer community. This metadata can include:

- Scope
- Environments
- API proxies
- Extensible profile

API products enable you repackage APIs
on-the-fly, without having to do any additional coding or configuration.
Apigee recommends that you start with a simple API product including only
required elements. You then provision credentials to apps to enable them to
start testing your APIs.

After you have authentication and authorization
working against a simple API product, you can iterate to create finer
grained API products, defining different sets of API resources for each API
product.

<aside class="warning"><strong>WARNING:</strong>

- If you don't specify an API proxy in the request body, <em>any</em> app
associated with the product can make calls to <em>any</em> API in your
entire organization.
- If you don't specify an environment in the request body, the product
allows access to all environments.

</aside>

For more information, see {{what_api_product}}

      Args:
        request: (ApigeeOrganizationsApiproductsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ApiProduct) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apiproducts',
        http_method='POST',
        method_id='apigee.organizations.apiproducts.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/apiproducts',
        request_field='googleCloudApigeeV1ApiProduct',
        request_type_name='ApigeeOrganizationsApiproductsCreateRequest',
        response_type_name='GoogleCloudApigeeV1ApiProduct',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an API product from an organization.

Deleting an API product
causes app requests to the resource URIs defined in the API product to
fail.

Ensure that you create a new API product to serve existing apps, unless
your intention is to disable access to the resources defined in the API
product.

The API product name required in the request URL is the internal name of
the product, not the display name. While they may be the same, it depends
on whether the API product was created via the UI or the API. View the list
of API products to verify the internal name.

      Args:
        request: (ApigeeOrganizationsApiproductsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ApiProduct) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apiproducts/{apiproductsId}',
        http_method='DELETE',
        method_id='apigee.organizations.apiproducts.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsApiproductsDeleteRequest',
        response_type_name='GoogleCloudApigeeV1ApiProduct',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets configuration details for an API product.

The API product name required in the request URL is the internal name of
the product, not the display name. While they may be the same, it depends
on whether the API product was created via the UI or the API. View the list
of API products to verify the internal name.

      Args:
        request: (ApigeeOrganizationsApiproductsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ApiProduct) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apiproducts/{apiproductsId}',
        http_method='GET',
        method_id='apigee.organizations.apiproducts.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsApiproductsGetRequest',
        response_type_name='GoogleCloudApigeeV1ApiProduct',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all API product names for an organization.
Filter the list by passing an `attributename` and `attibutevalue`.

The limit on the number of API products returned by the API is 1000. You
can paginate the list of API products returned using the `startKey` and
`count` query parameters.

      Args:
        request: (ApigeeOrganizationsApiproductsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListApiProductsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apiproducts',
        http_method='GET',
        method_id='apigee.organizations.apiproducts.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['attributename', 'attributevalue', 'count', 'expand', 'startKey'],
        relative_path='v1/{+parent}/apiproducts',
        request_field='',
        request_type_name='ApigeeOrganizationsApiproductsListRequest',
        response_type_name='GoogleCloudApigeeV1ListApiProductsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an existing API product. You must include all required values,.
whether or not you are updating them, as well as any optional values that
you are updating.

The API product name required in the request URL is the
internal name of the product, not the Display Name. While they may be the
same, it depends on whether the API product was created via UI or API. View
the list of API products to identify their internal names.

      Args:
        request: (GoogleCloudApigeeV1ApiProduct) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ApiProduct) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apiproducts/{apiproductsId}',
        http_method='PUT',
        method_id='apigee.organizations.apiproducts.update',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='<request>',
        request_type_name='GoogleCloudApigeeV1ApiProduct',
        response_type_name='GoogleCloudApigeeV1ApiProduct',
        supports_download=False,
    )

  class OrganizationsApisDeploymentsService(base_api.BaseApiService):
    """Service class for the organizations_apis_deployments resource."""

    _NAME = 'organizations_apis_deployments'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsApisDeploymentsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists all deployments of an API proxy.

      Args:
        request: (ApigeeOrganizationsApisDeploymentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListDeploymentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apis/{apisId}/deployments',
        http_method='GET',
        method_id='apigee.organizations.apis.deployments.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/deployments',
        request_field='',
        request_type_name='ApigeeOrganizationsApisDeploymentsListRequest',
        response_type_name='GoogleCloudApigeeV1ListDeploymentsResponse',
        supports_download=False,
    )

  class OrganizationsApisKeyvaluemapsService(base_api.BaseApiService):
    """Service class for the organizations_apis_keyvaluemaps resource."""

    _NAME = 'organizations_apis_keyvaluemaps'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsApisKeyvaluemapsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a key value map in an api proxy.

      Args:
        request: (ApigeeOrganizationsApisKeyvaluemapsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1KeyValueMap) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apis/{apisId}/keyvaluemaps',
        http_method='POST',
        method_id='apigee.organizations.apis.keyvaluemaps.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/keyvaluemaps',
        request_field='googleCloudApigeeV1KeyValueMap',
        request_type_name='ApigeeOrganizationsApisKeyvaluemapsCreateRequest',
        response_type_name='GoogleCloudApigeeV1KeyValueMap',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Delete a key value map in an api proxy.

      Args:
        request: (ApigeeOrganizationsApisKeyvaluemapsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1KeyValueMap) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apis/{apisId}/keyvaluemaps/{keyvaluemapsId}',
        http_method='DELETE',
        method_id='apigee.organizations.apis.keyvaluemaps.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsApisKeyvaluemapsDeleteRequest',
        response_type_name='GoogleCloudApigeeV1KeyValueMap',
        supports_download=False,
    )

  class OrganizationsApisRevisionsDeploymentsService(base_api.BaseApiService):
    """Service class for the organizations_apis_revisions_deployments resource."""

    _NAME = 'organizations_apis_revisions_deployments'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsApisRevisionsDeploymentsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists all deployments of an API proxy revision.

      Args:
        request: (ApigeeOrganizationsApisRevisionsDeploymentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListDeploymentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apis/{apisId}/revisions/{revisionsId}/deployments',
        http_method='GET',
        method_id='apigee.organizations.apis.revisions.deployments.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/deployments',
        request_field='',
        request_type_name='ApigeeOrganizationsApisRevisionsDeploymentsListRequest',
        response_type_name='GoogleCloudApigeeV1ListDeploymentsResponse',
        supports_download=False,
    )

  class OrganizationsApisRevisionsService(base_api.BaseApiService):
    """Service class for the organizations_apis_revisions resource."""

    _NAME = 'organizations_apis_revisions'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsApisRevisionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes an API proxy revision and all policies, resources, endpoints,.
and revisions associated with it. The API proxy revision must be undeployed
before you can delete it.

      Args:
        request: (ApigeeOrganizationsApisRevisionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ApiProxyRevision) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apis/{apisId}/revisions/{revisionsId}',
        http_method='DELETE',
        method_id='apigee.organizations.apis.revisions.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsApisRevisionsDeleteRequest',
        response_type_name='GoogleCloudApigeeV1ApiProxyRevision',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an API proxy revision.

To download the API proxy configuration bundle for the specified revision
as a zip file, do the following:

 * Set the `format` query parameter to `bundle`.
 * Set the `Accept` header to `application/zip`.

If you are using curl, specify `-o filename.zip` to save the output to a
file; otherwise, it displays to `stdout`. Then, develop the API proxy
configuration locally and upload the updated API proxy configuration
revision, as described in
[updateApiProxyRevision](updateApiProxyRevision).

      Args:
        request: (ApigeeOrganizationsApisRevisionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleApiHttpBody) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apis/{apisId}/revisions/{revisionsId}',
        http_method='GET',
        method_id='apigee.organizations.apis.revisions.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['format'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsApisRevisionsGetRequest',
        response_type_name='GoogleApiHttpBody',
        supports_download=False,
    )

    def UpdateApiProxyRevision(self, request, global_params=None):
      r"""Updates an existing API proxy revision by uploading the API proxy.
configuration bundle as a zip file from your local machine.

You can update only API proxy revisions
that have never been deployed. After deployment, an API proxy revision
becomes immutable, even if it is undeployed.

Set the `Content-Type` header to either
`multipart/form-data` or `application/octet-stream`.

      Args:
        request: (ApigeeOrganizationsApisRevisionsUpdateApiProxyRevisionRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ApiProxyRevision) The response message.
      """
      config = self.GetMethodConfig('UpdateApiProxyRevision')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateApiProxyRevision.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apis/{apisId}/revisions/{revisionsId}',
        http_method='POST',
        method_id='apigee.organizations.apis.revisions.updateApiProxyRevision',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['validate'],
        relative_path='v1/{+name}',
        request_field='googleApiHttpBody',
        request_type_name='ApigeeOrganizationsApisRevisionsUpdateApiProxyRevisionRequest',
        response_type_name='GoogleCloudApigeeV1ApiProxyRevision',
        supports_download=False,
    )

  class OrganizationsApisService(base_api.BaseApiService):
    """Service class for the organizations_apis resource."""

    _NAME = 'organizations_apis'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsApisService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an API proxy.
The API proxy created will not be accessible at runtime until it is
deployed to an environment.

Create a new API proxy by setting the `name` query parameter to the
name of the API proxy.

Import an API proxy configuration bundle stored in zip format
on your local machine to your organization by doing the following:

* Set the `name` query parameter to the name of the API proxy.
* Set the `action` query parameter to `import`.
* Set the `Content-Type` header to `multipart/form-data`.
* Pass as a file the name of API proxy
  configuration bundle stored in zip format on your local machine using
  the `file` form field.

**Note**: To validate the API proxy configuration bundle only
  without importing it, set the `action` query
  parameter to `validate`.

When importing an API proxy configuration bundle, if the API proxy
does not exist, it will be created.
If the API proxy exists, then a new revision is created. Invalid API
proxy configurations are rejected, and a list of validation errors is
returned to the client.

      Args:
        request: (ApigeeOrganizationsApisCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ApiProxyRevision) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apis',
        http_method='POST',
        method_id='apigee.organizations.apis.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['action', 'name', 'validate'],
        relative_path='v1/{+parent}/apis',
        request_field='googleApiHttpBody',
        request_type_name='ApigeeOrganizationsApisCreateRequest',
        response_type_name='GoogleCloudApigeeV1ApiProxyRevision',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an API proxy and all associated endpoints, policies, resources, and.
revisions. The API proxy must be undeployed before you can delete it.

      Args:
        request: (ApigeeOrganizationsApisDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ApiProxy) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apis/{apisId}',
        http_method='DELETE',
        method_id='apigee.organizations.apis.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsApisDeleteRequest',
        response_type_name='GoogleCloudApigeeV1ApiProxy',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an API proxy including a list of existing revisions.

      Args:
        request: (ApigeeOrganizationsApisGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ApiProxy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apis/{apisId}',
        http_method='GET',
        method_id='apigee.organizations.apis.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsApisGetRequest',
        response_type_name='GoogleCloudApigeeV1ApiProxy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the names of all API proxies in an organization. The names returned.
correspond to the names defined in the configuration files for each API
proxy.

      Args:
        request: (ApigeeOrganizationsApisListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListApiProxiesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apis',
        http_method='GET',
        method_id='apigee.organizations.apis.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['includeMetaData', 'includeRevisions'],
        relative_path='v1/{+parent}/apis',
        request_field='',
        request_type_name='ApigeeOrganizationsApisListRequest',
        response_type_name='GoogleCloudApigeeV1ListApiProxiesResponse',
        supports_download=False,
    )

  class OrganizationsAppsService(base_api.BaseApiService):
    """Service class for the organizations_apps resource."""

    _NAME = 'organizations_apps'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsAppsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the app profile for the specified app ID.

      Args:
        request: (ApigeeOrganizationsAppsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1App) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apps/{appsId}',
        http_method='GET',
        method_id='apigee.organizations.apps.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsAppsGetRequest',
        response_type_name='GoogleCloudApigeeV1App',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists IDs of apps within an organization that have the specified app status.
(approved or revoked) or are of the specified app type
(developer or company).

      Args:
        request: (ApigeeOrganizationsAppsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListAppsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/apps',
        http_method='GET',
        method_id='apigee.organizations.apps.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['apiProduct', 'apptype', 'expand', 'ids', 'includeCred', 'keyStatus', 'rows', 'startKey', 'status'],
        relative_path='v1/{+parent}/apps',
        request_field='',
        request_type_name='ApigeeOrganizationsAppsListRequest',
        response_type_name='GoogleCloudApigeeV1ListAppsResponse',
        supports_download=False,
    )

  class OrganizationsDeploymentsService(base_api.BaseApiService):
    """Service class for the organizations_deployments resource."""

    _NAME = 'organizations_deployments'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsDeploymentsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists all deployments of API proxies or shared flows.

      Args:
        request: (ApigeeOrganizationsDeploymentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListDeploymentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/deployments',
        http_method='GET',
        method_id='apigee.organizations.deployments.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['sharedFlows'],
        relative_path='v1/{+parent}/deployments',
        request_field='',
        request_type_name='ApigeeOrganizationsDeploymentsListRequest',
        response_type_name='GoogleCloudApigeeV1ListDeploymentsResponse',
        supports_download=False,
    )

  class OrganizationsDevelopersAppsAttributesService(base_api.BaseApiService):
    """Service class for the organizations_developers_apps_attributes resource."""

    _NAME = 'organizations_developers_apps_attributes'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsDevelopersAppsAttributesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes a developer app attribute.

      Args:
        request: (ApigeeOrganizationsDevelopersAppsAttributesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Attribute) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps/{appsId}/attributes/{attributesId}',
        http_method='DELETE',
        method_id='apigee.organizations.developers.apps.attributes.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsDevelopersAppsAttributesDeleteRequest',
        response_type_name='GoogleCloudApigeeV1Attribute',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns a developer app attribute.

      Args:
        request: (ApigeeOrganizationsDevelopersAppsAttributesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Attribute) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps/{appsId}/attributes/{attributesId}',
        http_method='GET',
        method_id='apigee.organizations.developers.apps.attributes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsDevelopersAppsAttributesGetRequest',
        response_type_name='GoogleCloudApigeeV1Attribute',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns a list of all developer app attributes.

      Args:
        request: (ApigeeOrganizationsDevelopersAppsAttributesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Attributes) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps/{appsId}/attributes',
        http_method='GET',
        method_id='apigee.organizations.developers.apps.attributes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/attributes',
        request_field='',
        request_type_name='ApigeeOrganizationsDevelopersAppsAttributesListRequest',
        response_type_name='GoogleCloudApigeeV1Attributes',
        supports_download=False,
    )

    def UpdateDeveloperAppAttribute(self, request, global_params=None):
      r"""Updates a developer app attribute.

**Note**: OAuth access tokens and Key Management Service (KMS) entities
(apps, developers, and API products) are cached for 180 seconds
(current default). Any custom attributes associated with these entities
are cached for at least 180 seconds after the entity is accessed at
runtime. Therefore, an `ExpiresIn` element on the OAuthV2 policy
won't be able to expire an access token in less than 180 seconds.

      Args:
        request: (GoogleCloudApigeeV1Attribute) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Attribute) The response message.
      """
      config = self.GetMethodConfig('UpdateDeveloperAppAttribute')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateDeveloperAppAttribute.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps/{appsId}/attributes/{attributesId}',
        http_method='POST',
        method_id='apigee.organizations.developers.apps.attributes.updateDeveloperAppAttribute',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='<request>',
        request_type_name='GoogleCloudApigeeV1Attribute',
        response_type_name='GoogleCloudApigeeV1Attribute',
        supports_download=False,
    )

  class OrganizationsDevelopersAppsKeysApiproductsService(base_api.BaseApiService):
    """Service class for the organizations_developers_apps_keys_apiproducts resource."""

    _NAME = 'organizations_developers_apps_keys_apiproducts'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsDevelopersAppsKeysApiproductsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Removes an API product from an app's consumer key. After the API product is.
removed, the app cannot access the API resources defined in
that API product.

**Note**: The consumer key is not removed, only its association with the
API product.

      Args:
        request: (ApigeeOrganizationsDevelopersAppsKeysApiproductsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DeveloperAppKey) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps/{appsId}/keys/{keysId}/apiproducts/{apiproductsId}',
        http_method='DELETE',
        method_id='apigee.organizations.developers.apps.keys.apiproducts.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsDevelopersAppsKeysApiproductsDeleteRequest',
        response_type_name='GoogleCloudApigeeV1DeveloperAppKey',
        supports_download=False,
    )

    def UpdateDeveloperAppKeyApiProduct(self, request, global_params=None):
      r"""Approve or revoke an app's consumer key. After a consumer key is approved,.
the app can use it to access APIs.

A consumer key that is revoked or pending cannot be used to access an API.
Any access tokens associated with a revoked consumer key will remain
active. However, Apigee hybrid checks the status of the consumer key and
if set to `revoked` will not allow access to the API.

      Args:
        request: (ApigeeOrganizationsDevelopersAppsKeysApiproductsUpdateDeveloperAppKeyApiProductRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('UpdateDeveloperAppKeyApiProduct')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateDeveloperAppKeyApiProduct.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps/{appsId}/keys/{keysId}/apiproducts/{apiproductsId}',
        http_method='POST',
        method_id='apigee.organizations.developers.apps.keys.apiproducts.updateDeveloperAppKeyApiProduct',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['action'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsDevelopersAppsKeysApiproductsUpdateDeveloperAppKeyApiProductRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

  class OrganizationsDevelopersAppsKeysCreateService(base_api.BaseApiService):
    """Service class for the organizations_developers_apps_keys_create resource."""

    _NAME = 'organizations_developers_apps_keys_create'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsDevelopersAppsKeysCreateService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a custom consumer key and secret for a developer app. This is.
particularly useful if you want to migrate existing consumer keys and
secrets to Apigee hybrid from another system.

Consumer keys and secrets can contain letters, numbers, underscores, and
hyphens. No other special characters are allowed. To avoid service
disruptions, a consumer key and secret should not exceed 2 KBs each.

**Note**: When creating the consumer key and secret, an association to
API products will not be made. Therefore, you should not specify the
associated API products in your request. Instead, use the
UpdateDeveloperAppKey API to
make the association after the consumer key and secret are created.

If a consumer key and secret already exist, you can keep them or
delete them using the
DeleteDeveloperAppKey API.

      Args:
        request: (ApigeeOrganizationsDevelopersAppsKeysCreateCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DeveloperAppKey) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps/{appsId}/keys/create',
        http_method='POST',
        method_id='apigee.organizations.developers.apps.keys.create.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/keys/create',
        request_field='googleCloudApigeeV1DeveloperAppKey',
        request_type_name='ApigeeOrganizationsDevelopersAppsKeysCreateCreateRequest',
        response_type_name='GoogleCloudApigeeV1DeveloperAppKey',
        supports_download=False,
    )

  class OrganizationsDevelopersAppsKeysService(base_api.BaseApiService):
    """Service class for the organizations_developers_apps_keys resource."""

    _NAME = 'organizations_developers_apps_keys'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsDevelopersAppsKeysService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a custom consumer key and secret for a developer app. This is.
particularly useful if you want to migrate existing consumer keys and
secrets to Apigee hybrid from another system.

Consumer keys and secrets can contain letters, numbers, underscores, and
hyphens. No other special characters are allowed. To avoid service
disruptions, a consumer key and secret should not exceed 2 KBs each.

**Note**: When creating the consumer key and secret, an association to
API products will not be made. Therefore, you should not specify the
associated API products in your request. Instead, use the
UpdateDeveloperAppKey API to
make the association after the consumer key and secret are created.

If a consumer key and secret already exist, you can keep them or
delete them using the
DeleteDeveloperAppKey API.

      Args:
        request: (ApigeeOrganizationsDevelopersAppsKeysCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DeveloperAppKey) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps/{appsId}/keys',
        http_method='POST',
        method_id='apigee.organizations.developers.apps.keys.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/keys',
        request_field='googleCloudApigeeV1DeveloperAppKey',
        request_type_name='ApigeeOrganizationsDevelopersAppsKeysCreateRequest',
        response_type_name='GoogleCloudApigeeV1DeveloperAppKey',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an app's consumer key and removes all API products.
associated with the app. After the consumer key is deleted,
it cannot be used to access any APIs.

**Note**: After you delete a consumer key, you may want to:
1. Create a new consumer key and secret for the developer app using the
CreateDeveloperAppKey API, and
subsequently add an API product to the key using the
UpdateDeveloperAppKey API.
2. Delete the developer app, if it is no longer required.

      Args:
        request: (ApigeeOrganizationsDevelopersAppsKeysDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DeveloperAppKey) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps/{appsId}/keys/{keysId}',
        http_method='DELETE',
        method_id='apigee.organizations.developers.apps.keys.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsDevelopersAppsKeysDeleteRequest',
        response_type_name='GoogleCloudApigeeV1DeveloperAppKey',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns details for a consumer key for a developer app, including the key.
and secret value, associated API products, and other information.

      Args:
        request: (ApigeeOrganizationsDevelopersAppsKeysGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DeveloperAppKey) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps/{appsId}/keys/{keysId}',
        http_method='GET',
        method_id='apigee.organizations.developers.apps.keys.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsDevelopersAppsKeysGetRequest',
        response_type_name='GoogleCloudApigeeV1DeveloperAppKey',
        supports_download=False,
    )

    def ReplaceDeveloperAppKey(self, request, global_params=None):
      r"""Updates the scope of an app.

This API replaces the
existing scopes with those specified in the request.
Include or exclude any existing scopes that you want to retain or
delete, respectively. The specified scopes must already
be defined for the API products associated with the app.

This API sets the `scopes` element
under the `apiProducts` element in the attributes of the app.

      Args:
        request: (ApigeeOrganizationsDevelopersAppsKeysReplaceDeveloperAppKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DeveloperAppKey) The response message.
      """
      config = self.GetMethodConfig('ReplaceDeveloperAppKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReplaceDeveloperAppKey.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps/{appsId}/keys/{keysId}',
        http_method='PUT',
        method_id='apigee.organizations.developers.apps.keys.replaceDeveloperAppKey',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='googleCloudApigeeV1DeveloperAppKey',
        request_type_name='ApigeeOrganizationsDevelopersAppsKeysReplaceDeveloperAppKeyRequest',
        response_type_name='GoogleCloudApigeeV1DeveloperAppKey',
        supports_download=False,
    )

    def UpdateDeveloperAppKey(self, request, global_params=None):
      r"""Adds an API product to a developer app key, enabling the app that holds.
the key to access the API resources bundled in the API product.

In addition, you can add
attributes to a developer app key. This API replaces the
existing attributes with those specified in the request.
Include or exclude any existing attributes that you want to retain or
delete, respectively.

You can use the same key to access all API products
associated with the app.

      Args:
        request: (ApigeeOrganizationsDevelopersAppsKeysUpdateDeveloperAppKeyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DeveloperAppKey) The response message.
      """
      config = self.GetMethodConfig('UpdateDeveloperAppKey')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateDeveloperAppKey.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps/{appsId}/keys/{keysId}',
        http_method='POST',
        method_id='apigee.organizations.developers.apps.keys.updateDeveloperAppKey',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['action'],
        relative_path='v1/{+name}',
        request_field='googleCloudApigeeV1DeveloperAppKey',
        request_type_name='ApigeeOrganizationsDevelopersAppsKeysUpdateDeveloperAppKeyRequest',
        response_type_name='GoogleCloudApigeeV1DeveloperAppKey',
        supports_download=False,
    )

  class OrganizationsDevelopersAppsService(base_api.BaseApiService):
    """Service class for the organizations_developers_apps resource."""

    _NAME = 'organizations_developers_apps'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsDevelopersAppsService, self).__init__(client)
      self._upload_configs = {
          }

    def Attributes(self, request, global_params=None):
      r"""Updates attributes for a developer app. This API replaces the.
current attributes with those specified in the request.

      Args:
        request: (ApigeeOrganizationsDevelopersAppsAttributesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Attributes) The response message.
      """
      config = self.GetMethodConfig('Attributes')
      return self._RunMethod(
          config, request, global_params=global_params)

    Attributes.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps/{appsId}/attributes',
        http_method='POST',
        method_id='apigee.organizations.developers.apps.attributes',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}/attributes',
        request_field='googleCloudApigeeV1Attributes',
        request_type_name='ApigeeOrganizationsDevelopersAppsAttributesRequest',
        response_type_name='GoogleCloudApigeeV1Attributes',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates an app associated with a developer. This API associates the.
developer app with the specified API
product and auto-generates an API key for the app to use in calls to API
proxies inside that API product.

The `name` is the unique ID of the app
that you can use in API calls. The `DisplayName` (set as an
attribute) appears in the UI. If you don't set the
`DisplayName` attribute, the `name` appears in the UI.

      Args:
        request: (ApigeeOrganizationsDevelopersAppsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DeveloperApp) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps',
        http_method='POST',
        method_id='apigee.organizations.developers.apps.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/apps',
        request_field='googleCloudApigeeV1DeveloperApp',
        request_type_name='ApigeeOrganizationsDevelopersAppsCreateRequest',
        response_type_name='GoogleCloudApigeeV1DeveloperApp',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a developer app.

**Note**: The delete operation is asynchronous. The developer app is
deleted immediately,
but its associated resources, such as app
keys or access tokens, may take anywhere from a few seconds to a
few minutes to be deleted.

      Args:
        request: (ApigeeOrganizationsDevelopersAppsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DeveloperApp) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps/{appsId}',
        http_method='DELETE',
        method_id='apigee.organizations.developers.apps.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsDevelopersAppsDeleteRequest',
        response_type_name='GoogleCloudApigeeV1DeveloperApp',
        supports_download=False,
    )

    def GenerateKeyPairOrUpdateDeveloperAppStatus(self, request, global_params=None):
      r"""Manages access to a developer app by enabling you to:.

* Approve or revoke a developer app
* Generate a new consumer key and secret for a developer app

To approve or revoke a developer app, set the `action` query parameter to
`approved` or `revoked`, respectively, and the
`Content-Type` header to `application/octet-stream`. If a developer app is
revoked, none of its API keys are valid for API calls even though
the keys are still `approved`. If successful, the API call returns the
following HTTP status code: `204 No Content`

To generate a new consumer key and secret for a developer
app, pass the new key/secret details. Rather than
replace an existing key, this API generates a new
key. In this case, multiple key
pairs may be associated with a single developer app. Each key pair has an
independent status (`approved` or `revoked`) and expiration time.
Any approved, non-expired key can be used in an API call.

For example, if you're using API key rotation, you can generate new
keys with expiration times that overlap keys that are going to expire.
You might also generate a new consumer key/secret if the security of the
original key/secret is compromised.

The `keyExpiresIn` property defines the
expiration time for the API key in milliseconds. If you don't set
this property or set it to `-1`, the API key never expires.

**Notes**:

* When generating a new key/secret, this API replaces the
existing attributes, notes, and callback URLs with those specified in the
request. Include or exclude any existing information that you want to
retain or delete, respectively.
* To migrate existing consumer keys and secrets to hybrid from another
system, see the
CreateDeveloperAppKey API.

      Args:
        request: (ApigeeOrganizationsDevelopersAppsGenerateKeyPairOrUpdateDeveloperAppStatusRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DeveloperApp) The response message.
      """
      config = self.GetMethodConfig('GenerateKeyPairOrUpdateDeveloperAppStatus')
      return self._RunMethod(
          config, request, global_params=global_params)

    GenerateKeyPairOrUpdateDeveloperAppStatus.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps/{appsId}',
        http_method='POST',
        method_id='apigee.organizations.developers.apps.generateKeyPairOrUpdateDeveloperAppStatus',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['action'],
        relative_path='v1/{+name}',
        request_field='googleCloudApigeeV1DeveloperApp',
        request_type_name='ApigeeOrganizationsDevelopersAppsGenerateKeyPairOrUpdateDeveloperAppStatusRequest',
        response_type_name='GoogleCloudApigeeV1DeveloperApp',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the details for a developer app.

      Args:
        request: (ApigeeOrganizationsDevelopersAppsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DeveloperApp) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps/{appsId}',
        http_method='GET',
        method_id='apigee.organizations.developers.apps.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['entity', 'query'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsDevelopersAppsGetRequest',
        response_type_name='GoogleCloudApigeeV1DeveloperApp',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all apps created by a developer in an Apigee organization.
Optionally, you can request an expanded view of the developer apps.

A maximum of 100 developer apps are returned per API call. You can paginate
the list of deveoper apps returned using the `startKey` and `count` query
parameters.

      Args:
        request: (ApigeeOrganizationsDevelopersAppsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListDeveloperAppsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps',
        http_method='GET',
        method_id='apigee.organizations.developers.apps.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['count', 'expand', 'shallowExpand', 'startKey'],
        relative_path='v1/{+parent}/apps',
        request_field='',
        request_type_name='ApigeeOrganizationsDevelopersAppsListRequest',
        response_type_name='GoogleCloudApigeeV1ListDeveloperAppsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the details for a developer app. In addition, you can.
add an API product to a developer app and automatically generate
an API key for the app to use when calling APIs in the API product.

If you want to use an existing API key for the API product,
add the API product to the API key using the
UpdateDeveloperAppKey
API.

Using this API, you cannot update the following:

* App name as it is the primary key used to identify the app and cannot
  be changed.
* Scopes associated with the app. Instead, use the
  ReplaceDeveloperAppKey API.

This API replaces the
existing attributes with those specified in the request.
Include or exclude any existing attributes that you want to retain or
delete, respectively.

      Args:
        request: (GoogleCloudApigeeV1DeveloperApp) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DeveloperApp) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/apps/{appsId}',
        http_method='PUT',
        method_id='apigee.organizations.developers.apps.update',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='<request>',
        request_type_name='GoogleCloudApigeeV1DeveloperApp',
        response_type_name='GoogleCloudApigeeV1DeveloperApp',
        supports_download=False,
    )

  class OrganizationsDevelopersAttributesService(base_api.BaseApiService):
    """Service class for the organizations_developers_attributes resource."""

    _NAME = 'organizations_developers_attributes'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsDevelopersAttributesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes a developer attribute.

      Args:
        request: (ApigeeOrganizationsDevelopersAttributesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Attribute) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/attributes/{attributesId}',
        http_method='DELETE',
        method_id='apigee.organizations.developers.attributes.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsDevelopersAttributesDeleteRequest',
        response_type_name='GoogleCloudApigeeV1Attribute',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the value of the specified developer attribute.

      Args:
        request: (ApigeeOrganizationsDevelopersAttributesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Attribute) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/attributes/{attributesId}',
        http_method='GET',
        method_id='apigee.organizations.developers.attributes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsDevelopersAttributesGetRequest',
        response_type_name='GoogleCloudApigeeV1Attribute',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns a list of all developer attributes.

      Args:
        request: (ApigeeOrganizationsDevelopersAttributesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Attributes) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/attributes',
        http_method='GET',
        method_id='apigee.organizations.developers.attributes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/attributes',
        request_field='',
        request_type_name='ApigeeOrganizationsDevelopersAttributesListRequest',
        response_type_name='GoogleCloudApigeeV1Attributes',
        supports_download=False,
    )

    def UpdateDeveloperAttribute(self, request, global_params=None):
      r"""Updates a developer attribute.

**Note**: OAuth access tokens and Key Management Service (KMS) entities
(apps, developers, and API products) are cached for 180 seconds
(default). Any custom attributes associated with these entities
are cached for at least 180 seconds after the entity is accessed at
runtime. Therefore, an `ExpiresIn` element on the OAuthV2 policy
won't be able to expire an access token in less than 180 seconds.

      Args:
        request: (GoogleCloudApigeeV1Attribute) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Attribute) The response message.
      """
      config = self.GetMethodConfig('UpdateDeveloperAttribute')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateDeveloperAttribute.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/attributes/{attributesId}',
        http_method='POST',
        method_id='apigee.organizations.developers.attributes.updateDeveloperAttribute',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='<request>',
        request_type_name='GoogleCloudApigeeV1Attribute',
        response_type_name='GoogleCloudApigeeV1Attribute',
        supports_download=False,
    )

  class OrganizationsDevelopersService(base_api.BaseApiService):
    """Service class for the organizations_developers resource."""

    _NAME = 'organizations_developers'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsDevelopersService, self).__init__(client)
      self._upload_configs = {
          }

    def Attributes(self, request, global_params=None):
      r"""Updates developer attributes.

This API replaces the
existing attributes with those specified in the request.
Add new attributes, and include or exclude any existing
attributes that you want to retain or
remove, respectively.

The custom attribute limit is 18.

**Note**: OAuth access tokens and Key Management Service (KMS) entities
(apps, developers, and API products) are cached for 180 seconds
(default). Any custom attributes associated with these entities
are cached for at least 180 seconds after the entity is accessed at
runtime. Therefore, an `ExpiresIn` element on the OAuthV2 policy
won't be able to expire an access token in less than 180 seconds.

      Args:
        request: (ApigeeOrganizationsDevelopersAttributesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Attributes) The response message.
      """
      config = self.GetMethodConfig('Attributes')
      return self._RunMethod(
          config, request, global_params=global_params)

    Attributes.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}/attributes',
        http_method='POST',
        method_id='apigee.organizations.developers.attributes',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/attributes',
        request_field='googleCloudApigeeV1Attributes',
        request_type_name='ApigeeOrganizationsDevelopersAttributesRequest',
        response_type_name='GoogleCloudApigeeV1Attributes',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a developer. Once created,.
the developer can register an app and obtain an API key.

At creation time, a developer is set as `active`. To change the developer
status, use the SetDeveloperStatus API.

      Args:
        request: (ApigeeOrganizationsDevelopersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Developer) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers',
        http_method='POST',
        method_id='apigee.organizations.developers.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/developers',
        request_field='googleCloudApigeeV1Developer',
        request_type_name='ApigeeOrganizationsDevelopersCreateRequest',
        response_type_name='GoogleCloudApigeeV1Developer',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a developer. All apps and API keys associated.
with the developer are also removed.

**Warning**: This API will permanently delete the developer
and related artifacts.

To avoid permanently deleting developers and their artifacts,
set the developer status to `inactive` using
the SetDeveloperStatus API.

**Note**: The delete operation is asynchronous. The developer app is
deleted immediately,
but its associated resources, such as apps and API keys, may take anywhere
from a few seconds to a few minutes to be deleted.

      Args:
        request: (ApigeeOrganizationsDevelopersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Developer) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}',
        http_method='DELETE',
        method_id='apigee.organizations.developers.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsDevelopersDeleteRequest',
        response_type_name='GoogleCloudApigeeV1Developer',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the developer details, including the.
developer's name, email address, apps, and other information.

**Note**: The response includes only the first 100 developer apps.

      Args:
        request: (ApigeeOrganizationsDevelopersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Developer) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}',
        http_method='GET',
        method_id='apigee.organizations.developers.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['action'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsDevelopersGetRequest',
        response_type_name='GoogleCloudApigeeV1Developer',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all developers in an organization by email address.

By default,
the response does not include company developers. Set the `includeCompany`
query parameter to `true` to include company developers.

**Note**: A maximum of 1000 developers are returned in the response. You
paginate the list of developers returned using the `startKey` and `count`
query parameters.

      Args:
        request: (ApigeeOrganizationsDevelopersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListOfDevelopersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers',
        http_method='GET',
        method_id='apigee.organizations.developers.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['count', 'expand', 'ids', 'includeCompany', 'startKey'],
        relative_path='v1/{+parent}/developers',
        request_field='',
        request_type_name='ApigeeOrganizationsDevelopersListRequest',
        response_type_name='GoogleCloudApigeeV1ListOfDevelopersResponse',
        supports_download=False,
    )

    def SetDeveloperStatus(self, request, global_params=None):
      r"""Sets the status of a developer. Valid values are `active` or `inactive`.

A developer is `active` by default. If you set a developer's status to
`inactive`, the API keys assigned to the developer apps are no longer valid
even though the API keys are set to `approved`. Inactive developers
can still sign in to the developer portal and create apps; however, any
new API keys generated during app creation won't work.

If successful, the API call returns the
following HTTP status code: `204 No Content`

      Args:
        request: (ApigeeOrganizationsDevelopersSetDeveloperStatusRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('SetDeveloperStatus')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetDeveloperStatus.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}',
        http_method='POST',
        method_id='apigee.organizations.developers.setDeveloperStatus',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['action'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsDevelopersSetDeveloperStatusRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a developer.

This API replaces the existing developer details with those specified
in the request. Include or exclude any existing details that
you want to retain or delete, respectively.

The custom attribute limit is 18.

**Note**: OAuth access tokens and Key Management Service (KMS) entities
(apps, developers, and API products) are cached for 180 seconds
(current default). Any custom attributes associated with these entities
are cached for at least 180 seconds after the entity is accessed at
runtime. Therefore, an `ExpiresIn` element on the OAuthV2 policy
won't be able to expire an access token in less than 180 seconds.

      Args:
        request: (ApigeeOrganizationsDevelopersUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Developer) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/developers/{developersId}',
        http_method='PUT',
        method_id='apigee.organizations.developers.update',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='googleCloudApigeeV1Developer',
        request_type_name='ApigeeOrganizationsDevelopersUpdateRequest',
        response_type_name='GoogleCloudApigeeV1Developer',
        supports_download=False,
    )

  class OrganizationsEnvgroupsAttachmentsService(base_api.BaseApiService):
    """Service class for the organizations_envgroups_attachments resource."""

    _NAME = 'organizations_envgroups_attachments'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvgroupsAttachmentsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new attachment of an environment to an environment group.

      Args:
        request: (ApigeeOrganizationsEnvgroupsAttachmentsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/envgroups/{envgroupsId}/attachments',
        http_method='POST',
        method_id='apigee.organizations.envgroups.attachments.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/attachments',
        request_field='googleCloudApigeeV1EnvironmentGroupAttachment',
        request_type_name='ApigeeOrganizationsEnvgroupsAttachmentsCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an environment group attachment.

      Args:
        request: (ApigeeOrganizationsEnvgroupsAttachmentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/envgroups/{envgroupsId}/attachments/{attachmentsId}',
        http_method='DELETE',
        method_id='apigee.organizations.envgroups.attachments.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvgroupsAttachmentsDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an environment group attachment.

      Args:
        request: (ApigeeOrganizationsEnvgroupsAttachmentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1EnvironmentGroupAttachment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/envgroups/{envgroupsId}/attachments/{attachmentsId}',
        http_method='GET',
        method_id='apigee.organizations.envgroups.attachments.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvgroupsAttachmentsGetRequest',
        response_type_name='GoogleCloudApigeeV1EnvironmentGroupAttachment',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all attachments of an environment group.

      Args:
        request: (ApigeeOrganizationsEnvgroupsAttachmentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListEnvironmentGroupAttachmentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/envgroups/{envgroupsId}/attachments',
        http_method='GET',
        method_id='apigee.organizations.envgroups.attachments.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/attachments',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvgroupsAttachmentsListRequest',
        response_type_name='GoogleCloudApigeeV1ListEnvironmentGroupAttachmentsResponse',
        supports_download=False,
    )

  class OrganizationsEnvgroupsService(base_api.BaseApiService):
    """Service class for the organizations_envgroups resource."""

    _NAME = 'organizations_envgroups'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvgroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new environment group.

      Args:
        request: (ApigeeOrganizationsEnvgroupsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/envgroups',
        http_method='POST',
        method_id='apigee.organizations.envgroups.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['name'],
        relative_path='v1/{+parent}/envgroups',
        request_field='googleCloudApigeeV1EnvironmentGroup',
        request_type_name='ApigeeOrganizationsEnvgroupsCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an environment group.

      Args:
        request: (ApigeeOrganizationsEnvgroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/envgroups/{envgroupsId}',
        http_method='DELETE',
        method_id='apigee.organizations.envgroups.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvgroupsDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an environment group.

      Args:
        request: (ApigeeOrganizationsEnvgroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1EnvironmentGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/envgroups/{envgroupsId}',
        http_method='GET',
        method_id='apigee.organizations.envgroups.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvgroupsGetRequest',
        response_type_name='GoogleCloudApigeeV1EnvironmentGroup',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all environment groups.

      Args:
        request: (ApigeeOrganizationsEnvgroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListEnvironmentGroupsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/envgroups',
        http_method='GET',
        method_id='apigee.organizations.envgroups.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/envgroups',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvgroupsListRequest',
        response_type_name='GoogleCloudApigeeV1ListEnvironmentGroupsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an environment group.

      Args:
        request: (ApigeeOrganizationsEnvgroupsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/envgroups/{envgroupsId}',
        http_method='PATCH',
        method_id='apigee.organizations.envgroups.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='googleCloudApigeeV1EnvironmentGroup',
        request_type_name='ApigeeOrganizationsEnvgroupsPatchRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

  class OrganizationsEnvironmentsAnalyticsAdminService(base_api.BaseApiService):
    """Service class for the organizations_environments_analytics_admin resource."""

    _NAME = 'organizations_environments_analytics_admin'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsAnalyticsAdminService, self).__init__(client)
      self._upload_configs = {
          }

    def GetSchemav2(self, request, global_params=None):
      r"""Get a list of metrics and dimensions which can be used for creating.
analytics queries and reports.
Each schema element contains the name of the field with its associated type
and if it is either custom field or standard field.

      Args:
        request: (ApigeeOrganizationsEnvironmentsAnalyticsAdminGetSchemav2Request) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Schema) The response message.
      """
      config = self.GetMethodConfig('GetSchemav2')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetSchemav2.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/analytics/admin/schemav2',
        http_method='GET',
        method_id='apigee.organizations.environments.analytics.admin.getSchemav2',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['type'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsAnalyticsAdminGetSchemav2Request',
        response_type_name='GoogleCloudApigeeV1Schema',
        supports_download=False,
    )

  class OrganizationsEnvironmentsAnalyticsService(base_api.BaseApiService):
    """Service class for the organizations_environments_analytics resource."""

    _NAME = 'organizations_environments_analytics'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsAnalyticsService, self).__init__(client)
      self._upload_configs = {
          }

  class OrganizationsEnvironmentsApisDeploymentsService(base_api.BaseApiService):
    """Service class for the organizations_environments_apis_deployments resource."""

    _NAME = 'organizations_environments_apis_deployments'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsApisDeploymentsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists all deployments of an API proxy in an environment.

      Args:
        request: (ApigeeOrganizationsEnvironmentsApisDeploymentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListDeploymentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/apis/{apisId}/deployments',
        http_method='GET',
        method_id='apigee.organizations.environments.apis.deployments.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/deployments',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsApisDeploymentsListRequest',
        response_type_name='GoogleCloudApigeeV1ListDeploymentsResponse',
        supports_download=False,
    )

  class OrganizationsEnvironmentsApisRevisionsDebugsessionsDataService(base_api.BaseApiService):
    """Service class for the organizations_environments_apis_revisions_debugsessions_data resource."""

    _NAME = 'organizations_environments_apis_revisions_debugsessions_data'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsApisRevisionsDebugsessionsDataService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the debug data from a transaction.

      Args:
        request: (ApigeeOrganizationsEnvironmentsApisRevisionsDebugsessionsDataGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DebugSessionTransaction) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/apis/{apisId}/revisions/{revisionsId}/debugsessions/{debugsessionsId}/data/{dataId}',
        http_method='GET',
        method_id='apigee.organizations.environments.apis.revisions.debugsessions.data.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsApisRevisionsDebugsessionsDataGetRequest',
        response_type_name='GoogleCloudApigeeV1DebugSessionTransaction',
        supports_download=False,
    )

  class OrganizationsEnvironmentsApisRevisionsDebugsessionsService(base_api.BaseApiService):
    """Service class for the organizations_environments_apis_revisions_debugsessions resource."""

    _NAME = 'organizations_environments_apis_revisions_debugsessions'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsApisRevisionsDebugsessionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a debug session for a deployed API Proxy revision.

      Args:
        request: (ApigeeOrganizationsEnvironmentsApisRevisionsDebugsessionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DebugSession) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/apis/{apisId}/revisions/{revisionsId}/debugsessions',
        http_method='POST',
        method_id='apigee.organizations.environments.apis.revisions.debugsessions.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['timeout'],
        relative_path='v1/{+parent}/debugsessions',
        request_field='googleCloudApigeeV1DebugSession',
        request_type_name='ApigeeOrganizationsEnvironmentsApisRevisionsDebugsessionsCreateRequest',
        response_type_name='GoogleCloudApigeeV1DebugSession',
        supports_download=False,
    )

    def DeleteData(self, request, global_params=None):
      r"""Deletes the data from a debug session. This does not cancel the debug.
session or prevent further data from being collected if the session is
still active in runtime pods.

      Args:
        request: (ApigeeOrganizationsEnvironmentsApisRevisionsDebugsessionsDeleteDataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('DeleteData')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteData.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/apis/{apisId}/revisions/{revisionsId}/debugsessions/{debugsessionsId}/data',
        http_method='DELETE',
        method_id='apigee.organizations.environments.apis.revisions.debugsessions.deleteData',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}/data',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsApisRevisionsDebugsessionsDeleteDataRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieves a debug session.

      Args:
        request: (ApigeeOrganizationsEnvironmentsApisRevisionsDebugsessionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DebugSession) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/apis/{apisId}/revisions/{revisionsId}/debugsessions/{debugsessionsId}',
        http_method='GET',
        method_id='apigee.organizations.environments.apis.revisions.debugsessions.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsApisRevisionsDebugsessionsGetRequest',
        response_type_name='GoogleCloudApigeeV1DebugSession',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists debug sessions that are currently active in the given API Proxy.
revision.

      Args:
        request: (ApigeeOrganizationsEnvironmentsApisRevisionsDebugsessionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListDebugSessionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/apis/{apisId}/revisions/{revisionsId}/debugsessions',
        http_method='GET',
        method_id='apigee.organizations.environments.apis.revisions.debugsessions.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/debugsessions',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsApisRevisionsDebugsessionsListRequest',
        response_type_name='GoogleCloudApigeeV1ListDebugSessionsResponse',
        supports_download=False,
    )

  class OrganizationsEnvironmentsApisRevisionsDeploymentsService(base_api.BaseApiService):
    """Service class for the organizations_environments_apis_revisions_deployments resource."""

    _NAME = 'organizations_environments_apis_revisions_deployments'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsApisRevisionsDeploymentsService, self).__init__(client)
      self._upload_configs = {
          }

    def GenerateDeployChangeReport(self, request, global_params=None):
      r"""Generates a report for a dry run analysis of a DeployApiProxy request.
without committing the deployment.

In addition to the standard validations performed when adding deployments,
additional analysis will be done to detect possible traffic routing changes
that would result from this deployment being created. Any potential routing
conflicts or unsafe changes will be reported in the response. This routing
analysis is not performed for a non-dry-run DeployApiProxy request.

      Args:
        request: (ApigeeOrganizationsEnvironmentsApisRevisionsDeploymentsGenerateDeployChangeReportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DeploymentChangeReport) The response message.
      """
      config = self.GetMethodConfig('GenerateDeployChangeReport')
      return self._RunMethod(
          config, request, global_params=global_params)

    GenerateDeployChangeReport.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/apis/{apisId}/revisions/{revisionsId}/deployments:generateDeployChangeReport',
        http_method='POST',
        method_id='apigee.organizations.environments.apis.revisions.deployments.generateDeployChangeReport',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['basepath', 'override'],
        relative_path='v1/{+name}/deployments:generateDeployChangeReport',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsApisRevisionsDeploymentsGenerateDeployChangeReportRequest',
        response_type_name='GoogleCloudApigeeV1DeploymentChangeReport',
        supports_download=False,
    )

    def GenerateUndeployChangeReport(self, request, global_params=None):
      r"""Generates a report for a dry run analysis of an UndeployApiProxy request.
without committing the undeploy.

In addition to the standard validations performed when removing
deployments, additional analysis will be done to detect possible traffic
routing changes that would result from this deployment being removed. Any
potential routing conflicts or unsafe changes will be reported in the
response. This routing analysis is not performed for a non-dry-run
UndeployApiProxy request.

      Args:
        request: (ApigeeOrganizationsEnvironmentsApisRevisionsDeploymentsGenerateUndeployChangeReportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DeploymentChangeReport) The response message.
      """
      config = self.GetMethodConfig('GenerateUndeployChangeReport')
      return self._RunMethod(
          config, request, global_params=global_params)

    GenerateUndeployChangeReport.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/apis/{apisId}/revisions/{revisionsId}/deployments:generateUndeployChangeReport',
        http_method='POST',
        method_id='apigee.organizations.environments.apis.revisions.deployments.generateUndeployChangeReport',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}/deployments:generateUndeployChangeReport',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsApisRevisionsDeploymentsGenerateUndeployChangeReportRequest',
        response_type_name='GoogleCloudApigeeV1DeploymentChangeReport',
        supports_download=False,
    )

  class OrganizationsEnvironmentsApisRevisionsService(base_api.BaseApiService):
    """Service class for the organizations_environments_apis_revisions resource."""

    _NAME = 'organizations_environments_apis_revisions'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsApisRevisionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Deployments(self, request, global_params=None):
      r"""Undeploys an API proxy revision from an environment.

Because multiple revisions of the same API proxy can be deployed in
the same environment if the base paths are different, you must specify the
revision number of the API proxy.

      Args:
        request: (ApigeeOrganizationsEnvironmentsApisRevisionsDeploymentsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Deployments')
      return self._RunMethod(
          config, request, global_params=global_params)

    Deployments.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/apis/{apisId}/revisions/{revisionsId}/deployments',
        http_method='DELETE',
        method_id='apigee.organizations.environments.apis.revisions.deployments',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}/deployments',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsApisRevisionsDeploymentsRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def GetDeployments(self, request, global_params=None):
      r"""Gets the deployment of an API proxy revision and actual state reported by.
runtime pods.

      Args:
        request: (ApigeeOrganizationsEnvironmentsApisRevisionsGetDeploymentsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Deployment) The response message.
      """
      config = self.GetMethodConfig('GetDeployments')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetDeployments.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/apis/{apisId}/revisions/{revisionsId}/deployments',
        http_method='GET',
        method_id='apigee.organizations.environments.apis.revisions.getDeployments',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}/deployments',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsApisRevisionsGetDeploymentsRequest',
        response_type_name='GoogleCloudApigeeV1Deployment',
        supports_download=False,
    )

  class OrganizationsEnvironmentsApisService(base_api.BaseApiService):
    """Service class for the organizations_environments_apis resource."""

    _NAME = 'organizations_environments_apis'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsApisService, self).__init__(client)
      self._upload_configs = {
          }

  class OrganizationsEnvironmentsCachesService(base_api.BaseApiService):
    """Service class for the organizations_environments_caches resource."""

    _NAME = 'organizations_environments_caches'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsCachesService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes a cache.

      Args:
        request: (ApigeeOrganizationsEnvironmentsCachesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/caches/{cachesId}',
        http_method='DELETE',
        method_id='apigee.organizations.environments.caches.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsCachesDeleteRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

  class OrganizationsEnvironmentsDeploymentsService(base_api.BaseApiService):
    """Service class for the organizations_environments_deployments resource."""

    _NAME = 'organizations_environments_deployments'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsDeploymentsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists all deployments of API proxies or shared flows in an environment.

      Args:
        request: (ApigeeOrganizationsEnvironmentsDeploymentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListDeploymentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/deployments',
        http_method='GET',
        method_id='apigee.organizations.environments.deployments.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['sharedFlows'],
        relative_path='v1/{+parent}/deployments',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsDeploymentsListRequest',
        response_type_name='GoogleCloudApigeeV1ListDeploymentsResponse',
        supports_download=False,
    )

  class OrganizationsEnvironmentsFlowhooksService(base_api.BaseApiService):
    """Service class for the organizations_environments_flowhooks resource."""

    _NAME = 'organizations_environments_flowhooks'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsFlowhooksService, self).__init__(client)
      self._upload_configs = {
          }

    def AttachSharedFlowToFlowHook(self, request, global_params=None):
      r"""Attaches a shared flow to a flow hook.

      Args:
        request: (ApigeeOrganizationsEnvironmentsFlowhooksAttachSharedFlowToFlowHookRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1FlowHook) The response message.
      """
      config = self.GetMethodConfig('AttachSharedFlowToFlowHook')
      return self._RunMethod(
          config, request, global_params=global_params)

    AttachSharedFlowToFlowHook.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/flowhooks/{flowhooksId}',
        http_method='PUT',
        method_id='apigee.organizations.environments.flowhooks.attachSharedFlowToFlowHook',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='googleCloudApigeeV1FlowHook',
        request_type_name='ApigeeOrganizationsEnvironmentsFlowhooksAttachSharedFlowToFlowHookRequest',
        response_type_name='GoogleCloudApigeeV1FlowHook',
        supports_download=False,
    )

    def DetachSharedFlowFromFlowHook(self, request, global_params=None):
      r"""Detaches a shared flow from a flow hook.

      Args:
        request: (ApigeeOrganizationsEnvironmentsFlowhooksDetachSharedFlowFromFlowHookRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1FlowHook) The response message.
      """
      config = self.GetMethodConfig('DetachSharedFlowFromFlowHook')
      return self._RunMethod(
          config, request, global_params=global_params)

    DetachSharedFlowFromFlowHook.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/flowhooks/{flowhooksId}',
        http_method='DELETE',
        method_id='apigee.organizations.environments.flowhooks.detachSharedFlowFromFlowHook',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsFlowhooksDetachSharedFlowFromFlowHookRequest',
        response_type_name='GoogleCloudApigeeV1FlowHook',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the name of the shared flow attached to the specified flow hook. If.
there's no shared flow attached to the flow hook, the API does not return
an error; it simply does not return a name in the response.

      Args:
        request: (ApigeeOrganizationsEnvironmentsFlowhooksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1FlowHook) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/flowhooks/{flowhooksId}',
        http_method='GET',
        method_id='apigee.organizations.environments.flowhooks.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsFlowhooksGetRequest',
        response_type_name='GoogleCloudApigeeV1FlowHook',
        supports_download=False,
    )

  class OrganizationsEnvironmentsKeystoresAliasesService(base_api.BaseApiService):
    """Service class for the organizations_environments_keystores_aliases resource."""

    _NAME = 'organizations_environments_keystores_aliases'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsKeystoresAliasesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an alias from a key, certificate pair.
The structure of the request is controlled by the `format` query parameter:
 * `keycertfile` - Separate PEM-encoded key and certificate files are
 uploaded. The request must have `Content-Type: multipart/form-data` and
 include fields `keyFile` and `certFile`. If uploading to a truststore,
 omit `keyFile`.
* `pkcs12` - A PKCS12 file is uploaded. The request must have
`Content-Type: multipart/form-data` with the file provided in the only
field.
* `selfsignedcert` - A new private key and certificate are generated. The
request must have `Content-Type: application/json` and a body of
CertificateGenerationSpec.

      Args:
        request: (ApigeeOrganizationsEnvironmentsKeystoresAliasesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Alias) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/keystores/{keystoresId}/aliases',
        http_method='POST',
        method_id='apigee.organizations.environments.keystores.aliases.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['_password', 'alias', 'format', 'ignoreExpiryValidation', 'ignoreNewlineValidation'],
        relative_path='v1/{+parent}/aliases',
        request_field='googleApiHttpBody',
        request_type_name='ApigeeOrganizationsEnvironmentsKeystoresAliasesCreateRequest',
        response_type_name='GoogleCloudApigeeV1Alias',
        supports_download=False,
    )

    def Csr(self, request, global_params=None):
      r"""Generates a PKCS #10 Certificate Signing Request for the private key in.
an alias.

      Args:
        request: (ApigeeOrganizationsEnvironmentsKeystoresAliasesCsrRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleApiHttpBody) The response message.
      """
      config = self.GetMethodConfig('Csr')
      return self._RunMethod(
          config, request, global_params=global_params)

    Csr.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/keystores/{keystoresId}/aliases/{aliasesId}/csr',
        http_method='GET',
        method_id='apigee.organizations.environments.keystores.aliases.csr',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}/csr',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsKeystoresAliasesCsrRequest',
        response_type_name='GoogleApiHttpBody',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an alias.

      Args:
        request: (ApigeeOrganizationsEnvironmentsKeystoresAliasesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Alias) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/keystores/{keystoresId}/aliases/{aliasesId}',
        http_method='DELETE',
        method_id='apigee.organizations.environments.keystores.aliases.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsKeystoresAliasesDeleteRequest',
        response_type_name='GoogleCloudApigeeV1Alias',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an alias.

      Args:
        request: (ApigeeOrganizationsEnvironmentsKeystoresAliasesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Alias) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/keystores/{keystoresId}/aliases/{aliasesId}',
        http_method='GET',
        method_id='apigee.organizations.environments.keystores.aliases.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsKeystoresAliasesGetRequest',
        response_type_name='GoogleCloudApigeeV1Alias',
        supports_download=False,
    )

    def GetCertificate(self, request, global_params=None):
      r"""Gets the certificate from an alias in PEM-encoded form.

      Args:
        request: (ApigeeOrganizationsEnvironmentsKeystoresAliasesGetCertificateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleApiHttpBody) The response message.
      """
      config = self.GetMethodConfig('GetCertificate')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetCertificate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/keystores/{keystoresId}/aliases/{aliasesId}/certificate',
        http_method='GET',
        method_id='apigee.organizations.environments.keystores.aliases.getCertificate',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}/certificate',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsKeystoresAliasesGetCertificateRequest',
        response_type_name='GoogleApiHttpBody',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the certificate in an alias.

      Args:
        request: (ApigeeOrganizationsEnvironmentsKeystoresAliasesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Alias) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/keystores/{keystoresId}/aliases/{aliasesId}',
        http_method='PUT',
        method_id='apigee.organizations.environments.keystores.aliases.update',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['ignoreExpiryValidation', 'ignoreNewlineValidation'],
        relative_path='v1/{+name}',
        request_field='googleApiHttpBody',
        request_type_name='ApigeeOrganizationsEnvironmentsKeystoresAliasesUpdateRequest',
        response_type_name='GoogleCloudApigeeV1Alias',
        supports_download=False,
    )

  class OrganizationsEnvironmentsKeystoresService(base_api.BaseApiService):
    """Service class for the organizations_environments_keystores resource."""

    _NAME = 'organizations_environments_keystores'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsKeystoresService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a keystore or truststore:.
 * Keystore: Contains certificates and their associated keys.
 * Truststore: Contains trusted certificates used to validate a
 server's certificate. These certificates are typically self-signed
 certificates or certificates that are not signed by a trusted CA.

      Args:
        request: (ApigeeOrganizationsEnvironmentsKeystoresCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Keystore) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/keystores',
        http_method='POST',
        method_id='apigee.organizations.environments.keystores.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['name'],
        relative_path='v1/{+parent}/keystores',
        request_field='googleCloudApigeeV1Keystore',
        request_type_name='ApigeeOrganizationsEnvironmentsKeystoresCreateRequest',
        response_type_name='GoogleCloudApigeeV1Keystore',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a keystore or truststore.

      Args:
        request: (ApigeeOrganizationsEnvironmentsKeystoresDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Keystore) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/keystores/{keystoresId}',
        http_method='DELETE',
        method_id='apigee.organizations.environments.keystores.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsKeystoresDeleteRequest',
        response_type_name='GoogleCloudApigeeV1Keystore',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a keystore or truststore.

      Args:
        request: (ApigeeOrganizationsEnvironmentsKeystoresGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Keystore) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/keystores/{keystoresId}',
        http_method='GET',
        method_id='apigee.organizations.environments.keystores.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsKeystoresGetRequest',
        response_type_name='GoogleCloudApigeeV1Keystore',
        supports_download=False,
    )

  class OrganizationsEnvironmentsKeyvaluemapsService(base_api.BaseApiService):
    """Service class for the organizations_environments_keyvaluemaps resource."""

    _NAME = 'organizations_environments_keyvaluemaps'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsKeyvaluemapsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a key value map in an environment.

      Args:
        request: (ApigeeOrganizationsEnvironmentsKeyvaluemapsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1KeyValueMap) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/keyvaluemaps',
        http_method='POST',
        method_id='apigee.organizations.environments.keyvaluemaps.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/keyvaluemaps',
        request_field='googleCloudApigeeV1KeyValueMap',
        request_type_name='ApigeeOrganizationsEnvironmentsKeyvaluemapsCreateRequest',
        response_type_name='GoogleCloudApigeeV1KeyValueMap',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Delete a key value map in an environment.

      Args:
        request: (ApigeeOrganizationsEnvironmentsKeyvaluemapsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1KeyValueMap) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/keyvaluemaps/{keyvaluemapsId}',
        http_method='DELETE',
        method_id='apigee.organizations.environments.keyvaluemaps.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsKeyvaluemapsDeleteRequest',
        response_type_name='GoogleCloudApigeeV1KeyValueMap',
        supports_download=False,
    )

  class OrganizationsEnvironmentsOptimizedStatsService(base_api.BaseApiService):
    """Service class for the organizations_environments_optimizedStats resource."""

    _NAME = 'organizations_environments_optimizedStats'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsOptimizedStatsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""This api is similar to GetStats.
except that the response is less verbose.
In the current scheme, a query parameter _optimized instructs
Edge Analytics to change the response but since this behavior
is not possible with protocol buffer and since this parameter is
predominantly used by Edge UI, we are introducing a separate api.

      Args:
        request: (ApigeeOrganizationsEnvironmentsOptimizedStatsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1OptimizedStats) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/optimizedStats/{optimizedStatsId}',
        http_method='GET',
        method_id='apigee.organizations.environments.optimizedStats.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['accuracy', 'aggTable', 'filter', 'limit', 'offset', 'realtime', 'select', 'sonar', 'sort', 'sortby', 'timeRange', 'timeUnit', 'topk', 'tsAscending', 'tzo'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsOptimizedStatsGetRequest',
        response_type_name='GoogleCloudApigeeV1OptimizedStats',
        supports_download=False,
    )

  class OrganizationsEnvironmentsQueriesService(base_api.BaseApiService):
    """Service class for the organizations_environments_queries resource."""

    _NAME = 'organizations_environments_queries'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsQueriesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Submit a query to be processed in the background.
If the submission of the query succeeds, the API returns a 201 status and
an ID that refer to the query. In addition to the HTTP status 201, the
`state` of "enqueued" means that the request succeeded.

      Args:
        request: (ApigeeOrganizationsEnvironmentsQueriesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1AsyncQuery) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/queries',
        http_method='POST',
        method_id='apigee.organizations.environments.queries.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/queries',
        request_field='googleCloudApigeeV1Query',
        request_type_name='ApigeeOrganizationsEnvironmentsQueriesCreateRequest',
        response_type_name='GoogleCloudApigeeV1AsyncQuery',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Get query status.
If the query is still in progress, the `state` is set to "running"
After the query has completed successfully, `state` is set to "completed"

      Args:
        request: (ApigeeOrganizationsEnvironmentsQueriesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1AsyncQuery) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/queries/{queriesId}',
        http_method='GET',
        method_id='apigee.organizations.environments.queries.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsQueriesGetRequest',
        response_type_name='GoogleCloudApigeeV1AsyncQuery',
        supports_download=False,
    )

    def GetResult(self, request, global_params=None):
      r"""After the query is completed, use this API to retrieve the results.
If the request succeeds, and there is a non-zero result set, the result is
downloaded to the client as a zipped JSON file.
The name of the downloaded file will be:
  OfflineQueryResult-<query-id>.zip

Example: `OfflineQueryResult-9cfc0d85-0f30-46d6-ae6f-318d0cb961bd.zip`

      Args:
        request: (ApigeeOrganizationsEnvironmentsQueriesGetResultRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleApiHttpBody) The response message.
      """
      config = self.GetMethodConfig('GetResult')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetResult.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/queries/{queriesId}/result',
        http_method='GET',
        method_id='apigee.organizations.environments.queries.getResult',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsQueriesGetResultRequest',
        response_type_name='GoogleApiHttpBody',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Return a list of Asynchronous Queries.

      Args:
        request: (ApigeeOrganizationsEnvironmentsQueriesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListAsyncQueriesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/queries',
        http_method='GET',
        method_id='apigee.organizations.environments.queries.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['dataset', 'from_', 'inclQueriesWithoutReport', 'status', 'submittedBy', 'to'],
        relative_path='v1/{+parent}/queries',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsQueriesListRequest',
        response_type_name='GoogleCloudApigeeV1ListAsyncQueriesResponse',
        supports_download=False,
    )

  class OrganizationsEnvironmentsReferencesService(base_api.BaseApiService):
    """Service class for the organizations_environments_references resource."""

    _NAME = 'organizations_environments_references'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsReferencesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a Reference in the specified environment.

      Args:
        request: (ApigeeOrganizationsEnvironmentsReferencesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Reference) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/references',
        http_method='POST',
        method_id='apigee.organizations.environments.references.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/references',
        request_field='googleCloudApigeeV1Reference',
        request_type_name='ApigeeOrganizationsEnvironmentsReferencesCreateRequest',
        response_type_name='GoogleCloudApigeeV1Reference',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a Reference from an environment. Returns the deleted.
Reference resource.

      Args:
        request: (ApigeeOrganizationsEnvironmentsReferencesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Reference) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/references/{referencesId}',
        http_method='DELETE',
        method_id='apigee.organizations.environments.references.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsReferencesDeleteRequest',
        response_type_name='GoogleCloudApigeeV1Reference',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a Reference resource.

      Args:
        request: (ApigeeOrganizationsEnvironmentsReferencesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Reference) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/references/{referencesId}',
        http_method='GET',
        method_id='apigee.organizations.environments.references.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsReferencesGetRequest',
        response_type_name='GoogleCloudApigeeV1Reference',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an existing Reference. Note that this operation has PUT.
semantics; it will replace the entirety of the existing Reference with
the resource in the request body.

      Args:
        request: (GoogleCloudApigeeV1Reference) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Reference) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/references/{referencesId}',
        http_method='PUT',
        method_id='apigee.organizations.environments.references.update',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='<request>',
        request_type_name='GoogleCloudApigeeV1Reference',
        response_type_name='GoogleCloudApigeeV1Reference',
        supports_download=False,
    )

  class OrganizationsEnvironmentsResourcefilesService(base_api.BaseApiService):
    """Service class for the organizations_environments_resourcefiles resource."""

    _NAME = 'organizations_environments_resourcefiles'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsResourcefilesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a resource file.

Specify the `Content-Type` as `application/octet-stream` or
`multipart/form-data`.

For more information about resource files, see
[Resource files](/api-platform/develop/resource-files).

      Args:
        request: (ApigeeOrganizationsEnvironmentsResourcefilesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ResourceFile) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/resourcefiles',
        http_method='POST',
        method_id='apigee.organizations.environments.resourcefiles.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['name', 'type'],
        relative_path='v1/{+parent}/resourcefiles',
        request_field='googleApiHttpBody',
        request_type_name='ApigeeOrganizationsEnvironmentsResourcefilesCreateRequest',
        response_type_name='GoogleCloudApigeeV1ResourceFile',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a resource file.

For more information about resource files, see
[Resource files](/api-platform/develop/resource-files).

      Args:
        request: (ApigeeOrganizationsEnvironmentsResourcefilesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ResourceFile) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/resourcefiles/{type}/{name}',
        http_method='DELETE',
        method_id='apigee.organizations.environments.resourcefiles.delete',
        ordered_params=['parent', 'type', 'name'],
        path_params=['name', 'parent', 'type'],
        query_params=[],
        relative_path='v1/{+parent}/resourcefiles/{type}/{name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsResourcefilesDeleteRequest',
        response_type_name='GoogleCloudApigeeV1ResourceFile',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the contents of a resource file.

For more information about resource files, see
[Resource files](/api-platform/develop/resource-files).

      Args:
        request: (ApigeeOrganizationsEnvironmentsResourcefilesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleApiHttpBody) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/resourcefiles/{type}/{name}',
        http_method='GET',
        method_id='apigee.organizations.environments.resourcefiles.get',
        ordered_params=['parent', 'type', 'name'],
        path_params=['name', 'parent', 'type'],
        query_params=[],
        relative_path='v1/{+parent}/resourcefiles/{type}/{name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsResourcefilesGetRequest',
        response_type_name='GoogleApiHttpBody',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all resource files.

For more information about resource files, see
[Resource files](/api-platform/develop/resource-files).

      Args:
        request: (ApigeeOrganizationsEnvironmentsResourcefilesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListEnvironmentResourcesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/resourcefiles',
        http_method='GET',
        method_id='apigee.organizations.environments.resourcefiles.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['type'],
        relative_path='v1/{+parent}/resourcefiles',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsResourcefilesListRequest',
        response_type_name='GoogleCloudApigeeV1ListEnvironmentResourcesResponse',
        supports_download=False,
    )

    def ListEnvironmentResources(self, request, global_params=None):
      r"""Lists all resource files.

For more information about resource files, see
[Resource files](/api-platform/develop/resource-files).

      Args:
        request: (ApigeeOrganizationsEnvironmentsResourcefilesListEnvironmentResourcesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListEnvironmentResourcesResponse) The response message.
      """
      config = self.GetMethodConfig('ListEnvironmentResources')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListEnvironmentResources.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/resourcefiles/{type}',
        http_method='GET',
        method_id='apigee.organizations.environments.resourcefiles.listEnvironmentResources',
        ordered_params=['parent', 'type'],
        path_params=['parent', 'type'],
        query_params=[],
        relative_path='v1/{+parent}/resourcefiles/{type}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsResourcefilesListEnvironmentResourcesRequest',
        response_type_name='GoogleCloudApigeeV1ListEnvironmentResourcesResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a resource file.

Specify the `Content-Type` as `application/octet-stream` or
`multipart/form-data`.

For more information about resource files, see
[Resource files](/api-platform/develop/resource-files).

      Args:
        request: (ApigeeOrganizationsEnvironmentsResourcefilesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ResourceFile) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/resourcefiles/{type}/{name}',
        http_method='PUT',
        method_id='apigee.organizations.environments.resourcefiles.update',
        ordered_params=['parent', 'type', 'name'],
        path_params=['name', 'parent', 'type'],
        query_params=[],
        relative_path='v1/{+parent}/resourcefiles/{type}/{name}',
        request_field='googleApiHttpBody',
        request_type_name='ApigeeOrganizationsEnvironmentsResourcefilesUpdateRequest',
        response_type_name='GoogleCloudApigeeV1ResourceFile',
        supports_download=False,
    )

  class OrganizationsEnvironmentsSharedflowsDeploymentsService(base_api.BaseApiService):
    """Service class for the organizations_environments_sharedflows_deployments resource."""

    _NAME = 'organizations_environments_sharedflows_deployments'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsSharedflowsDeploymentsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists all deployments of a shared flow in an environment.

      Args:
        request: (ApigeeOrganizationsEnvironmentsSharedflowsDeploymentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListDeploymentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/sharedflows/{sharedflowsId}/deployments',
        http_method='GET',
        method_id='apigee.organizations.environments.sharedflows.deployments.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/deployments',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsSharedflowsDeploymentsListRequest',
        response_type_name='GoogleCloudApigeeV1ListDeploymentsResponse',
        supports_download=False,
    )

  class OrganizationsEnvironmentsSharedflowsRevisionsService(base_api.BaseApiService):
    """Service class for the organizations_environments_sharedflows_revisions resource."""

    _NAME = 'organizations_environments_sharedflows_revisions'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsSharedflowsRevisionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Deployments(self, request, global_params=None):
      r"""Undeploys a shared flow revision from an environment.

      Args:
        request: (ApigeeOrganizationsEnvironmentsSharedflowsRevisionsDeploymentsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Deployments')
      return self._RunMethod(
          config, request, global_params=global_params)

    Deployments.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/sharedflows/{sharedflowsId}/revisions/{revisionsId}/deployments',
        http_method='DELETE',
        method_id='apigee.organizations.environments.sharedflows.revisions.deployments',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}/deployments',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsSharedflowsRevisionsDeploymentsRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def GetDeployments(self, request, global_params=None):
      r"""Gets the deployment of a shared flow revision and actual state reported by.
runtime pods.

      Args:
        request: (ApigeeOrganizationsEnvironmentsSharedflowsRevisionsGetDeploymentsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Deployment) The response message.
      """
      config = self.GetMethodConfig('GetDeployments')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetDeployments.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/sharedflows/{sharedflowsId}/revisions/{revisionsId}/deployments',
        http_method='GET',
        method_id='apigee.organizations.environments.sharedflows.revisions.getDeployments',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}/deployments',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsSharedflowsRevisionsGetDeploymentsRequest',
        response_type_name='GoogleCloudApigeeV1Deployment',
        supports_download=False,
    )

  class OrganizationsEnvironmentsSharedflowsService(base_api.BaseApiService):
    """Service class for the organizations_environments_sharedflows resource."""

    _NAME = 'organizations_environments_sharedflows'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsSharedflowsService, self).__init__(client)
      self._upload_configs = {
          }

  class OrganizationsEnvironmentsStatsService(base_api.BaseApiService):
    """Service class for the organizations_environments_stats resource."""

    _NAME = 'organizations_environments_stats'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsStatsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Retrieve metrics grouped by dimensions.
The types of metrics you can retrieve include traffic, message counts,
API call latency, response size, and cache hits and counts.
Dimensions let you view metrics in meaningful groups.
The stats api does accept dimensions as path params. The dimensions are
optional in which case the metrics are computed on the entire data
for the given timerange.

      Args:
        request: (ApigeeOrganizationsEnvironmentsStatsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Stats) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/stats/{statsId}',
        http_method='GET',
        method_id='apigee.organizations.environments.stats.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['accuracy', 'aggTable', 'filter', 'limit', 'offset', 'realtime', 'select', 'sonar', 'sort', 'sortby', 'timeRange', 'timeUnit', 'topk', 'tsAscending', 'tzo'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsStatsGetRequest',
        response_type_name='GoogleCloudApigeeV1Stats',
        supports_download=False,
    )

  class OrganizationsEnvironmentsTargetserversService(base_api.BaseApiService):
    """Service class for the organizations_environments_targetservers resource."""

    _NAME = 'organizations_environments_targetservers'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsTargetserversService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a TargetServer in the specified environment.

      Args:
        request: (ApigeeOrganizationsEnvironmentsTargetserversCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1TargetServer) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/targetservers',
        http_method='POST',
        method_id='apigee.organizations.environments.targetservers.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['name'],
        relative_path='v1/{+parent}/targetservers',
        request_field='googleCloudApigeeV1TargetServer',
        request_type_name='ApigeeOrganizationsEnvironmentsTargetserversCreateRequest',
        response_type_name='GoogleCloudApigeeV1TargetServer',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a TargetServer from an environment. Returns the deleted.
TargetServer resource.

      Args:
        request: (ApigeeOrganizationsEnvironmentsTargetserversDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1TargetServer) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/targetservers/{targetserversId}',
        http_method='DELETE',
        method_id='apigee.organizations.environments.targetservers.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsTargetserversDeleteRequest',
        response_type_name='GoogleCloudApigeeV1TargetServer',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a TargetServer resource.

      Args:
        request: (ApigeeOrganizationsEnvironmentsTargetserversGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1TargetServer) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/targetservers/{targetserversId}',
        http_method='GET',
        method_id='apigee.organizations.environments.targetservers.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsTargetserversGetRequest',
        response_type_name='GoogleCloudApigeeV1TargetServer',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an existing TargetServer. Note that this operation has PUT.
semantics; it will replace the entirety of the existing TargetServer with
the resource in the request body.

      Args:
        request: (GoogleCloudApigeeV1TargetServer) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1TargetServer) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/targetservers/{targetserversId}',
        http_method='PUT',
        method_id='apigee.organizations.environments.targetservers.update',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='<request>',
        request_type_name='GoogleCloudApigeeV1TargetServer',
        response_type_name='GoogleCloudApigeeV1TargetServer',
        supports_download=False,
    )

  class OrganizationsEnvironmentsService(base_api.BaseApiService):
    """Service class for the organizations_environments resource."""

    _NAME = 'organizations_environments'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsEnvironmentsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an environment in an organization.

      Args:
        request: (ApigeeOrganizationsEnvironmentsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments',
        http_method='POST',
        method_id='apigee.organizations.environments.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['name'],
        relative_path='v1/{+parent}/environments',
        request_field='googleCloudApigeeV1Environment',
        request_type_name='ApigeeOrganizationsEnvironmentsCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an environment from an organization.

      Args:
        request: (ApigeeOrganizationsEnvironmentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}',
        http_method='DELETE',
        method_id='apigee.organizations.environments.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets environment details.

      Args:
        request: (ApigeeOrganizationsEnvironmentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Environment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}',
        http_method='GET',
        method_id='apigee.organizations.environments.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsGetRequest',
        response_type_name='GoogleCloudApigeeV1Environment',
        supports_download=False,
    )

    def GetDebugmask(self, request, global_params=None):
      r"""Gets the debug mask singleton resource for an environment.

      Args:
        request: (ApigeeOrganizationsEnvironmentsGetDebugmaskRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DebugMask) The response message.
      """
      config = self.GetMethodConfig('GetDebugmask')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetDebugmask.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/debugmask',
        http_method='GET',
        method_id='apigee.organizations.environments.getDebugmask',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsGetDebugmaskRequest',
        response_type_name='GoogleCloudApigeeV1DebugMask',
        supports_download=False,
    )

    def GetDeployedConfig(self, request, global_params=None):
      r"""Gets the deployed configuration for an environment.

      Args:
        request: (ApigeeOrganizationsEnvironmentsGetDeployedConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1EnvironmentConfig) The response message.
      """
      config = self.GetMethodConfig('GetDeployedConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetDeployedConfig.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/deployedConfig',
        http_method='GET',
        method_id='apigee.organizations.environments.getDeployedConfig',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsGetDeployedConfigRequest',
        response_type_name='GoogleCloudApigeeV1EnvironmentConfig',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the IAM policy on an environment. For more information, see.
[Manage users, roles, and permissions
using the API](https://docs.apigee.com/hybrid/latest/manage-users-roles).

You must have the `apigee.environments.getIamPolicy` permission to call
this API.

      Args:
        request: (ApigeeOrganizationsEnvironmentsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleIamV1Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}:getIamPolicy',
        http_method='GET',
        method_id='apigee.organizations.environments.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsGetIamPolicyRequest',
        response_type_name='GoogleIamV1Policy',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the IAM policy on an environment, if the policy already.
exists it will be replaced. For more information, see
[Manage users, roles, and permissions
using the API](https://docs.apigee.com/hybrid/latest/manage-users-roles).

You must have the `apigee.environments.setIamPolicy` permission to
call this API.

      Args:
        request: (ApigeeOrganizationsEnvironmentsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleIamV1Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}:setIamPolicy',
        http_method='POST',
        method_id='apigee.organizations.environments.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='googleIamV1SetIamPolicyRequest',
        request_type_name='ApigeeOrganizationsEnvironmentsSetIamPolicyRequest',
        response_type_name='GoogleIamV1Policy',
        supports_download=False,
    )

    def Subscribe(self, request, global_params=None):
      r"""Creates a subscription for the environment's Pub/Sub topic.
The server will assign a random name for this subscription.
The "name" and "push_config" must *not* be specified.

      Args:
        request: (ApigeeOrganizationsEnvironmentsSubscribeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Subscription) The response message.
      """
      config = self.GetMethodConfig('Subscribe')
      return self._RunMethod(
          config, request, global_params=global_params)

    Subscribe.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}:subscribe',
        http_method='POST',
        method_id='apigee.organizations.environments.subscribe',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}:subscribe',
        request_field='',
        request_type_name='ApigeeOrganizationsEnvironmentsSubscribeRequest',
        response_type_name='GoogleCloudApigeeV1Subscription',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Tests the permissions of a user on an environment,.
and returns a subset of permissions that the user has on the environment.
If the environment does not exist, an empty permission set is returned
(a NOT_FOUND error is not returned).

      Args:
        request: (ApigeeOrganizationsEnvironmentsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleIamV1TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}:testIamPermissions',
        http_method='POST',
        method_id='apigee.organizations.environments.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='googleIamV1TestIamPermissionsRequest',
        request_type_name='ApigeeOrganizationsEnvironmentsTestIamPermissionsRequest',
        response_type_name='GoogleIamV1TestIamPermissionsResponse',
        supports_download=False,
    )

    def Unsubscribe(self, request, global_params=None):
      r"""Deletes a subscription for the environment's Pub/Sub topic.

      Args:
        request: (ApigeeOrganizationsEnvironmentsUnsubscribeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleProtobufEmpty) The response message.
      """
      config = self.GetMethodConfig('Unsubscribe')
      return self._RunMethod(
          config, request, global_params=global_params)

    Unsubscribe.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}:unsubscribe',
        http_method='POST',
        method_id='apigee.organizations.environments.unsubscribe',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}:unsubscribe',
        request_field='googleCloudApigeeV1Subscription',
        request_type_name='ApigeeOrganizationsEnvironmentsUnsubscribeRequest',
        response_type_name='GoogleProtobufEmpty',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an existing environment.

When updating properties, you must pass all existing properties to the API,
even if they are not being changed. If you omit properties from the
payload, the properties are removed. To get the current list of
properties for the environment, use the [Get Environment API](get).

      Args:
        request: (GoogleCloudApigeeV1Environment) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Environment) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}',
        http_method='PUT',
        method_id='apigee.organizations.environments.update',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='<request>',
        request_type_name='GoogleCloudApigeeV1Environment',
        response_type_name='GoogleCloudApigeeV1Environment',
        supports_download=False,
    )

    def UpdateDebugmask(self, request, global_params=None):
      r"""Updates the debug mask singleton resource for an environment.

      Args:
        request: (ApigeeOrganizationsEnvironmentsUpdateDebugmaskRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DebugMask) The response message.
      """
      config = self.GetMethodConfig('UpdateDebugmask')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateDebugmask.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}/debugmask',
        http_method='PATCH',
        method_id='apigee.organizations.environments.updateDebugmask',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['replaceRepeatedFields', 'updateMask'],
        relative_path='v1/{+name}',
        request_field='googleCloudApigeeV1DebugMask',
        request_type_name='ApigeeOrganizationsEnvironmentsUpdateDebugmaskRequest',
        response_type_name='GoogleCloudApigeeV1DebugMask',
        supports_download=False,
    )

    def UpdateEnvironment(self, request, global_params=None):
      r"""Updates an existing environment.

When updating properties, you must pass all existing properties to the API,
even if they are not being changed. If you omit properties from the
payload, the properties are removed. To get the current list of
properties for the environment, use the [Get Environment API](get).

      Args:
        request: (GoogleCloudApigeeV1Environment) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Environment) The response message.
      """
      config = self.GetMethodConfig('UpdateEnvironment')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateEnvironment.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/environments/{environmentsId}',
        http_method='POST',
        method_id='apigee.organizations.environments.updateEnvironment',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='<request>',
        request_type_name='GoogleCloudApigeeV1Environment',
        response_type_name='GoogleCloudApigeeV1Environment',
        supports_download=False,
    )

  class OrganizationsInstancesAttachmentsService(base_api.BaseApiService):
    """Service class for the organizations_instances_attachments resource."""

    _NAME = 'organizations_instances_attachments'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsInstancesAttachmentsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new attachment of an environment to an instance.

**Note:** Not supported for Apigee hybrid.

      Args:
        request: (ApigeeOrganizationsInstancesAttachmentsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/instances/{instancesId}/attachments',
        http_method='POST',
        method_id='apigee.organizations.instances.attachments.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/attachments',
        request_field='googleCloudApigeeV1InstanceAttachment',
        request_type_name='ApigeeOrganizationsInstancesAttachmentsCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an attachment.

**Note:** Not supported for Apigee hybrid.

      Args:
        request: (ApigeeOrganizationsInstancesAttachmentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/instances/{instancesId}/attachments/{attachmentsId}',
        http_method='DELETE',
        method_id='apigee.organizations.instances.attachments.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsInstancesAttachmentsDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an attachment.

**Note:** Not supported for Apigee hybrid.

      Args:
        request: (ApigeeOrganizationsInstancesAttachmentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1InstanceAttachment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/instances/{instancesId}/attachments/{attachmentsId}',
        http_method='GET',
        method_id='apigee.organizations.instances.attachments.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsInstancesAttachmentsGetRequest',
        response_type_name='GoogleCloudApigeeV1InstanceAttachment',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all attachments to an instance.

**Note:** Not supported for Apigee hybrid.

      Args:
        request: (ApigeeOrganizationsInstancesAttachmentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListInstanceAttachmentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/instances/{instancesId}/attachments',
        http_method='GET',
        method_id='apigee.organizations.instances.attachments.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/attachments',
        request_field='',
        request_type_name='ApigeeOrganizationsInstancesAttachmentsListRequest',
        response_type_name='GoogleCloudApigeeV1ListInstanceAttachmentsResponse',
        supports_download=False,
    )

  class OrganizationsInstancesService(base_api.BaseApiService):
    """Service class for the organizations_instances resource."""

    _NAME = 'organizations_instances'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsInstancesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an Apigee runtime instance. The instance is accessible from the.
authorized network configured on the organization.

**Note:** Not supported for Apigee hybrid.

      Args:
        request: (ApigeeOrganizationsInstancesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/instances',
        http_method='POST',
        method_id='apigee.organizations.instances.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/instances',
        request_field='googleCloudApigeeV1Instance',
        request_type_name='ApigeeOrganizationsInstancesCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an Apigee runtime instance. The instance stops serving.
requests and the runtime data is deleted.

**Note:** Not supported for Apigee hybrid.

      Args:
        request: (ApigeeOrganizationsInstancesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/instances/{instancesId}',
        http_method='DELETE',
        method_id='apigee.organizations.instances.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsInstancesDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the details for an Apigee runtime instance.

**Note:** Not supported for Apigee hybrid.

      Args:
        request: (ApigeeOrganizationsInstancesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Instance) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/instances/{instancesId}',
        http_method='GET',
        method_id='apigee.organizations.instances.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsInstancesGetRequest',
        response_type_name='GoogleCloudApigeeV1Instance',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all Apigee runtime instances for the organization.

**Note:** Not supported for Apigee hybrid.

      Args:
        request: (ApigeeOrganizationsInstancesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListInstancesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/instances',
        http_method='GET',
        method_id='apigee.organizations.instances.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/instances',
        request_field='',
        request_type_name='ApigeeOrganizationsInstancesListRequest',
        response_type_name='GoogleCloudApigeeV1ListInstancesResponse',
        supports_download=False,
    )

    def ReportStatus(self, request, global_params=None):
      r"""Reports the latest status for a runtime instance.

      Args:
        request: (ApigeeOrganizationsInstancesReportStatusRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ReportInstanceStatusResponse) The response message.
      """
      config = self.GetMethodConfig('ReportStatus')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReportStatus.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/instances/{instancesId}:reportStatus',
        http_method='POST',
        method_id='apigee.organizations.instances.reportStatus',
        ordered_params=['instance'],
        path_params=['instance'],
        query_params=[],
        relative_path='v1/{+instance}:reportStatus',
        request_field='googleCloudApigeeV1ReportInstanceStatusRequest',
        request_type_name='ApigeeOrganizationsInstancesReportStatusRequest',
        response_type_name='GoogleCloudApigeeV1ReportInstanceStatusResponse',
        supports_download=False,
    )

  class OrganizationsKeyvaluemapsService(base_api.BaseApiService):
    """Service class for the organizations_keyvaluemaps resource."""

    _NAME = 'organizations_keyvaluemaps'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsKeyvaluemapsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a key value map in an organization.

      Args:
        request: (ApigeeOrganizationsKeyvaluemapsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1KeyValueMap) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/keyvaluemaps',
        http_method='POST',
        method_id='apigee.organizations.keyvaluemaps.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/keyvaluemaps',
        request_field='googleCloudApigeeV1KeyValueMap',
        request_type_name='ApigeeOrganizationsKeyvaluemapsCreateRequest',
        response_type_name='GoogleCloudApigeeV1KeyValueMap',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Delete a key value map in an organization.

      Args:
        request: (ApigeeOrganizationsKeyvaluemapsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1KeyValueMap) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/keyvaluemaps/{keyvaluemapsId}',
        http_method='DELETE',
        method_id='apigee.organizations.keyvaluemaps.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsKeyvaluemapsDeleteRequest',
        response_type_name='GoogleCloudApigeeV1KeyValueMap',
        supports_download=False,
    )

  class OrganizationsOperationsService(base_api.BaseApiService):
    """Service class for the organizations_operations resource."""

    _NAME = 'organizations_operations'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (ApigeeOrganizationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='apigee.organizations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsOperationsGetRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the.
server doesn't support this method, it returns `UNIMPLEMENTED`.

NOTE: the `name` binding allows API services to override the binding
to use different resource name schemes, such as `users/*/operations`. To
override the binding, API services can add a binding such as
`"/v1/{name=users/*}/operations"` to their service configuration.
For backwards compatibility, the default name includes the operations
collection id, however overriding users must ensure the name binding
is the parent resource, without the operations collection id.

      Args:
        request: (ApigeeOrganizationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/operations',
        http_method='GET',
        method_id='apigee.organizations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+name}/operations',
        request_field='',
        request_type_name='ApigeeOrganizationsOperationsListRequest',
        response_type_name='GoogleLongrunningListOperationsResponse',
        supports_download=False,
    )

  class OrganizationsReportsService(base_api.BaseApiService):
    """Service class for the organizations_reports resource."""

    _NAME = 'organizations_reports'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsReportsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a Custom Report for an Organization. A Custom Report.
provides Apigee Customers to create custom dashboards in addition
to the standard dashboards which are provided. The Custom Report in its
simplest form contains specifications about metrics, dimensions and
filters. It is important to note that the custom report by itself does not
provide an executable entity. The Edge UI converts the custom report
definition into an analytics query and displays the result in a chart.

      Args:
        request: (ApigeeOrganizationsReportsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1CustomReport) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/reports',
        http_method='POST',
        method_id='apigee.organizations.reports.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/reports',
        request_field='googleCloudApigeeV1CustomReport',
        request_type_name='ApigeeOrganizationsReportsCreateRequest',
        response_type_name='GoogleCloudApigeeV1CustomReport',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an existing custom report definition.

      Args:
        request: (ApigeeOrganizationsReportsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1DeleteCustomReportResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/reports/{reportsId}',
        http_method='DELETE',
        method_id='apigee.organizations.reports.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsReportsDeleteRequest',
        response_type_name='GoogleCloudApigeeV1DeleteCustomReportResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Retrieve a custom report definition.

      Args:
        request: (ApigeeOrganizationsReportsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1CustomReport) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/reports/{reportsId}',
        http_method='GET',
        method_id='apigee.organizations.reports.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsReportsGetRequest',
        response_type_name='GoogleCloudApigeeV1CustomReport',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Return a list of Custom Reports.

      Args:
        request: (ApigeeOrganizationsReportsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListCustomReportsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/reports',
        http_method='GET',
        method_id='apigee.organizations.reports.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['expand'],
        relative_path='v1/{+parent}/reports',
        request_field='',
        request_type_name='ApigeeOrganizationsReportsListRequest',
        response_type_name='GoogleCloudApigeeV1ListCustomReportsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Update an existing custom report definition.

      Args:
        request: (GoogleCloudApigeeV1CustomReport) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1CustomReport) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/reports/{reportsId}',
        http_method='PUT',
        method_id='apigee.organizations.reports.update',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='<request>',
        request_type_name='GoogleCloudApigeeV1CustomReport',
        response_type_name='GoogleCloudApigeeV1CustomReport',
        supports_download=False,
    )

  class OrganizationsSharedflowsDeploymentsService(base_api.BaseApiService):
    """Service class for the organizations_sharedflows_deployments resource."""

    _NAME = 'organizations_sharedflows_deployments'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsSharedflowsDeploymentsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists all deployments of a shared flow.

      Args:
        request: (ApigeeOrganizationsSharedflowsDeploymentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListDeploymentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sharedflows/{sharedflowsId}/deployments',
        http_method='GET',
        method_id='apigee.organizations.sharedflows.deployments.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/deployments',
        request_field='',
        request_type_name='ApigeeOrganizationsSharedflowsDeploymentsListRequest',
        response_type_name='GoogleCloudApigeeV1ListDeploymentsResponse',
        supports_download=False,
    )

  class OrganizationsSharedflowsRevisionsDeploymentsService(base_api.BaseApiService):
    """Service class for the organizations_sharedflows_revisions_deployments resource."""

    _NAME = 'organizations_sharedflows_revisions_deployments'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsSharedflowsRevisionsDeploymentsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists all deployments of a shared flow revision.

      Args:
        request: (ApigeeOrganizationsSharedflowsRevisionsDeploymentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListDeploymentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sharedflows/{sharedflowsId}/revisions/{revisionsId}/deployments',
        http_method='GET',
        method_id='apigee.organizations.sharedflows.revisions.deployments.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}/deployments',
        request_field='',
        request_type_name='ApigeeOrganizationsSharedflowsRevisionsDeploymentsListRequest',
        response_type_name='GoogleCloudApigeeV1ListDeploymentsResponse',
        supports_download=False,
    )

  class OrganizationsSharedflowsRevisionsService(base_api.BaseApiService):
    """Service class for the organizations_sharedflows_revisions resource."""

    _NAME = 'organizations_sharedflows_revisions'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsSharedflowsRevisionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes a shared flow and all associated policies, resources, and.
revisions. You must undeploy the shared flow before deleting it.

      Args:
        request: (ApigeeOrganizationsSharedflowsRevisionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1SharedFlowRevision) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sharedflows/{sharedflowsId}/revisions/{revisionsId}',
        http_method='DELETE',
        method_id='apigee.organizations.sharedflows.revisions.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsSharedflowsRevisionsDeleteRequest',
        response_type_name='GoogleCloudApigeeV1SharedFlowRevision',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a revision of a shared flow.

If `format=bundle` is passed, it instead outputs a shared flow revision as
a ZIP-formatted bundle of code and config files.

      Args:
        request: (ApigeeOrganizationsSharedflowsRevisionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleApiHttpBody) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sharedflows/{sharedflowsId}/revisions/{revisionsId}',
        http_method='GET',
        method_id='apigee.organizations.sharedflows.revisions.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['format'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsSharedflowsRevisionsGetRequest',
        response_type_name='GoogleApiHttpBody',
        supports_download=False,
    )

    def UpdateSharedFlowRevision(self, request, global_params=None):
      r"""Updates a shared flow revision. This operation is only allowed on revisions.
which have never been deployed. After deployment a revision becomes
immutable, even if it becomes undeployed.

The payload is a ZIP-formatted shared flow.  Content type must be either
multipart/form-data or application/octet-stream.

      Args:
        request: (ApigeeOrganizationsSharedflowsRevisionsUpdateSharedFlowRevisionRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1SharedFlowRevision) The response message.
      """
      config = self.GetMethodConfig('UpdateSharedFlowRevision')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateSharedFlowRevision.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sharedflows/{sharedflowsId}/revisions/{revisionsId}',
        http_method='POST',
        method_id='apigee.organizations.sharedflows.revisions.updateSharedFlowRevision',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['validate'],
        relative_path='v1/{+name}',
        request_field='googleApiHttpBody',
        request_type_name='ApigeeOrganizationsSharedflowsRevisionsUpdateSharedFlowRevisionRequest',
        response_type_name='GoogleCloudApigeeV1SharedFlowRevision',
        supports_download=False,
    )

  class OrganizationsSharedflowsService(base_api.BaseApiService):
    """Service class for the organizations_sharedflows resource."""

    _NAME = 'organizations_sharedflows'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsSharedflowsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Uploads a ZIP-formatted shared flow configuration bundle to an.
organization. If the shared flow already exists, this creates a new
revision of it. If the shared flow does not exist, this creates it.

Once imported, the shared flow revision must be deployed before it can be
accessed at runtime.

The size limit of a shared flow bundle is 15 MB.

      Args:
        request: (ApigeeOrganizationsSharedflowsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1SharedFlowRevision) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sharedflows',
        http_method='POST',
        method_id='apigee.organizations.sharedflows.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['action', 'name'],
        relative_path='v1/{+parent}/sharedflows',
        request_field='googleApiHttpBody',
        request_type_name='ApigeeOrganizationsSharedflowsCreateRequest',
        response_type_name='GoogleCloudApigeeV1SharedFlowRevision',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a shared flow and all it's revisions. The shared flow must be.
undeployed before you can delete it.

      Args:
        request: (ApigeeOrganizationsSharedflowsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1SharedFlow) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sharedflows/{sharedflowsId}',
        http_method='DELETE',
        method_id='apigee.organizations.sharedflows.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsSharedflowsDeleteRequest',
        response_type_name='GoogleCloudApigeeV1SharedFlow',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a shared flow by name, including a list of its revisions.

      Args:
        request: (ApigeeOrganizationsSharedflowsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1SharedFlow) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sharedflows/{sharedflowsId}',
        http_method='GET',
        method_id='apigee.organizations.sharedflows.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsSharedflowsGetRequest',
        response_type_name='GoogleCloudApigeeV1SharedFlow',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all shared flows in the organization.

      Args:
        request: (ApigeeOrganizationsSharedflowsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListSharedFlowsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/sharedflows',
        http_method='GET',
        method_id='apigee.organizations.sharedflows.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['includeMetaData', 'includeRevisions'],
        relative_path='v1/{+parent}/sharedflows',
        request_field='',
        request_type_name='ApigeeOrganizationsSharedflowsListRequest',
        response_type_name='GoogleCloudApigeeV1ListSharedFlowsResponse',
        supports_download=False,
    )

  class OrganizationsService(base_api.BaseApiService):
    """Service class for the organizations resource."""

    _NAME = 'organizations'

    def __init__(self, client):
      super(ApigeeV1.OrganizationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an Apigee organization. See.
[Create an
organization](https://docs.apigee.com/hybrid/latest/precog-provision).

      Args:
        request: (ApigeeOrganizationsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='apigee.organizations.create',
        ordered_params=[],
        path_params=[],
        query_params=['parent'],
        relative_path='v1/organizations',
        request_field='googleCloudApigeeV1Organization',
        request_type_name='ApigeeOrganizationsCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the profile for an Apigee organization.
See
[Organizations](https://docs.apigee.com/hybrid/latest/terminology#organizations).

      Args:
        request: (ApigeeOrganizationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Organization) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}',
        http_method='GET',
        method_id='apigee.organizations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsGetRequest',
        response_type_name='GoogleCloudApigeeV1Organization',
        supports_download=False,
    )

    def GetDeployedIngressConfig(self, request, global_params=None):
      r"""Gets the deployed ingress configuration for an organization.

      Args:
        request: (ApigeeOrganizationsGetDeployedIngressConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1IngressConfig) The response message.
      """
      config = self.GetMethodConfig('GetDeployedIngressConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetDeployedIngressConfig.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}/deployedIngressConfig',
        http_method='GET',
        method_id='apigee.organizations.getDeployedIngressConfig',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ApigeeOrganizationsGetDeployedIngressConfigRequest',
        response_type_name='GoogleCloudApigeeV1IngressConfig',
        supports_download=False,
    )

    def GetSyncAuthorization(self, request, global_params=None):
      r"""Lists the service accounts with the permissions required to allow.
the Synchronizer to download environment data from the control plane.

An ETag is returned in the response to `getSyncAuthorization`.
Pass that ETag when calling [setSyncAuthorization](setSyncAuthorization)
to ensure that you are updating the correct version. If you don't pass the
ETag in the call to `setSyncAuthorization`, then the existing authorization
is overwritten indiscriminately.

For more information, see
[Enable Synchronizer
access](https://docs.apigee.com/hybrid/latest/synchronizer-access#enable-synchronizer-access).

**Note**: Available to Apigee hybrid only.

      Args:
        request: (ApigeeOrganizationsGetSyncAuthorizationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1SyncAuthorization) The response message.
      """
      config = self.GetMethodConfig('GetSyncAuthorization')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetSyncAuthorization.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}:getSyncAuthorization',
        http_method='POST',
        method_id='apigee.organizations.getSyncAuthorization',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:getSyncAuthorization',
        request_field='googleCloudApigeeV1GetSyncAuthorizationRequest',
        request_type_name='ApigeeOrganizationsGetSyncAuthorizationRequest',
        response_type_name='GoogleCloudApigeeV1SyncAuthorization',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the Apigee organizations and associated GCP projects that you have.
permission to access. See
[Organizations](https://docs.apigee.com/hybrid/latest/terminology#organizations).

      Args:
        request: (ApigeeOrganizationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1ListOrganizationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations',
        http_method='GET',
        method_id='apigee.organizations.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1/{+parent}',
        request_field='',
        request_type_name='ApigeeOrganizationsListRequest',
        response_type_name='GoogleCloudApigeeV1ListOrganizationsResponse',
        supports_download=False,
    )

    def SetSyncAuthorization(self, request, global_params=None):
      r"""Sets the permissions required to allow the Synchronizer to download.
environment data from the control plane. You must call this API to enable
proper functioning of hybrid.

Pass the ETag when calling `setSyncAuthorization` to ensure that
you are updating the correct version. To get an ETag,
call [getSyncAuthorization](getSyncAuthorization).
If you don't pass the ETag in the call to `setSyncAuthorization`, then the
existing authorization is overwritten indiscriminately.

For more information, see
[Enable Synchronizer
access](https://docs.apigee.com/hybrid/latest/synchronizer-access#enable-synchronizer-access).

**Note**: Available to Apigee hybrid only.

      Args:
        request: (ApigeeOrganizationsSetSyncAuthorizationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1SyncAuthorization) The response message.
      """
      config = self.GetMethodConfig('SetSyncAuthorization')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetSyncAuthorization.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}:setSyncAuthorization',
        http_method='POST',
        method_id='apigee.organizations.setSyncAuthorization',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:setSyncAuthorization',
        request_field='googleCloudApigeeV1SyncAuthorization',
        request_type_name='ApigeeOrganizationsSetSyncAuthorizationRequest',
        response_type_name='GoogleCloudApigeeV1SyncAuthorization',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the properties for an Apigee organization. No other fields in the.
organization profile will be updated.

      Args:
        request: (GoogleCloudApigeeV1Organization) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudApigeeV1Organization) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/organizations/{organizationsId}',
        http_method='PUT',
        method_id='apigee.organizations.update',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='<request>',
        request_type_name='GoogleCloudApigeeV1Organization',
        response_type_name='GoogleCloudApigeeV1Organization',
        supports_download=False,
    )
