"""Generated message classes for containeranalysis version v1.

An implementation of the Grafeas API, which stores, and enables querying and
retrieval of critical metadata about all of your software artifacts.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'containeranalysis'


class AliasContext(_messages.Message):
  r"""An alias to a repo revision.

  Enums:
    KindValueValuesEnum: The alias kind.

  Fields:
    kind: The alias kind.
    name: The alias name.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""The alias kind.

    Values:
      KIND_UNSPECIFIED: Unknown.
      FIXED: Git tag.
      MOVABLE: Git branch.
      OTHER: Used to specify non-standard aliases. For example, if a Git repo
        has a ref named "refs/foo/bar".
    """
    KIND_UNSPECIFIED = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  kind = _messages.EnumField('KindValueValuesEnum', 1)
  name = _messages.StringField(2)


class Artifact(_messages.Message):
  r"""Artifact describes a build product.

  Fields:
    checksum: Hash or checksum value of a binary, or Docker Registry 2.0
      digest of a container.
    id: Artifact ID, if any; for container images, this will be a URL by
      digest like `gcr.io/projectID/imagename@sha256:123456`.
    names: Related artifact names. This may be the path to a binary or jar
      file, or in the case of a container build, the name used to push the
      container image to Google Container Registry, as presented to `docker
      push`. Note that a single Artifact ID can have multiple names, for
      example if two tags are applied to one image.
  """

  checksum = _messages.StringField(1)
  id = _messages.StringField(2)
  names = _messages.StringField(3, repeated=True)


class AttestationNote(_messages.Message):
  r"""Note kind that represents a logical attestation "role" or "authority".
  For example, an organization might have one `Authority` for "QA" and one for
  "build". This note is intended to act strictly as a grouping mechanism for
  the attached occurrences (Attestations). This grouping mechanism also
  provides a security boundary, since IAM ACLs gate the ability for a
  principle to attach an occurrence to a given note. It also provides a single
  point of lookup to find all attached attestation occurrences, even if they
  don't all live in the same project.

  Fields:
    hint: Hint hints at the purpose of the attestation authority.
  """

  hint = _messages.MessageField('Hint', 1)


class AttestationOccurrence(_messages.Message):
  r"""Occurrence that represents a single "attestation". The authenticity of
  an attestation can be verified using the attached signature. If the verifier
  trusts the public key of the signer, then verifying the signature is
  sufficient to establish trust. In this circumstance, the authority to which
  this attestation is attached is primarily useful for lookup (how to find
  this attestation if you already know the authority and artifact to be
  verified) and intent (for which authority this attestation was intended to
  sign.

  Fields:
    serializedPayload: Required. The serialized payload that is verified by
      one or more `signatures`.
    signatures: One or more signatures over `serialized_payload`.  Verifier
      implementations should consider this attestation message verified if at
      least one `signature` verifies `serialized_payload`.  See `Signature` in
      common.proto for more details on signature structure and verification.
  """

  serializedPayload = _messages.BytesField(1)
  signatures = _messages.MessageField('Signature', 2, repeated=True)


class BatchCreateNotesRequest(_messages.Message):
  r"""Request to create notes in batch.

  Messages:
    NotesValue: The notes to create. Max allowed length is 1000.

  Fields:
    notes: The notes to create. Max allowed length is 1000.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class NotesValue(_messages.Message):
    r"""The notes to create. Max allowed length is 1000.

    Messages:
      AdditionalProperty: An additional property for a NotesValue object.

    Fields:
      additionalProperties: Additional properties of type NotesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a NotesValue object.

      Fields:
        key: Name of the additional property.
        value: A Note attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Note', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  notes = _messages.MessageField('NotesValue', 1)


class BatchCreateNotesResponse(_messages.Message):
  r"""Response for creating notes in batch.

  Fields:
    notes: The notes that were created.
  """

  notes = _messages.MessageField('Note', 1, repeated=True)


class BatchCreateOccurrencesRequest(_messages.Message):
  r"""Request to create occurrences in batch.

  Fields:
    occurrences: The occurrences to create. Max allowed length is 1000.
  """

  occurrences = _messages.MessageField('Occurrence', 1, repeated=True)


class BatchCreateOccurrencesResponse(_messages.Message):
  r"""Response for creating occurrences in batch.

  Fields:
    occurrences: The occurrences that were created.
  """

  occurrences = _messages.MessageField('Occurrence', 1, repeated=True)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. NOTE: An
      unsatisfied condition will not allow user access via current binding.
      Different bindings, including their conditions, are examined
      independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example,
      `alice@example.com` .   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.  *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example,`alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding.  *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus    unique identifier) representing a service account that has been
      recently    deleted. For example,    `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`.    If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding.  * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique    identifier) representing a Google group
      that has been recently    deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If    the group is
      recovered, this value reverts to `group:{emailid}` and the    recovered
      group retains the role in the binding.   * `domain:{domain}`: The G
      Suite domain (primary) that represents all the    users of that domain.
      For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class BuildNote(_messages.Message):
  r"""Note holding the version of the provider's builder and the signature of
  the provenance message in the build details occurrence.

  Fields:
    builderVersion: Required. Immutable. Version of the builder which produced
      this build.
  """

  builderVersion = _messages.StringField(1)


class BuildOccurrence(_messages.Message):
  r"""Details of a build occurrence.

  Fields:
    provenance: Required. The actual provenance for the build.
    provenanceBytes: Serialized JSON representation of the provenance, used in
      generating the build signature in the corresponding build note. After
      verifying the signature, `provenance_bytes` can be unmarshalled and
      compared to the provenance to confirm that it is unchanged. A
      base64-encoded string representation of the provenance bytes is used for
      the signature in order to interoperate with openssl which expects this
      format for signature verification.  The serialized form is captured both
      to avoid ambiguity in how the provenance is marshalled to json as well
      to prevent incompatibilities with future changes.
  """

  provenance = _messages.MessageField('BuildProvenance', 1)
  provenanceBytes = _messages.StringField(2)


class BuildProvenance(_messages.Message):
  r"""Provenance of a build. Contains all information needed to verify the
  full details about the build from source to completion.

  Messages:
    BuildOptionsValue: Special options applied to this build. This is a catch-
      all field where build providers can enter any desired additional
      details.

  Fields:
    buildOptions: Special options applied to this build. This is a catch-all
      field where build providers can enter any desired additional details.
    builderVersion: Version string of the builder at the time this build was
      executed.
    builtArtifacts: Output of the build.
    commands: Commands requested by the build.
    createTime: Time at which the build was created.
    creator: E-mail address of the user who initiated this build. Note that
      this was the user's e-mail address at the time the build was initiated;
      this address may not represent the same end-user for all time.
    endTime: Time at which execution of the build was finished.
    id: Required. Unique identifier of the build.
    logsUri: URI where any logs for this provenance were written.
    projectId: ID of the project.
    sourceProvenance: Details of the Source input to the build.
    startTime: Time at which execution of the build was started.
    triggerId: Trigger identifier if the build was triggered automatically;
      empty if not.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class BuildOptionsValue(_messages.Message):
    r"""Special options applied to this build. This is a catch-all field where
    build providers can enter any desired additional details.

    Messages:
      AdditionalProperty: An additional property for a BuildOptionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type BuildOptionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a BuildOptionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  buildOptions = _messages.MessageField('BuildOptionsValue', 1)
  builderVersion = _messages.StringField(2)
  builtArtifacts = _messages.MessageField('Artifact', 3, repeated=True)
  commands = _messages.MessageField('Command', 4, repeated=True)
  createTime = _messages.StringField(5)
  creator = _messages.StringField(6)
  endTime = _messages.StringField(7)
  id = _messages.StringField(8)
  logsUri = _messages.StringField(9)
  projectId = _messages.StringField(10)
  sourceProvenance = _messages.MessageField('Source', 11)
  startTime = _messages.StringField(12)
  triggerId = _messages.StringField(13)


class CVSSv3(_messages.Message):
  r"""Common Vulnerability Scoring System version 3. For details, see
  https://www.first.org/cvss/specification-document

  Enums:
    AttackComplexityValueValuesEnum:
    AttackVectorValueValuesEnum: Base Metrics Represents the intrinsic
      characteristics of a vulnerability that are constant over time and
      across user environments.
    AvailabilityImpactValueValuesEnum:
    ConfidentialityImpactValueValuesEnum:
    IntegrityImpactValueValuesEnum:
    PrivilegesRequiredValueValuesEnum:
    ScopeValueValuesEnum:
    UserInteractionValueValuesEnum:

  Fields:
    attackComplexity: A AttackComplexityValueValuesEnum attribute.
    attackVector: Base Metrics Represents the intrinsic characteristics of a
      vulnerability that are constant over time and across user environments.
    availabilityImpact: A AvailabilityImpactValueValuesEnum attribute.
    baseScore: The base score is a function of the base metric scores.
    confidentialityImpact: A ConfidentialityImpactValueValuesEnum attribute.
    exploitabilityScore: A number attribute.
    impactScore: A number attribute.
    integrityImpact: A IntegrityImpactValueValuesEnum attribute.
    privilegesRequired: A PrivilegesRequiredValueValuesEnum attribute.
    scope: A ScopeValueValuesEnum attribute.
    userInteraction: A UserInteractionValueValuesEnum attribute.
  """

  class AttackComplexityValueValuesEnum(_messages.Enum):
    r"""AttackComplexityValueValuesEnum enum type.

    Values:
      ATTACK_COMPLEXITY_UNSPECIFIED: <no description>
      ATTACK_COMPLEXITY_LOW: <no description>
      ATTACK_COMPLEXITY_HIGH: <no description>
    """
    ATTACK_COMPLEXITY_UNSPECIFIED = 0
    ATTACK_COMPLEXITY_LOW = 1
    ATTACK_COMPLEXITY_HIGH = 2

  class AttackVectorValueValuesEnum(_messages.Enum):
    r"""Base Metrics Represents the intrinsic characteristics of a
    vulnerability that are constant over time and across user environments.

    Values:
      ATTACK_VECTOR_UNSPECIFIED: <no description>
      ATTACK_VECTOR_NETWORK: <no description>
      ATTACK_VECTOR_ADJACENT: <no description>
      ATTACK_VECTOR_LOCAL: <no description>
      ATTACK_VECTOR_PHYSICAL: <no description>
    """
    ATTACK_VECTOR_UNSPECIFIED = 0
    ATTACK_VECTOR_NETWORK = 1
    ATTACK_VECTOR_ADJACENT = 2
    ATTACK_VECTOR_LOCAL = 3
    ATTACK_VECTOR_PHYSICAL = 4

  class AvailabilityImpactValueValuesEnum(_messages.Enum):
    r"""AvailabilityImpactValueValuesEnum enum type.

    Values:
      IMPACT_UNSPECIFIED: <no description>
      IMPACT_HIGH: <no description>
      IMPACT_LOW: <no description>
      IMPACT_NONE: <no description>
    """
    IMPACT_UNSPECIFIED = 0
    IMPACT_HIGH = 1
    IMPACT_LOW = 2
    IMPACT_NONE = 3

  class ConfidentialityImpactValueValuesEnum(_messages.Enum):
    r"""ConfidentialityImpactValueValuesEnum enum type.

    Values:
      IMPACT_UNSPECIFIED: <no description>
      IMPACT_HIGH: <no description>
      IMPACT_LOW: <no description>
      IMPACT_NONE: <no description>
    """
    IMPACT_UNSPECIFIED = 0
    IMPACT_HIGH = 1
    IMPACT_LOW = 2
    IMPACT_NONE = 3

  class IntegrityImpactValueValuesEnum(_messages.Enum):
    r"""IntegrityImpactValueValuesEnum enum type.

    Values:
      IMPACT_UNSPECIFIED: <no description>
      IMPACT_HIGH: <no description>
      IMPACT_LOW: <no description>
      IMPACT_NONE: <no description>
    """
    IMPACT_UNSPECIFIED = 0
    IMPACT_HIGH = 1
    IMPACT_LOW = 2
    IMPACT_NONE = 3

  class PrivilegesRequiredValueValuesEnum(_messages.Enum):
    r"""PrivilegesRequiredValueValuesEnum enum type.

    Values:
      PRIVILEGES_REQUIRED_UNSPECIFIED: <no description>
      PRIVILEGES_REQUIRED_NONE: <no description>
      PRIVILEGES_REQUIRED_LOW: <no description>
      PRIVILEGES_REQUIRED_HIGH: <no description>
    """
    PRIVILEGES_REQUIRED_UNSPECIFIED = 0
    PRIVILEGES_REQUIRED_NONE = 1
    PRIVILEGES_REQUIRED_LOW = 2
    PRIVILEGES_REQUIRED_HIGH = 3

  class ScopeValueValuesEnum(_messages.Enum):
    r"""ScopeValueValuesEnum enum type.

    Values:
      SCOPE_UNSPECIFIED: <no description>
      SCOPE_UNCHANGED: <no description>
      SCOPE_CHANGED: <no description>
    """
    SCOPE_UNSPECIFIED = 0
    SCOPE_UNCHANGED = 1
    SCOPE_CHANGED = 2

  class UserInteractionValueValuesEnum(_messages.Enum):
    r"""UserInteractionValueValuesEnum enum type.

    Values:
      USER_INTERACTION_UNSPECIFIED: <no description>
      USER_INTERACTION_NONE: <no description>
      USER_INTERACTION_REQUIRED: <no description>
    """
    USER_INTERACTION_UNSPECIFIED = 0
    USER_INTERACTION_NONE = 1
    USER_INTERACTION_REQUIRED = 2

  attackComplexity = _messages.EnumField('AttackComplexityValueValuesEnum', 1)
  attackVector = _messages.EnumField('AttackVectorValueValuesEnum', 2)
  availabilityImpact = _messages.EnumField('AvailabilityImpactValueValuesEnum', 3)
  baseScore = _messages.FloatField(4, variant=_messages.Variant.FLOAT)
  confidentialityImpact = _messages.EnumField('ConfidentialityImpactValueValuesEnum', 5)
  exploitabilityScore = _messages.FloatField(6, variant=_messages.Variant.FLOAT)
  impactScore = _messages.FloatField(7, variant=_messages.Variant.FLOAT)
  integrityImpact = _messages.EnumField('IntegrityImpactValueValuesEnum', 8)
  privilegesRequired = _messages.EnumField('PrivilegesRequiredValueValuesEnum', 9)
  scope = _messages.EnumField('ScopeValueValuesEnum', 10)
  userInteraction = _messages.EnumField('UserInteractionValueValuesEnum', 11)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloudRepoSourceContext(_messages.Message):
  r"""A CloudRepoSourceContext denotes a particular revision in a Google Cloud
  Source Repo.

  Fields:
    aliasContext: An alias, which may be a branch or tag.
    repoId: The ID of the repo.
    revisionId: A revision ID.
  """

  aliasContext = _messages.MessageField('AliasContext', 1)
  repoId = _messages.MessageField('RepoId', 2)
  revisionId = _messages.StringField(3)


class Command(_messages.Message):
  r"""Command describes a step performed as part of the build pipeline.

  Fields:
    args: Command-line arguments used when executing this command.
    dir: Working directory (relative to project source root) used when running
      this command.
    env: Environment variables set before running this command.
    id: Optional unique identifier for this command, used in wait_for to
      reference this command as a dependency.
    name: Required. Name of the command, as presented on the command line, or
      if the command is packaged as a Docker container, as presented to
      `docker pull`.
    waitFor: The ID(s) of the command(s) that this command depends on.
  """

  args = _messages.StringField(1, repeated=True)
  dir = _messages.StringField(2)
  env = _messages.StringField(3, repeated=True)
  id = _messages.StringField(4)
  name = _messages.StringField(5)
  waitFor = _messages.StringField(6, repeated=True)


class ContaineranalysisOperationsCancelRequest(_messages.Message):
  r"""A ContaineranalysisOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class ContaineranalysisOperationsDeleteRequest(_messages.Message):
  r"""A ContaineranalysisOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisOperationsGetRequest(_messages.Message):
  r"""A ContaineranalysisOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisOperationsListRequest(_messages.Message):
  r"""A ContaineranalysisOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ContaineranalysisProjectsNotesBatchCreateRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesBatchCreateRequest object.

  Fields:
    batchCreateNotesRequest: A BatchCreateNotesRequest resource to be passed
      as the request body.
    parent: The name of the project in the form of `projects/[PROJECT_ID]`,
      under which the notes are to be created.
  """

  batchCreateNotesRequest = _messages.MessageField('BatchCreateNotesRequest', 1)
  parent = _messages.StringField(2, required=True)


class ContaineranalysisProjectsNotesCreateRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesCreateRequest object.

  Fields:
    note: A Note resource to be passed as the request body.
    noteId: The ID to use for this note.
    parent: The name of the project in the form of `projects/[PROJECT_ID]`,
      under which the note is to be created.
  """

  note = _messages.MessageField('Note', 1)
  noteId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ContaineranalysisProjectsNotesDeleteRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesDeleteRequest object.

  Fields:
    name: The name of the note in the form of
      `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsNotesGetIamPolicyRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class ContaineranalysisProjectsNotesGetRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesGetRequest object.

  Fields:
    name: The name of the note in the form of
      `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsNotesListRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesListRequest object.

  Fields:
    filter: The filter expression.
    pageSize: Number of notes to return in the list. Must be positive. Max
      allowed page size is 1000. If not specified, page size defaults to 20.
    pageToken: Token to provide to skip to a particular spot in the list.
    parent: The name of the project to list notes for in the form of
      `projects/[PROJECT_ID]`.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class ContaineranalysisProjectsNotesOccurrencesListRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesOccurrencesListRequest object.

  Fields:
    filter: The filter expression.
    name: The name of the note to list occurrences for in the form of
      `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
    pageSize: Number of occurrences to return in the list.
    pageToken: Token to provide to skip to a particular spot in the list.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ContaineranalysisProjectsNotesPatchRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesPatchRequest object.

  Fields:
    name: The name of the note in the form of
      `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
    note: A Note resource to be passed as the request body.
    updateMask: The fields to update.
  """

  name = _messages.StringField(1, required=True)
  note = _messages.MessageField('Note', 2)
  updateMask = _messages.StringField(3)


class ContaineranalysisProjectsNotesSetIamPolicyRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ContaineranalysisProjectsNotesTestIamPermissionsRequest(_messages.Message):
  r"""A ContaineranalysisProjectsNotesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ContaineranalysisProjectsOccurrencesBatchCreateRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesBatchCreateRequest object.

  Fields:
    batchCreateOccurrencesRequest: A BatchCreateOccurrencesRequest resource to
      be passed as the request body.
    parent: The name of the project in the form of `projects/[PROJECT_ID]`,
      under which the occurrences are to be created.
  """

  batchCreateOccurrencesRequest = _messages.MessageField('BatchCreateOccurrencesRequest', 1)
  parent = _messages.StringField(2, required=True)


class ContaineranalysisProjectsOccurrencesCreateRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesCreateRequest object.

  Fields:
    occurrence: A Occurrence resource to be passed as the request body.
    parent: The name of the project in the form of `projects/[PROJECT_ID]`,
      under which the occurrence is to be created.
  """

  occurrence = _messages.MessageField('Occurrence', 1)
  parent = _messages.StringField(2, required=True)


class ContaineranalysisProjectsOccurrencesDeleteRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesDeleteRequest object.

  Fields:
    name: The name of the occurrence in the form of
      `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsOccurrencesGetIamPolicyRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class ContaineranalysisProjectsOccurrencesGetNotesRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesGetNotesRequest object.

  Fields:
    name: The name of the occurrence in the form of
      `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsOccurrencesGetRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesGetRequest object.

  Fields:
    name: The name of the occurrence in the form of
      `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsOccurrencesListRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesListRequest object.

  Fields:
    filter: The filter expression.
    pageSize: Number of occurrences to return in the list. Must be positive.
      Max allowed page size is 1000. If not specified, page size defaults to
      20.
    pageToken: Token to provide to skip to a particular spot in the list.
    parent: The name of the project to list occurrences for in the form of
      `projects/[PROJECT_ID]`.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class ContaineranalysisProjectsOccurrencesPatchRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesPatchRequest object.

  Fields:
    name: The name of the occurrence in the form of
      `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
    occurrence: A Occurrence resource to be passed as the request body.
    updateMask: The fields to update.
  """

  name = _messages.StringField(1, required=True)
  occurrence = _messages.MessageField('Occurrence', 2)
  updateMask = _messages.StringField(3)


class ContaineranalysisProjectsOccurrencesSetIamPolicyRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ContaineranalysisProjectsOccurrencesTestIamPermissionsRequest(_messages.Message):
  r"""A ContaineranalysisProjectsOccurrencesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class DeploymentNote(_messages.Message):
  r"""An artifact that can be deployed in some runtime.

  Fields:
    resourceUri: Required. Resource URI for the artifact being deployed.
  """

  resourceUri = _messages.StringField(1, repeated=True)


class DeploymentOccurrence(_messages.Message):
  r"""The period during which some deployable was active in a runtime.

  Enums:
    PlatformValueValuesEnum: Platform hosting this deployment.

  Fields:
    address: Address of the runtime element hosting this deployment.
    config: Configuration used to create this deployment.
    deployTime: Required. Beginning of the lifetime of this deployment.
    platform: Platform hosting this deployment.
    resourceUri: Output only. Resource URI for the artifact being deployed
      taken from the deployable field with the same name.
    undeployTime: End of the lifetime of this deployment.
    userEmail: Identity of the user that triggered this deployment.
  """

  class PlatformValueValuesEnum(_messages.Enum):
    r"""Platform hosting this deployment.

    Values:
      PLATFORM_UNSPECIFIED: Unknown.
      GKE: Google Container Engine.
      FLEX: Google App Engine: Flexible Environment.
      CUSTOM: Custom user-defined platform.
    """
    PLATFORM_UNSPECIFIED = 0
    GKE = 1
    FLEX = 2
    CUSTOM = 3

  address = _messages.StringField(1)
  config = _messages.StringField(2)
  deployTime = _messages.StringField(3)
  platform = _messages.EnumField('PlatformValueValuesEnum', 4)
  resourceUri = _messages.StringField(5, repeated=True)
  undeployTime = _messages.StringField(6)
  userEmail = _messages.StringField(7)


class Detail(_messages.Message):
  r"""A detail for a distro and package affected by this vulnerability and its
  associated fix (if one is available).

  Fields:
    affectedCpeUri: Required. The [CPE
      URI](https://cpe.mitre.org/specification/) this vulnerability affects.
    affectedPackage: Required. The package this vulnerability affects.
    affectedVersionEnd: The version number at the end of an interval in which
      this vulnerability exists. A vulnerability can affect a package between
      version numbers that are disjoint sets of intervals (example:
      [1.0.0-1.1.0], [2.4.6-2.4.8] and [4.5.6-4.6.8]) each of which will be
      represented in its own Detail. If a specific affected version is
      provided by a vulnerability database, affected_version_start and
      affected_version_end will be the same in that Detail.
    affectedVersionStart: The version number at the start of an interval in
      which this vulnerability exists. A vulnerability can affect a package
      between version numbers that are disjoint sets of intervals (example:
      [1.0.0-1.1.0], [2.4.6-2.4.8] and [4.5.6-4.6.8]) each of which will be
      represented in its own Detail. If a specific affected version is
      provided by a vulnerability database, affected_version_start and
      affected_version_end will be the same in that Detail.
    description: A vendor-specific description of this vulnerability.
    fixedCpeUri: The distro recommended [CPE
      URI](https://cpe.mitre.org/specification/) to update to that contains a
      fix for this vulnerability. It is possible for this to be different from
      the affected_cpe_uri.
    fixedPackage: The distro recommended package to update to that contains a
      fix for this vulnerability. It is possible for this to be different from
      the affected_package.
    fixedVersion: The distro recommended version to update to that contains a
      fix for this vulnerability. Setting this to VersionKind.MAXIMUM means no
      such version is yet available.
    isObsolete: Whether this detail is obsolete. Occurrences are expected not
      to point to obsolete details.
    packageType: The type of package; whether native or non native (e.g., ruby
      gems, node.js packages, etc.).
    severityName: The distro assigned severity of this vulnerability.
    sourceUpdateTime: The time this information was last changed at the
      source. This is an upstream timestamp from the underlying information
      source - e.g. Ubuntu security tracker.
  """

  affectedCpeUri = _messages.StringField(1)
  affectedPackage = _messages.StringField(2)
  affectedVersionEnd = _messages.MessageField('Version', 3)
  affectedVersionStart = _messages.MessageField('Version', 4)
  description = _messages.StringField(5)
  fixedCpeUri = _messages.StringField(6)
  fixedPackage = _messages.StringField(7)
  fixedVersion = _messages.MessageField('Version', 8)
  isObsolete = _messages.BooleanField(9)
  packageType = _messages.StringField(10)
  severityName = _messages.StringField(11)
  sourceUpdateTime = _messages.StringField(12)


class DiscoveryNote(_messages.Message):
  r"""A note that indicates a type of analysis a provider would perform. This
  note exists in a provider's project. A `Discovery` occurrence is created in
  a consumer's project at the start of analysis.

  Enums:
    AnalysisKindValueValuesEnum: Required. Immutable. The kind of analysis
      that is handled by this discovery.

  Fields:
    analysisKind: Required. Immutable. The kind of analysis that is handled by
      this discovery.
  """

  class AnalysisKindValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. The kind of analysis that is handled by this
    discovery.

    Values:
      NOTE_KIND_UNSPECIFIED: Unknown.
      VULNERABILITY: The note and occurrence represent a package
        vulnerability.
      BUILD: The note and occurrence assert build provenance.
      IMAGE: This represents an image basis relationship.
      PACKAGE: This represents a package installed via a package manager.
      DEPLOYMENT: The note and occurrence track deployment events.
      DISCOVERY: The note and occurrence track the initial discovery status of
        a resource.
      ATTESTATION: This represents a logical "role" that can attest to
        artifacts.
      UPGRADE: This represents an available package upgrade.
    """
    NOTE_KIND_UNSPECIFIED = 0
    VULNERABILITY = 1
    BUILD = 2
    IMAGE = 3
    PACKAGE = 4
    DEPLOYMENT = 5
    DISCOVERY = 6
    ATTESTATION = 7
    UPGRADE = 8

  analysisKind = _messages.EnumField('AnalysisKindValueValuesEnum', 1)


class DiscoveryOccurrence(_messages.Message):
  r"""Provides information about the analysis status of a discovered resource.

  Enums:
    AnalysisStatusValueValuesEnum: The status of discovery for the resource.
    ContinuousAnalysisValueValuesEnum: Whether the resource is continuously
      analyzed.

  Fields:
    analysisStatus: The status of discovery for the resource.
    analysisStatusError: When an error is encountered this will contain a
      LocalizedMessage under details to show to the user. The LocalizedMessage
      is output only and populated by the API.
    continuousAnalysis: Whether the resource is continuously analyzed.
    cpe: The CPE of the resource being scanned.
  """

  class AnalysisStatusValueValuesEnum(_messages.Enum):
    r"""The status of discovery for the resource.

    Values:
      ANALYSIS_STATUS_UNSPECIFIED: Unknown.
      PENDING: Resource is known but no action has been taken yet.
      SCANNING: Resource is being analyzed.
      FINISHED_SUCCESS: Analysis has finished successfully.
      FINISHED_FAILED: Analysis has finished unsuccessfully, the analysis
        itself is in a bad state.
      FINISHED_UNSUPPORTED: The resource is known not to be supported
    """
    ANALYSIS_STATUS_UNSPECIFIED = 0
    PENDING = 1
    SCANNING = 2
    FINISHED_SUCCESS = 3
    FINISHED_FAILED = 4
    FINISHED_UNSUPPORTED = 5

  class ContinuousAnalysisValueValuesEnum(_messages.Enum):
    r"""Whether the resource is continuously analyzed.

    Values:
      CONTINUOUS_ANALYSIS_UNSPECIFIED: Unknown.
      ACTIVE: The resource is continuously analyzed.
      INACTIVE: The resource is ignored for continuous analysis.
    """
    CONTINUOUS_ANALYSIS_UNSPECIFIED = 0
    ACTIVE = 1
    INACTIVE = 2

  analysisStatus = _messages.EnumField('AnalysisStatusValueValuesEnum', 1)
  analysisStatusError = _messages.MessageField('Status', 2)
  continuousAnalysis = _messages.EnumField('ContinuousAnalysisValueValuesEnum', 3)
  cpe = _messages.StringField(4)


class Distribution(_messages.Message):
  r"""This represents a particular channel of distribution for a given
  package. E.g., Debian's jessie-backports dpkg mirror.

  Enums:
    ArchitectureValueValuesEnum: The CPU architecture for which packages in
      this distribution channel were built.

  Fields:
    architecture: The CPU architecture for which packages in this distribution
      channel were built.
    cpeUri: Required. The cpe_uri in [CPE
      format](https://cpe.mitre.org/specification/) denoting the package
      manager version distributing a package.
    description: The distribution channel-specific description of this
      package.
    latestVersion: The latest available version of this package in this
      distribution channel.
    maintainer: A freeform string denoting the maintainer of this package.
    url: The distribution channel-specific homepage for this package.
  """

  class ArchitectureValueValuesEnum(_messages.Enum):
    r"""The CPU architecture for which packages in this distribution channel
    were built.

    Values:
      ARCHITECTURE_UNSPECIFIED: Unknown architecture.
      X86: X86 architecture.
      X64: X64 architecture.
    """
    ARCHITECTURE_UNSPECIFIED = 0
    X86 = 1
    X64 = 2

  architecture = _messages.EnumField('ArchitectureValueValuesEnum', 1)
  cpeUri = _messages.StringField(2)
  description = _messages.StringField(3)
  latestVersion = _messages.MessageField('Version', 4)
  maintainer = _messages.StringField(5)
  url = _messages.StringField(6)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  r"""Represents an expression text. Example:      title: "User account
  presence"     description: "Determines whether the request has a user
  account"     expression: "size(request.user) > 0"

  Fields:
    description: An optional description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.  The application context of the containing message
      determines which well-known feature set of CEL is supported.
    location: An optional string indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: An optional title for the expression, i.e. a short string
      describing its purpose. This can be used e.g. in UIs which allow to
      enter the expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class FileHashes(_messages.Message):
  r"""Container message for hashes of byte content of files, used in source
  messages to verify integrity of source input to the build.

  Fields:
    fileHash: Required. Collection of file hashes.
  """

  fileHash = _messages.MessageField('Hash', 1, repeated=True)


class Fingerprint(_messages.Message):
  r"""A set of properties that uniquely identify a given Docker image.

  Fields:
    v1Name: Required. The layer ID of the final layer in the Docker image's v1
      representation.
    v2Blob: Required. The ordered list of v2 blobs that represent a given
      image.
    v2Name: Output only. The name of the image's v2 blobs computed via:
      [bottom] := v2_blobbottom := sha256(v2_blob[N] + " " + v2_name[N+1])
      Only the name of the final blob is kept.
  """

  v1Name = _messages.StringField(1)
  v2Blob = _messages.StringField(2, repeated=True)
  v2Name = _messages.StringField(3)


class GerritSourceContext(_messages.Message):
  r"""A SourceContext referring to a Gerrit project.

  Fields:
    aliasContext: An alias, which may be a branch or tag.
    gerritProject: The full project name within the host. Projects may be
      nested, so "project/subproject" is a valid project name. The "repo name"
      is the hostURI/project.
    hostUri: The URI of a running Gerrit instance.
    revisionId: A revision (commit) ID.
  """

  aliasContext = _messages.MessageField('AliasContext', 1)
  gerritProject = _messages.StringField(2)
  hostUri = _messages.StringField(3)
  revisionId = _messages.StringField(4)


class GetIamPolicyRequest(_messages.Message):
  r"""Request message for `GetIamPolicy` method.

  Fields:
    options: OPTIONAL: A `GetPolicyOptions` object for specifying options to
      `GetIamPolicy`. This field is only used by Cloud IAM.
  """

  options = _messages.MessageField('GetPolicyOptions', 1)


class GetPolicyOptions(_messages.Message):
  r"""Encapsulates settings provided to GetIamPolicy.

  Fields:
    requestedPolicyVersion: Optional. The policy format version to be
      returned.  Valid values are 0, 1, and 3. Requests specifying an invalid
      value will be rejected.  Requests for policies with any conditional
      bindings must specify version 3. Policies without any conditional
      bindings may specify any valid value or leave the field unset.
  """

  requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GitSourceContext(_messages.Message):
  r"""A GitSourceContext denotes a particular revision in a third party Git
  repository (e.g., GitHub).

  Fields:
    revisionId: Git commit hash.
    url: Git repository URL.
  """

  revisionId = _messages.StringField(1)
  url = _messages.StringField(2)


class GoogleDevtoolsContaineranalysisV1alpha1OperationMetadata(_messages.Message):
  r"""Metadata for all operations used and required for all operations that
  created by Container Analysis Providers

  Fields:
    createTime: Output only. The time this operation was created.
    endTime: Output only. The time that this operation was marked completed or
      failed.
  """

  createTime = _messages.StringField(1)
  endTime = _messages.StringField(2)


class Hash(_messages.Message):
  r"""Container message for hash values.

  Fields:
    type: Required. The type of hash that was performed, e.g. "SHA-256".
    value: Required. The hash value.
  """

  type = _messages.StringField(1)
  value = _messages.BytesField(2)


class Hint(_messages.Message):
  r"""This submessage provides human-readable hints about the purpose of the
  authority. Because the name of a note acts as its resource reference, it is
  important to disambiguate the canonical name of the Note (which might be a
  UUID for security purposes) from "readable" names more suitable for debug
  output. Note that these hints should not be used to look up authorities in
  security sensitive contexts, such as when looking up attestations to verify.

  Fields:
    humanReadableName: Required. The human readable name of this attestation
      authority, for example "qa".
  """

  humanReadableName = _messages.StringField(1)


class ImageNote(_messages.Message):
  r"""Basis describes the base image portion (Note) of the DockerImage
  relationship. Linked occurrences are derived from this or an equivalent
  image via:   FROM <Basis.resource_url> Or an equivalent reference, e.g., a
  tag of the resource_url.

  Fields:
    fingerprint: Required. Immutable. The fingerprint of the base image.
    resourceUrl: Required. Immutable. The resource_url for the resource
      representing the basis of associated occurrence images.
  """

  fingerprint = _messages.MessageField('Fingerprint', 1)
  resourceUrl = _messages.StringField(2)


class ImageOccurrence(_messages.Message):
  r"""Details of the derived image portion of the DockerImage relationship.
  This image would be produced from a Dockerfile with FROM <DockerImage.Basis
  in attached Note>.

  Fields:
    baseResourceUrl: Output only. This contains the base image URL for the
      derived image occurrence.
    distance: Output only. The number of layers by which this image differs
      from the associated image basis.
    fingerprint: Required. The fingerprint of the derived image.
    layerInfo: This contains layer-specific metadata, if populated it has
      length "distance" and is ordered with [distance] being the layer
      immediately following the base image and [1] being the final layer.
  """

  baseResourceUrl = _messages.StringField(1)
  distance = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  fingerprint = _messages.MessageField('Fingerprint', 3)
  layerInfo = _messages.MessageField('Layer', 4, repeated=True)


class KnowledgeBase(_messages.Message):
  r"""A KnowledgeBase object.

  Fields:
    name: The KB name (generally of the form KB[0-9]+ (e.g., KB123456)).
    url: A link to the KB in the [Windows update catalog]
      (https://www.catalog.update.microsoft.com/).
  """

  name = _messages.StringField(1)
  url = _messages.StringField(2)


class Layer(_messages.Message):
  r"""Layer holds metadata specific to a layer of a Docker image.

  Fields:
    arguments: The recovered arguments to the Dockerfile directive.
    directive: Required. The recovered Dockerfile directive used to construct
      this layer. See https://docs.docker.com/engine/reference/builder/ for
      more information.
  """

  arguments = _messages.StringField(1)
  directive = _messages.StringField(2)


class ListNoteOccurrencesResponse(_messages.Message):
  r"""Response for listing occurrences for a note.

  Fields:
    nextPageToken: Token to provide to skip to a particular spot in the list.
    occurrences: The occurrences attached to the specified note.
  """

  nextPageToken = _messages.StringField(1)
  occurrences = _messages.MessageField('Occurrence', 2, repeated=True)


class ListNotesResponse(_messages.Message):
  r"""Response for listing notes.

  Fields:
    nextPageToken: The next pagination token in the list response. It should
      be used as `page_token` for the following request. An empty value means
      no more results.
    notes: The notes requested.
  """

  nextPageToken = _messages.StringField(1)
  notes = _messages.MessageField('Note', 2, repeated=True)


class ListOccurrencesResponse(_messages.Message):
  r"""Response for listing occurrences.

  Fields:
    nextPageToken: The next pagination token in the list response. It should
      be used as `page_token` for the following request. An empty value means
      no more results.
    occurrences: The occurrences requested.
  """

  nextPageToken = _messages.StringField(1)
  occurrences = _messages.MessageField('Occurrence', 2, repeated=True)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Location(_messages.Message):
  r"""An occurrence of a particular package installation found within a
  system's filesystem. E.g., glibc was found in `/var/lib/dpkg/status`.

  Fields:
    cpeUri: Required. The CPE URI in [CPE
      format](https://cpe.mitre.org/specification/) denoting the package
      manager version distributing a package.
    path: The path from which we gathered that this package/version is
      installed.
    version: The version installed at this location.
  """

  cpeUri = _messages.StringField(1)
  path = _messages.StringField(2)
  version = _messages.MessageField('Version', 3)


class Note(_messages.Message):
  r"""A type of analysis that can be done for a resource.

  Enums:
    KindValueValuesEnum: Output only. The type of analysis. This field can be
      used as a filter in list requests.

  Fields:
    attestation: A note describing an attestation role.
    build: A note describing build provenance for a verifiable build.
    createTime: Output only. The time this note was created. This field can be
      used as a filter in list requests.
    deployment: A note describing something that can be deployed.
    discovery: A note describing the initial analysis of a resource.
    expirationTime: Time of expiration for this note. Empty if note does not
      expire.
    image: A note describing a base image.
    kind: Output only. The type of analysis. This field can be used as a
      filter in list requests.
    longDescription: A detailed description of this note.
    name: Output only. The name of the note in the form of
      `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
    package: A note describing a package hosted by various package managers.
    relatedNoteNames: Other notes related to this note.
    relatedUrl: URLs associated with this note.
    shortDescription: A one sentence description of this note.
    updateTime: Output only. The time this note was last updated. This field
      can be used as a filter in list requests.
    upgrade: A note describing available package upgrades.
    vulnerability: A note describing a package vulnerability.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""Output only. The type of analysis. This field can be used as a filter
    in list requests.

    Values:
      NOTE_KIND_UNSPECIFIED: Unknown.
      VULNERABILITY: The note and occurrence represent a package
        vulnerability.
      BUILD: The note and occurrence assert build provenance.
      IMAGE: This represents an image basis relationship.
      PACKAGE: This represents a package installed via a package manager.
      DEPLOYMENT: The note and occurrence track deployment events.
      DISCOVERY: The note and occurrence track the initial discovery status of
        a resource.
      ATTESTATION: This represents a logical "role" that can attest to
        artifacts.
      UPGRADE: This represents an available package upgrade.
    """
    NOTE_KIND_UNSPECIFIED = 0
    VULNERABILITY = 1
    BUILD = 2
    IMAGE = 3
    PACKAGE = 4
    DEPLOYMENT = 5
    DISCOVERY = 6
    ATTESTATION = 7
    UPGRADE = 8

  attestation = _messages.MessageField('AttestationNote', 1)
  build = _messages.MessageField('BuildNote', 2)
  createTime = _messages.StringField(3)
  deployment = _messages.MessageField('DeploymentNote', 4)
  discovery = _messages.MessageField('DiscoveryNote', 5)
  expirationTime = _messages.StringField(6)
  image = _messages.MessageField('ImageNote', 7)
  kind = _messages.EnumField('KindValueValuesEnum', 8)
  longDescription = _messages.StringField(9)
  name = _messages.StringField(10)
  package = _messages.MessageField('PackageNote', 11)
  relatedNoteNames = _messages.StringField(12, repeated=True)
  relatedUrl = _messages.MessageField('RelatedUrl', 13, repeated=True)
  shortDescription = _messages.StringField(14)
  updateTime = _messages.StringField(15)
  upgrade = _messages.MessageField('UpgradeNote', 16)
  vulnerability = _messages.MessageField('VulnerabilityNote', 17)


class Occurrence(_messages.Message):
  r"""An instance of an analysis type that has been found on a resource.

  Enums:
    KindValueValuesEnum: Output only. This explicitly denotes which of the
      occurrence details are specified. This field can be used as a filter in
      list requests.

  Fields:
    attestation: Describes an attestation of an artifact.
    build: Describes a verifiable build.
    createTime: Output only. The time this occurrence was created.
    deployment: Describes the deployment of an artifact on a runtime.
    discovery: Describes when a resource was discovered.
    image: Describes how this resource derives from the basis in the
      associated note.
    kind: Output only. This explicitly denotes which of the occurrence details
      are specified. This field can be used as a filter in list requests.
    name: Output only. The name of the occurrence in the form of
      `projects/[PROJECT_ID]/occurrences/[OCCURRENCE_ID]`.
    noteName: Required. Immutable. The analysis note associated with this
      occurrence, in the form of `projects/[PROVIDER_ID]/notes/[NOTE_ID]`.
      This field can be used as a filter in list requests.
    package: Describes the installation of a package on the linked resource.
    remediation: A description of actions that can be taken to remedy the
      note.
    resourceUri: Required. Immutable. A URI that represents the resource for
      which the occurrence applies. For example,
      `https://gcr.io/project/image@sha256:123abc` for a Docker image.
    updateTime: Output only. The time this occurrence was last updated.
    upgrade: Describes an available package upgrade on the linked resource.
    vulnerability: Describes a security vulnerability.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""Output only. This explicitly denotes which of the occurrence details
    are specified. This field can be used as a filter in list requests.

    Values:
      NOTE_KIND_UNSPECIFIED: Unknown.
      VULNERABILITY: The note and occurrence represent a package
        vulnerability.
      BUILD: The note and occurrence assert build provenance.
      IMAGE: This represents an image basis relationship.
      PACKAGE: This represents a package installed via a package manager.
      DEPLOYMENT: The note and occurrence track deployment events.
      DISCOVERY: The note and occurrence track the initial discovery status of
        a resource.
      ATTESTATION: This represents a logical "role" that can attest to
        artifacts.
      UPGRADE: This represents an available package upgrade.
    """
    NOTE_KIND_UNSPECIFIED = 0
    VULNERABILITY = 1
    BUILD = 2
    IMAGE = 3
    PACKAGE = 4
    DEPLOYMENT = 5
    DISCOVERY = 6
    ATTESTATION = 7
    UPGRADE = 8

  attestation = _messages.MessageField('AttestationOccurrence', 1)
  build = _messages.MessageField('BuildOccurrence', 2)
  createTime = _messages.StringField(3)
  deployment = _messages.MessageField('DeploymentOccurrence', 4)
  discovery = _messages.MessageField('DiscoveryOccurrence', 5)
  image = _messages.MessageField('ImageOccurrence', 6)
  kind = _messages.EnumField('KindValueValuesEnum', 7)
  name = _messages.StringField(8)
  noteName = _messages.StringField(9)
  package = _messages.MessageField('PackageOccurrence', 10)
  remediation = _messages.StringField(11)
  resourceUri = _messages.StringField(12)
  updateTime = _messages.StringField(13)
  upgrade = _messages.MessageField('UpgradeOccurrence', 14)
  vulnerability = _messages.MessageField('VulnerabilityOccurrence', 15)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class PackageIssue(_messages.Message):
  r"""A detail for a distro and package this vulnerability occurrence was
  found in and its associated fix (if one is available).

  Fields:
    affectedCpeUri: Required. The [CPE
      URI](https://cpe.mitre.org/specification/) this vulnerability was found
      in.
    affectedPackage: Required. The package this vulnerability was found in.
    affectedVersion: Required. The version of the package that is installed on
      the resource affected by this vulnerability.
    fixAvailable: Output only. Whether a fix is available for this package.
    fixedCpeUri: The [CPE URI](https://cpe.mitre.org/specification/) this
      vulnerability was fixed in. It is possible for this to be different from
      the affected_cpe_uri.
    fixedPackage: The package this vulnerability was fixed in. It is possible
      for this to be different from the affected_package.
    fixedVersion: Required. The version of the package this vulnerability was
      fixed in. Setting this to VersionKind.MAXIMUM means no fix is yet
      available.
  """

  affectedCpeUri = _messages.StringField(1)
  affectedPackage = _messages.StringField(2)
  affectedVersion = _messages.MessageField('Version', 3)
  fixAvailable = _messages.BooleanField(4)
  fixedCpeUri = _messages.StringField(5)
  fixedPackage = _messages.StringField(6)
  fixedVersion = _messages.MessageField('Version', 7)


class PackageNote(_messages.Message):
  r"""This represents a particular package that is distributed over various
  channels. E.g., glibc (aka libc6) is distributed by many, at various
  versions.

  Fields:
    distribution: The various channels by which a package is distributed.
    name: Required. Immutable. The name of the package.
  """

  distribution = _messages.MessageField('Distribution', 1, repeated=True)
  name = _messages.StringField(2)


class PackageOccurrence(_messages.Message):
  r"""Details on how a particular software package was installed on a system.

  Fields:
    location: Required. All of the places within the filesystem versions of
      this package have been found.
    name: Output only. The name of the installed package.
  """

  location = _messages.MessageField('Location', 1, repeated=True)
  name = _messages.StringField(2)


class Policy(_messages.Message):
  r"""Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  is a collection of `bindings`. A `binding` binds one or more `members` to a
  single `role`. Members can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions (defined by IAM or configured by users). A `binding` can
  optionally specify a `condition`, which is a logic expression that further
  constrains the role binding based on attributes about the request and/or
  target resource.  **JSON Example**      {       "bindings": [         {
  "role": "roles/resourcemanager.organizationAdmin",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-project-
  id@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/resourcemanager.organizationViewer",           "members":
  ["user:eve@example.com"],           "condition": {             "title":
  "expirable access",             "description": "Does not grant access after
  Sep 2020",             "expression": "request.time <
  timestamp('2020-10-01T00:00:00.000Z')",           }         }       ]     }
  **YAML Example**      bindings:     - members:       - user:mike@example.com
  - group:admins@example.com       - domain:google.com       - serviceAccount
  :my-project-id@appspot.gserviceaccount.com       role:
  roles/resourcemanager.organizationAdmin     - members:       -
  user:eve@example.com       role: roles/resourcemanager.organizationViewer
  condition:         title: expirable access         description: Does not
  grant access after Sep 2020         expression: request.time <
  timestamp('2020-10-01T00:00:00.000Z')  For a description of IAM and its
  features, see the [IAM developer's
  guide](https://cloud.google.com/iam/docs).

  Fields:
    bindings: Associates a list of `members` to a `role`. Optionally may
      specify a `condition` that determines when binding is in effect.
      `bindings` with no members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten. Due to blind-set semantics of an
      etag-less policy, 'setIamPolicy' will not fail even if either of
      incoming or stored policy does not meet the version requirements.
    version: Specifies the format of the policy.  Valid values are 0, 1, and
      3. Requests specifying an invalid value will be rejected.  Operations
      affecting conditional bindings must specify version 3. This can be
      either setting a conditional policy, modifying a conditional binding, or
      removing a conditional binding from the stored conditional policy.
      Operations on non-conditional policies may specify any valid value or
      leave the field unset.  If no etag is provided in the call to
      `setIamPolicy`, any version compliance checks on the incoming and/or
      stored policy is skipped.
  """

  bindings = _messages.MessageField('Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class ProjectRepoId(_messages.Message):
  r"""Selects a repo using a Google Cloud Platform project ID (e.g., winged-
  cargo-31) and a repo name within that project.

  Fields:
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
  """

  projectId = _messages.StringField(1)
  repoName = _messages.StringField(2)


class RelatedUrl(_messages.Message):
  r"""Metadata for any related URL information.

  Fields:
    label: Label to describe usage of the URL.
    url: Specific URL associated with the resource.
  """

  label = _messages.StringField(1)
  url = _messages.StringField(2)


class RepoId(_messages.Message):
  r"""A unique identifier for a Cloud Repo.

  Fields:
    projectRepoId: A combination of a project ID and a repo name.
    uid: A server-assigned, globally unique identifier.
  """

  projectRepoId = _messages.MessageField('ProjectRepoId', 1)
  uid = _messages.StringField(2)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
  """

  policy = _messages.MessageField('Policy', 1)


class Signature(_messages.Message):
  r"""Verifiers (e.g. Kritis implementations) MUST verify signatures with
  respect to the trust anchors defined in policy (e.g. a Kritis policy).
  Typically this means that the verifier has been configured with a map from
  `public_key_id` to public key material (and any required parameters, e.g.
  signing algorithm).  In particular, verification implementations MUST NOT
  treat the signature `public_key_id` as anything more than a key lookup hint.
  The `public_key_id` DOES NOT validate or authenticate a public key; it only
  provides a mechanism for quickly selecting a public key ALREADY CONFIGURED
  on the verifier through a trusted channel. Verification implementations MUST
  reject signatures in any of the following circumstances:   * The
  `public_key_id` is not recognized by the verifier.   * The public key that
  `public_key_id` refers to does not verify the     signature with respect to
  the payload.  The `signature` contents SHOULD NOT be "attached" (where the
  payload is included with the serialized `signature` bytes). Verifiers MUST
  ignore any "attached" payload and only verify signatures with respect to
  explicitly provided payload (e.g. a `payload` field on the proto message
  that holds this Signature, or the canonical serialization of the proto
  message that holds this signature).

  Fields:
    publicKeyId: The identifier for the public key that verifies this
      signature.   * The `public_key_id` is required.   * The `public_key_id`
      MUST be an RFC3986 conformant URI.   * When possible, the
      `public_key_id` SHOULD be an immutable reference,     such as a
      cryptographic digest.  Examples of valid `public_key_id`s:  OpenPGP V4
      public key fingerprint:   *
      "openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA" See
      https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr for more
      details on this scheme.  RFC6920 digest-named SubjectPublicKeyInfo
      (digest of the DER serialization):   *
      "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU"   * "nih:///
      sha-256;703f68f42aba2c6de30f488a5ea122fef76324679c9bf89791ba95a1271589a5
      "
    signature: The content of the signature, an opaque bytestring. The payload
      that this signature verifies MUST be unambiguously provided with the
      Signature during verification. A wrapper message might provide the
      payload explicitly. Alternatively, a message might have a canonical
      serialization that can always be unambiguously computed to derive the
      payload.
  """

  publicKeyId = _messages.StringField(1)
  signature = _messages.BytesField(2)


class Source(_messages.Message):
  r"""Source describes the location of the source used for the build.

  Messages:
    FileHashesValue: Hash(es) of the build source, which can be used to verify
      that the original source integrity was maintained in the build.  The
      keys to this map are file paths used as build source and the values
      contain the hash values for those files.  If the build source came in a
      single package such as a gzipped tarfile (.tar.gz), the FileHash will be
      for the single path to that file.

  Fields:
    additionalContexts: If provided, some of the source code used for the
      build may be found in these locations, in the case where the source
      repository had multiple remotes or submodules. This list will not
      include the context specified in the context field.
    artifactStorageSourceUri: If provided, the input binary artifacts for the
      build came from this location.
    context: If provided, the source code used for the build came from this
      location.
    fileHashes: Hash(es) of the build source, which can be used to verify that
      the original source integrity was maintained in the build.  The keys to
      this map are file paths used as build source and the values contain the
      hash values for those files.  If the build source came in a single
      package such as a gzipped tarfile (.tar.gz), the FileHash will be for
      the single path to that file.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FileHashesValue(_messages.Message):
    r"""Hash(es) of the build source, which can be used to verify that the
    original source integrity was maintained in the build.  The keys to this
    map are file paths used as build source and the values contain the hash
    values for those files.  If the build source came in a single package such
    as a gzipped tarfile (.tar.gz), the FileHash will be for the single path
    to that file.

    Messages:
      AdditionalProperty: An additional property for a FileHashesValue object.

    Fields:
      additionalProperties: Additional properties of type FileHashesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FileHashesValue object.

      Fields:
        key: Name of the additional property.
        value: A FileHashes attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('FileHashes', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalContexts = _messages.MessageField('SourceContext', 1, repeated=True)
  artifactStorageSourceUri = _messages.StringField(2)
  context = _messages.MessageField('SourceContext', 3)
  fileHashes = _messages.MessageField('FileHashesValue', 4)


class SourceContext(_messages.Message):
  r"""A SourceContext is a reference to a tree of files. A SourceContext
  together with a path point to a unique revision of a single file or
  directory.

  Messages:
    LabelsValue: Labels with user defined metadata.

  Fields:
    cloudRepo: A SourceContext referring to a revision in a Google Cloud
      Source Repo.
    gerrit: A SourceContext referring to a Gerrit project.
    git: A SourceContext referring to any third party Git repo (e.g., GitHub).
    labels: Labels with user defined metadata.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels with user defined metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  cloudRepo = _messages.MessageField('CloudRepoSourceContext', 1)
  gerrit = _messages.MessageField('GerritSourceContext', 2)
  git = _messages.MessageField('GitSourceContext', 3)
  labels = _messages.MessageField('LabelsValue', 4)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details.  You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class UpgradeDistribution(_messages.Message):
  r"""The Upgrade Distribution represents metadata about the Upgrade for each
  operating system (CPE). Some distributions have additional metadata around
  updates, classifying them into various categories and severities.

  Fields:
    classification: The operating system classification of this Upgrade, as
      specified by the upstream operating system upgrade feed.
    cpeUri: Required - The specific operating system this metadata applies to.
      See https://cpe.mitre.org/specification/.
    cve: The cve tied to this Upgrade.
    severity: The severity as specified by the upstream operating system.
  """

  classification = _messages.StringField(1)
  cpeUri = _messages.StringField(2)
  cve = _messages.StringField(3, repeated=True)
  severity = _messages.StringField(4)


class UpgradeNote(_messages.Message):
  r"""A Upgrade Note represents a potential upgrade of a package to a given
  version. For each package version combination (i.e. bash 4.0, bash 4.1, bash
  4.1.2), there will be a Upgrade Note.

  Fields:
    distributions: Metadata about the upgrade for each specific operating
      system.
    package: Required - The package this Upgrade is for.
    version: Required - The version of the package in machine + human readable
      form.
  """

  distributions = _messages.MessageField('UpgradeDistribution', 1, repeated=True)
  package = _messages.StringField(2)
  version = _messages.MessageField('Version', 3)


class UpgradeOccurrence(_messages.Message):
  r"""A Upgrade Occurrence represents that a specific resource_url could
  install a specific upgrade. This presence is supplied via local sources
  (i.e. it is present in the mirror and the running system has noticed its
  availability).

  Fields:
    distribution: Metadata about the upgrade for avaiable for the specific
      operating system for the resource_url. This allows efficient filtering,
      as well as making it easier to use the occurrence.
    package: Required - The package this Upgrade is for.
    parsedVersion: Required - The version of the package in a machine + human
      readable form.
  """

  distribution = _messages.MessageField('UpgradeDistribution', 1)
  package = _messages.StringField(2)
  parsedVersion = _messages.MessageField('Version', 3)


class Version(_messages.Message):
  r"""Version contains structured information about the version of a package.

  Enums:
    KindValueValuesEnum: Required. Distinguishes between sentinel MIN/MAX
      versions and normal versions.

  Fields:
    epoch: Used to correct mistakes in the version numbering scheme.
    fullName: Human readable version string. This string is of the form
      <epoch>:<name>-<revision> and is only set when kind is NORMAL.
    kind: Required. Distinguishes between sentinel MIN/MAX versions and normal
      versions.
    name: Required only when version kind is NORMAL. The main part of the
      version name.
    revision: The iteration of the package build from the above version.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""Required. Distinguishes between sentinel MIN/MAX versions and normal
    versions.

    Values:
      VERSION_KIND_UNSPECIFIED: Unknown.
      NORMAL: A standard package version.
      MINIMUM: A special version representing negative infinity.
      MAXIMUM: A special version representing positive infinity.
    """
    VERSION_KIND_UNSPECIFIED = 0
    NORMAL = 1
    MINIMUM = 2
    MAXIMUM = 3

  epoch = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  fullName = _messages.StringField(2)
  kind = _messages.EnumField('KindValueValuesEnum', 3)
  name = _messages.StringField(4)
  revision = _messages.StringField(5)


class VulnerabilityNote(_messages.Message):
  r"""A security vulnerability that can be found in resources.

  Enums:
    SeverityValueValuesEnum: The note provider assigned severity of this
      vulnerability.

  Fields:
    cvssScore: The CVSS score of this vulnerability. CVSS score is on a scale
      of 0 - 10 where 0 indicates low severity and 10 indicates high severity.
    cvssV3: The full description of the CVSSv3 for this vulnerability.
    details: Details of all known distros and packages affected by this
      vulnerability.
    severity: The note provider assigned severity of this vulnerability.
    sourceUpdateTime: The time this information was last changed at the
      source. This is an upstream timestamp from the underlying information
      source - e.g. Ubuntu security tracker.
    windowsDetails: Windows details get their own format because the
      information format and model don't match a normal detail. Specifically
      Windows updates are done as patches, thus Windows vulnerabilities really
      are a missing package, rather than a package being at an incorrect
      version.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""The note provider assigned severity of this vulnerability.

    Values:
      SEVERITY_UNSPECIFIED: Unknown.
      MINIMAL: Minimal severity.
      LOW: Low severity.
      MEDIUM: Medium severity.
      HIGH: High severity.
      CRITICAL: Critical severity.
    """
    SEVERITY_UNSPECIFIED = 0
    MINIMAL = 1
    LOW = 2
    MEDIUM = 3
    HIGH = 4
    CRITICAL = 5

  cvssScore = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  cvssV3 = _messages.MessageField('CVSSv3', 2)
  details = _messages.MessageField('Detail', 3, repeated=True)
  severity = _messages.EnumField('SeverityValueValuesEnum', 4)
  sourceUpdateTime = _messages.StringField(5)
  windowsDetails = _messages.MessageField('WindowsDetail', 6, repeated=True)


class VulnerabilityOccurrence(_messages.Message):
  r"""An occurrence of a severity vulnerability on a resource.

  Enums:
    EffectiveSeverityValueValuesEnum: The distro assigned severity for this
      vulnerability when it is available, and note provider assigned severity
      when distro has not yet assigned a severity for this vulnerability.
    SeverityValueValuesEnum: Output only. The note provider assigned severity
      of this vulnerability.

  Fields:
    cvssScore: Output only. The CVSS score of this vulnerability. CVSS score
      is on a scale of 0 - 10 where 0 indicates low severity and 10 indicates
      high severity.
    effectiveSeverity: The distro assigned severity for this vulnerability
      when it is available, and note provider assigned severity when distro
      has not yet assigned a severity for this vulnerability.
    fixAvailable: Output only. Whether at least one of the affected packages
      has a fix available.
    longDescription: Output only. A detailed description of this
      vulnerability.
    packageIssue: Required. The set of affected locations and their fixes (if
      available) within the associated resource.
    relatedUrls: Output only. URLs related to this vulnerability.
    severity: Output only. The note provider assigned severity of this
      vulnerability.
    shortDescription: Output only. A one sentence description of this
      vulnerability.
    type: The type of package; whether native or non native (e.g., ruby gems,
      node.js packages, etc.).
  """

  class EffectiveSeverityValueValuesEnum(_messages.Enum):
    r"""The distro assigned severity for this vulnerability when it is
    available, and note provider assigned severity when distro has not yet
    assigned a severity for this vulnerability.

    Values:
      SEVERITY_UNSPECIFIED: Unknown.
      MINIMAL: Minimal severity.
      LOW: Low severity.
      MEDIUM: Medium severity.
      HIGH: High severity.
      CRITICAL: Critical severity.
    """
    SEVERITY_UNSPECIFIED = 0
    MINIMAL = 1
    LOW = 2
    MEDIUM = 3
    HIGH = 4
    CRITICAL = 5

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Output only. The note provider assigned severity of this
    vulnerability.

    Values:
      SEVERITY_UNSPECIFIED: Unknown.
      MINIMAL: Minimal severity.
      LOW: Low severity.
      MEDIUM: Medium severity.
      HIGH: High severity.
      CRITICAL: Critical severity.
    """
    SEVERITY_UNSPECIFIED = 0
    MINIMAL = 1
    LOW = 2
    MEDIUM = 3
    HIGH = 4
    CRITICAL = 5

  cvssScore = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  effectiveSeverity = _messages.EnumField('EffectiveSeverityValueValuesEnum', 2)
  fixAvailable = _messages.BooleanField(3)
  longDescription = _messages.StringField(4)
  packageIssue = _messages.MessageField('PackageIssue', 5, repeated=True)
  relatedUrls = _messages.MessageField('RelatedUrl', 6, repeated=True)
  severity = _messages.EnumField('SeverityValueValuesEnum', 7)
  shortDescription = _messages.StringField(8)
  type = _messages.StringField(9)


class WindowsDetail(_messages.Message):
  r"""A WindowsDetail object.

  Fields:
    cpeUri: Required. The [CPE URI](https://cpe.mitre.org/specification/) this
      vulnerability affects.
    description: The description of this vulnerability.
    fixingKbs: Required. The names of the KBs which have hotfixes to mitigate
      this vulnerability. Note that there may be multiple hotfixes (and thus
      multiple KBs) that mitigate a given vulnerability. Currently any listed
      KBs presence is considered a fix.
    name: Required. The name of this vulnerability.
  """

  cpeUri = _messages.StringField(1)
  description = _messages.StringField(2)
  fixingKbs = _messages.MessageField('KnowledgeBase', 3, repeated=True)
  name = _messages.StringField(4)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
