"""Generated message classes for accesscontextmanager version v1alpha.

An API for setting attribute based access control to requests to GCP services.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'accesscontextmanager'


class AccessLevel(_messages.Message):
  r"""An `AccessLevel` is a label that can be applied to requests to GCP
  services, along with a list of requirements necessary for the label to be
  applied. `AccessLevels` can be referenced in `AccessZones` and in the `Cloud
  Org Policy` API.

  Fields:
    basic: A `BasicLevel` composed of `Conditions`.
    createTime: Output only. Time the `AccessLevel` was created in UTC.
    description: Description of the `AccessLevel` and its use. Does not affect
      behavior.
    name: Required. Resource name for the Access Level. The `short_name`
      component must begin with a letter and only include alphanumeric and
      '_'. Format: `accessPolicies/{policy_id}/accessLevels/{short_name}`
    title: Human readable title. Must be unique within the Policy.
    updateTime: Output only. Time the `AccessLevel` was updated in UTC.
  """

  basic = _messages.MessageField('BasicLevel', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  name = _messages.StringField(4)
  title = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class AccessPolicy(_messages.Message):
  r"""`AccessPolicy` is a container for `AccessLevels` (which define the
  necessary attributes to use GCP services) and `AccessZones` (which define
  regions of services able to freely pass data within a zone). An access
  policy is globally visible within an organization, and the restrictions it
  specifies apply to all projects within an organization.

  Fields:
    createTime: Output only. Time the `AccessPolicy` was created in UTC.
    name: Output only. Resource name of the `AccessPolicy`. Format:
      `accessPolicies/{policy_id}`
    parent: Required. The parent of this `AccessPolicy` in the Cloud Resource
      Hierarchy. Currently immutable once created. Format:
      `organizations/{organization_id}`
    title: Human readable title. Does not affect behavior.
    updateTime: Output only. Time the `AccessPolicy` was updated in UTC.
  """

  createTime = _messages.StringField(1)
  name = _messages.StringField(2)
  parent = _messages.StringField(3)
  title = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class AccessZone(_messages.Message):
  r"""`AccessZone` describes a set of GCP resources which can freely import
  and export data amongst themselves, but not export outside of the
  `AccessZone`. If a request with a source within this `AccessZone` has a
  target outside of the `AccessZone`, the request will be blocked. Otherwise
  the request is allowed. Access Zones cannot overlap, a single GCP project
  can only belong to a single Access Zone. The restriction against overlapping
  zones may be lifted in the future.

  Enums:
    ZoneTypeValueValuesEnum: Zone type indicator. A single project is allowed
      to be a member of single regular access zone, but multiple bridge access
      zones. A project cannot be a included in a bridge access zone without
      being included in regular access zone. For bridge access zones,
      restricted/unrestricted service lists as well as access lists must be
      empty.

  Fields:
    accessLevels: A list of `AccessLevel` resource names that allow resources
      within the `AccessZone` to be accessed from the internet. `AccessLevels`
      listed must be in the same policy as this `AccessZone`. Referencing a
      nonexistent `AccessLevel` is a syntax error. If no `AccessLevel` names
      are listed, resources within the zone can only be accessed via GCP calls
      with request origins within the zone. Example:
      `"accessPolicies/MY_POLICY/accessLevels/MY_LEVEL"`. For bridge access
      zones, must be empty.
    createTime: Output only. Time the `AccessZone` was created in UTC.
    description: Description of the `AccessZone` and its use. Does not affect
      behavior.
    name: Required. Resource name for the Access Zone.  The `short_name`
      component must begin with a letter and only include alphanumeric and
      '_'. Format: `accessPolicies/{policy_id}/accessZones/{short_name}`
    resources: A list of GCP resources that are inside of the access zone.
      Currently only projects are allowed. Format: `projects/{project_number}`
    restrictedServices: GCP services that Access Zone restrictions will be
      applied to. May contain list of services or a single wildcard "*". Only
      resources for services matching the restricted_services will be subject
      to access zone protection. For example, if `storage.googleapis.com` is
      specified, then storage buckets that belong to the access zone could be
      accessed through Storage service only if access conditions are met.
      Wildcard means that unless explicitly specified by
      "unrestricted_services" list, any service is treated as restricted. One
      of the fields "restricted_services", "unrestricted_services" must
      contain a wildcard "*", otherwise the Access Zone specification is
      invalid. It also means that both field being empty is invalid as well.
      "restricted_services" can be empty if and only if
      "unrestricted_services" list contains a "*" wildcard. For bridge access
      zones, must be empty.
    title: Human readable title. Must be unique within the Policy.
    unrestrictedServices: GCP services exempt from the Access Zone
      restrictions. May contain list of services or a single wildcard "*".
      Services matching the unrestricted_services are excluded from Access
      Zone restrictions. For example, if `logging.googleapis.com` is
      unrestricted, users can read logs in projects from anywhere, even though
      the projects are inside access zone. Wildcard means that unless
      explicitly specified by "restricted_services" list, any service is
      treated as unrestricted. One of the fields "restricted_services",
      "unrestricted_services" must contain a wildcard "*", otherwise the
      Access Zone specification is invalid. It also means that both field
      being empty is invalid as well. "unrestricted_services" can be empty if
      and only if "restricted_services" list contains a "*" wildcard. For
      bridge access zones, must be empty.
    updateTime: Output only. Time the `AccessZone` was updated in UTC.
    zoneType: Zone type indicator. A single project is allowed to be a member
      of single regular access zone, but multiple bridge access zones. A
      project cannot be a included in a bridge access zone without being
      included in regular access zone. For bridge access zones,
      restricted/unrestricted service lists as well as access lists must be
      empty.
  """

  class ZoneTypeValueValuesEnum(_messages.Enum):
    r"""Zone type indicator. A single project is allowed to be a member of
    single regular access zone, but multiple bridge access zones. A project
    cannot be a included in a bridge access zone without being included in
    regular access zone. For bridge access zones, restricted/unrestricted
    service lists as well as access lists must be empty.

    Values:
      ZONE_TYPE_REGULAR: Regular zone.
      ZONE_TYPE_BRIDGE: Bridge zone.
    """
    ZONE_TYPE_REGULAR = 0
    ZONE_TYPE_BRIDGE = 1

  accessLevels = _messages.StringField(1, repeated=True)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  name = _messages.StringField(4)
  resources = _messages.StringField(5, repeated=True)
  restrictedServices = _messages.StringField(6, repeated=True)
  title = _messages.StringField(7)
  unrestrictedServices = _messages.StringField(8, repeated=True)
  updateTime = _messages.StringField(9)
  zoneType = _messages.EnumField('ZoneTypeValueValuesEnum', 10)


class AccesscontextmanagerAccessPoliciesAccessLevelsCreateRequest(_messages.Message):
  r"""A AccesscontextmanagerAccessPoliciesAccessLevelsCreateRequest object.

  Fields:
    accessLevel: A AccessLevel resource to be passed as the request body.
    parent: Required. Resource name for the access policy which owns this
      Access Level.  Format: `accessPolicies/{policy_id}`
  """

  accessLevel = _messages.MessageField('AccessLevel', 1)
  parent = _messages.StringField(2, required=True)


class AccesscontextmanagerAccessPoliciesAccessLevelsDeleteRequest(_messages.Message):
  r"""A AccesscontextmanagerAccessPoliciesAccessLevelsDeleteRequest object.

  Fields:
    name: Required. Resource name for the Access Level.  Format:
      `accessPolicies/{policy_id}/accessLevels/{access_level_id}`
  """

  name = _messages.StringField(1, required=True)


class AccesscontextmanagerAccessPoliciesAccessLevelsGetRequest(_messages.Message):
  r"""A AccesscontextmanagerAccessPoliciesAccessLevelsGetRequest object.

  Enums:
    AccessLevelFormatValueValuesEnum: Whether to return `BasicLevels` in the
      Cloud Common Expression Language rather than as `BasicLevels`. Defaults
      to AS_DEFINED, where Access Levels are returned as `BasicLevels` or
      `CustomLevels` based on how they were created. If set to CEL, all Access
      Levels are returned as `CustomLevels`. In the CEL case, `BasicLevels`
      are translated to equivalent `CustomLevels`.

  Fields:
    accessLevelFormat: Whether to return `BasicLevels` in the Cloud Common
      Expression Language rather than as `BasicLevels`. Defaults to
      AS_DEFINED, where Access Levels are returned as `BasicLevels` or
      `CustomLevels` based on how they were created. If set to CEL, all Access
      Levels are returned as `CustomLevels`. In the CEL case, `BasicLevels`
      are translated to equivalent `CustomLevels`.
    name: Required. Resource name for the Access Level.  Format:
      `accessPolicies/{policy_id}/accessLevels/{access_level_id}`
  """

  class AccessLevelFormatValueValuesEnum(_messages.Enum):
    r"""Whether to return `BasicLevels` in the Cloud Common Expression
    Language rather than as `BasicLevels`. Defaults to AS_DEFINED, where
    Access Levels are returned as `BasicLevels` or `CustomLevels` based on how
    they were created. If set to CEL, all Access Levels are returned as
    `CustomLevels`. In the CEL case, `BasicLevels` are translated to
    equivalent `CustomLevels`.

    Values:
      LEVEL_FORMAT_UNSPECIFIED: <no description>
      AS_DEFINED: <no description>
      CEL: <no description>
    """
    LEVEL_FORMAT_UNSPECIFIED = 0
    AS_DEFINED = 1
    CEL = 2

  accessLevelFormat = _messages.EnumField('AccessLevelFormatValueValuesEnum', 1)
  name = _messages.StringField(2, required=True)


class AccesscontextmanagerAccessPoliciesAccessLevelsListRequest(_messages.Message):
  r"""A AccesscontextmanagerAccessPoliciesAccessLevelsListRequest object.

  Enums:
    AccessLevelFormatValueValuesEnum: Whether to return `BasicLevels` in the
      Cloud Common Expression language, as `CustomLevels`, rather than as
      `BasicLevels`. Defaults to returning `AccessLevels` in the format they
      were defined.

  Fields:
    accessLevelFormat: Whether to return `BasicLevels` in the Cloud Common
      Expression language, as `CustomLevels`, rather than as `BasicLevels`.
      Defaults to returning `AccessLevels` in the format they were defined.
    pageSize: Number of Access Levels to include in the list. Default 100.
    pageToken: Next page token for the next batch of Access Level instances.
      Defaults to the first page of results.
    parent: Required. Resource name for the access policy to list Access
      Levels from.  Format: `accessPolicies/{policy_id}`
  """

  class AccessLevelFormatValueValuesEnum(_messages.Enum):
    r"""Whether to return `BasicLevels` in the Cloud Common Expression
    language, as `CustomLevels`, rather than as `BasicLevels`. Defaults to
    returning `AccessLevels` in the format they were defined.

    Values:
      LEVEL_FORMAT_UNSPECIFIED: <no description>
      AS_DEFINED: <no description>
      CEL: <no description>
    """
    LEVEL_FORMAT_UNSPECIFIED = 0
    AS_DEFINED = 1
    CEL = 2

  accessLevelFormat = _messages.EnumField('AccessLevelFormatValueValuesEnum', 1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class AccesscontextmanagerAccessPoliciesAccessLevelsPatchRequest(_messages.Message):
  r"""A AccesscontextmanagerAccessPoliciesAccessLevelsPatchRequest object.

  Fields:
    accessLevel: A AccessLevel resource to be passed as the request body.
    name: Required. Resource name for the Access Level. The `short_name`
      component must begin with a letter and only include alphanumeric and
      '_'. Format: `accessPolicies/{policy_id}/accessLevels/{short_name}`
    updateMask: Required.  Mask to control which fields get updated. Must be
      non-empty.
  """

  accessLevel = _messages.MessageField('AccessLevel', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AccesscontextmanagerAccessPoliciesAccessZonesCreateRequest(_messages.Message):
  r"""A AccesscontextmanagerAccessPoliciesAccessZonesCreateRequest object.

  Fields:
    accessZone: A AccessZone resource to be passed as the request body.
    parent: Required. Resource name for the access policy which owns this
      Access Zone.  Format: `accessPolicies/{policy_id}`
  """

  accessZone = _messages.MessageField('AccessZone', 1)
  parent = _messages.StringField(2, required=True)


class AccesscontextmanagerAccessPoliciesAccessZonesDeleteRequest(_messages.Message):
  r"""A AccesscontextmanagerAccessPoliciesAccessZonesDeleteRequest object.

  Fields:
    name: Required. Resource name for the Access Zone.  Format:
      `accessPolicies/{policy_id}/accessZones/{access_zone_id}`
  """

  name = _messages.StringField(1, required=True)


class AccesscontextmanagerAccessPoliciesAccessZonesGetRequest(_messages.Message):
  r"""A AccesscontextmanagerAccessPoliciesAccessZonesGetRequest object.

  Fields:
    name: Required. Resource name for the Access Zone.  Format:
      `accessPolicies/{policy_id}/accessZones/{access_zones_id}`
  """

  name = _messages.StringField(1, required=True)


class AccesscontextmanagerAccessPoliciesAccessZonesListRequest(_messages.Message):
  r"""A AccesscontextmanagerAccessPoliciesAccessZonesListRequest object.

  Fields:
    pageSize: Number of Access Zones to include in the list. Default 100.
    pageToken: Next page token for the next batch of Access Zone instances.
      Defaults to the first page of results.
    parent: Required. Resource name for the access policy to list Access Zones
      from.  Format: `accessPolicies/{policy_id}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class AccesscontextmanagerAccessPoliciesAccessZonesPatchRequest(_messages.Message):
  r"""A AccesscontextmanagerAccessPoliciesAccessZonesPatchRequest object.

  Fields:
    accessZone: A AccessZone resource to be passed as the request body.
    name: Required. Resource name for the Access Zone.  The `short_name`
      component must begin with a letter and only include alphanumeric and
      '_'. Format: `accessPolicies/{policy_id}/accessZones/{short_name}`
    updateMask: Required. Mask to control which fields get updated. Must be
      non-empty.
  """

  accessZone = _messages.MessageField('AccessZone', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AccesscontextmanagerAccessPoliciesDeleteRequest(_messages.Message):
  r"""A AccesscontextmanagerAccessPoliciesDeleteRequest object.

  Fields:
    name: Required. Resource name for the access policy to delete.  Format
      `accessPolicies/{policy_id}`
  """

  name = _messages.StringField(1, required=True)


class AccesscontextmanagerAccessPoliciesGetRequest(_messages.Message):
  r"""A AccesscontextmanagerAccessPoliciesGetRequest object.

  Fields:
    name: Required. Resource name for the access policy to get.  Format
      `accessPolicies/{policy_id}`
  """

  name = _messages.StringField(1, required=True)


class AccesscontextmanagerAccessPoliciesListRequest(_messages.Message):
  r"""A AccesscontextmanagerAccessPoliciesListRequest object.

  Fields:
    pageSize: Number of AccessPolicy instances to include in the list. Default
      100.
    pageToken: Next page token for the next batch of AccessPolicy instances.
      Defaults to the first page of results.
    parent: Required. Resource name for the container to list AccessPolicy
      instances from.  Format: `organizations/{org_id}`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3)


class AccesscontextmanagerAccessPoliciesPatchRequest(_messages.Message):
  r"""A AccesscontextmanagerAccessPoliciesPatchRequest object.

  Fields:
    accessPolicy: A AccessPolicy resource to be passed as the request body.
    name: Output only. Resource name of the `AccessPolicy`. Format:
      `accessPolicies/{policy_id}`
    updateMask: Required. Mask to control which fields get updated. Must be
      non-empty.
  """

  accessPolicy = _messages.MessageField('AccessPolicy', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class AccesscontextmanagerOperationsGetRequest(_messages.Message):
  r"""A AccesscontextmanagerOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class BasicLevel(_messages.Message):
  r"""`BasicLevel` is an `AccessLevel` using a set of recommended features.

  Enums:
    CombiningFunctionValueValuesEnum: How the `conditions` list should be
      combined to determine if a request is granted this `AccessLevel`. If AND
      is used, each `Condition` in `conditions` must be satisfied for the
      `AccessLevel` to be applied. If OR is used, at least one `Condition` in
      `conditions` must be satisfied for the `AccessLevel` to be applied.
      Default behavior is AND.

  Fields:
    combiningFunction: How the `conditions` list should be combined to
      determine if a request is granted this `AccessLevel`. If AND is used,
      each `Condition` in `conditions` must be satisfied for the `AccessLevel`
      to be applied. If OR is used, at least one `Condition` in `conditions`
      must be satisfied for the `AccessLevel` to be applied. Default behavior
      is AND.
    conditions: Required. A list of requirements for the `AccessLevel` to be
      granted.
  """

  class CombiningFunctionValueValuesEnum(_messages.Enum):
    r"""How the `conditions` list should be combined to determine if a request
    is granted this `AccessLevel`. If AND is used, each `Condition` in
    `conditions` must be satisfied for the `AccessLevel` to be applied. If OR
    is used, at least one `Condition` in `conditions` must be satisfied for
    the `AccessLevel` to be applied. Default behavior is AND.

    Values:
      AND: All `Conditions` must be true for the `BasicLevel` to be true.
      OR: If at least one `Condition` is true, then the `BasicLevel` is true.
    """
    AND = 0
    OR = 1

  combiningFunction = _messages.EnumField('CombiningFunctionValueValuesEnum', 1)
  conditions = _messages.MessageField('Condition', 2, repeated=True)


class Condition(_messages.Message):
  r"""A condition necessary for an `AccessLevel` to be granted. The Condition
  is an AND over its fields. So a Condition is true if: 1) the request IP is
  from one of the listed subnetworks AND 2) the originating device complies
  with the listed device policy AND 3) all listed access levels are granted
  AND 4) the request was sent at a time allowed by the DateTimeRestriction.

  Fields:
    ipSubnetworks: CIDR block IP subnetwork specification. May be IPv4 or
      IPv6. Note that for a CIDR IP address block, the specified IP address
      portion must be properly truncated (i.e. all the host bits must be zero)
      or the input is considered malformed. For example, "192.0.2.0/24" is
      accepted but "192.0.2.1/24" is not. Similarly, for IPv6, "2001:db8::/32"
      is accepted whereas "2001:db8::1/32" is not. The originating IP of a
      request must be in one of the listed subnets in order for this Condition
      to be true. If empty, all IP addresses are allowed.
    members: The signed-in user originating the request must be a part of one
      of the provided members. Syntax: `user:{emailid}` `group:{emailid}`
      `serviceAccount:{emailid}` If not specified, a request may come from any
      user (logged in/not logged in, not present in any groups, etc.).
    negate: Whether to negate the Condition. If true, the Condition becomes a
      NAND over its non-empty fields, each field must be false for the
      Condition overall to be satisfied. Defaults to false.
    requiredAccessLevels: A list of other access levels defined in the same
      `Policy`, referenced by resource name. Referencing an `AccessLevel`
      which does not exist is an error. All access levels listed must be
      granted for the Condition to be true. Example:
      "`accessPolicies/MY_POLICY/accessLevels/LEVEL_NAME"`
  """

  ipSubnetworks = _messages.StringField(1, repeated=True)
  members = _messages.StringField(2, repeated=True)
  negate = _messages.BooleanField(3)
  requiredAccessLevels = _messages.StringField(4, repeated=True)


class ListAccessLevelsResponse(_messages.Message):
  r"""A response to `ListAccessLevelsRequest`.

  Fields:
    accessLevels: List of the Access Level instances.
    nextPageToken: The pagination token to retrieve the next page of results.
      If the value is empty, no further results remain.
  """

  accessLevels = _messages.MessageField('AccessLevel', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListAccessPoliciesResponse(_messages.Message):
  r"""A response to `ListAccessPoliciesRequest`.

  Fields:
    accessPolicies: List of the AccessPolicy instances.
    nextPageToken: The pagination token to retrieve the next page of results.
      If the value is empty, no further results remain.
  """

  accessPolicies = _messages.MessageField('AccessPolicy', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListAccessZonesResponse(_messages.Message):
  r"""A response to `ListAccessZonesRequest`.

  Fields:
    accessZones: List of the Access Zone instances.
    nextPageToken: The pagination token to retrieve the next page of results.
      If the value is empty, no further results remain.
  """

  accessZones = _messages.MessageField('AccessZone', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should have the format of `operations/some/unique/name`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` that can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
