<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw vpc`
This API allows you to manage your Virtual Private Clouds (VPCs) and Private Networks.
  
- [Private network management command](#private-network-management-command)
  - [Create a Private Network](#create-a-private-network)
  - [Delete a Private Network](#delete-a-private-network)
  - [Enable DHCP on a Private Network](#enable-dhcp-on-a-private-network)
  - [Get a Private Network](#get-a-private-network)
  - [List Private Networks](#list-private-networks)
  - [Update Private Network](#update-private-network)
- [Route management command](#route-management-command)
  - [Create a Route](#create-a-route)
  - [Delete a Route](#delete-a-route)
  - [Enable routing on a VPC](#enable-routing-on-a-vpc)
  - [Get a Route](#get-a-route)
  - [Return routes with associated next hop data](#return-routes-with-associated-next-hop-data)
  - [Update Route](#update-route)
- [Rule management command](#rule-management-command)
- [Subnet management command](#subnet-management-command)
- [VPC management command](#vpc-management-command)
  - [Create a VPC](#create-a-vpc)
  - [Delete a VPC](#delete-a-vpc)
  - [Get a VPC](#get-a-vpc)
  - [List VPCs](#list-vpcs)
  - [Update VPC](#update-vpc)

  
## Private network management command

A Private Network allows you to interconnect your Scaleway resources
in an isolated and private network. Network reachability is limited
to resources that are on the same Private Network. Note that a
resource can be a part of multiple private networks.


### Create a Private Network

Create a new Private Network. Once created, you can attach Scaleway resources which are in the same region.

**Usage:**

```
scw vpc private-network create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required<br />Default: `<generated>` | Name for the Private Network |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| tags.{index} |  | Tags for the Private Network |
| subnets.{index} |  | Private Network subnets CIDR |
| vpc-id |  | VPC in which to create the Private Network |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a Private Network

Delete an existing Private Network. Note that you must first detach all resources from the network, in order to delete it.

**Usage:**

```
scw vpc private-network delete <private-network-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| private-network-id | Required | Private Network ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Enable DHCP on a Private Network

Enable DHCP managed on an existing Private Network. Note that you will not be able to deactivate it afterwards.

**Usage:**

```
scw vpc private-network enable-dhcp [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| private-network-id | Required | Private Network ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a Private Network

Retrieve information about an existing Private Network, specified by its Private Network ID. Its full details are returned in the response object.

**Usage:**

```
scw vpc private-network get <private-network-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| private-network-id | Required | Private Network ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List Private Networks

List existing Private Networks in the specified region. By default, the Private Networks returned in the list are ordered by creation date in ascending order, though this can be modified via the order_by field.

**Usage:**

```
scw vpc private-network list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Sort order of the returned Private Networks |
| name |  | Name to filter for. Only Private Networks with names containing this string will be returned |
| tags.{index} |  | Tags to filter for. Only Private Networks with one or more matching tags will be returned |
| project-id |  | Project ID to filter for. Only Private Networks belonging to this Project will be returned |
| private-network-ids.{index} |  | Private Network IDs to filter for. Only Private Networks with one of these IDs will be returned |
| vpc-id |  | VPC ID to filter for. Only Private Networks belonging to this VPC will be returned |
| dhcp-enabled |  | DHCP status to filter for. When true, only Private Networks with managed DHCP enabled will be returned |
| organization-id |  | Organization ID to filter for. Only Private Networks belonging to this Organization will be returned |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update Private Network

Update parameters (such as name or tags) of an existing Private Network, specified by its Private Network ID.

**Usage:**

```
scw vpc private-network update <private-network-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| private-network-id | Required | Private Network ID |
| name |  | Name for the Private Network |
| tags.{index} |  | Tags for the Private Network |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Route management command

Custom routes.


### Create a Route

Create a new custom Route.

**Usage:**

```
scw vpc route create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| description |  | Route description |
| tags.{index} |  | Tags of the Route |
| vpc-id |  | VPC the Route belongs to |
| destination |  | Destination of the Route |
| nexthop-resource-id |  | ID of the nexthop resource |
| nexthop-private-network-id |  | ID of the nexthop private network |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a Route

Delete a Route specified by its Route ID.

**Usage:**

```
scw vpc route delete <route-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| route-id | Required | Route ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Enable routing on a VPC

Enable routing on an existing VPC. Note that you will not be able to deactivate it afterwards.

**Usage:**

```
scw vpc route enable-routing <vpc-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| vpc-id | Required | VPC ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a Route

Retrieve details of an existing Route, specified by its Route ID.

**Usage:**

```
scw vpc route get <route-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| route-id | Required | Route ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Return routes with associated next hop data

Return routes with associated next hop data.

**Usage:**

```
scw vpc route list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `destination_asc`, `destination_desc`, `prefix_len_asc`, `prefix_len_desc` | Sort order of the returned routes |
| vpc-id |  | VPC to filter for. Only routes within this VPC will be returned |
| nexthop-resource-id |  | Next hop resource ID to filter for. Only routes with a matching next hop resource ID will be returned |
| nexthop-private-network-id |  | Next hop private network ID to filter for. Only routes with a matching next hop private network ID will be returned |
| nexthop-resource-type | One of: `unknown_type`, `vpc_gateway_network`, `instance_private_nic`, `baremetal_private_nic`, `apple_silicon_private_nic` | Next hop resource type to filter for. Only Routes with a matching next hop resource type will be returned |
| contains |  | Only routes whose destination is contained in this subnet will be returned |
| tags.{index} |  | Tags to filter for, only routes with one or more matching tags will be returned |
| is-ipv6 |  | Only routes with an IPv6 destination will be returned |
| region | Default: `fr-par`<br />One of: `all` | Region to target. If none is passed will use default region from the config |



### Update Route

Update parameters of the specified Route.

**Usage:**

```
scw vpc route update <route-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| route-id | Required | Route ID |
| description |  | Route description |
| tags.{index} |  | Tags of the Route |
| destination |  | Destination of the Route |
| nexthop-resource-id |  | ID of the nexthop resource |
| nexthop-private-network-id |  | ID of the nexthop private network |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Rule management command

Acl Rules.

Acl Rules.

**Usage:**

```
scw vpc rule
```



## Subnet management command

CIDR Subnet.

CIDR Subnet.

**Usage:**

```
scw vpc subnet
```



## VPC management command

A Virtual Private Cloud (VPC) allows you to group your regional
Private Networks together. Note that a Private Network can be a
part of only one VPC.


### Create a VPC

Create a new VPC in the specified region.

**Usage:**

```
scw vpc vpc create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required<br />Default: `<generated>` | Name for the VPC |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| tags.{index} |  | Tags for the VPC |
| enable-routing |  | Enable routing between Private Networks in the VPC |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a VPC

Delete a VPC specified by its VPC ID.

**Usage:**

```
scw vpc vpc delete <vpc-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| vpc-id | Required | VPC ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a VPC

Retrieve details of an existing VPC, specified by its VPC ID.

**Usage:**

```
scw vpc vpc get <vpc-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| vpc-id | Required | VPC ID |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List VPCs

List existing VPCs in the specified region.

**Usage:**

```
scw vpc vpc list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Sort order of the returned VPCs |
| name |  | Name to filter for. Only VPCs with names containing this string will be returned |
| tags.{index} |  | Tags to filter for. Only VPCs with one more more matching tags will be returned |
| project-id |  | Project ID to filter for. Only VPCs belonging to this Project will be returned |
| is-default |  | Defines whether to filter only for VPCs which are the default one for their Project |
| routing-enabled |  | Defines whether to filter only for VPCs which route traffic between their Private Networks |
| organization-id |  | Organization ID to filter for. Only VPCs belonging to this Organization will be returned |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update VPC

Update parameters including name and tags of the specified VPC.

**Usage:**

```
scw vpc vpc update <vpc-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| vpc-id | Required | VPC ID |
| name |  | Name for the VPC |
| tags.{index} |  | Tags for the VPC |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



