<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw function`
Function as a Service API.
  
- [Cron management commands](#cron-management-commands)
  - [Create a new cron](#create-a-new-cron)
  - [Delete an existing cron](#delete-an-existing-cron)
  - [Get a cron](#get-a-cron)
  - [List all crons](#list-all-crons)
  - [Update an existing cron](#update-an-existing-cron)
- [Deploy a function](#deploy-a-function)
- [Domain management commands](#domain-management-commands)
  - [Create a domain name binding](#create-a-domain-name-binding)
  - [Delete a domain name binding](#delete-a-domain-name-binding)
  - [Get a domain name binding](#get-a-domain-name-binding)
  - [List all domain name bindings](#list-all-domain-name-bindings)
- [Function management commands](#function-management-commands)
  - [Create a new function](#create-a-new-function)
  - [Delete a function](#delete-a-function)
  - [Deploy a function](#deploy-a-function)
  - [Get a function](#get-a-function)
  - [Get a download URL of a function](#get-a-download-url-of-a-function)
  - [Get an upload URL of a function](#get-an-upload-url-of-a-function)
  - [List all your functions](#list-all-your-functions)
  - [Update an existing function](#update-an-existing-function)
- [Function namespace management commands](#function-namespace-management-commands)
  - [Create a new namespace](#create-a-new-namespace)
  - [Delete an existing namespace](#delete-an-existing-namespace)
  - [Get a namespace](#get-a-namespace)
  - [List all your namespaces](#list-all-your-namespaces)
  - [Update an existing namespace](#update-an-existing-namespace)
- [Runtime management commands](#runtime-management-commands)
  - [List function runtimes](#list-function-runtimes)
- [Token management commands](#token-management-commands)
  - [Create a new revocable token](#create-a-new-revocable-token)
  - [Delete a token](#delete-a-token)
  - [Get a token](#get-a-token)
  - [List all tokens](#list-all-tokens)
- [Trigger management commands](#trigger-management-commands)
  - [Create a trigger](#create-a-trigger)
  - [Delete a trigger](#delete-a-trigger)
  - [Get a trigger](#get-a-trigger)
  - [List all triggers](#list-all-triggers)
  - [Update a trigger](#update-a-trigger)

  
## Cron management commands

Cron management commands.


### Create a new cron

Create a new cronjob for a function with the specified ID.

**Usage:**

```
scw function cron create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| function-id |  | UUID of the function to use the cron with |
| schedule |  | Schedule of the cron in UNIX cron format |
| args |  | Arguments to use with the cron |
| name |  | Name of the cron |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete an existing cron

Delete the cron associated with the specified ID.

**Usage:**

```
scw function cron delete <cron-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cron-id | Required | UUID of the cron to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a cron

Get the cron associated with the specified ID.

**Usage:**

```
scw function cron get <cron-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cron-id | Required | UUID of the cron to get |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all crons

List all the cronjobs in a specified region.

**Usage:**

```
scw function cron list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Order of the crons |
| function-id |  | UUID of the function |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update an existing cron

Update the cron associated with the specified ID.

**Usage:**

```
scw function cron update <cron-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| cron-id | Required | UUID of the cron to update |
| function-id |  | UUID of the function to use the cron with |
| schedule |  | Schedule of the cron in UNIX cron format |
| args |  | Arguments to use with the cron |
| name |  | Name of the cron |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Deploy a function

Create or fetch, upload and deploy your function

Create or fetch, upload and deploy your function

**Usage:**

```
scw function deploy [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id |  | Function Namespace ID to deploy to |
| name | Required | Name of the function to deploy, will be used in namespace's name if no ID is provided |
| runtime | Required<br />One of: `unknown_runtime`, `golang`, `python`, `python3`, `node8`, `node10`, `node14`, `node16`, `node17`, `python37`, `python38`, `python39`, `python310`, `go113`, `go117`, `go118`, `node18`, `rust165`, `go119`, `python311`, `php82`, `node19`, `go120`, `node20`, `go121`, `node22`, `python312`, `php83`, `go122`, `rust178` |  |
| zip-file | Required | Path of the zip file that contains your code |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Domain management commands

Domain management commands.


### Create a domain name binding

Create a domain name binding for the function with the specified ID.

**Usage:**

```
scw function domain create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| hostname |  | Hostame to create |
| function-id |  | UUID of the function to associate the domain with |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a domain name binding

Delete a domain name binding for the function with the specified ID.

**Usage:**

```
scw function domain delete <domain-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain-id | Required | UUID of the domain to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a domain name binding

Get a domain name binding for the function with the specified ID.

**Usage:**

```
scw function domain get <domain-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| domain-id | Required | UUID of the domain to get |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all domain name bindings

List all domain name bindings in a specified region.

**Usage:**

```
scw function domain list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `hostname_asc`, `hostname_desc` | Order of the domains |
| function-id |  | UUID of the function the domain is assoicated with |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



## Function management commands

Function management commands.


### Create a new function

Create a new function in the specified region for a specified Organization or Project.

**Usage:**

```
scw function function create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Default: `<generated>` | Name of the function to create |
| namespace-id |  | UUID of the namespace the function will be created in |
| environment-variables.{key} |  | Environment variables of the function |
| min-scale |  | Minumum number of instances to scale the function to |
| max-scale |  | Maximum number of instances to scale the function to |
| runtime | One of: `unknown_runtime`, `golang`, `python`, `python3`, `node8`, `node10`, `node14`, `node16`, `node17`, `python37`, `python38`, `python39`, `python310`, `go113`, `go117`, `go118`, `node18`, `rust165`, `go119`, `python311`, `php82`, `node19`, `go120`, `node20`, `go121`, `node22`, `python312`, `php83`, `go122`, `rust178` | Runtime to use with the function |
| memory-limit |  | Memory limit of the function in MB |
| timeout |  | Request processing time limit for the function |
| handler |  | Handler to use with the function |
| privacy | One of: `unknown_privacy`, `public`, `private` | Privacy setting of the function |
| description |  | Description of the function |
| secret-environment-variables.{index}.key |  |  |
| secret-environment-variables.{index}.value |  |  |
| http-option | Default: `enabled`<br />One of: `unknown_http_option`, `enabled`, `redirected` | Configure how HTTP and HTTPS requests are handled |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a function

Delete the function associated with the specified ID.

**Usage:**

```
scw function function delete <function-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| function-id | Required | UUID of the function to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Deploy a function

Deploy a function associated with the specified ID.

**Usage:**

```
scw function function deploy <function-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| function-id | Required | UUID of the function to deploy |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a function

Get the function associated with the specified ID.

**Usage:**

```
scw function function get <function-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| function-id | Required | UUID of the function |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a download URL of a function

Get a download URL for a function associated with the specified ID.

**Usage:**

```
scw function function get-download-url <function-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| function-id | Required | UUID of the function to get the the download URL for |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get an upload URL of a function

Get an upload URL of a function associated with the specified ID.

**Usage:**

```
scw function function get-upload-url <function-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| function-id | Required | UUID of the function to get the upload URL for |
| content-length | Required | Size of the archive to upload in bytes |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all your functions

List all your functions.

**Usage:**

```
scw function function list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Order of the functions |
| namespace-id |  | UUID of the namespace the function belongs to |
| name |  | Name of the function |
| project-id |  | UUID of the Project the function belongs to |
| organization-id |  | UUID of the Organziation the function belongs to |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update an existing function

Update the function associated with the specified ID.

**Usage:**

```
scw function function update <function-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| function-id | Required | UUID of the function to update |
| environment-variables.{key} |  | Environment variables of the function to update |
| min-scale |  | Minumum number of instances to scale the function to |
| max-scale |  | Maximum number of instances to scale the function to |
| runtime | One of: `unknown_runtime`, `golang`, `python`, `python3`, `node8`, `node10`, `node14`, `node16`, `node17`, `python37`, `python38`, `python39`, `python310`, `go113`, `go117`, `go118`, `node18`, `rust165`, `go119`, `python311`, `php82`, `node19`, `go120`, `node20`, `go121`, `node22`, `python312`, `php83`, `go122`, `rust178` | Runtime to use with the function |
| memory-limit |  | Memory limit of the function in MB |
| timeout |  | Processing time limit for the function |
| redeploy |  | Redeploy failed function |
| handler |  | Handler to use with the function |
| privacy | One of: `unknown_privacy`, `public`, `private` | Privacy setting of the function |
| description |  | Description of the function |
| secret-environment-variables.{index}.key |  |  |
| secret-environment-variables.{index}.value |  |  |
| http-option | Default: `enabled`<br />One of: `unknown_http_option`, `enabled`, `redirected` | Configure how HTTP and HTTPS requests are handled |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Function namespace management commands

Function namespace management commands.


### Create a new namespace

Create a new namespace in a specified Organization or Project.

**Usage:**

```
scw function namespace create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Default: `<generated>` |  |
| environment-variables.{key} |  | Environment variables of the namespace |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| description |  | Description of the namespace |
| secret-environment-variables.{index}.key |  |  |
| secret-environment-variables.{index}.value |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete an existing namespace

Delete the namespace associated with the specified ID.

**Usage:**

```
scw function namespace delete <namespace-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required | UUID of the namespace |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a namespace

Get the namespace associated with the specified ID.

**Usage:**

```
scw function namespace get <namespace-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required | UUID of the namespace |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all your namespaces

List all existing namespaces in the specified region.

**Usage:**

```
scw function namespace list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Order of the namespaces |
| name |  | Name of the namespace |
| project-id |  | UUID of the Project the namespace belongs to |
| organization-id |  | UUID of the Organization the namespace belongs to |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update an existing namespace

Update the namespace associated with the specified ID.

**Usage:**

```
scw function namespace update <namespace-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| namespace-id | Required | UUID of the namespapce |
| environment-variables.{key} |  | Environment variables of the namespace |
| description |  | Description of the namespace |
| secret-environment-variables.{index}.key |  |  |
| secret-environment-variables.{index}.value |  |  |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Runtime management commands

Runtime management commands.


### List function runtimes

List available function runtimes.

**Usage:**

```
scw function runtime list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



## Token management commands

Token management commands.


### Create a new revocable token

Create a new revocable token.

**Usage:**

```
scw function token create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| function-id |  | UUID of the function to associate the token with |
| namespace-id |  | UUID of the namespace to associate the token with |
| description |  | Description of the token |
| expires-at |  | Date on which the token expires |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a token

Delete a token.

**Usage:**

```
scw function token delete <token-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| token-id | Required | UUID of the token to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a token

Get a token.

**Usage:**

```
scw function token get <token-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| token-id | Required | UUID of the token to get |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all tokens

List all tokens.

**Usage:**

```
scw function token list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Sort order for the tokens |
| function-id |  | UUID of the function the token is assoicated with |
| namespace-id |  | UUID of the namespace the token is associated with |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



## Trigger management commands

Trigger management commands.


### Create a trigger

Create a new trigger for a specified function.

**Usage:**

```
scw function trigger create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required | Name of the trigger |
| function-id | Required | ID of the function to trigger |
| description |  | Description of the trigger |
| scw-sqs-config.queue |  | Name of the SQS queue the trigger should listen to |
| scw-sqs-config.mnq-project-id |  | ID of the Messaging and Queuing project |
| scw-sqs-config.mnq-region |  | Region in which the Messaging and Queuing project is activated. |
| scw-nats-config.subject |  | Name of the NATS subject the trigger should listen to |
| scw-nats-config.mnq-nats-account-id |  | ID of the Messaging and Queuing NATS account |
| scw-nats-config.mnq-project-id |  | ID of the Messaging and Queuing project |
| scw-nats-config.mnq-region |  | Region in which the Messaging and Queuing project is activated. |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Delete a trigger

Delete a trigger with a specified ID.

**Usage:**

```
scw function trigger delete <trigger-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| trigger-id | Required | ID of the trigger to delete |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### Get a trigger

Get a trigger with a specified ID.

**Usage:**

```
scw function trigger get <trigger-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| trigger-id | Required | ID of the trigger to get |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



### List all triggers

List all triggers belonging to a specified Organization or Project.

**Usage:**

```
scw function trigger list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc` | Order in which to return results |
| function-id |  | ID of the function the triggers belongs to |
| namespace-id |  | ID of the namespace the triggers belongs to |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw`, `all` | Region to target. If none is passed will use default region from the config |



### Update a trigger

Update a trigger with a specified ID.

**Usage:**

```
scw function trigger update <trigger-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| trigger-id | Required | ID of the trigger to update |
| name |  | Name of the trigger |
| description |  | Description of the trigger |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams`, `pl-waw` | Region to target. If none is passed will use default region from the config |



