<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw object`
Object-storage utils
  
- [Manage configuration files for popular S3 tools](#manage-configuration-files-for-popular-s3-tools)
  - [Generate a S3 tool configuration file](#generate-a-s3-tool-configuration-file)
  - [Install a S3 tool configuration file to its default location](#install-a-s3-tool-configuration-file-to-its-default-location)

  
## Manage configuration files for popular S3 tools

Configuration generation for S3 tools.


### Generate a S3 tool configuration file

Generate a S3 tool configuration file.

**Usage:**

```
scw object config get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| type | Required<br />One of: `rclone`, `s3cmd`, `mc` | Type of S3 tool you want to generate a config for |
| name | Default: `scaleway` | Name of the s3 remote you want to generate |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Generate a s3cmd config file for Paris region
```
scw object config get region=fr-par type=s3cmd
```

Generate a rclone config file for default region
```
scw object config get type=rclone
```

Generate a mc (minio) config file for default region
```
scw object config get type=mc
```




### Install a S3 tool configuration file to its default location

Install a S3 tool configuration file to its default location.

**Usage:**

```
scw object config install [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| type | Required<br />One of: `rclone`, `s3cmd`, `mc` | Type of S3 tool you want to generate a config for |
| name | Default: `scaleway` | Name of the s3 remote you want to generate |
| region | Default: `fr-par`<br />One of: `fr-par`, `nl-ams` | Region to target. If none is passed will use default region from the config |


**Examples:**


Install a s3cmd config file for Paris region
```
scw object config install region=fr-par type=s3cmd
```

Install a rclone config file for default region
```
scw object config install type=rclone
```

Install a mc (minio) config file for default region
```
scw object config install type=mc
```




