<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw cockpit`
Cockpit API.
  
- [Managed alerts management commands](#managed-alerts-management-commands)
  - [Disable the sending of managed alerts for a given Cockpit, specified by the ID of the Project the Cockpit belongs to](#disable-the-sending-of-managed-alerts-for-a-given-cockpit,-specified-by-the-id-of-the-project-the-cockpit-belongs-to)
  - [Enable the sending of managed alerts for a given Cockpit, specified by the ID of the Project the Cockpit belongs to](#enable-the-sending-of-managed-alerts-for-a-given-cockpit,-specified-by-the-id-of-the-project-the-cockpit-belongs-to)
  - [Send a test alert to make sure your contact points get notified when an actual alert is triggered](#send-a-test-alert-to-make-sure-your-contact-points-get-notified-when-an-actual-alert-is-triggered)
- [Cockpit management commands](#cockpit-management-commands)
  - [Activate the Cockpit of a given Project specified by the Project ID](#activate-the-cockpit-of-a-given-project-specified-by-the-project-id)
  - [Deactivate the Cockpit of a given Project specified by the Project ID](#deactivate-the-cockpit-of-a-given-project-specified-by-the-project-id)
  - [Retrieve the Cockpit of a given Project specified by the Project ID](#retrieve-the-cockpit-of-a-given-project-specified-by-the-project-id)
  - [Wait for a cockpit to reach a stable state (installation)](#wait-for-a-cockpit-to-reach-a-stable-state-(installation))
- [Contacts management commands](#contacts-management-commands)
  - [Create a contact point associated with the default receiver, to receive alerts](#create-a-contact-point-associated-with-the-default-receiver,-to-receive-alerts)
  - [Delete a contact point associated with the default receiver](#delete-a-contact-point-associated-with-the-default-receiver)
  - [Get a list of contact points created for a given Cockpit, specified by the ID of the Project the Cockpit belongs to](#get-a-list-of-contact-points-created-for-a-given-cockpit,-specified-by-the-id-of-the-project-the-cockpit-belongs-to)
- [Datasource management commands](#datasource-management-commands)
- [Grafana user management commands](#grafana-user-management-commands)
  - [Create a Grafana user for your Cockpit's Grafana. Make sure you save the automatically-generated password and the Grafana user ID](#create-a-grafana-user-for-your-cockpit's-grafana.-make-sure-you-save-the-automatically-generated-password-and-the-grafana-user-id)
  - [Delete a Grafana user from your Cockpit's Grafana, specified by the ID of the Project the Cockpit belongs to, and the ID of the Grafana user](#delete-a-grafana-user-from-your-cockpit's-grafana,-specified-by-the-id-of-the-project-the-cockpit-belongs-to,-and-the-id-of-the-grafana-user)
  - [Get a list of all Grafana users created in your Cockpit's Grafana](#get-a-list-of-all-grafana-users-created-in-your-cockpit's-grafana)
  - [Reset the password of a Grafana user, specified by the ID of the Project the Cockpit belongs to, and the ID of the Grafana user](#reset-the-password-of-a-grafana-user,-specified-by-the-id-of-the-project-the-cockpit-belongs-to,-and-the-id-of-the-grafana-user)
- [Pricing plans management commands](#pricing-plans-management-commands)
  - [Get a list of all pricing plans available](#get-a-list-of-all-pricing-plans-available)
  - [Select your chosen pricing plan for your Cockpit, specifying the Cockpit's Project ID and the pricing plan's ID in the request](#select-your-chosen-pricing-plan-for-your-cockpit,-specifying-the-cockpit's-project-id-and-the-pricing-plan's-id-in-the-request)
- [Product dashboards management commands](#product-dashboards-management-commands)
- [Token management commands](#token-management-commands)
  - [Create a token in a given Project specified by the Project ID](#create-a-token-in-a-given-project-specified-by-the-project-id)
  - [Delete a given token specified by the token ID](#delete-a-given-token-specified-by-the-token-id)
  - [Retrieve a given token specified by the token ID](#retrieve-a-given-token-specified-by-the-token-id)
  - [Get a list of tokens in a given Project specified by the Project ID](#get-a-list-of-tokens-in-a-given-project-specified-by-the-project-id)

  
## Managed alerts management commands

Managed alerts management commands.


### Disable the sending of managed alerts for a given Cockpit, specified by the ID of the Project the Cockpit belongs to

Disable the sending of managed alerts for a given Cockpit, specified by the ID of the Project the Cockpit belongs to.

**Usage:**

```
scw cockpit alert disable [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Enable the sending of managed alerts for a given Cockpit, specified by the ID of the Project the Cockpit belongs to

Enable the sending of managed alerts for a given Cockpit, specified by the ID of the Project the Cockpit belongs to.

**Usage:**

```
scw cockpit alert enable [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Send a test alert to make sure your contact points get notified when an actual alert is triggered

Send a test alert to make sure your contact points get notified when an actual alert is triggered.

**Usage:**

```
scw cockpit alert test [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



## Cockpit management commands

Cockpit management commands.


### Activate the Cockpit of a given Project specified by the Project ID

Activate the Cockpit of a given Project specified by the Project ID.

**Usage:**

```
scw cockpit cockpit activate [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Deactivate the Cockpit of a given Project specified by the Project ID

Deactivate the Cockpit of a given Project specified by the Project ID.

**Usage:**

```
scw cockpit cockpit deactivate [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Retrieve the Cockpit of a given Project specified by the Project ID

Retrieve the Cockpit of a given Project specified by the Project ID.

**Usage:**

```
scw cockpit cockpit get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Wait for a cockpit to reach a stable state (installation)

Wait for a cockpit to reach a stable state. This is similar to using --wait flag on other action commands, but without requiring a new action on the cockpit.

**Usage:**

```
scw cockpit cockpit wait <project-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id | Required | The ID of the project the cockpit is attached to |
| timeout | Default: `3m0s` | Timeout of the wait |


**Examples:**


Wait for a cockpit to reach a stable state
```
scw cockpit cockpit wait 11111111-1111-1111-1111-111111111111
```




## Contacts management commands

Contacts management commands.


### Create a contact point associated with the default receiver, to receive alerts

Create a contact point associated with the default receiver, to receive alerts.

**Usage:**

```
scw cockpit contact create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| contact-point.email.to |  |  |



### Delete a contact point associated with the default receiver

Delete a contact point associated with the default receiver.

**Usage:**

```
scw cockpit contact delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| contact-point.email.to |  |  |



### Get a list of contact points created for a given Cockpit, specified by the ID of the Project the Cockpit belongs to

Get a list of contact points created for a given Cockpit, specified by the ID of the Project the Cockpit belongs to.

**Usage:**

```
scw cockpit contact list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



## Datasource management commands

Datasource management commands.

Datasource management commands.

**Usage:**

```
scw cockpit datasource
```



## Grafana user management commands

Grafana user management commands.


### Create a Grafana user for your Cockpit's Grafana. Make sure you save the automatically-generated password and the Grafana user ID

Create a Grafana user for your Cockpit's Grafana. Make sure you save the automatically-generated password and the Grafana user ID.

**Usage:**

```
scw cockpit grafana-user create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| login |  | Username of the Grafana user |
| role | One of: `unknown_role`, `editor`, `viewer` | Role assigned to the Grafana user |



### Delete a Grafana user from your Cockpit's Grafana, specified by the ID of the Project the Cockpit belongs to, and the ID of the Grafana user

Delete a Grafana user from your Cockpit's Grafana, specified by the ID of the Project the Cockpit belongs to, and the ID of the Grafana user.

**Usage:**

```
scw cockpit grafana-user delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| grafana-user-id | Required | ID of the Grafana user |



### Get a list of all Grafana users created in your Cockpit's Grafana

Get a list of all Grafana users created in your Cockpit's Grafana.

**Usage:**

```
scw cockpit grafana-user list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `login_asc`, `login_desc` |  |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Reset the password of a Grafana user, specified by the ID of the Project the Cockpit belongs to, and the ID of the Grafana user

Reset the password of a Grafana user, specified by the ID of the Project the Cockpit belongs to, and the ID of the Grafana user.

**Usage:**

```
scw cockpit grafana-user reset-password [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| grafana-user-id | Required | ID of the Grafana user |



## Pricing plans management commands

Pricing plans management commands.


### Get a list of all pricing plans available

Get a list of all pricing plans available.

**Usage:**

```
scw cockpit plan list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `name_asc`, `name_desc` |  |



### Select your chosen pricing plan for your Cockpit, specifying the Cockpit's Project ID and the pricing plan's ID in the request

Select your chosen pricing plan for your Cockpit, specifying the Cockpit's Project ID and the pricing plan's ID in the request.

**Usage:**

```
scw cockpit plan select [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| plan-id |  | ID of the pricing plan |



## Product dashboards management commands

Product dashboards management commands.

Product dashboards management commands.

**Usage:**

```
scw cockpit product-dashboards
```



## Token management commands

Token management commands.


### Create a token in a given Project specified by the Project ID

Create a token in a given Project specified by the Project ID.

**Usage:**

```
scw cockpit token create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name | Default: `<generated>` | Name of the token |
| scopes.query-metrics |  | Permission to fetch metrics |
| scopes.write-metrics |  | Permission to write metrics |
| scopes.setup-metrics-rules |  | Permission to setup metrics rules |
| scopes.query-logs |  | Permission to fetch logs |
| scopes.write-logs |  | Permission to write logs |
| scopes.setup-logs-rules |  | Permission to set up logs rules |
| scopes.setup-alerts |  | Permission to set up alerts |
| scopes.query-traces |  | Permission to fetch traces |
| scopes.write-traces |  | Permission to write traces |



### Delete a given token specified by the token ID

Delete a given token specified by the token ID.

**Usage:**

```
scw cockpit token delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| token-id | Required | ID of the token |



### Retrieve a given token specified by the token ID

Retrieve a given token specified by the token ID.

**Usage:**

```
scw cockpit token get <token-id ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| token-id | Required | ID of the token |



### Get a list of tokens in a given Project specified by the Project ID

Get a list of tokens in a given Project specified by the Project ID.

**Usage:**

```
scw cockpit token list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | How the response is ordered |
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



